/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_atsc_fpll = R"doc(ATSC Receiver FPLL.

This block is takes in a complex I/Q baseband stream from the receive filter and outputs the 8-level symbol stream.


It does this by first locally generating a pilot tone and complex mixing with the input signal. This results in the pilot tone shifting to DC and places the signal in the upper sideband.


As no information is encoded in the phase of the waveform, the Q channel is then discarded, producing a real signal with the lower sideband restored.


The 8-level symbol stream still has a DC offset, and still requires symbol timing recovery.

Constructor Specific Documentation:

Make a new instance of gr::dtv::atsc_fpll.

param rate Sample rate of incoming stream

Args:
    rate : )doc";


static const char* __doc_gr_dtv_atsc_fpll_atsc_fpll = R"doc()doc";


static const char* __doc_gr_dtv_atsc_fpll_make = R"doc(ATSC Receiver FPLL.

This block is takes in a complex I/Q baseband stream from the receive filter and outputs the 8-level symbol stream.


It does this by first locally generating a pilot tone and complex mixing with the input signal. This results in the pilot tone shifting to DC and places the signal in the upper sideband.


As no information is encoded in the phase of the waveform, the Q channel is then discarded, producing a real signal with the lower sideband restored.


The 8-level symbol stream still has a DC offset, and still requires symbol timing recovery.

Constructor Specific Documentation:

Make a new instance of gr::dtv::atsc_fpll.

param rate Sample rate of incoming stream

Args:
    rate : )doc";
