
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in CurveConstraintPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of CurveConstraintPy
PyTypeObject CurveConstraintPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.GeomPlate.CurveConstraintPy",     /*tp_name*/
    sizeof(CurveConstraintPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Defines curves as constraints to be used to deform a surface",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::CurveConstraintPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::CurveConstraintPy::GetterSetter,                     /*tp_getset */
    &Base::PyObjectBase::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::CurveConstraintPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of CurveConstraintPy
PyMethodDef CurveConstraintPy::Methods[] = {
    {"setOrder",
        reinterpret_cast<PyCFunction>( staticCallback_setOrder ),
        METH_VARARGS,
        "Allows you to set the order of continuity required for\n"
        "the constraints: G0, G1, and G2, controlled\n"
        "respectively by G0Criterion G1Criterion and G2Criterion."
    },
    {"order",
        reinterpret_cast<PyCFunction>( staticCallback_order ),
        METH_VARARGS,
        "Returns the order of constraint, one of G0, G1 or G2"
    },
    {"G0Criterion",
        reinterpret_cast<PyCFunction>( staticCallback_G0Criterion ),
        METH_VARARGS,
        "Returns the G0 criterion at the parametric point U on\n"
        "the curve. This is the greatest distance allowed between\n"
        "the constraint and the target surface at U."
    },
    {"G1Criterion",
        reinterpret_cast<PyCFunction>( staticCallback_G1Criterion ),
        METH_VARARGS,
        "Returns the G1 criterion at the parametric point U on\n"
        "the curve. This is the greatest angle allowed between\n"
        "the constraint and the target surface at U.\n"
        "Raises an exception if  the  curve  is  not  on  a  surface."
    },
    {"G2Criterion",
        reinterpret_cast<PyCFunction>( staticCallback_G2Criterion ),
        METH_VARARGS,
        "Returns the G2 criterion at the parametric point U on\n"
        "the curve. This is the greatest difference in curvature\n"
        "allowed between the constraint and the target surface at U.\n"
        "Raises an exception if  the  curve  is  not  on  a  surface."
    },
    {"setG0Criterion",
        reinterpret_cast<PyCFunction>( staticCallback_setG0Criterion ),
        METH_VARARGS,
        "Allows you to set the G0 criterion. This is the law\n"
        "defining the greatest distance allowed between the\n"
        "constraint and the target surface for each point of the\n"
        "constraint. If this criterion is not set, TolDist, the\n"
        "distance tolerance from the constructor, is used."
    },
    {"setG1Criterion",
        reinterpret_cast<PyCFunction>( staticCallback_setG1Criterion ),
        METH_VARARGS,
        "Allows you to set the G1 criterion. This is the law\n"
        "defining the greatest angle allowed between the\n"
        "constraint and the target surface. If this criterion is not\n"
        "set, TolAng, the angular tolerance from the constructor, is used.\n"
        "Raises an exception if  the  curve  is  not  on  a  surface"
    },
    {"setG2Criterion",
        reinterpret_cast<PyCFunction>( staticCallback_setG2Criterion ),
        METH_VARARGS,
        "Allows you to set the G2 criterion. This is the law\n"
        " defining the greatest difference in curvature allowed\n"
        " between the constraint and the target surface. If this\n"
        " criterion is not set, TolCurv, the curvature tolerance from\n"
        " the constructor, is used.\n"
        " Raises   ConstructionError if  the  point  is  not  on  the  surface"
    },
    {"curve3d",
        reinterpret_cast<PyCFunction>( staticCallback_curve3d ),
        METH_VARARGS,
        "Returns a 3d curve associated the surface resulting of the constraints"
    },
    {"setCurve2dOnSurf",
        reinterpret_cast<PyCFunction>( staticCallback_setCurve2dOnSurf ),
        METH_VARARGS,
        "loads a 2d curve associated the surface resulting of the constraints"
    },
    {"curve2dOnSurf",
        reinterpret_cast<PyCFunction>( staticCallback_curve2dOnSurf ),
        METH_VARARGS,
        "Returns a 2d curve associated the surface resulting of the constraints"
    },
    {"setProjectedCurve",
        reinterpret_cast<PyCFunction>( staticCallback_setProjectedCurve ),
        METH_VARARGS,
        "loads a 2d curve  resulting from the normal projection of\n"
        " the curve on the initial surface"
    },
    {"projectedCurve",
        reinterpret_cast<PyCFunction>( staticCallback_projectedCurve ),
        METH_VARARGS,
        "Returns the projected curve resulting from the normal projection of the\n"
        " curve on the initial surface"
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of CurveConstraintPy
PyGetSetDef CurveConstraintPy::GetterSetter[] = {
    {"NbPoints",
        (getter) staticCallback_getNbPoints,
        (setter) staticCallback_setNbPoints,
        "The number of points on the curve used as a\n"
        "constraint. The default setting is 10. This parameter\n"
        "affects computation time, which increases by the cube of\n"
        "the number of points.",
        nullptr
    },
    {"FirstParameter",
        (getter) staticCallback_getFirstParameter,
        (setter) staticCallback_setFirstParameter,
        "This function returns the first parameter of the curve.\n"
        "The first parameter is the lowest parametric value for the curve, which defines the starting point of the curve.",
        nullptr
    },
    {"LastParameter",
        (getter) staticCallback_getLastParameter,
        (setter) staticCallback_setLastParameter,
        "This function returns the last parameter of the curve.\n"
        "The last parameter is the highest parametric value for the curve, which defines the ending point of the curve.",
        nullptr
    },
    {"Length",
        (getter) staticCallback_getLength,
        (setter) staticCallback_setLength,
        "This function returns the length of the curve.\n"
        "The length of the curve is a geometric property that indicates how long the curve is in the space.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// setOrder() callback and implementer
// PyObject*  CurveConstraintPy::setOrder(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_setOrder (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setOrder' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->setOrder(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// order() callback and implementer
// PyObject*  CurveConstraintPy::order(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_order (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'order' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->order(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// G0Criterion() callback and implementer
// PyObject*  CurveConstraintPy::G0Criterion(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_G0Criterion (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'G0Criterion' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->G0Criterion(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// G1Criterion() callback and implementer
// PyObject*  CurveConstraintPy::G1Criterion(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_G1Criterion (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'G1Criterion' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->G1Criterion(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// G2Criterion() callback and implementer
// PyObject*  CurveConstraintPy::G2Criterion(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_G2Criterion (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'G2Criterion' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->G2Criterion(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setG0Criterion() callback and implementer
// PyObject*  CurveConstraintPy::setG0Criterion(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_setG0Criterion (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setG0Criterion' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->setG0Criterion(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setG1Criterion() callback and implementer
// PyObject*  CurveConstraintPy::setG1Criterion(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_setG1Criterion (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setG1Criterion' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->setG1Criterion(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setG2Criterion() callback and implementer
// PyObject*  CurveConstraintPy::setG2Criterion(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_setG2Criterion (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setG2Criterion' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->setG2Criterion(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// curve3d() callback and implementer
// PyObject*  CurveConstraintPy::curve3d(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_curve3d (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'curve3d' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->curve3d(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setCurve2dOnSurf() callback and implementer
// PyObject*  CurveConstraintPy::setCurve2dOnSurf(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_setCurve2dOnSurf (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setCurve2dOnSurf' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->setCurve2dOnSurf(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// curve2dOnSurf() callback and implementer
// PyObject*  CurveConstraintPy::curve2dOnSurf(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_curve2dOnSurf (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'curve2dOnSurf' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->curve2dOnSurf(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setProjectedCurve() callback and implementer
// PyObject*  CurveConstraintPy::setProjectedCurve(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_setProjectedCurve (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setProjectedCurve' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->setProjectedCurve(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// projectedCurve() callback and implementer
// PyObject*  CurveConstraintPy::projectedCurve(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_projectedCurve (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'projectedCurve' of 'Part.GeomPlate_CurveConstraint' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<CurveConstraintPy*>(self)->projectedCurve(args);
        if (ret != nullptr)
            static_cast<CurveConstraintPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// NbPoints() callback and implementer
// PyObject*  CurveConstraintPy::NbPoints(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_getNbPoints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<CurveConstraintPy*>(self)->getNbPoints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'NbPoints' of object 'GeomPlate_CurveConstraint'");
        return nullptr;
    }
}

int CurveConstraintPy::staticCallback_setNbPoints (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<CurveConstraintPy*>(self)->setNbPoints(Py::Long(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'NbPoints' of object 'GeomPlate_CurveConstraint'");
        return -1;
    }
}

// FirstParameter() callback and implementer
// PyObject*  CurveConstraintPy::FirstParameter(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_getFirstParameter (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<CurveConstraintPy*>(self)->getFirstParameter());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'FirstParameter' of object 'GeomPlate_CurveConstraint'");
        return nullptr;
    }
}

int CurveConstraintPy::staticCallback_setFirstParameter (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'FirstParameter' of object 'GeomPlate_CurveConstraint' is read-only");
    return -1;
}

// LastParameter() callback and implementer
// PyObject*  CurveConstraintPy::LastParameter(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_getLastParameter (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<CurveConstraintPy*>(self)->getLastParameter());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'LastParameter' of object 'GeomPlate_CurveConstraint'");
        return nullptr;
    }
}

int CurveConstraintPy::staticCallback_setLastParameter (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'LastParameter' of object 'GeomPlate_CurveConstraint' is read-only");
    return -1;
}

// Length() callback and implementer
// PyObject*  CurveConstraintPy::Length(PyObject *args){};
// has to be implemented in CurveConstraintPyImp.cpp
PyObject * CurveConstraintPy::staticCallback_getLength (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<CurveConstraintPy*>(self)->getLength());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Length' of object 'GeomPlate_CurveConstraint'");
        return nullptr;
    }
}

int CurveConstraintPy::staticCallback_setLength (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Length' of object 'GeomPlate_CurveConstraint' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
CurveConstraintPy::CurveConstraintPy(GeomPlate_CurveConstraint *pcObject, PyTypeObject *T)
    : PyObjectBase(static_cast<PyObjectBase::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
CurveConstraintPy::~CurveConstraintPy()                                // Everything handled in parent
{
    // delete the handled object when the PyObject dies
    CurveConstraintPy::PointerType ptr = static_cast<CurveConstraintPy::PointerType>(_pcTwinPointer);
    delete ptr;
}

//--------------------------------------------------------------------------
// CurveConstraintPy representation
//--------------------------------------------------------------------------
PyObject *CurveConstraintPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// CurveConstraintPy Attributes
//--------------------------------------------------------------------------
PyObject *CurveConstraintPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return PyObjectBase::_getattr(attr);
}

int CurveConstraintPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return PyObjectBase::_setattr(attr, value);
}

GeomPlate_CurveConstraint *CurveConstraintPy::getGeomPlate_CurveConstraintPtr() const
{
    return static_cast<GeomPlate_CurveConstraint *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in CurveConstraintPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *CurveConstraintPy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of CurveConstraintPy and the Twin object
    return new CurveConstraintPy(new GeomPlate_CurveConstraint);
}

// constructor method
int CurveConstraintPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string CurveConstraintPy::representation() const
{
    return {"<GeomPlate_CurveConstraint object>"};
}

PyObject* CurveConstraintPy::setOrder(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::order(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::G0Criterion(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::G1Criterion(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::G2Criterion(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::setG0Criterion(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::setG1Criterion(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::setG2Criterion(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::curve3d(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::setCurve2dOnSurf(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::curve2dOnSurf(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::setProjectedCurve(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* CurveConstraintPy::projectedCurve(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::Long CurveConstraintPy::getNbPoints() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

void  CurveConstraintPy::setNbPoints(Py::Long arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float CurveConstraintPy::getFirstParameter() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float CurveConstraintPy::getLastParameter() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float CurveConstraintPy::getLength() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *CurveConstraintPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int CurveConstraintPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



