/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLCanvasElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "InspectorCanvasCallTracer.h"
#include "JSBlobCallback.h"
#include "JSCanvasRenderingContext2D.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUCanvasContext.h"
#include "JSImageBitmapRenderingContext.h"
#include "JSWebGL2RenderingContext.h"
#include "JSWebGLRenderingContext.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

#if ENABLE(MEDIA_STREAM)
#include "JSMediaStream.h"
#endif

#if ENABLE(OFFSCREEN_CANVAS)
#include "JSOffscreenCanvas.h"
#endif

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsHTMLCanvasElementPrototypeFunction_getContext);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLCanvasElementPrototypeFunction_toDataURL);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLCanvasElementPrototypeFunction_toBlob);
#if ENABLE(OFFSCREEN_CANVAS)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLCanvasElementPrototypeFunction_transferControlToOffscreen);
#endif
#if ENABLE(MEDIA_STREAM)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLCanvasElementPrototypeFunction_captureStream);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHTMLCanvasElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLCanvasElement_width);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLCanvasElement_width);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLCanvasElement_height);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLCanvasElement_height);

class JSHTMLCanvasElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLCanvasElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLCanvasElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLCanvasElementPrototype>(vm)) JSHTMLCanvasElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLCanvasElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLCanvasElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLCanvasElementPrototype, JSHTMLCanvasElementPrototype::Base);

using JSHTMLCanvasElementDOMConstructor = JSDOMConstructorNotConstructable<JSHTMLCanvasElement>;

template<> const ClassInfo JSHTMLCanvasElementDOMConstructor::s_info = { "HTMLCanvasElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLCanvasElementDOMConstructor) };

template<> JSValue JSHTMLCanvasElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLCanvasElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "HTMLCanvasElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLCanvasElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 8> JSHTMLCanvasElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLCanvasElementConstructor, 0 } },
    HashTableValue { "width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLCanvasElement_width, setJSHTMLCanvasElement_width } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLCanvasElement_height, setJSHTMLCanvasElement_height } },
    HashTableValue { "getContext"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLCanvasElementPrototypeFunction_getContext, 1 } },
    HashTableValue { "toDataURL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLCanvasElementPrototypeFunction_toDataURL, 0 } },
    HashTableValue { "toBlob"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLCanvasElementPrototypeFunction_toBlob, 1 } },
#if ENABLE(OFFSCREEN_CANVAS)
    HashTableValue { "transferControlToOffscreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLCanvasElementPrototypeFunction_transferControlToOffscreen, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STREAM)
    HashTableValue { "captureStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLCanvasElementPrototypeFunction_captureStream, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

const ClassInfo JSHTMLCanvasElementPrototype::s_info = { "HTMLCanvasElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLCanvasElementPrototype) };

void JSHTMLCanvasElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLCanvasElement::info(), JSHTMLCanvasElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(OFFSCREEN_CANVAS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().offscreenCanvasEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "transferControlToOffscreen"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHTMLCanvasElement::s_info = { "HTMLCanvasElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLCanvasElement) };

JSHTMLCanvasElement::JSHTMLCanvasElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLCanvasElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

Ref<HTMLCanvasElement> JSHTMLCanvasElement::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, HTMLCanvasElement>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

void JSHTMLCanvasElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(info()));

    vm.heap.reportExtraMemoryAllocated(this, wrapped().memoryCost());
}

JSObject* JSHTMLCanvasElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHTMLCanvasElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSHTMLCanvasElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHTMLCanvasElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLCanvasElement>(vm, globalObject);
}

JSValue JSHTMLCanvasElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLCanvasElementDOMConstructor, DOMConstructorID::HTMLCanvasElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLCanvasElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLCanvasElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLCanvasElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsHTMLCanvasElement_widthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLCanvasElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "width"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLCanvasElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLCanvasElement>::get<jsHTMLCanvasElement_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLCanvasElement_widthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLCanvasElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "width"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setWidth(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLCanvasElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLCanvasElement>::set<setJSHTMLCanvasElement_widthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLCanvasElement_heightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLCanvasElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "height"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLCanvasElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLCanvasElement>::get<jsHTMLCanvasElement_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLCanvasElement_heightSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLCanvasElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "height"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setHeight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLCanvasElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLCanvasElement>::set<setJSHTMLCanvasElement_heightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsHTMLCanvasElementPrototypeFunction_getContextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLCanvasElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto contextIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (contextIdConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto arguments = convertVariadicArguments<IDLAny>(*lexicalGlobalObject, *callFrame, 1);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLUnion<IDLInterface<WebGLRenderingContext>, IDLInterface<WebGL2RenderingContext>, IDLInterface<GPUCanvasContext>, IDLInterface<ImageBitmapRenderingContext>, IDLInterface<CanvasRenderingContext2D>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getContext(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), contextIdConversionResult.releaseReturnValue(), WTFMove(arguments)))));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLCanvasElementPrototypeFunction_getContext, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLCanvasElement>::call<jsHTMLCanvasElementPrototypeFunction_getContextBody>(*lexicalGlobalObject, *callFrame, "getContext");
}

static inline JSC::EncodedJSValue jsHTMLCanvasElementPrototypeFunction_toDataURLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLCanvasElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto typeConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLDOMString> { return typename Converter<IDLDOMString>::ReturnType { String() }; });
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto qualityConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument1.value());
    if (qualityConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.toDataURL(typeConversionResult.releaseReturnValue(), qualityConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLCanvasElementPrototypeFunction_toDataURL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLCanvasElement>::call<jsHTMLCanvasElementPrototypeFunction_toDataURLBody>(*lexicalGlobalObject, *callFrame, "toDataURL");
}

static inline JSC::EncodedJSValue jsHTMLCanvasElementPrototypeFunction_toBlobBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLCanvasElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callbackConversionResult = convert<IDLCallbackFunction<JSBlobCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback"_s, "HTMLCanvasElement"_s, "toBlob"_s); });
    if (callbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto typeConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLDOMString> { return typename Converter<IDLDOMString>::ReturnType { String() }; });
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto qualityConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument2.value());
    if (qualityConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.toBlob(callbackConversionResult.releaseReturnValue(), typeConversionResult.releaseReturnValue(), qualityConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLCanvasElementPrototypeFunction_toBlob, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLCanvasElement>::call<jsHTMLCanvasElementPrototypeFunction_toBlobBody>(*lexicalGlobalObject, *callFrame, "toBlob");
}

#if ENABLE(OFFSCREEN_CANVAS)
static inline JSC::EncodedJSValue jsHTMLCanvasElementPrototypeFunction_transferControlToOffscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLCanvasElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<OffscreenCanvas>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.transferControlToOffscreen())));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLCanvasElementPrototypeFunction_transferControlToOffscreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLCanvasElement>::call<jsHTMLCanvasElementPrototypeFunction_transferControlToOffscreenBody>(*lexicalGlobalObject, *callFrame, "transferControlToOffscreen");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsHTMLCanvasElementPrototypeFunction_captureStreamBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLCanvasElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto frameRequestRateConversionResult = convert<IDLOptional<IDLDouble>>(*lexicalGlobalObject, argument0.value());
    if (frameRequestRateConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<MediaStream>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.captureStream(frameRequestRateConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLCanvasElementPrototypeFunction_captureStream, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLCanvasElement>::call<jsHTMLCanvasElementPrototypeFunction_captureStreamBody>(*lexicalGlobalObject, *callFrame, "captureStream");
}

#endif

JSC::GCClient::IsoSubspace* JSHTMLCanvasElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHTMLCanvasElement, UseCustomHeapCellType::No>(vm, "JSHTMLCanvasElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHTMLCanvasElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHTMLCanvasElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHTMLCanvasElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHTMLCanvasElement = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSHTMLCanvasElement::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLCanvasElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
    visitor.reportExtraMemoryVisited(thisObject->wrapped().memoryCost());
#if ENABLE(RESOURCE_USAGE)
    visitor.reportExternalMemoryVisited(thisObject->wrapped().externalMemoryCost());
#endif
}

DEFINE_VISIT_CHILDREN(JSHTMLCanvasElement);

template<typename Visitor>
void JSHTMLCanvasElement::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLCanvasElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSHTMLCanvasElement::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSHTMLCanvasElement::visitOutputConstraints(JSCell*, SlotVisitor&);
size_t JSHTMLCanvasElement::estimatedSize(JSCell* cell, VM& vm)
{
    auto* thisObject = jsCast<JSHTMLCanvasElement*>(cell);
    return Base::estimatedSize(thisObject, vm) + thisObject->wrapped().memoryCost();
}

void JSHTMLCanvasElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLCanvasElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSHTMLCanvasElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsHTMLCanvasElement = jsCast<JSHTMLCanvasElement*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsHTMLCanvasElement->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor, reason))
        return true;
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSHTMLCanvasElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLCanvasElement = static_cast<JSHTMLCanvasElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsHTMLCanvasElement->protectedWrapped().ptr(), jsHTMLCanvasElement);
}

HTMLCanvasElement* JSHTMLCanvasElement::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLCanvasElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
