// java wrapper for vtkImageReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageReader2_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageReader",dType)) { return me; }
  if ((res= vtkImageReader2_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader_SetDataVOI_14(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataVOI(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader_SetDataVOI_15(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataVOI(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageReader_GetDataVOI_16(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataVOI();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReader_GetDataMask_17(JNIEnv* env, jobject obj)
{
   unsigned long long   temp20;

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataMask();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader_SetDataMask_18(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long long   temp0;
  temp0 = id0;

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataMask(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader_SetTransform_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform * temp0;
  temp0 = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReader_GetTransform_110(JNIEnv* env, jobject obj)
{
  vtkTransform * temp20;

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader_ComputeInverseTransformedExtent_111(JNIEnv* env, jobject obj,jintArray id0,jintArray id1)
{
  int temp0[6];
  int temp1[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeInverseTransformedExtent(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->SetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader_ComputeInverseTransformedIncrements_112(JNIEnv* env, jobject obj,jlongArray id0,jlongArray id1)
{
  long long temp0[3];
  long long temp1[3];
  env->GetLongArrayRegion(id0, 0, 3, reinterpret_cast<jlong*>(&temp0[0]));
  env->GetLongArrayRegion(id1, 0, 3, reinterpret_cast<jlong*>(&temp1[0]));

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeInverseTransformedIncrements(temp0,temp1);
  env->SetLongArrayRegion(id0, 0, 3, reinterpret_cast<jlong*>(&temp0[0]));
  env->SetLongArrayRegion(id1, 0, 3, reinterpret_cast<jlong*>(&temp1[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader_OpenAndSeekFile_113(JNIEnv* env, jobject obj,jintArray id0,jint id1)
{
  int temp0[6];
  int   temp1;
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->OpenAndSeekFile(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader_SetScalarArrayName_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageReader_GetScalarArrayName_115(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader_CanReadFile_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader* op = static_cast<vtkImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageReader::New());
}
