// java wrapper for vtkHexahedron object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHexahedron.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkCell3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHexahedron_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHexahedron",dType)) { return me; }
  if ((res= vtkCell3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexahedron_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexahedron_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHexahedron_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHexahedron_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHexahedron_GetCentroid_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCentroid(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexahedron_GetCellType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexahedron_GetNumberOfEdges_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexahedron_GetNumberOfFaces_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHexahedron_GetEdge_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHexahedron_GetFace_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexahedron_CellBoundary_110(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHexahedron_Contour_111(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jobject id7,jobject id8,jlong id9,jobject id10)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkCellArray * temp4;
  vtkCellArray * temp5;
  vtkPointData * temp6;
  vtkPointData * temp7;
  vtkCellData * temp8;
  long long   temp9;
  vtkCellData * temp10;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id7));
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;
  temp10 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id10));

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->Contour(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHexahedron_TriangulateLocalIds_112(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHexahedron_InterpolationFunctions_113(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[8];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 8, &temp1[0]);

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolationFunctions(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 8, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHexahedron_InterpolationDerivs_114(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[24];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 24, &temp1[0]);

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolationDerivs(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 24, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHexahedron_InterpolateFunctions_115(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[8];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 8, &temp1[0]);

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateFunctions(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 8, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHexahedron_InterpolateDerivs_116(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[24];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 24, &temp1[0]);

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateDerivs(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 24, &temp1[0]);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexahedron_GetEdgeArray_117(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 2);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexahedron_GetFaceArray_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 4);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexahedron_GetEdgeToAdjacentFacesArray_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeToAdjacentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 2);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexahedron_GetFaceToAdjacentFacesArray_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceToAdjacentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 4);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexahedron_GetPointToIncidentEdgesArray_121(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToIncidentEdgesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexahedron_GetPointToIncidentFacesArray_122(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToIncidentFacesArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkHexahedron_GetPointToOneRingPointsArray_123(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const long long * temp20;
  temp0 = id0;

  vtkHexahedron* op = static_cast<vtkHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointToOneRingPointsArray(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<const jlong*>(temp20), 3);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkHexahedron_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkHexahedron::New());
}
