// java wrapper for vtkVersion object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVersion.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVersion_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVersion",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVersion_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVersion* op = static_cast<vtkVersion*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVersion_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVersion* op = static_cast<vtkVersion*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVersion_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVersion* op = static_cast<vtkVersion*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVersion_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVersion* op = static_cast<vtkVersion*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVersion_GetVTKVersion_14(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkVersion* op = static_cast<vtkVersion*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKVersion();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVersion_GetVTKVersionFull_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkVersion* op = static_cast<vtkVersion*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKVersionFull();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVersion_GetVTKMajorVersion_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVersion* op = static_cast<vtkVersion*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKMajorVersion();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVersion_GetVTKMinorVersion_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVersion* op = static_cast<vtkVersion*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKMinorVersion();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVersion_GetVTKBuildVersion_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVersion* op = static_cast<vtkVersion*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKBuildVersion();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVersion_GetVTKSourceVersion_19(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkVersion* op = static_cast<vtkVersion*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKSourceVersion();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkVersion_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkVersion::New());
}
