/** @file
 * VirtualBox API class wrapper code for IVFSExplorer.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_VFSEXPLORER

#include "VFSExplorerWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(VFSExplorerWrap)

//
// IVFSExplorer properties
//

STDMETHODIMP VFSExplorerWrap::COMGETTER(Path)(BSTR *aPath)
{
    LogRelFlow(("{%p} %s: enter aPath=%p\n", this, "VFSExplorer::getPath", aPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPath);
        BSTROutConverter TmpPath(aPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_GET_PATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPath(TmpPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_GET_PATH_RETURN(this, hrc, 0 /*normal*/,TmpPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_GET_PATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_GET_PATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPath=%ls hrc=%Rhrc\n", this, "VFSExplorer::getPath", *aPath, hrc));
    return hrc;
}

STDMETHODIMP VFSExplorerWrap::COMGETTER(Type)(VFSType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "VFSExplorer::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "VFSExplorer::getType", *aType, hrc));
    return hrc;
}


//
// IVFSExplorer methods
//

STDMETHODIMP VFSExplorerWrap::Update(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "VFSExplorer::update", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_UPDATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = update(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_UPDATE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_UPDATE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_UPDATE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "VFSExplorer::update", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP VFSExplorerWrap::Cd(IN_BSTR aDir,
                                 IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aDir=%ls aProgress=%p\n", this, "VFSExplorer::cd", aDir, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpDir(aDir);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_CD_ENTER(this, TmpDir.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = cd(TmpDir.str(),
                     TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_CD_RETURN(this, hrc, 0 /*normal*/, TmpDir.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_CD_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_CD_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "VFSExplorer::cd", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP VFSExplorerWrap::CdUp(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "VFSExplorer::cdUp", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_CDUP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = cdUp(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_CDUP_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_CDUP_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_CDUP_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "VFSExplorer::cdUp", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP VFSExplorerWrap::EntryList(ComSafeArrayOut(BSTR, aNames),
                                        ComSafeArrayOut(ULONG, aTypes),
                                        ComSafeArrayOut(LONG64, aSizes),
                                        ComSafeArrayOut(ULONG, aModes))
{
    LogRelFlow(("{%p} %s: enter aNames=%p aTypes=%p aSizes=%p aModes=%p\n", this, "VFSExplorer::entryList", aNames, aTypes, aSizes, aModes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNames);
        CheckComArgOutPointerValidThrow(aTypes);
        CheckComArgOutPointerValidThrow(aSizes);
        CheckComArgOutPointerValidThrow(aModes);


        ArrayBSTROutConverter TmpNames(ComSafeArrayOutArg(aNames));
        ArrayOutConverter<ULONG> TmpTypes(ComSafeArrayOutArg(aTypes));
        ArrayOutConverter<LONG64> TmpSizes(ComSafeArrayOutArg(aSizes));
        ArrayOutConverter<ULONG> TmpModes(ComSafeArrayOutArg(aModes));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_ENTRYLIST_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = entryList(TmpNames.array(),
                            TmpTypes.array(),
                            TmpSizes.array(),
                            TmpModes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_ENTRYLIST_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpTypes.array().size(), NULL /*for now*/, (uint32_t)TmpSizes.array().size(), NULL /*for now*/, (uint32_t)TmpModes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_ENTRYLIST_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_ENTRYLIST_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNames=%zu *aTypes=%zu *aSizes=%zu *aModes=%zu hrc=%Rhrc\n", this, "VFSExplorer::entryList", ComSafeArraySize(*aNames), ComSafeArraySize(*aTypes), ComSafeArraySize(*aSizes), ComSafeArraySize(*aModes), hrc));
    return hrc;
}

STDMETHODIMP VFSExplorerWrap::Exists(ComSafeArrayIn(IN_BSTR, aNames),
                                     ComSafeArrayOut(BSTR, aExists))
{
    LogRelFlow(("{%p} %s: enter aNames=%zu aExists=%p\n", this, "VFSExplorer::exists", aNames, aExists));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExists);


        ArrayBSTRInConverter TmpNames(ComSafeArrayInArg(aNames));
        ArrayBSTROutConverter TmpExists(ComSafeArrayOutArg(aExists));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_EXISTS_ENTER(this, (uint32_t)TmpNames.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = exists(TmpNames.array(),
                         TmpExists.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_EXISTS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpExists.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_EXISTS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_EXISTS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aExists=%zu hrc=%Rhrc\n", this, "VFSExplorer::exists", ComSafeArraySize(*aExists), hrc));
    return hrc;
}

STDMETHODIMP VFSExplorerWrap::Remove(ComSafeArrayIn(IN_BSTR, aNames),
                                     IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aNames=%zu aProgress=%p\n", this, "VFSExplorer::remove", aNames, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayBSTRInConverter TmpNames(ComSafeArrayInArg(aNames));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_REMOVE_ENTER(this, (uint32_t)TmpNames.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = remove(TmpNames.array(),
                         TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_REMOVE_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_REMOVE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VFSEXPLORER_REMOVE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "VFSExplorer::remove", *aProgress, hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(VFSExplorerWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(VFSExplorerWrap, IVFSExplorer)
#endif // VBOX_WITH_XPCOM
