/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v2beta1

import (
	v1 "k8s.io/api/core/v1"
	resource "k8s.io/apimachinery/pkg/api/resource"
)

// ResourceMetricSourceApplyConfiguration represents a declarative configuration of the ResourceMetricSource type for use
// with apply.
//
// ResourceMetricSource indicates how to scale on a resource metric known to
// Kubernetes, as specified in requests and limits, describing each pod in the
// current scale target (e.g. CPU or memory).  The values will be averaged
// together before being compared to the target.  Such metrics are built in to
// Kubernetes, and have special scaling options on top of those available to
// normal per-pod metrics using the "pods" source.  Only one "target" type
// should be set.
type ResourceMetricSourceApplyConfiguration struct {
	// name is the name of the resource in question.
	Name *v1.ResourceName `json:"name,omitempty"`
	// targetAverageUtilization is the target value of the average of the
	// resource metric across all relevant pods, represented as a percentage of
	// the requested value of the resource for the pods.
	TargetAverageUtilization *int32 `json:"targetAverageUtilization,omitempty"`
	// targetAverageValue is the target value of the average of the
	// resource metric across all relevant pods, as a raw value (instead of as
	// a percentage of the request), similar to the "pods" metric source type.
	TargetAverageValue *resource.Quantity `json:"targetAverageValue,omitempty"`
}

// ResourceMetricSourceApplyConfiguration constructs a declarative configuration of the ResourceMetricSource type for use with
// apply.
func ResourceMetricSource() *ResourceMetricSourceApplyConfiguration {
	return &ResourceMetricSourceApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ResourceMetricSourceApplyConfiguration) WithName(value v1.ResourceName) *ResourceMetricSourceApplyConfiguration {
	b.Name = &value
	return b
}

// WithTargetAverageUtilization sets the TargetAverageUtilization field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TargetAverageUtilization field is set to the value of the last call.
func (b *ResourceMetricSourceApplyConfiguration) WithTargetAverageUtilization(value int32) *ResourceMetricSourceApplyConfiguration {
	b.TargetAverageUtilization = &value
	return b
}

// WithTargetAverageValue sets the TargetAverageValue field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TargetAverageValue field is set to the value of the last call.
func (b *ResourceMetricSourceApplyConfiguration) WithTargetAverageValue(value resource.Quantity) *ResourceMetricSourceApplyConfiguration {
	b.TargetAverageValue = &value
	return b
}
