/* Sidebar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Sidebar.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2024 elementary, Inc. (https://elementary.io)
 */

#include "applications.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <adwaita.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	APPLICATIONS_SIDEBAR_0_PROPERTY,
	APPLICATIONS_SIDEBAR_STACK_PROPERTY,
	APPLICATIONS_SIDEBAR_NUM_PROPERTIES
};
static GParamSpec* applications_sidebar_properties[APPLICATIONS_SIDEBAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW (applications_sidebar_simple_sidebar_row_get_type ())
#define APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW, ApplicationsSidebarSimpleSidebarRow))
#define APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW, ApplicationsSidebarSimpleSidebarRowClass))
#define APPLICATIONS_SIDEBAR_IS_SIMPLE_SIDEBAR_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW))
#define APPLICATIONS_SIDEBAR_IS_SIMPLE_SIDEBAR_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW))
#define APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW, ApplicationsSidebarSimpleSidebarRowClass))

typedef struct _ApplicationsSidebarSimpleSidebarRow ApplicationsSidebarSimpleSidebarRow;
typedef struct _ApplicationsSidebarSimpleSidebarRowClass ApplicationsSidebarSimpleSidebarRowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ApplicationsSidebarSimpleSidebarRowPrivate ApplicationsSidebarSimpleSidebarRowPrivate;
enum  {
	APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_0_PROPERTY,
	APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_LABEL_PROPERTY,
	APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_ICON_NAME_PROPERTY,
	APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_NUM_PROPERTIES
};
static GParamSpec* applications_sidebar_simple_sidebar_row_properties[APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_NUM_PROPERTIES];
typedef struct _Block1Data Block1Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _ApplicationsSidebarPrivate {
	GtkStack* _stack;
	GtkSearchEntry* search_entry;
};

struct _ApplicationsSidebarSimpleSidebarRow {
	GtkListBoxRow parent_instance;
	ApplicationsSidebarSimpleSidebarRowPrivate * priv;
};

struct _ApplicationsSidebarSimpleSidebarRowClass {
	GtkListBoxRowClass parent_class;
};

struct _ApplicationsSidebarSimpleSidebarRowPrivate {
	gchar* _label;
	gchar* _icon_name;
};

struct _Block1Data {
	int _ref_count_;
	ApplicationsSidebar* self;
	GtkRevealer* search_revealer;
	GtkListBox* listbox;
	GSimpleAction* search_action;
};

static gint ApplicationsSidebar_private_offset;
static gpointer applications_sidebar_parent_class = NULL;
static gint ApplicationsSidebarSimpleSidebarRow_private_offset;
static gpointer applications_sidebar_simple_sidebar_row_parent_class = NULL;

static gboolean applications_sidebar_filter_function (ApplicationsSidebar* self,
                                               GtkListBoxRow* row);
static GType applications_sidebar_simple_sidebar_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void applications_sidebar_header_func (ApplicationsSidebar* self,
                                       GtkListBoxRow* row,
                                       GtkListBoxRow* before);
static gint applications_sidebar_sort_func (ApplicationsSidebar* self,
                                     GtkListBoxRow* row1,
                                     GtkListBoxRow* row2);
static ApplicationsSidebarSimpleSidebarRow* applications_sidebar_simple_sidebar_row_new (const gchar* label,
                                                                                  const gchar* icon_name);
static ApplicationsSidebarSimpleSidebarRow* applications_sidebar_simple_sidebar_row_construct (GType object_type,
                                                                                        const gchar* label,
                                                                                        const gchar* icon_name);
static const gchar* applications_sidebar_simple_sidebar_row_get_label (ApplicationsSidebarSimpleSidebarRow* self);
static void applications_sidebar_simple_sidebar_row_set_label (ApplicationsSidebarSimpleSidebarRow* self,
                                                        const gchar* value);
static const gchar* applications_sidebar_simple_sidebar_row_get_icon_name (ApplicationsSidebarSimpleSidebarRow* self);
static void applications_sidebar_simple_sidebar_row_set_icon_name (ApplicationsSidebarSimpleSidebarRow* self,
                                                            const gchar* value);
static GObject * applications_sidebar_simple_sidebar_row_constructor (GType type,
                                                               guint n_construct_properties,
                                                               GObjectConstructParam * construct_properties);
static void applications_sidebar_simple_sidebar_row_finalize (GObject * obj);
static GType applications_sidebar_simple_sidebar_row_get_type_once (void);
static void _vala_applications_sidebar_simple_sidebar_row_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec);
static void _vala_applications_sidebar_simple_sidebar_row_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec);
static GObject * applications_sidebar_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _applications_sidebar_filter_function_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                         gpointer self);
static void _applications_sidebar_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                        GtkListBoxRow* before,
                                                                        gpointer self);
static gint _applications_sidebar_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                             GtkListBoxRow* row2,
                                                             gpointer self);
static void _applications_sidebar___lambda33_ (Block1Data* _data1_,
                                        const gchar* id,
                                        PermissionsBackendApp* app);
static void __applications_sidebar___lambda33__gh_func (gconstpointer key,
                                                 gconstpointer value,
                                                 gpointer self);
static void _applications_sidebar___lambda34_ (ApplicationsSidebar* self,
                                        GtkListBoxRow* row);
static void __applications_sidebar___lambda34__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self);
static void _applications_sidebar___lambda35_ (Block1Data* _data1_,
                                        GVariant* value);
static void __applications_sidebar___lambda35__g_simple_action_change_state (GSimpleAction* _sender,
                                                                      GVariant* value,
                                                                      gpointer self);
static void _applications_sidebar___lambda36_ (Block1Data* _data1_);
static void __applications_sidebar___lambda36__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                         gpointer self);
static void applications_sidebar_finalize (GObject * obj);
static GType applications_sidebar_get_type_once (void);
static void _vala_applications_sidebar_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_applications_sidebar_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
applications_sidebar_get_instance_private (ApplicationsSidebar* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationsSidebar_private_offset);
}

ApplicationsSidebar*
applications_sidebar_construct (GType object_type,
                                GtkStack* stack)
{
	ApplicationsSidebar * self = NULL;
	g_return_val_if_fail (stack != NULL, NULL);
	self = (ApplicationsSidebar*) g_object_new (object_type, "stack", stack, NULL);
	return self;
}

ApplicationsSidebar*
applications_sidebar_new (GtkStack* stack)
{
	return applications_sidebar_construct (APPLICATIONS_TYPE_SIDEBAR, stack);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
applications_sidebar_filter_function (ApplicationsSidebar* self,
                                      GtkListBoxRow* row)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		gchar* search_term = NULL;
		GtkSearchEntry* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* row_name = NULL;
		PermissionsBackendApp* _tmp7_;
		PermissionsBackendApp* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		if (APPLICATIONS_SIDEBAR_IS_SIMPLE_SIDEBAR_ROW (row)) {
			result = FALSE;
			return result;
		}
		_tmp3_ = self->priv->search_entry;
		_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
		search_term = _tmp6_;
		_tmp7_ = permissions_sidebar_row_get_app (G_TYPE_CHECK_INSTANCE_CAST (row, PERMISSIONS_TYPE_SIDEBAR_ROW, PermissionsSidebarRow));
		_tmp8_ = _tmp7_;
		_tmp9_ = permissions_backend_app_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) -1);
		row_name = _tmp11_;
		_tmp12_ = row_name;
		_tmp13_ = search_term;
		result = string_contains (_tmp12_, _tmp13_);
		_g_free0 (row_name);
		_g_free0 (search_term);
		return result;
	}
	result = TRUE;
	return result;
}

static void
applications_sidebar_header_func (ApplicationsSidebar* self,
                                  GtkListBoxRow* row,
                                  GtkListBoxRow* before)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	if (APPLICATIONS_SIDEBAR_IS_SIMPLE_SIDEBAR_ROW (row)) {
		_tmp0_ = !APPLICATIONS_SIDEBAR_IS_SIMPLE_SIDEBAR_ROW (before);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GraniteHeaderLabel* _tmp1_;
		GraniteHeaderLabel* _tmp2_;
		_tmp1_ = granite_header_label_new (_ ("System"));
		g_object_ref_sink (_tmp1_);
		_tmp2_ = _tmp1_;
		gtk_list_box_row_set_header (row, (GtkWidget*) _tmp2_);
		_g_object_unref0 (_tmp2_);
		return;
	}
	if (PERMISSIONS_IS_SIDEBAR_ROW (row)) {
		_tmp3_ = APPLICATIONS_SIDEBAR_IS_SIMPLE_SIDEBAR_ROW (before);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GraniteHeaderLabel* _tmp4_;
		GraniteHeaderLabel* _tmp5_;
		_tmp4_ = granite_header_label_new (_ ("Apps"));
		g_object_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		gtk_list_box_row_set_header (row, (GtkWidget*) _tmp5_);
		_g_object_unref0 (_tmp5_);
		return;
	}
	gtk_list_box_row_set_header (row, NULL);
}

static gint
applications_sidebar_sort_func (ApplicationsSidebar* self,
                                GtkListBoxRow* row1,
                                GtkListBoxRow* row2)
{
	gboolean _tmp0_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	if (PERMISSIONS_IS_SIDEBAR_ROW (row1)) {
		_tmp0_ = PERMISSIONS_IS_SIDEBAR_ROW (row2);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		PermissionsBackendApp* _tmp1_;
		PermissionsBackendApp* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		PermissionsBackendApp* _tmp5_;
		PermissionsBackendApp* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp1_ = permissions_sidebar_row_get_app (G_TYPE_CHECK_INSTANCE_CAST (row1, PERMISSIONS_TYPE_SIDEBAR_ROW, PermissionsSidebarRow));
		_tmp2_ = _tmp1_;
		_tmp3_ = permissions_backend_app_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = permissions_sidebar_row_get_app (G_TYPE_CHECK_INSTANCE_CAST (row2, PERMISSIONS_TYPE_SIDEBAR_ROW, PermissionsSidebarRow));
		_tmp6_ = _tmp5_;
		_tmp7_ = permissions_backend_app_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		result = g_utf8_collate (_tmp4_, _tmp8_);
		return result;
	}
	result = 0;
	return result;
}

GtkStack*
applications_sidebar_get_stack (ApplicationsSidebar* self)
{
	GtkStack* result;
	GtkStack* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stack;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
applications_sidebar_set_stack (ApplicationsSidebar* self,
                                GtkStack* value)
{
	GtkStack* old_value;
	g_return_if_fail (self != NULL);
	old_value = applications_sidebar_get_stack (self);
	if (old_value != value) {
		GtkStack* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_stack);
		self->priv->_stack = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, applications_sidebar_properties[APPLICATIONS_SIDEBAR_STACK_PROPERTY]);
	}
}

static inline gpointer
applications_sidebar_simple_sidebar_row_get_instance_private (ApplicationsSidebarSimpleSidebarRow* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationsSidebarSimpleSidebarRow_private_offset);
}

static ApplicationsSidebarSimpleSidebarRow*
applications_sidebar_simple_sidebar_row_construct (GType object_type,
                                                   const gchar* label,
                                                   const gchar* icon_name)
{
	ApplicationsSidebarSimpleSidebarRow * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (ApplicationsSidebarSimpleSidebarRow*) g_object_new (object_type, "label", label, "icon-name", icon_name, NULL);
	return self;
}

static ApplicationsSidebarSimpleSidebarRow*
applications_sidebar_simple_sidebar_row_new (const gchar* label,
                                             const gchar* icon_name)
{
	return applications_sidebar_simple_sidebar_row_construct (APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW, label, icon_name);
}

static const gchar*
applications_sidebar_simple_sidebar_row_get_label (ApplicationsSidebarSimpleSidebarRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
applications_sidebar_simple_sidebar_row_set_label (ApplicationsSidebarSimpleSidebarRow* self,
                                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = applications_sidebar_simple_sidebar_row_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, applications_sidebar_simple_sidebar_row_properties[APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_LABEL_PROPERTY]);
	}
}

static const gchar*
applications_sidebar_simple_sidebar_row_get_icon_name (ApplicationsSidebarSimpleSidebarRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
applications_sidebar_simple_sidebar_row_set_icon_name (ApplicationsSidebarSimpleSidebarRow* self,
                                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = applications_sidebar_simple_sidebar_row_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, applications_sidebar_simple_sidebar_row_properties[APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_ICON_NAME_PROPERTY]);
	}
}

static GObject *
applications_sidebar_simple_sidebar_row_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ApplicationsSidebarSimpleSidebarRow * self;
	GtkImage* image = NULL;
	const gchar* _tmp0_;
	GtkImage* _tmp1_ = NULL;
	GtkLabel* title_label = NULL;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_;
	GtkBox* box = NULL;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkImage* _tmp7_;
	GtkBox* _tmp8_;
	GtkLabel* _tmp9_;
	GtkBox* _tmp10_;
	const gchar* _tmp11_;
	parent_class = G_OBJECT_CLASS (applications_sidebar_simple_sidebar_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW, ApplicationsSidebarSimpleSidebarRow);
	_tmp0_ = self->priv->_icon_name;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp0_);
	gtk_image_set_icon_size (_tmp1_, GTK_ICON_SIZE_LARGE);
	g_object_ref_sink (_tmp1_);
	image = _tmp1_;
	_tmp2_ = self->priv->_label;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	gtk_label_set_ellipsize (_tmp3_, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (_tmp3_, (gfloat) 0);
	g_object_ref_sink (_tmp3_);
	title_label = _tmp3_;
	_tmp4_ = title_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp5_);
	box = _tmp5_;
	_tmp6_ = box;
	_tmp7_ = image;
	gtk_box_append (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = box;
	_tmp9_ = title_label;
	gtk_box_append (_tmp8_, (GtkWidget*) _tmp9_);
	g_object_set ((GtkAccessible*) self, "accessible-role", GTK_ACCESSIBLE_ROLE_TAB, NULL);
	_tmp10_ = box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->_label;
	gtk_accessible_update_property ((GtkAccessible*) self, GTK_ACCESSIBLE_PROPERTY_LABEL, _tmp11_, -1, -1);
	_g_object_unref0 (box);
	_g_object_unref0 (title_label);
	_g_object_unref0 (image);
	return obj;
}

static void
applications_sidebar_simple_sidebar_row_class_init (ApplicationsSidebarSimpleSidebarRowClass * klass,
                                                    gpointer klass_data)
{
	applications_sidebar_simple_sidebar_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationsSidebarSimpleSidebarRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_applications_sidebar_simple_sidebar_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_applications_sidebar_simple_sidebar_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = applications_sidebar_simple_sidebar_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = applications_sidebar_simple_sidebar_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_LABEL_PROPERTY, applications_sidebar_simple_sidebar_row_properties[APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_ICON_NAME_PROPERTY, applications_sidebar_simple_sidebar_row_properties[APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
applications_sidebar_simple_sidebar_row_instance_init (ApplicationsSidebarSimpleSidebarRow * self,
                                                       gpointer klass)
{
	self->priv = applications_sidebar_simple_sidebar_row_get_instance_private (self);
}

static void
applications_sidebar_simple_sidebar_row_finalize (GObject * obj)
{
	ApplicationsSidebarSimpleSidebarRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW, ApplicationsSidebarSimpleSidebarRow);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_icon_name);
	G_OBJECT_CLASS (applications_sidebar_simple_sidebar_row_parent_class)->finalize (obj);
}

static GType
applications_sidebar_simple_sidebar_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationsSidebarSimpleSidebarRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) applications_sidebar_simple_sidebar_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationsSidebarSimpleSidebarRow), 0, (GInstanceInitFunc) applications_sidebar_simple_sidebar_row_instance_init, NULL };
	GType applications_sidebar_simple_sidebar_row_type_id;
	applications_sidebar_simple_sidebar_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ApplicationsSidebarSimpleSidebarRow", &g_define_type_info, 0);
	ApplicationsSidebarSimpleSidebarRow_private_offset = g_type_add_instance_private (applications_sidebar_simple_sidebar_row_type_id, sizeof (ApplicationsSidebarSimpleSidebarRowPrivate));
	return applications_sidebar_simple_sidebar_row_type_id;
}

static GType
applications_sidebar_simple_sidebar_row_get_type (void)
{
	static volatile gsize applications_sidebar_simple_sidebar_row_type_id__once = 0;
	if (g_once_init_enter (&applications_sidebar_simple_sidebar_row_type_id__once)) {
		GType applications_sidebar_simple_sidebar_row_type_id;
		applications_sidebar_simple_sidebar_row_type_id = applications_sidebar_simple_sidebar_row_get_type_once ();
		g_once_init_leave (&applications_sidebar_simple_sidebar_row_type_id__once, applications_sidebar_simple_sidebar_row_type_id);
	}
	return applications_sidebar_simple_sidebar_row_type_id__once;
}

static void
_vala_applications_sidebar_simple_sidebar_row_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec)
{
	ApplicationsSidebarSimpleSidebarRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW, ApplicationsSidebarSimpleSidebarRow);
	switch (property_id) {
		case APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_LABEL_PROPERTY:
		g_value_set_string (value, applications_sidebar_simple_sidebar_row_get_label (self));
		break;
		case APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_ICON_NAME_PROPERTY:
		g_value_set_string (value, applications_sidebar_simple_sidebar_row_get_icon_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_applications_sidebar_simple_sidebar_row_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec)
{
	ApplicationsSidebarSimpleSidebarRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW, ApplicationsSidebarSimpleSidebarRow);
	switch (property_id) {
		case APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_LABEL_PROPERTY:
		applications_sidebar_simple_sidebar_row_set_label (self, g_value_get_string (value));
		break;
		case APPLICATIONS_SIDEBAR_SIMPLE_SIDEBAR_ROW_ICON_NAME_PROPERTY:
		applications_sidebar_simple_sidebar_row_set_icon_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ApplicationsSidebar* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->search_action);
		_g_object_unref0 (_data1_->listbox);
		_g_object_unref0 (_data1_->search_revealer);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
_applications_sidebar_filter_function_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                gpointer self)
{
	gboolean result;
	result = applications_sidebar_filter_function ((ApplicationsSidebar*) self, row);
	return result;
}

static void
_applications_sidebar_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                   GtkListBoxRow* before,
                                                                   gpointer self)
{
	applications_sidebar_header_func ((ApplicationsSidebar*) self, row, before);
}

static gint
_applications_sidebar_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                        GtkListBoxRow* row2,
                                                        gpointer self)
{
	gint result;
	result = applications_sidebar_sort_func ((ApplicationsSidebar*) self, row1, row2);
	return result;
}

static void
_applications_sidebar___lambda33_ (Block1Data* _data1_,
                                   const gchar* id,
                                   PermissionsBackendApp* app)
{
	ApplicationsSidebar* self;
	PermissionsSidebarRow* app_entry = NULL;
	PermissionsSidebarRow* _tmp0_;
	GtkListBox* _tmp1_;
	PermissionsSidebarRow* _tmp2_;
	self = _data1_->self;
	g_return_if_fail (id != NULL);
	g_return_if_fail (app != NULL);
	_tmp0_ = permissions_sidebar_row_new (app);
	g_object_ref_sink (_tmp0_);
	app_entry = _tmp0_;
	_tmp1_ = _data1_->listbox;
	_tmp2_ = app_entry;
	gtk_list_box_append (_tmp1_, (GtkWidget*) _tmp2_);
	_g_object_unref0 (app_entry);
}

static void
__applications_sidebar___lambda33__gh_func (gconstpointer key,
                                            gconstpointer value,
                                            gpointer self)
{
	_applications_sidebar___lambda33_ (self, (const gchar*) key, (PermissionsBackendApp*) value);
}

static void
_applications_sidebar___lambda34_ (ApplicationsSidebar* self,
                                   GtkListBoxRow* row)
{
	if (row == NULL) {
		return;
	}
	if (PERMISSIONS_IS_SIDEBAR_ROW (row)) {
		GtkStack* _tmp0_;
		GtkStack* _tmp1_;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		PermissionsBackendApp* _tmp4_;
		PermissionsBackendApp* _tmp5_;
		_tmp0_ = self->priv->_stack;
		gtk_stack_set_visible_child_name (_tmp0_, APPLICATIONS_PLUG_PERMISSIONS);
		_tmp1_ = self->priv->_stack;
		_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = permissions_sidebar_row_get_app (G_TYPE_CHECK_INSTANCE_CAST (row, PERMISSIONS_TYPE_SIDEBAR_ROW, PermissionsSidebarRow));
		_tmp5_ = _tmp4_;
		permissions_widgets_app_settings_view_set_selected_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, PERMISSIONS_WIDGETS_TYPE_APP_SETTINGS_VIEW, PermissionsWidgetsAppSettingsView), _tmp5_);
	} else {
		if (APPLICATIONS_SIDEBAR_IS_SIMPLE_SIDEBAR_ROW (row)) {
			GtkStack* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp6_ = self->priv->_stack;
			_tmp7_ = applications_sidebar_simple_sidebar_row_get_icon_name (G_TYPE_CHECK_INSTANCE_CAST (row, APPLICATIONS_SIDEBAR_TYPE_SIMPLE_SIDEBAR_ROW, ApplicationsSidebarSimpleSidebarRow));
			_tmp8_ = _tmp7_;
			gtk_stack_set_visible_child_name (_tmp6_, _tmp8_);
		}
	}
}

static void
__applications_sidebar___lambda34__gtk_list_box_row_selected (GtkListBox* _sender,
                                                              GtkListBoxRow* row,
                                                              gpointer self)
{
	_applications_sidebar___lambda34_ ((ApplicationsSidebar*) self, row);
}

static void
_applications_sidebar___lambda35_ (Block1Data* _data1_,
                                   GVariant* value)
{
	ApplicationsSidebar* self;
	GSimpleAction* _tmp0_;
	GtkRevealer* _tmp1_;
	self = _data1_->self;
	_tmp0_ = _data1_->search_action;
	g_simple_action_set_state (_tmp0_, value);
	_tmp1_ = _data1_->search_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, g_variant_get_boolean (value));
	if (g_variant_get_boolean (value)) {
		GtkSearchEntry* _tmp2_;
		_tmp2_ = self->priv->search_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
	} else {
		GtkSearchEntry* _tmp3_;
		_tmp3_ = self->priv->search_entry;
		gtk_editable_set_text ((GtkEditable*) _tmp3_, "");
	}
}

static void
__applications_sidebar___lambda35__g_simple_action_change_state (GSimpleAction* _sender,
                                                                 GVariant* value,
                                                                 gpointer self)
{
	_applications_sidebar___lambda35_ (self, value);
}

static void
_applications_sidebar___lambda36_ (Block1Data* _data1_)
{
	ApplicationsSidebar* self;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkListBox* _tmp6_;
	self = _data1_->self;
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		GSimpleAction* _tmp3_;
		GVariant* _tmp4_;
		GVariant* _tmp5_;
		_tmp3_ = _data1_->search_action;
		_tmp4_ = g_variant_new_boolean (TRUE);
		g_variant_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		g_signal_emit_by_name (_tmp3_, "change-state", _tmp5_);
		_g_variant_unref0 (_tmp5_);
	}
	_tmp6_ = _data1_->listbox;
	gtk_list_box_invalidate_filter (_tmp6_);
}

static void
__applications_sidebar___lambda36__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                    gpointer self)
{
	_applications_sidebar___lambda36_ (self);
}

static GObject *
applications_sidebar_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ApplicationsSidebar * self;
	Block1Data* _data1_;
	ApplicationsSidebarSimpleSidebarRow* defaults_row = NULL;
	ApplicationsSidebarSimpleSidebarRow* _tmp0_;
	ApplicationsSidebarSimpleSidebarRow* startup_row = NULL;
	ApplicationsSidebarSimpleSidebarRow* _tmp1_;
	gchar* _tmp2_;
	GtkSearchEntry* _tmp3_ = NULL;
	GtkSearchEntry* _tmp4_;
	GtkSearchEntry* _tmp5_;
	GtkWidget* _tmp6_;
	GtkRevealer* _tmp7_ = NULL;
	GtkToggleButton* search_toggle = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkToggleButton* _tmp11_ = NULL;
	AdwHeaderBar* headerbar = NULL;
	AdwHeaderBar* _tmp12_ = NULL;
	AdwHeaderBar* _tmp13_;
	GtkToggleButton* _tmp14_;
	GtkListBox* _tmp15_ = NULL;
	GtkListBox* _tmp16_;
	GtkListBox* _tmp17_;
	GtkListBox* _tmp18_;
	GtkListBox* _tmp19_;
	ApplicationsSidebarSimpleSidebarRow* _tmp20_;
	GtkListBox* _tmp21_;
	ApplicationsSidebarSimpleSidebarRow* _tmp22_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkListBox* _tmp23_;
	GtkWidget* _tmp24_;
	GtkScrolledWindow* _tmp25_ = NULL;
	AdwToolbarView* toolbarview = NULL;
	GtkScrolledWindow* _tmp26_;
	GtkWidget* _tmp27_;
	AdwToolbarView* _tmp28_ = NULL;
	AdwToolbarView* _tmp29_;
	AdwHeaderBar* _tmp30_;
	AdwToolbarView* _tmp31_;
	GtkRevealer* _tmp32_;
	AdwToolbarView* _tmp33_;
	PermissionsBackendAppManager* _tmp34_;
	PermissionsBackendAppManager* _tmp35_;
	GHashTable* _tmp36_;
	GHashTable* _tmp37_;
	GtkListBox* _tmp38_;
	GVariant* _tmp39_;
	GVariant* _tmp40_;
	GSimpleAction* _tmp41_;
	GSimpleAction* _tmp42_;
	GSimpleAction* _tmp43_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp44_;
	GSimpleActionGroup* _tmp45_;
	GSimpleAction* _tmp46_;
	GSimpleActionGroup* _tmp47_;
	GtkSearchEntry* _tmp48_;
	parent_class = G_OBJECT_CLASS (applications_sidebar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATIONS_TYPE_SIDEBAR, ApplicationsSidebar);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = applications_sidebar_simple_sidebar_row_new (_ ("Defaults"), APPLICATIONS_PLUG_DEFAULTS);
	g_object_ref_sink (_tmp0_);
	defaults_row = _tmp0_;
	_tmp1_ = applications_sidebar_simple_sidebar_row_new (_ ("Startup"), APPLICATIONS_PLUG_STARTUP);
	g_object_ref_sink (_tmp1_);
	startup_row = _tmp1_;
	_tmp2_ = g_strdup (_ ("Search Apps"));
	_tmp3_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_set (_tmp3_, "placeholder-text", _tmp2_, NULL);
	_g_free0 (_tmp2_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp3_;
	_tmp4_ = self->priv->search_entry;
	gtk_search_entry_set_key_capture_widget (_tmp4_, (GtkWidget*) self);
	_tmp5_ = self->priv->search_entry;
	_tmp6_ = _g_object_ref0 ((GtkWidget*) _tmp5_);
	_tmp7_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp7_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_data1_->search_revealer = _tmp7_;
	_tmp8_ = g_strdup ("sidebar.search");
	_tmp9_ = g_strdup ("edit-find-symbolic");
	_tmp10_ = g_strdup (_ ("Search Apps"));
	_tmp11_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp11_, _tmp8_);
	_g_free0 (_tmp8_);
	gtk_button_set_icon_name ((GtkButton*) _tmp11_, _tmp9_);
	_g_free0 (_tmp9_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _tmp10_);
	_g_free0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	search_toggle = _tmp11_;
	_tmp12_ = (AdwHeaderBar*) adw_header_bar_new ();
	adw_header_bar_set_show_end_title_buttons (_tmp12_, FALSE);
	adw_header_bar_set_show_title (_tmp12_, FALSE);
	g_object_ref_sink (_tmp12_);
	headerbar = _tmp12_;
	_tmp13_ = headerbar;
	_tmp14_ = search_toggle;
	adw_header_bar_pack_end (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp15_, TRUE);
	gtk_list_box_set_selection_mode (_tmp15_, GTK_SELECTION_BROWSE);
	g_object_ref_sink (_tmp15_);
	_data1_->listbox = _tmp15_;
	_tmp16_ = _data1_->listbox;
	gtk_list_box_set_filter_func (_tmp16_, _applications_sidebar_filter_function_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp17_ = _data1_->listbox;
	gtk_list_box_set_header_func (_tmp17_, _applications_sidebar_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp18_ = _data1_->listbox;
	gtk_list_box_set_sort_func (_tmp18_, _applications_sidebar_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp19_ = _data1_->listbox;
	_tmp20_ = defaults_row;
	gtk_list_box_append (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = _data1_->listbox;
	_tmp22_ = startup_row;
	gtk_list_box_append (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = _data1_->listbox;
	_tmp24_ = _g_object_ref0 ((GtkWidget*) _tmp23_);
	_tmp25_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp25_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	g_object_set (_tmp25_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp25_);
	scrolled_window = _tmp25_;
	_tmp26_ = scrolled_window;
	_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
	_tmp28_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_content (_tmp28_, _tmp27_);
	_g_object_unref0 (_tmp27_);
	adw_toolbar_view_set_top_bar_style (_tmp28_, ADW_TOOLBAR_FLAT);
	g_object_ref_sink (_tmp28_);
	toolbarview = _tmp28_;
	_tmp29_ = toolbarview;
	_tmp30_ = headerbar;
	adw_toolbar_view_add_top_bar (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = toolbarview;
	_tmp32_ = _data1_->search_revealer;
	adw_toolbar_view_add_top_bar (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = toolbarview;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp33_);
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_SIDEBAR);
	_tmp34_ = permissions_backend_app_manager_get_default ();
	_tmp35_ = _tmp34_;
	_tmp36_ = permissions_backend_app_manager_get_apps (_tmp35_);
	_tmp37_ = _tmp36_;
	g_hash_table_foreach (_tmp37_, __applications_sidebar___lambda33__gh_func, _data1_);
	_g_object_unref0 (_tmp35_);
	_tmp38_ = _data1_->listbox;
	g_signal_connect_object (_tmp38_, "row-selected", (GCallback) __applications_sidebar___lambda34__gtk_list_box_row_selected, self, 0);
	_tmp39_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp39_);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_simple_action_new_stateful ("search", NULL, _tmp40_);
	_tmp42_ = _tmp41_;
	_g_variant_unref0 (_tmp40_);
	_data1_->search_action = _tmp42_;
	_tmp43_ = _data1_->search_action;
	g_signal_connect_data (_tmp43_, "change-state", (GCallback) __applications_sidebar___lambda35__g_simple_action_change_state, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp44_ = g_simple_action_group_new ();
	action_group = _tmp44_;
	_tmp45_ = action_group;
	_tmp46_ = _data1_->search_action;
	g_action_map_add_action ((GActionMap*) _tmp45_, (GAction*) _tmp46_);
	_tmp47_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "sidebar", (GActionGroup*) _tmp47_);
	_tmp48_ = self->priv->search_entry;
	g_signal_connect_data (_tmp48_, "search-changed", (GCallback) __applications_sidebar___lambda36__gtk_search_entry_search_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_object_unref0 (action_group);
	_g_object_unref0 (toolbarview);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (search_toggle);
	_g_object_unref0 (startup_row);
	_g_object_unref0 (defaults_row);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
applications_sidebar_base_init (ApplicationsSidebarClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "settingssidebar");
}

static void
applications_sidebar_class_init (ApplicationsSidebarClass * klass,
                                 gpointer klass_data)
{
	applications_sidebar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationsSidebar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_applications_sidebar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_applications_sidebar_set_property;
	G_OBJECT_CLASS (klass)->constructor = applications_sidebar_constructor;
	G_OBJECT_CLASS (klass)->finalize = applications_sidebar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATIONS_SIDEBAR_STACK_PROPERTY, applications_sidebar_properties[APPLICATIONS_SIDEBAR_STACK_PROPERTY] = g_param_spec_object ("stack", "stack", "stack", gtk_stack_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
applications_sidebar_instance_init (ApplicationsSidebar * self,
                                    gpointer klass)
{
	self->priv = applications_sidebar_get_instance_private (self);
}

static void
applications_sidebar_finalize (GObject * obj)
{
	ApplicationsSidebar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATIONS_TYPE_SIDEBAR, ApplicationsSidebar);
	_g_object_unref0 (self->priv->_stack);
	_g_object_unref0 (self->priv->search_entry);
	G_OBJECT_CLASS (applications_sidebar_parent_class)->finalize (obj);
}

static GType
applications_sidebar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationsSidebarClass), (GBaseInitFunc) applications_sidebar_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) applications_sidebar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationsSidebar), 0, (GInstanceInitFunc) applications_sidebar_instance_init, NULL };
	GType applications_sidebar_type_id;
	applications_sidebar_type_id = g_type_register_static (gtk_box_get_type (), "ApplicationsSidebar", &g_define_type_info, 0);
	ApplicationsSidebar_private_offset = g_type_add_instance_private (applications_sidebar_type_id, sizeof (ApplicationsSidebarPrivate));
	return applications_sidebar_type_id;
}

GType
applications_sidebar_get_type (void)
{
	static volatile gsize applications_sidebar_type_id__once = 0;
	if (g_once_init_enter (&applications_sidebar_type_id__once)) {
		GType applications_sidebar_type_id;
		applications_sidebar_type_id = applications_sidebar_get_type_once ();
		g_once_init_leave (&applications_sidebar_type_id__once, applications_sidebar_type_id);
	}
	return applications_sidebar_type_id__once;
}

static void
_vala_applications_sidebar_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	ApplicationsSidebar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATIONS_TYPE_SIDEBAR, ApplicationsSidebar);
	switch (property_id) {
		case APPLICATIONS_SIDEBAR_STACK_PROPERTY:
		g_value_set_object (value, applications_sidebar_get_stack (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_applications_sidebar_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	ApplicationsSidebar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATIONS_TYPE_SIDEBAR, ApplicationsSidebar);
	switch (property_id) {
		case APPLICATIONS_SIDEBAR_STACK_PROPERTY:
		applications_sidebar_set_stack (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

