
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_krb5pac.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/netlogon.h"
#include "librpc/gen_ndr/samr.h"
static PyTypeObject PAC_LOGON_NAME_Type;
static PyTypeObject PAC_SIGNATURE_DATA_Type;
static PyTypeObject PAC_DOMAIN_GROUP_MEMBERSHIP_Type;
static PyTypeObject PAC_LOGON_INFO_Type;
static PyTypeObject PAC_CREDENTIAL_NTLM_SECPKG_Type;
static PyTypeObject PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_Type;
static PyTypeObject PAC_CREDENTIAL_DATA_Type;
static PyTypeObject PAC_CREDENTIAL_DATA_CTR_Type;
static PyTypeObject PAC_CREDENTIAL_DATA_NDR_Type;
static PyTypeObject PAC_CREDENTIAL_INFO_Type;
static PyTypeObject PAC_CONSTRAINED_DELEGATION_Type;
static PyTypeObject PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_Type;
static PyTypeObject PAC_UPN_DNS_INFO_EX_Type;
static PyTypeObject PAC_UPN_DNS_INFO_Type;
static PyTypeObject PAC_ATTRIBUTES_INFO_Type;
static PyTypeObject PAC_REQUESTER_SID_Type;
static PyTypeObject PAC_LOGON_INFO_CTR_Type;
static PyTypeObject PAC_CONSTRAINED_DELEGATION_CTR_Type;
static PyTypeObject PAC_DEVICE_INFO_Type;
static PyTypeObject PAC_DEVICE_INFO_CTR_Type;
static PyTypeObject DATA_BLOB_REM_Type;
static PyTypeObject PAC_INFO_Type;
static PyTypeObject PAC_BUFFER_Type;
static PyTypeObject PAC_DATA_Type;
static PyTypeObject PAC_BUFFER_RAW_Type;
static PyTypeObject PAC_DATA_RAW_Type;
static PyTypeObject PAC_Validate_Type;
static PyTypeObject netsamlogoncache_entry_Type;
static PyTypeObject krb5pac_InterfaceType;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *samr_RidWithAttributeArray_Type;
static PyTypeObject *netr_SamInfo3_Type;
static PyTypeObject *samr_Password_Type;
static PyTypeObject *lsa_String_Type;
static PyTypeObject *netr_SidAttr_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_PAC_LOGON_NAME_get_logon_time(PyObject *obj, void *closure)
{
	struct PAC_LOGON_NAME *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_time;
	py_logon_time = PyLong_FromUnsignedLongLong(object->logon_time);
	return py_logon_time;
}

static int py_PAC_LOGON_NAME_set_logon_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_NAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_LOGON_NAME_get_size(PyObject *obj, void *closure)
{
	struct PAC_LOGON_NAME *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_PAC_LOGON_NAME_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_NAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_LOGON_NAME_get_account_name(PyObject *obj, void *closure)
{
	struct PAC_LOGON_NAME *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
	}
	return py_account_name;
}

static int py_PAC_LOGON_NAME_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_NAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->account_name = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_PAC_LOGON_NAME_getsetters[] = {
	{
		.name = discard_const_p(char, "logon_time"),
		.get = py_PAC_LOGON_NAME_get_logon_time,
		.set = py_PAC_LOGON_NAME_set_logon_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_PAC_LOGON_NAME_get_size,
		.set = py_PAC_LOGON_NAME_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_PAC_LOGON_NAME_get_account_name,
		.set = py_PAC_LOGON_NAME_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_LOGON_NAME_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_LOGON_NAME, type);
}


static PyTypeObject PAC_LOGON_NAME_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_LOGON_NAME",
	.tp_getset = py_PAC_LOGON_NAME_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_LOGON_NAME_new,
};


static PyObject *py_PAC_SIGNATURE_DATA_get_type(PyObject *obj, void *closure)
{
	struct PAC_SIGNATURE_DATA *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_PAC_SIGNATURE_DATA_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_SIGNATURE_DATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_SIGNATURE_DATA_get_signature(PyObject *obj, void *closure)
{
	struct PAC_SIGNATURE_DATA *object = pytalloc_get_ptr(obj);
	PyObject *py_signature;
	py_signature = PyBytes_FromStringAndSize((char *)(object->signature).data, (object->signature).length);
	return py_signature;
}

static int py_PAC_SIGNATURE_DATA_set_signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_SIGNATURE_DATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->signature");
		return -1;
	}
	object->signature = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_PAC_SIGNATURE_DATA_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_PAC_SIGNATURE_DATA_get_type,
		.set = py_PAC_SIGNATURE_DATA_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "signature"),
		.get = py_PAC_SIGNATURE_DATA_get_signature,
		.set = py_PAC_SIGNATURE_DATA_set_signature,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_SIGNATURE_DATA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_SIGNATURE_DATA, type);
}

static PyObject *py_PAC_SIGNATURE_DATA_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_SIGNATURE_DATA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_SIGNATURE_DATA);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_SIGNATURE_DATA_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_SIGNATURE_DATA *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_SIGNATURE_DATA);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_SIGNATURE_DATA);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_SIGNATURE_DATA_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_SIGNATURE_DATA *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_SIGNATURE_DATA, "PAC_SIGNATURE_DATA", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_SIGNATURE_DATA, "PAC_SIGNATURE_DATA", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_SIGNATURE_DATA_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_SIGNATURE_DATA_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_SIGNATURE_DATA_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_SIGNATURE_DATA_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_SIGNATURE_DATA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_SIGNATURE_DATA",
	.tp_getset = py_PAC_SIGNATURE_DATA_getsetters,
	.tp_methods = py_PAC_SIGNATURE_DATA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_SIGNATURE_DATA_new,
};


static PyObject *py_PAC_DOMAIN_GROUP_MEMBERSHIP_get_domain_sid(PyObject *obj, void *closure)
{
	struct PAC_DOMAIN_GROUP_MEMBERSHIP *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->domain_sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_sid == NULL) {
		py_domain_sid = Py_None;
		Py_INCREF(py_domain_sid);
	} else {
		py_domain_sid = pytalloc_reference_ex(dom_sid_Type, object->domain_sid, object->domain_sid);
	}
	return py_domain_sid;
}

static int py_PAC_DOMAIN_GROUP_MEMBERSHIP_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DOMAIN_GROUP_MEMBERSHIP *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->domain_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_sid");
		return -1;
	}
	if (value == Py_None) {
		object->domain_sid = NULL;
	} else {
		object->domain_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_PAC_DOMAIN_GROUP_MEMBERSHIP_get_groups(PyObject *obj, void *closure)
{
	struct PAC_DOMAIN_GROUP_MEMBERSHIP *object = pytalloc_get_ptr(obj);
	PyObject *py_groups;
	py_groups = pytalloc_reference_ex(samr_RidWithAttributeArray_Type, pytalloc_get_mem_ctx(obj), &object->groups);
	return py_groups;
}

static int py_PAC_DOMAIN_GROUP_MEMBERSHIP_set_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DOMAIN_GROUP_MEMBERSHIP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->groups");
		return -1;
	}
	PY_CHECK_TYPE(samr_RidWithAttributeArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->groups = *(struct samr_RidWithAttributeArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_PAC_DOMAIN_GROUP_MEMBERSHIP_getsetters[] = {
	{
		.name = discard_const_p(char, "domain_sid"),
		.get = py_PAC_DOMAIN_GROUP_MEMBERSHIP_get_domain_sid,
		.set = py_PAC_DOMAIN_GROUP_MEMBERSHIP_set_domain_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "groups"),
		.get = py_PAC_DOMAIN_GROUP_MEMBERSHIP_get_groups,
		.set = py_PAC_DOMAIN_GROUP_MEMBERSHIP_set_groups,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_RidWithAttributeArray")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_DOMAIN_GROUP_MEMBERSHIP_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_DOMAIN_GROUP_MEMBERSHIP, type);
}


static PyTypeObject PAC_DOMAIN_GROUP_MEMBERSHIP_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_DOMAIN_GROUP_MEMBERSHIP",
	.tp_getset = py_PAC_DOMAIN_GROUP_MEMBERSHIP_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_DOMAIN_GROUP_MEMBERSHIP_new,
};


static PyObject *py_PAC_LOGON_INFO_get_info3(PyObject *obj, void *closure)
{
	struct PAC_LOGON_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_info3;
	py_info3 = pytalloc_reference_ex(netr_SamInfo3_Type, pytalloc_get_mem_ctx(obj), &object->info3);
	return py_info3;
}

static int py_PAC_LOGON_INFO_set_info3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info3");
		return -1;
	}
	PY_CHECK_TYPE(netr_SamInfo3_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info3 = *(struct netr_SamInfo3 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_PAC_LOGON_INFO_get_resource_groups(PyObject *obj, void *closure)
{
	struct PAC_LOGON_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_resource_groups;
	py_resource_groups = pytalloc_reference_ex(&PAC_DOMAIN_GROUP_MEMBERSHIP_Type, pytalloc_get_mem_ctx(obj), &object->resource_groups);
	return py_resource_groups;
}

static int py_PAC_LOGON_INFO_set_resource_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->resource_groups");
		return -1;
	}
	PY_CHECK_TYPE(&PAC_DOMAIN_GROUP_MEMBERSHIP_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->resource_groups = *(struct PAC_DOMAIN_GROUP_MEMBERSHIP *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_PAC_LOGON_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "info3"),
		.get = py_PAC_LOGON_INFO_get_info3,
		.set = py_PAC_LOGON_INFO_set_info3,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SamInfo3")
	},
	{
		.name = discard_const_p(char, "resource_groups"),
		.get = py_PAC_LOGON_INFO_get_resource_groups,
		.set = py_PAC_LOGON_INFO_set_resource_groups,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_DOMAIN_GROUP_MEMBERSHIP")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_LOGON_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_LOGON_INFO, type);
}


static PyTypeObject PAC_LOGON_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_LOGON_INFO",
	.tp_getset = py_PAC_LOGON_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_LOGON_INFO_new,
};


static PyObject *py_PAC_CREDENTIAL_NTLM_SECPKG_get_version(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_PAC_CREDENTIAL_NTLM_SECPKG_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_CREDENTIAL_NTLM_SECPKG_get_flags(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_PAC_CREDENTIAL_NTLM_SECPKG_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_CREDENTIAL_NTLM_SECPKG_get_lm_password(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_password;
	py_lm_password = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->lm_password);
	return py_lm_password;
}

static int py_PAC_CREDENTIAL_NTLM_SECPKG_set_lm_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_password");
		return -1;
	}
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lm_password = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_PAC_CREDENTIAL_NTLM_SECPKG_get_nt_password(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_password;
	py_nt_password = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->nt_password);
	return py_nt_password;
}

static int py_PAC_CREDENTIAL_NTLM_SECPKG_set_nt_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_password");
		return -1;
	}
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->nt_password = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_PAC_CREDENTIAL_NTLM_SECPKG_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_PAC_CREDENTIAL_NTLM_SECPKG_get_version,
		.set = py_PAC_CREDENTIAL_NTLM_SECPKG_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_PAC_CREDENTIAL_NTLM_SECPKG_get_flags,
		.set = py_PAC_CREDENTIAL_NTLM_SECPKG_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_CREDENTIAL_NTLM_FLAGS")
	},
	{
		.name = discard_const_p(char, "lm_password"),
		.get = py_PAC_CREDENTIAL_NTLM_SECPKG_get_lm_password,
		.set = py_PAC_CREDENTIAL_NTLM_SECPKG_set_lm_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{
		.name = discard_const_p(char, "nt_password"),
		.get = py_PAC_CREDENTIAL_NTLM_SECPKG_get_nt_password,
		.set = py_PAC_CREDENTIAL_NTLM_SECPKG_set_nt_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_CREDENTIAL_NTLM_SECPKG_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_CREDENTIAL_NTLM_SECPKG, type);
}

static PyObject *py_PAC_CREDENTIAL_NTLM_SECPKG_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_CREDENTIAL_NTLM_SECPKG);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_CREDENTIAL_NTLM_SECPKG_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_NTLM_SECPKG);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_NTLM_SECPKG);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_CREDENTIAL_NTLM_SECPKG_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_NTLM_SECPKG *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_NTLM_SECPKG, "PAC_CREDENTIAL_NTLM_SECPKG", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_NTLM_SECPKG, "PAC_CREDENTIAL_NTLM_SECPKG", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_CREDENTIAL_NTLM_SECPKG_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_CREDENTIAL_NTLM_SECPKG_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_NTLM_SECPKG_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_NTLM_SECPKG_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_CREDENTIAL_NTLM_SECPKG_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_CREDENTIAL_NTLM_SECPKG",
	.tp_getset = py_PAC_CREDENTIAL_NTLM_SECPKG_getsetters,
	.tp_methods = py_PAC_CREDENTIAL_NTLM_SECPKG_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_CREDENTIAL_NTLM_SECPKG_new,
};


static PyObject *py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_get_package_name(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *object = pytalloc_get_ptr(obj);
	PyObject *py_package_name;
	py_package_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->package_name);
	return py_package_name;
}

static int py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_set_package_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->package_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->package_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_get_credential_size(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *object = pytalloc_get_ptr(obj);
	PyObject *py_credential_size;
	py_credential_size = PyLong_FromUnsignedLongLong((uint32_t)(object->credential_size));
	return py_credential_size;
}

static int py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_set_credential_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->credential_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->credential_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->credential_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_get_credential(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *object = pytalloc_get_ptr(obj);
	PyObject *py_credential;
	if (object->credential == NULL) {
		Py_RETURN_NONE;
	}
	if (object->credential == NULL) {
		py_credential = Py_None;
		Py_INCREF(py_credential);
	} else {
		py_credential = PyList_New(object->credential_size);
		if (py_credential == NULL) {
			return NULL;
		}
		{
			int credential_cntr_1;
			for (credential_cntr_1 = 0; credential_cntr_1 < (object->credential_size); credential_cntr_1++) {
				PyObject *py_credential_1;
				py_credential_1 = PyLong_FromLong((uint16_t)((object->credential)[credential_cntr_1]));
				PyList_SetItem(py_credential, credential_cntr_1, py_credential_1);
			}
		}
	}
	return py_credential;
}

static int py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_set_credential(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->credential));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->credential");
		return -1;
	}
	if (value == Py_None) {
		object->credential = NULL;
	} else {
		object->credential = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int credential_cntr_1;
			object->credential = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->credential, PyList_GET_SIZE(value));
			if (!object->credential) { return -1; }
			talloc_set_name_const(object->credential, "ARRAY: object->credential");
			for (credential_cntr_1 = 0; credential_cntr_1 < PyList_GET_SIZE(value); credential_cntr_1++) {
				if (PyList_GET_ITEM(value, credential_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->credential)[credential_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->credential)[credential_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, credential_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, credential_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->credential)[credential_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_getsetters[] = {
	{
		.name = discard_const_p(char, "package_name"),
		.get = py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_get_package_name,
		.set = py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_set_package_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "credential_size"),
		.get = py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_get_credential_size,
		.set = py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_set_credential_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "credential"),
		.get = py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_get_credential,
		.set = py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_set_credential,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG, type);
}

static PyObject *py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG, "PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG, "PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG",
	.tp_getset = py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_getsetters,
	.tp_methods = py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_new,
};


static PyObject *py_PAC_CREDENTIAL_DATA_get_credential_count(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_DATA *object = pytalloc_get_ptr(obj);
	PyObject *py_credential_count;
	py_credential_count = PyLong_FromUnsignedLongLong((uint32_t)(object->credential_count));
	return py_credential_count;
}

static int py_PAC_CREDENTIAL_DATA_set_credential_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_DATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->credential_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->credential_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->credential_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_CREDENTIAL_DATA_get_credentials(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_DATA *object = pytalloc_get_ptr(obj);
	PyObject *py_credentials;
	py_credentials = PyList_New(object->credential_count);
	if (py_credentials == NULL) {
		return NULL;
	}
	{
		int credentials_cntr_0;
		for (credentials_cntr_0 = 0; credentials_cntr_0 < (object->credential_count); credentials_cntr_0++) {
			PyObject *py_credentials_0;
			py_credentials_0 = pytalloc_reference_ex(&PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_Type, object->credentials, &(object->credentials)[credentials_cntr_0]);
			PyList_SetItem(py_credentials, credentials_cntr_0, py_credentials_0);
		}
	}
	return py_credentials;
}

static int py_PAC_CREDENTIAL_DATA_set_credentials(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_DATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->credentials");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int credentials_cntr_0;
		object->credentials = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->credentials, PyList_GET_SIZE(value));
		if (!object->credentials) { return -1; }
		talloc_set_name_const(object->credentials, "ARRAY: object->credentials");
		for (credentials_cntr_0 = 0; credentials_cntr_0 < PyList_GET_SIZE(value); credentials_cntr_0++) {
			if (PyList_GET_ITEM(value, credentials_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->credentials)[credentials_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_Type, PyList_GET_ITEM(value, credentials_cntr_0), return -1;);
			if (talloc_reference(object->credentials, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, credentials_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->credentials)[credentials_cntr_0] = *(struct PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG *)pytalloc_get_ptr(PyList_GET_ITEM(value, credentials_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_CREDENTIAL_DATA_getsetters[] = {
	{
		.name = discard_const_p(char, "credential_count"),
		.get = py_PAC_CREDENTIAL_DATA_get_credential_count,
		.set = py_PAC_CREDENTIAL_DATA_set_credential_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "credentials"),
		.get = py_PAC_CREDENTIAL_DATA_get_credentials,
		.set = py_PAC_CREDENTIAL_DATA_set_credentials,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_CREDENTIAL_DATA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_CREDENTIAL_DATA, type);
}

static PyObject *py_PAC_CREDENTIAL_DATA_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_CREDENTIAL_DATA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_CREDENTIAL_DATA);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_CREDENTIAL_DATA_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_DATA *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_DATA);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_DATA);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_CREDENTIAL_DATA_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_DATA *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_DATA, "PAC_CREDENTIAL_DATA", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_DATA, "PAC_CREDENTIAL_DATA", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_CREDENTIAL_DATA_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_CREDENTIAL_DATA_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_DATA_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_DATA_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_CREDENTIAL_DATA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_CREDENTIAL_DATA",
	.tp_getset = py_PAC_CREDENTIAL_DATA_getsetters,
	.tp_methods = py_PAC_CREDENTIAL_DATA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_CREDENTIAL_DATA_new,
};


static PyObject *py_PAC_CREDENTIAL_DATA_CTR_get_data(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_DATA_CTR *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = pytalloc_reference_ex(&PAC_CREDENTIAL_DATA_Type, object->data, object->data);
	}
	return py_data;
}

static int py_PAC_CREDENTIAL_DATA_CTR_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_DATA_CTR *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PAC_CREDENTIAL_DATA_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->data = (struct PAC_CREDENTIAL_DATA *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_PAC_CREDENTIAL_DATA_CTR_getsetters[] = {
	{
		.name = discard_const_p(char, "data"),
		.get = py_PAC_CREDENTIAL_DATA_CTR_get_data,
		.set = py_PAC_CREDENTIAL_DATA_CTR_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_CREDENTIAL_DATA")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_CREDENTIAL_DATA_CTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_CREDENTIAL_DATA_CTR, type);
}

static PyObject *py_PAC_CREDENTIAL_DATA_CTR_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_CREDENTIAL_DATA_CTR *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_CREDENTIAL_DATA_CTR);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_CREDENTIAL_DATA_CTR_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_DATA_CTR *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_DATA_CTR);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_DATA_CTR);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_CREDENTIAL_DATA_CTR_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_DATA_CTR *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_DATA_CTR, "PAC_CREDENTIAL_DATA_CTR", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_DATA_CTR, "PAC_CREDENTIAL_DATA_CTR", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_CREDENTIAL_DATA_CTR_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_CREDENTIAL_DATA_CTR_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_DATA_CTR_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_DATA_CTR_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_CREDENTIAL_DATA_CTR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_CREDENTIAL_DATA_CTR",
	.tp_getset = py_PAC_CREDENTIAL_DATA_CTR_getsetters,
	.tp_methods = py_PAC_CREDENTIAL_DATA_CTR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_CREDENTIAL_DATA_CTR_new,
};


static PyObject *py_PAC_CREDENTIAL_DATA_NDR_get_ctr(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_DATA_NDR *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	py_ctr = pytalloc_reference_ex(&PAC_CREDENTIAL_DATA_CTR_Type, pytalloc_get_mem_ctx(obj), &object->ctr);
	return py_ctr;
}

static int py_PAC_CREDENTIAL_DATA_NDR_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_DATA_NDR *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctr");
		return -1;
	}
	PY_CHECK_TYPE(&PAC_CREDENTIAL_DATA_CTR_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ctr = *(struct PAC_CREDENTIAL_DATA_CTR *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_PAC_CREDENTIAL_DATA_NDR_getsetters[] = {
	{
		.name = discard_const_p(char, "ctr"),
		.get = py_PAC_CREDENTIAL_DATA_NDR_get_ctr,
		.set = py_PAC_CREDENTIAL_DATA_NDR_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_CREDENTIAL_DATA_CTR")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_CREDENTIAL_DATA_NDR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_CREDENTIAL_DATA_NDR, type);
}

static PyObject *py_PAC_CREDENTIAL_DATA_NDR_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_CREDENTIAL_DATA_NDR *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_CREDENTIAL_DATA_NDR);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_CREDENTIAL_DATA_NDR_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_DATA_NDR *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_DATA_NDR);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_DATA_NDR);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_CREDENTIAL_DATA_NDR_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_DATA_NDR *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_DATA_NDR, "PAC_CREDENTIAL_DATA_NDR", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_DATA_NDR, "PAC_CREDENTIAL_DATA_NDR", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_CREDENTIAL_DATA_NDR_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_CREDENTIAL_DATA_NDR_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_DATA_NDR_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_DATA_NDR_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_CREDENTIAL_DATA_NDR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_CREDENTIAL_DATA_NDR",
	.tp_getset = py_PAC_CREDENTIAL_DATA_NDR_getsetters,
	.tp_methods = py_PAC_CREDENTIAL_DATA_NDR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_CREDENTIAL_DATA_NDR_new,
};


static PyObject *py_PAC_CREDENTIAL_INFO_get_version(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_PAC_CREDENTIAL_INFO_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_CREDENTIAL_INFO_get_encryption_type(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_encryption_type;
	py_encryption_type = PyLong_FromUnsignedLongLong((uint32_t)(object->encryption_type));
	return py_encryption_type;
}

static int py_PAC_CREDENTIAL_INFO_set_encryption_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->encryption_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->encryption_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->encryption_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_CREDENTIAL_INFO_get_encrypted_data(PyObject *obj, void *closure)
{
	struct PAC_CREDENTIAL_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_encrypted_data;
	py_encrypted_data = PyBytes_FromStringAndSize((char *)(object->encrypted_data).data, (object->encrypted_data).length);
	return py_encrypted_data;
}

static int py_PAC_CREDENTIAL_INFO_set_encrypted_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CREDENTIAL_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->encrypted_data");
		return -1;
	}
	object->encrypted_data = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_PAC_CREDENTIAL_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_PAC_CREDENTIAL_INFO_get_version,
		.set = py_PAC_CREDENTIAL_INFO_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "encryption_type"),
		.get = py_PAC_CREDENTIAL_INFO_get_encryption_type,
		.set = py_PAC_CREDENTIAL_INFO_set_encryption_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "encrypted_data"),
		.get = py_PAC_CREDENTIAL_INFO_get_encrypted_data,
		.set = py_PAC_CREDENTIAL_INFO_set_encrypted_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_CREDENTIAL_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_CREDENTIAL_INFO, type);
}

static PyObject *py_PAC_CREDENTIAL_INFO_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_CREDENTIAL_INFO *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_CREDENTIAL_INFO);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_CREDENTIAL_INFO_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_INFO *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_INFO);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CREDENTIAL_INFO);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_CREDENTIAL_INFO_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CREDENTIAL_INFO *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_INFO, "PAC_CREDENTIAL_INFO", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CREDENTIAL_INFO, "PAC_CREDENTIAL_INFO", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_CREDENTIAL_INFO_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_CREDENTIAL_INFO_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_INFO_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CREDENTIAL_INFO_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_CREDENTIAL_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_CREDENTIAL_INFO",
	.tp_getset = py_PAC_CREDENTIAL_INFO_getsetters,
	.tp_methods = py_PAC_CREDENTIAL_INFO_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_CREDENTIAL_INFO_new,
};


static PyObject *py_PAC_CONSTRAINED_DELEGATION_get_proxy_target(PyObject *obj, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = pytalloc_get_ptr(obj);
	PyObject *py_proxy_target;
	py_proxy_target = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->proxy_target);
	return py_proxy_target;
}

static int py_PAC_CONSTRAINED_DELEGATION_set_proxy_target(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->proxy_target");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->proxy_target = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_PAC_CONSTRAINED_DELEGATION_get_num_transited_services(PyObject *obj, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = pytalloc_get_ptr(obj);
	PyObject *py_num_transited_services;
	py_num_transited_services = PyLong_FromUnsignedLongLong((uint32_t)(object->num_transited_services));
	return py_num_transited_services;
}

static int py_PAC_CONSTRAINED_DELEGATION_set_num_transited_services(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_transited_services");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_transited_services));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_transited_services = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_CONSTRAINED_DELEGATION_get_transited_services(PyObject *obj, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = pytalloc_get_ptr(obj);
	PyObject *py_transited_services;
	if (object->transited_services == NULL) {
		Py_RETURN_NONE;
	}
	if (object->transited_services == NULL) {
		py_transited_services = Py_None;
		Py_INCREF(py_transited_services);
	} else {
		py_transited_services = PyList_New(object->num_transited_services);
		if (py_transited_services == NULL) {
			return NULL;
		}
		{
			int transited_services_cntr_1;
			for (transited_services_cntr_1 = 0; transited_services_cntr_1 < (object->num_transited_services); transited_services_cntr_1++) {
				PyObject *py_transited_services_1;
				py_transited_services_1 = pytalloc_reference_ex(lsa_String_Type, object->transited_services, &(object->transited_services)[transited_services_cntr_1]);
				PyList_SetItem(py_transited_services, transited_services_cntr_1, py_transited_services_1);
			}
		}
	}
	return py_transited_services;
}

static int py_PAC_CONSTRAINED_DELEGATION_set_transited_services(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->transited_services));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->transited_services");
		return -1;
	}
	if (value == Py_None) {
		object->transited_services = NULL;
	} else {
		object->transited_services = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int transited_services_cntr_1;
			object->transited_services = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->transited_services, PyList_GET_SIZE(value));
			if (!object->transited_services) { return -1; }
			talloc_set_name_const(object->transited_services, "ARRAY: object->transited_services");
			for (transited_services_cntr_1 = 0; transited_services_cntr_1 < PyList_GET_SIZE(value); transited_services_cntr_1++) {
				if (PyList_GET_ITEM(value, transited_services_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->transited_services)[transited_services_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, transited_services_cntr_1), return -1;);
				if (talloc_reference(object->transited_services, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, transited_services_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->transited_services)[transited_services_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, transited_services_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_CONSTRAINED_DELEGATION_getsetters[] = {
	{
		.name = discard_const_p(char, "proxy_target"),
		.get = py_PAC_CONSTRAINED_DELEGATION_get_proxy_target,
		.set = py_PAC_CONSTRAINED_DELEGATION_set_proxy_target,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "num_transited_services"),
		.get = py_PAC_CONSTRAINED_DELEGATION_get_num_transited_services,
		.set = py_PAC_CONSTRAINED_DELEGATION_set_num_transited_services,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "transited_services"),
		.get = py_PAC_CONSTRAINED_DELEGATION_get_transited_services,
		.set = py_PAC_CONSTRAINED_DELEGATION_set_transited_services,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_CONSTRAINED_DELEGATION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_CONSTRAINED_DELEGATION, type);
}


static PyTypeObject PAC_CONSTRAINED_DELEGATION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_CONSTRAINED_DELEGATION",
	.tp_getset = py_PAC_CONSTRAINED_DELEGATION_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_CONSTRAINED_DELEGATION_new,
};


static PyObject *py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_get_samaccountname_size(PyObject *obj, void *closure)
{
	struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *object = pytalloc_get_ptr(obj);
	PyObject *py_samaccountname_size;
	py_samaccountname_size = PyLong_FromLong((uint16_t)(object->samaccountname_size));
	return py_samaccountname_size;
}

static int py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_set_samaccountname_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->samaccountname_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->samaccountname_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->samaccountname_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_get_samaccountname(PyObject *obj, void *closure)
{
	struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *object = pytalloc_get_ptr(obj);
	PyObject *py_samaccountname;
	if (object->samaccountname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->samaccountname == NULL) {
		py_samaccountname = Py_None;
		Py_INCREF(py_samaccountname);
	} else {
		py_samaccountname = PyString_FromStringOrNULL(object->samaccountname);
	}
	return py_samaccountname;
}

static int py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_set_samaccountname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->samaccountname));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->samaccountname");
		return -1;
	}
	if (value == Py_None) {
		object->samaccountname = NULL;
	} else {
		object->samaccountname = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->samaccountname = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_get_objectsid_size(PyObject *obj, void *closure)
{
	struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *object = pytalloc_get_ptr(obj);
	PyObject *py_objectsid_size;
	py_objectsid_size = PyLong_FromLong((uint16_t)(object->objectsid_size));
	return py_objectsid_size;
}

static int py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_set_objectsid_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->objectsid_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->objectsid_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->objectsid_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_get_objectsid(PyObject *obj, void *closure)
{
	struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *object = pytalloc_get_ptr(obj);
	PyObject *py_objectsid;
	if (object->objectsid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->objectsid == NULL) {
		py_objectsid = Py_None;
		Py_INCREF(py_objectsid);
	} else {
		py_objectsid = pytalloc_reference_ex(dom_sid_Type, object->objectsid, object->objectsid);
	}
	return py_objectsid;
}

static int py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_set_objectsid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->objectsid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->objectsid");
		return -1;
	}
	if (value == Py_None) {
		object->objectsid = NULL;
	} else {
		object->objectsid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->objectsid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_getsetters[] = {
	{
		.name = discard_const_p(char, "samaccountname_size"),
		.get = py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_get_samaccountname_size,
		.set = py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_set_samaccountname_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "samaccountname"),
		.get = py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_get_samaccountname,
		.set = py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_set_samaccountname,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "objectsid_size"),
		.get = py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_get_objectsid_size,
		.set = py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_set_objectsid_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "objectsid"),
		.get = py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_get_objectsid,
		.set = py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_set_objectsid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID, type);
}


static PyTypeObject PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_UPN_DNS_INFO_SAM_NAME_AND_SID",
	.tp_getset = py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_new,
};

static PyObject *py_import_PAC_UPN_DNS_INFO_EX(TALLOC_CTX *mem_ctx, int level, union PAC_UPN_DNS_INFO_EX *in)
{
	PyObject *ret;

	switch (level) {
		case PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID:
			ret = pytalloc_reference_ex(&PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_Type, mem_ctx, &in->sam_name_and_sid);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union PAC_UPN_DNS_INFO_EX *py_export_PAC_UPN_DNS_INFO_EX(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union PAC_UPN_DNS_INFO_EX *ret = talloc_zero(mem_ctx, union PAC_UPN_DNS_INFO_EX);
	switch (level) {
		case PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sam_name_and_sid");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->sam_name_and_sid = *(struct PAC_UPN_DNS_INFO_SAM_NAME_AND_SID *)pytalloc_get_ptr(in);
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_PAC_UPN_DNS_INFO_EX_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union PAC_UPN_DNS_INFO_EX *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union PAC_UPN_DNS_INFO_EX *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union PAC_UPN_DNS_INFO_EX!");
		return NULL;
	}

	return py_import_PAC_UPN_DNS_INFO_EX(mem_ctx, level, in);
}

static PyObject *py_PAC_UPN_DNS_INFO_EX_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union PAC_UPN_DNS_INFO_EX *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_PAC_UPN_DNS_INFO_EX(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_PAC_UPN_DNS_INFO_EX_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_UPN_DNS_INFO_EX_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_UPN_DNS_INFO_EX_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_PAC_UPN_DNS_INFO_EX_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject PAC_UPN_DNS_INFO_EX_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_UPN_DNS_INFO_EX",
	.tp_getset = NULL,
	.tp_methods = py_PAC_UPN_DNS_INFO_EX_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_UPN_DNS_INFO_EX_new,
};


static PyObject *py_PAC_UPN_DNS_INFO_get_upn_name_size(PyObject *obj, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_upn_name_size;
	py_upn_name_size = PyLong_FromLong((uint16_t)(object->upn_name_size));
	return py_upn_name_size;
}

static int py_PAC_UPN_DNS_INFO_set_upn_name_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->upn_name_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->upn_name_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->upn_name_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_UPN_DNS_INFO_get_upn_name(PyObject *obj, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_upn_name;
	if (object->upn_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->upn_name == NULL) {
		py_upn_name = Py_None;
		Py_INCREF(py_upn_name);
	} else {
		py_upn_name = PyString_FromStringOrNULL(object->upn_name);
	}
	return py_upn_name;
}

static int py_PAC_UPN_DNS_INFO_set_upn_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->upn_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->upn_name");
		return -1;
	}
	if (value == Py_None) {
		object->upn_name = NULL;
	} else {
		object->upn_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->upn_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_PAC_UPN_DNS_INFO_get_dns_domain_name_size(PyObject *obj, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domain_name_size;
	py_dns_domain_name_size = PyLong_FromLong((uint16_t)(object->dns_domain_name_size));
	return py_dns_domain_name_size;
}

static int py_PAC_UPN_DNS_INFO_set_dns_domain_name_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_domain_name_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dns_domain_name_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dns_domain_name_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_UPN_DNS_INFO_get_dns_domain_name(PyObject *obj, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domain_name;
	if (object->dns_domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_domain_name == NULL) {
		py_dns_domain_name = Py_None;
		Py_INCREF(py_dns_domain_name);
	} else {
		py_dns_domain_name = PyString_FromStringOrNULL(object->dns_domain_name);
	}
	return py_dns_domain_name;
}

static int py_PAC_UPN_DNS_INFO_set_dns_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->dns_domain_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->dns_domain_name = NULL;
	} else {
		object->dns_domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_PAC_UPN_DNS_INFO_get_flags(PyObject *obj, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_PAC_UPN_DNS_INFO_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_UPN_DNS_INFO_get_ex(PyObject *obj, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_ex;
	py_ex = pyrpc_import_union(&PAC_UPN_DNS_INFO_EX_Type, pytalloc_get_mem_ctx(obj), object->flags & PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID, &object->ex, "union PAC_UPN_DNS_INFO_EX");
	if (py_ex == NULL) {
		return NULL;
	}
	return py_ex;
}

static int py_PAC_UPN_DNS_INFO_set_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UPN_DNS_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ex");
		return -1;
	}
	{
		union PAC_UPN_DNS_INFO_EX *ex_switch_0;
		ex_switch_0 = (union PAC_UPN_DNS_INFO_EX *)pyrpc_export_union(&PAC_UPN_DNS_INFO_EX_Type, pytalloc_get_mem_ctx(py_obj), object->flags & PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID, value, "union PAC_UPN_DNS_INFO_EX");
		if (ex_switch_0 == NULL) {
			return -1;
		}
		object->ex = *ex_switch_0;
	}
	return 0;
}

static PyGetSetDef py_PAC_UPN_DNS_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "upn_name_size"),
		.get = py_PAC_UPN_DNS_INFO_get_upn_name_size,
		.set = py_PAC_UPN_DNS_INFO_set_upn_name_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "upn_name"),
		.get = py_PAC_UPN_DNS_INFO_get_upn_name,
		.set = py_PAC_UPN_DNS_INFO_set_upn_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "dns_domain_name_size"),
		.get = py_PAC_UPN_DNS_INFO_get_dns_domain_name_size,
		.set = py_PAC_UPN_DNS_INFO_set_dns_domain_name_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dns_domain_name"),
		.get = py_PAC_UPN_DNS_INFO_get_dns_domain_name,
		.set = py_PAC_UPN_DNS_INFO_set_dns_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_PAC_UPN_DNS_INFO_get_flags,
		.set = py_PAC_UPN_DNS_INFO_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_UPN_DNS_FLAGS")
	},
	{
		.name = discard_const_p(char, "ex"),
		.get = py_PAC_UPN_DNS_INFO_get_ex,
		.set = py_PAC_UPN_DNS_INFO_set_ex,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_UPN_DNS_INFO_EX")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_UPN_DNS_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_UPN_DNS_INFO, type);
}


static PyTypeObject PAC_UPN_DNS_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_UPN_DNS_INFO",
	.tp_getset = py_PAC_UPN_DNS_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_UPN_DNS_INFO_new,
};


static PyObject *py_PAC_ATTRIBUTES_INFO_get_flags_length(PyObject *obj, void *closure)
{
	struct PAC_ATTRIBUTES_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_flags_length;
	py_flags_length = PyLong_FromUnsignedLongLong((uint32_t)(object->flags_length));
	return py_flags_length;
}

static int py_PAC_ATTRIBUTES_INFO_set_flags_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_ATTRIBUTES_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_ATTRIBUTES_INFO_get_flags(PyObject *obj, void *closure)
{
	struct PAC_ATTRIBUTES_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_PAC_ATTRIBUTES_INFO_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_ATTRIBUTES_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_ATTRIBUTES_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "flags_length"),
		.get = py_PAC_ATTRIBUTES_INFO_get_flags_length,
		.set = py_PAC_ATTRIBUTES_INFO_set_flags_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_PAC_ATTRIBUTES_INFO_get_flags,
		.set = py_PAC_ATTRIBUTES_INFO_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_ATTRIBUTE_INFO_FLAGS")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_ATTRIBUTES_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_ATTRIBUTES_INFO, type);
}


static PyTypeObject PAC_ATTRIBUTES_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_ATTRIBUTES_INFO",
	.tp_getset = py_PAC_ATTRIBUTES_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_ATTRIBUTES_INFO_new,
};


static PyObject *py_PAC_REQUESTER_SID_get_sid(PyObject *obj, void *closure)
{
	struct PAC_REQUESTER_SID *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_PAC_REQUESTER_SID_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_REQUESTER_SID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_PAC_REQUESTER_SID_getsetters[] = {
	{
		.name = discard_const_p(char, "sid"),
		.get = py_PAC_REQUESTER_SID_get_sid,
		.set = py_PAC_REQUESTER_SID_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_REQUESTER_SID_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_REQUESTER_SID, type);
}


static PyTypeObject PAC_REQUESTER_SID_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_REQUESTER_SID",
	.tp_getset = py_PAC_REQUESTER_SID_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_REQUESTER_SID_new,
};


static PyObject *py_PAC_LOGON_INFO_CTR_get_info(PyObject *obj, void *closure)
{
	struct PAC_LOGON_INFO_CTR *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&PAC_LOGON_INFO_Type, object->info, object->info);
	}
	return py_info;
}

static int py_PAC_LOGON_INFO_CTR_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_INFO_CTR *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&PAC_LOGON_INFO_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct PAC_LOGON_INFO *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_PAC_LOGON_INFO_CTR_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_PAC_LOGON_INFO_CTR_get_info,
		.set = py_PAC_LOGON_INFO_CTR_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_LOGON_INFO")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_LOGON_INFO_CTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_LOGON_INFO_CTR, type);
}

static PyObject *py_PAC_LOGON_INFO_CTR_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_LOGON_INFO_CTR *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_LOGON_INFO_CTR);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_LOGON_INFO_CTR_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_LOGON_INFO_CTR *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_LOGON_INFO_CTR);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_LOGON_INFO_CTR);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_LOGON_INFO_CTR_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_LOGON_INFO_CTR *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_LOGON_INFO_CTR, "PAC_LOGON_INFO_CTR", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_LOGON_INFO_CTR, "PAC_LOGON_INFO_CTR", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_LOGON_INFO_CTR_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_LOGON_INFO_CTR_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_LOGON_INFO_CTR_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_LOGON_INFO_CTR_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_LOGON_INFO_CTR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_LOGON_INFO_CTR",
	.tp_getset = py_PAC_LOGON_INFO_CTR_getsetters,
	.tp_methods = py_PAC_LOGON_INFO_CTR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_LOGON_INFO_CTR_new,
};


static PyObject *py_PAC_CONSTRAINED_DELEGATION_CTR_get_info(PyObject *obj, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION_CTR *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&PAC_CONSTRAINED_DELEGATION_Type, object->info, object->info);
	}
	return py_info;
}

static int py_PAC_CONSTRAINED_DELEGATION_CTR_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION_CTR *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&PAC_CONSTRAINED_DELEGATION_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct PAC_CONSTRAINED_DELEGATION *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_PAC_CONSTRAINED_DELEGATION_CTR_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_PAC_CONSTRAINED_DELEGATION_CTR_get_info,
		.set = py_PAC_CONSTRAINED_DELEGATION_CTR_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_CONSTRAINED_DELEGATION")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_CONSTRAINED_DELEGATION_CTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_CONSTRAINED_DELEGATION_CTR, type);
}

static PyObject *py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_CONSTRAINED_DELEGATION_CTR *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_CONSTRAINED_DELEGATION_CTR);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CONSTRAINED_DELEGATION_CTR *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CONSTRAINED_DELEGATION_CTR);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CONSTRAINED_DELEGATION_CTR);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CONSTRAINED_DELEGATION_CTR *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CONSTRAINED_DELEGATION_CTR, "PAC_CONSTRAINED_DELEGATION_CTR", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CONSTRAINED_DELEGATION_CTR, "PAC_CONSTRAINED_DELEGATION_CTR", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_CONSTRAINED_DELEGATION_CTR_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_CONSTRAINED_DELEGATION_CTR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_CONSTRAINED_DELEGATION_CTR",
	.tp_getset = py_PAC_CONSTRAINED_DELEGATION_CTR_getsetters,
	.tp_methods = py_PAC_CONSTRAINED_DELEGATION_CTR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_CONSTRAINED_DELEGATION_CTR_new,
};


static PyObject *py_PAC_DEVICE_INFO_get_rid(PyObject *obj, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_PAC_DEVICE_INFO_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_DEVICE_INFO_get_primary_gid(PyObject *obj, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyLong_FromUnsignedLongLong((uint32_t)(object->primary_gid));
	return py_primary_gid;
}

static int py_PAC_DEVICE_INFO_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->primary_gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->primary_gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_DEVICE_INFO_get_domain_sid(PyObject *obj, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->domain_sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_sid == NULL) {
		py_domain_sid = Py_None;
		Py_INCREF(py_domain_sid);
	} else {
		py_domain_sid = pytalloc_reference_ex(dom_sid_Type, object->domain_sid, object->domain_sid);
	}
	return py_domain_sid;
}

static int py_PAC_DEVICE_INFO_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->domain_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_sid");
		return -1;
	}
	if (value == Py_None) {
		object->domain_sid = NULL;
	} else {
		object->domain_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_PAC_DEVICE_INFO_get_groups(PyObject *obj, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_groups;
	py_groups = pytalloc_reference_ex(samr_RidWithAttributeArray_Type, pytalloc_get_mem_ctx(obj), &object->groups);
	return py_groups;
}

static int py_PAC_DEVICE_INFO_set_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->groups");
		return -1;
	}
	PY_CHECK_TYPE(samr_RidWithAttributeArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->groups = *(struct samr_RidWithAttributeArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_PAC_DEVICE_INFO_get_sid_count(PyObject *obj, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_count;
	py_sid_count = PyLong_FromUnsignedLongLong((uint32_t)(object->sid_count));
	return py_sid_count;
}

static int py_PAC_DEVICE_INFO_set_sid_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_DEVICE_INFO_get_sids(PyObject *obj, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->sid_count);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < (object->sid_count); sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(netr_SidAttr_Type, object->sids, &(object->sids)[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_PAC_DEVICE_INFO_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sids");
		return -1;
	}
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				if (PyList_GET_ITEM(value, sids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->sids)[sids_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(netr_SidAttr_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sids)[sids_cntr_1] = *(struct netr_SidAttr *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_PAC_DEVICE_INFO_get_domain_group_count(PyObject *obj, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_group_count;
	py_domain_group_count = PyLong_FromUnsignedLongLong((uint32_t)(object->domain_group_count));
	return py_domain_group_count;
}

static int py_PAC_DEVICE_INFO_set_domain_group_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_group_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->domain_group_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->domain_group_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_DEVICE_INFO_get_domain_groups(PyObject *obj, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_groups;
	if (object->domain_groups == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_groups == NULL) {
		py_domain_groups = Py_None;
		Py_INCREF(py_domain_groups);
	} else {
		py_domain_groups = PyList_New(object->domain_group_count);
		if (py_domain_groups == NULL) {
			return NULL;
		}
		{
			int domain_groups_cntr_1;
			for (domain_groups_cntr_1 = 0; domain_groups_cntr_1 < (object->domain_group_count); domain_groups_cntr_1++) {
				PyObject *py_domain_groups_1;
				py_domain_groups_1 = pytalloc_reference_ex(&PAC_DOMAIN_GROUP_MEMBERSHIP_Type, object->domain_groups, &(object->domain_groups)[domain_groups_cntr_1]);
				PyList_SetItem(py_domain_groups, domain_groups_cntr_1, py_domain_groups_1);
			}
		}
	}
	return py_domain_groups;
}

static int py_PAC_DEVICE_INFO_set_domain_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DEVICE_INFO *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->domain_groups));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_groups");
		return -1;
	}
	if (value == Py_None) {
		object->domain_groups = NULL;
	} else {
		object->domain_groups = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int domain_groups_cntr_1;
			object->domain_groups = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->domain_groups, PyList_GET_SIZE(value));
			if (!object->domain_groups) { return -1; }
			talloc_set_name_const(object->domain_groups, "ARRAY: object->domain_groups");
			for (domain_groups_cntr_1 = 0; domain_groups_cntr_1 < PyList_GET_SIZE(value); domain_groups_cntr_1++) {
				if (PyList_GET_ITEM(value, domain_groups_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->domain_groups)[domain_groups_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&PAC_DOMAIN_GROUP_MEMBERSHIP_Type, PyList_GET_ITEM(value, domain_groups_cntr_1), return -1;);
				if (talloc_reference(object->domain_groups, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, domain_groups_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->domain_groups)[domain_groups_cntr_1] = *(struct PAC_DOMAIN_GROUP_MEMBERSHIP *)pytalloc_get_ptr(PyList_GET_ITEM(value, domain_groups_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_DEVICE_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "rid"),
		.get = py_PAC_DEVICE_INFO_get_rid,
		.set = py_PAC_DEVICE_INFO_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "primary_gid"),
		.get = py_PAC_DEVICE_INFO_get_primary_gid,
		.set = py_PAC_DEVICE_INFO_set_primary_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "domain_sid"),
		.get = py_PAC_DEVICE_INFO_get_domain_sid,
		.set = py_PAC_DEVICE_INFO_set_domain_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "groups"),
		.get = py_PAC_DEVICE_INFO_get_groups,
		.set = py_PAC_DEVICE_INFO_set_groups,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_RidWithAttributeArray")
	},
	{
		.name = discard_const_p(char, "sid_count"),
		.get = py_PAC_DEVICE_INFO_get_sid_count,
		.set = py_PAC_DEVICE_INFO_set_sid_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_PAC_DEVICE_INFO_get_sids,
		.set = py_PAC_DEVICE_INFO_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SidAttr")
	},
	{
		.name = discard_const_p(char, "domain_group_count"),
		.get = py_PAC_DEVICE_INFO_get_domain_group_count,
		.set = py_PAC_DEVICE_INFO_set_domain_group_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "domain_groups"),
		.get = py_PAC_DEVICE_INFO_get_domain_groups,
		.set = py_PAC_DEVICE_INFO_set_domain_groups,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_DOMAIN_GROUP_MEMBERSHIP")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_DEVICE_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_DEVICE_INFO, type);
}


static PyTypeObject PAC_DEVICE_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_DEVICE_INFO",
	.tp_getset = py_PAC_DEVICE_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_DEVICE_INFO_new,
};


static PyObject *py_PAC_DEVICE_INFO_CTR_get_info(PyObject *obj, void *closure)
{
	struct PAC_DEVICE_INFO_CTR *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&PAC_DEVICE_INFO_Type, object->info, object->info);
	}
	return py_info;
}

static int py_PAC_DEVICE_INFO_CTR_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DEVICE_INFO_CTR *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&PAC_DEVICE_INFO_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct PAC_DEVICE_INFO *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_PAC_DEVICE_INFO_CTR_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_PAC_DEVICE_INFO_CTR_get_info,
		.set = py_PAC_DEVICE_INFO_CTR_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_DEVICE_INFO")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_DEVICE_INFO_CTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_DEVICE_INFO_CTR, type);
}


static PyTypeObject PAC_DEVICE_INFO_CTR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_DEVICE_INFO_CTR",
	.tp_getset = py_PAC_DEVICE_INFO_CTR_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_DEVICE_INFO_CTR_new,
};


static PyObject *py_DATA_BLOB_REM_get_remaining(PyObject *obj, void *closure)
{
	struct DATA_BLOB_REM *object = pytalloc_get_ptr(obj);
	PyObject *py_remaining;
	py_remaining = PyBytes_FromStringAndSize((char *)(object->remaining).data, (object->remaining).length);
	return py_remaining;
}

static int py_DATA_BLOB_REM_set_remaining(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DATA_BLOB_REM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remaining");
		return -1;
	}
	object->remaining = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_DATA_BLOB_REM_getsetters[] = {
	{
		.name = discard_const_p(char, "remaining"),
		.get = py_DATA_BLOB_REM_get_remaining,
		.set = py_DATA_BLOB_REM_set_remaining,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_DATA_BLOB_REM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DATA_BLOB_REM, type);
}


static PyTypeObject DATA_BLOB_REM_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.DATA_BLOB_REM",
	.tp_getset = py_DATA_BLOB_REM_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DATA_BLOB_REM_new,
};

static PyObject *py_import_PAC_INFO(TALLOC_CTX *mem_ctx, int level, union PAC_INFO *in)
{
	PyObject *ret;

	switch (level) {
		case PAC_TYPE_LOGON_INFO:
			ret = pytalloc_reference_ex(&PAC_LOGON_INFO_CTR_Type, mem_ctx, &in->logon_info);
			return ret;

		case PAC_TYPE_CREDENTIAL_INFO:
			ret = pytalloc_reference_ex(&PAC_CREDENTIAL_INFO_Type, mem_ctx, &in->credential_info);
			return ret;

		case PAC_TYPE_SRV_CHECKSUM:
			ret = pytalloc_reference_ex(&PAC_SIGNATURE_DATA_Type, mem_ctx, &in->srv_cksum);
			return ret;

		case PAC_TYPE_KDC_CHECKSUM:
			ret = pytalloc_reference_ex(&PAC_SIGNATURE_DATA_Type, mem_ctx, &in->kdc_cksum);
			return ret;

		case PAC_TYPE_LOGON_NAME:
			ret = pytalloc_reference_ex(&PAC_LOGON_NAME_Type, mem_ctx, &in->logon_name);
			return ret;

		case PAC_TYPE_CONSTRAINED_DELEGATION:
			ret = pytalloc_reference_ex(&PAC_CONSTRAINED_DELEGATION_CTR_Type, mem_ctx, &in->constrained_delegation);
			return ret;

		case PAC_TYPE_UPN_DNS_INFO:
			ret = pytalloc_reference_ex(&PAC_UPN_DNS_INFO_Type, mem_ctx, &in->upn_dns_info);
			return ret;

		case PAC_TYPE_TICKET_CHECKSUM:
			ret = pytalloc_reference_ex(&PAC_SIGNATURE_DATA_Type, mem_ctx, &in->ticket_checksum);
			return ret;

		case PAC_TYPE_ATTRIBUTES_INFO:
			ret = pytalloc_reference_ex(&PAC_ATTRIBUTES_INFO_Type, mem_ctx, &in->attributes_info);
			return ret;

		case PAC_TYPE_REQUESTER_SID:
			ret = pytalloc_reference_ex(&PAC_REQUESTER_SID_Type, mem_ctx, &in->requester_sid);
			return ret;

		case PAC_TYPE_CLIENT_CLAIMS_INFO:
			ret = pytalloc_reference_ex(&DATA_BLOB_REM_Type, mem_ctx, &in->client_claims_info);
			return ret;

		case PAC_TYPE_DEVICE_INFO:
			ret = pytalloc_reference_ex(&PAC_DEVICE_INFO_CTR_Type, mem_ctx, &in->device_info);
			return ret;

		case PAC_TYPE_DEVICE_CLAIMS_INFO:
			ret = pytalloc_reference_ex(&DATA_BLOB_REM_Type, mem_ctx, &in->device_claims_info);
			return ret;

		case PAC_TYPE_FULL_CHECKSUM:
			ret = pytalloc_reference_ex(&PAC_SIGNATURE_DATA_Type, mem_ctx, &in->full_checksum);
			return ret;

		default:
			ret = pytalloc_reference_ex(&DATA_BLOB_REM_Type, mem_ctx, &in->unknown);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union PAC_INFO *py_export_PAC_INFO(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union PAC_INFO *ret = talloc_zero(mem_ctx, union PAC_INFO);
	switch (level) {
		case PAC_TYPE_LOGON_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->logon_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_LOGON_INFO_CTR_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->logon_info = *(struct PAC_LOGON_INFO_CTR *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_CREDENTIAL_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->credential_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_CREDENTIAL_INFO_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->credential_info = *(struct PAC_CREDENTIAL_INFO *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_SRV_CHECKSUM:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->srv_cksum");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_SIGNATURE_DATA_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->srv_cksum = *(struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_KDC_CHECKSUM:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->kdc_cksum");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_SIGNATURE_DATA_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->kdc_cksum = *(struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_LOGON_NAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->logon_name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_LOGON_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->logon_name = *(struct PAC_LOGON_NAME *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_CONSTRAINED_DELEGATION:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->constrained_delegation");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_CONSTRAINED_DELEGATION_CTR_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->constrained_delegation = *(struct PAC_CONSTRAINED_DELEGATION_CTR *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_UPN_DNS_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->upn_dns_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_UPN_DNS_INFO_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->upn_dns_info = *(struct PAC_UPN_DNS_INFO *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_TICKET_CHECKSUM:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ticket_checksum");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_SIGNATURE_DATA_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ticket_checksum = *(struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_ATTRIBUTES_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->attributes_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_ATTRIBUTES_INFO_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->attributes_info = *(struct PAC_ATTRIBUTES_INFO *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_REQUESTER_SID:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->requester_sid");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_REQUESTER_SID_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->requester_sid = *(struct PAC_REQUESTER_SID *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_CLIENT_CLAIMS_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->client_claims_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DATA_BLOB_REM_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->client_claims_info = *(struct DATA_BLOB_REM *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_DEVICE_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->device_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_DEVICE_INFO_CTR_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->device_info = *(struct PAC_DEVICE_INFO_CTR *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_DEVICE_CLAIMS_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->device_claims_info");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DATA_BLOB_REM_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->device_claims_info = *(struct DATA_BLOB_REM *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_FULL_CHECKSUM:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->full_checksum");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PAC_SIGNATURE_DATA_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->full_checksum = *(struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->unknown");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DATA_BLOB_REM_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->unknown = *(struct DATA_BLOB_REM *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}

static PyObject *py_PAC_INFO_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union PAC_INFO *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union PAC_INFO *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union PAC_INFO!");
		return NULL;
	}

	return py_import_PAC_INFO(mem_ctx, level, in);
}

static PyObject *py_PAC_INFO_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union PAC_INFO *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_PAC_INFO(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_PAC_INFO_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_INFO_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_INFO_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_PAC_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject PAC_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_INFO",
	.tp_getset = NULL,
	.tp_methods = py_PAC_INFO_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_INFO_new,
};


static PyObject *py_PAC_BUFFER_get_type(PyObject *obj, void *closure)
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_PAC_BUFFER_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_BUFFER_get__ndr_size(PyObject *obj, void *closure)
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(obj);
	PyObject *py__ndr_size;
	py__ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->_ndr_size));
	return py__ndr_size;
}

static int py_PAC_BUFFER_set__ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->_ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->_ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_BUFFER_get_info(PyObject *obj, void *closure)
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&PAC_INFO_Type, object->info, object->type, object->info, "union PAC_INFO");
		if (py_info == NULL) {
			return NULL;
		}
	}
	return py_info;
}

static int py_PAC_BUFFER_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		{
			union PAC_INFO *info_switch_2;
			info_switch_2 = (union PAC_INFO *)pyrpc_export_union(&PAC_INFO_Type, pytalloc_get_mem_ctx(py_obj), object->type, value, "union PAC_INFO");
			if (info_switch_2 == NULL) {
				return -1;
			}
			object->info = info_switch_2;
		}
	}
	return 0;
}

static PyObject *py_PAC_BUFFER_get__pad(PyObject *obj, void *closure)
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyLong_FromUnsignedLongLong((uint32_t)(object->_pad));
	return py__pad;
}

static int py_PAC_BUFFER_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->_pad));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->_pad = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_BUFFER_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_PAC_BUFFER_get_type,
		.set = py_PAC_BUFFER_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_TYPE")
	},
	{
		.name = discard_const_p(char, "_ndr_size"),
		.get = py_PAC_BUFFER_get__ndr_size,
		.set = py_PAC_BUFFER_set__ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_PAC_BUFFER_get_info,
		.set = py_PAC_BUFFER_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_INFO")
	},
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_PAC_BUFFER_get__pad,
		.set = py_PAC_BUFFER_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_BUFFER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_BUFFER, type);
}

static PyObject *py_PAC_BUFFER_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_BUFFER);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_BUFFER_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_BUFFER);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_BUFFER);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_BUFFER_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_BUFFER *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_BUFFER, "PAC_BUFFER", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_BUFFER, "PAC_BUFFER", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_BUFFER_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_BUFFER_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_BUFFER_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_BUFFER_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_BUFFER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_BUFFER",
	.tp_getset = py_PAC_BUFFER_getsetters,
	.tp_methods = py_PAC_BUFFER_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_BUFFER_new,
};


static PyObject *py_PAC_DATA_get_num_buffers(PyObject *obj, void *closure)
{
	struct PAC_DATA *object = pytalloc_get_ptr(obj);
	PyObject *py_num_buffers;
	py_num_buffers = PyLong_FromUnsignedLongLong((uint32_t)(object->num_buffers));
	return py_num_buffers;
}

static int py_PAC_DATA_set_num_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_buffers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_buffers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_buffers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_DATA_get_version(PyObject *obj, void *closure)
{
	struct PAC_DATA *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_PAC_DATA_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_DATA_get_buffers(PyObject *obj, void *closure)
{
	struct PAC_DATA *object = pytalloc_get_ptr(obj);
	PyObject *py_buffers;
	py_buffers = PyList_New(object->num_buffers);
	if (py_buffers == NULL) {
		return NULL;
	}
	{
		int buffers_cntr_0;
		for (buffers_cntr_0 = 0; buffers_cntr_0 < (object->num_buffers); buffers_cntr_0++) {
			PyObject *py_buffers_0;
			py_buffers_0 = pytalloc_reference_ex(&PAC_BUFFER_Type, object->buffers, &(object->buffers)[buffers_cntr_0]);
			PyList_SetItem(py_buffers, buffers_cntr_0, py_buffers_0);
		}
	}
	return py_buffers;
}

static int py_PAC_DATA_set_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buffers");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int buffers_cntr_0;
		object->buffers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffers, PyList_GET_SIZE(value));
		if (!object->buffers) { return -1; }
		talloc_set_name_const(object->buffers, "ARRAY: object->buffers");
		for (buffers_cntr_0 = 0; buffers_cntr_0 < PyList_GET_SIZE(value); buffers_cntr_0++) {
			if (PyList_GET_ITEM(value, buffers_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->buffers)[buffers_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&PAC_BUFFER_Type, PyList_GET_ITEM(value, buffers_cntr_0), return -1;);
			if (talloc_reference(object->buffers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, buffers_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->buffers)[buffers_cntr_0] = *(struct PAC_BUFFER *)pytalloc_get_ptr(PyList_GET_ITEM(value, buffers_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_DATA_getsetters[] = {
	{
		.name = discard_const_p(char, "num_buffers"),
		.get = py_PAC_DATA_get_num_buffers,
		.set = py_PAC_DATA_set_num_buffers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_PAC_DATA_get_version,
		.set = py_PAC_DATA_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "buffers"),
		.get = py_PAC_DATA_get_buffers,
		.set = py_PAC_DATA_set_buffers,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_BUFFER")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_DATA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_DATA, type);
}

static PyObject *py_PAC_DATA_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_DATA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_DATA);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_DATA_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_DATA *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_DATA);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_DATA);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_DATA_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_DATA *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_DATA, "PAC_DATA", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_DATA, "PAC_DATA", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_DATA_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_DATA_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_DATA_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_DATA_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_DATA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_DATA",
	.tp_getset = py_PAC_DATA_getsetters,
	.tp_methods = py_PAC_DATA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_DATA_new,
};


static PyObject *py_PAC_BUFFER_RAW_get_type(PyObject *obj, void *closure)
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_PAC_BUFFER_RAW_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_BUFFER_RAW_get_ndr_size(PyObject *obj, void *closure)
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(obj);
	PyObject *py_ndr_size;
	py_ndr_size = PyLong_FromUnsignedLongLong((uint32_t)(object->ndr_size));
	return py_ndr_size;
}

static int py_PAC_BUFFER_RAW_set_ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ndr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ndr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ndr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_BUFFER_RAW_get_info(PyObject *obj, void *closure)
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&DATA_BLOB_REM_Type, object->info, object->info);
	}
	return py_info;
}

static int py_PAC_BUFFER_RAW_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&DATA_BLOB_REM_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct DATA_BLOB_REM *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_PAC_BUFFER_RAW_get__pad(PyObject *obj, void *closure)
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyLong_FromUnsignedLongLong((uint32_t)(object->_pad));
	return py__pad;
}

static int py_PAC_BUFFER_RAW_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->_pad));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->_pad = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_BUFFER_RAW_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_PAC_BUFFER_RAW_get_type,
		.set = py_PAC_BUFFER_RAW_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_TYPE")
	},
	{
		.name = discard_const_p(char, "ndr_size"),
		.get = py_PAC_BUFFER_RAW_get_ndr_size,
		.set = py_PAC_BUFFER_RAW_set_ndr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_PAC_BUFFER_RAW_get_info,
		.set = py_PAC_BUFFER_RAW_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB_REM")
	},
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_PAC_BUFFER_RAW_get__pad,
		.set = py_PAC_BUFFER_RAW_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_BUFFER_RAW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_BUFFER_RAW, type);
}

static PyObject *py_PAC_BUFFER_RAW_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_BUFFER_RAW);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_BUFFER_RAW_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_BUFFER_RAW);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_BUFFER_RAW);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_BUFFER_RAW_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_BUFFER_RAW *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_BUFFER_RAW, "PAC_BUFFER_RAW", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_BUFFER_RAW, "PAC_BUFFER_RAW", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_BUFFER_RAW_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_BUFFER_RAW_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_BUFFER_RAW_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_BUFFER_RAW_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_BUFFER_RAW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_BUFFER_RAW",
	.tp_getset = py_PAC_BUFFER_RAW_getsetters,
	.tp_methods = py_PAC_BUFFER_RAW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_BUFFER_RAW_new,
};


static PyObject *py_PAC_DATA_RAW_get_num_buffers(PyObject *obj, void *closure)
{
	struct PAC_DATA_RAW *object = pytalloc_get_ptr(obj);
	PyObject *py_num_buffers;
	py_num_buffers = PyLong_FromUnsignedLongLong((uint32_t)(object->num_buffers));
	return py_num_buffers;
}

static int py_PAC_DATA_RAW_set_num_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA_RAW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_buffers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_buffers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_buffers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_DATA_RAW_get_version(PyObject *obj, void *closure)
{
	struct PAC_DATA_RAW *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_PAC_DATA_RAW_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA_RAW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_DATA_RAW_get_buffers(PyObject *obj, void *closure)
{
	struct PAC_DATA_RAW *object = pytalloc_get_ptr(obj);
	PyObject *py_buffers;
	py_buffers = PyList_New(object->num_buffers);
	if (py_buffers == NULL) {
		return NULL;
	}
	{
		int buffers_cntr_0;
		for (buffers_cntr_0 = 0; buffers_cntr_0 < (object->num_buffers); buffers_cntr_0++) {
			PyObject *py_buffers_0;
			py_buffers_0 = pytalloc_reference_ex(&PAC_BUFFER_RAW_Type, object->buffers, &(object->buffers)[buffers_cntr_0]);
			PyList_SetItem(py_buffers, buffers_cntr_0, py_buffers_0);
		}
	}
	return py_buffers;
}

static int py_PAC_DATA_RAW_set_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA_RAW *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buffers");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int buffers_cntr_0;
		object->buffers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffers, PyList_GET_SIZE(value));
		if (!object->buffers) { return -1; }
		talloc_set_name_const(object->buffers, "ARRAY: object->buffers");
		for (buffers_cntr_0 = 0; buffers_cntr_0 < PyList_GET_SIZE(value); buffers_cntr_0++) {
			if (PyList_GET_ITEM(value, buffers_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->buffers)[buffers_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&PAC_BUFFER_RAW_Type, PyList_GET_ITEM(value, buffers_cntr_0), return -1;);
			if (talloc_reference(object->buffers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, buffers_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->buffers)[buffers_cntr_0] = *(struct PAC_BUFFER_RAW *)pytalloc_get_ptr(PyList_GET_ITEM(value, buffers_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_DATA_RAW_getsetters[] = {
	{
		.name = discard_const_p(char, "num_buffers"),
		.get = py_PAC_DATA_RAW_get_num_buffers,
		.set = py_PAC_DATA_RAW_set_num_buffers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "version"),
		.get = py_PAC_DATA_RAW_get_version,
		.set = py_PAC_DATA_RAW_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "buffers"),
		.get = py_PAC_DATA_RAW_get_buffers,
		.set = py_PAC_DATA_RAW_set_buffers,
		.doc = discard_const_p(char, "PIDL-generated element of base type PAC_BUFFER_RAW")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_DATA_RAW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_DATA_RAW, type);
}

static PyObject *py_PAC_DATA_RAW_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_DATA_RAW *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_DATA_RAW);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_DATA_RAW_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_DATA_RAW *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_DATA_RAW);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_DATA_RAW);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_DATA_RAW_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_DATA_RAW *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_DATA_RAW, "PAC_DATA_RAW", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_DATA_RAW, "PAC_DATA_RAW", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_DATA_RAW_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_DATA_RAW_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_DATA_RAW_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_DATA_RAW_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_DATA_RAW_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_DATA_RAW",
	.tp_getset = py_PAC_DATA_RAW_getsetters,
	.tp_methods = py_PAC_DATA_RAW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_DATA_RAW_new,
};


static PyObject *py_PAC_Validate_get_MessageType(PyObject *obj, void *closure)
{
	struct PAC_Validate *object = pytalloc_get_ptr(obj);
	PyObject *py_MessageType;
	py_MessageType = PyLong_FromUnsignedLongLong((uint32_t)(object->MessageType));
	return py_MessageType;
}

static int py_PAC_Validate_set_MessageType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_Validate *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MessageType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MessageType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MessageType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_Validate_get_ChecksumLength(PyObject *obj, void *closure)
{
	struct PAC_Validate *object = pytalloc_get_ptr(obj);
	PyObject *py_ChecksumLength;
	py_ChecksumLength = PyLong_FromUnsignedLongLong((uint32_t)(object->ChecksumLength));
	return py_ChecksumLength;
}

static int py_PAC_Validate_set_ChecksumLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_Validate *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ChecksumLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ChecksumLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ChecksumLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_Validate_get_SignatureType(PyObject *obj, void *closure)
{
	struct PAC_Validate *object = pytalloc_get_ptr(obj);
	PyObject *py_SignatureType;
	py_SignatureType = PyLong_FromLong(object->SignatureType);
	return py_SignatureType;
}

static int py_PAC_Validate_set_SignatureType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_Validate *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SignatureType");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->SignatureType));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->SignatureType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_Validate_get_SignatureLength(PyObject *obj, void *closure)
{
	struct PAC_Validate *object = pytalloc_get_ptr(obj);
	PyObject *py_SignatureLength;
	py_SignatureLength = PyLong_FromUnsignedLongLong((uint32_t)(object->SignatureLength));
	return py_SignatureLength;
}

static int py_PAC_Validate_set_SignatureLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_Validate *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->SignatureLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->SignatureLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->SignatureLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_PAC_Validate_get_ChecksumAndSignature(PyObject *obj, void *closure)
{
	struct PAC_Validate *object = pytalloc_get_ptr(obj);
	PyObject *py_ChecksumAndSignature;
	py_ChecksumAndSignature = PyBytes_FromStringAndSize((char *)(object->ChecksumAndSignature).data, (object->ChecksumAndSignature).length);
	return py_ChecksumAndSignature;
}

static int py_PAC_Validate_set_ChecksumAndSignature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_Validate *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ChecksumAndSignature");
		return -1;
	}
	object->ChecksumAndSignature = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_PAC_Validate_getsetters[] = {
	{
		.name = discard_const_p(char, "MessageType"),
		.get = py_PAC_Validate_get_MessageType,
		.set = py_PAC_Validate_set_MessageType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ChecksumLength"),
		.get = py_PAC_Validate_get_ChecksumLength,
		.set = py_PAC_Validate_set_ChecksumLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "SignatureType"),
		.get = py_PAC_Validate_get_SignatureType,
		.set = py_PAC_Validate_set_SignatureType,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "SignatureLength"),
		.get = py_PAC_Validate_get_SignatureLength,
		.set = py_PAC_Validate_set_SignatureLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ChecksumAndSignature"),
		.get = py_PAC_Validate_get_ChecksumAndSignature,
		.set = py_PAC_Validate_set_ChecksumAndSignature,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_PAC_Validate_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_Validate, type);
}

static PyObject *py_PAC_Validate_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct PAC_Validate *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_PAC_Validate);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_PAC_Validate_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_Validate *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_Validate);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_Validate);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_Validate_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_Validate *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_Validate, "PAC_Validate", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_Validate, "PAC_Validate", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_Validate_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_Validate_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_Validate_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_PAC_Validate_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_Validate_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.PAC_Validate",
	.tp_getset = py_PAC_Validate_getsetters,
	.tp_methods = py_PAC_Validate_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_PAC_Validate_new,
};


static PyObject *py_netsamlogoncache_entry_get_timestamp(PyObject *obj, void *closure)
{
	struct netsamlogoncache_entry *object = pytalloc_get_ptr(obj);
	PyObject *py_timestamp;
	py_timestamp = PyLong_FromLong(object->timestamp);
	return py_timestamp;
}

static int py_netsamlogoncache_entry_set_timestamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netsamlogoncache_entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timestamp");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->timestamp));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->timestamp = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netsamlogoncache_entry_get_info3(PyObject *obj, void *closure)
{
	struct netsamlogoncache_entry *object = pytalloc_get_ptr(obj);
	PyObject *py_info3;
	py_info3 = pytalloc_reference_ex(netr_SamInfo3_Type, pytalloc_get_mem_ctx(obj), &object->info3);
	return py_info3;
}

static int py_netsamlogoncache_entry_set_info3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netsamlogoncache_entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info3");
		return -1;
	}
	PY_CHECK_TYPE(netr_SamInfo3_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info3 = *(struct netr_SamInfo3 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netsamlogoncache_entry_getsetters[] = {
	{
		.name = discard_const_p(char, "timestamp"),
		.get = py_netsamlogoncache_entry_get_timestamp,
		.set = py_netsamlogoncache_entry_set_timestamp,
		.doc = discard_const_p(char, "PIDL-generated element of base type time_t")
	},
	{
		.name = discard_const_p(char, "info3"),
		.get = py_netsamlogoncache_entry_get_info3,
		.set = py_netsamlogoncache_entry_set_info3,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SamInfo3")
	},
	{ .name = NULL }
};

static PyObject *py_netsamlogoncache_entry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netsamlogoncache_entry, type);
}

static PyObject *py_netsamlogoncache_entry_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netsamlogoncache_entry *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netsamlogoncache_entry);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netsamlogoncache_entry_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netsamlogoncache_entry *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netsamlogoncache_entry);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netsamlogoncache_entry);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netsamlogoncache_entry_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netsamlogoncache_entry *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netsamlogoncache_entry, "netsamlogoncache_entry", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netsamlogoncache_entry, "netsamlogoncache_entry", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netsamlogoncache_entry_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netsamlogoncache_entry_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netsamlogoncache_entry_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netsamlogoncache_entry_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netsamlogoncache_entry_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.netsamlogoncache_entry",
	.tp_getset = py_netsamlogoncache_entry_getsetters,
	.tp_methods = py_netsamlogoncache_entry_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netsamlogoncache_entry_new,
};


const struct PyNdrRpcMethodDef py_ndr_krb5pac_methods[] = {
	{
		.name = NULL,
	},
};

static PyObject *interface_krb5pac_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_krb5pac);
}

#define PY_DOC_KRB5PAC "Active Directory KRB5 PAC"
static PyTypeObject krb5pac_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.krb5pac",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "krb5pac(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A krb5pac client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_KRB5PAC,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_krb5pac_new,
};

static PyObject *syntax_krb5pac_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_krb5pac.syntax_id);
}

#define PY_DOC_KRB5PAC_SYNTAX "Active Directory KRB5 PAC"
static PyTypeObject krb5pac_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "krb5pac.krb5pac_abstract_syntax",
	.tp_doc = "krb5pac_abstract_syntax()\n"PY_DOC_KRB5PAC_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_krb5pac_new,
};

static PyMethodDef krb5pac_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "krb5pac",
	.m_doc = "krb5pac DCE/RPC",
	.m_size = -1,
	.m_methods = krb5pac_methods,
};
MODULE_INIT_FUNC(krb5pac)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_samba_dcerpc_lsa = NULL;
	PyObject *dep_samba_dcerpc_netlogon = NULL;
	PyObject *dep_samba_dcerpc_samr = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		goto out;

	dep_samba_dcerpc_netlogon = PyImport_ImportModule("samba.dcerpc.netlogon");
	if (dep_samba_dcerpc_netlogon == NULL)
		goto out;

	dep_samba_dcerpc_samr = PyImport_ImportModule("samba.dcerpc.samr");
	if (dep_samba_dcerpc_samr == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	samr_RidWithAttributeArray_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_samr, "RidWithAttributeArray");
	if (samr_RidWithAttributeArray_Type == NULL)
		goto out;

	netr_SamInfo3_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_SamInfo3");
	if (netr_SamInfo3_Type == NULL)
		goto out;

	samr_Password_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_samr, "Password");
	if (samr_Password_Type == NULL)
		goto out;

	lsa_String_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "String");
	if (lsa_String_Type == NULL)
		goto out;

	netr_SidAttr_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_SidAttr");
	if (netr_SidAttr_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	PAC_LOGON_NAME_Type.tp_base = BaseObject_Type;
	PAC_LOGON_NAME_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_SIGNATURE_DATA_Type.tp_base = BaseObject_Type;
	PAC_SIGNATURE_DATA_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_DOMAIN_GROUP_MEMBERSHIP_Type.tp_base = BaseObject_Type;
	PAC_DOMAIN_GROUP_MEMBERSHIP_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_LOGON_INFO_Type.tp_base = BaseObject_Type;
	PAC_LOGON_INFO_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_CREDENTIAL_NTLM_SECPKG_Type.tp_base = BaseObject_Type;
	PAC_CREDENTIAL_NTLM_SECPKG_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_Type.tp_base = BaseObject_Type;
	PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_CREDENTIAL_DATA_Type.tp_base = BaseObject_Type;
	PAC_CREDENTIAL_DATA_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_CREDENTIAL_DATA_CTR_Type.tp_base = BaseObject_Type;
	PAC_CREDENTIAL_DATA_CTR_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_CREDENTIAL_DATA_NDR_Type.tp_base = BaseObject_Type;
	PAC_CREDENTIAL_DATA_NDR_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_CREDENTIAL_INFO_Type.tp_base = BaseObject_Type;
	PAC_CREDENTIAL_INFO_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_CONSTRAINED_DELEGATION_Type.tp_base = BaseObject_Type;
	PAC_CONSTRAINED_DELEGATION_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_Type.tp_base = BaseObject_Type;
	PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_UPN_DNS_INFO_EX_Type.tp_base = BaseObject_Type;
	PAC_UPN_DNS_INFO_EX_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_UPN_DNS_INFO_Type.tp_base = BaseObject_Type;
	PAC_UPN_DNS_INFO_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_ATTRIBUTES_INFO_Type.tp_base = BaseObject_Type;
	PAC_ATTRIBUTES_INFO_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_REQUESTER_SID_Type.tp_base = BaseObject_Type;
	PAC_REQUESTER_SID_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_LOGON_INFO_CTR_Type.tp_base = BaseObject_Type;
	PAC_LOGON_INFO_CTR_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_CONSTRAINED_DELEGATION_CTR_Type.tp_base = BaseObject_Type;
	PAC_CONSTRAINED_DELEGATION_CTR_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_DEVICE_INFO_Type.tp_base = BaseObject_Type;
	PAC_DEVICE_INFO_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_DEVICE_INFO_CTR_Type.tp_base = BaseObject_Type;
	PAC_DEVICE_INFO_CTR_Type.tp_basicsize = pytalloc_BaseObject_size();

	DATA_BLOB_REM_Type.tp_base = BaseObject_Type;
	DATA_BLOB_REM_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_INFO_Type.tp_base = BaseObject_Type;
	PAC_INFO_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_BUFFER_Type.tp_base = BaseObject_Type;
	PAC_BUFFER_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_DATA_Type.tp_base = BaseObject_Type;
	PAC_DATA_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_BUFFER_RAW_Type.tp_base = BaseObject_Type;
	PAC_BUFFER_RAW_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_DATA_RAW_Type.tp_base = BaseObject_Type;
	PAC_DATA_RAW_Type.tp_basicsize = pytalloc_BaseObject_size();

	PAC_Validate_Type.tp_base = BaseObject_Type;
	PAC_Validate_Type.tp_basicsize = pytalloc_BaseObject_size();

	netsamlogoncache_entry_Type.tp_base = BaseObject_Type;
	netsamlogoncache_entry_Type.tp_basicsize = pytalloc_BaseObject_size();

	krb5pac_InterfaceType.tp_base = ClientConnection_Type;

	krb5pac_SyntaxType.tp_base = ndr_syntax_id_Type;
	krb5pac_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&PAC_LOGON_NAME_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_SIGNATURE_DATA_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_DOMAIN_GROUP_MEMBERSHIP_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_LOGON_INFO_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_CREDENTIAL_NTLM_SECPKG_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_CREDENTIAL_DATA_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_CREDENTIAL_DATA_CTR_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_CREDENTIAL_DATA_NDR_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_CREDENTIAL_INFO_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_CONSTRAINED_DELEGATION_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_UPN_DNS_INFO_EX_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_UPN_DNS_INFO_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_ATTRIBUTES_INFO_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_REQUESTER_SID_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_LOGON_INFO_CTR_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_CONSTRAINED_DELEGATION_CTR_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_DEVICE_INFO_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_DEVICE_INFO_CTR_Type) < 0)
		goto out;
	if (PyType_Ready(&DATA_BLOB_REM_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_INFO_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_BUFFER_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_DATA_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_BUFFER_RAW_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_DATA_RAW_Type) < 0)
		goto out;
	if (PyType_Ready(&PAC_Validate_Type) < 0)
		goto out;
	if (PyType_Ready(&netsamlogoncache_entry_Type) < 0)
		goto out;
	if (PyType_Ready(&krb5pac_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&krb5pac_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&krb5pac_InterfaceType, py_ndr_krb5pac_methods))
		return NULL;

#ifdef PY_PAC_LOGON_NAME_PATCH
	PY_PAC_LOGON_NAME_PATCH(&PAC_LOGON_NAME_Type);
#endif
#ifdef PY_PAC_SIGNATURE_DATA_PATCH
	PY_PAC_SIGNATURE_DATA_PATCH(&PAC_SIGNATURE_DATA_Type);
#endif
#ifdef PY_PAC_DOMAIN_GROUP_MEMBERSHIP_PATCH
	PY_PAC_DOMAIN_GROUP_MEMBERSHIP_PATCH(&PAC_DOMAIN_GROUP_MEMBERSHIP_Type);
#endif
#ifdef PY_PAC_LOGON_INFO_PATCH
	PY_PAC_LOGON_INFO_PATCH(&PAC_LOGON_INFO_Type);
#endif
#ifdef PY_PAC_CREDENTIAL_NTLM_SECPKG_PATCH
	PY_PAC_CREDENTIAL_NTLM_SECPKG_PATCH(&PAC_CREDENTIAL_NTLM_SECPKG_Type);
#endif
#ifdef PY_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_PATCH
	PY_PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_PATCH(&PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_Type);
#endif
#ifdef PY_PAC_CREDENTIAL_DATA_PATCH
	PY_PAC_CREDENTIAL_DATA_PATCH(&PAC_CREDENTIAL_DATA_Type);
#endif
#ifdef PY_PAC_CREDENTIAL_DATA_CTR_PATCH
	PY_PAC_CREDENTIAL_DATA_CTR_PATCH(&PAC_CREDENTIAL_DATA_CTR_Type);
#endif
#ifdef PY_PAC_CREDENTIAL_DATA_NDR_PATCH
	PY_PAC_CREDENTIAL_DATA_NDR_PATCH(&PAC_CREDENTIAL_DATA_NDR_Type);
#endif
#ifdef PY_PAC_CREDENTIAL_INFO_PATCH
	PY_PAC_CREDENTIAL_INFO_PATCH(&PAC_CREDENTIAL_INFO_Type);
#endif
#ifdef PY_PAC_CONSTRAINED_DELEGATION_PATCH
	PY_PAC_CONSTRAINED_DELEGATION_PATCH(&PAC_CONSTRAINED_DELEGATION_Type);
#endif
#ifdef PY_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_PATCH
	PY_PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_PATCH(&PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_Type);
#endif
#ifdef PY_PAC_UPN_DNS_INFO_EX_PATCH
	PY_PAC_UPN_DNS_INFO_EX_PATCH(&PAC_UPN_DNS_INFO_EX_Type);
#endif
#ifdef PY_PAC_UPN_DNS_INFO_PATCH
	PY_PAC_UPN_DNS_INFO_PATCH(&PAC_UPN_DNS_INFO_Type);
#endif
#ifdef PY_PAC_ATTRIBUTES_INFO_PATCH
	PY_PAC_ATTRIBUTES_INFO_PATCH(&PAC_ATTRIBUTES_INFO_Type);
#endif
#ifdef PY_PAC_REQUESTER_SID_PATCH
	PY_PAC_REQUESTER_SID_PATCH(&PAC_REQUESTER_SID_Type);
#endif
#ifdef PY_PAC_LOGON_INFO_CTR_PATCH
	PY_PAC_LOGON_INFO_CTR_PATCH(&PAC_LOGON_INFO_CTR_Type);
#endif
#ifdef PY_PAC_CONSTRAINED_DELEGATION_CTR_PATCH
	PY_PAC_CONSTRAINED_DELEGATION_CTR_PATCH(&PAC_CONSTRAINED_DELEGATION_CTR_Type);
#endif
#ifdef PY_PAC_DEVICE_INFO_PATCH
	PY_PAC_DEVICE_INFO_PATCH(&PAC_DEVICE_INFO_Type);
#endif
#ifdef PY_PAC_DEVICE_INFO_CTR_PATCH
	PY_PAC_DEVICE_INFO_CTR_PATCH(&PAC_DEVICE_INFO_CTR_Type);
#endif
#ifdef PY_DATA_BLOB_REM_PATCH
	PY_DATA_BLOB_REM_PATCH(&DATA_BLOB_REM_Type);
#endif
#ifdef PY_PAC_INFO_PATCH
	PY_PAC_INFO_PATCH(&PAC_INFO_Type);
#endif
#ifdef PY_PAC_BUFFER_PATCH
	PY_PAC_BUFFER_PATCH(&PAC_BUFFER_Type);
#endif
#ifdef PY_PAC_DATA_PATCH
	PY_PAC_DATA_PATCH(&PAC_DATA_Type);
#endif
#ifdef PY_PAC_BUFFER_RAW_PATCH
	PY_PAC_BUFFER_RAW_PATCH(&PAC_BUFFER_RAW_Type);
#endif
#ifdef PY_PAC_DATA_RAW_PATCH
	PY_PAC_DATA_RAW_PATCH(&PAC_DATA_RAW_Type);
#endif
#ifdef PY_PAC_VALIDATE_PATCH
	PY_PAC_VALIDATE_PATCH(&PAC_Validate_Type);
#endif
#ifdef PY_NETSAMLOGONCACHE_ENTRY_PATCH
	PY_NETSAMLOGONCACHE_ENTRY_PATCH(&netsamlogoncache_entry_Type);
#endif
#ifdef PY_KRB5PAC_PATCH
	PY_KRB5PAC_PATCH(&krb5pac_InterfaceType);
#endif
#ifdef PY_KRB5PAC_ABSTRACT_SYNTAX_PATCH
	PY_KRB5PAC_ABSTRACT_SYNTAX_PATCH(&krb5pac_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&krb5pac_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "PAC_TYPE_BEGIN", PyLong_FromUnsignedLongLong(1));
	PyModule_AddObject(m, "PAC_TYPE_END", PyLong_FromUnsignedLongLong(20));
	PyModule_AddObject(m, "PAC_TYPE_COUNT", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_END-PAC_TYPE_BEGIN)));
	PyModule_AddObject(m, "NETLOGON_GENERIC_KRB5_PAC_VALIDATE", PyLong_FromUnsignedLongLong(3));
	PyModule_AddObject(m, "PAC_CREDENTIAL_NTLM_HAS_LM_HASH", PyLong_FromUnsignedLongLong((uint32_t)(PAC_CREDENTIAL_NTLM_HAS_LM_HASH)));
	PyModule_AddObject(m, "PAC_CREDENTIAL_NTLM_HAS_NT_HASH", PyLong_FromUnsignedLongLong((uint32_t)(PAC_CREDENTIAL_NTLM_HAS_NT_HASH)));
	PyModule_AddObject(m, "PAC_UPN_DNS_FLAG_CONSTRUCTED", PyLong_FromUnsignedLongLong((uint32_t)(PAC_UPN_DNS_FLAG_CONSTRUCTED)));
	PyModule_AddObject(m, "PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID", PyLong_FromUnsignedLongLong((uint32_t)(PAC_UPN_DNS_FLAG_HAS_SAM_NAME_AND_SID)));
	PyModule_AddObject(m, "PAC_ATTRIBUTE_FLAG_PAC_WAS_REQUESTED", PyLong_FromUnsignedLongLong((uint32_t)(PAC_ATTRIBUTE_FLAG_PAC_WAS_REQUESTED)));
	PyModule_AddObject(m, "PAC_ATTRIBUTE_FLAG_PAC_WAS_GIVEN_IMPLICITLY", PyLong_FromUnsignedLongLong((uint32_t)(PAC_ATTRIBUTE_FLAG_PAC_WAS_GIVEN_IMPLICITLY)));
	PyModule_AddObject(m, "PAC_TYPE_LOGON_INFO", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_LOGON_INFO)));
	PyModule_AddObject(m, "PAC_TYPE_CREDENTIAL_INFO", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_CREDENTIAL_INFO)));
	PyModule_AddObject(m, "PAC_TYPE_SRV_CHECKSUM", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_SRV_CHECKSUM)));
	PyModule_AddObject(m, "PAC_TYPE_KDC_CHECKSUM", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_KDC_CHECKSUM)));
	PyModule_AddObject(m, "PAC_TYPE_LOGON_NAME", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_LOGON_NAME)));
	PyModule_AddObject(m, "PAC_TYPE_CONSTRAINED_DELEGATION", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_CONSTRAINED_DELEGATION)));
	PyModule_AddObject(m, "PAC_TYPE_UPN_DNS_INFO", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_UPN_DNS_INFO)));
	PyModule_AddObject(m, "PAC_TYPE_CLIENT_CLAIMS_INFO", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_CLIENT_CLAIMS_INFO)));
	PyModule_AddObject(m, "PAC_TYPE_DEVICE_INFO", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_DEVICE_INFO)));
	PyModule_AddObject(m, "PAC_TYPE_DEVICE_CLAIMS_INFO", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_DEVICE_CLAIMS_INFO)));
	PyModule_AddObject(m, "PAC_TYPE_TICKET_CHECKSUM", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_TICKET_CHECKSUM)));
	PyModule_AddObject(m, "PAC_TYPE_ATTRIBUTES_INFO", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_ATTRIBUTES_INFO)));
	PyModule_AddObject(m, "PAC_TYPE_REQUESTER_SID", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_REQUESTER_SID)));
	PyModule_AddObject(m, "PAC_TYPE_FULL_CHECKSUM", PyLong_FromUnsignedLongLong((uint32_t)(PAC_TYPE_FULL_CHECKSUM)));
	Py_INCREF((PyObject *)(void *)&PAC_LOGON_NAME_Type);
	PyModule_AddObject(m, "PAC_LOGON_NAME", (PyObject *)(void *)&PAC_LOGON_NAME_Type);
	Py_INCREF((PyObject *)(void *)&PAC_SIGNATURE_DATA_Type);
	PyModule_AddObject(m, "PAC_SIGNATURE_DATA", (PyObject *)(void *)&PAC_SIGNATURE_DATA_Type);
	Py_INCREF((PyObject *)(void *)&PAC_DOMAIN_GROUP_MEMBERSHIP_Type);
	PyModule_AddObject(m, "PAC_DOMAIN_GROUP_MEMBERSHIP", (PyObject *)(void *)&PAC_DOMAIN_GROUP_MEMBERSHIP_Type);
	Py_INCREF((PyObject *)(void *)&PAC_LOGON_INFO_Type);
	PyModule_AddObject(m, "PAC_LOGON_INFO", (PyObject *)(void *)&PAC_LOGON_INFO_Type);
	Py_INCREF((PyObject *)(void *)&PAC_CREDENTIAL_NTLM_SECPKG_Type);
	PyModule_AddObject(m, "PAC_CREDENTIAL_NTLM_SECPKG", (PyObject *)(void *)&PAC_CREDENTIAL_NTLM_SECPKG_Type);
	Py_INCREF((PyObject *)(void *)&PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_Type);
	PyModule_AddObject(m, "PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG", (PyObject *)(void *)&PAC_CREDENTIAL_SUPPLEMENTAL_SECPKG_Type);
	Py_INCREF((PyObject *)(void *)&PAC_CREDENTIAL_DATA_Type);
	PyModule_AddObject(m, "PAC_CREDENTIAL_DATA", (PyObject *)(void *)&PAC_CREDENTIAL_DATA_Type);
	Py_INCREF((PyObject *)(void *)&PAC_CREDENTIAL_DATA_CTR_Type);
	PyModule_AddObject(m, "PAC_CREDENTIAL_DATA_CTR", (PyObject *)(void *)&PAC_CREDENTIAL_DATA_CTR_Type);
	Py_INCREF((PyObject *)(void *)&PAC_CREDENTIAL_DATA_NDR_Type);
	PyModule_AddObject(m, "PAC_CREDENTIAL_DATA_NDR", (PyObject *)(void *)&PAC_CREDENTIAL_DATA_NDR_Type);
	Py_INCREF((PyObject *)(void *)&PAC_CREDENTIAL_INFO_Type);
	PyModule_AddObject(m, "PAC_CREDENTIAL_INFO", (PyObject *)(void *)&PAC_CREDENTIAL_INFO_Type);
	Py_INCREF((PyObject *)(void *)&PAC_CONSTRAINED_DELEGATION_Type);
	PyModule_AddObject(m, "PAC_CONSTRAINED_DELEGATION", (PyObject *)(void *)&PAC_CONSTRAINED_DELEGATION_Type);
	Py_INCREF((PyObject *)(void *)&PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_Type);
	PyModule_AddObject(m, "PAC_UPN_DNS_INFO_SAM_NAME_AND_SID", (PyObject *)(void *)&PAC_UPN_DNS_INFO_SAM_NAME_AND_SID_Type);
	Py_INCREF((PyObject *)(void *)&PAC_UPN_DNS_INFO_EX_Type);
	PyModule_AddObject(m, "PAC_UPN_DNS_INFO_EX", (PyObject *)(void *)&PAC_UPN_DNS_INFO_EX_Type);
	Py_INCREF((PyObject *)(void *)&PAC_UPN_DNS_INFO_Type);
	PyModule_AddObject(m, "PAC_UPN_DNS_INFO", (PyObject *)(void *)&PAC_UPN_DNS_INFO_Type);
	Py_INCREF((PyObject *)(void *)&PAC_ATTRIBUTES_INFO_Type);
	PyModule_AddObject(m, "PAC_ATTRIBUTES_INFO", (PyObject *)(void *)&PAC_ATTRIBUTES_INFO_Type);
	Py_INCREF((PyObject *)(void *)&PAC_REQUESTER_SID_Type);
	PyModule_AddObject(m, "PAC_REQUESTER_SID", (PyObject *)(void *)&PAC_REQUESTER_SID_Type);
	Py_INCREF((PyObject *)(void *)&PAC_LOGON_INFO_CTR_Type);
	PyModule_AddObject(m, "PAC_LOGON_INFO_CTR", (PyObject *)(void *)&PAC_LOGON_INFO_CTR_Type);
	Py_INCREF((PyObject *)(void *)&PAC_CONSTRAINED_DELEGATION_CTR_Type);
	PyModule_AddObject(m, "PAC_CONSTRAINED_DELEGATION_CTR", (PyObject *)(void *)&PAC_CONSTRAINED_DELEGATION_CTR_Type);
	Py_INCREF((PyObject *)(void *)&PAC_DEVICE_INFO_Type);
	PyModule_AddObject(m, "PAC_DEVICE_INFO", (PyObject *)(void *)&PAC_DEVICE_INFO_Type);
	Py_INCREF((PyObject *)(void *)&PAC_DEVICE_INFO_CTR_Type);
	PyModule_AddObject(m, "PAC_DEVICE_INFO_CTR", (PyObject *)(void *)&PAC_DEVICE_INFO_CTR_Type);
	Py_INCREF((PyObject *)(void *)&DATA_BLOB_REM_Type);
	PyModule_AddObject(m, "DATA_BLOB_REM", (PyObject *)(void *)&DATA_BLOB_REM_Type);
	Py_INCREF((PyObject *)(void *)&PAC_INFO_Type);
	PyModule_AddObject(m, "PAC_INFO", (PyObject *)(void *)&PAC_INFO_Type);
	Py_INCREF((PyObject *)(void *)&PAC_BUFFER_Type);
	PyModule_AddObject(m, "PAC_BUFFER", (PyObject *)(void *)&PAC_BUFFER_Type);
	Py_INCREF((PyObject *)(void *)&PAC_DATA_Type);
	PyModule_AddObject(m, "PAC_DATA", (PyObject *)(void *)&PAC_DATA_Type);
	Py_INCREF((PyObject *)(void *)&PAC_BUFFER_RAW_Type);
	PyModule_AddObject(m, "PAC_BUFFER_RAW", (PyObject *)(void *)&PAC_BUFFER_RAW_Type);
	Py_INCREF((PyObject *)(void *)&PAC_DATA_RAW_Type);
	PyModule_AddObject(m, "PAC_DATA_RAW", (PyObject *)(void *)&PAC_DATA_RAW_Type);
	Py_INCREF((PyObject *)(void *)&PAC_Validate_Type);
	PyModule_AddObject(m, "PAC_Validate", (PyObject *)(void *)&PAC_Validate_Type);
	Py_INCREF((PyObject *)(void *)&netsamlogoncache_entry_Type);
	PyModule_AddObject(m, "netsamlogoncache_entry", (PyObject *)(void *)&netsamlogoncache_entry_Type);
	Py_INCREF((PyObject *)(void *)&krb5pac_InterfaceType);
	PyModule_AddObject(m, "krb5pac", (PyObject *)(void *)&krb5pac_InterfaceType);
	Py_INCREF((PyObject *)(void *)&krb5pac_SyntaxType);
	PyModule_AddObject(m, "krb5pac_abstract_syntax", (PyObject *)(void *)&krb5pac_SyntaxType);
	Py_INCREF((PyObject *)(void *)&krb5pac_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&krb5pac_SyntaxType);
#ifdef PY_MOD_KRB5PAC_PATCH
	PY_MOD_KRB5PAC_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_samba_dcerpc_lsa);
	Py_XDECREF(dep_samba_dcerpc_netlogon);
	Py_XDECREF(dep_samba_dcerpc_samr);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	Py_XDECREF(dep_samba_dcerpc_misc);
	return m;

}
