/* localsearch-picture-item-factory.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from localsearch-picture-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-localsearch.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <tinysparql.h>
#include "rygel-server.h"
#include <glib-object.h>
#include "rygel-core.h"
#include <gee.h>

#define RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_CATEGORY "nmm:Photo"
#define RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_CATEGORY_IRI "http://www.tracker-project.org/" "temp/nmm#Photo"
#define RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_GRAPH "tracker:Pictures"
#define RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_GRAPH_IRI "http://tracker.api.gnome.org/ontology/v3/tracker#Pictures"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_HEIGHT = RYGEL_LOCAL_SEARCH_ITEM_FACTORY_METADATA_LAST_KEY,
	RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_WIDTH,
	RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_LAST_KEY
} RygelLocalSearchPictureItemFactoryPictureMetadata;

#define RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_TYPE_PICTURE_METADATA (rygel_local_search_picture_item_factory_picture_metadata_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_local_search_picture_item_factory_parent_class = NULL;

static GType rygel_local_search_picture_item_factory_picture_metadata_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static RygelMediaFileItem* rygel_local_search_picture_item_factory_real_create (RygelLocalSearchItemFactory* base,
                                                                         const gchar* id,
                                                                         const gchar* uri,
                                                                         RygelLocalSearchSearchContainer* parent,
                                                                         TrackerSparqlCursor* metadata,
                                                                         GError** error);
static void rygel_local_search_picture_item_factory_real_set_metadata (RygelLocalSearchItemFactory* base,
                                                                RygelMediaFileItem* item,
                                                                const gchar* uri,
                                                                TrackerSparqlCursor* metadata,
                                                                GError** error);
static GType rygel_local_search_picture_item_factory_get_type_once (void);

 G_GNUC_NO_INLINE static GType
rygel_local_search_picture_item_factory_picture_metadata_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_HEIGHT, "RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_HEIGHT", "height"}, {RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_WIDTH, "RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_WIDTH", "width"}, {RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_LAST_KEY, "RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
	GType rygel_local_search_picture_item_factory_picture_metadata_type_id;
	rygel_local_search_picture_item_factory_picture_metadata_type_id = g_enum_register_static ("RygelLocalSearchPictureItemFactoryPictureMetadata", values);
	return rygel_local_search_picture_item_factory_picture_metadata_type_id;
}

static GType
rygel_local_search_picture_item_factory_picture_metadata_get_type (void)
{
	static volatile gsize rygel_local_search_picture_item_factory_picture_metadata_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_picture_item_factory_picture_metadata_type_id__once)) {
		GType rygel_local_search_picture_item_factory_picture_metadata_type_id;
		rygel_local_search_picture_item_factory_picture_metadata_type_id = rygel_local_search_picture_item_factory_picture_metadata_get_type_once ();
		g_once_init_leave (&rygel_local_search_picture_item_factory_picture_metadata_type_id__once, rygel_local_search_picture_item_factory_picture_metadata_type_id);
	}
	return rygel_local_search_picture_item_factory_picture_metadata_type_id__once;
}

RygelLocalSearchPictureItemFactory*
rygel_local_search_picture_item_factory_construct (GType object_type)
{
	RygelLocalSearchPictureItemFactory* self = NULL;
	gchar* upload_folder = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_tmp1_ = g_strdup (_tmp0_);
	upload_folder = _tmp1_;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = rygel_meta_config_get_default ();
		config = _tmp2_;
		_tmp4_ = rygel_configuration_get_picture_upload_folder ((RygelConfiguration*) config, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (upload_folder);
		upload_folder = _tmp5_;
		_g_free0 (_tmp3_);
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (upload_folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = upload_folder;
	self = (RygelLocalSearchPictureItemFactory*) rygel_local_search_item_factory_construct (object_type, RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_CATEGORY, RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_CATEGORY_IRI, RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_GRAPH, RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_GRAPH_IRI, RYGEL_PHOTO_ITEM_UPNP_CLASS, _tmp6_);
	_tmp7_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "height");
	_tmp8_ = ((RygelLocalSearchItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, "width");
	_g_free0 (upload_folder);
	return self;
}

RygelLocalSearchPictureItemFactory*
rygel_local_search_picture_item_factory_new (void)
{
	return rygel_local_search_picture_item_factory_construct (RYGEL_LOCAL_SEARCH_TYPE_PICTURE_ITEM_FACTORY);
}

static RygelMediaFileItem*
rygel_local_search_picture_item_factory_real_create (RygelLocalSearchItemFactory* base,
                                                     const gchar* id,
                                                     const gchar* uri,
                                                     RygelLocalSearchSearchContainer* parent,
                                                     TrackerSparqlCursor* metadata,
                                                     GError** error)
{
	RygelLocalSearchPictureItemFactory * self;
	RygelPhotoItem* item = NULL;
	RygelPhotoItem* _tmp0_;
	GError* _inner_error0_ = NULL;
	RygelMediaFileItem* result;
	self = (RygelLocalSearchPictureItemFactory*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = rygel_photo_item_new (id, (RygelMediaContainer*) parent, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
	item = _tmp0_;
	rygel_local_search_item_factory_set_metadata ((RygelLocalSearchItemFactory*) self, (RygelMediaFileItem*) item, uri, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (item);
		return NULL;
	}
	result = (RygelMediaFileItem*) item;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_local_search_picture_item_factory_real_set_metadata (RygelLocalSearchItemFactory* base,
                                                           RygelMediaFileItem* item,
                                                           const gchar* uri,
                                                           TrackerSparqlCursor* metadata,
                                                           GError** error)
{
	RygelLocalSearchPictureItemFactory * self;
	RygelPhotoItem* photo = NULL;
	RygelPhotoItem* _tmp0_;
	RygelPhotoItem* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = (RygelLocalSearchPictureItemFactory*) base;
	g_return_if_fail (item != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	RYGEL_LOCAL_SEARCH_ITEM_FACTORY_CLASS (rygel_local_search_picture_item_factory_parent_class)->set_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_LOCAL_SEARCH_TYPE_ITEM_FACTORY, RygelLocalSearchItemFactory), item, uri, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	rygel_local_search_item_factory_set_ref_id ((RygelLocalSearchItemFactory*) self, item, "AllPictures");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_PHOTO_ITEM) ? ((RygelPhotoItem*) item) : NULL);
	photo = _tmp0_;
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_WIDTH)) {
		RygelPhotoItem* _tmp1_;
		_tmp1_ = photo;
		rygel_visual_item_set_width ((RygelVisualItem*) _tmp1_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_WIDTH));
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_HEIGHT)) {
		RygelPhotoItem* _tmp2_;
		_tmp2_ = photo;
		rygel_visual_item_set_height ((RygelVisualItem*) _tmp2_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_LOCAL_SEARCH_PICTURE_ITEM_FACTORY_PICTURE_METADATA_HEIGHT));
	}
	_tmp3_ = photo;
	RYGEL_LOCAL_SEARCH_ITEM_FACTORY_CLASS (rygel_local_search_picture_item_factory_parent_class)->add_resources (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_LOCAL_SEARCH_TYPE_ITEM_FACTORY, RygelLocalSearchItemFactory), (RygelMediaFileItem*) _tmp3_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (photo);
		return;
	}
	_g_object_unref0 (photo);
}

static void
rygel_local_search_picture_item_factory_class_init (RygelLocalSearchPictureItemFactoryClass * klass,
                                                    gpointer klass_data)
{
	rygel_local_search_picture_item_factory_parent_class = g_type_class_peek_parent (klass);
	((RygelLocalSearchItemFactoryClass *) klass)->create = (RygelMediaFileItem* (*) (RygelLocalSearchItemFactory*, const gchar*, const gchar*, RygelLocalSearchSearchContainer*, TrackerSparqlCursor*, GError**)) rygel_local_search_picture_item_factory_real_create;
	((RygelLocalSearchItemFactoryClass *) klass)->set_metadata = (void (*) (RygelLocalSearchItemFactory*, RygelMediaFileItem*, const gchar*, TrackerSparqlCursor*, GError**)) rygel_local_search_picture_item_factory_real_set_metadata;
}

static void
rygel_local_search_picture_item_factory_instance_init (RygelLocalSearchPictureItemFactory * self,
                                                       gpointer klass)
{
}

/**
 * LocalSearch picture item factory.
 */
 G_GNUC_NO_INLINE static GType
rygel_local_search_picture_item_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchPictureItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_picture_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLocalSearchPictureItemFactory), 0, (GInstanceInitFunc) rygel_local_search_picture_item_factory_instance_init, NULL };
	GType rygel_local_search_picture_item_factory_type_id;
	rygel_local_search_picture_item_factory_type_id = g_type_register_static (RYGEL_LOCAL_SEARCH_TYPE_ITEM_FACTORY, "RygelLocalSearchPictureItemFactory", &g_define_type_info, 0);
	return rygel_local_search_picture_item_factory_type_id;
}

GType
rygel_local_search_picture_item_factory_get_type (void)
{
	static volatile gsize rygel_local_search_picture_item_factory_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_picture_item_factory_type_id__once)) {
		GType rygel_local_search_picture_item_factory_type_id;
		rygel_local_search_picture_item_factory_type_id = rygel_local_search_picture_item_factory_get_type_once ();
		g_once_init_leave (&rygel_local_search_picture_item_factory_type_id__once, rygel_local_search_picture_item_factory_type_id);
	}
	return rygel_local_search_picture_item_factory_type_id__once;
}

