// python wrapper for vtkCameraManipulatorGUIHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCameraManipulatorGUIHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCameraManipulatorGUIHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCameraManipulatorGUIHelper_ClassNew(); }


static PyObject *
PyvtkCameraManipulatorGUIHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCameraManipulatorGUIHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulatorGUIHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulatorGUIHelper *op = static_cast<vtkCameraManipulatorGUIHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCameraManipulatorGUIHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulatorGUIHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCameraManipulatorGUIHelper *tempr = vtkCameraManipulatorGUIHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulatorGUIHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulatorGUIHelper *op = static_cast<vtkCameraManipulatorGUIHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCameraManipulatorGUIHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCameraManipulatorGUIHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulatorGUIHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCameraManipulatorGUIHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulatorGUIHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulatorGUIHelper *op = static_cast<vtkCameraManipulatorGUIHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCameraManipulatorGUIHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulatorGUIHelper_UpdateGUI(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateGUI");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulatorGUIHelper *op = static_cast<vtkCameraManipulatorGUIHelper *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    op->UpdateGUI();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulatorGUIHelper_GetActiveSourceBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveSourceBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulatorGUIHelper *op = static_cast<vtkCameraManipulatorGUIHelper *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  double save0[6];
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    int tempr = op->GetActiveSourceBounds(temp0);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulatorGUIHelper_GetActiveActorTranslate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveActorTranslate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulatorGUIHelper *op = static_cast<vtkCameraManipulatorGUIHelper *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    int tempr = op->GetActiveActorTranslate(temp0);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulatorGUIHelper_SetActiveActorTranslate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveActorTranslate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulatorGUIHelper *op = static_cast<vtkCameraManipulatorGUIHelper *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    int tempr = op->SetActiveActorTranslate(temp0);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulatorGUIHelper_GetCenterOfRotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCenterOfRotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulatorGUIHelper *op = static_cast<vtkCameraManipulatorGUIHelper *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    int tempr = op->GetCenterOfRotation(temp0);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCameraManipulatorGUIHelper_Methods[] = {
  {"IsTypeOf", PyvtkCameraManipulatorGUIHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCameraManipulatorGUIHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCameraManipulatorGUIHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCameraManipulatorGUIHelper\nC++: static vtkCameraManipulatorGUIHelper *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCameraManipulatorGUIHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCameraManipulatorGUIHelper\nC++: vtkCameraManipulatorGUIHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCameraManipulatorGUIHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCameraManipulatorGUIHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"UpdateGUI", PyvtkCameraManipulatorGUIHelper_UpdateGUI, METH_VARARGS,
   "UpdateGUI(self) -> None\nC++: virtual void UpdateGUI()\n\nCalled by the manipulator to update the GUI. This typically\ninvolves calling processing pending events on the GUI.\n"},
  {"GetActiveSourceBounds", PyvtkCameraManipulatorGUIHelper_GetActiveSourceBounds, METH_VARARGS,
   "GetActiveSourceBounds(self, bounds:[float, float, float, float,\n    float, float]) -> int\nC++: virtual int GetActiveSourceBounds(double bounds[6])\n\nSome interactors use the bounds of the active source. The method\nreturns 0 is no active source is present or not supported by GUI,\notherwise returns 1 and the bounds are filled into the passed\nargument array.\n"},
  {"GetActiveActorTranslate", PyvtkCameraManipulatorGUIHelper_GetActiveActorTranslate, METH_VARARGS,
   "GetActiveActorTranslate(self, translate:[float, float, float])\n    -> int\nC++: virtual int GetActiveActorTranslate(double translate[3])\n\nCalled to get/set the translation for the actor for the active\nsource in the active view. If applicable returns 1, otherwise\nreturns 0.\n"},
  {"SetActiveActorTranslate", PyvtkCameraManipulatorGUIHelper_SetActiveActorTranslate, METH_VARARGS,
   "SetActiveActorTranslate(self, translate:[float, float, float])\n    -> int\nC++: virtual int SetActiveActorTranslate(double translate[3])\n\n"},
  {"GetCenterOfRotation", PyvtkCameraManipulatorGUIHelper_GetCenterOfRotation, METH_VARARGS,
   "GetCenterOfRotation(self, center:[float, float, float]) -> int\nC++: virtual int GetCenterOfRotation(double center[3])\n\nGet the center of rotation. Returns 0 if not applicable.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCameraManipulatorGUIHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCameraManipulatorGUIHelper_Doc =
  "vtkCameraManipulatorGUIHelper - Helper class for Camera\n\n"
  "Superclass: vtkObject\n\n"
  "Manipulators.\n\n"
  "This class is the interaface that defines API for a helper class used\n"
  "by some specialized camera manipulators that needed access to GUI.\n"
  "GUI implementations subclass this. vtkPVInteractorStyle sets the\n"
  "helper on every manipulator, if available so that the manipulator can\n"
  "use it.\n"
  "@sa\n"
  "vtkPVInteractorStyle\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCameraManipulatorGUIHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsInteractionStyle.vtkCameraManipulatorGUIHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCameraManipulatorGUIHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkCameraManipulatorGUIHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCameraManipulatorGUIHelper_Type, PyvtkCameraManipulatorGUIHelper_Methods,
    "vtkCameraManipulatorGUIHelper",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCameraManipulatorGUIHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCameraManipulatorGUIHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCameraManipulatorGUIHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCameraManipulatorGUIHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

