/* ConversationListItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ConversationListItem.vala, do not modify */

/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <handy.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <camel/camel.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <gio/gio.h>

#define MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "win"
#define MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "."
#define MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH "trash"
#define MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD "mark-unread"
#define MAIL_MAIN_WINDOW_ACTION_MARK_READ "mark-read"
#define MAIL_MAIN_WINDOW_ACTION_MARK_STAR "mark-star"
#define MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR "mark-unstar"
#define MAIL_MAIN_WINDOW_ACTION_ARCHIVE "archive"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_VIRTUALIZING_LIST_BOX_ROW (virtualizing_list_box_row_get_type ())
#define VIRTUALIZING_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRow))
#define VIRTUALIZING_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRowClass))
#define IS_VIRTUALIZING_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIRTUALIZING_LIST_BOX_ROW))
#define IS_VIRTUALIZING_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIRTUALIZING_LIST_BOX_ROW))
#define VIRTUALIZING_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRowClass))

typedef struct _VirtualizingListBoxRow VirtualizingListBoxRow;
typedef struct _VirtualizingListBoxRowClass VirtualizingListBoxRowClass;
typedef struct _VirtualizingListBoxRowPrivate VirtualizingListBoxRowPrivate;

#define MAIL_TYPE_CONVERSATION_LIST_ITEM (mail_conversation_list_item_get_type ())
#define MAIL_CONVERSATION_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_CONVERSATION_LIST_ITEM, MailConversationListItem))
#define MAIL_CONVERSATION_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_CONVERSATION_LIST_ITEM, MailConversationListItemClass))
#define MAIL_IS_CONVERSATION_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_CONVERSATION_LIST_ITEM))
#define MAIL_IS_CONVERSATION_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_CONVERSATION_LIST_ITEM))
#define MAIL_CONVERSATION_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_CONVERSATION_LIST_ITEM, MailConversationListItemClass))

typedef struct _MailConversationListItem MailConversationListItem;
typedef struct _MailConversationListItemClass MailConversationListItemClass;
typedef struct _MailConversationListItemPrivate MailConversationListItemPrivate;
enum  {
	MAIL_CONVERSATION_LIST_ITEM_0_PROPERTY,
	MAIL_CONVERSATION_LIST_ITEM_NUM_PROPERTIES
};
static GParamSpec* mail_conversation_list_item_properties[MAIL_CONVERSATION_LIST_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define MAIL_TYPE_CONVERSATION_ITEM_MODEL (mail_conversation_item_model_get_type ())
#define MAIL_CONVERSATION_ITEM_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel))
#define MAIL_CONVERSATION_ITEM_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModelClass))
#define MAIL_IS_CONVERSATION_ITEM_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_CONVERSATION_ITEM_MODEL))
#define MAIL_IS_CONVERSATION_ITEM_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_CONVERSATION_ITEM_MODEL))
#define MAIL_CONVERSATION_ITEM_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModelClass))

typedef struct _MailConversationItemModel MailConversationItemModel;
typedef struct _MailConversationItemModelClass MailConversationItemModelClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE (mail_conversation_list_item_swipe_affordance_get_type ())
#define MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE, MailConversationListItemSwipeAffordance))
#define MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE, MailConversationListItemSwipeAffordanceClass))
#define MAIL_CONVERSATION_LIST_ITEM_IS_SWIPE_AFFORDANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE))
#define MAIL_CONVERSATION_LIST_ITEM_IS_SWIPE_AFFORDANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE))
#define MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE, MailConversationListItemSwipeAffordanceClass))

typedef struct _MailConversationListItemSwipeAffordance MailConversationListItemSwipeAffordance;
typedef struct _MailConversationListItemSwipeAffordanceClass MailConversationListItemSwipeAffordanceClass;
typedef struct _MailConversationListItemSwipeAffordancePrivate MailConversationListItemSwipeAffordancePrivate;
enum  {
	MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_0_PROPERTY,
	MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ALIGNMENT_PROPERTY,
	MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ICON_NAME_PROPERTY,
	MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_LABEL_PROPERTY,
	MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_NUM_PROPERTIES
};
static GParamSpec* mail_conversation_list_item_swipe_affordance_properties[MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_NUM_PROPERTIES];

#define MAIL_TYPE_MAIN_WINDOW (mail_main_window_get_type ())
#define MAIL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MAIN_WINDOW, MailMainWindow))
#define MAIL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MAIN_WINDOW, MailMainWindowClass))
#define MAIL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MAIN_WINDOW))
#define MAIL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MAIN_WINDOW))
#define MAIL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MAIN_WINDOW, MailMainWindowClass))

typedef struct _MailMainWindow MailMainWindow;
typedef struct _MailMainWindowClass MailMainWindowClass;
enum  {
	MAIL_CONVERSATION_LIST_ITEM_SELECT_SIGNAL,
	MAIL_CONVERSATION_LIST_ITEM_NUM_SIGNALS
};
static guint mail_conversation_list_item_signals[MAIL_CONVERSATION_LIST_ITEM_NUM_SIGNALS] = {0};

struct _VirtualizingListBoxRow {
	GtkBin parent_instance;
	VirtualizingListBoxRowPrivate * priv;
};

struct _VirtualizingListBoxRowClass {
	GtkBinClass parent_class;
};

struct _MailConversationListItem {
	VirtualizingListBoxRow parent_instance;
	MailConversationListItemPrivate * priv;
};

struct _MailConversationListItemClass {
	VirtualizingListBoxRowClass parent_class;
};

struct _MailConversationListItemPrivate {
	GtkImage* status_icon;
	GtkLabel* date;
	GtkLabel* messages;
	GtkLabel* source;
	GtkLabel* topic;
	GtkRevealer* flagged_icon_revealer;
	GtkRevealer* status_revealer;
	GtkGrid* grid;
	HdyCarousel* carousel;
	GtkGestureMultiPress* gesture_controller;
	GtkEventControllerKey* key_controller;
};

struct _MailConversationListItemSwipeAffordance {
	GtkBox parent_instance;
	MailConversationListItemSwipeAffordancePrivate * priv;
};

struct _MailConversationListItemSwipeAffordanceClass {
	GtkBoxClass parent_class;
};

struct _MailConversationListItemSwipeAffordancePrivate {
	GtkAlign _alignment;
	gchar* _icon_name;
	gchar* _label;
};

static gint MailConversationListItem_private_offset;
static gpointer mail_conversation_list_item_parent_class = NULL;
static gint MailConversationListItemSwipeAffordance_private_offset;
static gpointer mail_conversation_list_item_swipe_affordance_parent_class = NULL;
static GtkCssProvider* mail_conversation_list_item_swipe_affordance_provider;
static GtkCssProvider* mail_conversation_list_item_swipe_affordance_provider = NULL;

VALA_EXTERN GType virtualizing_list_box_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VirtualizingListBoxRow, g_object_unref)
VALA_EXTERN GType mail_conversation_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailConversationListItem, g_object_unref)
VALA_EXTERN GType mail_conversation_item_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailConversationItemModel, g_object_unref)
VALA_EXTERN void mail_conversation_list_item_assign (MailConversationListItem* self,
                                         MailConversationItemModel* data);
VALA_EXTERN gchar* mail_conversation_item_model_get_formatted_date (MailConversationItemModel* self);
VALA_EXTERN const gchar* mail_conversation_item_model_get_subject (MailConversationItemModel* self);
VALA_EXTERN CamelFolderInfoFlags mail_conversation_item_model_get_folder_info_flags (MailConversationItemModel* self);
VALA_EXTERN gchar* mail_conversation_item_model_get_to (MailConversationItemModel* self);
VALA_EXTERN gchar* mail_conversation_item_model_get_from (MailConversationItemModel* self);
VALA_EXTERN guint mail_conversation_item_model_get_num_messages (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_unread (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_replied_all (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_replied (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_forwarded (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_flagged (MailConversationItemModel* self);
static void mail_conversation_list_item_create_context_menu (MailConversationListItem* self,
                                                      gdouble* x,
                                                      gdouble* y);
VALA_EXTERN GObject* virtualizing_list_box_row_get_model_item (VirtualizingListBoxRow* self);
VALA_EXTERN MailConversationListItem* mail_conversation_list_item_new (void);
VALA_EXTERN MailConversationListItem* mail_conversation_list_item_construct (GType object_type);
VALA_EXTERN VirtualizingListBoxRow* virtualizing_list_box_row_new (void);
VALA_EXTERN VirtualizingListBoxRow* virtualizing_list_box_row_construct (GType object_type);
static GType mail_conversation_list_item_swipe_affordance_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailConversationListItemSwipeAffordance, g_object_unref)
static MailConversationListItemSwipeAffordance* mail_conversation_list_item_swipe_affordance_new (const gchar* label,
                                                                                           const gchar* icon_name,
                                                                                           GtkAlign alignment);
static MailConversationListItemSwipeAffordance* mail_conversation_list_item_swipe_affordance_construct (GType object_type,
                                                                                                 const gchar* label,
                                                                                                 const gchar* icon_name,
                                                                                                 GtkAlign alignment);
static GtkAlign mail_conversation_list_item_swipe_affordance_get_alignment (MailConversationListItemSwipeAffordance* self);
static void mail_conversation_list_item_swipe_affordance_set_alignment (MailConversationListItemSwipeAffordance* self,
                                                                 GtkAlign value);
static const gchar* mail_conversation_list_item_swipe_affordance_get_icon_name (MailConversationListItemSwipeAffordance* self);
static void mail_conversation_list_item_swipe_affordance_set_icon_name (MailConversationListItemSwipeAffordance* self,
                                                                 const gchar* value);
static const gchar* mail_conversation_list_item_swipe_affordance_get_label (MailConversationListItemSwipeAffordance* self);
static void mail_conversation_list_item_swipe_affordance_set_label (MailConversationListItemSwipeAffordance* self,
                                                             const gchar* value);
static GObject * mail_conversation_list_item_swipe_affordance_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties);
static void mail_conversation_list_item_swipe_affordance_finalize (GObject * obj);
static GType mail_conversation_list_item_swipe_affordance_get_type_once (void);
static void _vala_mail_conversation_list_item_swipe_affordance_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_mail_conversation_list_item_swipe_affordance_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static GObject * mail_conversation_list_item_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _mail_conversation_list_item___lambda45_ (MailConversationListItem* self,
                                               gint n_press,
                                               gdouble x,
                                               gdouble y);
static void __mail_conversation_list_item___lambda45__gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                 gint n_press,
                                                                                 gdouble x,
                                                                                 gdouble y,
                                                                                 gpointer self);
static void _mail_conversation_list_item___lambda46_ (MailConversationListItem* self,
                                               guint keyval);
static void __mail_conversation_list_item___lambda46__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                      guint keyval,
                                                                                      guint keycode,
                                                                                      GdkModifierType state,
                                                                                      gpointer self);
static void _mail_conversation_list_item___lambda47_ (MailConversationListItem* self,
                                               guint index);
VALA_EXTERN GType mail_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMainWindow, g_object_unref)
static gboolean __lambda48_ (MailConversationListItem* self);
static gboolean ___lambda48__gsource_func (gpointer self);
static void __mail_conversation_list_item___lambda47__hdy_carousel_page_changed (HdyCarousel* _sender,
                                                                          guint index,
                                                                          gpointer self);
static void mail_conversation_list_item_finalize (GObject * obj);
static GType mail_conversation_list_item_get_type_once (void);

static inline gpointer
mail_conversation_list_item_get_instance_private (MailConversationListItem* self)
{
	return G_STRUCT_MEMBER_P (self, MailConversationListItem_private_offset);
}

void
mail_conversation_list_item_assign (MailConversationListItem* self,
                                    MailConversationItemModel* data)
{
	HdyCarousel* _tmp0_;
	GtkGrid* _tmp1_;
	GtkLabel* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* source_label_text = NULL;
	gchar* _tmp9_;
	CamelFolderInfoFlags _tmp10_;
	CamelFolderInfoFlags _tmp11_;
	GtkLabel* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	guint num_messages = 0U;
	guint _tmp25_;
	guint _tmp26_;
	gchar* _tmp27_ = NULL;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkLabel* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	GtkRevealer* _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp65_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = self->priv->grid;
	hdy_carousel_scroll_to_full (_tmp0_, (GtkWidget*) _tmp1_, (gint64) 0);
	_tmp2_ = self->priv->date;
	_tmp3_ = mail_conversation_item_model_get_formatted_date (data);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->topic;
	_tmp7_ = mail_conversation_item_model_get_subject (data);
	_tmp8_ = _tmp7_;
	gtk_label_set_label (_tmp6_, _tmp8_);
	_tmp9_ = g_strdup ("");
	source_label_text = _tmp9_;
	_tmp10_ = mail_conversation_item_model_get_folder_info_flags (data);
	_tmp11_ = _tmp10_;
	if (CAMEL_FOLDER_TYPE_SENT == (_tmp11_ & CAMEL_FOLDER_TYPE_MASK)) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = mail_conversation_item_model_get_to (data);
		_tmp13_ = _tmp12_;
		_g_free0 (source_label_text);
		source_label_text = _tmp13_;
	} else {
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = mail_conversation_item_model_get_from (data);
		_tmp15_ = _tmp14_;
		_g_free0 (source_label_text);
		source_label_text = _tmp15_;
	}
	_tmp16_ = self->priv->source;
	_tmp17_ = source_label_text;
	_tmp18_ = g_markup_escape_text (_tmp17_, (gssize) -1);
	_tmp19_ = _tmp18_;
	gtk_label_set_label (_tmp16_, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = source_label_text;
	_tmp21_ = mail_conversation_item_model_get_subject (data);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_markup_printf_escaped ("<b>%s</b>\n%s", _tmp20_, _tmp22_);
	_tmp24_ = _tmp23_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) self, _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = mail_conversation_item_model_get_num_messages (data);
	_tmp26_ = _tmp25_;
	num_messages = _tmp26_;
	if (num_messages > ((guint) 1)) {
		gchar* _tmp28_;
		_tmp28_ = g_strdup_printf ("%u", num_messages);
		_g_free0 (_tmp27_);
		_tmp27_ = _tmp28_;
	} else {
		_g_free0 (_tmp27_);
		_tmp27_ = NULL;
	}
	_tmp29_ = self->priv->messages;
	gtk_label_set_label (_tmp29_, _tmp27_);
	_tmp30_ = self->priv->messages;
	gtk_widget_set_visible ((GtkWidget*) _tmp30_, num_messages > ((guint) 1));
	_tmp31_ = self->priv->messages;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp31_, num_messages <= ((guint) 1));
	_tmp32_ = mail_conversation_item_model_get_unread (data);
	_tmp33_ = _tmp32_;
	if (_tmp33_) {
		GtkGrid* _tmp34_;
		GtkStyleContext* _tmp35_;
		GtkImage* _tmp36_;
		GtkImage* _tmp37_;
		GtkImage* _tmp38_;
		GtkStyleContext* _tmp39_;
		GtkRevealer* _tmp40_;
		GtkLabel* _tmp41_;
		GtkStyleContext* _tmp42_;
		_tmp34_ = self->priv->grid;
		_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
		gtk_style_context_add_class (_tmp35_, "unread-message");
		_tmp36_ = self->priv->status_icon;
		g_object_set (_tmp36_, "icon-name", "mail-unread-symbolic", NULL);
		_tmp37_ = self->priv->status_icon;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp37_, _ ("Unread"));
		_tmp38_ = self->priv->status_icon;
		_tmp39_ = gtk_widget_get_style_context ((GtkWidget*) _tmp38_);
		gtk_style_context_add_class (_tmp39_, GRANITE_STYLE_CLASS_ACCENT);
		_tmp40_ = self->priv->status_revealer;
		gtk_revealer_set_reveal_child (_tmp40_, TRUE);
		_tmp41_ = self->priv->source;
		_tmp42_ = gtk_widget_get_style_context ((GtkWidget*) _tmp41_);
		gtk_style_context_add_class (_tmp42_, GRANITE_STYLE_CLASS_ACCENT);
	} else {
		GtkGrid* _tmp43_;
		GtkStyleContext* _tmp44_;
		GtkImage* _tmp45_;
		GtkStyleContext* _tmp46_;
		GtkLabel* _tmp47_;
		GtkStyleContext* _tmp48_;
		gboolean _tmp49_ = FALSE;
		gboolean _tmp50_;
		gboolean _tmp51_;
		_tmp43_ = self->priv->grid;
		_tmp44_ = gtk_widget_get_style_context ((GtkWidget*) _tmp43_);
		gtk_style_context_remove_class (_tmp44_, "unread-message");
		_tmp45_ = self->priv->status_icon;
		_tmp46_ = gtk_widget_get_style_context ((GtkWidget*) _tmp45_);
		gtk_style_context_remove_class (_tmp46_, GRANITE_STYLE_CLASS_ACCENT);
		_tmp47_ = self->priv->source;
		_tmp48_ = gtk_widget_get_style_context ((GtkWidget*) _tmp47_);
		gtk_style_context_remove_class (_tmp48_, GRANITE_STYLE_CLASS_ACCENT);
		_tmp50_ = mail_conversation_item_model_get_replied_all (data);
		_tmp51_ = _tmp50_;
		if (_tmp51_) {
			_tmp49_ = TRUE;
		} else {
			gboolean _tmp52_;
			gboolean _tmp53_;
			_tmp52_ = mail_conversation_item_model_get_replied (data);
			_tmp53_ = _tmp52_;
			_tmp49_ = _tmp53_;
		}
		if (_tmp49_) {
			GtkImage* _tmp54_;
			GtkImage* _tmp55_;
			GtkRevealer* _tmp56_;
			_tmp54_ = self->priv->status_icon;
			g_object_set (_tmp54_, "icon-name", "mail-replied-symbolic", NULL);
			_tmp55_ = self->priv->status_icon;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp55_, _ ("Replied"));
			_tmp56_ = self->priv->status_revealer;
			gtk_revealer_set_reveal_child (_tmp56_, TRUE);
		} else {
			gboolean _tmp57_;
			gboolean _tmp58_;
			_tmp57_ = mail_conversation_item_model_get_forwarded (data);
			_tmp58_ = _tmp57_;
			if (_tmp58_) {
				GtkImage* _tmp59_;
				GtkImage* _tmp60_;
				GtkRevealer* _tmp61_;
				_tmp59_ = self->priv->status_icon;
				g_object_set (_tmp59_, "icon-name", "mail-forwarded-symbolic", NULL);
				_tmp60_ = self->priv->status_icon;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp60_, _ ("Forwarded"));
				_tmp61_ = self->priv->status_revealer;
				gtk_revealer_set_reveal_child (_tmp61_, TRUE);
			} else {
				GtkRevealer* _tmp62_;
				_tmp62_ = self->priv->status_revealer;
				gtk_revealer_set_reveal_child (_tmp62_, FALSE);
			}
		}
	}
	_tmp63_ = self->priv->flagged_icon_revealer;
	_tmp64_ = mail_conversation_item_model_get_flagged (data);
	_tmp65_ = _tmp64_;
	gtk_revealer_set_reveal_child (_tmp63_, _tmp65_);
	_g_free0 (_tmp27_);
	_g_free0 (source_label_text);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mail_conversation_list_item_create_context_menu (MailConversationListItem* self,
                                                 gdouble* x,
                                                 gdouble* y)
{
	MailConversationItemModel* item = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	MailConversationItemModel* _tmp2_;
	GtkMenu* menu = NULL;
	GtkWidget* _tmp3_;
	GtkMenu* _tmp4_ = NULL;
	GtkMenuItem* trash_menu_item = NULL;
	gchar* _tmp5_;
	GraniteAccelLabel* _tmp6_;
	GtkMenuItem* _tmp7_ = NULL;
	GtkMenu* _tmp8_;
	GtkMenuItem* _tmp9_;
	MailConversationItemModel* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	MailConversationItemModel* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	GtkMenu* _tmp36_;
	GtkMenu* _tmp37_;
	gboolean _tmp38_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = virtualizing_list_box_row_get_model_item ((VirtualizingListBoxRow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
	item = _tmp2_;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) self);
	_tmp4_ = (GtkMenu*) gtk_menu_new ();
	g_object_set (_tmp4_, "attach-widget", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	menu = _tmp4_;
	_tmp5_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH);
	_tmp6_ = granite_accel_label_new_from_action_name (_ ("Move To Trash"), MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp7_, _tmp5_);
	_g_free0 (_tmp5_);
	g_object_set ((GtkContainer*) _tmp7_, "child", (GtkWidget*) _tmp6_, NULL);
	_g_object_unref0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	trash_menu_item = _tmp7_;
	_tmp8_ = menu;
	_tmp9_ = trash_menu_item;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = item;
	_tmp11_ = mail_conversation_item_model_get_unread (_tmp10_);
	_tmp12_ = _tmp11_;
	if (!_tmp12_) {
		GtkMenuItem* mark_unread_menu_item = NULL;
		gchar* _tmp13_;
		GraniteAccelLabel* _tmp14_;
		GtkMenuItem* _tmp15_ = NULL;
		GtkMenu* _tmp16_;
		GtkMenuItem* _tmp17_;
		_tmp13_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD);
		_tmp14_ = granite_accel_label_new_from_action_name (_ ("Mark As Unread"), MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD);
		g_object_ref_sink (_tmp14_);
		_tmp15_ = (GtkMenuItem*) gtk_menu_item_new ();
		gtk_actionable_set_action_name ((GtkActionable*) _tmp15_, _tmp13_);
		_g_free0 (_tmp13_);
		g_object_set ((GtkContainer*) _tmp15_, "child", (GtkWidget*) _tmp14_, NULL);
		_g_object_unref0 (_tmp14_);
		g_object_ref_sink (_tmp15_);
		mark_unread_menu_item = _tmp15_;
		_tmp16_ = menu;
		_tmp17_ = mark_unread_menu_item;
		gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
		_g_object_unref0 (mark_unread_menu_item);
	} else {
		GtkMenuItem* mark_read_menu_item = NULL;
		gchar* _tmp18_;
		GraniteAccelLabel* _tmp19_;
		GtkMenuItem* _tmp20_ = NULL;
		GtkMenu* _tmp21_;
		GtkMenuItem* _tmp22_;
		_tmp18_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_READ);
		_tmp19_ = granite_accel_label_new_from_action_name (_ ("Mark as Read"), MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_READ);
		g_object_ref_sink (_tmp19_);
		_tmp20_ = (GtkMenuItem*) gtk_menu_item_new ();
		gtk_actionable_set_action_name ((GtkActionable*) _tmp20_, _tmp18_);
		_g_free0 (_tmp18_);
		g_object_set ((GtkContainer*) _tmp20_, "child", (GtkWidget*) _tmp19_, NULL);
		_g_object_unref0 (_tmp19_);
		g_object_ref_sink (_tmp20_);
		mark_read_menu_item = _tmp20_;
		_tmp21_ = menu;
		_tmp22_ = mark_read_menu_item;
		gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
		_g_object_unref0 (mark_read_menu_item);
	}
	_tmp23_ = item;
	_tmp24_ = mail_conversation_item_model_get_flagged (_tmp23_);
	_tmp25_ = _tmp24_;
	if (!_tmp25_) {
		GtkMenuItem* mark_starred_menu_item = NULL;
		gchar* _tmp26_;
		GraniteAccelLabel* _tmp27_;
		GtkMenuItem* _tmp28_ = NULL;
		GtkMenu* _tmp29_;
		GtkMenuItem* _tmp30_;
		_tmp26_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_STAR);
		_tmp27_ = granite_accel_label_new_from_action_name (_ ("Star"), MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_STAR);
		g_object_ref_sink (_tmp27_);
		_tmp28_ = (GtkMenuItem*) gtk_menu_item_new ();
		gtk_actionable_set_action_name ((GtkActionable*) _tmp28_, _tmp26_);
		_g_free0 (_tmp26_);
		g_object_set ((GtkContainer*) _tmp28_, "child", (GtkWidget*) _tmp27_, NULL);
		_g_object_unref0 (_tmp27_);
		g_object_ref_sink (_tmp28_);
		mark_starred_menu_item = _tmp28_;
		_tmp29_ = menu;
		_tmp30_ = mark_starred_menu_item;
		gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
		_g_object_unref0 (mark_starred_menu_item);
	} else {
		GtkMenuItem* mark_unstarred_menu_item = NULL;
		gchar* _tmp31_;
		GraniteAccelLabel* _tmp32_;
		GtkMenuItem* _tmp33_ = NULL;
		GtkMenu* _tmp34_;
		GtkMenuItem* _tmp35_;
		_tmp31_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR);
		_tmp32_ = granite_accel_label_new_from_action_name (_ ("Unstar"), MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR);
		g_object_ref_sink (_tmp32_);
		_tmp33_ = (GtkMenuItem*) gtk_menu_item_new ();
		gtk_actionable_set_action_name ((GtkActionable*) _tmp33_, _tmp31_);
		_g_free0 (_tmp31_);
		g_object_set ((GtkContainer*) _tmp33_, "child", (GtkWidget*) _tmp32_, NULL);
		_g_object_unref0 (_tmp32_);
		g_object_ref_sink (_tmp33_);
		mark_unstarred_menu_item = _tmp33_;
		_tmp34_ = menu;
		_tmp35_ = mark_unstarred_menu_item;
		gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
		_g_object_unref0 (mark_unstarred_menu_item);
	}
	_tmp36_ = menu;
	gtk_widget_show_all ((GtkWidget*) _tmp36_);
	_tmp37_ = menu;
	gtk_menu_popup_at_pointer (_tmp37_, NULL);
	if (x == NULL) {
		_tmp38_ = TRUE;
	} else {
		_tmp38_ = y == NULL;
	}
	if (_tmp38_) {
		GtkMenu* _tmp39_;
		_tmp39_ = menu;
		gtk_menu_popup_at_widget (_tmp39_, (GtkWidget*) self, GDK_GRAVITY_EAST, GDK_GRAVITY_CENTER, NULL);
	} else {
		GtkMenu* _tmp40_;
		_tmp40_ = menu;
		gtk_menu_popup_at_pointer (_tmp40_, NULL);
	}
	_g_object_unref0 (trash_menu_item);
	_g_object_unref0 (menu);
	_g_object_unref0 (item);
}

MailConversationListItem*
mail_conversation_list_item_construct (GType object_type)
{
	MailConversationListItem * self = NULL;
	self = (MailConversationListItem*) virtualizing_list_box_row_construct (object_type);
	return self;
}

MailConversationListItem*
mail_conversation_list_item_new (void)
{
	return mail_conversation_list_item_construct (MAIL_TYPE_CONVERSATION_LIST_ITEM);
}

static inline gpointer
mail_conversation_list_item_swipe_affordance_get_instance_private (MailConversationListItemSwipeAffordance* self)
{
	return G_STRUCT_MEMBER_P (self, MailConversationListItemSwipeAffordance_private_offset);
}

static MailConversationListItemSwipeAffordance*
mail_conversation_list_item_swipe_affordance_construct (GType object_type,
                                                        const gchar* label,
                                                        const gchar* icon_name,
                                                        GtkAlign alignment)
{
	MailConversationListItemSwipeAffordance * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (MailConversationListItemSwipeAffordance*) g_object_new (object_type, "alignment", alignment, "icon-name", icon_name, "label", label, NULL);
	return self;
}

static MailConversationListItemSwipeAffordance*
mail_conversation_list_item_swipe_affordance_new (const gchar* label,
                                                  const gchar* icon_name,
                                                  GtkAlign alignment)
{
	return mail_conversation_list_item_swipe_affordance_construct (MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE, label, icon_name, alignment);
}

static GtkAlign
mail_conversation_list_item_swipe_affordance_get_alignment (MailConversationListItemSwipeAffordance* self)
{
	GtkAlign result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_alignment;
	return result;
}

static void
mail_conversation_list_item_swipe_affordance_set_alignment (MailConversationListItemSwipeAffordance* self,
                                                            GtkAlign value)
{
	GtkAlign old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_list_item_swipe_affordance_get_alignment (self);
	if (old_value != value) {
		self->priv->_alignment = value;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_list_item_swipe_affordance_properties[MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ALIGNMENT_PROPERTY]);
	}
}

static const gchar*
mail_conversation_list_item_swipe_affordance_get_icon_name (MailConversationListItemSwipeAffordance* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
mail_conversation_list_item_swipe_affordance_set_icon_name (MailConversationListItemSwipeAffordance* self,
                                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_list_item_swipe_affordance_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_list_item_swipe_affordance_properties[MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ICON_NAME_PROPERTY]);
	}
}

static const gchar*
mail_conversation_list_item_swipe_affordance_get_label (MailConversationListItemSwipeAffordance* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
mail_conversation_list_item_swipe_affordance_set_label (MailConversationListItemSwipeAffordance* self,
                                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_list_item_swipe_affordance_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_list_item_swipe_affordance_properties[MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_LABEL_PROPERTY]);
	}
}

static GObject *
mail_conversation_list_item_swipe_affordance_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailConversationListItemSwipeAffordance * self;
	GtkImage* image = NULL;
	const gchar* _tmp0_;
	GtkImage* _tmp1_;
	GtkLabel* label = NULL;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkLabel* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkCssProvider* _tmp8_;
	GtkBox* box = NULL;
	GtkAlign _tmp9_;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_;
	GtkImage* _tmp12_;
	GtkBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkBox* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkCssProvider* _tmp17_;
	GtkAlign _tmp18_;
	parent_class = G_OBJECT_CLASS (mail_conversation_list_item_swipe_affordance_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE, MailConversationListItemSwipeAffordance);
	_tmp0_ = self->priv->_icon_name;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp0_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	image = _tmp1_;
	_tmp2_ = self->priv->_label;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	label = _tmp3_;
	_tmp4_ = label;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp6_ = label;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	_tmp8_ = mail_conversation_list_item_swipe_affordance_provider;
	gtk_style_context_add_provider (_tmp7_, (GtkStyleProvider*) _tmp8_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp9_ = self->priv->_alignment;
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, _tmp9_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_CENTER);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp10_, FALSE);
	g_object_ref_sink (_tmp10_);
	box = _tmp10_;
	_tmp11_ = box;
	_tmp12_ = image;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = box;
	_tmp14_ = label;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp15_);
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp17_ = mail_conversation_list_item_swipe_affordance_provider;
	gtk_style_context_add_provider (_tmp16_, (GtkStyleProvider*) _tmp17_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp18_ = self->priv->_alignment;
	if (_tmp18_ == GTK_ALIGN_START) {
		GtkStyleContext* _tmp19_;
		_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp19_, "start");
	} else {
		GtkAlign _tmp20_;
		_tmp20_ = self->priv->_alignment;
		if (_tmp20_ == GTK_ALIGN_END) {
			GtkStyleContext* _tmp21_;
			_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) self);
			gtk_style_context_add_class (_tmp21_, "end");
		}
	}
	_g_object_unref0 (box);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	return obj;
}

static void
mail_conversation_list_item_swipe_affordance_base_init (MailConversationListItemSwipeAffordanceClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "affordance");
}

static void
mail_conversation_list_item_swipe_affordance_class_init (MailConversationListItemSwipeAffordanceClass * klass,
                                                         gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	mail_conversation_list_item_swipe_affordance_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailConversationListItemSwipeAffordance_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_conversation_list_item_swipe_affordance_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_conversation_list_item_swipe_affordance_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_conversation_list_item_swipe_affordance_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_conversation_list_item_swipe_affordance_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ALIGNMENT_PROPERTY, mail_conversation_list_item_swipe_affordance_properties[MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ALIGNMENT_PROPERTY] = g_param_spec_enum ("alignment", "alignment", "alignment", gtk_align_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ICON_NAME_PROPERTY, mail_conversation_list_item_swipe_affordance_properties[MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_LABEL_PROPERTY, mail_conversation_list_item_swipe_affordance_properties[MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (mail_conversation_list_item_swipe_affordance_provider);
	mail_conversation_list_item_swipe_affordance_provider = _tmp0_;
	_tmp1_ = mail_conversation_list_item_swipe_affordance_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "io/elementary/mail/ConversationListItem.css");
}

static void
mail_conversation_list_item_swipe_affordance_instance_init (MailConversationListItemSwipeAffordance * self,
                                                            gpointer klass)
{
	self->priv = mail_conversation_list_item_swipe_affordance_get_instance_private (self);
}

static void
mail_conversation_list_item_swipe_affordance_finalize (GObject * obj)
{
	MailConversationListItemSwipeAffordance * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE, MailConversationListItemSwipeAffordance);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_label);
	G_OBJECT_CLASS (mail_conversation_list_item_swipe_affordance_parent_class)->finalize (obj);
}

static GType
mail_conversation_list_item_swipe_affordance_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailConversationListItemSwipeAffordanceClass), (GBaseInitFunc) mail_conversation_list_item_swipe_affordance_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_conversation_list_item_swipe_affordance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailConversationListItemSwipeAffordance), 0, (GInstanceInitFunc) mail_conversation_list_item_swipe_affordance_instance_init, NULL };
	GType mail_conversation_list_item_swipe_affordance_type_id;
	mail_conversation_list_item_swipe_affordance_type_id = g_type_register_static (gtk_box_get_type (), "MailConversationListItemSwipeAffordance", &g_define_type_info, 0);
	MailConversationListItemSwipeAffordance_private_offset = g_type_add_instance_private (mail_conversation_list_item_swipe_affordance_type_id, sizeof (MailConversationListItemSwipeAffordancePrivate));
	return mail_conversation_list_item_swipe_affordance_type_id;
}

static GType
mail_conversation_list_item_swipe_affordance_get_type (void)
{
	static volatile gsize mail_conversation_list_item_swipe_affordance_type_id__once = 0;
	if (g_once_init_enter (&mail_conversation_list_item_swipe_affordance_type_id__once)) {
		GType mail_conversation_list_item_swipe_affordance_type_id;
		mail_conversation_list_item_swipe_affordance_type_id = mail_conversation_list_item_swipe_affordance_get_type_once ();
		g_once_init_leave (&mail_conversation_list_item_swipe_affordance_type_id__once, mail_conversation_list_item_swipe_affordance_type_id);
	}
	return mail_conversation_list_item_swipe_affordance_type_id__once;
}

static void
_vala_mail_conversation_list_item_swipe_affordance_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	MailConversationListItemSwipeAffordance * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE, MailConversationListItemSwipeAffordance);
	switch (property_id) {
		case MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ALIGNMENT_PROPERTY:
		g_value_set_enum (value, mail_conversation_list_item_swipe_affordance_get_alignment (self));
		break;
		case MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ICON_NAME_PROPERTY:
		g_value_set_string (value, mail_conversation_list_item_swipe_affordance_get_icon_name (self));
		break;
		case MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_LABEL_PROPERTY:
		g_value_set_string (value, mail_conversation_list_item_swipe_affordance_get_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_conversation_list_item_swipe_affordance_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	MailConversationListItemSwipeAffordance * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_CONVERSATION_LIST_ITEM_TYPE_SWIPE_AFFORDANCE, MailConversationListItemSwipeAffordance);
	switch (property_id) {
		case MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ALIGNMENT_PROPERTY:
		mail_conversation_list_item_swipe_affordance_set_alignment (self, g_value_get_enum (value));
		break;
		case MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_ICON_NAME_PROPERTY:
		mail_conversation_list_item_swipe_affordance_set_icon_name (self, g_value_get_string (value));
		break;
		case MAIL_CONVERSATION_LIST_ITEM_SWIPE_AFFORDANCE_LABEL_PROPERTY:
		mail_conversation_list_item_swipe_affordance_set_label (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_mail_conversation_list_item___lambda45_ (MailConversationListItem* self,
                                          gint n_press,
                                          gdouble x,
                                          gdouble y)
{
	g_signal_emit (self, mail_conversation_list_item_signals[MAIL_CONVERSATION_LIST_ITEM_SELECT_SIGNAL], 0);
	mail_conversation_list_item_create_context_menu (self, &x, &y);
}

static void
__mail_conversation_list_item___lambda45__gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                            gint n_press,
                                                                            gdouble x,
                                                                            gdouble y,
                                                                            gpointer self)
{
	_mail_conversation_list_item___lambda45_ ((MailConversationListItem*) self, n_press, x, y);
}

static void
_mail_conversation_list_item___lambda46_ (MailConversationListItem* self,
                                          guint keyval)
{
	if (keyval != GDK_KEY_Menu) {
		return;
	}
	mail_conversation_list_item_create_context_menu (self, NULL, NULL);
}

static void
__mail_conversation_list_item___lambda46__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                 guint keyval,
                                                                                 guint keycode,
                                                                                 GdkModifierType state,
                                                                                 gpointer self)
{
	_mail_conversation_list_item___lambda46_ ((MailConversationListItem*) self, keyval);
}

static gboolean
__lambda48_ (MailConversationListItem* self)
{
	HdyCarousel* _tmp0_;
	GtkGrid* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->carousel;
	_tmp1_ = self->priv->grid;
	hdy_carousel_scroll_to_full (_tmp0_, (GtkWidget*) _tmp1_, (gint64) 0);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda48__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda48_ ((MailConversationListItem*) self);
	return result;
}

static void
_mail_conversation_list_item___lambda47_ (MailConversationListItem* self,
                                          guint index)
{
	MailMainWindow* main_window = NULL;
	GtkWidget* _tmp0_;
	MailMainWindow* _tmp1_;
	if (index == ((guint) 1)) {
		return;
	}
	g_signal_emit (self, mail_conversation_list_item_signals[MAIL_CONVERSATION_LIST_ITEM_SELECT_SIGNAL], 0);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, MAIL_TYPE_MAIN_WINDOW, MailMainWindow));
	main_window = _tmp1_;
	if (index == ((guint) 2)) {
		MailMainWindow* _tmp2_;
		_tmp2_ = main_window;
		g_action_group_activate_action ((GActionGroup*) _tmp2_, MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH, NULL);
	} else {
		if (index == ((guint) 0)) {
			MailMainWindow* _tmp3_;
			_tmp3_ = main_window;
			g_action_group_activate_action ((GActionGroup*) _tmp3_, MAIL_MAIN_WINDOW_ACTION_ARCHIVE, NULL);
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda48__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (main_window);
}

static void
__mail_conversation_list_item___lambda47__hdy_carousel_page_changed (HdyCarousel* _sender,
                                                                     guint index,
                                                                     gpointer self)
{
	_mail_conversation_list_item___lambda47_ ((MailConversationListItem*) self, index);
}

static GObject *
mail_conversation_list_item_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailConversationListItem * self;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkWidget* _tmp2_;
	GtkRevealer* _tmp3_ = NULL;
	GtkImage* flagged_icon = NULL;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkWidget* _tmp6_;
	GtkRevealer* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkLabel* _tmp11_ = NULL;
	GtkStyleContext* messages_style = NULL;
	GtkLabel* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkGrid* _tmp20_ = NULL;
	GtkGrid* _tmp21_;
	GtkRevealer* _tmp22_;
	GtkGrid* _tmp23_;
	GtkRevealer* _tmp24_;
	GtkGrid* _tmp25_;
	GtkLabel* _tmp26_;
	GtkGrid* _tmp27_;
	GtkLabel* _tmp28_;
	GtkGrid* _tmp29_;
	GtkLabel* _tmp30_;
	GtkGrid* _tmp31_;
	GtkLabel* _tmp32_;
	MailConversationListItemSwipeAffordance* archive_affordance = NULL;
	MailConversationListItemSwipeAffordance* _tmp33_;
	MailConversationListItemSwipeAffordance* _tmp34_;
	GtkStyleContext* _tmp35_;
	MailConversationListItemSwipeAffordance* trash_affordance = NULL;
	MailConversationListItemSwipeAffordance* _tmp36_;
	MailConversationListItemSwipeAffordance* _tmp37_;
	GtkStyleContext* _tmp38_;
	HdyCarousel* _tmp39_ = NULL;
	HdyCarousel* _tmp40_;
	MailConversationListItemSwipeAffordance* _tmp41_;
	HdyCarousel* _tmp42_;
	GtkGrid* _tmp43_;
	HdyCarousel* _tmp44_;
	MailConversationListItemSwipeAffordance* _tmp45_;
	HdyCarousel* _tmp46_;
	GtkGrid* _tmp47_;
	GtkStyleContext* _tmp48_;
	HdyCarousel* _tmp49_;
	GtkGestureMultiPress* _tmp50_ = NULL;
	GtkGestureMultiPress* _tmp51_;
	GtkEventControllerKey* _tmp52_;
	GtkEventControllerKey* _tmp53_;
	HdyCarousel* _tmp54_;
	parent_class = G_OBJECT_CLASS (mail_conversation_list_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_CONVERSATION_LIST_ITEM, MailConversationListItem);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("mail-unread-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->status_icon);
	self->priv->status_icon = _tmp0_;
	_tmp1_ = self->priv->status_icon;
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
	_tmp3_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp3_, "child", _tmp2_, NULL);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->status_revealer);
	self->priv->status_revealer = _tmp3_;
	_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name ("starred-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp4_);
	flagged_icon = _tmp4_;
	_tmp5_ = flagged_icon;
	_tmp6_ = _g_object_ref0 ((GtkWidget*) _tmp5_);
	_tmp7_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp7_, "child", _tmp6_, NULL);
	_g_object_unref0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->flagged_icon_revealer);
	self->priv->flagged_icon_revealer = _tmp7_;
	_tmp8_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	gtk_label_set_ellipsize (_tmp8_, PANGO_ELLIPSIZE_END);
	gtk_label_set_use_markup (_tmp8_, TRUE);
	gtk_label_set_xalign (_tmp8_, (gfloat) 0);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->source);
	self->priv->source = _tmp8_;
	_tmp9_ = self->priv->source;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_add_class (_tmp10_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp11_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->messages);
	self->priv->messages = _tmp11_;
	_tmp12_ = self->priv->messages;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	messages_style = _tmp13_;
	_tmp14_ = messages_style;
	gtk_style_context_add_class (_tmp14_, GRANITE_STYLE_CLASS_BADGE);
	_tmp15_ = messages_style;
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_FLAT);
	_tmp16_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp16_, TRUE);
	gtk_label_set_ellipsize (_tmp16_, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (_tmp16_, (gfloat) 0);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->topic);
	self->priv->topic = _tmp16_;
	_tmp17_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->date);
	self->priv->date = _tmp17_;
	_tmp18_ = self->priv->date;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp20_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp20_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp20_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp20_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp20_, 12);
	gtk_grid_set_column_spacing (_tmp20_, 12);
	gtk_grid_set_row_spacing (_tmp20_, 6);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp20_, TRUE);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp20_;
	_tmp21_ = self->priv->grid;
	_tmp22_ = self->priv->status_revealer;
	gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, 0, 0, 1, 1);
	_tmp23_ = self->priv->grid;
	_tmp24_ = self->priv->flagged_icon_revealer;
	gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp24_, 0, 1, 1, 1);
	_tmp25_ = self->priv->grid;
	_tmp26_ = self->priv->source;
	gtk_grid_attach (_tmp25_, (GtkWidget*) _tmp26_, 1, 0, 1, 1);
	_tmp27_ = self->priv->grid;
	_tmp28_ = self->priv->date;
	gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, 2, 0, 2, 1);
	_tmp29_ = self->priv->grid;
	_tmp30_ = self->priv->topic;
	gtk_grid_attach (_tmp29_, (GtkWidget*) _tmp30_, 1, 1, 2, 1);
	_tmp31_ = self->priv->grid;
	_tmp32_ = self->priv->messages;
	gtk_grid_attach (_tmp31_, (GtkWidget*) _tmp32_, 3, 1, 1, 1);
	_tmp33_ = mail_conversation_list_item_swipe_affordance_new (_ ("Archive"), "mail-archive-symbolic", GTK_ALIGN_END);
	g_object_ref_sink (_tmp33_);
	archive_affordance = _tmp33_;
	_tmp34_ = archive_affordance;
	_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
	gtk_style_context_add_class (_tmp35_, "archive");
	_tmp36_ = mail_conversation_list_item_swipe_affordance_new (_ ("Trash"), "edit-delete-symbolic", GTK_ALIGN_START);
	g_object_ref_sink (_tmp36_);
	trash_affordance = _tmp36_;
	_tmp37_ = trash_affordance;
	_tmp38_ = gtk_widget_get_style_context ((GtkWidget*) _tmp37_);
	gtk_style_context_add_class (_tmp38_, "trash");
	_tmp39_ = (HdyCarousel*) hdy_carousel_new ();
	hdy_carousel_set_allow_scroll_wheel (_tmp39_, FALSE);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->carousel);
	self->priv->carousel = _tmp39_;
	_tmp40_ = self->priv->carousel;
	_tmp41_ = archive_affordance;
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->carousel;
	_tmp43_ = self->priv->grid;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = self->priv->carousel;
	_tmp45_ = trash_affordance;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = self->priv->carousel;
	_tmp47_ = self->priv->grid;
	hdy_carousel_scroll_to (_tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp48_, "conversation-list-item");
	_tmp49_ = self->priv->carousel;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp49_, NULL);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp50_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp50_, (guint) GDK_BUTTON_SECONDARY);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp50_, GTK_PHASE_BUBBLE);
	_g_object_unref0 (self->priv->gesture_controller);
	self->priv->gesture_controller = _tmp50_;
	_tmp51_ = self->priv->gesture_controller;
	g_signal_connect_object (_tmp51_, "released", (GCallback) __mail_conversation_list_item___lambda45__gtk_gesture_multi_press_released, self, 0);
	_tmp52_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp52_;
	_tmp53_ = self->priv->key_controller;
	g_signal_connect_object (_tmp53_, "key-released", (GCallback) __mail_conversation_list_item___lambda46__gtk_event_controller_key_key_released, self, 0);
	_tmp54_ = self->priv->carousel;
	g_signal_connect_object (_tmp54_, "page-changed", (GCallback) __mail_conversation_list_item___lambda47__hdy_carousel_page_changed, self, 0);
	_g_object_unref0 (trash_affordance);
	_g_object_unref0 (archive_affordance);
	_g_object_unref0 (flagged_icon);
	return obj;
}

static void
mail_conversation_list_item_class_init (MailConversationListItemClass * klass,
                                        gpointer klass_data)
{
	mail_conversation_list_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailConversationListItem_private_offset);
	G_OBJECT_CLASS (klass)->constructor = mail_conversation_list_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_conversation_list_item_finalize;
	mail_conversation_list_item_signals[MAIL_CONVERSATION_LIST_ITEM_SELECT_SIGNAL] = g_signal_new ("select", MAIL_TYPE_CONVERSATION_LIST_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
mail_conversation_list_item_instance_init (MailConversationListItem * self,
                                           gpointer klass)
{
	self->priv = mail_conversation_list_item_get_instance_private (self);
}

static void
mail_conversation_list_item_finalize (GObject * obj)
{
	MailConversationListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_CONVERSATION_LIST_ITEM, MailConversationListItem);
	_g_object_unref0 (self->priv->status_icon);
	_g_object_unref0 (self->priv->date);
	_g_object_unref0 (self->priv->messages);
	_g_object_unref0 (self->priv->source);
	_g_object_unref0 (self->priv->topic);
	_g_object_unref0 (self->priv->flagged_icon_revealer);
	_g_object_unref0 (self->priv->status_revealer);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->carousel);
	_g_object_unref0 (self->priv->gesture_controller);
	_g_object_unref0 (self->priv->key_controller);
	G_OBJECT_CLASS (mail_conversation_list_item_parent_class)->finalize (obj);
}

static GType
mail_conversation_list_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailConversationListItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_conversation_list_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailConversationListItem), 0, (GInstanceInitFunc) mail_conversation_list_item_instance_init, NULL };
	GType mail_conversation_list_item_type_id;
	mail_conversation_list_item_type_id = g_type_register_static (TYPE_VIRTUALIZING_LIST_BOX_ROW, "MailConversationListItem", &g_define_type_info, 0);
	MailConversationListItem_private_offset = g_type_add_instance_private (mail_conversation_list_item_type_id, sizeof (MailConversationListItemPrivate));
	return mail_conversation_list_item_type_id;
}

GType
mail_conversation_list_item_get_type (void)
{
	static volatile gsize mail_conversation_list_item_type_id__once = 0;
	if (g_once_init_enter (&mail_conversation_list_item_type_id__once)) {
		GType mail_conversation_list_item_type_id;
		mail_conversation_list_item_type_id = mail_conversation_list_item_get_type_once ();
		g_once_init_leave (&mail_conversation_list_item_type_id__once, mail_conversation_list_item_type_id);
	}
	return mail_conversation_list_item_type_id__once;
}

