use glib::{Object, Properties, prelude::*, subclass};
use gtk4::{Accessible, Buildable, CompositeTemplate, ConstraintTarget, Widget, subclass::prelude::*};
use libadwaita::{Bin, subclass::prelude::*};
use std::cell::RefCell;

mod imp {
    use super::*;

    #[derive(Debug, Default, CompositeTemplate, Properties)]
    #[properties(wrapper_type = super::ZoomControl)]
    #[template(file = "data/resources/ui_templates/article_view/zoom.blp")]
    pub struct ZoomControl {
        #[property(get, set)]
        pub percentage: RefCell<String>,
    }

    #[glib::object_subclass]
    impl ObjectSubclass for ZoomControl {
        const NAME: &'static str = "ZoomControl";
        type Type = super::ZoomControl;
        type ParentType = Bin;

        fn class_init(klass: &mut Self::Class) {
            klass.bind_template();
        }

        fn instance_init(obj: &subclass::InitializingObject<Self>) {
            obj.init_template();
        }
    }

    #[glib::derived_properties]
    impl ObjectImpl for ZoomControl {}

    impl WidgetImpl for ZoomControl {}

    impl BinImpl for ZoomControl {}
}

glib::wrapper! {
    pub struct ZoomControl(ObjectSubclass<imp::ZoomControl>)
        @extends Widget, Bin,
        @implements Accessible, Buildable, ConstraintTarget;
}

impl Default for ZoomControl {
    fn default() -> Self {
        Object::new()
    }
}
