/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "meta-dbus-input-capture.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_capabilities,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__UINT_UINT_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintUintVariantFunc)
       (void *data1,
        guint arg_barrier_id,
        guint arg_activation_id,
        GVariant *arg_cursor_position,
        void *data2);
  _GDbusCodegenMarshalVoid_UintUintVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintUintVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            g_marshal_value_peek_variant (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_serial,
        GVariant *arg_position,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.InputCapture
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDBusInputCapture
 * @title: MetaDBusInputCapture
 * @short_description: Generated C code for the org.gnome.Mutter.InputCapture D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture.top_of_page">org.gnome.Mutter.InputCapture</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.InputCapture ---- */

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_method_info_create_session_IN_ARG_capabilities =
{
  {
    -1,
    (gchar *) "capabilities",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_input_capture_method_info_create_session_IN_ARG_pointers[] =
{
  &_meta_dbus_input_capture_method_info_create_session_IN_ARG_capabilities.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_method_info_create_session_OUT_ARG_session_path =
{
  {
    -1,
    (gchar *) "session_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_input_capture_method_info_create_session_OUT_ARG_pointers[] =
{
  &_meta_dbus_input_capture_method_info_create_session_OUT_ARG_session_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_input_capture_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    (GDBusArgInfo **) &_meta_dbus_input_capture_method_info_create_session_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_input_capture_method_info_create_session_OUT_ARG_pointers,
    NULL
  },
  "handle-create-session",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_input_capture_method_info_pointers[] =
{
  &_meta_dbus_input_capture_method_info_create_session.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_input_capture_property_info_supported_capabilities =
{
  {
    -1,
    (gchar *) "SupportedCapabilities",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-capabilities",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _meta_dbus_input_capture_property_info_pointers[] =
{
  &_meta_dbus_input_capture_property_info_supported_capabilities.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_input_capture_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.InputCapture",
    (GDBusMethodInfo **) &_meta_dbus_input_capture_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_meta_dbus_input_capture_property_info_pointers,
    NULL
  },
  "input-capture",
};


/**
 * meta_dbus_input_capture_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture.top_of_page">org.gnome.Mutter.InputCapture</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_input_capture_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_input_capture_interface_info.parent_struct;
}

/**
 * meta_dbus_input_capture_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDBusInputCapture interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_input_capture_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "supported-capabilities");
  return property_id_begin - 1;
}


inline static void
meta_dbus_input_capture_method_marshal_create_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDBusInputCapture:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture.top_of_page">org.gnome.Mutter.InputCapture</link>.
 */

/**
 * MetaDBusInputCaptureIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #MetaDBusInputCapture::handle-create-session signal.
 * @get_supported_capabilities: Getter for the #MetaDBusInputCapture:supported-capabilities property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture.top_of_page">org.gnome.Mutter.InputCapture</link>.
 */

typedef MetaDBusInputCaptureIface MetaDBusInputCaptureInterface;
G_DEFINE_INTERFACE (MetaDBusInputCapture, meta_dbus_input_capture, G_TYPE_OBJECT)

static void
meta_dbus_input_capture_default_init (MetaDBusInputCaptureIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDBusInputCapture::handle-create-session:
   * @object: A #MetaDBusInputCapture.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_capabilities: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_input_capture_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusInputCaptureIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_input_capture_method_marshal_create_session,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * MetaDBusInputCapture:supported-capabilities:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-InputCapture.SupportedCapabilities">"SupportedCapabilities"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("supported-capabilities", "SupportedCapabilities", "SupportedCapabilities", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * meta_dbus_input_capture_get_supported_capabilities: (skip)
 * @object: A #MetaDBusInputCapture.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-InputCapture.SupportedCapabilities">"SupportedCapabilities"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
meta_dbus_input_capture_get_supported_capabilities (MetaDBusInputCapture *object)
{
  g_return_val_if_fail (META_DBUS_IS_INPUT_CAPTURE (object), 0);

  return META_DBUS_INPUT_CAPTURE_GET_IFACE (object)->get_supported_capabilities (object);
}

/**
 * meta_dbus_input_capture_set_supported_capabilities: (skip)
 * @object: A #MetaDBusInputCapture.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-InputCapture.SupportedCapabilities">"SupportedCapabilities"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_input_capture_set_supported_capabilities (MetaDBusInputCapture *object, guint value)
{
  g_object_set (G_OBJECT (object), "supported-capabilities", value, NULL);
}

/**
 * meta_dbus_input_capture_call_create_session:
 * @proxy: A #MetaDBusInputCaptureProxy.
 * @arg_capabilities: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_call_create_session_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_input_capture_call_create_session (
    MetaDBusInputCapture *proxy,
    guint arg_capabilities,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(u)",
                   arg_capabilities),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_input_capture_call_create_session_finish:
 * @proxy: A #MetaDBusInputCaptureProxy.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_input_capture_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_call_create_session_finish (
    MetaDBusInputCapture *proxy,
    gchar **out_session_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_call_create_session_sync:
 * @proxy: A #MetaDBusInputCaptureProxy.
 * @arg_capabilities: Argument to pass with the method invocation.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_call_create_session_sync (
    MetaDBusInputCapture *proxy,
    guint arg_capabilities,
    gchar **out_session_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(u)",
                   arg_capabilities),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_complete_create_session:
 * @object: A #MetaDBusInputCapture.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @session_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_input_capture_complete_create_session (
    MetaDBusInputCapture *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *session_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   session_path));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDBusInputCaptureProxy:
 *
 * The #MetaDBusInputCaptureProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusInputCaptureProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusInputCaptureProxy.
 */

struct _MetaDBusInputCaptureProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_input_capture_proxy_iface_init (MetaDBusInputCaptureIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusInputCaptureProxy, meta_dbus_input_capture_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDBusInputCaptureProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_INPUT_CAPTURE, meta_dbus_input_capture_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusInputCaptureProxy, meta_dbus_input_capture_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_INPUT_CAPTURE, meta_dbus_input_capture_proxy_iface_init))

#endif
static void
meta_dbus_input_capture_proxy_finalize (GObject *object)
{
  MetaDBusInputCaptureProxy *proxy = META_DBUS_INPUT_CAPTURE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_input_capture_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_input_capture_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_input_capture_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
meta_dbus_input_capture_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.InputCapture: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
meta_dbus_input_capture_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_input_capture_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.InputCapture", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) meta_dbus_input_capture_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
meta_dbus_input_capture_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_input_capture_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_INPUT_CAPTURE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_INPUT_CAPTURE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_input_capture_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDBusInputCaptureProxy *proxy = META_DBUS_INPUT_CAPTURE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_input_capture_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_input_capture_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
meta_dbus_input_capture_proxy_get_supported_capabilities (MetaDBusInputCapture *object)
{
  MetaDBusInputCaptureProxy *proxy = META_DBUS_INPUT_CAPTURE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedCapabilities");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
meta_dbus_input_capture_proxy_init (MetaDBusInputCaptureProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_input_capture_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_TYPE_INPUT_CAPTURE_PROXY, MetaDBusInputCaptureProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_input_capture_interface_info ());
}

static void
meta_dbus_input_capture_proxy_class_init (MetaDBusInputCaptureProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_input_capture_proxy_finalize;
  gobject_class->get_property = meta_dbus_input_capture_proxy_get_property;
  gobject_class->set_property = meta_dbus_input_capture_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_input_capture_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_input_capture_proxy_g_properties_changed;

  meta_dbus_input_capture_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusInputCaptureProxyPrivate));
#endif
}

static void
meta_dbus_input_capture_proxy_iface_init (MetaDBusInputCaptureIface *iface)
{
  iface->get_supported_capabilities = meta_dbus_input_capture_proxy_get_supported_capabilities;
}

/**
 * meta_dbus_input_capture_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture.top_of_page">org.gnome.Mutter.InputCapture</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_input_capture_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_INPUT_CAPTURE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.InputCapture", NULL);
}

/**
 * meta_dbus_input_capture_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_input_capture_proxy_new().
 *
 * Returns: (transfer full) (type MetaDBusInputCaptureProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusInputCapture *
meta_dbus_input_capture_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_INPUT_CAPTURE (ret);
  else
    return NULL;
}

/**
 * meta_dbus_input_capture_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture.top_of_page">org.gnome.Mutter.InputCapture</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusInputCaptureProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusInputCapture *
meta_dbus_input_capture_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_INPUT_CAPTURE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.InputCapture", NULL);
  if (ret != NULL)
    return META_DBUS_INPUT_CAPTURE (ret);
  else
    return NULL;
}


/**
 * meta_dbus_input_capture_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_input_capture_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_input_capture_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_INPUT_CAPTURE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.InputCapture", NULL);
}

/**
 * meta_dbus_input_capture_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_input_capture_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDBusInputCaptureProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusInputCapture *
meta_dbus_input_capture_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_INPUT_CAPTURE (ret);
  else
    return NULL;
}

/**
 * meta_dbus_input_capture_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_input_capture_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusInputCaptureProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusInputCapture *
meta_dbus_input_capture_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_INPUT_CAPTURE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.InputCapture", NULL);
  if (ret != NULL)
    return META_DBUS_INPUT_CAPTURE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDBusInputCaptureSkeleton:
 *
 * The #MetaDBusInputCaptureSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusInputCaptureSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusInputCaptureSkeleton.
 */

struct _MetaDBusInputCaptureSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_input_capture_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_TYPE_INPUT_CAPTURE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_INPUT_CAPTURE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_input_capture_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_input_capture_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_input_capture_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_input_capture_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_input_capture_skeleton_vtable =
{
  _meta_dbus_input_capture_skeleton_handle_method_call,
  _meta_dbus_input_capture_skeleton_handle_get_property,
  _meta_dbus_input_capture_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_input_capture_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_input_capture_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_input_capture_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_input_capture_skeleton_vtable;
}

static GVariant *
meta_dbus_input_capture_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_meta_dbus_input_capture_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_input_capture_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_input_capture_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_input_capture_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.InputCapture", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _meta_dbus_input_capture_emit_changed (gpointer user_data);

static void
meta_dbus_input_capture_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _meta_dbus_input_capture_emit_changed (skeleton);
}

static void meta_dbus_input_capture_skeleton_iface_init (MetaDBusInputCaptureIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusInputCaptureSkeleton, meta_dbus_input_capture_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDBusInputCaptureSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_INPUT_CAPTURE, meta_dbus_input_capture_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusInputCaptureSkeleton, meta_dbus_input_capture_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_INPUT_CAPTURE, meta_dbus_input_capture_skeleton_iface_init))

#endif
static void
meta_dbus_input_capture_skeleton_finalize (GObject *object)
{
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_input_capture_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_input_capture_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_meta_dbus_input_capture_emit_changed (gpointer user_data)
{
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.InputCapture",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_meta_dbus_input_capture_schedule_emit_changed (MetaDBusInputCaptureSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
meta_dbus_input_capture_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _meta_dbus_input_capture_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _meta_dbus_input_capture_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
meta_dbus_input_capture_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_input_capture_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _meta_dbus_input_capture_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
meta_dbus_input_capture_skeleton_init (MetaDBusInputCaptureSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_input_capture_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_TYPE_INPUT_CAPTURE_SKELETON, MetaDBusInputCaptureSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
meta_dbus_input_capture_skeleton_get_supported_capabilities (MetaDBusInputCapture *object)
{
  MetaDBusInputCaptureSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
meta_dbus_input_capture_skeleton_class_init (MetaDBusInputCaptureSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_input_capture_skeleton_finalize;
  gobject_class->get_property = meta_dbus_input_capture_skeleton_get_property;
  gobject_class->set_property = meta_dbus_input_capture_skeleton_set_property;
  gobject_class->notify       = meta_dbus_input_capture_skeleton_notify;


  meta_dbus_input_capture_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_input_capture_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_input_capture_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_input_capture_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_input_capture_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusInputCaptureSkeletonPrivate));
#endif
}

static void
meta_dbus_input_capture_skeleton_iface_init (MetaDBusInputCaptureIface *iface)
{
  iface->get_supported_capabilities = meta_dbus_input_capture_skeleton_get_supported_capabilities;
}

/**
 * meta_dbus_input_capture_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture.top_of_page">org.gnome.Mutter.InputCapture</link>.
 *
 * Returns: (transfer full) (type MetaDBusInputCaptureSkeleton): The skeleton object.
 */
MetaDBusInputCapture *
meta_dbus_input_capture_skeleton_new (void)
{
  return META_DBUS_INPUT_CAPTURE (g_object_new (META_DBUS_TYPE_INPUT_CAPTURE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.InputCapture.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDBusInputCaptureSession
 * @title: MetaDBusInputCaptureSession
 * @short_description: Generated C code for the org.gnome.Mutter.InputCapture.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture-Session.top_of_page">org.gnome.Mutter.InputCapture.Session</link> D-Bus interface in C.
 */

enum
{
  META_DBUS__INPUT_CAPTURE_SESSION_ACTIVATED,
  META_DBUS__INPUT_CAPTURE_SESSION_DEACTIVATED,
  META_DBUS__INPUT_CAPTURE_SESSION_ZONES_CHANGED,
  META_DBUS__INPUT_CAPTURE_SESSION_DISABLED,
  META_DBUS__INPUT_CAPTURE_SESSION_CLOSED,
};

static unsigned META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[5] = { 0 };

/* ---- Introspection data for org.gnome.Mutter.InputCapture.Session ---- */

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_method_info_get_zones_OUT_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_method_info_get_zones_OUT_ARG_zones =
{
  {
    -1,
    (gchar *) "zones",
    (gchar *) "a(uuii)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_input_capture_session_method_info_get_zones_OUT_ARG_pointers[] =
{
  &_meta_dbus_input_capture_session_method_info_get_zones_OUT_ARG_serial.parent_struct,
  &_meta_dbus_input_capture_session_method_info_get_zones_OUT_ARG_zones.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_input_capture_session_method_info_get_zones =
{
  {
    -1,
    (gchar *) "GetZones",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_input_capture_session_method_info_get_zones_OUT_ARG_pointers,
    NULL
  },
  "handle-get-zones",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_method_info_add_barrier_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_method_info_add_barrier_IN_ARG_position =
{
  {
    -1,
    (gchar *) "position",
    (gchar *) "(iiii)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_input_capture_session_method_info_add_barrier_IN_ARG_pointers[] =
{
  &_meta_dbus_input_capture_session_method_info_add_barrier_IN_ARG_serial.parent_struct,
  &_meta_dbus_input_capture_session_method_info_add_barrier_IN_ARG_position.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_method_info_add_barrier_OUT_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_input_capture_session_method_info_add_barrier_OUT_ARG_pointers[] =
{
  &_meta_dbus_input_capture_session_method_info_add_barrier_OUT_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_input_capture_session_method_info_add_barrier =
{
  {
    -1,
    (gchar *) "AddBarrier",
    (GDBusArgInfo **) &_meta_dbus_input_capture_session_method_info_add_barrier_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_input_capture_session_method_info_add_barrier_OUT_ARG_pointers,
    NULL
  },
  "handle-add-barrier",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_input_capture_session_method_info_clear_barriers =
{
  {
    -1,
    (gchar *) "ClearBarriers",
    NULL,
    NULL,
    NULL
  },
  "handle-clear-barriers",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_input_capture_session_method_info_enable =
{
  {
    -1,
    (gchar *) "Enable",
    NULL,
    NULL,
    NULL
  },
  "handle-enable",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_input_capture_session_method_info_disable =
{
  {
    -1,
    (gchar *) "Disable",
    NULL,
    NULL,
    NULL
  },
  "handle-disable",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_method_info_connect_to_eis_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_input_capture_session_method_info_connect_to_eis_OUT_ARG_pointers[] =
{
  &_meta_dbus_input_capture_session_method_info_connect_to_eis_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_input_capture_session_method_info_connect_to_eis =
{
  {
    -1,
    (gchar *) "ConnectToEIS",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_input_capture_session_method_info_connect_to_eis_OUT_ARG_pointers,
    NULL
  },
  "handle-connect-to-eis",
  TRUE
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_method_info_release_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_input_capture_session_method_info_release_IN_ARG_pointers[] =
{
  &_meta_dbus_input_capture_session_method_info_release_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_input_capture_session_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    (GDBusArgInfo **) &_meta_dbus_input_capture_session_method_info_release_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_input_capture_session_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_input_capture_session_method_info_pointers[] =
{
  &_meta_dbus_input_capture_session_method_info_get_zones.parent_struct,
  &_meta_dbus_input_capture_session_method_info_add_barrier.parent_struct,
  &_meta_dbus_input_capture_session_method_info_clear_barriers.parent_struct,
  &_meta_dbus_input_capture_session_method_info_enable.parent_struct,
  &_meta_dbus_input_capture_session_method_info_disable.parent_struct,
  &_meta_dbus_input_capture_session_method_info_connect_to_eis.parent_struct,
  &_meta_dbus_input_capture_session_method_info_release.parent_struct,
  &_meta_dbus_input_capture_session_method_info_close.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_signal_info_activated_ARG_barrier_id =
{
  {
    -1,
    (gchar *) "barrier_id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_signal_info_activated_ARG_activation_id =
{
  {
    -1,
    (gchar *) "activation_id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_signal_info_activated_ARG_cursor_position =
{
  {
    -1,
    (gchar *) "cursor_position",
    (gchar *) "(dd)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_input_capture_session_signal_info_activated_ARG_pointers[] =
{
  &_meta_dbus_input_capture_session_signal_info_activated_ARG_barrier_id.parent_struct,
  &_meta_dbus_input_capture_session_signal_info_activated_ARG_activation_id.parent_struct,
  &_meta_dbus_input_capture_session_signal_info_activated_ARG_cursor_position.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_input_capture_session_signal_info_activated =
{
  {
    -1,
    (gchar *) "Activated",
    (GDBusArgInfo **) &_meta_dbus_input_capture_session_signal_info_activated_ARG_pointers,
    NULL
  },
  "activated"
};

static const _ExtendedGDBusArgInfo _meta_dbus_input_capture_session_signal_info_deactivated_ARG_activation_id =
{
  {
    -1,
    (gchar *) "activation_id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_input_capture_session_signal_info_deactivated_ARG_pointers[] =
{
  &_meta_dbus_input_capture_session_signal_info_deactivated_ARG_activation_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_input_capture_session_signal_info_deactivated =
{
  {
    -1,
    (gchar *) "Deactivated",
    (GDBusArgInfo **) &_meta_dbus_input_capture_session_signal_info_deactivated_ARG_pointers,
    NULL
  },
  "deactivated"
};

static const _ExtendedGDBusSignalInfo _meta_dbus_input_capture_session_signal_info_zones_changed =
{
  {
    -1,
    (gchar *) "ZonesChanged",
    NULL,
    NULL
  },
  "zones-changed"
};

static const _ExtendedGDBusSignalInfo _meta_dbus_input_capture_session_signal_info_disabled =
{
  {
    -1,
    (gchar *) "Disabled",
    NULL,
    NULL
  },
  "disabled"
};

static const _ExtendedGDBusSignalInfo _meta_dbus_input_capture_session_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const GDBusSignalInfo * const _meta_dbus_input_capture_session_signal_info_pointers[] =
{
  &_meta_dbus_input_capture_session_signal_info_activated.parent_struct,
  &_meta_dbus_input_capture_session_signal_info_deactivated.parent_struct,
  &_meta_dbus_input_capture_session_signal_info_zones_changed.parent_struct,
  &_meta_dbus_input_capture_session_signal_info_disabled.parent_struct,
  &_meta_dbus_input_capture_session_signal_info_closed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_input_capture_session_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.InputCapture.Session",
    (GDBusMethodInfo **) &_meta_dbus_input_capture_session_method_info_pointers,
    (GDBusSignalInfo **) &_meta_dbus_input_capture_session_signal_info_pointers,
    NULL,
    NULL
  },
  "input-capture-session",
};


/**
 * meta_dbus_input_capture_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture-Session.top_of_page">org.gnome.Mutter.InputCapture.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_input_capture_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_input_capture_session_interface_info.parent_struct;
}

/**
 * meta_dbus_input_capture_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDBusInputCaptureSession interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_input_capture_session_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
meta_dbus_input_capture_session_signal_marshal_activated (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_UINT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_signal_marshal_deactivated (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_signal_marshal_zones_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_signal_marshal_disabled (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_signal_marshal_closed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_method_marshal_get_zones (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_method_marshal_add_barrier (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_method_marshal_clear_barriers (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_method_marshal_enable (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_method_marshal_disable (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_method_marshal_connect_to_eis (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_method_marshal_release (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_input_capture_session_method_marshal_close (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDBusInputCaptureSession:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture-Session.top_of_page">org.gnome.Mutter.InputCapture.Session</link>.
 */

/**
 * MetaDBusInputCaptureSessionIface:
 * @parent_iface: The parent interface.
 * @handle_add_barrier: Handler for the #MetaDBusInputCaptureSession::handle-add-barrier signal.
 * @handle_clear_barriers: Handler for the #MetaDBusInputCaptureSession::handle-clear-barriers signal.
 * @handle_close: Handler for the #MetaDBusInputCaptureSession::handle-close signal.
 * @handle_connect_to_eis: Handler for the #MetaDBusInputCaptureSession::handle-connect-to-eis signal.
 * @handle_disable: Handler for the #MetaDBusInputCaptureSession::handle-disable signal.
 * @handle_enable: Handler for the #MetaDBusInputCaptureSession::handle-enable signal.
 * @handle_get_zones: Handler for the #MetaDBusInputCaptureSession::handle-get-zones signal.
 * @handle_release: Handler for the #MetaDBusInputCaptureSession::handle-release signal.
 * @activated: Handler for the #MetaDBusInputCaptureSession::activated signal.
 * @closed: Handler for the #MetaDBusInputCaptureSession::closed signal.
 * @deactivated: Handler for the #MetaDBusInputCaptureSession::deactivated signal.
 * @disabled: Handler for the #MetaDBusInputCaptureSession::disabled signal.
 * @zones_changed: Handler for the #MetaDBusInputCaptureSession::zones-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture-Session.top_of_page">org.gnome.Mutter.InputCapture.Session</link>.
 */

typedef MetaDBusInputCaptureSessionIface MetaDBusInputCaptureSessionInterface;
G_DEFINE_INTERFACE (MetaDBusInputCaptureSession, meta_dbus_input_capture_session, G_TYPE_OBJECT)

static void
meta_dbus_input_capture_session_default_init (MetaDBusInputCaptureSessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDBusInputCaptureSession::handle-get-zones:
   * @object: A #MetaDBusInputCaptureSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.GetZones">GetZones()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_input_capture_session_complete_get_zones() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-zones",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, handle_get_zones),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_input_capture_session_method_marshal_get_zones,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusInputCaptureSession::handle-add-barrier:
   * @object: A #MetaDBusInputCaptureSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_serial: Argument passed by remote caller.
   * @arg_position: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.AddBarrier">AddBarrier()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_input_capture_session_complete_add_barrier() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-barrier",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, handle_add_barrier),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_input_capture_session_method_marshal_add_barrier,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * MetaDBusInputCaptureSession::handle-clear-barriers:
   * @object: A #MetaDBusInputCaptureSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.ClearBarriers">ClearBarriers()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_input_capture_session_complete_clear_barriers() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-clear-barriers",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, handle_clear_barriers),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_input_capture_session_method_marshal_clear_barriers,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusInputCaptureSession::handle-enable:
   * @object: A #MetaDBusInputCaptureSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Enable">Enable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_input_capture_session_complete_enable() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, handle_enable),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_input_capture_session_method_marshal_enable,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusInputCaptureSession::handle-disable:
   * @object: A #MetaDBusInputCaptureSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Disable">Disable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_input_capture_session_complete_disable() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, handle_disable),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_input_capture_session_method_marshal_disable,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusInputCaptureSession::handle-connect-to-eis:
   * @object: A #MetaDBusInputCaptureSession.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.ConnectToEIS">ConnectToEIS()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_input_capture_session_complete_connect_to_eis() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-connect-to-eis",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, handle_connect_to_eis),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_input_capture_session_method_marshal_connect_to_eis,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST);

  /**
   * MetaDBusInputCaptureSession::handle-release:
   * @object: A #MetaDBusInputCaptureSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_input_capture_session_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_input_capture_session_method_marshal_release,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MetaDBusInputCaptureSession::handle-close:
   * @object: A #MetaDBusInputCaptureSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_input_capture_session_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_input_capture_session_method_marshal_close,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * MetaDBusInputCaptureSession::activated:
   * @object: A #MetaDBusInputCaptureSession.
   * @arg_barrier_id: Argument.
   * @arg_activation_id: Argument.
   * @arg_cursor_position: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-InputCapture-Session.Activated">"Activated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[META_DBUS__INPUT_CAPTURE_SESSION_ACTIVATED] =
    g_signal_new ("activated",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, activated),
      NULL,
      NULL,
      meta_dbus_input_capture_session_signal_marshal_activated,
      G_TYPE_NONE,
      3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * MetaDBusInputCaptureSession::deactivated:
   * @object: A #MetaDBusInputCaptureSession.
   * @arg_activation_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-InputCapture-Session.Deactivated">"Deactivated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[META_DBUS__INPUT_CAPTURE_SESSION_DEACTIVATED] =
    g_signal_new ("deactivated",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, deactivated),
      NULL,
      NULL,
      meta_dbus_input_capture_session_signal_marshal_deactivated,
      G_TYPE_NONE,
      1, G_TYPE_UINT);

  /**
   * MetaDBusInputCaptureSession::zones-changed:
   * @object: A #MetaDBusInputCaptureSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-InputCapture-Session.ZonesChanged">"ZonesChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[META_DBUS__INPUT_CAPTURE_SESSION_ZONES_CHANGED] =
    g_signal_new ("zones-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, zones_changed),
      NULL,
      NULL,
      meta_dbus_input_capture_session_signal_marshal_zones_changed,
      G_TYPE_NONE,
      0);

  /**
   * MetaDBusInputCaptureSession::disabled:
   * @object: A #MetaDBusInputCaptureSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-InputCapture-Session.Disabled">"Disabled"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[META_DBUS__INPUT_CAPTURE_SESSION_DISABLED] =
    g_signal_new ("disabled",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, disabled),
      NULL,
      NULL,
      meta_dbus_input_capture_session_signal_marshal_disabled,
      G_TYPE_NONE,
      0);

  /**
   * MetaDBusInputCaptureSession::closed:
   * @object: A #MetaDBusInputCaptureSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-InputCapture-Session.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[META_DBUS__INPUT_CAPTURE_SESSION_CLOSED] =
    g_signal_new ("closed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusInputCaptureSessionIface, closed),
      NULL,
      NULL,
      meta_dbus_input_capture_session_signal_marshal_closed,
      G_TYPE_NONE,
      0);

}

/**
 * meta_dbus_input_capture_session_emit_activated:
 * @object: A #MetaDBusInputCaptureSession.
 * @arg_barrier_id: Argument to pass with the signal.
 * @arg_activation_id: Argument to pass with the signal.
 * @arg_cursor_position: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-InputCapture-Session.Activated">"Activated"</link> D-Bus signal.
 */
void
meta_dbus_input_capture_session_emit_activated (
    MetaDBusInputCaptureSession *object,
    guint arg_barrier_id,
    guint arg_activation_id,
    GVariant *arg_cursor_position)
{
  g_signal_emit (object, META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[META_DBUS__INPUT_CAPTURE_SESSION_ACTIVATED], 0, arg_barrier_id, arg_activation_id, arg_cursor_position);
}

/**
 * meta_dbus_input_capture_session_emit_deactivated:
 * @object: A #MetaDBusInputCaptureSession.
 * @arg_activation_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-InputCapture-Session.Deactivated">"Deactivated"</link> D-Bus signal.
 */
void
meta_dbus_input_capture_session_emit_deactivated (
    MetaDBusInputCaptureSession *object,
    guint arg_activation_id)
{
  g_signal_emit (object, META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[META_DBUS__INPUT_CAPTURE_SESSION_DEACTIVATED], 0, arg_activation_id);
}

/**
 * meta_dbus_input_capture_session_emit_zones_changed:
 * @object: A #MetaDBusInputCaptureSession.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-InputCapture-Session.ZonesChanged">"ZonesChanged"</link> D-Bus signal.
 */
void
meta_dbus_input_capture_session_emit_zones_changed (
    MetaDBusInputCaptureSession *object)
{
  g_signal_emit (object, META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[META_DBUS__INPUT_CAPTURE_SESSION_ZONES_CHANGED], 0);
}

/**
 * meta_dbus_input_capture_session_emit_disabled:
 * @object: A #MetaDBusInputCaptureSession.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-InputCapture-Session.Disabled">"Disabled"</link> D-Bus signal.
 */
void
meta_dbus_input_capture_session_emit_disabled (
    MetaDBusInputCaptureSession *object)
{
  g_signal_emit (object, META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[META_DBUS__INPUT_CAPTURE_SESSION_DISABLED], 0);
}

/**
 * meta_dbus_input_capture_session_emit_closed:
 * @object: A #MetaDBusInputCaptureSession.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-InputCapture-Session.Closed">"Closed"</link> D-Bus signal.
 */
void
meta_dbus_input_capture_session_emit_closed (
    MetaDBusInputCaptureSession *object)
{
  g_signal_emit (object, META_DBUS__INPUT_CAPTURE_SESSION_SIGNALS[META_DBUS__INPUT_CAPTURE_SESSION_CLOSED], 0);
}

/**
 * meta_dbus_input_capture_session_call_get_zones:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.GetZones">GetZones()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_session_call_get_zones_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_session_call_get_zones_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_input_capture_session_call_get_zones (
    MetaDBusInputCaptureSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetZones",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_input_capture_session_call_get_zones_finish:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @out_serial: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_zones: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_session_call_get_zones().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_input_capture_session_call_get_zones().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_get_zones_finish (
    MetaDBusInputCaptureSession *proxy,
    guint *out_serial,
    GVariant **out_zones,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a(uuii))",
                 out_serial,
                 out_zones);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_get_zones_sync:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @out_serial: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_zones: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.GetZones">GetZones()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_session_call_get_zones() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_get_zones_sync (
    MetaDBusInputCaptureSession *proxy,
    guint *out_serial,
    GVariant **out_zones,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetZones",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a(uuii))",
                 out_serial,
                 out_zones);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_add_barrier:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.AddBarrier">AddBarrier()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_session_call_add_barrier_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_session_call_add_barrier_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_input_capture_session_call_add_barrier (
    MetaDBusInputCaptureSession *proxy,
    guint arg_serial,
    GVariant *arg_position,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddBarrier",
    g_variant_new ("(u@(iiii))",
                   arg_serial,
                   arg_position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_input_capture_session_call_add_barrier_finish:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @out_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_session_call_add_barrier().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_input_capture_session_call_add_barrier().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_add_barrier_finish (
    MetaDBusInputCaptureSession *proxy,
    guint *out_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_add_barrier_sync:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_position: Argument to pass with the method invocation.
 * @out_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.AddBarrier">AddBarrier()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_session_call_add_barrier() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_add_barrier_sync (
    MetaDBusInputCaptureSession *proxy,
    guint arg_serial,
    GVariant *arg_position,
    guint *out_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddBarrier",
    g_variant_new ("(u@(iiii))",
                   arg_serial,
                   arg_position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_clear_barriers:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.ClearBarriers">ClearBarriers()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_session_call_clear_barriers_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_session_call_clear_barriers_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_input_capture_session_call_clear_barriers (
    MetaDBusInputCaptureSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ClearBarriers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_input_capture_session_call_clear_barriers_finish:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_session_call_clear_barriers().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_input_capture_session_call_clear_barriers().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_clear_barriers_finish (
    MetaDBusInputCaptureSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_clear_barriers_sync:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.ClearBarriers">ClearBarriers()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_session_call_clear_barriers() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_clear_barriers_sync (
    MetaDBusInputCaptureSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ClearBarriers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_enable:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Enable">Enable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_session_call_enable_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_session_call_enable_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_input_capture_session_call_enable (
    MetaDBusInputCaptureSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Enable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_input_capture_session_call_enable_finish:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_session_call_enable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_input_capture_session_call_enable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_enable_finish (
    MetaDBusInputCaptureSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_enable_sync:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Enable">Enable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_session_call_enable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_enable_sync (
    MetaDBusInputCaptureSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Enable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_disable:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Disable">Disable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_session_call_disable_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_session_call_disable_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_input_capture_session_call_disable (
    MetaDBusInputCaptureSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Disable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_input_capture_session_call_disable_finish:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_session_call_disable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_input_capture_session_call_disable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_disable_finish (
    MetaDBusInputCaptureSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_disable_sync:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Disable">Disable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_session_call_disable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_disable_sync (
    MetaDBusInputCaptureSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Disable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_connect_to_eis:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.ConnectToEIS">ConnectToEIS()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_session_call_connect_to_eis_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_session_call_connect_to_eis_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_input_capture_session_call_connect_to_eis (
    MetaDBusInputCaptureSession *proxy,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "ConnectToEIS",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_input_capture_session_call_connect_to_eis_finish:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_session_call_connect_to_eis().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_input_capture_session_call_connect_to_eis().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_connect_to_eis_finish (
    MetaDBusInputCaptureSession *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_connect_to_eis_sync:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.ConnectToEIS">ConnectToEIS()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_session_call_connect_to_eis() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_connect_to_eis_sync (
    MetaDBusInputCaptureSession *proxy,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "ConnectToEIS",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_release:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_session_call_release_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_session_call_release_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_input_capture_session_call_release (
    MetaDBusInputCaptureSession *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_input_capture_session_call_release_finish:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_session_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_input_capture_session_call_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_release_finish (
    MetaDBusInputCaptureSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_release_sync:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_session_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_release_sync (
    MetaDBusInputCaptureSession *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_close:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_session_call_close_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_session_call_close_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_input_capture_session_call_close (
    MetaDBusInputCaptureSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_input_capture_session_call_close_finish:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_session_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_input_capture_session_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_close_finish (
    MetaDBusInputCaptureSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_call_close_sync:
 * @proxy: A #MetaDBusInputCaptureSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_session_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_input_capture_session_call_close_sync (
    MetaDBusInputCaptureSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_input_capture_session_complete_get_zones:
 * @object: A #MetaDBusInputCaptureSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @serial: Parameter to return.
 * @zones: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.GetZones">GetZones()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_input_capture_session_complete_get_zones (
    MetaDBusInputCaptureSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint serial,
    GVariant *zones)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a(uuii))",
                   serial,
                   zones));
}

/**
 * meta_dbus_input_capture_session_complete_add_barrier:
 * @object: A #MetaDBusInputCaptureSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.AddBarrier">AddBarrier()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_input_capture_session_complete_add_barrier (
    MetaDBusInputCaptureSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   id));
}

/**
 * meta_dbus_input_capture_session_complete_clear_barriers:
 * @object: A #MetaDBusInputCaptureSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.ClearBarriers">ClearBarriers()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_input_capture_session_complete_clear_barriers (
    MetaDBusInputCaptureSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_input_capture_session_complete_enable:
 * @object: A #MetaDBusInputCaptureSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Enable">Enable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_input_capture_session_complete_enable (
    MetaDBusInputCaptureSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_input_capture_session_complete_disable:
 * @object: A #MetaDBusInputCaptureSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Disable">Disable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_input_capture_session_complete_disable (
    MetaDBusInputCaptureSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_input_capture_session_complete_connect_to_eis:
 * @object: A #MetaDBusInputCaptureSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.ConnectToEIS">ConnectToEIS()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_input_capture_session_complete_connect_to_eis (
    MetaDBusInputCaptureSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * meta_dbus_input_capture_session_complete_release:
 * @object: A #MetaDBusInputCaptureSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_input_capture_session_complete_release (
    MetaDBusInputCaptureSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_input_capture_session_complete_close:
 * @object: A #MetaDBusInputCaptureSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-InputCapture-Session.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_input_capture_session_complete_close (
    MetaDBusInputCaptureSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDBusInputCaptureSessionProxy:
 *
 * The #MetaDBusInputCaptureSessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusInputCaptureSessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusInputCaptureSessionProxy.
 */

struct _MetaDBusInputCaptureSessionProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_input_capture_session_proxy_iface_init (MetaDBusInputCaptureSessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusInputCaptureSessionProxy, meta_dbus_input_capture_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDBusInputCaptureSessionProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_INPUT_CAPTURE_SESSION, meta_dbus_input_capture_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusInputCaptureSessionProxy, meta_dbus_input_capture_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_INPUT_CAPTURE_SESSION, meta_dbus_input_capture_session_proxy_iface_init))

#endif
static void
meta_dbus_input_capture_session_proxy_finalize (GObject *object)
{
  MetaDBusInputCaptureSessionProxy *proxy = META_DBUS_INPUT_CAPTURE_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_input_capture_session_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_input_capture_session_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_input_capture_session_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_input_capture_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_input_capture_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_INPUT_CAPTURE_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_INPUT_CAPTURE_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_input_capture_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDBusInputCaptureSessionProxy *proxy = META_DBUS_INPUT_CAPTURE_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_input_capture_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_input_capture_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
meta_dbus_input_capture_session_proxy_init (MetaDBusInputCaptureSessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_input_capture_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_TYPE_INPUT_CAPTURE_SESSION_PROXY, MetaDBusInputCaptureSessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_input_capture_session_interface_info ());
}

static void
meta_dbus_input_capture_session_proxy_class_init (MetaDBusInputCaptureSessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_input_capture_session_proxy_finalize;
  gobject_class->get_property = meta_dbus_input_capture_session_proxy_get_property;
  gobject_class->set_property = meta_dbus_input_capture_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_input_capture_session_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_input_capture_session_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusInputCaptureSessionProxyPrivate));
#endif
}

static void
meta_dbus_input_capture_session_proxy_iface_init (MetaDBusInputCaptureSessionIface *iface G_GNUC_UNUSED)
{
}

/**
 * meta_dbus_input_capture_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture-Session.top_of_page">org.gnome.Mutter.InputCapture.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_session_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_input_capture_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_INPUT_CAPTURE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.InputCapture.Session", NULL);
}

/**
 * meta_dbus_input_capture_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_input_capture_session_proxy_new().
 *
 * Returns: (transfer full) (type MetaDBusInputCaptureSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusInputCaptureSession *
meta_dbus_input_capture_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_INPUT_CAPTURE_SESSION (ret);
  else
    return NULL;
}

/**
 * meta_dbus_input_capture_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture-Session.top_of_page">org.gnome.Mutter.InputCapture.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusInputCaptureSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusInputCaptureSession *
meta_dbus_input_capture_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_INPUT_CAPTURE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.InputCapture.Session", NULL);
  if (ret != NULL)
    return META_DBUS_INPUT_CAPTURE_SESSION (ret);
  else
    return NULL;
}


/**
 * meta_dbus_input_capture_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_input_capture_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_input_capture_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_input_capture_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_input_capture_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_INPUT_CAPTURE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.InputCapture.Session", NULL);
}

/**
 * meta_dbus_input_capture_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_input_capture_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_input_capture_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDBusInputCaptureSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusInputCaptureSession *
meta_dbus_input_capture_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_INPUT_CAPTURE_SESSION (ret);
  else
    return NULL;
}

/**
 * meta_dbus_input_capture_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_input_capture_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_input_capture_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusInputCaptureSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusInputCaptureSession *
meta_dbus_input_capture_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_INPUT_CAPTURE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.InputCapture.Session", NULL);
  if (ret != NULL)
    return META_DBUS_INPUT_CAPTURE_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDBusInputCaptureSessionSkeleton:
 *
 * The #MetaDBusInputCaptureSessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusInputCaptureSessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusInputCaptureSessionSkeleton.
 */

struct _MetaDBusInputCaptureSessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_input_capture_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDBusInputCaptureSessionSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_TYPE_INPUT_CAPTURE_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_INPUT_CAPTURE_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_input_capture_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDBusInputCaptureSessionSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_input_capture_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_input_capture_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDBusInputCaptureSessionSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_input_capture_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_input_capture_session_skeleton_vtable =
{
  _meta_dbus_input_capture_session_skeleton_handle_method_call,
  _meta_dbus_input_capture_session_skeleton_handle_get_property,
  _meta_dbus_input_capture_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_input_capture_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_input_capture_session_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_input_capture_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_input_capture_session_skeleton_vtable;
}

static GVariant *
meta_dbus_input_capture_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusInputCaptureSessionSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_meta_dbus_input_capture_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_input_capture_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_input_capture_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_input_capture_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.InputCapture.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
meta_dbus_input_capture_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_meta_dbus_input_capture_session_on_signal_activated (
    MetaDBusInputCaptureSession *object,
    guint arg_barrier_id,
    guint arg_activation_id,
    GVariant *arg_cursor_position)
{
  MetaDBusInputCaptureSessionSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu@(dd))",
                   arg_barrier_id,
                   arg_activation_id,
                   arg_cursor_position));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.InputCapture.Session", "Activated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_input_capture_session_on_signal_deactivated (
    MetaDBusInputCaptureSession *object,
    guint arg_activation_id)
{
  MetaDBusInputCaptureSessionSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_activation_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.InputCapture.Session", "Deactivated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_input_capture_session_on_signal_zones_changed (
    MetaDBusInputCaptureSession *object)
{
  MetaDBusInputCaptureSessionSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.InputCapture.Session", "ZonesChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_input_capture_session_on_signal_disabled (
    MetaDBusInputCaptureSession *object)
{
  MetaDBusInputCaptureSessionSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.InputCapture.Session", "Disabled",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_input_capture_session_on_signal_closed (
    MetaDBusInputCaptureSession *object)
{
  MetaDBusInputCaptureSessionSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.InputCapture.Session", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void meta_dbus_input_capture_session_skeleton_iface_init (MetaDBusInputCaptureSessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusInputCaptureSessionSkeleton, meta_dbus_input_capture_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDBusInputCaptureSessionSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_INPUT_CAPTURE_SESSION, meta_dbus_input_capture_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusInputCaptureSessionSkeleton, meta_dbus_input_capture_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_INPUT_CAPTURE_SESSION, meta_dbus_input_capture_session_skeleton_iface_init))

#endif
static void
meta_dbus_input_capture_session_skeleton_finalize (GObject *object)
{
  MetaDBusInputCaptureSessionSkeleton *skeleton = META_DBUS_INPUT_CAPTURE_SESSION_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_input_capture_session_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_input_capture_session_skeleton_init (MetaDBusInputCaptureSessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_input_capture_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_TYPE_INPUT_CAPTURE_SESSION_SKELETON, MetaDBusInputCaptureSessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
meta_dbus_input_capture_session_skeleton_class_init (MetaDBusInputCaptureSessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_input_capture_session_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_input_capture_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_input_capture_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_input_capture_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_input_capture_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusInputCaptureSessionSkeletonPrivate));
#endif
}

static void
meta_dbus_input_capture_session_skeleton_iface_init (MetaDBusInputCaptureSessionIface *iface)
{
  iface->activated = _meta_dbus_input_capture_session_on_signal_activated;
  iface->deactivated = _meta_dbus_input_capture_session_on_signal_deactivated;
  iface->zones_changed = _meta_dbus_input_capture_session_on_signal_zones_changed;
  iface->disabled = _meta_dbus_input_capture_session_on_signal_disabled;
  iface->closed = _meta_dbus_input_capture_session_on_signal_closed;
}

/**
 * meta_dbus_input_capture_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-InputCapture-Session.top_of_page">org.gnome.Mutter.InputCapture.Session</link>.
 *
 * Returns: (transfer full) (type MetaDBusInputCaptureSessionSkeleton): The skeleton object.
 */
MetaDBusInputCaptureSession *
meta_dbus_input_capture_session_skeleton_new (void)
{
  return META_DBUS_INPUT_CAPTURE_SESSION (g_object_new (META_DBUS_TYPE_INPUT_CAPTURE_SESSION_SKELETON, NULL));
}

