// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/data"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolSpan = sync.Pool{
		New: func() any {
			return &otlptrace.Span{}
		},
	}
)

func NewOrigSpan() *otlptrace.Span {
	if !UseProtoPooling.IsEnabled() {
		return &otlptrace.Span{}
	}
	return protoPoolSpan.Get().(*otlptrace.Span)
}

func DeleteOrigSpan(orig *otlptrace.Span, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteOrigTraceID(&orig.TraceId, false)
	DeleteOrigSpanID(&orig.SpanId, false)
	DeleteOrigSpanID(&orig.ParentSpanId, false)
	for i := range orig.Attributes {
		DeleteOrigKeyValue(&orig.Attributes[i], false)
	}
	for i := range orig.Events {
		DeleteOrigSpan_Event(orig.Events[i], true)
	}
	for i := range orig.Links {
		DeleteOrigSpan_Link(orig.Links[i], true)
	}
	DeleteOrigStatus(&orig.Status, false)

	orig.Reset()
	if nullable {
		protoPoolSpan.Put(orig)
	}
}

func CopyOrigSpan(dest, src *otlptrace.Span) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.TraceId = src.TraceId
	dest.SpanId = src.SpanId
	CopyOrigTraceState(&dest.TraceState, &src.TraceState)
	dest.ParentSpanId = src.ParentSpanId
	dest.Flags = src.Flags
	dest.Name = src.Name
	dest.Kind = src.Kind
	dest.StartTimeUnixNano = src.StartTimeUnixNano
	dest.EndTimeUnixNano = src.EndTimeUnixNano
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.DroppedAttributesCount = src.DroppedAttributesCount
	dest.Events = CopyOrigSpan_EventSlice(dest.Events, src.Events)
	dest.DroppedEventsCount = src.DroppedEventsCount
	dest.Links = CopyOrigSpan_LinkSlice(dest.Links, src.Links)
	dest.DroppedLinksCount = src.DroppedLinksCount
	CopyOrigStatus(&dest.Status, &src.Status)
}

func GenTestOrigSpan() *otlptrace.Span {
	orig := NewOrigSpan()
	orig.TraceId = data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	orig.SpanId = data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})
	orig.TraceState = *GenTestOrigTraceState()
	orig.ParentSpanId = data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})
	orig.Flags = uint32(13)
	orig.Name = "test_name"
	orig.Kind = otlptrace.Span_SpanKind(3)
	orig.StartTimeUnixNano = 1234567890
	orig.EndTimeUnixNano = 1234567890
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.DroppedAttributesCount = uint32(13)
	orig.Events = GenerateOrigTestSpan_EventSlice()
	orig.DroppedEventsCount = uint32(13)
	orig.Links = GenerateOrigTestSpan_LinkSlice()
	orig.DroppedLinksCount = uint32(13)
	orig.Status = *GenTestOrigStatus()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigSpan(orig *otlptrace.Span, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.TraceId != data.TraceID([16]byte{}) {
		dest.WriteObjectField("traceId")
		MarshalJSONOrigTraceID(&orig.TraceId, dest)
	}
	if orig.SpanId != data.SpanID([8]byte{}) {
		dest.WriteObjectField("spanId")
		MarshalJSONOrigSpanID(&orig.SpanId, dest)
	}
	if orig.TraceState != "" {
		dest.WriteObjectField("traceState")
		dest.WriteString(orig.TraceState)
	}
	if orig.ParentSpanId != data.SpanID([8]byte{}) {
		dest.WriteObjectField("parentSpanId")
		MarshalJSONOrigSpanID(&orig.ParentSpanId, dest)
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if orig.Name != "" {
		dest.WriteObjectField("name")
		dest.WriteString(orig.Name)
	}

	if int32(orig.Kind) != 0 {
		dest.WriteObjectField("kind")
		dest.WriteInt32(int32(orig.Kind))
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.EndTimeUnixNano != uint64(0) {
		dest.WriteObjectField("endTimeUnixNano")
		dest.WriteUint64(orig.EndTimeUnixNano)
	}
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if len(orig.Events) > 0 {
		dest.WriteObjectField("events")
		dest.WriteArrayStart()
		MarshalJSONOrigSpan_Event(orig.Events[0], dest)
		for i := 1; i < len(orig.Events); i++ {
			dest.WriteMore()
			MarshalJSONOrigSpan_Event(orig.Events[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedEventsCount != uint32(0) {
		dest.WriteObjectField("droppedEventsCount")
		dest.WriteUint32(orig.DroppedEventsCount)
	}
	if len(orig.Links) > 0 {
		dest.WriteObjectField("links")
		dest.WriteArrayStart()
		MarshalJSONOrigSpan_Link(orig.Links[0], dest)
		for i := 1; i < len(orig.Links); i++ {
			dest.WriteMore()
			MarshalJSONOrigSpan_Link(orig.Links[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedLinksCount != uint32(0) {
		dest.WriteObjectField("droppedLinksCount")
		dest.WriteUint32(orig.DroppedLinksCount)
	}
	dest.WriteObjectField("status")
	MarshalJSONOrigStatus(&orig.Status, dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigSpan unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSpan(orig *otlptrace.Span, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "traceId", "trace_id":
			UnmarshalJSONOrigTraceID(&orig.TraceId, iter)
		case "spanId", "span_id":
			UnmarshalJSONOrigSpanID(&orig.SpanId, iter)
		case "traceState", "trace_state":
			orig.TraceState = iter.ReadString()
		case "parentSpanId", "parent_span_id":
			UnmarshalJSONOrigSpanID(&orig.ParentSpanId, iter)
		case "flags":
			orig.Flags = iter.ReadUint32()
		case "name":
			orig.Name = iter.ReadString()
		case "kind":
			orig.Kind = otlptrace.Span_SpanKind(iter.ReadEnumValue(otlptrace.Span_SpanKind_value))
		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "endTimeUnixNano", "end_time_unix_nano":
			orig.EndTimeUnixNano = iter.ReadUint64()
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
				UnmarshalJSONOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], iter)
			}

		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "events":
			for iter.ReadArray() {
				orig.Events = append(orig.Events, NewOrigSpan_Event())
				UnmarshalJSONOrigSpan_Event(orig.Events[len(orig.Events)-1], iter)
			}

		case "droppedEventsCount", "dropped_events_count":
			orig.DroppedEventsCount = iter.ReadUint32()
		case "links":
			for iter.ReadArray() {
				orig.Links = append(orig.Links, NewOrigSpan_Link())
				UnmarshalJSONOrigSpan_Link(orig.Links[len(orig.Links)-1], iter)
			}

		case "droppedLinksCount", "dropped_links_count":
			orig.DroppedLinksCount = iter.ReadUint32()
		case "status":
			UnmarshalJSONOrigStatus(&orig.Status, iter)
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigSpan(orig *otlptrace.Span) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigTraceID(&orig.TraceId)
	n += 1 + proto.Sov(uint64(l)) + l
	l = SizeProtoOrigSpanID(&orig.SpanId)
	n += 1 + proto.Sov(uint64(l)) + l
	l = len(orig.TraceState)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = SizeProtoOrigSpanID(&orig.ParentSpanId)
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.Flags != 0 {
		n += 6
	}
	l = len(orig.Name)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Kind != 0 {
		n += 1 + proto.Sov(uint64(orig.Kind))
	}
	if orig.StartTimeUnixNano != 0 {
		n += 9
	}
	if orig.EndTimeUnixNano != 0 {
		n += 9
	}
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	for i := range orig.Events {
		l = SizeProtoOrigSpan_Event(orig.Events[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedEventsCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedEventsCount))
	}
	for i := range orig.Links {
		l = SizeProtoOrigSpan_Link(orig.Links[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedLinksCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedLinksCount))
	}
	l = SizeProtoOrigStatus(&orig.Status)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigSpan(orig *otlptrace.Span, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigTraceID(&orig.TraceId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	l = MarshalProtoOrigSpanID(&orig.SpanId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	l = len(orig.TraceState)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.TraceState)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}

	l = MarshalProtoOrigSpanID(&orig.ParentSpanId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x22

	if orig.Flags != 0 {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.Flags))
		pos--
		buf[pos] = 0x1
		pos--
		buf[pos] = 0x85
	}
	l = len(orig.Name)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Name)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x2a
	}
	if orig.Kind != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Kind))
		pos--
		buf[pos] = 0x30
	}
	if orig.StartTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x39
	}
	if orig.EndTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.EndTimeUnixNano))
		pos--
		buf[pos] = 0x41
	}
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x4a
	}
	if orig.DroppedAttributesCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x50
	}
	for i := len(orig.Events) - 1; i >= 0; i-- {
		l = MarshalProtoOrigSpan_Event(orig.Events[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x5a
	}
	if orig.DroppedEventsCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedEventsCount))
		pos--
		buf[pos] = 0x60
	}
	for i := len(orig.Links) - 1; i >= 0; i-- {
		l = MarshalProtoOrigSpan_Link(orig.Links[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x6a
	}
	if orig.DroppedLinksCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedLinksCount))
		pos--
		buf[pos] = 0x70
	}

	l = MarshalProtoOrigStatus(&orig.Status, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x7a

	return len(buf) - pos
}

func UnmarshalProtoOrigSpan(orig *otlptrace.Span, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigTraceID(&orig.TraceId, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigSpanID(&orig.SpanId, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceState", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.TraceState = string(buf[startPos:pos])

		case 4:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigSpanID(&orig.ParentSpanId, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 16:
			if wireType != proto.WireTypeI32 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint32
			num, pos, err = proto.ConsumeI32(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Name = string(buf[startPos:pos])

		case 6:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Kind = otlptrace.Span_SpanKind(num)

		case 7:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.StartTimeUnixNano = uint64(num)

		case 8:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.EndTimeUnixNano = uint64(num)

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
			err = UnmarshalProtoOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 10:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.DroppedAttributesCount = uint32(num)

		case 11:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Events = append(orig.Events, NewOrigSpan_Event())
			err = UnmarshalProtoOrigSpan_Event(orig.Events[len(orig.Events)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 12:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedEventsCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.DroppedEventsCount = uint32(num)

		case 13:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Links", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Links = append(orig.Links, NewOrigSpan_Link())
			err = UnmarshalProtoOrigSpan_Link(orig.Links[len(orig.Links)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 14:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedLinksCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.DroppedLinksCount = uint32(num)

		case 15:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigStatus(&orig.Status, buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
