/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "meta-dbus-rtkit1.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUint64UintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint64 arg_thread,
        guint arg_priority,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUint64UintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUint64UintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint64 (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64_UINT64_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUint64Uint64UintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint64 arg_process,
        guint64 arg_thread,
        guint arg_priority,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUint64Uint64UintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUint64Uint64UintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint64 (param_values + 2),
              g_marshal_value_peek_uint64 (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUint64IntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint64 arg_thread,
        gint arg_priority,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUint64IntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUint64IntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint64 (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64_UINT64_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUint64Uint64IntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint64 arg_process,
        guint64 arg_thread,
        gint arg_priority,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUint64Uint64IntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUint64Uint64IntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint64 (param_values + 2),
              g_marshal_value_peek_uint64 (param_values + 3),
              g_marshal_value_peek_int (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_interface,
        const gchar *arg_property,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.RealtimeKit1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDbusRealtimeKit1
 * @title: MetaDbusRealtimeKit1
 * @short_description: Generated C code for the org.freedesktop.RealtimeKit1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-RealtimeKit1.top_of_page">org.freedesktop.RealtimeKit1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.RealtimeKit1 ---- */

static const _ExtendedGDBusArgInfo _meta_dbus_realtime_kit1_method_info_make_thread_realtime_IN_ARG_thread =
{
  {
    -1,
    (gchar *) "thread",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_realtime_kit1_method_info_make_thread_realtime_IN_ARG_priority =
{
  {
    -1,
    (gchar *) "priority",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_realtime_kit1_method_info_make_thread_realtime_IN_ARG_pointers[] =
{
  &_meta_dbus_realtime_kit1_method_info_make_thread_realtime_IN_ARG_thread.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_make_thread_realtime_IN_ARG_priority.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_realtime_kit1_method_info_make_thread_realtime =
{
  {
    -1,
    (gchar *) "MakeThreadRealtime",
    (GDBusArgInfo **) &_meta_dbus_realtime_kit1_method_info_make_thread_realtime_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-make-thread-realtime",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_realtime_kit1_method_info_make_thread_realtime_with_pid_IN_ARG_process =
{
  {
    -1,
    (gchar *) "process",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_realtime_kit1_method_info_make_thread_realtime_with_pid_IN_ARG_thread =
{
  {
    -1,
    (gchar *) "thread",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_realtime_kit1_method_info_make_thread_realtime_with_pid_IN_ARG_priority =
{
  {
    -1,
    (gchar *) "priority",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_realtime_kit1_method_info_make_thread_realtime_with_pid_IN_ARG_pointers[] =
{
  &_meta_dbus_realtime_kit1_method_info_make_thread_realtime_with_pid_IN_ARG_process.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_make_thread_realtime_with_pid_IN_ARG_thread.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_make_thread_realtime_with_pid_IN_ARG_priority.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_realtime_kit1_method_info_make_thread_realtime_with_pid =
{
  {
    -1,
    (gchar *) "MakeThreadRealtimeWithPID",
    (GDBusArgInfo **) &_meta_dbus_realtime_kit1_method_info_make_thread_realtime_with_pid_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-make-thread-realtime-with-pid",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_realtime_kit1_method_info_make_thread_high_priority_IN_ARG_thread =
{
  {
    -1,
    (gchar *) "thread",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_realtime_kit1_method_info_make_thread_high_priority_IN_ARG_priority =
{
  {
    -1,
    (gchar *) "priority",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_realtime_kit1_method_info_make_thread_high_priority_IN_ARG_pointers[] =
{
  &_meta_dbus_realtime_kit1_method_info_make_thread_high_priority_IN_ARG_thread.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_make_thread_high_priority_IN_ARG_priority.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_realtime_kit1_method_info_make_thread_high_priority =
{
  {
    -1,
    (gchar *) "MakeThreadHighPriority",
    (GDBusArgInfo **) &_meta_dbus_realtime_kit1_method_info_make_thread_high_priority_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-make-thread-high-priority",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_realtime_kit1_method_info_make_thread_high_priority_with_pid_IN_ARG_process =
{
  {
    -1,
    (gchar *) "process",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_realtime_kit1_method_info_make_thread_high_priority_with_pid_IN_ARG_thread =
{
  {
    -1,
    (gchar *) "thread",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_realtime_kit1_method_info_make_thread_high_priority_with_pid_IN_ARG_priority =
{
  {
    -1,
    (gchar *) "priority",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_realtime_kit1_method_info_make_thread_high_priority_with_pid_IN_ARG_pointers[] =
{
  &_meta_dbus_realtime_kit1_method_info_make_thread_high_priority_with_pid_IN_ARG_process.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_make_thread_high_priority_with_pid_IN_ARG_thread.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_make_thread_high_priority_with_pid_IN_ARG_priority.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_realtime_kit1_method_info_make_thread_high_priority_with_pid =
{
  {
    -1,
    (gchar *) "MakeThreadHighPriorityWithPID",
    (GDBusArgInfo **) &_meta_dbus_realtime_kit1_method_info_make_thread_high_priority_with_pid_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-make-thread-high-priority-with-pid",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_realtime_kit1_method_info_reset_known =
{
  {
    -1,
    (gchar *) "ResetKnown",
    NULL,
    NULL,
    NULL
  },
  "handle-reset-known",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_realtime_kit1_method_info_reset_all =
{
  {
    -1,
    (gchar *) "ResetAll",
    NULL,
    NULL,
    NULL
  },
  "handle-reset-all",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_realtime_kit1_method_info_exit =
{
  {
    -1,
    (gchar *) "Exit",
    NULL,
    NULL,
    NULL
  },
  "handle-exit",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_realtime_kit1_method_info_pointers[] =
{
  &_meta_dbus_realtime_kit1_method_info_make_thread_realtime.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_make_thread_realtime_with_pid.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_make_thread_high_priority.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_make_thread_high_priority_with_pid.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_reset_known.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_reset_all.parent_struct,
  &_meta_dbus_realtime_kit1_method_info_exit.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_realtime_kit1_property_info_rttime_usec_max =
{
  {
    -1,
    (gchar *) "RTTimeUSecMax",
    (gchar *) "x",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "rttime-usec-max",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_realtime_kit1_property_info_max_realtime_priority =
{
  {
    -1,
    (gchar *) "MaxRealtimePriority",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "max-realtime-priority",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_realtime_kit1_property_info_min_nice_level =
{
  {
    -1,
    (gchar *) "MinNiceLevel",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "min-nice-level",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _meta_dbus_realtime_kit1_property_info_pointers[] =
{
  &_meta_dbus_realtime_kit1_property_info_rttime_usec_max.parent_struct,
  &_meta_dbus_realtime_kit1_property_info_max_realtime_priority.parent_struct,
  &_meta_dbus_realtime_kit1_property_info_min_nice_level.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_realtime_kit1_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.RealtimeKit1",
    (GDBusMethodInfo **) &_meta_dbus_realtime_kit1_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_meta_dbus_realtime_kit1_property_info_pointers,
    NULL
  },
  "realtime-kit1",
};


/**
 * meta_dbus_realtime_kit1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-RealtimeKit1.top_of_page">org.freedesktop.RealtimeKit1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_realtime_kit1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_realtime_kit1_interface_info.parent_struct;
}

/**
 * meta_dbus_realtime_kit1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDbusRealtimeKit1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_realtime_kit1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "rttime-usec-max");
  g_object_class_override_property (klass, property_id_begin++, "max-realtime-priority");
  g_object_class_override_property (klass, property_id_begin++, "min-nice-level");
  return property_id_begin - 1;
}


inline static void
meta_dbus_realtime_kit1_method_marshal_make_thread_realtime (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_realtime_kit1_method_marshal_make_thread_realtime_with_pid (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64_UINT64_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_realtime_kit1_method_marshal_make_thread_high_priority (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_realtime_kit1_method_marshal_make_thread_high_priority_with_pid (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT64_UINT64_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_realtime_kit1_method_marshal_reset_known (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_realtime_kit1_method_marshal_reset_all (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_realtime_kit1_method_marshal_exit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDbusRealtimeKit1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-RealtimeKit1.top_of_page">org.freedesktop.RealtimeKit1</link>.
 */

/**
 * MetaDbusRealtimeKit1Iface:
 * @parent_iface: The parent interface.
 * @handle_exit: Handler for the #MetaDbusRealtimeKit1::handle-exit signal.
 * @handle_make_thread_high_priority: Handler for the #MetaDbusRealtimeKit1::handle-make-thread-high-priority signal.
 * @handle_make_thread_high_priority_with_pid: Handler for the #MetaDbusRealtimeKit1::handle-make-thread-high-priority-with-pid signal.
 * @handle_make_thread_realtime: Handler for the #MetaDbusRealtimeKit1::handle-make-thread-realtime signal.
 * @handle_make_thread_realtime_with_pid: Handler for the #MetaDbusRealtimeKit1::handle-make-thread-realtime-with-pid signal.
 * @handle_reset_all: Handler for the #MetaDbusRealtimeKit1::handle-reset-all signal.
 * @handle_reset_known: Handler for the #MetaDbusRealtimeKit1::handle-reset-known signal.
 * @get_max_realtime_priority: Getter for the #MetaDbusRealtimeKit1:max-realtime-priority property.
 * @get_min_nice_level: Getter for the #MetaDbusRealtimeKit1:min-nice-level property.
 * @get_rttime_usec_max: Getter for the #MetaDbusRealtimeKit1:rttime-usec-max property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-RealtimeKit1.top_of_page">org.freedesktop.RealtimeKit1</link>.
 */

typedef MetaDbusRealtimeKit1Iface MetaDbusRealtimeKit1Interface;
G_DEFINE_INTERFACE (MetaDbusRealtimeKit1, meta_dbus_realtime_kit1, G_TYPE_OBJECT)

static void
meta_dbus_realtime_kit1_default_init (MetaDbusRealtimeKit1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDbusRealtimeKit1::handle-make-thread-realtime:
   * @object: A #MetaDbusRealtimeKit1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_thread: Argument passed by remote caller.
   * @arg_priority: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadRealtime">MakeThreadRealtime()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_realtime_kit1_complete_make_thread_realtime() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-make-thread-realtime",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusRealtimeKit1Iface, handle_make_thread_realtime),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_realtime_kit1_method_marshal_make_thread_realtime,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_UINT);

  /**
   * MetaDbusRealtimeKit1::handle-make-thread-realtime-with-pid:
   * @object: A #MetaDbusRealtimeKit1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_process: Argument passed by remote caller.
   * @arg_thread: Argument passed by remote caller.
   * @arg_priority: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadRealtimeWithPID">MakeThreadRealtimeWithPID()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_realtime_kit1_complete_make_thread_realtime_with_pid() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-make-thread-realtime-with-pid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusRealtimeKit1Iface, handle_make_thread_realtime_with_pid),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_realtime_kit1_method_marshal_make_thread_realtime_with_pid,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_UINT64, G_TYPE_UINT);

  /**
   * MetaDbusRealtimeKit1::handle-make-thread-high-priority:
   * @object: A #MetaDbusRealtimeKit1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_thread: Argument passed by remote caller.
   * @arg_priority: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadHighPriority">MakeThreadHighPriority()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_realtime_kit1_complete_make_thread_high_priority() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-make-thread-high-priority",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusRealtimeKit1Iface, handle_make_thread_high_priority),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_realtime_kit1_method_marshal_make_thread_high_priority,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_INT);

  /**
   * MetaDbusRealtimeKit1::handle-make-thread-high-priority-with-pid:
   * @object: A #MetaDbusRealtimeKit1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_process: Argument passed by remote caller.
   * @arg_thread: Argument passed by remote caller.
   * @arg_priority: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadHighPriorityWithPID">MakeThreadHighPriorityWithPID()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_realtime_kit1_complete_make_thread_high_priority_with_pid() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-make-thread-high-priority-with-pid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusRealtimeKit1Iface, handle_make_thread_high_priority_with_pid),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_realtime_kit1_method_marshal_make_thread_high_priority_with_pid,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_UINT64, G_TYPE_INT);

  /**
   * MetaDbusRealtimeKit1::handle-reset-known:
   * @object: A #MetaDbusRealtimeKit1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.ResetKnown">ResetKnown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_realtime_kit1_complete_reset_known() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reset-known",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusRealtimeKit1Iface, handle_reset_known),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_realtime_kit1_method_marshal_reset_known,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDbusRealtimeKit1::handle-reset-all:
   * @object: A #MetaDbusRealtimeKit1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.ResetAll">ResetAll()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_realtime_kit1_complete_reset_all() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reset-all",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusRealtimeKit1Iface, handle_reset_all),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_realtime_kit1_method_marshal_reset_all,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDbusRealtimeKit1::handle-exit:
   * @object: A #MetaDbusRealtimeKit1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.Exit">Exit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_realtime_kit1_complete_exit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-exit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusRealtimeKit1Iface, handle_exit),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_realtime_kit1_method_marshal_exit,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * MetaDbusRealtimeKit1:rttime-usec-max:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-RealtimeKit1.RTTimeUSecMax">"RTTimeUSecMax"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int64 ("rttime-usec-max", "RTTimeUSecMax", "RTTimeUSecMax", G_MININT64, G_MAXINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDbusRealtimeKit1:max-realtime-priority:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-RealtimeKit1.MaxRealtimePriority">"MaxRealtimePriority"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("max-realtime-priority", "MaxRealtimePriority", "MaxRealtimePriority", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDbusRealtimeKit1:min-nice-level:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-RealtimeKit1.MinNiceLevel">"MinNiceLevel"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("min-nice-level", "MinNiceLevel", "MinNiceLevel", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * meta_dbus_realtime_kit1_get_rttime_usec_max: (skip)
 * @object: A #MetaDbusRealtimeKit1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-RealtimeKit1.RTTimeUSecMax">"RTTimeUSecMax"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint64 
meta_dbus_realtime_kit1_get_rttime_usec_max (MetaDbusRealtimeKit1 *object)
{
  g_return_val_if_fail (META_DBUS_IS_REALTIME_KIT1 (object), 0);

  return META_DBUS_REALTIME_KIT1_GET_IFACE (object)->get_rttime_usec_max (object);
}

/**
 * meta_dbus_realtime_kit1_set_rttime_usec_max: (skip)
 * @object: A #MetaDbusRealtimeKit1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-RealtimeKit1.RTTimeUSecMax">"RTTimeUSecMax"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_realtime_kit1_set_rttime_usec_max (MetaDbusRealtimeKit1 *object, gint64 value)
{
  g_object_set (G_OBJECT (object), "rttime-usec-max", value, NULL);
}

/**
 * meta_dbus_realtime_kit1_get_max_realtime_priority: (skip)
 * @object: A #MetaDbusRealtimeKit1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-RealtimeKit1.MaxRealtimePriority">"MaxRealtimePriority"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
meta_dbus_realtime_kit1_get_max_realtime_priority (MetaDbusRealtimeKit1 *object)
{
  g_return_val_if_fail (META_DBUS_IS_REALTIME_KIT1 (object), 0);

  return META_DBUS_REALTIME_KIT1_GET_IFACE (object)->get_max_realtime_priority (object);
}

/**
 * meta_dbus_realtime_kit1_set_max_realtime_priority: (skip)
 * @object: A #MetaDbusRealtimeKit1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-RealtimeKit1.MaxRealtimePriority">"MaxRealtimePriority"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_realtime_kit1_set_max_realtime_priority (MetaDbusRealtimeKit1 *object, gint value)
{
  g_object_set (G_OBJECT (object), "max-realtime-priority", value, NULL);
}

/**
 * meta_dbus_realtime_kit1_get_min_nice_level: (skip)
 * @object: A #MetaDbusRealtimeKit1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-RealtimeKit1.MinNiceLevel">"MinNiceLevel"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
meta_dbus_realtime_kit1_get_min_nice_level (MetaDbusRealtimeKit1 *object)
{
  g_return_val_if_fail (META_DBUS_IS_REALTIME_KIT1 (object), 0);

  return META_DBUS_REALTIME_KIT1_GET_IFACE (object)->get_min_nice_level (object);
}

/**
 * meta_dbus_realtime_kit1_set_min_nice_level: (skip)
 * @object: A #MetaDbusRealtimeKit1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-RealtimeKit1.MinNiceLevel">"MinNiceLevel"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_realtime_kit1_set_min_nice_level (MetaDbusRealtimeKit1 *object, gint value)
{
  g_object_set (G_OBJECT (object), "min-nice-level", value, NULL);
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_realtime:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @arg_thread: Argument to pass with the method invocation.
 * @arg_priority: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadRealtime">MakeThreadRealtime()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_realtime_kit1_call_make_thread_realtime_finish() to get the result of the operation.
 *
 * See meta_dbus_realtime_kit1_call_make_thread_realtime_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_realtime_kit1_call_make_thread_realtime (
    MetaDbusRealtimeKit1 *proxy,
    guint64 arg_thread,
    guint arg_priority,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MakeThreadRealtime",
    g_variant_new ("(tu)",
                   arg_thread,
                   arg_priority),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_realtime_finish:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_realtime_kit1_call_make_thread_realtime().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_realtime_kit1_call_make_thread_realtime().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_make_thread_realtime_finish (
    MetaDbusRealtimeKit1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_realtime_sync:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @arg_thread: Argument to pass with the method invocation.
 * @arg_priority: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadRealtime">MakeThreadRealtime()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_realtime_kit1_call_make_thread_realtime() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_make_thread_realtime_sync (
    MetaDbusRealtimeKit1 *proxy,
    guint64 arg_thread,
    guint arg_priority,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MakeThreadRealtime",
    g_variant_new ("(tu)",
                   arg_thread,
                   arg_priority),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @arg_process: Argument to pass with the method invocation.
 * @arg_thread: Argument to pass with the method invocation.
 * @arg_priority: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadRealtimeWithPID">MakeThreadRealtimeWithPID()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid_finish() to get the result of the operation.
 *
 * See meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid (
    MetaDbusRealtimeKit1 *proxy,
    guint64 arg_process,
    guint64 arg_thread,
    guint arg_priority,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MakeThreadRealtimeWithPID",
    g_variant_new ("(ttu)",
                   arg_process,
                   arg_thread,
                   arg_priority),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid_finish:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid_finish (
    MetaDbusRealtimeKit1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid_sync:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @arg_process: Argument to pass with the method invocation.
 * @arg_thread: Argument to pass with the method invocation.
 * @arg_priority: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadRealtimeWithPID">MakeThreadRealtimeWithPID()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_make_thread_realtime_with_pid_sync (
    MetaDbusRealtimeKit1 *proxy,
    guint64 arg_process,
    guint64 arg_thread,
    guint arg_priority,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MakeThreadRealtimeWithPID",
    g_variant_new ("(ttu)",
                   arg_process,
                   arg_thread,
                   arg_priority),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_high_priority:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @arg_thread: Argument to pass with the method invocation.
 * @arg_priority: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadHighPriority">MakeThreadHighPriority()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_realtime_kit1_call_make_thread_high_priority_finish() to get the result of the operation.
 *
 * See meta_dbus_realtime_kit1_call_make_thread_high_priority_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_realtime_kit1_call_make_thread_high_priority (
    MetaDbusRealtimeKit1 *proxy,
    guint64 arg_thread,
    gint arg_priority,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MakeThreadHighPriority",
    g_variant_new ("(ti)",
                   arg_thread,
                   arg_priority),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_high_priority_finish:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_realtime_kit1_call_make_thread_high_priority().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_realtime_kit1_call_make_thread_high_priority().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_make_thread_high_priority_finish (
    MetaDbusRealtimeKit1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_high_priority_sync:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @arg_thread: Argument to pass with the method invocation.
 * @arg_priority: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadHighPriority">MakeThreadHighPriority()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_realtime_kit1_call_make_thread_high_priority() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_make_thread_high_priority_sync (
    MetaDbusRealtimeKit1 *proxy,
    guint64 arg_thread,
    gint arg_priority,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MakeThreadHighPriority",
    g_variant_new ("(ti)",
                   arg_thread,
                   arg_priority),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @arg_process: Argument to pass with the method invocation.
 * @arg_thread: Argument to pass with the method invocation.
 * @arg_priority: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadHighPriorityWithPID">MakeThreadHighPriorityWithPID()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid_finish() to get the result of the operation.
 *
 * See meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid (
    MetaDbusRealtimeKit1 *proxy,
    guint64 arg_process,
    guint64 arg_thread,
    gint arg_priority,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MakeThreadHighPriorityWithPID",
    g_variant_new ("(tti)",
                   arg_process,
                   arg_thread,
                   arg_priority),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid_finish:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid_finish (
    MetaDbusRealtimeKit1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid_sync:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @arg_process: Argument to pass with the method invocation.
 * @arg_thread: Argument to pass with the method invocation.
 * @arg_priority: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadHighPriorityWithPID">MakeThreadHighPriorityWithPID()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_make_thread_high_priority_with_pid_sync (
    MetaDbusRealtimeKit1 *proxy,
    guint64 arg_process,
    guint64 arg_thread,
    gint arg_priority,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MakeThreadHighPriorityWithPID",
    g_variant_new ("(tti)",
                   arg_process,
                   arg_thread,
                   arg_priority),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_reset_known:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.ResetKnown">ResetKnown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_realtime_kit1_call_reset_known_finish() to get the result of the operation.
 *
 * See meta_dbus_realtime_kit1_call_reset_known_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_realtime_kit1_call_reset_known (
    MetaDbusRealtimeKit1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ResetKnown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_realtime_kit1_call_reset_known_finish:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_realtime_kit1_call_reset_known().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_realtime_kit1_call_reset_known().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_reset_known_finish (
    MetaDbusRealtimeKit1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_reset_known_sync:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.ResetKnown">ResetKnown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_realtime_kit1_call_reset_known() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_reset_known_sync (
    MetaDbusRealtimeKit1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ResetKnown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_reset_all:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.ResetAll">ResetAll()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_realtime_kit1_call_reset_all_finish() to get the result of the operation.
 *
 * See meta_dbus_realtime_kit1_call_reset_all_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_realtime_kit1_call_reset_all (
    MetaDbusRealtimeKit1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ResetAll",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_realtime_kit1_call_reset_all_finish:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_realtime_kit1_call_reset_all().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_realtime_kit1_call_reset_all().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_reset_all_finish (
    MetaDbusRealtimeKit1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_reset_all_sync:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.ResetAll">ResetAll()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_realtime_kit1_call_reset_all() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_reset_all_sync (
    MetaDbusRealtimeKit1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ResetAll",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_exit:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.Exit">Exit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_realtime_kit1_call_exit_finish() to get the result of the operation.
 *
 * See meta_dbus_realtime_kit1_call_exit_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_realtime_kit1_call_exit (
    MetaDbusRealtimeKit1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Exit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_realtime_kit1_call_exit_finish:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_realtime_kit1_call_exit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_realtime_kit1_call_exit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_exit_finish (
    MetaDbusRealtimeKit1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_call_exit_sync:
 * @proxy: A #MetaDbusRealtimeKit1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.Exit">Exit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_realtime_kit1_call_exit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_realtime_kit1_call_exit_sync (
    MetaDbusRealtimeKit1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Exit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_realtime_kit1_complete_make_thread_realtime:
 * @object: A #MetaDbusRealtimeKit1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadRealtime">MakeThreadRealtime()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_realtime_kit1_complete_make_thread_realtime (
    MetaDbusRealtimeKit1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_realtime_kit1_complete_make_thread_realtime_with_pid:
 * @object: A #MetaDbusRealtimeKit1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadRealtimeWithPID">MakeThreadRealtimeWithPID()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_realtime_kit1_complete_make_thread_realtime_with_pid (
    MetaDbusRealtimeKit1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_realtime_kit1_complete_make_thread_high_priority:
 * @object: A #MetaDbusRealtimeKit1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadHighPriority">MakeThreadHighPriority()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_realtime_kit1_complete_make_thread_high_priority (
    MetaDbusRealtimeKit1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_realtime_kit1_complete_make_thread_high_priority_with_pid:
 * @object: A #MetaDbusRealtimeKit1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.MakeThreadHighPriorityWithPID">MakeThreadHighPriorityWithPID()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_realtime_kit1_complete_make_thread_high_priority_with_pid (
    MetaDbusRealtimeKit1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_realtime_kit1_complete_reset_known:
 * @object: A #MetaDbusRealtimeKit1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.ResetKnown">ResetKnown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_realtime_kit1_complete_reset_known (
    MetaDbusRealtimeKit1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_realtime_kit1_complete_reset_all:
 * @object: A #MetaDbusRealtimeKit1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.ResetAll">ResetAll()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_realtime_kit1_complete_reset_all (
    MetaDbusRealtimeKit1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_realtime_kit1_complete_exit:
 * @object: A #MetaDbusRealtimeKit1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-RealtimeKit1.Exit">Exit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_realtime_kit1_complete_exit (
    MetaDbusRealtimeKit1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDbusRealtimeKit1Proxy:
 *
 * The #MetaDbusRealtimeKit1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDbusRealtimeKit1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDbusRealtimeKit1Proxy.
 */

struct _MetaDbusRealtimeKit1ProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_realtime_kit1_proxy_iface_init (MetaDbusRealtimeKit1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDbusRealtimeKit1Proxy, meta_dbus_realtime_kit1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDbusRealtimeKit1Proxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REALTIME_KIT1, meta_dbus_realtime_kit1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDbusRealtimeKit1Proxy, meta_dbus_realtime_kit1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REALTIME_KIT1, meta_dbus_realtime_kit1_proxy_iface_init))

#endif
static void
meta_dbus_realtime_kit1_proxy_finalize (GObject *object)
{
  MetaDbusRealtimeKit1Proxy *proxy = META_DBUS_REALTIME_KIT1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_realtime_kit1_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_realtime_kit1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_realtime_kit1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
meta_dbus_realtime_kit1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.RealtimeKit1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
meta_dbus_realtime_kit1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_realtime_kit1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.RealtimeKit1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) meta_dbus_realtime_kit1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
meta_dbus_realtime_kit1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_realtime_kit1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_REALTIME_KIT1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_REALTIME_KIT1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_realtime_kit1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDbusRealtimeKit1Proxy *proxy = META_DBUS_REALTIME_KIT1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_realtime_kit1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_realtime_kit1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gint64 
meta_dbus_realtime_kit1_proxy_get_rttime_usec_max (MetaDbusRealtimeKit1 *object)
{
  MetaDbusRealtimeKit1Proxy *proxy = META_DBUS_REALTIME_KIT1_PROXY (object);
  GVariant *variant;
  gint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RTTimeUSecMax");
  if (variant != NULL)
    {
      value = g_variant_get_int64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
meta_dbus_realtime_kit1_proxy_get_max_realtime_priority (MetaDbusRealtimeKit1 *object)
{
  MetaDbusRealtimeKit1Proxy *proxy = META_DBUS_REALTIME_KIT1_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MaxRealtimePriority");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
meta_dbus_realtime_kit1_proxy_get_min_nice_level (MetaDbusRealtimeKit1 *object)
{
  MetaDbusRealtimeKit1Proxy *proxy = META_DBUS_REALTIME_KIT1_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MinNiceLevel");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
meta_dbus_realtime_kit1_proxy_init (MetaDbusRealtimeKit1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_realtime_kit1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_TYPE_REALTIME_KIT1_PROXY, MetaDbusRealtimeKit1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_realtime_kit1_interface_info ());
}

static void
meta_dbus_realtime_kit1_proxy_class_init (MetaDbusRealtimeKit1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_realtime_kit1_proxy_finalize;
  gobject_class->get_property = meta_dbus_realtime_kit1_proxy_get_property;
  gobject_class->set_property = meta_dbus_realtime_kit1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_realtime_kit1_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_realtime_kit1_proxy_g_properties_changed;

  meta_dbus_realtime_kit1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDbusRealtimeKit1ProxyPrivate));
#endif
}

static void
meta_dbus_realtime_kit1_proxy_iface_init (MetaDbusRealtimeKit1Iface *iface)
{
  iface->get_rttime_usec_max = meta_dbus_realtime_kit1_proxy_get_rttime_usec_max;
  iface->get_max_realtime_priority = meta_dbus_realtime_kit1_proxy_get_max_realtime_priority;
  iface->get_min_nice_level = meta_dbus_realtime_kit1_proxy_get_min_nice_level;
}

/**
 * meta_dbus_realtime_kit1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-RealtimeKit1.top_of_page">org.freedesktop.RealtimeKit1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_realtime_kit1_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_realtime_kit1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_realtime_kit1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_REALTIME_KIT1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.RealtimeKit1", NULL);
}

/**
 * meta_dbus_realtime_kit1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_realtime_kit1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_realtime_kit1_proxy_new().
 *
 * Returns: (transfer full) (type MetaDbusRealtimeKit1Proxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusRealtimeKit1 *
meta_dbus_realtime_kit1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_REALTIME_KIT1 (ret);
  else
    return NULL;
}

/**
 * meta_dbus_realtime_kit1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-RealtimeKit1.top_of_page">org.freedesktop.RealtimeKit1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_realtime_kit1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDbusRealtimeKit1Proxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusRealtimeKit1 *
meta_dbus_realtime_kit1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_REALTIME_KIT1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.RealtimeKit1", NULL);
  if (ret != NULL)
    return META_DBUS_REALTIME_KIT1 (ret);
  else
    return NULL;
}


/**
 * meta_dbus_realtime_kit1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_realtime_kit1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_realtime_kit1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_realtime_kit1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_realtime_kit1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_REALTIME_KIT1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.RealtimeKit1", NULL);
}

/**
 * meta_dbus_realtime_kit1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_realtime_kit1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_realtime_kit1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDbusRealtimeKit1Proxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusRealtimeKit1 *
meta_dbus_realtime_kit1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_REALTIME_KIT1 (ret);
  else
    return NULL;
}

/**
 * meta_dbus_realtime_kit1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_realtime_kit1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_realtime_kit1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDbusRealtimeKit1Proxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusRealtimeKit1 *
meta_dbus_realtime_kit1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_REALTIME_KIT1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.RealtimeKit1", NULL);
  if (ret != NULL)
    return META_DBUS_REALTIME_KIT1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDbusRealtimeKit1Skeleton:
 *
 * The #MetaDbusRealtimeKit1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDbusRealtimeKit1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDbusRealtimeKit1Skeleton.
 */

struct _MetaDbusRealtimeKit1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_realtime_kit1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_TYPE_REALTIME_KIT1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_REALTIME_KIT1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_realtime_kit1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_realtime_kit1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_realtime_kit1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_realtime_kit1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_realtime_kit1_skeleton_vtable =
{
  _meta_dbus_realtime_kit1_skeleton_handle_method_call,
  _meta_dbus_realtime_kit1_skeleton_handle_get_property,
  _meta_dbus_realtime_kit1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_realtime_kit1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_realtime_kit1_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_realtime_kit1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_realtime_kit1_skeleton_vtable;
}

static GVariant *
meta_dbus_realtime_kit1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_meta_dbus_realtime_kit1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_realtime_kit1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_realtime_kit1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_realtime_kit1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.RealtimeKit1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _meta_dbus_realtime_kit1_emit_changed (gpointer user_data);

static void
meta_dbus_realtime_kit1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _meta_dbus_realtime_kit1_emit_changed (skeleton);
}

static void meta_dbus_realtime_kit1_skeleton_iface_init (MetaDbusRealtimeKit1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDbusRealtimeKit1Skeleton, meta_dbus_realtime_kit1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDbusRealtimeKit1Skeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REALTIME_KIT1, meta_dbus_realtime_kit1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDbusRealtimeKit1Skeleton, meta_dbus_realtime_kit1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REALTIME_KIT1, meta_dbus_realtime_kit1_skeleton_iface_init))

#endif
static void
meta_dbus_realtime_kit1_skeleton_finalize (GObject *object)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_realtime_kit1_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_realtime_kit1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_meta_dbus_realtime_kit1_emit_changed (gpointer user_data)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.RealtimeKit1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_meta_dbus_realtime_kit1_schedule_emit_changed (MetaDbusRealtimeKit1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
meta_dbus_realtime_kit1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _meta_dbus_realtime_kit1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _meta_dbus_realtime_kit1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
meta_dbus_realtime_kit1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_realtime_kit1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _meta_dbus_realtime_kit1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
meta_dbus_realtime_kit1_skeleton_init (MetaDbusRealtimeKit1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_realtime_kit1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_TYPE_REALTIME_KIT1_SKELETON, MetaDbusRealtimeKit1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_INT64);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_INT);
}

static gint64 
meta_dbus_realtime_kit1_skeleton_get_rttime_usec_max (MetaDbusRealtimeKit1 *object)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (object);
  gint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int64 (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
meta_dbus_realtime_kit1_skeleton_get_max_realtime_priority (MetaDbusRealtimeKit1 *object)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
meta_dbus_realtime_kit1_skeleton_get_min_nice_level (MetaDbusRealtimeKit1 *object)
{
  MetaDbusRealtimeKit1Skeleton *skeleton = META_DBUS_REALTIME_KIT1_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
meta_dbus_realtime_kit1_skeleton_class_init (MetaDbusRealtimeKit1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_realtime_kit1_skeleton_finalize;
  gobject_class->get_property = meta_dbus_realtime_kit1_skeleton_get_property;
  gobject_class->set_property = meta_dbus_realtime_kit1_skeleton_set_property;
  gobject_class->notify       = meta_dbus_realtime_kit1_skeleton_notify;


  meta_dbus_realtime_kit1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_realtime_kit1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_realtime_kit1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_realtime_kit1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_realtime_kit1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDbusRealtimeKit1SkeletonPrivate));
#endif
}

static void
meta_dbus_realtime_kit1_skeleton_iface_init (MetaDbusRealtimeKit1Iface *iface)
{
  iface->get_rttime_usec_max = meta_dbus_realtime_kit1_skeleton_get_rttime_usec_max;
  iface->get_max_realtime_priority = meta_dbus_realtime_kit1_skeleton_get_max_realtime_priority;
  iface->get_min_nice_level = meta_dbus_realtime_kit1_skeleton_get_min_nice_level;
}

/**
 * meta_dbus_realtime_kit1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-RealtimeKit1.top_of_page">org.freedesktop.RealtimeKit1</link>.
 *
 * Returns: (transfer full) (type MetaDbusRealtimeKit1Skeleton): The skeleton object.
 */
MetaDbusRealtimeKit1 *
meta_dbus_realtime_kit1_skeleton_new (void)
{
  return META_DBUS_REALTIME_KIT1 (g_object_new (META_DBUS_TYPE_REALTIME_KIT1_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.DBus.Properties
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDbusDBusProperties
 * @title: MetaDbusDBusProperties
 * @short_description: Generated C code for the org.freedesktop.DBus.Properties D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.DBus.Properties ---- */

static const _ExtendedGDBusArgInfo _meta_dbus_dbus_properties_method_info_get_IN_ARG_interface =
{
  {
    -1,
    (gchar *) "interface",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_dbus_properties_method_info_get_IN_ARG_property =
{
  {
    -1,
    (gchar *) "property",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_dbus_properties_method_info_get_IN_ARG_pointers[] =
{
  &_meta_dbus_dbus_properties_method_info_get_IN_ARG_interface.parent_struct,
  &_meta_dbus_dbus_properties_method_info_get_IN_ARG_property.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_dbus_properties_method_info_get_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_dbus_properties_method_info_get_OUT_ARG_pointers[] =
{
  &_meta_dbus_dbus_properties_method_info_get_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_dbus_properties_method_info_get =
{
  {
    -1,
    (gchar *) "Get",
    (GDBusArgInfo **) &_meta_dbus_dbus_properties_method_info_get_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_dbus_properties_method_info_get_OUT_ARG_pointers,
    NULL
  },
  "handle-get",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_dbus_properties_method_info_pointers[] =
{
  &_meta_dbus_dbus_properties_method_info_get.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_dbus_properties_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.DBus.Properties",
    (GDBusMethodInfo **) &_meta_dbus_dbus_properties_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "dbus-properties",
};


/**
 * meta_dbus_dbus_properties_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_dbus_properties_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_dbus_properties_interface_info.parent_struct;
}

/**
 * meta_dbus_dbus_properties_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDbusDBusProperties interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_dbus_properties_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
meta_dbus_dbus_properties_method_marshal_get (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDbusDBusProperties:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link>.
 */

/**
 * MetaDbusDBusPropertiesIface:
 * @parent_iface: The parent interface.
 * @handle_get: Handler for the #MetaDbusDBusProperties::handle-get signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link>.
 */

typedef MetaDbusDBusPropertiesIface MetaDbusDBusPropertiesInterface;
G_DEFINE_INTERFACE (MetaDbusDBusProperties, meta_dbus_dbus_properties, G_TYPE_OBJECT)

static void
meta_dbus_dbus_properties_default_init (MetaDbusDBusPropertiesIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDbusDBusProperties::handle-get:
   * @object: A #MetaDbusDBusProperties.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_interface: Argument passed by remote caller.
   * @arg_property: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Get">Get()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_dbus_properties_complete_get() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusDBusPropertiesIface, handle_get),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_dbus_properties_method_marshal_get,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

}

/**
 * meta_dbus_dbus_properties_call_get:
 * @proxy: A #MetaDbusDBusPropertiesProxy.
 * @arg_interface: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Get">Get()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_dbus_properties_call_get_finish() to get the result of the operation.
 *
 * See meta_dbus_dbus_properties_call_get_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_dbus_properties_call_get (
    MetaDbusDBusProperties *proxy,
    const gchar *arg_interface,
    const gchar *arg_property,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Get",
    g_variant_new ("(ss)",
                   arg_interface,
                   arg_property),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_dbus_properties_call_get_finish:
 * @proxy: A #MetaDbusDBusPropertiesProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_dbus_properties_call_get().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_dbus_properties_call_get().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_dbus_properties_call_get_finish (
    MetaDbusDBusProperties *proxy,
    GVariant **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_dbus_properties_call_get_sync:
 * @proxy: A #MetaDbusDBusPropertiesProxy.
 * @arg_interface: Argument to pass with the method invocation.
 * @arg_property: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Get">Get()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_dbus_properties_call_get() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_dbus_properties_call_get_sync (
    MetaDbusDBusProperties *proxy,
    const gchar *arg_interface,
    const gchar *arg_property,
    GVariant **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Get",
    g_variant_new ("(ss)",
                   arg_interface,
                   arg_property),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_dbus_properties_complete_get:
 * @object: A #MetaDbusDBusProperties.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DBus-Properties.Get">Get()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_dbus_properties_complete_get (
    MetaDbusDBusProperties *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@v)",
                   value));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDbusDBusPropertiesProxy:
 *
 * The #MetaDbusDBusPropertiesProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDbusDBusPropertiesProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDbusDBusPropertiesProxy.
 */

struct _MetaDbusDBusPropertiesProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_dbus_properties_proxy_iface_init (MetaDbusDBusPropertiesIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDbusDBusPropertiesProxy, meta_dbus_dbus_properties_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDbusDBusPropertiesProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_DBUS_PROPERTIES, meta_dbus_dbus_properties_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDbusDBusPropertiesProxy, meta_dbus_dbus_properties_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_DBUS_PROPERTIES, meta_dbus_dbus_properties_proxy_iface_init))

#endif
static void
meta_dbus_dbus_properties_proxy_finalize (GObject *object)
{
  MetaDbusDBusPropertiesProxy *proxy = META_DBUS_DBUS_PROPERTIES_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_dbus_properties_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_dbus_properties_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_dbus_properties_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_dbus_properties_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_dbus_properties_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_DBUS_PROPERTIES);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_DBUS_PROPERTIES);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_dbus_properties_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDbusDBusPropertiesProxy *proxy = META_DBUS_DBUS_PROPERTIES_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_dbus_properties_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_dbus_properties_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
meta_dbus_dbus_properties_proxy_init (MetaDbusDBusPropertiesProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_dbus_properties_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_TYPE_DBUS_PROPERTIES_PROXY, MetaDbusDBusPropertiesProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_dbus_properties_interface_info ());
}

static void
meta_dbus_dbus_properties_proxy_class_init (MetaDbusDBusPropertiesProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_dbus_properties_proxy_finalize;
  gobject_class->get_property = meta_dbus_dbus_properties_proxy_get_property;
  gobject_class->set_property = meta_dbus_dbus_properties_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_dbus_properties_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_dbus_properties_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDbusDBusPropertiesProxyPrivate));
#endif
}

static void
meta_dbus_dbus_properties_proxy_iface_init (MetaDbusDBusPropertiesIface *iface G_GNUC_UNUSED)
{
}

/**
 * meta_dbus_dbus_properties_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_dbus_properties_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_dbus_properties_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_dbus_properties_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_DBUS_PROPERTIES_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
}

/**
 * meta_dbus_dbus_properties_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_dbus_properties_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_dbus_properties_proxy_new().
 *
 * Returns: (transfer full) (type MetaDbusDBusPropertiesProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusDBusProperties *
meta_dbus_dbus_properties_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_DBUS_PROPERTIES (ret);
  else
    return NULL;
}

/**
 * meta_dbus_dbus_properties_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_dbus_properties_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDbusDBusPropertiesProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusDBusProperties *
meta_dbus_dbus_properties_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_DBUS_PROPERTIES_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
  if (ret != NULL)
    return META_DBUS_DBUS_PROPERTIES (ret);
  else
    return NULL;
}


/**
 * meta_dbus_dbus_properties_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_dbus_properties_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_dbus_properties_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_dbus_properties_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_dbus_properties_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_DBUS_PROPERTIES_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
}

/**
 * meta_dbus_dbus_properties_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_dbus_properties_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_dbus_properties_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDbusDBusPropertiesProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusDBusProperties *
meta_dbus_dbus_properties_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_DBUS_PROPERTIES (ret);
  else
    return NULL;
}

/**
 * meta_dbus_dbus_properties_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_dbus_properties_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_dbus_properties_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDbusDBusPropertiesProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusDBusProperties *
meta_dbus_dbus_properties_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_DBUS_PROPERTIES_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
  if (ret != NULL)
    return META_DBUS_DBUS_PROPERTIES (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDbusDBusPropertiesSkeleton:
 *
 * The #MetaDbusDBusPropertiesSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDbusDBusPropertiesSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDbusDBusPropertiesSkeleton.
 */

struct _MetaDbusDBusPropertiesSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_dbus_properties_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDbusDBusPropertiesSkeleton *skeleton = META_DBUS_DBUS_PROPERTIES_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_TYPE_DBUS_PROPERTIES);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_DBUS_PROPERTIES);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_dbus_properties_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDbusDBusPropertiesSkeleton *skeleton = META_DBUS_DBUS_PROPERTIES_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_dbus_properties_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_dbus_properties_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDbusDBusPropertiesSkeleton *skeleton = META_DBUS_DBUS_PROPERTIES_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_dbus_properties_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_dbus_properties_skeleton_vtable =
{
  _meta_dbus_dbus_properties_skeleton_handle_method_call,
  _meta_dbus_dbus_properties_skeleton_handle_get_property,
  _meta_dbus_dbus_properties_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_dbus_properties_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_dbus_properties_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_dbus_properties_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_dbus_properties_skeleton_vtable;
}

static GVariant *
meta_dbus_dbus_properties_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDbusDBusPropertiesSkeleton *skeleton = META_DBUS_DBUS_PROPERTIES_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_meta_dbus_dbus_properties_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_dbus_properties_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_dbus_properties_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_dbus_properties_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.DBus.Properties", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
meta_dbus_dbus_properties_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void meta_dbus_dbus_properties_skeleton_iface_init (MetaDbusDBusPropertiesIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDbusDBusPropertiesSkeleton, meta_dbus_dbus_properties_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDbusDBusPropertiesSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_DBUS_PROPERTIES, meta_dbus_dbus_properties_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDbusDBusPropertiesSkeleton, meta_dbus_dbus_properties_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_DBUS_PROPERTIES, meta_dbus_dbus_properties_skeleton_iface_init))

#endif
static void
meta_dbus_dbus_properties_skeleton_finalize (GObject *object)
{
  MetaDbusDBusPropertiesSkeleton *skeleton = META_DBUS_DBUS_PROPERTIES_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_dbus_properties_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_dbus_properties_skeleton_init (MetaDbusDBusPropertiesSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_dbus_properties_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_TYPE_DBUS_PROPERTIES_SKELETON, MetaDbusDBusPropertiesSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
meta_dbus_dbus_properties_skeleton_class_init (MetaDbusDBusPropertiesSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_dbus_properties_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_dbus_properties_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_dbus_properties_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_dbus_properties_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_dbus_properties_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDbusDBusPropertiesSkeletonPrivate));
#endif
}

static void
meta_dbus_dbus_properties_skeleton_iface_init (MetaDbusDBusPropertiesIface *iface G_GNUC_UNUSED)
{
}

/**
 * meta_dbus_dbus_properties_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Properties.top_of_page">org.freedesktop.DBus.Properties</link>.
 *
 * Returns: (transfer full) (type MetaDbusDBusPropertiesSkeleton): The skeleton object.
 */
MetaDbusDBusProperties *
meta_dbus_dbus_properties_skeleton_new (void)
{
  return META_DBUS_DBUS_PROPERTIES (g_object_new (META_DBUS_TYPE_DBUS_PROPERTIES_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.DBus.Introspectable
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDbusDBusIntrospectable
 * @title: MetaDbusDBusIntrospectable
 * @short_description: Generated C code for the org.freedesktop.DBus.Introspectable D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.DBus.Introspectable ---- */

static const _ExtendedGDBusArgInfo _meta_dbus_dbus_introspectable_method_info_introspect_OUT_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_dbus_introspectable_method_info_introspect_OUT_ARG_pointers[] =
{
  &_meta_dbus_dbus_introspectable_method_info_introspect_OUT_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_dbus_introspectable_method_info_introspect =
{
  {
    -1,
    (gchar *) "Introspect",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_dbus_introspectable_method_info_introspect_OUT_ARG_pointers,
    NULL
  },
  "handle-introspect",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_dbus_introspectable_method_info_pointers[] =
{
  &_meta_dbus_dbus_introspectable_method_info_introspect.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_dbus_introspectable_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.DBus.Introspectable",
    (GDBusMethodInfo **) &_meta_dbus_dbus_introspectable_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "dbus-introspectable",
};


/**
 * meta_dbus_dbus_introspectable_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_dbus_introspectable_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_dbus_introspectable_interface_info.parent_struct;
}

/**
 * meta_dbus_dbus_introspectable_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDbusDBusIntrospectable interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_dbus_introspectable_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
meta_dbus_dbus_introspectable_method_marshal_introspect (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDbusDBusIntrospectable:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link>.
 */

/**
 * MetaDbusDBusIntrospectableIface:
 * @parent_iface: The parent interface.
 * @handle_introspect: Handler for the #MetaDbusDBusIntrospectable::handle-introspect signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link>.
 */

typedef MetaDbusDBusIntrospectableIface MetaDbusDBusIntrospectableInterface;
G_DEFINE_INTERFACE (MetaDbusDBusIntrospectable, meta_dbus_dbus_introspectable, G_TYPE_OBJECT)

static void
meta_dbus_dbus_introspectable_default_init (MetaDbusDBusIntrospectableIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDbusDBusIntrospectable::handle-introspect:
   * @object: A #MetaDbusDBusIntrospectable.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DBus-Introspectable.Introspect">Introspect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_dbus_introspectable_complete_introspect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-introspect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusDBusIntrospectableIface, handle_introspect),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_dbus_introspectable_method_marshal_introspect,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * meta_dbus_dbus_introspectable_call_introspect:
 * @proxy: A #MetaDbusDBusIntrospectableProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Introspectable.Introspect">Introspect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_dbus_introspectable_call_introspect_finish() to get the result of the operation.
 *
 * See meta_dbus_dbus_introspectable_call_introspect_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_dbus_introspectable_call_introspect (
    MetaDbusDBusIntrospectable *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Introspect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_dbus_introspectable_call_introspect_finish:
 * @proxy: A #MetaDbusDBusIntrospectableProxy.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_dbus_introspectable_call_introspect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_dbus_introspectable_call_introspect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_dbus_introspectable_call_introspect_finish (
    MetaDbusDBusIntrospectable *proxy,
    gchar **out_data,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_dbus_introspectable_call_introspect_sync:
 * @proxy: A #MetaDbusDBusIntrospectableProxy.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DBus-Introspectable.Introspect">Introspect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_dbus_introspectable_call_introspect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_dbus_introspectable_call_introspect_sync (
    MetaDbusDBusIntrospectable *proxy,
    gchar **out_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Introspect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_dbus_introspectable_complete_introspect:
 * @object: A #MetaDbusDBusIntrospectable.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @data: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DBus-Introspectable.Introspect">Introspect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_dbus_introspectable_complete_introspect (
    MetaDbusDBusIntrospectable *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *data)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   data));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDbusDBusIntrospectableProxy:
 *
 * The #MetaDbusDBusIntrospectableProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDbusDBusIntrospectableProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDbusDBusIntrospectableProxy.
 */

struct _MetaDbusDBusIntrospectableProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_dbus_introspectable_proxy_iface_init (MetaDbusDBusIntrospectableIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDbusDBusIntrospectableProxy, meta_dbus_dbus_introspectable_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDbusDBusIntrospectableProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_DBUS_INTROSPECTABLE, meta_dbus_dbus_introspectable_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDbusDBusIntrospectableProxy, meta_dbus_dbus_introspectable_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_DBUS_INTROSPECTABLE, meta_dbus_dbus_introspectable_proxy_iface_init))

#endif
static void
meta_dbus_dbus_introspectable_proxy_finalize (GObject *object)
{
  MetaDbusDBusIntrospectableProxy *proxy = META_DBUS_DBUS_INTROSPECTABLE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_dbus_introspectable_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_dbus_introspectable_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_dbus_introspectable_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_dbus_introspectable_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_dbus_introspectable_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_DBUS_INTROSPECTABLE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_DBUS_INTROSPECTABLE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_dbus_introspectable_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDbusDBusIntrospectableProxy *proxy = META_DBUS_DBUS_INTROSPECTABLE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_dbus_introspectable_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_dbus_introspectable_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
meta_dbus_dbus_introspectable_proxy_init (MetaDbusDBusIntrospectableProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_dbus_introspectable_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_TYPE_DBUS_INTROSPECTABLE_PROXY, MetaDbusDBusIntrospectableProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_dbus_introspectable_interface_info ());
}

static void
meta_dbus_dbus_introspectable_proxy_class_init (MetaDbusDBusIntrospectableProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_dbus_introspectable_proxy_finalize;
  gobject_class->get_property = meta_dbus_dbus_introspectable_proxy_get_property;
  gobject_class->set_property = meta_dbus_dbus_introspectable_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_dbus_introspectable_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_dbus_introspectable_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDbusDBusIntrospectableProxyPrivate));
#endif
}

static void
meta_dbus_dbus_introspectable_proxy_iface_init (MetaDbusDBusIntrospectableIface *iface G_GNUC_UNUSED)
{
}

/**
 * meta_dbus_dbus_introspectable_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_dbus_introspectable_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_dbus_introspectable_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_dbus_introspectable_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_DBUS_INTROSPECTABLE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
}

/**
 * meta_dbus_dbus_introspectable_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_dbus_introspectable_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_dbus_introspectable_proxy_new().
 *
 * Returns: (transfer full) (type MetaDbusDBusIntrospectableProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusDBusIntrospectable *
meta_dbus_dbus_introspectable_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_DBUS_INTROSPECTABLE (ret);
  else
    return NULL;
}

/**
 * meta_dbus_dbus_introspectable_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_dbus_introspectable_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDbusDBusIntrospectableProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusDBusIntrospectable *
meta_dbus_dbus_introspectable_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_DBUS_INTROSPECTABLE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
  if (ret != NULL)
    return META_DBUS_DBUS_INTROSPECTABLE (ret);
  else
    return NULL;
}


/**
 * meta_dbus_dbus_introspectable_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_dbus_introspectable_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_dbus_introspectable_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_dbus_introspectable_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_dbus_introspectable_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_DBUS_INTROSPECTABLE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
}

/**
 * meta_dbus_dbus_introspectable_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_dbus_introspectable_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_dbus_introspectable_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDbusDBusIntrospectableProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusDBusIntrospectable *
meta_dbus_dbus_introspectable_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_DBUS_INTROSPECTABLE (ret);
  else
    return NULL;
}

/**
 * meta_dbus_dbus_introspectable_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_dbus_introspectable_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_dbus_introspectable_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDbusDBusIntrospectableProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusDBusIntrospectable *
meta_dbus_dbus_introspectable_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_DBUS_INTROSPECTABLE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
  if (ret != NULL)
    return META_DBUS_DBUS_INTROSPECTABLE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDbusDBusIntrospectableSkeleton:
 *
 * The #MetaDbusDBusIntrospectableSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDbusDBusIntrospectableSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDbusDBusIntrospectableSkeleton.
 */

struct _MetaDbusDBusIntrospectableSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_dbus_introspectable_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDbusDBusIntrospectableSkeleton *skeleton = META_DBUS_DBUS_INTROSPECTABLE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_TYPE_DBUS_INTROSPECTABLE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_DBUS_INTROSPECTABLE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_dbus_introspectable_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDbusDBusIntrospectableSkeleton *skeleton = META_DBUS_DBUS_INTROSPECTABLE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_dbus_introspectable_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_dbus_introspectable_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDbusDBusIntrospectableSkeleton *skeleton = META_DBUS_DBUS_INTROSPECTABLE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_dbus_introspectable_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_dbus_introspectable_skeleton_vtable =
{
  _meta_dbus_dbus_introspectable_skeleton_handle_method_call,
  _meta_dbus_dbus_introspectable_skeleton_handle_get_property,
  _meta_dbus_dbus_introspectable_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_dbus_introspectable_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_dbus_introspectable_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_dbus_introspectable_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_dbus_introspectable_skeleton_vtable;
}

static GVariant *
meta_dbus_dbus_introspectable_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDbusDBusIntrospectableSkeleton *skeleton = META_DBUS_DBUS_INTROSPECTABLE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_meta_dbus_dbus_introspectable_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_dbus_introspectable_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_dbus_introspectable_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_dbus_introspectable_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.DBus.Introspectable", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
meta_dbus_dbus_introspectable_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void meta_dbus_dbus_introspectable_skeleton_iface_init (MetaDbusDBusIntrospectableIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDbusDBusIntrospectableSkeleton, meta_dbus_dbus_introspectable_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDbusDBusIntrospectableSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_DBUS_INTROSPECTABLE, meta_dbus_dbus_introspectable_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDbusDBusIntrospectableSkeleton, meta_dbus_dbus_introspectable_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_DBUS_INTROSPECTABLE, meta_dbus_dbus_introspectable_skeleton_iface_init))

#endif
static void
meta_dbus_dbus_introspectable_skeleton_finalize (GObject *object)
{
  MetaDbusDBusIntrospectableSkeleton *skeleton = META_DBUS_DBUS_INTROSPECTABLE_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_dbus_introspectable_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_dbus_introspectable_skeleton_init (MetaDbusDBusIntrospectableSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_dbus_introspectable_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_TYPE_DBUS_INTROSPECTABLE_SKELETON, MetaDbusDBusIntrospectableSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
meta_dbus_dbus_introspectable_skeleton_class_init (MetaDbusDBusIntrospectableSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_dbus_introspectable_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_dbus_introspectable_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_dbus_introspectable_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_dbus_introspectable_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_dbus_introspectable_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDbusDBusIntrospectableSkeletonPrivate));
#endif
}

static void
meta_dbus_dbus_introspectable_skeleton_iface_init (MetaDbusDBusIntrospectableIface *iface G_GNUC_UNUSED)
{
}

/**
 * meta_dbus_dbus_introspectable_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DBus-Introspectable.top_of_page">org.freedesktop.DBus.Introspectable</link>.
 *
 * Returns: (transfer full) (type MetaDbusDBusIntrospectableSkeleton): The skeleton object.
 */
MetaDbusDBusIntrospectable *
meta_dbus_dbus_introspectable_skeleton_new (void)
{
  return META_DBUS_DBUS_INTROSPECTABLE (g_object_new (META_DBUS_TYPE_DBUS_INTROSPECTABLE_SKELETON, NULL));
}

