/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CounterSetApplyConfiguration represents a declarative configuration of the CounterSet type for use
// with apply.
//
// CounterSet defines a named set of counters
// that are available to be used by devices defined in the
// ResourcePool.
//
// The counters are not allocatable by themselves, but
// can be referenced by devices. When a device is allocated,
// the portion of counters it uses will no longer be available for use
// by other devices.
type CounterSetApplyConfiguration struct {
	// Name defines the name of the counter set.
	// It must be a DNS label.
	Name *string `json:"name,omitempty"`
	// Counters defines the set of counters for this CounterSet
	// The name of each counter must be unique in that set and must be a DNS label.
	//
	// The maximum number of counters is 32.
	Counters map[string]CounterApplyConfiguration `json:"counters,omitempty"`
}

// CounterSetApplyConfiguration constructs a declarative configuration of the CounterSet type for use with
// apply.
func CounterSet() *CounterSetApplyConfiguration {
	return &CounterSetApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *CounterSetApplyConfiguration) WithName(value string) *CounterSetApplyConfiguration {
	b.Name = &value
	return b
}

// WithCounters puts the entries into the Counters field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Counters field,
// overwriting an existing map entries in Counters field with the same key.
func (b *CounterSetApplyConfiguration) WithCounters(entries map[string]CounterApplyConfiguration) *CounterSetApplyConfiguration {
	if b.Counters == nil && len(entries) > 0 {
		b.Counters = make(map[string]CounterApplyConfiguration, len(entries))
	}
	for k, v := range entries {
		b.Counters[k] = v
	}
	return b
}
