// Code generated by "libovsdb.modelgen"
// DO NOT EDIT.

package ovsmodel

const ControllerTable = "Controller"

type (
	ControllerConnectionMode = string
	ControllerRole           = string
	ControllerType           = string
)

var (
	ControllerConnectionModeInBand    ControllerConnectionMode = "in-band"
	ControllerConnectionModeOutOfBand ControllerConnectionMode = "out-of-band"
	ControllerRoleOther               ControllerRole           = "other"
	ControllerRoleMaster              ControllerRole           = "master"
	ControllerRoleSlave               ControllerRole           = "slave"
	ControllerTypePrimary             ControllerType           = "primary"
	ControllerTypeService             ControllerType           = "service"
)

// Controller defines an object in Controller table
type Controller struct {
	UUID                 string                    `ovsdb:"_uuid"`
	ConnectionMode       *ControllerConnectionMode `ovsdb:"connection_mode" validate:"omitempty,oneof='in-band' 'out-of-band'"`
	ControllerBurstLimit *int                      `ovsdb:"controller_burst_limit" validate:"omitempty,min=25"`
	ControllerQueueSize  *int                      `ovsdb:"controller_queue_size" validate:"omitempty,min=1,max=512"`
	ControllerRateLimit  *int                      `ovsdb:"controller_rate_limit" validate:"omitempty,min=100"`
	EnableAsyncMessages  *bool                     `ovsdb:"enable_async_messages"`
	ExternalIDs          map[string]string         `ovsdb:"external_ids"`
	InactivityProbe      *int                      `ovsdb:"inactivity_probe"`
	IsConnected          bool                      `ovsdb:"is_connected"`
	LocalGateway         *string                   `ovsdb:"local_gateway"`
	LocalIP              *string                   `ovsdb:"local_ip"`
	LocalNetmask         *string                   `ovsdb:"local_netmask"`
	MaxBackoff           *int                      `ovsdb:"max_backoff" validate:"omitempty,min=1000"`
	OtherConfig          map[string]string         `ovsdb:"other_config"`
	Role                 *ControllerRole           `ovsdb:"role" validate:"omitempty,oneof='other' 'master' 'slave'"`
	Status               map[string]string         `ovsdb:"status"`
	Target               string                    `ovsdb:"target"`
	Type                 *ControllerType           `ovsdb:"type" validate:"omitempty,oneof='primary' 'service'"`
}
