{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Recognizes long press gestures.
-- 
-- This gesture is also known as “Press and Hold”.
-- 
-- When the timeout is exceeded, the gesture is triggering the
-- [GestureLongPress::pressed]("GI.Gtk.Objects.GestureLongPress#g:signal:pressed") signal.
-- 
-- If the touchpoint is lifted before the timeout passes, or if
-- it drifts too far of the initial press point, the
-- [GestureLongPress::cancelled]("GI.Gtk.Objects.GestureLongPress#g:signal:cancelled") signal will be emitted.
-- 
-- How long the timeout is before the [pressed](#g:signal:pressed) signal gets emitted is
-- determined by the [Settings:gtkLongPressTime]("GI.Gtk.Objects.Settings#g:attr:gtkLongPressTime") setting.
-- It can be modified by the [GestureLongPress:delayFactor]("GI.Gtk.Objects.GestureLongPress#g:attr:delayFactor")
-- property.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.GestureLongPress
    ( 

-- * Exported types
    GestureLongPress(..)                    ,
    IsGestureLongPress                      ,
    toGestureLongPress                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [group]("GI.Gtk.Objects.Gesture#g:method:group"), [handlesSequence]("GI.Gtk.Objects.Gesture#g:method:handlesSequence"), [isActive]("GI.Gtk.Objects.Gesture#g:method:isActive"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isGroupedWith]("GI.Gtk.Objects.Gesture#g:method:isGroupedWith"), [isRecognized]("GI.Gtk.Objects.Gesture#g:method:isRecognized"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.EventController#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [ungroup]("GI.Gtk.Objects.Gesture#g:method:ungroup"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBoundingBox]("GI.Gtk.Objects.Gesture#g:method:getBoundingBox"), [getBoundingBoxCenter]("GI.Gtk.Objects.Gesture#g:method:getBoundingBoxCenter"), [getButton]("GI.Gtk.Objects.GestureSingle#g:method:getButton"), [getCurrentButton]("GI.Gtk.Objects.GestureSingle#g:method:getCurrentButton"), [getCurrentEvent]("GI.Gtk.Objects.EventController#g:method:getCurrentEvent"), [getCurrentEventDevice]("GI.Gtk.Objects.EventController#g:method:getCurrentEventDevice"), [getCurrentEventState]("GI.Gtk.Objects.EventController#g:method:getCurrentEventState"), [getCurrentEventTime]("GI.Gtk.Objects.EventController#g:method:getCurrentEventTime"), [getCurrentSequence]("GI.Gtk.Objects.GestureSingle#g:method:getCurrentSequence"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDelayFactor]("GI.Gtk.Objects.GestureLongPress#g:method:getDelayFactor"), [getDevice]("GI.Gtk.Objects.Gesture#g:method:getDevice"), [getExclusive]("GI.Gtk.Objects.GestureSingle#g:method:getExclusive"), [getGroup]("GI.Gtk.Objects.Gesture#g:method:getGroup"), [getLastEvent]("GI.Gtk.Objects.Gesture#g:method:getLastEvent"), [getLastUpdatedSequence]("GI.Gtk.Objects.Gesture#g:method:getLastUpdatedSequence"), [getName]("GI.Gtk.Objects.EventController#g:method:getName"), [getPoint]("GI.Gtk.Objects.Gesture#g:method:getPoint"), [getPropagationLimit]("GI.Gtk.Objects.EventController#g:method:getPropagationLimit"), [getPropagationPhase]("GI.Gtk.Objects.EventController#g:method:getPropagationPhase"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSequenceState]("GI.Gtk.Objects.Gesture#g:method:getSequenceState"), [getSequences]("GI.Gtk.Objects.Gesture#g:method:getSequences"), [getTouchOnly]("GI.Gtk.Objects.GestureSingle#g:method:getTouchOnly"), [getWidget]("GI.Gtk.Objects.EventController#g:method:getWidget").
-- 
-- ==== Setters
-- [setButton]("GI.Gtk.Objects.GestureSingle#g:method:setButton"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDelayFactor]("GI.Gtk.Objects.GestureLongPress#g:method:setDelayFactor"), [setExclusive]("GI.Gtk.Objects.GestureSingle#g:method:setExclusive"), [setName]("GI.Gtk.Objects.EventController#g:method:setName"), [setPropagationLimit]("GI.Gtk.Objects.EventController#g:method:setPropagationLimit"), [setPropagationPhase]("GI.Gtk.Objects.EventController#g:method:setPropagationPhase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSequenceState]("GI.Gtk.Objects.Gesture#g:method:setSequenceState"), [setState]("GI.Gtk.Objects.Gesture#g:method:setState"), [setStaticName]("GI.Gtk.Objects.EventController#g:method:setStaticName"), [setTouchOnly]("GI.Gtk.Objects.GestureSingle#g:method:setTouchOnly").

#if defined(ENABLE_OVERLOADING)
    ResolveGestureLongPressMethod           ,
#endif

-- ** getDelayFactor #method:getDelayFactor#

#if defined(ENABLE_OVERLOADING)
    GestureLongPressGetDelayFactorMethodInfo,
#endif
    gestureLongPressGetDelayFactor          ,


-- ** new #method:new#

    gestureLongPressNew                     ,


-- ** setDelayFactor #method:setDelayFactor#

#if defined(ENABLE_OVERLOADING)
    GestureLongPressSetDelayFactorMethodInfo,
#endif
    gestureLongPressSetDelayFactor          ,




 -- * Properties


-- ** delayFactor #attr:delayFactor#
-- | Factor by which to modify the default timeout.

#if defined(ENABLE_OVERLOADING)
    GestureLongPressDelayFactorPropertyInfo ,
#endif
    constructGestureLongPressDelayFactor    ,
#if defined(ENABLE_OVERLOADING)
    gestureLongPressDelayFactor             ,
#endif
    getGestureLongPressDelayFactor          ,
    setGestureLongPressDelayFactor          ,




 -- * Signals


-- ** cancelled #signal:cancelled#

    GestureLongPressCancelledCallback       ,
#if defined(ENABLE_OVERLOADING)
    GestureLongPressCancelledSignalInfo     ,
#endif
    afterGestureLongPressCancelled          ,
    onGestureLongPressCancelled             ,


-- ** pressed #signal:pressed#

    GestureLongPressPressedCallback         ,
#if defined(ENABLE_OVERLOADING)
    GestureLongPressPressedSignalInfo       ,
#endif
    afterGestureLongPressPressed            ,
    onGestureLongPressPressed               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Gesture as Gtk.Gesture
import {-# SOURCE #-} qualified GI.Gtk.Objects.GestureSingle as Gtk.GestureSingle
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Gesture as Gtk.Gesture
import {-# SOURCE #-} qualified GI.Gtk.Objects.GestureSingle as Gtk.GestureSingle

#endif

-- | Memory-managed wrapper type.
newtype GestureLongPress = GestureLongPress (SP.ManagedPtr GestureLongPress)
    deriving (Eq)

instance SP.ManagedPtrNewtype GestureLongPress where
    toManagedPtr (GestureLongPress p) = p

foreign import ccall "gtk_gesture_long_press_get_type"
    c_gtk_gesture_long_press_get_type :: IO B.Types.GType

instance B.Types.TypedObject GestureLongPress where
    glibType = c_gtk_gesture_long_press_get_type

instance B.Types.GObject GestureLongPress

-- | Type class for types which can be safely cast to t'GestureLongPress', for instance with `toGestureLongPress`.
class (SP.GObject o, O.IsDescendantOf GestureLongPress o) => IsGestureLongPress o
instance (SP.GObject o, O.IsDescendantOf GestureLongPress o) => IsGestureLongPress o

instance O.HasParentTypes GestureLongPress
type instance O.ParentTypes GestureLongPress = '[Gtk.GestureSingle.GestureSingle, Gtk.Gesture.Gesture, Gtk.EventController.EventController, GObject.Object.Object]

-- | Cast to t'GestureLongPress', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toGestureLongPress :: (MIO.MonadIO m, IsGestureLongPress o) => o -> m GestureLongPress
toGestureLongPress = MIO.liftIO . B.ManagedPtr.unsafeCastTo GestureLongPress

-- | Convert t'GestureLongPress' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GestureLongPress) where
    gvalueGType_ = c_gtk_gesture_long_press_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GestureLongPress)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GestureLongPress)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GestureLongPress ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGestureLongPressMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGestureLongPressMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGestureLongPressMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGestureLongPressMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGestureLongPressMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGestureLongPressMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGestureLongPressMethod "group" o = Gtk.Gesture.GestureGroupMethodInfo
    ResolveGestureLongPressMethod "handlesSequence" o = Gtk.Gesture.GestureHandlesSequenceMethodInfo
    ResolveGestureLongPressMethod "isActive" o = Gtk.Gesture.GestureIsActiveMethodInfo
    ResolveGestureLongPressMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGestureLongPressMethod "isGroupedWith" o = Gtk.Gesture.GestureIsGroupedWithMethodInfo
    ResolveGestureLongPressMethod "isRecognized" o = Gtk.Gesture.GestureIsRecognizedMethodInfo
    ResolveGestureLongPressMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGestureLongPressMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGestureLongPressMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGestureLongPressMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGestureLongPressMethod "reset" o = Gtk.EventController.EventControllerResetMethodInfo
    ResolveGestureLongPressMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGestureLongPressMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGestureLongPressMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGestureLongPressMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGestureLongPressMethod "ungroup" o = Gtk.Gesture.GestureUngroupMethodInfo
    ResolveGestureLongPressMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGestureLongPressMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGestureLongPressMethod "getBoundingBox" o = Gtk.Gesture.GestureGetBoundingBoxMethodInfo
    ResolveGestureLongPressMethod "getBoundingBoxCenter" o = Gtk.Gesture.GestureGetBoundingBoxCenterMethodInfo
    ResolveGestureLongPressMethod "getButton" o = Gtk.GestureSingle.GestureSingleGetButtonMethodInfo
    ResolveGestureLongPressMethod "getCurrentButton" o = Gtk.GestureSingle.GestureSingleGetCurrentButtonMethodInfo
    ResolveGestureLongPressMethod "getCurrentEvent" o = Gtk.EventController.EventControllerGetCurrentEventMethodInfo
    ResolveGestureLongPressMethod "getCurrentEventDevice" o = Gtk.EventController.EventControllerGetCurrentEventDeviceMethodInfo
    ResolveGestureLongPressMethod "getCurrentEventState" o = Gtk.EventController.EventControllerGetCurrentEventStateMethodInfo
    ResolveGestureLongPressMethod "getCurrentEventTime" o = Gtk.EventController.EventControllerGetCurrentEventTimeMethodInfo
    ResolveGestureLongPressMethod "getCurrentSequence" o = Gtk.GestureSingle.GestureSingleGetCurrentSequenceMethodInfo
    ResolveGestureLongPressMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGestureLongPressMethod "getDelayFactor" o = GestureLongPressGetDelayFactorMethodInfo
    ResolveGestureLongPressMethod "getDevice" o = Gtk.Gesture.GestureGetDeviceMethodInfo
    ResolveGestureLongPressMethod "getExclusive" o = Gtk.GestureSingle.GestureSingleGetExclusiveMethodInfo
    ResolveGestureLongPressMethod "getGroup" o = Gtk.Gesture.GestureGetGroupMethodInfo
    ResolveGestureLongPressMethod "getLastEvent" o = Gtk.Gesture.GestureGetLastEventMethodInfo
    ResolveGestureLongPressMethod "getLastUpdatedSequence" o = Gtk.Gesture.GestureGetLastUpdatedSequenceMethodInfo
    ResolveGestureLongPressMethod "getName" o = Gtk.EventController.EventControllerGetNameMethodInfo
    ResolveGestureLongPressMethod "getPoint" o = Gtk.Gesture.GestureGetPointMethodInfo
    ResolveGestureLongPressMethod "getPropagationLimit" o = Gtk.EventController.EventControllerGetPropagationLimitMethodInfo
    ResolveGestureLongPressMethod "getPropagationPhase" o = Gtk.EventController.EventControllerGetPropagationPhaseMethodInfo
    ResolveGestureLongPressMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGestureLongPressMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGestureLongPressMethod "getSequenceState" o = Gtk.Gesture.GestureGetSequenceStateMethodInfo
    ResolveGestureLongPressMethod "getSequences" o = Gtk.Gesture.GestureGetSequencesMethodInfo
    ResolveGestureLongPressMethod "getTouchOnly" o = Gtk.GestureSingle.GestureSingleGetTouchOnlyMethodInfo
    ResolveGestureLongPressMethod "getWidget" o = Gtk.EventController.EventControllerGetWidgetMethodInfo
    ResolveGestureLongPressMethod "setButton" o = Gtk.GestureSingle.GestureSingleSetButtonMethodInfo
    ResolveGestureLongPressMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGestureLongPressMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGestureLongPressMethod "setDelayFactor" o = GestureLongPressSetDelayFactorMethodInfo
    ResolveGestureLongPressMethod "setExclusive" o = Gtk.GestureSingle.GestureSingleSetExclusiveMethodInfo
    ResolveGestureLongPressMethod "setName" o = Gtk.EventController.EventControllerSetNameMethodInfo
    ResolveGestureLongPressMethod "setPropagationLimit" o = Gtk.EventController.EventControllerSetPropagationLimitMethodInfo
    ResolveGestureLongPressMethod "setPropagationPhase" o = Gtk.EventController.EventControllerSetPropagationPhaseMethodInfo
    ResolveGestureLongPressMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGestureLongPressMethod "setSequenceState" o = Gtk.Gesture.GestureSetSequenceStateMethodInfo
    ResolveGestureLongPressMethod "setState" o = Gtk.Gesture.GestureSetStateMethodInfo
    ResolveGestureLongPressMethod "setStaticName" o = Gtk.EventController.EventControllerSetStaticNameMethodInfo
    ResolveGestureLongPressMethod "setTouchOnly" o = Gtk.GestureSingle.GestureSingleSetTouchOnlyMethodInfo
    ResolveGestureLongPressMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGestureLongPressMethod t GestureLongPress, O.OverloadedMethod info GestureLongPress p) => OL.IsLabel t (GestureLongPress -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGestureLongPressMethod t GestureLongPress, O.OverloadedMethod info GestureLongPress p, R.HasField t GestureLongPress p) => R.HasField t GestureLongPress p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGestureLongPressMethod t GestureLongPress, O.OverloadedMethodInfo info GestureLongPress) => OL.IsLabel t (O.MethodProxy info GestureLongPress) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal GestureLongPress::cancelled
-- | Emitted whenever a press moved too far, or was released
-- before [GestureLongPress::pressed]("GI.Gtk.Objects.GestureLongPress#g:signal:pressed") happened.
type GestureLongPressCancelledCallback =
    IO ()

type C_GestureLongPressCancelledCallback =
    Ptr GestureLongPress ->                 -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_GestureLongPressCancelledCallback`.
foreign import ccall "wrapper"
    mk_GestureLongPressCancelledCallback :: C_GestureLongPressCancelledCallback -> IO (FunPtr C_GestureLongPressCancelledCallback)

wrap_GestureLongPressCancelledCallback :: 
    GObject a => (a -> GestureLongPressCancelledCallback) ->
    C_GestureLongPressCancelledCallback
wrap_GestureLongPressCancelledCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [cancelled](#signal:cancelled) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' gestureLongPress #cancelled callback
-- @
-- 
-- 
onGestureLongPressCancelled :: (IsGestureLongPress a, MonadIO m) => a -> ((?self :: a) => GestureLongPressCancelledCallback) -> m SignalHandlerId
onGestureLongPressCancelled obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureLongPressCancelledCallback wrapped
    wrapped'' <- mk_GestureLongPressCancelledCallback wrapped'
    connectSignalFunPtr obj "cancelled" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [cancelled](#signal:cancelled) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' gestureLongPress #cancelled callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterGestureLongPressCancelled :: (IsGestureLongPress a, MonadIO m) => a -> ((?self :: a) => GestureLongPressCancelledCallback) -> m SignalHandlerId
afterGestureLongPressCancelled obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureLongPressCancelledCallback wrapped
    wrapped'' <- mk_GestureLongPressCancelledCallback wrapped'
    connectSignalFunPtr obj "cancelled" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data GestureLongPressCancelledSignalInfo
instance SignalInfo GestureLongPressCancelledSignalInfo where
    type HaskellCallbackType GestureLongPressCancelledSignalInfo = GestureLongPressCancelledCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_GestureLongPressCancelledCallback cb
        cb'' <- mk_GestureLongPressCancelledCallback cb'
        connectSignalFunPtr obj "cancelled" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureLongPress::cancelled"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureLongPress.html#g:signal:cancelled"})

#endif

-- signal GestureLongPress::pressed
-- | Emitted whenever a press goes unmoved\/unreleased longer than
-- what the GTK defaults tell.
type GestureLongPressPressedCallback =
    Double
    -- ^ /@x@/: the X coordinate where the press happened, relative to the widget allocation
    -> Double
    -- ^ /@y@/: the Y coordinate where the press happened, relative to the widget allocation
    -> IO ()

type C_GestureLongPressPressedCallback =
    Ptr GestureLongPress ->                 -- object
    CDouble ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_GestureLongPressPressedCallback`.
foreign import ccall "wrapper"
    mk_GestureLongPressPressedCallback :: C_GestureLongPressPressedCallback -> IO (FunPtr C_GestureLongPressPressedCallback)

wrap_GestureLongPressPressedCallback :: 
    GObject a => (a -> GestureLongPressPressedCallback) ->
    C_GestureLongPressPressedCallback
wrap_GestureLongPressPressedCallback gi'cb gi'selfPtr x y _ = do
    let x' = realToFrac x
    let y' = realToFrac y
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  x' y'


-- | Connect a signal handler for the [pressed](#signal:pressed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' gestureLongPress #pressed callback
-- @
-- 
-- 
onGestureLongPressPressed :: (IsGestureLongPress a, MonadIO m) => a -> ((?self :: a) => GestureLongPressPressedCallback) -> m SignalHandlerId
onGestureLongPressPressed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureLongPressPressedCallback wrapped
    wrapped'' <- mk_GestureLongPressPressedCallback wrapped'
    connectSignalFunPtr obj "pressed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [pressed](#signal:pressed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' gestureLongPress #pressed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterGestureLongPressPressed :: (IsGestureLongPress a, MonadIO m) => a -> ((?self :: a) => GestureLongPressPressedCallback) -> m SignalHandlerId
afterGestureLongPressPressed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureLongPressPressedCallback wrapped
    wrapped'' <- mk_GestureLongPressPressedCallback wrapped'
    connectSignalFunPtr obj "pressed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data GestureLongPressPressedSignalInfo
instance SignalInfo GestureLongPressPressedSignalInfo where
    type HaskellCallbackType GestureLongPressPressedSignalInfo = GestureLongPressPressedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_GestureLongPressPressedCallback cb
        cb'' <- mk_GestureLongPressPressedCallback cb'
        connectSignalFunPtr obj "pressed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureLongPress::pressed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureLongPress.html#g:signal:pressed"})

#endif

-- VVV Prop "delay-factor"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@delay-factor@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gestureLongPress #delayFactor
-- @
getGestureLongPressDelayFactor :: (MonadIO m, IsGestureLongPress o) => o -> m Double
getGestureLongPressDelayFactor obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "delay-factor"

-- | Set the value of the “@delay-factor@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gestureLongPress [ #delayFactor 'Data.GI.Base.Attributes.:=' value ]
-- @
setGestureLongPressDelayFactor :: (MonadIO m, IsGestureLongPress o) => o -> Double -> m ()
setGestureLongPressDelayFactor obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "delay-factor" val

-- | Construct a t'GValueConstruct' with valid value for the “@delay-factor@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGestureLongPressDelayFactor :: (IsGestureLongPress o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructGestureLongPressDelayFactor val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "delay-factor" val

#if defined(ENABLE_OVERLOADING)
data GestureLongPressDelayFactorPropertyInfo
instance AttrInfo GestureLongPressDelayFactorPropertyInfo where
    type AttrAllowedOps GestureLongPressDelayFactorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint GestureLongPressDelayFactorPropertyInfo = IsGestureLongPress
    type AttrSetTypeConstraint GestureLongPressDelayFactorPropertyInfo = (~) Double
    type AttrTransferTypeConstraint GestureLongPressDelayFactorPropertyInfo = (~) Double
    type AttrTransferType GestureLongPressDelayFactorPropertyInfo = Double
    type AttrGetType GestureLongPressDelayFactorPropertyInfo = Double
    type AttrLabel GestureLongPressDelayFactorPropertyInfo = "delay-factor"
    type AttrOrigin GestureLongPressDelayFactorPropertyInfo = GestureLongPress
    attrGet = getGestureLongPressDelayFactor
    attrSet = setGestureLongPressDelayFactor
    attrPut = setGestureLongPressDelayFactor
    attrTransfer _ v = do
        return v
    attrConstruct = constructGestureLongPressDelayFactor
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureLongPress.delayFactor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureLongPress.html#g:attr:delayFactor"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GestureLongPress
type instance O.AttributeList GestureLongPress = GestureLongPressAttributeList
type GestureLongPressAttributeList = ('[ '("button", Gtk.GestureSingle.GestureSingleButtonPropertyInfo), '("delayFactor", GestureLongPressDelayFactorPropertyInfo), '("exclusive", Gtk.GestureSingle.GestureSingleExclusivePropertyInfo), '("nPoints", Gtk.Gesture.GestureNPointsPropertyInfo), '("name", Gtk.EventController.EventControllerNamePropertyInfo), '("propagationLimit", Gtk.EventController.EventControllerPropagationLimitPropertyInfo), '("propagationPhase", Gtk.EventController.EventControllerPropagationPhasePropertyInfo), '("touchOnly", Gtk.GestureSingle.GestureSingleTouchOnlyPropertyInfo), '("widget", Gtk.EventController.EventControllerWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
gestureLongPressDelayFactor :: AttrLabelProxy "delayFactor"
gestureLongPressDelayFactor = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GestureLongPress = GestureLongPressSignalList
type GestureLongPressSignalList = ('[ '("begin", Gtk.Gesture.GestureBeginSignalInfo), '("cancel", Gtk.Gesture.GestureCancelSignalInfo), '("cancelled", GestureLongPressCancelledSignalInfo), '("end", Gtk.Gesture.GestureEndSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("pressed", GestureLongPressPressedSignalInfo), '("sequenceStateChanged", Gtk.Gesture.GestureSequenceStateChangedSignalInfo), '("update", Gtk.Gesture.GestureUpdateSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GestureLongPress::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "GestureLongPress" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_gesture_long_press_new" gtk_gesture_long_press_new :: 
    IO (Ptr GestureLongPress)

-- | Returns a newly created @GtkGesture@ that recognizes long presses.
gestureLongPressNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GestureLongPress
    -- ^ __Returns:__ a newly created @GtkGestureLongPress@.
gestureLongPressNew  = liftIO $ do
    result <- gtk_gesture_long_press_new
    checkUnexpectedReturnNULL "gestureLongPressNew" result
    result' <- (wrapObject GestureLongPress) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method GestureLongPress::get_delay_factor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "gesture"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GestureLongPress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkGestureLongPress`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_gesture_long_press_get_delay_factor" gtk_gesture_long_press_get_delay_factor :: 
    Ptr GestureLongPress ->                 -- gesture : TInterface (Name {namespace = "Gtk", name = "GestureLongPress"})
    IO CDouble

-- | Returns the delay factor.
gestureLongPressGetDelayFactor ::
    (B.CallStack.HasCallStack, MonadIO m, IsGestureLongPress a) =>
    a
    -- ^ /@gesture@/: A @GtkGestureLongPress@
    -> m Double
    -- ^ __Returns:__ the delay factor
gestureLongPressGetDelayFactor gesture = liftIO $ do
    gesture' <- unsafeManagedPtrCastPtr gesture
    result <- gtk_gesture_long_press_get_delay_factor gesture'
    let result' = realToFrac result
    touchManagedPtr gesture
    return result'

#if defined(ENABLE_OVERLOADING)
data GestureLongPressGetDelayFactorMethodInfo
instance (signature ~ (m Double), MonadIO m, IsGestureLongPress a) => O.OverloadedMethod GestureLongPressGetDelayFactorMethodInfo a signature where
    overloadedMethod = gestureLongPressGetDelayFactor

instance O.OverloadedMethodInfo GestureLongPressGetDelayFactorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureLongPress.gestureLongPressGetDelayFactor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureLongPress.html#v:gestureLongPressGetDelayFactor"
        })


#endif

-- method GestureLongPress::set_delay_factor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "gesture"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GestureLongPress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkGestureLongPress`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "delay_factor"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The delay factor to apply"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_gesture_long_press_set_delay_factor" gtk_gesture_long_press_set_delay_factor :: 
    Ptr GestureLongPress ->                 -- gesture : TInterface (Name {namespace = "Gtk", name = "GestureLongPress"})
    CDouble ->                              -- delay_factor : TBasicType TDouble
    IO ()

-- | Applies the given delay factor.
-- 
-- The default long press time will be multiplied by this value.
-- Valid values are in the range [0.5..2.0].
gestureLongPressSetDelayFactor ::
    (B.CallStack.HasCallStack, MonadIO m, IsGestureLongPress a) =>
    a
    -- ^ /@gesture@/: A @GtkGestureLongPress@
    -> Double
    -- ^ /@delayFactor@/: The delay factor to apply
    -> m ()
gestureLongPressSetDelayFactor gesture delayFactor = liftIO $ do
    gesture' <- unsafeManagedPtrCastPtr gesture
    let delayFactor' = realToFrac delayFactor
    gtk_gesture_long_press_set_delay_factor gesture' delayFactor'
    touchManagedPtr gesture
    return ()

#if defined(ENABLE_OVERLOADING)
data GestureLongPressSetDelayFactorMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsGestureLongPress a) => O.OverloadedMethod GestureLongPressSetDelayFactorMethodInfo a signature where
    overloadedMethod = gestureLongPressSetDelayFactor

instance O.OverloadedMethodInfo GestureLongPressSetDelayFactorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureLongPress.gestureLongPressSetDelayFactor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureLongPress.html#v:gestureLongPressSetDelayFactor"
        })


#endif


