{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The class of a flags type holds information about its
-- possible values.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.FlagsClass
    ( 

-- * Exported types
    FlagsClass(..)                          ,
    newZeroFlagsClass                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveFlagsClassMethod                 ,
#endif



 -- * Properties


-- ** gTypeClass #attr:gTypeClass#
-- | the parent class

#if defined(ENABLE_OVERLOADING)
    flagsClass_gTypeClass                   ,
#endif
    getFlagsClassGTypeClass                 ,


-- ** mask #attr:mask#
-- | a mask covering all possible values.

#if defined(ENABLE_OVERLOADING)
    flagsClass_mask                         ,
#endif
    getFlagsClassMask                       ,
    setFlagsClassMask                       ,


-- ** nValues #attr:nValues#
-- | the number of possible values.

#if defined(ENABLE_OVERLOADING)
    flagsClass_nValues                      ,
#endif
    getFlagsClassNValues                    ,
    setFlagsClassNValues                    ,


-- ** values #attr:values#
-- | an array of t'GI.GObject.Structs.FlagsValue.FlagsValue' structs describing the
--  individual values.

    clearFlagsClassValues                   ,
#if defined(ENABLE_OVERLOADING)
    flagsClass_values                       ,
#endif
    getFlagsClassValues                     ,
    setFlagsClassValues                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GObject.Structs.FlagsValue as GObject.FlagsValue
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass

#else
import {-# SOURCE #-} qualified GI.GObject.Structs.FlagsValue as GObject.FlagsValue
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass

#endif

-- | Memory-managed wrapper type.
newtype FlagsClass = FlagsClass (SP.ManagedPtr FlagsClass)
    deriving (Eq)

instance SP.ManagedPtrNewtype FlagsClass where
    toManagedPtr (FlagsClass p) = p

instance BoxedPtr FlagsClass where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr FlagsClass)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr FlagsClass where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'FlagsClass' struct initialized to zero.
newZeroFlagsClass :: MonadIO m => m FlagsClass
newZeroFlagsClass = liftIO $ boxedPtrCalloc >>= wrapPtr FlagsClass

instance tag ~ 'AttrSet => Constructible FlagsClass tag where
    new _ attrs = do
        o <- newZeroFlagsClass
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@g_type_class@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' flagsClass #gTypeClass
-- @
getFlagsClassGTypeClass :: MonadIO m => FlagsClass -> m GObject.TypeClass.TypeClass
getFlagsClassGTypeClass s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr GObject.TypeClass.TypeClass)
    val' <- (newPtr GObject.TypeClass.TypeClass) val
    return val'

#if defined(ENABLE_OVERLOADING)
data FlagsClassGTypeClassFieldInfo
instance AttrInfo FlagsClassGTypeClassFieldInfo where
    type AttrBaseTypeConstraint FlagsClassGTypeClassFieldInfo = (~) FlagsClass
    type AttrAllowedOps FlagsClassGTypeClassFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint FlagsClassGTypeClassFieldInfo = (~) (Ptr GObject.TypeClass.TypeClass)
    type AttrTransferTypeConstraint FlagsClassGTypeClassFieldInfo = (~)(Ptr GObject.TypeClass.TypeClass)
    type AttrTransferType FlagsClassGTypeClassFieldInfo = (Ptr GObject.TypeClass.TypeClass)
    type AttrGetType FlagsClassGTypeClassFieldInfo = GObject.TypeClass.TypeClass
    type AttrLabel FlagsClassGTypeClassFieldInfo = "g_type_class"
    type AttrOrigin FlagsClassGTypeClassFieldInfo = FlagsClass
    attrGet = getFlagsClassGTypeClass
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.FlagsClass.gTypeClass"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-FlagsClass.html#g:attr:gTypeClass"
        })

flagsClass_gTypeClass :: AttrLabelProxy "gTypeClass"
flagsClass_gTypeClass = AttrLabelProxy

#endif


-- | Get the value of the “@mask@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' flagsClass #mask
-- @
getFlagsClassMask :: MonadIO m => FlagsClass -> m Word32
getFlagsClassMask s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@mask@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' flagsClass [ #mask 'Data.GI.Base.Attributes.:=' value ]
-- @
setFlagsClassMask :: MonadIO m => FlagsClass -> Word32 -> m ()
setFlagsClassMask s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data FlagsClassMaskFieldInfo
instance AttrInfo FlagsClassMaskFieldInfo where
    type AttrBaseTypeConstraint FlagsClassMaskFieldInfo = (~) FlagsClass
    type AttrAllowedOps FlagsClassMaskFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FlagsClassMaskFieldInfo = (~) Word32
    type AttrTransferTypeConstraint FlagsClassMaskFieldInfo = (~)Word32
    type AttrTransferType FlagsClassMaskFieldInfo = Word32
    type AttrGetType FlagsClassMaskFieldInfo = Word32
    type AttrLabel FlagsClassMaskFieldInfo = "mask"
    type AttrOrigin FlagsClassMaskFieldInfo = FlagsClass
    attrGet = getFlagsClassMask
    attrSet = setFlagsClassMask
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.FlagsClass.mask"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-FlagsClass.html#g:attr:mask"
        })

flagsClass_mask :: AttrLabelProxy "mask"
flagsClass_mask = AttrLabelProxy

#endif


-- | Get the value of the “@n_values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' flagsClass #nValues
-- @
getFlagsClassNValues :: MonadIO m => FlagsClass -> m Word32
getFlagsClassNValues s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Word32
    return val

-- | Set the value of the “@n_values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' flagsClass [ #nValues 'Data.GI.Base.Attributes.:=' value ]
-- @
setFlagsClassNValues :: MonadIO m => FlagsClass -> Word32 -> m ()
setFlagsClassNValues s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data FlagsClassNValuesFieldInfo
instance AttrInfo FlagsClassNValuesFieldInfo where
    type AttrBaseTypeConstraint FlagsClassNValuesFieldInfo = (~) FlagsClass
    type AttrAllowedOps FlagsClassNValuesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FlagsClassNValuesFieldInfo = (~) Word32
    type AttrTransferTypeConstraint FlagsClassNValuesFieldInfo = (~)Word32
    type AttrTransferType FlagsClassNValuesFieldInfo = Word32
    type AttrGetType FlagsClassNValuesFieldInfo = Word32
    type AttrLabel FlagsClassNValuesFieldInfo = "n_values"
    type AttrOrigin FlagsClassNValuesFieldInfo = FlagsClass
    attrGet = getFlagsClassNValues
    attrSet = setFlagsClassNValues
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.FlagsClass.nValues"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-FlagsClass.html#g:attr:nValues"
        })

flagsClass_nValues :: AttrLabelProxy "nValues"
flagsClass_nValues = AttrLabelProxy

#endif


-- | Get the value of the “@values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' flagsClass #values
-- @
getFlagsClassValues :: MonadIO m => FlagsClass -> m (Maybe GObject.FlagsValue.FlagsValue)
getFlagsClassValues s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr GObject.FlagsValue.FlagsValue)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr GObject.FlagsValue.FlagsValue) val'
        return val''
    return result

-- | Set the value of the “@values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' flagsClass [ #values 'Data.GI.Base.Attributes.:=' value ]
-- @
setFlagsClassValues :: MonadIO m => FlagsClass -> Ptr GObject.FlagsValue.FlagsValue -> m ()
setFlagsClassValues s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr GObject.FlagsValue.FlagsValue)

-- | Set the value of the “@values@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #values
-- @
clearFlagsClassValues :: MonadIO m => FlagsClass -> m ()
clearFlagsClassValues s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr GObject.FlagsValue.FlagsValue)

#if defined(ENABLE_OVERLOADING)
data FlagsClassValuesFieldInfo
instance AttrInfo FlagsClassValuesFieldInfo where
    type AttrBaseTypeConstraint FlagsClassValuesFieldInfo = (~) FlagsClass
    type AttrAllowedOps FlagsClassValuesFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint FlagsClassValuesFieldInfo = (~) (Ptr GObject.FlagsValue.FlagsValue)
    type AttrTransferTypeConstraint FlagsClassValuesFieldInfo = (~)(Ptr GObject.FlagsValue.FlagsValue)
    type AttrTransferType FlagsClassValuesFieldInfo = (Ptr GObject.FlagsValue.FlagsValue)
    type AttrGetType FlagsClassValuesFieldInfo = Maybe GObject.FlagsValue.FlagsValue
    type AttrLabel FlagsClassValuesFieldInfo = "values"
    type AttrOrigin FlagsClassValuesFieldInfo = FlagsClass
    attrGet = getFlagsClassValues
    attrSet = setFlagsClassValues
    attrConstruct = undefined
    attrClear = clearFlagsClassValues
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.FlagsClass.values"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-FlagsClass.html#g:attr:values"
        })

flagsClass_values :: AttrLabelProxy "values"
flagsClass_values = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FlagsClass
type instance O.AttributeList FlagsClass = FlagsClassAttributeList
type FlagsClassAttributeList = ('[ '("gTypeClass", FlagsClassGTypeClassFieldInfo), '("mask", FlagsClassMaskFieldInfo), '("nValues", FlagsClassNValuesFieldInfo), '("values", FlagsClassValuesFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFlagsClassMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFlagsClassMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFlagsClassMethod t FlagsClass, O.OverloadedMethod info FlagsClass p) => OL.IsLabel t (FlagsClass -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFlagsClassMethod t FlagsClass, O.OverloadedMethod info FlagsClass p, R.HasField t FlagsClass p) => R.HasField t FlagsClass p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFlagsClassMethod t FlagsClass, O.OverloadedMethodInfo info FlagsClass) => OL.IsLabel t (O.MethodProxy info FlagsClass) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


