

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Enums
    ( 

 -- * Enumerations


-- ** AxisUse #enum:AxisUse#

    AxisUse(..)                             ,


-- ** ByteOrder #enum:ByteOrder#

    ByteOrder(..)                           ,


-- ** CrossingMode #enum:CrossingMode#

    CrossingMode(..)                        ,


-- ** CursorType #enum:CursorType#

    CursorType(..)                          ,


-- ** DevicePadFeature #enum:DevicePadFeature#

    DevicePadFeature(..)                    ,


-- ** DeviceToolType #enum:DeviceToolType#

    DeviceToolType(..)                      ,


-- ** DeviceType #enum:DeviceType#

    DeviceType(..)                          ,


-- ** DragCancelReason #enum:DragCancelReason#

    DragCancelReason(..)                    ,


-- ** DragProtocol #enum:DragProtocol#

    DragProtocol(..)                        ,


-- ** EventType #enum:EventType#

    EventType(..)                           ,


-- ** FilterReturn #enum:FilterReturn#

    FilterReturn(..)                        ,


-- ** FullscreenMode #enum:FullscreenMode#

    FullscreenMode(..)                      ,


-- ** GLError #enum:GLError#

    GLError(..)                             ,
    catchGLError                            ,
    handleGLError                           ,


-- ** GrabOwnership #enum:GrabOwnership#

    GrabOwnership(..)                       ,


-- ** GrabStatus #enum:GrabStatus#

    GrabStatus(..)                          ,


-- ** Gravity #enum:Gravity#

    Gravity(..)                             ,


-- ** InputMode #enum:InputMode#

    InputMode(..)                           ,


-- ** InputSource #enum:InputSource#

    InputSource(..)                         ,


-- ** ModifierIntent #enum:ModifierIntent#

    ModifierIntent(..)                      ,


-- ** NotifyType #enum:NotifyType#

    NotifyType(..)                          ,


-- ** OwnerChange #enum:OwnerChange#

    OwnerChange(..)                         ,


-- ** PropMode #enum:PropMode#

    PropMode(..)                            ,


-- ** PropertyState #enum:PropertyState#

    PropertyState(..)                       ,


-- ** ScrollDirection #enum:ScrollDirection#

    ScrollDirection(..)                     ,


-- ** SettingAction #enum:SettingAction#

    SettingAction(..)                       ,


-- ** Status #enum:Status#

    Status(..)                              ,


-- ** SubpixelLayout #enum:SubpixelLayout#

    SubpixelLayout(..)                      ,


-- ** TouchpadGesturePhase #enum:TouchpadGesturePhase#

    TouchpadGesturePhase(..)                ,


-- ** VisibilityState #enum:VisibilityState#

    VisibilityState(..)                     ,


-- ** VisualType #enum:VisualType#

    VisualType(..)                          ,


-- ** WindowEdge #enum:WindowEdge#

    WindowEdge(..)                          ,


-- ** WindowType #enum:WindowType#

    WindowType(..)                          ,


-- ** WindowTypeHint #enum:WindowTypeHint#

    WindowTypeHint(..)                      ,


-- ** WindowWindowClass #enum:WindowWindowClass#

    WindowWindowClass(..)                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum WindowWindowClass
-- | /@gDKINPUTOUTPUT@/ windows are the standard kind of window you might expect.
-- Such windows receive events and are also displayed on screen.
-- /@gDKINPUTONLY@/ windows are invisible; they are usually placed above other
-- windows in order to trap or filter the events. You can’t draw on
-- /@gDKINPUTONLY@/ windows.
data WindowWindowClass = 
      WindowWindowClassInputOutput
    -- ^ window for graphics and events
    | WindowWindowClassInputOnly
    -- ^ window for events only
    | AnotherWindowWindowClass Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WindowWindowClass where
    fromEnum WindowWindowClassInputOutput = 0
    fromEnum WindowWindowClassInputOnly = 1
    fromEnum (AnotherWindowWindowClass k) = k

    toEnum 0 = WindowWindowClassInputOutput
    toEnum 1 = WindowWindowClassInputOnly
    toEnum k = AnotherWindowWindowClass k

instance P.Ord WindowWindowClass where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WindowWindowClass = '[]
instance O.HasParentTypes WindowWindowClass

foreign import ccall "gdk_window_window_class_get_type" c_gdk_window_window_class_get_type :: 
    IO GType

instance B.Types.TypedObject WindowWindowClass where
    glibType = c_gdk_window_window_class_get_type

instance B.Types.BoxedEnum WindowWindowClass

-- Enum WindowTypeHint
-- | These are hints for the window manager that indicate what type of function
-- the window has. The window manager can use this when determining decoration
-- and behaviour of the window. The hint must be set before mapping the window.
-- 
-- See the <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints>
-- specification for more details about window types.
data WindowTypeHint = 
      WindowTypeHintNormal
    -- ^ Normal toplevel window.
    | WindowTypeHintDialog
    -- ^ Dialog window.
    | WindowTypeHintMenu
    -- ^ Window used to implement a menu; GTK+ uses
    --  this hint only for torn-off menus, see @/GtkTearoffMenuItem/@.
    | WindowTypeHintToolbar
    -- ^ Window used to implement toolbars.
    | WindowTypeHintSplashscreen
    -- ^ Window used to display a splash
    --  screen during application startup.
    | WindowTypeHintUtility
    -- ^ Utility windows which are not detached
    --  toolbars or dialogs.
    | WindowTypeHintDock
    -- ^ Used for creating dock or panel windows.
    | WindowTypeHintDesktop
    -- ^ Used for creating the desktop background
    --  window.
    | WindowTypeHintDropdownMenu
    -- ^ A menu that belongs to a menubar.
    | WindowTypeHintPopupMenu
    -- ^ A menu that does not belong to a menubar,
    --  e.g. a context menu.
    | WindowTypeHintTooltip
    -- ^ A tooltip.
    | WindowTypeHintNotification
    -- ^ A notification - typically a “bubble”
    --  that belongs to a status icon.
    | WindowTypeHintCombo
    -- ^ A popup from a combo box.
    | WindowTypeHintDnd
    -- ^ A window that is used to implement a DND cursor.
    | AnotherWindowTypeHint Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WindowTypeHint where
    fromEnum WindowTypeHintNormal = 0
    fromEnum WindowTypeHintDialog = 1
    fromEnum WindowTypeHintMenu = 2
    fromEnum WindowTypeHintToolbar = 3
    fromEnum WindowTypeHintSplashscreen = 4
    fromEnum WindowTypeHintUtility = 5
    fromEnum WindowTypeHintDock = 6
    fromEnum WindowTypeHintDesktop = 7
    fromEnum WindowTypeHintDropdownMenu = 8
    fromEnum WindowTypeHintPopupMenu = 9
    fromEnum WindowTypeHintTooltip = 10
    fromEnum WindowTypeHintNotification = 11
    fromEnum WindowTypeHintCombo = 12
    fromEnum WindowTypeHintDnd = 13
    fromEnum (AnotherWindowTypeHint k) = k

    toEnum 0 = WindowTypeHintNormal
    toEnum 1 = WindowTypeHintDialog
    toEnum 2 = WindowTypeHintMenu
    toEnum 3 = WindowTypeHintToolbar
    toEnum 4 = WindowTypeHintSplashscreen
    toEnum 5 = WindowTypeHintUtility
    toEnum 6 = WindowTypeHintDock
    toEnum 7 = WindowTypeHintDesktop
    toEnum 8 = WindowTypeHintDropdownMenu
    toEnum 9 = WindowTypeHintPopupMenu
    toEnum 10 = WindowTypeHintTooltip
    toEnum 11 = WindowTypeHintNotification
    toEnum 12 = WindowTypeHintCombo
    toEnum 13 = WindowTypeHintDnd
    toEnum k = AnotherWindowTypeHint k

instance P.Ord WindowTypeHint where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WindowTypeHint = '[]
instance O.HasParentTypes WindowTypeHint

foreign import ccall "gdk_window_type_hint_get_type" c_gdk_window_type_hint_get_type :: 
    IO GType

instance B.Types.TypedObject WindowTypeHint where
    glibType = c_gdk_window_type_hint_get_type

instance B.Types.BoxedEnum WindowTypeHint

-- Enum WindowType
-- | Describes the kind of window.
data WindowType = 
      WindowTypeRoot
    -- ^ root window; this window has no parent, covers the entire
    --  screen, and is created by the window system
    | WindowTypeToplevel
    -- ^ toplevel window (used to implement @/GtkWindow/@)
    | WindowTypeChild
    -- ^ child window (used to implement e.g. @/GtkEntry/@)
    | WindowTypeTemp
    -- ^ override redirect temporary window (used to implement
    --  @/GtkMenu/@)
    | WindowTypeForeign
    -- ^ foreign window (see @/gdk_window_foreign_new()/@)
    | WindowTypeOffscreen
    -- ^ offscreen window (see
    --  [Offscreen Windows][OFFSCREEN-WINDOWS]). Since 2.18
    | WindowTypeSubsurface
    -- ^ subsurface-based window; This window is visually
    --  tied to a toplevel, and is moved\/stacked with it. Currently this window
    --  type is only implemented in Wayland. Since 3.14
    | AnotherWindowType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WindowType where
    fromEnum WindowTypeRoot = 0
    fromEnum WindowTypeToplevel = 1
    fromEnum WindowTypeChild = 2
    fromEnum WindowTypeTemp = 3
    fromEnum WindowTypeForeign = 4
    fromEnum WindowTypeOffscreen = 5
    fromEnum WindowTypeSubsurface = 6
    fromEnum (AnotherWindowType k) = k

    toEnum 0 = WindowTypeRoot
    toEnum 1 = WindowTypeToplevel
    toEnum 2 = WindowTypeChild
    toEnum 3 = WindowTypeTemp
    toEnum 4 = WindowTypeForeign
    toEnum 5 = WindowTypeOffscreen
    toEnum 6 = WindowTypeSubsurface
    toEnum k = AnotherWindowType k

instance P.Ord WindowType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WindowType = '[]
instance O.HasParentTypes WindowType

foreign import ccall "gdk_window_type_get_type" c_gdk_window_type_get_type :: 
    IO GType

instance B.Types.TypedObject WindowType where
    glibType = c_gdk_window_type_get_type

instance B.Types.BoxedEnum WindowType

-- Enum WindowEdge
-- | Determines a window edge or corner.
data WindowEdge = 
      WindowEdgeNorthWest
    -- ^ the top left corner.
    | WindowEdgeNorth
    -- ^ the top edge.
    | WindowEdgeNorthEast
    -- ^ the top right corner.
    | WindowEdgeWest
    -- ^ the left edge.
    | WindowEdgeEast
    -- ^ the right edge.
    | WindowEdgeSouthWest
    -- ^ the lower left corner.
    | WindowEdgeSouth
    -- ^ the lower edge.
    | WindowEdgeSouthEast
    -- ^ the lower right corner.
    | AnotherWindowEdge Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WindowEdge where
    fromEnum WindowEdgeNorthWest = 0
    fromEnum WindowEdgeNorth = 1
    fromEnum WindowEdgeNorthEast = 2
    fromEnum WindowEdgeWest = 3
    fromEnum WindowEdgeEast = 4
    fromEnum WindowEdgeSouthWest = 5
    fromEnum WindowEdgeSouth = 6
    fromEnum WindowEdgeSouthEast = 7
    fromEnum (AnotherWindowEdge k) = k

    toEnum 0 = WindowEdgeNorthWest
    toEnum 1 = WindowEdgeNorth
    toEnum 2 = WindowEdgeNorthEast
    toEnum 3 = WindowEdgeWest
    toEnum 4 = WindowEdgeEast
    toEnum 5 = WindowEdgeSouthWest
    toEnum 6 = WindowEdgeSouth
    toEnum 7 = WindowEdgeSouthEast
    toEnum k = AnotherWindowEdge k

instance P.Ord WindowEdge where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WindowEdge = '[]
instance O.HasParentTypes WindowEdge

foreign import ccall "gdk_window_edge_get_type" c_gdk_window_edge_get_type :: 
    IO GType

instance B.Types.TypedObject WindowEdge where
    glibType = c_gdk_window_edge_get_type

instance B.Types.BoxedEnum WindowEdge

-- Enum VisualType
-- | A set of values that describe the manner in which the pixel values
-- for a visual are converted into RGB values for display.
data VisualType = 
      VisualTypeStaticGray
    -- ^ Each pixel value indexes a grayscale value
    --     directly.
    | VisualTypeGrayscale
    -- ^ Each pixel is an index into a color map that
    --     maps pixel values into grayscale values. The color map can be
    --     changed by an application.
    | VisualTypeStaticColor
    -- ^ Each pixel value is an index into a predefined,
    --     unmodifiable color map that maps pixel values into RGB values.
    | VisualTypePseudoColor
    -- ^ Each pixel is an index into a color map that
    --     maps pixel values into rgb values. The color map can be changed by
    --     an application.
    | VisualTypeTrueColor
    -- ^ Each pixel value directly contains red, green,
    --     and blue components. Use 'GI.Gdk.Objects.Visual.visualGetRedPixelDetails', etc,
    --     to obtain information about how the components are assembled into
    --     a pixel value.
    | VisualTypeDirectColor
    -- ^ Each pixel value contains red, green, and blue
    --     components as for 'GI.Gdk.Enums.VisualTypeTrueColor', but the components are
    --     mapped via a color table into the final output table instead of
    --     being converted directly.
    | AnotherVisualType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum VisualType where
    fromEnum VisualTypeStaticGray = 0
    fromEnum VisualTypeGrayscale = 1
    fromEnum VisualTypeStaticColor = 2
    fromEnum VisualTypePseudoColor = 3
    fromEnum VisualTypeTrueColor = 4
    fromEnum VisualTypeDirectColor = 5
    fromEnum (AnotherVisualType k) = k

    toEnum 0 = VisualTypeStaticGray
    toEnum 1 = VisualTypeGrayscale
    toEnum 2 = VisualTypeStaticColor
    toEnum 3 = VisualTypePseudoColor
    toEnum 4 = VisualTypeTrueColor
    toEnum 5 = VisualTypeDirectColor
    toEnum k = AnotherVisualType k

instance P.Ord VisualType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes VisualType = '[]
instance O.HasParentTypes VisualType

foreign import ccall "gdk_visual_type_get_type" c_gdk_visual_type_get_type :: 
    IO GType

instance B.Types.TypedObject VisualType where
    glibType = c_gdk_visual_type_get_type

instance B.Types.BoxedEnum VisualType

-- Enum VisibilityState
-- | Specifies the visiblity status of a window for a t'GI.Gdk.Structs.EventVisibility.EventVisibility'.
data VisibilityState = 
      VisibilityStateUnobscured
    -- ^ the window is completely visible.
    | VisibilityStatePartial
    -- ^ the window is partially visible.
    | VisibilityStateFullyObscured
    -- ^ the window is not visible at all.
    | AnotherVisibilityState Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum VisibilityState where
    fromEnum VisibilityStateUnobscured = 0
    fromEnum VisibilityStatePartial = 1
    fromEnum VisibilityStateFullyObscured = 2
    fromEnum (AnotherVisibilityState k) = k

    toEnum 0 = VisibilityStateUnobscured
    toEnum 1 = VisibilityStatePartial
    toEnum 2 = VisibilityStateFullyObscured
    toEnum k = AnotherVisibilityState k

instance P.Ord VisibilityState where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes VisibilityState = '[]
instance O.HasParentTypes VisibilityState

foreign import ccall "gdk_visibility_state_get_type" c_gdk_visibility_state_get_type :: 
    IO GType

instance B.Types.TypedObject VisibilityState where
    glibType = c_gdk_visibility_state_get_type

instance B.Types.BoxedEnum VisibilityState

-- Enum TouchpadGesturePhase
-- | Specifies the current state of a touchpad gesture. All gestures are
-- guaranteed to begin with an event with phase 'GI.Gdk.Enums.TouchpadGesturePhaseBegin',
-- followed by 0 or several events with phase 'GI.Gdk.Enums.TouchpadGesturePhaseUpdate'.
-- 
-- A finished gesture may have 2 possible outcomes, an event with phase
-- 'GI.Gdk.Enums.TouchpadGesturePhaseEnd' will be emitted when the gesture is
-- considered successful, this should be used as the hint to perform any
-- permanent changes.
-- 
-- Cancelled gestures may be so for a variety of reasons, due to hardware
-- or the compositor, or due to the gesture recognition layers hinting the
-- gesture did not finish resolutely (eg. a 3rd finger being added during
-- a pinch gesture). In these cases, the last event will report the phase
-- 'GI.Gdk.Enums.TouchpadGesturePhaseCancel', this should be used as a hint
-- to undo any visible\/permanent changes that were done throughout the
-- progress of the gesture.
-- 
-- See also t'GI.Gdk.Structs.EventTouchpadSwipe.EventTouchpadSwipe' and t'GI.Gdk.Structs.EventTouchpadPinch.EventTouchpadPinch'.
data TouchpadGesturePhase = 
      TouchpadGesturePhaseBegin
    -- ^ The gesture has begun.
    | TouchpadGesturePhaseUpdate
    -- ^ The gesture has been updated.
    | TouchpadGesturePhaseEnd
    -- ^ The gesture was finished, changes
    --   should be permanently applied.
    | TouchpadGesturePhaseCancel
    -- ^ The gesture was cancelled, all
    --   changes should be undone.
    | AnotherTouchpadGesturePhase Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TouchpadGesturePhase where
    fromEnum TouchpadGesturePhaseBegin = 0
    fromEnum TouchpadGesturePhaseUpdate = 1
    fromEnum TouchpadGesturePhaseEnd = 2
    fromEnum TouchpadGesturePhaseCancel = 3
    fromEnum (AnotherTouchpadGesturePhase k) = k

    toEnum 0 = TouchpadGesturePhaseBegin
    toEnum 1 = TouchpadGesturePhaseUpdate
    toEnum 2 = TouchpadGesturePhaseEnd
    toEnum 3 = TouchpadGesturePhaseCancel
    toEnum k = AnotherTouchpadGesturePhase k

instance P.Ord TouchpadGesturePhase where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TouchpadGesturePhase = '[]
instance O.HasParentTypes TouchpadGesturePhase

foreign import ccall "gdk_touchpad_gesture_phase_get_type" c_gdk_touchpad_gesture_phase_get_type :: 
    IO GType

instance B.Types.TypedObject TouchpadGesturePhase where
    glibType = c_gdk_touchpad_gesture_phase_get_type

instance B.Types.BoxedEnum TouchpadGesturePhase

-- Enum SubpixelLayout
-- | This enumeration describes how the red, green and blue components
-- of physical pixels on an output device are laid out.
-- 
-- /Since: 3.22/
data SubpixelLayout = 
      SubpixelLayoutUnknown
    -- ^ The layout is not known
    | SubpixelLayoutNone
    -- ^ Not organized in this way
    | SubpixelLayoutHorizontalRgb
    -- ^ The layout is horizontal, the order is RGB
    | SubpixelLayoutHorizontalBgr
    -- ^ The layout is horizontal, the order is BGR
    | SubpixelLayoutVerticalRgb
    -- ^ The layout is vertical, the order is RGB
    | SubpixelLayoutVerticalBgr
    -- ^ The layout is vertical, the order is BGR
    | AnotherSubpixelLayout Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SubpixelLayout where
    fromEnum SubpixelLayoutUnknown = 0
    fromEnum SubpixelLayoutNone = 1
    fromEnum SubpixelLayoutHorizontalRgb = 2
    fromEnum SubpixelLayoutHorizontalBgr = 3
    fromEnum SubpixelLayoutVerticalRgb = 4
    fromEnum SubpixelLayoutVerticalBgr = 5
    fromEnum (AnotherSubpixelLayout k) = k

    toEnum 0 = SubpixelLayoutUnknown
    toEnum 1 = SubpixelLayoutNone
    toEnum 2 = SubpixelLayoutHorizontalRgb
    toEnum 3 = SubpixelLayoutHorizontalBgr
    toEnum 4 = SubpixelLayoutVerticalRgb
    toEnum 5 = SubpixelLayoutVerticalBgr
    toEnum k = AnotherSubpixelLayout k

instance P.Ord SubpixelLayout where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SubpixelLayout = '[]
instance O.HasParentTypes SubpixelLayout

foreign import ccall "gdk_subpixel_layout_get_type" c_gdk_subpixel_layout_get_type :: 
    IO GType

instance B.Types.TypedObject SubpixelLayout where
    glibType = c_gdk_subpixel_layout_get_type

instance B.Types.BoxedEnum SubpixelLayout

-- Enum Status
-- | /No description available in the introspection data./
data Status = 
      StatusOk
    -- ^ /No description available in the introspection data./
    | StatusError
    -- ^ /No description available in the introspection data./
    | StatusErrorParam
    -- ^ /No description available in the introspection data./
    | StatusErrorFile
    -- ^ /No description available in the introspection data./
    | StatusErrorMem
    -- ^ /No description available in the introspection data./
    | AnotherStatus Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Status where
    fromEnum StatusOk = 0
    fromEnum StatusError = -1
    fromEnum StatusErrorParam = -2
    fromEnum StatusErrorFile = -3
    fromEnum StatusErrorMem = -4
    fromEnum (AnotherStatus k) = k

    toEnum 0 = StatusOk
    toEnum -1 = StatusError
    toEnum -2 = StatusErrorParam
    toEnum -3 = StatusErrorFile
    toEnum -4 = StatusErrorMem
    toEnum k = AnotherStatus k

instance P.Ord Status where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Status = '[]
instance O.HasParentTypes Status

foreign import ccall "gdk_status_get_type" c_gdk_status_get_type :: 
    IO GType

instance B.Types.TypedObject Status where
    glibType = c_gdk_status_get_type

instance B.Types.BoxedEnum Status

-- Enum SettingAction
-- | Specifies the kind of modification applied to a setting in a
-- t'GI.Gdk.Structs.EventSetting.EventSetting'.
data SettingAction = 
      SettingActionNew
    -- ^ a setting was added.
    | SettingActionChanged
    -- ^ a setting was changed.
    | SettingActionDeleted
    -- ^ a setting was deleted.
    | AnotherSettingAction Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SettingAction where
    fromEnum SettingActionNew = 0
    fromEnum SettingActionChanged = 1
    fromEnum SettingActionDeleted = 2
    fromEnum (AnotherSettingAction k) = k

    toEnum 0 = SettingActionNew
    toEnum 1 = SettingActionChanged
    toEnum 2 = SettingActionDeleted
    toEnum k = AnotherSettingAction k

instance P.Ord SettingAction where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SettingAction = '[]
instance O.HasParentTypes SettingAction

foreign import ccall "gdk_setting_action_get_type" c_gdk_setting_action_get_type :: 
    IO GType

instance B.Types.TypedObject SettingAction where
    glibType = c_gdk_setting_action_get_type

instance B.Types.BoxedEnum SettingAction

-- Enum ScrollDirection
-- | Specifies the direction for t'GI.Gdk.Structs.EventScroll.EventScroll'.
data ScrollDirection = 
      ScrollDirectionUp
    -- ^ the window is scrolled up.
    | ScrollDirectionDown
    -- ^ the window is scrolled down.
    | ScrollDirectionLeft
    -- ^ the window is scrolled to the left.
    | ScrollDirectionRight
    -- ^ the window is scrolled to the right.
    | ScrollDirectionSmooth
    -- ^ the scrolling is determined by the delta values
    --   in t'GI.Gdk.Structs.EventScroll.EventScroll'. See 'GI.Gdk.Unions.Event.eventGetScrollDeltas'. Since: 3.4
    | AnotherScrollDirection Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ScrollDirection where
    fromEnum ScrollDirectionUp = 0
    fromEnum ScrollDirectionDown = 1
    fromEnum ScrollDirectionLeft = 2
    fromEnum ScrollDirectionRight = 3
    fromEnum ScrollDirectionSmooth = 4
    fromEnum (AnotherScrollDirection k) = k

    toEnum 0 = ScrollDirectionUp
    toEnum 1 = ScrollDirectionDown
    toEnum 2 = ScrollDirectionLeft
    toEnum 3 = ScrollDirectionRight
    toEnum 4 = ScrollDirectionSmooth
    toEnum k = AnotherScrollDirection k

instance P.Ord ScrollDirection where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ScrollDirection = '[]
instance O.HasParentTypes ScrollDirection

foreign import ccall "gdk_scroll_direction_get_type" c_gdk_scroll_direction_get_type :: 
    IO GType

instance B.Types.TypedObject ScrollDirection where
    glibType = c_gdk_scroll_direction_get_type

instance B.Types.BoxedEnum ScrollDirection

-- Enum PropertyState
-- | Specifies the type of a property change for a t'GI.Gdk.Structs.EventProperty.EventProperty'.
data PropertyState = 
      PropertyStateNewValue
    -- ^ the property value was changed.
    | PropertyStateDelete
    -- ^ the property was deleted.
    | AnotherPropertyState Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PropertyState where
    fromEnum PropertyStateNewValue = 0
    fromEnum PropertyStateDelete = 1
    fromEnum (AnotherPropertyState k) = k

    toEnum 0 = PropertyStateNewValue
    toEnum 1 = PropertyStateDelete
    toEnum k = AnotherPropertyState k

instance P.Ord PropertyState where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PropertyState = '[]
instance O.HasParentTypes PropertyState

foreign import ccall "gdk_property_state_get_type" c_gdk_property_state_get_type :: 
    IO GType

instance B.Types.TypedObject PropertyState where
    glibType = c_gdk_property_state_get_type

instance B.Types.BoxedEnum PropertyState

-- Enum PropMode
-- | Describes how existing data is combined with new data when
-- using @/gdk_property_change()/@.
data PropMode = 
      PropModeReplace
    -- ^ the new data replaces the existing data.
    | PropModePrepend
    -- ^ the new data is prepended to the existing data.
    | PropModeAppend
    -- ^ the new data is appended to the existing data.
    | AnotherPropMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PropMode where
    fromEnum PropModeReplace = 0
    fromEnum PropModePrepend = 1
    fromEnum PropModeAppend = 2
    fromEnum (AnotherPropMode k) = k

    toEnum 0 = PropModeReplace
    toEnum 1 = PropModePrepend
    toEnum 2 = PropModeAppend
    toEnum k = AnotherPropMode k

instance P.Ord PropMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PropMode = '[]
instance O.HasParentTypes PropMode

foreign import ccall "gdk_prop_mode_get_type" c_gdk_prop_mode_get_type :: 
    IO GType

instance B.Types.TypedObject PropMode where
    glibType = c_gdk_prop_mode_get_type

instance B.Types.BoxedEnum PropMode

-- Enum OwnerChange
-- | Specifies why a selection ownership was changed.
data OwnerChange = 
      OwnerChangeNewOwner
    -- ^ some other app claimed the ownership
    | OwnerChangeDestroy
    -- ^ the window was destroyed
    | OwnerChangeClose
    -- ^ the client was closed
    | AnotherOwnerChange Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OwnerChange where
    fromEnum OwnerChangeNewOwner = 0
    fromEnum OwnerChangeDestroy = 1
    fromEnum OwnerChangeClose = 2
    fromEnum (AnotherOwnerChange k) = k

    toEnum 0 = OwnerChangeNewOwner
    toEnum 1 = OwnerChangeDestroy
    toEnum 2 = OwnerChangeClose
    toEnum k = AnotherOwnerChange k

instance P.Ord OwnerChange where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OwnerChange = '[]
instance O.HasParentTypes OwnerChange

foreign import ccall "gdk_owner_change_get_type" c_gdk_owner_change_get_type :: 
    IO GType

instance B.Types.TypedObject OwnerChange where
    glibType = c_gdk_owner_change_get_type

instance B.Types.BoxedEnum OwnerChange

-- Enum NotifyType
-- | Specifies the kind of crossing for t'GI.Gdk.Structs.EventCrossing.EventCrossing'.
-- 
-- See the X11 protocol specification of LeaveNotify for
-- full details of crossing event generation.
data NotifyType = 
      NotifyTypeAncestor
    -- ^ the window is entered from an ancestor or
    --   left towards an ancestor.
    | NotifyTypeVirtual
    -- ^ the pointer moves between an ancestor and an
    --   inferior of the window.
    | NotifyTypeInferior
    -- ^ the window is entered from an inferior or
    --   left towards an inferior.
    | NotifyTypeNonlinear
    -- ^ the window is entered from or left towards
    --   a window which is neither an ancestor nor an inferior.
    | NotifyTypeNonlinearVirtual
    -- ^ the pointer moves between two windows
    --   which are not ancestors of each other and the window is part of
    --   the ancestor chain between one of these windows and their least
    --   common ancestor.
    | NotifyTypeUnknown
    -- ^ an unknown type of enter\/leave event occurred.
    | AnotherNotifyType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum NotifyType where
    fromEnum NotifyTypeAncestor = 0
    fromEnum NotifyTypeVirtual = 1
    fromEnum NotifyTypeInferior = 2
    fromEnum NotifyTypeNonlinear = 3
    fromEnum NotifyTypeNonlinearVirtual = 4
    fromEnum NotifyTypeUnknown = 5
    fromEnum (AnotherNotifyType k) = k

    toEnum 0 = NotifyTypeAncestor
    toEnum 1 = NotifyTypeVirtual
    toEnum 2 = NotifyTypeInferior
    toEnum 3 = NotifyTypeNonlinear
    toEnum 4 = NotifyTypeNonlinearVirtual
    toEnum 5 = NotifyTypeUnknown
    toEnum k = AnotherNotifyType k

instance P.Ord NotifyType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes NotifyType = '[]
instance O.HasParentTypes NotifyType

foreign import ccall "gdk_notify_type_get_type" c_gdk_notify_type_get_type :: 
    IO GType

instance B.Types.TypedObject NotifyType where
    glibType = c_gdk_notify_type_get_type

instance B.Types.BoxedEnum NotifyType

-- Enum ModifierIntent
-- | This enum is used with 'GI.Gdk.Objects.Keymap.keymapGetModifierMask'
-- in order to determine what modifiers the
-- currently used windowing system backend uses for particular
-- purposes. For example, on X11\/Windows, the Control key is used for
-- invoking menu shortcuts (accelerators), whereas on Apple computers
-- it’s the Command key (which correspond to 'GI.Gdk.Flags.ModifierTypeControlMask' and
-- 'GI.Gdk.Flags.ModifierTypeMod2Mask', respectively).
-- 
-- /Since: 3.4/
data ModifierIntent = 
      ModifierIntentPrimaryAccelerator
    -- ^ the primary modifier used to invoke
    --  menu accelerators.
    | ModifierIntentContextMenu
    -- ^ the modifier used to invoke context menus.
    --  Note that mouse button 3 always triggers context menus. When this modifier
    --  is not 0, it additionally triggers context menus when used with mouse button 1.
    | ModifierIntentExtendSelection
    -- ^ the modifier used to extend selections
    --  using @modifier@-click or @modifier@-cursor-key
    | ModifierIntentModifySelection
    -- ^ the modifier used to modify selections,
    --  which in most cases means toggling the clicked item into or out of the selection.
    | ModifierIntentNoTextInput
    -- ^ when any of these modifiers is pressed, the
    --  key event cannot produce a symbol directly. This is meant to be used for
    --  input methods, and for use cases like typeahead search.
    | ModifierIntentShiftGroup
    -- ^ the modifier that switches between keyboard
    --  groups (AltGr on X11\/Windows and Option\/Alt on OS X).
    | ModifierIntentDefaultModMask
    -- ^ The set of modifier masks accepted
    -- as modifiers in accelerators. Needed because Command is mapped to MOD2 on
    -- OSX, which is widely used, but on X11 MOD2 is NumLock and using that for a
    -- mod key is problematic at best.
    -- Ref: https:\/\/bugzilla.gnome.org\/show_bug.cgi?id=736125.
    | AnotherModifierIntent Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ModifierIntent where
    fromEnum ModifierIntentPrimaryAccelerator = 0
    fromEnum ModifierIntentContextMenu = 1
    fromEnum ModifierIntentExtendSelection = 2
    fromEnum ModifierIntentModifySelection = 3
    fromEnum ModifierIntentNoTextInput = 4
    fromEnum ModifierIntentShiftGroup = 5
    fromEnum ModifierIntentDefaultModMask = 6
    fromEnum (AnotherModifierIntent k) = k

    toEnum 0 = ModifierIntentPrimaryAccelerator
    toEnum 1 = ModifierIntentContextMenu
    toEnum 2 = ModifierIntentExtendSelection
    toEnum 3 = ModifierIntentModifySelection
    toEnum 4 = ModifierIntentNoTextInput
    toEnum 5 = ModifierIntentShiftGroup
    toEnum 6 = ModifierIntentDefaultModMask
    toEnum k = AnotherModifierIntent k

instance P.Ord ModifierIntent where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ModifierIntent = '[]
instance O.HasParentTypes ModifierIntent

foreign import ccall "gdk_modifier_intent_get_type" c_gdk_modifier_intent_get_type :: 
    IO GType

instance B.Types.TypedObject ModifierIntent where
    glibType = c_gdk_modifier_intent_get_type

instance B.Types.BoxedEnum ModifierIntent

-- Enum InputSource
-- | An enumeration describing the type of an input device in general terms.
data InputSource = 
      InputSourceMouse
    -- ^ the device is a mouse. (This will be reported for the core
    --                    pointer, even if it is something else, such as a trackball.)
    | InputSourcePen
    -- ^ the device is a stylus of a graphics tablet or similar device.
    | InputSourceEraser
    -- ^ the device is an eraser. Typically, this would be the other end
    --                     of a stylus on a graphics tablet.
    | InputSourceCursor
    -- ^ the device is a graphics tablet “puck” or similar device.
    | InputSourceKeyboard
    -- ^ the device is a keyboard.
    | InputSourceTouchscreen
    -- ^ the device is a direct-input touch device, such
    --     as a touchscreen or tablet. This device type has been added in 3.4.
    | InputSourceTouchpad
    -- ^ the device is an indirect touch device, such
    --     as a touchpad. This device type has been added in 3.4.
    | InputSourceTrackpoint
    -- ^ the device is a trackpoint. This device type has been
    --     added in 3.22
    | InputSourceTabletPad
    -- ^ the device is a \"pad\", a collection of buttons,
    --     rings and strips found in drawing tablets. This device type has been
    --     added in 3.22.
    | AnotherInputSource Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum InputSource where
    fromEnum InputSourceMouse = 0
    fromEnum InputSourcePen = 1
    fromEnum InputSourceEraser = 2
    fromEnum InputSourceCursor = 3
    fromEnum InputSourceKeyboard = 4
    fromEnum InputSourceTouchscreen = 5
    fromEnum InputSourceTouchpad = 6
    fromEnum InputSourceTrackpoint = 7
    fromEnum InputSourceTabletPad = 8
    fromEnum (AnotherInputSource k) = k

    toEnum 0 = InputSourceMouse
    toEnum 1 = InputSourcePen
    toEnum 2 = InputSourceEraser
    toEnum 3 = InputSourceCursor
    toEnum 4 = InputSourceKeyboard
    toEnum 5 = InputSourceTouchscreen
    toEnum 6 = InputSourceTouchpad
    toEnum 7 = InputSourceTrackpoint
    toEnum 8 = InputSourceTabletPad
    toEnum k = AnotherInputSource k

instance P.Ord InputSource where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes InputSource = '[]
instance O.HasParentTypes InputSource

foreign import ccall "gdk_input_source_get_type" c_gdk_input_source_get_type :: 
    IO GType

instance B.Types.TypedObject InputSource where
    glibType = c_gdk_input_source_get_type

instance B.Types.BoxedEnum InputSource

-- Enum InputMode
-- | An enumeration that describes the mode of an input device.
data InputMode = 
      InputModeDisabled
    -- ^ the device is disabled and will not report any events.
    | InputModeScreen
    -- ^ the device is enabled. The device’s coordinate space
    --                   maps to the entire screen.
    | InputModeWindow
    -- ^ the device is enabled. The device’s coordinate space
    --                   is mapped to a single window. The manner in which this window
    --                   is chosen is undefined, but it will typically be the same
    --                   way in which the focus window for key events is determined.
    | AnotherInputMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum InputMode where
    fromEnum InputModeDisabled = 0
    fromEnum InputModeScreen = 1
    fromEnum InputModeWindow = 2
    fromEnum (AnotherInputMode k) = k

    toEnum 0 = InputModeDisabled
    toEnum 1 = InputModeScreen
    toEnum 2 = InputModeWindow
    toEnum k = AnotherInputMode k

instance P.Ord InputMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes InputMode = '[]
instance O.HasParentTypes InputMode

foreign import ccall "gdk_input_mode_get_type" c_gdk_input_mode_get_type :: 
    IO GType

instance B.Types.TypedObject InputMode where
    glibType = c_gdk_input_mode_get_type

instance B.Types.BoxedEnum InputMode

-- Enum Gravity
-- | Defines the reference point of a window and the meaning of coordinates
-- passed to @/gtk_window_move()/@. See @/gtk_window_move()/@ and the \"implementation
-- notes\" section of the
-- <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints>
-- specification for more details.
data Gravity = 
      GravityNorthWest
    -- ^ the reference point is at the top left corner.
    | GravityNorth
    -- ^ the reference point is in the middle of the top edge.
    | GravityNorthEast
    -- ^ the reference point is at the top right corner.
    | GravityWest
    -- ^ the reference point is at the middle of the left edge.
    | GravityCenter
    -- ^ the reference point is at the center of the window.
    | GravityEast
    -- ^ the reference point is at the middle of the right edge.
    | GravitySouthWest
    -- ^ the reference point is at the lower left corner.
    | GravitySouth
    -- ^ the reference point is at the middle of the lower edge.
    | GravitySouthEast
    -- ^ the reference point is at the lower right corner.
    | GravityStatic
    -- ^ the reference point is at the top left corner of the
    --  window itself, ignoring window manager decorations.
    | AnotherGravity Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Gravity where
    fromEnum GravityNorthWest = 1
    fromEnum GravityNorth = 2
    fromEnum GravityNorthEast = 3
    fromEnum GravityWest = 4
    fromEnum GravityCenter = 5
    fromEnum GravityEast = 6
    fromEnum GravitySouthWest = 7
    fromEnum GravitySouth = 8
    fromEnum GravitySouthEast = 9
    fromEnum GravityStatic = 10
    fromEnum (AnotherGravity k) = k

    toEnum 1 = GravityNorthWest
    toEnum 2 = GravityNorth
    toEnum 3 = GravityNorthEast
    toEnum 4 = GravityWest
    toEnum 5 = GravityCenter
    toEnum 6 = GravityEast
    toEnum 7 = GravitySouthWest
    toEnum 8 = GravitySouth
    toEnum 9 = GravitySouthEast
    toEnum 10 = GravityStatic
    toEnum k = AnotherGravity k

instance P.Ord Gravity where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Gravity = '[]
instance O.HasParentTypes Gravity

foreign import ccall "gdk_gravity_get_type" c_gdk_gravity_get_type :: 
    IO GType

instance B.Types.TypedObject Gravity where
    glibType = c_gdk_gravity_get_type

instance B.Types.BoxedEnum Gravity

-- Enum GrabStatus
-- | Returned by 'GI.Gdk.Objects.Device.deviceGrab', 'GI.Gdk.Functions.pointerGrab' and 'GI.Gdk.Functions.keyboardGrab' to
-- indicate success or the reason for the failure of the grab attempt.
data GrabStatus = 
      GrabStatusSuccess
    -- ^ the resource was successfully grabbed.
    | GrabStatusAlreadyGrabbed
    -- ^ the resource is actively grabbed by another client.
    | GrabStatusInvalidTime
    -- ^ the resource was grabbed more recently than the
    --  specified time.
    | GrabStatusNotViewable
    -- ^ the grab window or the /@confineTo@/ window are not
    --  viewable.
    | GrabStatusFrozen
    -- ^ the resource is frozen by an active grab of another client.
    | GrabStatusFailed
    -- ^ the grab failed for some other reason. Since 3.16
    | AnotherGrabStatus Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum GrabStatus where
    fromEnum GrabStatusSuccess = 0
    fromEnum GrabStatusAlreadyGrabbed = 1
    fromEnum GrabStatusInvalidTime = 2
    fromEnum GrabStatusNotViewable = 3
    fromEnum GrabStatusFrozen = 4
    fromEnum GrabStatusFailed = 5
    fromEnum (AnotherGrabStatus k) = k

    toEnum 0 = GrabStatusSuccess
    toEnum 1 = GrabStatusAlreadyGrabbed
    toEnum 2 = GrabStatusInvalidTime
    toEnum 3 = GrabStatusNotViewable
    toEnum 4 = GrabStatusFrozen
    toEnum 5 = GrabStatusFailed
    toEnum k = AnotherGrabStatus k

instance P.Ord GrabStatus where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes GrabStatus = '[]
instance O.HasParentTypes GrabStatus

foreign import ccall "gdk_grab_status_get_type" c_gdk_grab_status_get_type :: 
    IO GType

instance B.Types.TypedObject GrabStatus where
    glibType = c_gdk_grab_status_get_type

instance B.Types.BoxedEnum GrabStatus

-- Enum GrabOwnership
-- | Defines how device grabs interact with other devices.
data GrabOwnership = 
      GrabOwnershipNone
    -- ^ All other devices’ events are allowed.
    | GrabOwnershipWindow
    -- ^ Other devices’ events are blocked for the grab window.
    | GrabOwnershipApplication
    -- ^ Other devices’ events are blocked for the whole application.
    | AnotherGrabOwnership Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum GrabOwnership where
    fromEnum GrabOwnershipNone = 0
    fromEnum GrabOwnershipWindow = 1
    fromEnum GrabOwnershipApplication = 2
    fromEnum (AnotherGrabOwnership k) = k

    toEnum 0 = GrabOwnershipNone
    toEnum 1 = GrabOwnershipWindow
    toEnum 2 = GrabOwnershipApplication
    toEnum k = AnotherGrabOwnership k

instance P.Ord GrabOwnership where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes GrabOwnership = '[]
instance O.HasParentTypes GrabOwnership

foreign import ccall "gdk_grab_ownership_get_type" c_gdk_grab_ownership_get_type :: 
    IO GType

instance B.Types.TypedObject GrabOwnership where
    glibType = c_gdk_grab_ownership_get_type

instance B.Types.BoxedEnum GrabOwnership

-- Enum GLError
-- | Error enumeration for t'GI.Gdk.Objects.GLContext.GLContext'.
-- 
-- /Since: 3.16/
data GLError = 
      GLErrorNotAvailable
    -- ^ OpenGL support is not available
    | GLErrorUnsupportedFormat
    -- ^ The requested visual format is not supported
    | GLErrorUnsupportedProfile
    -- ^ The requested profile is not supported
    | AnotherGLError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum GLError where
    fromEnum GLErrorNotAvailable = 0
    fromEnum GLErrorUnsupportedFormat = 1
    fromEnum GLErrorUnsupportedProfile = 2
    fromEnum (AnotherGLError k) = k

    toEnum 0 = GLErrorNotAvailable
    toEnum 1 = GLErrorUnsupportedFormat
    toEnum 2 = GLErrorUnsupportedProfile
    toEnum k = AnotherGLError k

instance P.Ord GLError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass GLError where
    gerrorClassDomain _ = "gdk-gl-error-quark"

-- | Catch exceptions of type `GLError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchGLError ::
    IO a ->
    (GLError -> GErrorMessage -> IO a) ->
    IO a
catchGLError = catchGErrorJustDomain

-- | Handle exceptions of type `GLError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleGLError ::
    (GLError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleGLError = handleGErrorJustDomain

type instance O.ParentTypes GLError = '[]
instance O.HasParentTypes GLError

foreign import ccall "gdk_gl_error_get_type" c_gdk_gl_error_get_type :: 
    IO GType

instance B.Types.TypedObject GLError where
    glibType = c_gdk_gl_error_get_type

instance B.Types.BoxedEnum GLError

-- Enum FullscreenMode
-- | Indicates which monitor (in a multi-head setup) a window should span over
-- when in fullscreen mode.
-- 
-- /Since: 3.8/
data FullscreenMode = 
      FullscreenModeCurrentMonitor
    -- ^ Fullscreen on current monitor only.
    | FullscreenModeAllMonitors
    -- ^ Span across all monitors when fullscreen.
    | AnotherFullscreenMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FullscreenMode where
    fromEnum FullscreenModeCurrentMonitor = 0
    fromEnum FullscreenModeAllMonitors = 1
    fromEnum (AnotherFullscreenMode k) = k

    toEnum 0 = FullscreenModeCurrentMonitor
    toEnum 1 = FullscreenModeAllMonitors
    toEnum k = AnotherFullscreenMode k

instance P.Ord FullscreenMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FullscreenMode = '[]
instance O.HasParentTypes FullscreenMode

foreign import ccall "gdk_fullscreen_mode_get_type" c_gdk_fullscreen_mode_get_type :: 
    IO GType

instance B.Types.TypedObject FullscreenMode where
    glibType = c_gdk_fullscreen_mode_get_type

instance B.Types.BoxedEnum FullscreenMode

-- Enum FilterReturn
-- | Specifies the result of applying a t'GI.Gdk.Callbacks.FilterFunc' to a native event.
data FilterReturn = 
      FilterReturnContinue
    -- ^ event not handled, continue processing.
    | FilterReturnTranslate
    -- ^ native event translated into a GDK event and stored
    --  in the @event@ structure that was passed in.
    | FilterReturnRemove
    -- ^ event handled, terminate processing.
    | AnotherFilterReturn Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FilterReturn where
    fromEnum FilterReturnContinue = 0
    fromEnum FilterReturnTranslate = 1
    fromEnum FilterReturnRemove = 2
    fromEnum (AnotherFilterReturn k) = k

    toEnum 0 = FilterReturnContinue
    toEnum 1 = FilterReturnTranslate
    toEnum 2 = FilterReturnRemove
    toEnum k = AnotherFilterReturn k

instance P.Ord FilterReturn where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FilterReturn = '[]
instance O.HasParentTypes FilterReturn

foreign import ccall "gdk_filter_return_get_type" c_gdk_filter_return_get_type :: 
    IO GType

instance B.Types.TypedObject FilterReturn where
    glibType = c_gdk_filter_return_get_type

instance B.Types.BoxedEnum FilterReturn

-- Enum EventType
-- | Specifies the type of the event.
-- 
-- Do not confuse these events with the signals that GTK+ widgets emit.
-- Although many of these events result in corresponding signals being emitted,
-- the events are often transformed or filtered along the way.
-- 
-- In some language bindings, the values 'GI.Gdk.Enums.EventType2buttonPress' and
-- 'GI.Gdk.Enums.EventType3buttonPress' would translate into something syntactically
-- invalid (eg @Gdk.EventType.2ButtonPress@, where a
-- symbol is not allowed to start with a number). In that case, the
-- aliases 'GI.Gdk.Enums.EventTypeDoubleButtonPress' and 'GI.Gdk.Enums.EventTypeTripleButtonPress' can
-- be used instead.
data EventType = 
      EventTypeNothing
    -- ^ a special code to indicate a null event.
    | EventTypeDelete
    -- ^ the window manager has requested that the toplevel window be
    --   hidden or destroyed, usually when the user clicks on a special icon in the
    --   title bar.
    | EventTypeDestroy
    -- ^ the window has been destroyed.
    | EventTypeExpose
    -- ^ all or part of the window has become visible and needs to be
    --   redrawn.
    | EventTypeMotionNotify
    -- ^ the pointer (usually a mouse) has moved.
    | EventTypeButtonPress
    -- ^ a mouse button has been pressed.
    | EventType2buttonPress
    -- ^ a mouse button has been double-clicked (clicked twice
    --   within a short period of time). Note that each click also generates a
    --   'GI.Gdk.Enums.EventTypeButtonPress' event.
    | EventTypeDoubleButtonPress
    -- ^ alias for 'GI.Gdk.Enums.EventType2buttonPress', added in 3.6.
    | EventType3buttonPress
    -- ^ a mouse button has been clicked 3 times in a short period
    --   of time. Note that each click also generates a 'GI.Gdk.Enums.EventTypeButtonPress' event.
    | EventTypeTripleButtonPress
    -- ^ alias for 'GI.Gdk.Enums.EventType3buttonPress', added in 3.6.
    | EventTypeButtonRelease
    -- ^ a mouse button has been released.
    | EventTypeKeyPress
    -- ^ a key has been pressed.
    | EventTypeKeyRelease
    -- ^ a key has been released.
    | EventTypeEnterNotify
    -- ^ the pointer has entered the window.
    | EventTypeLeaveNotify
    -- ^ the pointer has left the window.
    | EventTypeFocusChange
    -- ^ the keyboard focus has entered or left the window.
    | EventTypeConfigure
    -- ^ the size, position or stacking order of the window has changed.
    --   Note that GTK+ discards these events for 'GI.Gdk.Enums.WindowTypeChild' windows.
    | EventTypeMap
    -- ^ the window has been mapped.
    | EventTypeUnmap
    -- ^ the window has been unmapped.
    | EventTypePropertyNotify
    -- ^ a property on the window has been changed or deleted.
    | EventTypeSelectionClear
    -- ^ the application has lost ownership of a selection.
    | EventTypeSelectionRequest
    -- ^ another application has requested a selection.
    | EventTypeSelectionNotify
    -- ^ a selection has been received.
    | EventTypeProximityIn
    -- ^ an input device has moved into contact with a sensing
    --   surface (e.g. a touchscreen or graphics tablet).
    | EventTypeProximityOut
    -- ^ an input device has moved out of contact with a sensing
    --   surface.
    | EventTypeDragEnter
    -- ^ the mouse has entered the window while a drag is in progress.
    | EventTypeDragLeave
    -- ^ the mouse has left the window while a drag is in progress.
    | EventTypeDragMotion
    -- ^ the mouse has moved in the window while a drag is in
    --   progress.
    | EventTypeDragStatus
    -- ^ the status of the drag operation initiated by the window
    --   has changed.
    | EventTypeDropStart
    -- ^ a drop operation onto the window has started.
    | EventTypeDropFinished
    -- ^ the drop operation initiated by the window has completed.
    | EventTypeClientEvent
    -- ^ a message has been received from another application.
    | EventTypeVisibilityNotify
    -- ^ the window visibility status has changed.
    | EventTypeScroll
    -- ^ the scroll wheel was turned
    | EventTypeWindowState
    -- ^ the state of a window has changed. See t'GI.Gdk.Flags.WindowState'
    --   for the possible window states
    | EventTypeSetting
    -- ^ a setting has been modified.
    | EventTypeOwnerChange
    -- ^ the owner of a selection has changed. This event type
    --   was added in 2.6
    | EventTypeGrabBroken
    -- ^ a pointer or keyboard grab was broken. This event type
    --   was added in 2.8.
    | EventTypeDamage
    -- ^ the content of the window has been changed. This event type
    --   was added in 2.14.
    | EventTypeTouchBegin
    -- ^ A new touch event sequence has just started. This event
    --   type was added in 3.4.
    | EventTypeTouchUpdate
    -- ^ A touch event sequence has been updated. This event type
    --   was added in 3.4.
    | EventTypeTouchEnd
    -- ^ A touch event sequence has finished. This event type
    --   was added in 3.4.
    | EventTypeTouchCancel
    -- ^ A touch event sequence has been canceled. This event type
    --   was added in 3.4.
    | EventTypeTouchpadSwipe
    -- ^ A touchpad swipe gesture event, the current state
    --   is determined by its phase field. This event type was added in 3.18.
    | EventTypeTouchpadPinch
    -- ^ A touchpad pinch gesture event, the current state
    --   is determined by its phase field. This event type was added in 3.18.
    | EventTypePadButtonPress
    -- ^ A tablet pad button press event. This event type
    --   was added in 3.22.
    | EventTypePadButtonRelease
    -- ^ A tablet pad button release event. This event type
    --   was added in 3.22.
    | EventTypePadRing
    -- ^ A tablet pad axis event from a \"ring\". This event type was
    --   added in 3.22.
    | EventTypePadStrip
    -- ^ A tablet pad axis event from a \"strip\". This event type was
    --   added in 3.22.
    | EventTypePadGroupMode
    -- ^ A tablet pad group mode change. This event type was
    --   added in 3.22.
    | EventTypeEventLast
    -- ^ marks the end of the GdkEventType enumeration. Added in 2.18
    | AnotherEventType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum EventType where
    fromEnum EventTypeNothing = -1
    fromEnum EventTypeDelete = 0
    fromEnum EventTypeDestroy = 1
    fromEnum EventTypeExpose = 2
    fromEnum EventTypeMotionNotify = 3
    fromEnum EventTypeButtonPress = 4
    fromEnum EventType2buttonPress = 5
    fromEnum EventTypeDoubleButtonPress = 5
    fromEnum EventType3buttonPress = 6
    fromEnum EventTypeTripleButtonPress = 6
    fromEnum EventTypeButtonRelease = 7
    fromEnum EventTypeKeyPress = 8
    fromEnum EventTypeKeyRelease = 9
    fromEnum EventTypeEnterNotify = 10
    fromEnum EventTypeLeaveNotify = 11
    fromEnum EventTypeFocusChange = 12
    fromEnum EventTypeConfigure = 13
    fromEnum EventTypeMap = 14
    fromEnum EventTypeUnmap = 15
    fromEnum EventTypePropertyNotify = 16
    fromEnum EventTypeSelectionClear = 17
    fromEnum EventTypeSelectionRequest = 18
    fromEnum EventTypeSelectionNotify = 19
    fromEnum EventTypeProximityIn = 20
    fromEnum EventTypeProximityOut = 21
    fromEnum EventTypeDragEnter = 22
    fromEnum EventTypeDragLeave = 23
    fromEnum EventTypeDragMotion = 24
    fromEnum EventTypeDragStatus = 25
    fromEnum EventTypeDropStart = 26
    fromEnum EventTypeDropFinished = 27
    fromEnum EventTypeClientEvent = 28
    fromEnum EventTypeVisibilityNotify = 29
    fromEnum EventTypeScroll = 31
    fromEnum EventTypeWindowState = 32
    fromEnum EventTypeSetting = 33
    fromEnum EventTypeOwnerChange = 34
    fromEnum EventTypeGrabBroken = 35
    fromEnum EventTypeDamage = 36
    fromEnum EventTypeTouchBegin = 37
    fromEnum EventTypeTouchUpdate = 38
    fromEnum EventTypeTouchEnd = 39
    fromEnum EventTypeTouchCancel = 40
    fromEnum EventTypeTouchpadSwipe = 41
    fromEnum EventTypeTouchpadPinch = 42
    fromEnum EventTypePadButtonPress = 43
    fromEnum EventTypePadButtonRelease = 44
    fromEnum EventTypePadRing = 45
    fromEnum EventTypePadStrip = 46
    fromEnum EventTypePadGroupMode = 47
    fromEnum EventTypeEventLast = 48
    fromEnum (AnotherEventType k) = k

    toEnum -1 = EventTypeNothing
    toEnum 0 = EventTypeDelete
    toEnum 1 = EventTypeDestroy
    toEnum 2 = EventTypeExpose
    toEnum 3 = EventTypeMotionNotify
    toEnum 4 = EventTypeButtonPress
    toEnum 5 = EventType2buttonPress
    toEnum 6 = EventType3buttonPress
    toEnum 7 = EventTypeButtonRelease
    toEnum 8 = EventTypeKeyPress
    toEnum 9 = EventTypeKeyRelease
    toEnum 10 = EventTypeEnterNotify
    toEnum 11 = EventTypeLeaveNotify
    toEnum 12 = EventTypeFocusChange
    toEnum 13 = EventTypeConfigure
    toEnum 14 = EventTypeMap
    toEnum 15 = EventTypeUnmap
    toEnum 16 = EventTypePropertyNotify
    toEnum 17 = EventTypeSelectionClear
    toEnum 18 = EventTypeSelectionRequest
    toEnum 19 = EventTypeSelectionNotify
    toEnum 20 = EventTypeProximityIn
    toEnum 21 = EventTypeProximityOut
    toEnum 22 = EventTypeDragEnter
    toEnum 23 = EventTypeDragLeave
    toEnum 24 = EventTypeDragMotion
    toEnum 25 = EventTypeDragStatus
    toEnum 26 = EventTypeDropStart
    toEnum 27 = EventTypeDropFinished
    toEnum 28 = EventTypeClientEvent
    toEnum 29 = EventTypeVisibilityNotify
    toEnum 31 = EventTypeScroll
    toEnum 32 = EventTypeWindowState
    toEnum 33 = EventTypeSetting
    toEnum 34 = EventTypeOwnerChange
    toEnum 35 = EventTypeGrabBroken
    toEnum 36 = EventTypeDamage
    toEnum 37 = EventTypeTouchBegin
    toEnum 38 = EventTypeTouchUpdate
    toEnum 39 = EventTypeTouchEnd
    toEnum 40 = EventTypeTouchCancel
    toEnum 41 = EventTypeTouchpadSwipe
    toEnum 42 = EventTypeTouchpadPinch
    toEnum 43 = EventTypePadButtonPress
    toEnum 44 = EventTypePadButtonRelease
    toEnum 45 = EventTypePadRing
    toEnum 46 = EventTypePadStrip
    toEnum 47 = EventTypePadGroupMode
    toEnum 48 = EventTypeEventLast
    toEnum k = AnotherEventType k

instance P.Ord EventType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes EventType = '[]
instance O.HasParentTypes EventType

foreign import ccall "gdk_event_type_get_type" c_gdk_event_type_get_type :: 
    IO GType

instance B.Types.TypedObject EventType where
    glibType = c_gdk_event_type_get_type

instance B.Types.BoxedEnum EventType

-- Enum DragProtocol
-- | Used in t'GI.Gdk.Objects.DragContext.DragContext' to indicate the protocol according to
-- which DND is done.
data DragProtocol = 
      DragProtocolNone
    -- ^ no protocol.
    | DragProtocolMotif
    -- ^ The Motif DND protocol. No longer supported
    | DragProtocolXdnd
    -- ^ The Xdnd protocol.
    | DragProtocolRootwin
    -- ^ An extension to the Xdnd protocol for
    --  unclaimed root window drops.
    | DragProtocolWin32Dropfiles
    -- ^ The simple WM_DROPFILES protocol.
    | DragProtocolOle2
    -- ^ The complex OLE2 DND protocol (not implemented).
    | DragProtocolLocal
    -- ^ Intra-application DND.
    | DragProtocolWayland
    -- ^ Wayland DND protocol.
    | AnotherDragProtocol Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DragProtocol where
    fromEnum DragProtocolNone = 0
    fromEnum DragProtocolMotif = 1
    fromEnum DragProtocolXdnd = 2
    fromEnum DragProtocolRootwin = 3
    fromEnum DragProtocolWin32Dropfiles = 4
    fromEnum DragProtocolOle2 = 5
    fromEnum DragProtocolLocal = 6
    fromEnum DragProtocolWayland = 7
    fromEnum (AnotherDragProtocol k) = k

    toEnum 0 = DragProtocolNone
    toEnum 1 = DragProtocolMotif
    toEnum 2 = DragProtocolXdnd
    toEnum 3 = DragProtocolRootwin
    toEnum 4 = DragProtocolWin32Dropfiles
    toEnum 5 = DragProtocolOle2
    toEnum 6 = DragProtocolLocal
    toEnum 7 = DragProtocolWayland
    toEnum k = AnotherDragProtocol k

instance P.Ord DragProtocol where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DragProtocol = '[]
instance O.HasParentTypes DragProtocol

foreign import ccall "gdk_drag_protocol_get_type" c_gdk_drag_protocol_get_type :: 
    IO GType

instance B.Types.TypedObject DragProtocol where
    glibType = c_gdk_drag_protocol_get_type

instance B.Types.BoxedEnum DragProtocol

-- Enum DragCancelReason
-- | Used in t'GI.Gdk.Objects.DragContext.DragContext' to the reason of a cancelled DND operation.
-- 
-- /Since: 3.20/
data DragCancelReason = 
      DragCancelReasonNoTarget
    -- ^ There is no suitable drop target.
    | DragCancelReasonUserCancelled
    -- ^ Drag cancelled by the user
    | DragCancelReasonError
    -- ^ Unspecified error.
    | AnotherDragCancelReason Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DragCancelReason where
    fromEnum DragCancelReasonNoTarget = 0
    fromEnum DragCancelReasonUserCancelled = 1
    fromEnum DragCancelReasonError = 2
    fromEnum (AnotherDragCancelReason k) = k

    toEnum 0 = DragCancelReasonNoTarget
    toEnum 1 = DragCancelReasonUserCancelled
    toEnum 2 = DragCancelReasonError
    toEnum k = AnotherDragCancelReason k

instance P.Ord DragCancelReason where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DragCancelReason = '[]
instance O.HasParentTypes DragCancelReason

foreign import ccall "gdk_drag_cancel_reason_get_type" c_gdk_drag_cancel_reason_get_type :: 
    IO GType

instance B.Types.TypedObject DragCancelReason where
    glibType = c_gdk_drag_cancel_reason_get_type

instance B.Types.BoxedEnum DragCancelReason

-- Enum DeviceType
-- | Indicates the device type. See [above][GdkDeviceManager.description]
-- for more information about the meaning of these device types.
data DeviceType = 
      DeviceTypeMaster
    -- ^ Device is a master (or virtual) device. There will
    --                          be an associated focus indicator on the screen.
    | DeviceTypeSlave
    -- ^ Device is a slave (or physical) device.
    | DeviceTypeFloating
    -- ^ Device is a physical device, currently not attached to
    --                            any virtual device.
    | AnotherDeviceType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DeviceType where
    fromEnum DeviceTypeMaster = 0
    fromEnum DeviceTypeSlave = 1
    fromEnum DeviceTypeFloating = 2
    fromEnum (AnotherDeviceType k) = k

    toEnum 0 = DeviceTypeMaster
    toEnum 1 = DeviceTypeSlave
    toEnum 2 = DeviceTypeFloating
    toEnum k = AnotherDeviceType k

instance P.Ord DeviceType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DeviceType = '[]
instance O.HasParentTypes DeviceType

foreign import ccall "gdk_device_type_get_type" c_gdk_device_type_get_type :: 
    IO GType

instance B.Types.TypedObject DeviceType where
    glibType = c_gdk_device_type_get_type

instance B.Types.BoxedEnum DeviceType

-- Enum DeviceToolType
-- | Indicates the specific type of tool being used being a tablet. Such as an
-- airbrush, pencil, etc.
-- 
-- /Since: 3.22/
data DeviceToolType = 
      DeviceToolTypeUnknown
    -- ^ Tool is of an unknown type.
    | DeviceToolTypePen
    -- ^ Tool is a standard tablet stylus.
    | DeviceToolTypeEraser
    -- ^ Tool is standard tablet eraser.
    | DeviceToolTypeBrush
    -- ^ Tool is a brush stylus.
    | DeviceToolTypePencil
    -- ^ Tool is a pencil stylus.
    | DeviceToolTypeAirbrush
    -- ^ Tool is an airbrush stylus.
    | DeviceToolTypeMouse
    -- ^ Tool is a mouse.
    | DeviceToolTypeLens
    -- ^ Tool is a lens cursor.
    | AnotherDeviceToolType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DeviceToolType where
    fromEnum DeviceToolTypeUnknown = 0
    fromEnum DeviceToolTypePen = 1
    fromEnum DeviceToolTypeEraser = 2
    fromEnum DeviceToolTypeBrush = 3
    fromEnum DeviceToolTypePencil = 4
    fromEnum DeviceToolTypeAirbrush = 5
    fromEnum DeviceToolTypeMouse = 6
    fromEnum DeviceToolTypeLens = 7
    fromEnum (AnotherDeviceToolType k) = k

    toEnum 0 = DeviceToolTypeUnknown
    toEnum 1 = DeviceToolTypePen
    toEnum 2 = DeviceToolTypeEraser
    toEnum 3 = DeviceToolTypeBrush
    toEnum 4 = DeviceToolTypePencil
    toEnum 5 = DeviceToolTypeAirbrush
    toEnum 6 = DeviceToolTypeMouse
    toEnum 7 = DeviceToolTypeLens
    toEnum k = AnotherDeviceToolType k

instance P.Ord DeviceToolType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DeviceToolType = '[]
instance O.HasParentTypes DeviceToolType

foreign import ccall "gdk_device_tool_type_get_type" c_gdk_device_tool_type_get_type :: 
    IO GType

instance B.Types.TypedObject DeviceToolType where
    glibType = c_gdk_device_tool_type_get_type

instance B.Types.BoxedEnum DeviceToolType

-- Enum DevicePadFeature
-- | A pad feature.
data DevicePadFeature = 
      DevicePadFeatureButton
    -- ^ a button
    | DevicePadFeatureRing
    -- ^ a ring-shaped interactive area
    | DevicePadFeatureStrip
    -- ^ a straight interactive area
    | AnotherDevicePadFeature Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DevicePadFeature where
    fromEnum DevicePadFeatureButton = 0
    fromEnum DevicePadFeatureRing = 1
    fromEnum DevicePadFeatureStrip = 2
    fromEnum (AnotherDevicePadFeature k) = k

    toEnum 0 = DevicePadFeatureButton
    toEnum 1 = DevicePadFeatureRing
    toEnum 2 = DevicePadFeatureStrip
    toEnum k = AnotherDevicePadFeature k

instance P.Ord DevicePadFeature where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DevicePadFeature = '[]
instance O.HasParentTypes DevicePadFeature

foreign import ccall "gdk_device_pad_feature_get_type" c_gdk_device_pad_feature_get_type :: 
    IO GType

instance B.Types.TypedObject DevicePadFeature where
    glibType = c_gdk_device_pad_feature_get_type

instance B.Types.BoxedEnum DevicePadFeature

-- Enum CursorType
-- | Predefined cursors.
-- 
-- Note that these IDs are directly taken from the X cursor font, and many
-- of these cursors are either not useful, or are not available on other platforms.
-- 
-- The recommended way to create cursors is to use 'GI.Gdk.Objects.Cursor.cursorNewFromName'.
data CursorType = 
      CursorTypeXCursor
    -- ^ <<http://developer.gnome.org/gdk/stable/X_cursor.png>>
    | CursorTypeArrow
    -- ^ <<http://developer.gnome.org/gdk/stable/arrow.png>>
    | CursorTypeBasedArrowDown
    -- ^ <<http://developer.gnome.org/gdk/stable/based_arrow_down.png>>
    | CursorTypeBasedArrowUp
    -- ^ <<http://developer.gnome.org/gdk/stable/based_arrow_up.png>>
    | CursorTypeBoat
    -- ^ <<http://developer.gnome.org/gdk/stable/boat.png>>
    | CursorTypeBogosity
    -- ^ <<http://developer.gnome.org/gdk/stable/bogosity.png>>
    | CursorTypeBottomLeftCorner
    -- ^ <<http://developer.gnome.org/gdk/stable/bottom_left_corner.png>>
    | CursorTypeBottomRightCorner
    -- ^ <<http://developer.gnome.org/gdk/stable/bottom_right_corner.png>>
    | CursorTypeBottomSide
    -- ^ <<http://developer.gnome.org/gdk/stable/bottom_side.png>>
    | CursorTypeBottomTee
    -- ^ <<http://developer.gnome.org/gdk/stable/bottom_tee.png>>
    | CursorTypeBoxSpiral
    -- ^ <<http://developer.gnome.org/gdk/stable/box_spiral.png>>
    | CursorTypeCenterPtr
    -- ^ <<http://developer.gnome.org/gdk/stable/center_ptr.png>>
    | CursorTypeCircle
    -- ^ <<http://developer.gnome.org/gdk/stable/circle.png>>
    | CursorTypeClock
    -- ^ <<http://developer.gnome.org/gdk/stable/clock.png>>
    | CursorTypeCoffeeMug
    -- ^ <<http://developer.gnome.org/gdk/stable/coffee_mug.png>>
    | CursorTypeCross
    -- ^ <<http://developer.gnome.org/gdk/stable/cross.png>>
    | CursorTypeCrossReverse
    -- ^ <<http://developer.gnome.org/gdk/stable/cross_reverse.png>>
    | CursorTypeCrosshair
    -- ^ <<http://developer.gnome.org/gdk/stable/crosshair.png>>
    | CursorTypeDiamondCross
    -- ^ <<http://developer.gnome.org/gdk/stable/diamond_cross.png>>
    | CursorTypeDot
    -- ^ <<http://developer.gnome.org/gdk/stable/dot.png>>
    | CursorTypeDotbox
    -- ^ <<http://developer.gnome.org/gdk/stable/dotbox.png>>
    | CursorTypeDoubleArrow
    -- ^ <<http://developer.gnome.org/gdk/stable/double_arrow.png>>
    | CursorTypeDraftLarge
    -- ^ <<http://developer.gnome.org/gdk/stable/draft_large.png>>
    | CursorTypeDraftSmall
    -- ^ <<http://developer.gnome.org/gdk/stable/draft_small.png>>
    | CursorTypeDrapedBox
    -- ^ <<http://developer.gnome.org/gdk/stable/draped_box.png>>
    | CursorTypeExchange
    -- ^ <<http://developer.gnome.org/gdk/stable/exchange.png>>
    | CursorTypeFleur
    -- ^ <<http://developer.gnome.org/gdk/stable/fleur.png>>
    | CursorTypeGobbler
    -- ^ <<http://developer.gnome.org/gdk/stable/gobbler.png>>
    | CursorTypeGumby
    -- ^ <<http://developer.gnome.org/gdk/stable/gumby.png>>
    | CursorTypeHand1
    -- ^ <<http://developer.gnome.org/gdk/stable/hand1.png>>
    | CursorTypeHand2
    -- ^ <<http://developer.gnome.org/gdk/stable/hand2.png>>
    | CursorTypeHeart
    -- ^ <<http://developer.gnome.org/gdk/stable/heart.png>>
    | CursorTypeIcon
    -- ^ <<http://developer.gnome.org/gdk/stable/icon.png>>
    | CursorTypeIronCross
    -- ^ <<http://developer.gnome.org/gdk/stable/iron_cross.png>>
    | CursorTypeLeftPtr
    -- ^ <<http://developer.gnome.org/gdk/stable/left_ptr.png>>
    | CursorTypeLeftSide
    -- ^ <<http://developer.gnome.org/gdk/stable/left_side.png>>
    | CursorTypeLeftTee
    -- ^ <<http://developer.gnome.org/gdk/stable/left_tee.png>>
    | CursorTypeLeftbutton
    -- ^ <<http://developer.gnome.org/gdk/stable/leftbutton.png>>
    | CursorTypeLlAngle
    -- ^ <<http://developer.gnome.org/gdk/stable/ll_angle.png>>
    | CursorTypeLrAngle
    -- ^ <<http://developer.gnome.org/gdk/stable/lr_angle.png>>
    | CursorTypeMan
    -- ^ <<http://developer.gnome.org/gdk/stable/man.png>>
    | CursorTypeMiddlebutton
    -- ^ <<http://developer.gnome.org/gdk/stable/middlebutton.png>>
    | CursorTypeMouse
    -- ^ <<http://developer.gnome.org/gdk/stable/mouse.png>>
    | CursorTypePencil
    -- ^ <<http://developer.gnome.org/gdk/stable/pencil.png>>
    | CursorTypePirate
    -- ^ <<http://developer.gnome.org/gdk/stable/pirate.png>>
    | CursorTypePlus
    -- ^ <<http://developer.gnome.org/gdk/stable/plus.png>>
    | CursorTypeQuestionArrow
    -- ^ <<http://developer.gnome.org/gdk/stable/question_arrow.png>>
    | CursorTypeRightPtr
    -- ^ <<http://developer.gnome.org/gdk/stable/right_ptr.png>>
    | CursorTypeRightSide
    -- ^ <<http://developer.gnome.org/gdk/stable/right_side.png>>
    | CursorTypeRightTee
    -- ^ <<http://developer.gnome.org/gdk/stable/right_tee.png>>
    | CursorTypeRightbutton
    -- ^ <<http://developer.gnome.org/gdk/stable/rightbutton.png>>
    | CursorTypeRtlLogo
    -- ^ <<http://developer.gnome.org/gdk/stable/rtl_logo.png>>
    | CursorTypeSailboat
    -- ^ <<http://developer.gnome.org/gdk/stable/sailboat.png>>
    | CursorTypeSbDownArrow
    -- ^ <<http://developer.gnome.org/gdk/stable/sb_down_arrow.png>>
    | CursorTypeSbHDoubleArrow
    -- ^ <<http://developer.gnome.org/gdk/stable/sb_h_double_arrow.png>>
    | CursorTypeSbLeftArrow
    -- ^ <<http://developer.gnome.org/gdk/stable/sb_left_arrow.png>>
    | CursorTypeSbRightArrow
    -- ^ <<http://developer.gnome.org/gdk/stable/sb_right_arrow.png>>
    | CursorTypeSbUpArrow
    -- ^ <<http://developer.gnome.org/gdk/stable/sb_up_arrow.png>>
    | CursorTypeSbVDoubleArrow
    -- ^ <<http://developer.gnome.org/gdk/stable/sb_v_double_arrow.png>>
    | CursorTypeShuttle
    -- ^ <<http://developer.gnome.org/gdk/stable/shuttle.png>>
    | CursorTypeSizing
    -- ^ <<http://developer.gnome.org/gdk/stable/sizing.png>>
    | CursorTypeSpider
    -- ^ <<http://developer.gnome.org/gdk/stable/spider.png>>
    | CursorTypeSpraycan
    -- ^ <<http://developer.gnome.org/gdk/stable/spraycan.png>>
    | CursorTypeStar
    -- ^ <<http://developer.gnome.org/gdk/stable/star.png>>
    | CursorTypeTarget
    -- ^ <<http://developer.gnome.org/gdk/stable/target.png>>
    | CursorTypeTcross
    -- ^ <<http://developer.gnome.org/gdk/stable/tcross.png>>
    | CursorTypeTopLeftArrow
    -- ^ <<http://developer.gnome.org/gdk/stable/top_left_arrow.png>>
    | CursorTypeTopLeftCorner
    -- ^ <<http://developer.gnome.org/gdk/stable/top_left_corner.png>>
    | CursorTypeTopRightCorner
    -- ^ <<http://developer.gnome.org/gdk/stable/top_right_corner.png>>
    | CursorTypeTopSide
    -- ^ <<http://developer.gnome.org/gdk/stable/top_side.png>>
    | CursorTypeTopTee
    -- ^ <<http://developer.gnome.org/gdk/stable/top_tee.png>>
    | CursorTypeTrek
    -- ^ <<http://developer.gnome.org/gdk/stable/trek.png>>
    | CursorTypeUlAngle
    -- ^ <<http://developer.gnome.org/gdk/stable/ul_angle.png>>
    | CursorTypeUmbrella
    -- ^ <<http://developer.gnome.org/gdk/stable/umbrella.png>>
    | CursorTypeUrAngle
    -- ^ <<http://developer.gnome.org/gdk/stable/ur_angle.png>>
    | CursorTypeWatch
    -- ^ <<http://developer.gnome.org/gdk/stable/watch.png>>
    | CursorTypeXterm
    -- ^ <<http://developer.gnome.org/gdk/stable/xterm.png>>
    | CursorTypeLastCursor
    -- ^ last cursor type
    | CursorTypeBlankCursor
    -- ^ Blank cursor. Since 2.16
    | CursorTypeCursorIsPixmap
    -- ^ type of cursors constructed with
    --   'GI.Gdk.Objects.Cursor.cursorNewFromPixbuf'
    | AnotherCursorType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CursorType where
    fromEnum CursorTypeXCursor = 0
    fromEnum CursorTypeArrow = 2
    fromEnum CursorTypeBasedArrowDown = 4
    fromEnum CursorTypeBasedArrowUp = 6
    fromEnum CursorTypeBoat = 8
    fromEnum CursorTypeBogosity = 10
    fromEnum CursorTypeBottomLeftCorner = 12
    fromEnum CursorTypeBottomRightCorner = 14
    fromEnum CursorTypeBottomSide = 16
    fromEnum CursorTypeBottomTee = 18
    fromEnum CursorTypeBoxSpiral = 20
    fromEnum CursorTypeCenterPtr = 22
    fromEnum CursorTypeCircle = 24
    fromEnum CursorTypeClock = 26
    fromEnum CursorTypeCoffeeMug = 28
    fromEnum CursorTypeCross = 30
    fromEnum CursorTypeCrossReverse = 32
    fromEnum CursorTypeCrosshair = 34
    fromEnum CursorTypeDiamondCross = 36
    fromEnum CursorTypeDot = 38
    fromEnum CursorTypeDotbox = 40
    fromEnum CursorTypeDoubleArrow = 42
    fromEnum CursorTypeDraftLarge = 44
    fromEnum CursorTypeDraftSmall = 46
    fromEnum CursorTypeDrapedBox = 48
    fromEnum CursorTypeExchange = 50
    fromEnum CursorTypeFleur = 52
    fromEnum CursorTypeGobbler = 54
    fromEnum CursorTypeGumby = 56
    fromEnum CursorTypeHand1 = 58
    fromEnum CursorTypeHand2 = 60
    fromEnum CursorTypeHeart = 62
    fromEnum CursorTypeIcon = 64
    fromEnum CursorTypeIronCross = 66
    fromEnum CursorTypeLeftPtr = 68
    fromEnum CursorTypeLeftSide = 70
    fromEnum CursorTypeLeftTee = 72
    fromEnum CursorTypeLeftbutton = 74
    fromEnum CursorTypeLlAngle = 76
    fromEnum CursorTypeLrAngle = 78
    fromEnum CursorTypeMan = 80
    fromEnum CursorTypeMiddlebutton = 82
    fromEnum CursorTypeMouse = 84
    fromEnum CursorTypePencil = 86
    fromEnum CursorTypePirate = 88
    fromEnum CursorTypePlus = 90
    fromEnum CursorTypeQuestionArrow = 92
    fromEnum CursorTypeRightPtr = 94
    fromEnum CursorTypeRightSide = 96
    fromEnum CursorTypeRightTee = 98
    fromEnum CursorTypeRightbutton = 100
    fromEnum CursorTypeRtlLogo = 102
    fromEnum CursorTypeSailboat = 104
    fromEnum CursorTypeSbDownArrow = 106
    fromEnum CursorTypeSbHDoubleArrow = 108
    fromEnum CursorTypeSbLeftArrow = 110
    fromEnum CursorTypeSbRightArrow = 112
    fromEnum CursorTypeSbUpArrow = 114
    fromEnum CursorTypeSbVDoubleArrow = 116
    fromEnum CursorTypeShuttle = 118
    fromEnum CursorTypeSizing = 120
    fromEnum CursorTypeSpider = 122
    fromEnum CursorTypeSpraycan = 124
    fromEnum CursorTypeStar = 126
    fromEnum CursorTypeTarget = 128
    fromEnum CursorTypeTcross = 130
    fromEnum CursorTypeTopLeftArrow = 132
    fromEnum CursorTypeTopLeftCorner = 134
    fromEnum CursorTypeTopRightCorner = 136
    fromEnum CursorTypeTopSide = 138
    fromEnum CursorTypeTopTee = 140
    fromEnum CursorTypeTrek = 142
    fromEnum CursorTypeUlAngle = 144
    fromEnum CursorTypeUmbrella = 146
    fromEnum CursorTypeUrAngle = 148
    fromEnum CursorTypeWatch = 150
    fromEnum CursorTypeXterm = 152
    fromEnum CursorTypeLastCursor = 153
    fromEnum CursorTypeBlankCursor = -2
    fromEnum CursorTypeCursorIsPixmap = -1
    fromEnum (AnotherCursorType k) = k

    toEnum 0 = CursorTypeXCursor
    toEnum 2 = CursorTypeArrow
    toEnum 4 = CursorTypeBasedArrowDown
    toEnum 6 = CursorTypeBasedArrowUp
    toEnum 8 = CursorTypeBoat
    toEnum 10 = CursorTypeBogosity
    toEnum 12 = CursorTypeBottomLeftCorner
    toEnum 14 = CursorTypeBottomRightCorner
    toEnum 16 = CursorTypeBottomSide
    toEnum 18 = CursorTypeBottomTee
    toEnum 20 = CursorTypeBoxSpiral
    toEnum 22 = CursorTypeCenterPtr
    toEnum 24 = CursorTypeCircle
    toEnum 26 = CursorTypeClock
    toEnum 28 = CursorTypeCoffeeMug
    toEnum 30 = CursorTypeCross
    toEnum 32 = CursorTypeCrossReverse
    toEnum 34 = CursorTypeCrosshair
    toEnum 36 = CursorTypeDiamondCross
    toEnum 38 = CursorTypeDot
    toEnum 40 = CursorTypeDotbox
    toEnum 42 = CursorTypeDoubleArrow
    toEnum 44 = CursorTypeDraftLarge
    toEnum 46 = CursorTypeDraftSmall
    toEnum 48 = CursorTypeDrapedBox
    toEnum 50 = CursorTypeExchange
    toEnum 52 = CursorTypeFleur
    toEnum 54 = CursorTypeGobbler
    toEnum 56 = CursorTypeGumby
    toEnum 58 = CursorTypeHand1
    toEnum 60 = CursorTypeHand2
    toEnum 62 = CursorTypeHeart
    toEnum 64 = CursorTypeIcon
    toEnum 66 = CursorTypeIronCross
    toEnum 68 = CursorTypeLeftPtr
    toEnum 70 = CursorTypeLeftSide
    toEnum 72 = CursorTypeLeftTee
    toEnum 74 = CursorTypeLeftbutton
    toEnum 76 = CursorTypeLlAngle
    toEnum 78 = CursorTypeLrAngle
    toEnum 80 = CursorTypeMan
    toEnum 82 = CursorTypeMiddlebutton
    toEnum 84 = CursorTypeMouse
    toEnum 86 = CursorTypePencil
    toEnum 88 = CursorTypePirate
    toEnum 90 = CursorTypePlus
    toEnum 92 = CursorTypeQuestionArrow
    toEnum 94 = CursorTypeRightPtr
    toEnum 96 = CursorTypeRightSide
    toEnum 98 = CursorTypeRightTee
    toEnum 100 = CursorTypeRightbutton
    toEnum 102 = CursorTypeRtlLogo
    toEnum 104 = CursorTypeSailboat
    toEnum 106 = CursorTypeSbDownArrow
    toEnum 108 = CursorTypeSbHDoubleArrow
    toEnum 110 = CursorTypeSbLeftArrow
    toEnum 112 = CursorTypeSbRightArrow
    toEnum 114 = CursorTypeSbUpArrow
    toEnum 116 = CursorTypeSbVDoubleArrow
    toEnum 118 = CursorTypeShuttle
    toEnum 120 = CursorTypeSizing
    toEnum 122 = CursorTypeSpider
    toEnum 124 = CursorTypeSpraycan
    toEnum 126 = CursorTypeStar
    toEnum 128 = CursorTypeTarget
    toEnum 130 = CursorTypeTcross
    toEnum 132 = CursorTypeTopLeftArrow
    toEnum 134 = CursorTypeTopLeftCorner
    toEnum 136 = CursorTypeTopRightCorner
    toEnum 138 = CursorTypeTopSide
    toEnum 140 = CursorTypeTopTee
    toEnum 142 = CursorTypeTrek
    toEnum 144 = CursorTypeUlAngle
    toEnum 146 = CursorTypeUmbrella
    toEnum 148 = CursorTypeUrAngle
    toEnum 150 = CursorTypeWatch
    toEnum 152 = CursorTypeXterm
    toEnum 153 = CursorTypeLastCursor
    toEnum -2 = CursorTypeBlankCursor
    toEnum -1 = CursorTypeCursorIsPixmap
    toEnum k = AnotherCursorType k

instance P.Ord CursorType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes CursorType = '[]
instance O.HasParentTypes CursorType

foreign import ccall "gdk_cursor_type_get_type" c_gdk_cursor_type_get_type :: 
    IO GType

instance B.Types.TypedObject CursorType where
    glibType = c_gdk_cursor_type_get_type

instance B.Types.BoxedEnum CursorType

-- Enum CrossingMode
-- | Specifies the crossing mode for t'GI.Gdk.Structs.EventCrossing.EventCrossing'.
data CrossingMode = 
      CrossingModeNormal
    -- ^ crossing because of pointer motion.
    | CrossingModeGrab
    -- ^ crossing because a grab is activated.
    | CrossingModeUngrab
    -- ^ crossing because a grab is deactivated.
    | CrossingModeGtkGrab
    -- ^ crossing because a GTK+ grab is activated.
    | CrossingModeGtkUngrab
    -- ^ crossing because a GTK+ grab is deactivated.
    | CrossingModeStateChanged
    -- ^ crossing because a GTK+ widget changed
    --   state (e.g. sensitivity).
    | CrossingModeTouchBegin
    -- ^ crossing because a touch sequence has begun,
    --   this event is synthetic as the pointer might have not left the window.
    | CrossingModeTouchEnd
    -- ^ crossing because a touch sequence has ended,
    --   this event is synthetic as the pointer might have not left the window.
    | CrossingModeDeviceSwitch
    -- ^ crossing because of a device switch (i.e.
    --   a mouse taking control of the pointer after a touch device), this event
    --   is synthetic as the pointer didn’t leave the window.
    | AnotherCrossingMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CrossingMode where
    fromEnum CrossingModeNormal = 0
    fromEnum CrossingModeGrab = 1
    fromEnum CrossingModeUngrab = 2
    fromEnum CrossingModeGtkGrab = 3
    fromEnum CrossingModeGtkUngrab = 4
    fromEnum CrossingModeStateChanged = 5
    fromEnum CrossingModeTouchBegin = 6
    fromEnum CrossingModeTouchEnd = 7
    fromEnum CrossingModeDeviceSwitch = 8
    fromEnum (AnotherCrossingMode k) = k

    toEnum 0 = CrossingModeNormal
    toEnum 1 = CrossingModeGrab
    toEnum 2 = CrossingModeUngrab
    toEnum 3 = CrossingModeGtkGrab
    toEnum 4 = CrossingModeGtkUngrab
    toEnum 5 = CrossingModeStateChanged
    toEnum 6 = CrossingModeTouchBegin
    toEnum 7 = CrossingModeTouchEnd
    toEnum 8 = CrossingModeDeviceSwitch
    toEnum k = AnotherCrossingMode k

instance P.Ord CrossingMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes CrossingMode = '[]
instance O.HasParentTypes CrossingMode

foreign import ccall "gdk_crossing_mode_get_type" c_gdk_crossing_mode_get_type :: 
    IO GType

instance B.Types.TypedObject CrossingMode where
    glibType = c_gdk_crossing_mode_get_type

instance B.Types.BoxedEnum CrossingMode

-- Enum ByteOrder
-- | A set of values describing the possible byte-orders
-- for storing pixel values in memory.
data ByteOrder = 
      ByteOrderLsbFirst
    -- ^ The values are stored with the least-significant byte
    --   first. For instance, the 32-bit value 0xffeecc would be stored
    --   in memory as 0xcc, 0xee, 0xff, 0x00.
    | ByteOrderMsbFirst
    -- ^ The values are stored with the most-significant byte
    --   first. For instance, the 32-bit value 0xffeecc would be stored
    --   in memory as 0x00, 0xff, 0xee, 0xcc.
    | AnotherByteOrder Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ByteOrder where
    fromEnum ByteOrderLsbFirst = 0
    fromEnum ByteOrderMsbFirst = 1
    fromEnum (AnotherByteOrder k) = k

    toEnum 0 = ByteOrderLsbFirst
    toEnum 1 = ByteOrderMsbFirst
    toEnum k = AnotherByteOrder k

instance P.Ord ByteOrder where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ByteOrder = '[]
instance O.HasParentTypes ByteOrder

foreign import ccall "gdk_byte_order_get_type" c_gdk_byte_order_get_type :: 
    IO GType

instance B.Types.TypedObject ByteOrder where
    glibType = c_gdk_byte_order_get_type

instance B.Types.BoxedEnum ByteOrder

-- Enum AxisUse
-- | An enumeration describing the way in which a device
-- axis (valuator) maps onto the predefined valuator
-- types that GTK+ understands.
-- 
-- Note that the X and Y axes are not really needed; pointer devices
-- report their location via the x\/y members of events regardless. Whether
-- X and Y are present as axes depends on the GDK backend.
data AxisUse = 
      AxisUseIgnore
    -- ^ the axis is ignored.
    | AxisUseX
    -- ^ the axis is used as the x axis.
    | AxisUseY
    -- ^ the axis is used as the y axis.
    | AxisUsePressure
    -- ^ the axis is used for pressure information.
    | AxisUseXtilt
    -- ^ the axis is used for x tilt information.
    | AxisUseYtilt
    -- ^ the axis is used for y tilt information.
    | AxisUseWheel
    -- ^ the axis is used for wheel information.
    | AxisUseDistance
    -- ^ the axis is used for pen\/tablet distance information. (Since: 3.22)
    | AxisUseRotation
    -- ^ the axis is used for pen rotation information. (Since: 3.22)
    | AxisUseSlider
    -- ^ the axis is used for pen slider information. (Since: 3.22)
    | AxisUseLast
    -- ^ a constant equal to the numerically highest axis value.
    | AnotherAxisUse Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AxisUse where
    fromEnum AxisUseIgnore = 0
    fromEnum AxisUseX = 1
    fromEnum AxisUseY = 2
    fromEnum AxisUsePressure = 3
    fromEnum AxisUseXtilt = 4
    fromEnum AxisUseYtilt = 5
    fromEnum AxisUseWheel = 6
    fromEnum AxisUseDistance = 7
    fromEnum AxisUseRotation = 8
    fromEnum AxisUseSlider = 9
    fromEnum AxisUseLast = 10
    fromEnum (AnotherAxisUse k) = k

    toEnum 0 = AxisUseIgnore
    toEnum 1 = AxisUseX
    toEnum 2 = AxisUseY
    toEnum 3 = AxisUsePressure
    toEnum 4 = AxisUseXtilt
    toEnum 5 = AxisUseYtilt
    toEnum 6 = AxisUseWheel
    toEnum 7 = AxisUseDistance
    toEnum 8 = AxisUseRotation
    toEnum 9 = AxisUseSlider
    toEnum 10 = AxisUseLast
    toEnum k = AnotherAxisUse k

instance P.Ord AxisUse where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AxisUse = '[]
instance O.HasParentTypes AxisUse

foreign import ccall "gdk_axis_use_get_type" c_gdk_axis_use_get_type :: 
    IO GType

instance B.Types.TypedObject AxisUse where
    glibType = c_gdk_axis_use_get_type

instance B.Types.BoxedEnum AxisUse


