/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, iio, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */

static const char* __doc_gr_iio_attr_updater = R"doc(Generic helper block to create message in a format that will be accepted by the IIO Attribute Sink Block.

This block is a simple but flexible message source which can be connected to the IIO Attribute Sink block for easy interaction and real-time control of IIO driver attributes.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::attr_updater.

Args:
    attribute : String of name of attribute to be updated
    value : String of value to update the attribute too
    interval_ms : Integer of interval in milliseconds to produce messages. If zero outputs will be made only on callback changes and when the flowgraph starts)doc";

static const char* __doc_gr_iio_attr_updater_make = R"doc(Generic helper block to create message in a format that will be accepted by the IIO Attribute Sink Block.

This block is a simple but flexible message source which can be connected to the IIO Attribute Sink block for easy interaction and real-time control of IIO driver attributes.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::attr_updater.

Args:
    attribute : String of name of attribute to be updated
    value : String of value to update the attribute too
    interval_ms : Integer of interval in milliseconds to produce messages. If zero outputs will be made only on callback changes and when the flowgraph starts)doc";

static const char* __doc_gr_iio_attr_set_value = R"doc()doc";
