/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt2_cellinterleaver_cc = R"doc(Cell and time interleaves QPSK/QAM modulated cells.

Input: QPSK, 16QAM, 64QAM or 256QAM modulated cells. 
Output: Cell and time interleaved QPSK, 16QAM, 64QAM or 256QAM modulated cells.

Constructor Specific Documentation:

Create a DVB-T2 cell and time interleaver.

Args:
    framesize : FEC frame size (normal or short).
    constellation : DVB-T2 constellation.
    fecblocks : number of FEC frames in a T2 frame.
    tiblocks : number of time interleaving blocks in a T2 frame.)doc";


static const char* __doc_gr_dtv_dvbt2_cellinterleaver_cc_dvbt2_cellinterleaver_cc =
    R"doc()doc";


static const char* __doc_gr_dtv_dvbt2_cellinterleaver_cc_make = R"doc(Cell and time interleaves QPSK/QAM modulated cells.

Input: QPSK, 16QAM, 64QAM or 256QAM modulated cells. 
Output: Cell and time interleaved QPSK, 16QAM, 64QAM or 256QAM modulated cells.

Constructor Specific Documentation:

Create a DVB-T2 cell and time interleaver.

Args:
    framesize : FEC frame size (normal or short).
    constellation : DVB-T2 constellation.
    fecblocks : number of FEC frames in a T2 frame.
    tiblocks : number of time interleaving blocks in a T2 frame.)doc";
