/* buttons-programming.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from buttons-programming.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "calculator.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PROGRAMMING_BUTTON_PANEL (programming_button_panel_get_type ())
#define PROGRAMMING_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRAMMING_BUTTON_PANEL, ProgrammingButtonPanel))
#define PROGRAMMING_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRAMMING_BUTTON_PANEL, ProgrammingButtonPanelClass))
#define IS_PROGRAMMING_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRAMMING_BUTTON_PANEL))
#define IS_PROGRAMMING_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRAMMING_BUTTON_PANEL))
#define PROGRAMMING_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRAMMING_BUTTON_PANEL, ProgrammingButtonPanelClass))

typedef struct _ProgrammingButtonPanel ProgrammingButtonPanel;
typedef struct _ProgrammingButtonPanelClass ProgrammingButtonPanelClass;
typedef struct _ProgrammingButtonPanelPrivate ProgrammingButtonPanelPrivate;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
enum  {
	PROGRAMMING_BUTTON_PANEL_0_PROPERTY,
	PROGRAMMING_BUTTON_PANEL_NUM_PROPERTIES
};
static GParamSpec* programming_button_panel_properties[PROGRAMMING_BUTTON_PANEL_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MATH_POPOVER (math_popover_get_type ())
#define MATH_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_POPOVER, MathPopover))
#define MATH_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_POPOVER, MathPopoverClass))
#define IS_MATH_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_POPOVER))
#define IS_MATH_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_POPOVER))
#define MATH_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_POPOVER, MathPopoverClass))

typedef struct _MathPopover MathPopover;
typedef struct _MathPopoverClass MathPopoverClass;

#define TYPE_MATH_VARIABLE_POPOVER (math_variable_popover_get_type ())
#define MATH_VARIABLE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopover))
#define MATH_VARIABLE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopoverClass))
#define IS_MATH_VARIABLE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLE_POPOVER))
#define IS_MATH_VARIABLE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLE_POPOVER))
#define MATH_VARIABLE_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopoverClass))

typedef struct _MathVariablePopover MathVariablePopover;
typedef struct _MathVariablePopoverClass MathVariablePopoverClass;

#define TYPE_MATH_FUNCTION_POPOVER (math_function_popover_get_type ())
#define MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopover))
#define MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))
#define IS_MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION_POPOVER))
#define IS_MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION_POPOVER))
#define MATH_FUNCTION_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))

typedef struct _MathFunctionPopover MathFunctionPopover;
typedef struct _MathFunctionPopoverClass MathFunctionPopoverClass;
typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD,
	BUTTON_MODE_CONVERSION
} ButtonMode;

#define TYPE_BUTTON_MODE (button_mode_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _ProgrammingButtonPanel {
	AdwBreakpointBin parent_instance;
	ProgrammingButtonPanelPrivate * priv;
};

struct _ProgrammingButtonPanelClass {
	AdwBreakpointBinClass parent_class;
};

struct _ProgrammingButtonPanelPrivate {
	MathButtons* buttons;
	MathEquation* equation;
	AdwCarousel* carousel;
	GtkWidget* carousel_dots;
	GtkWidget* math_box;
	GtkWidget* basic;
	GtkWidget* advanced;
	GtkGrid* hex_buttons;
	GtkButton* calc_numeric_point_button;
	GtkMenuButton* calc_memory_button;
	GtkMenuButton* calc_function_button;
	GtkButton* calc_inverse_modifier_button;
	GtkButton* calc_base_10_exponential_button;
	GtkButton* calc_base_2_exponential_button;
	GtkMenuButton* calc_base_button;
	GtkMenuButton* calc_word_size_button;
	GtkGrid* bit_panel;
	GList* hex_button_list;
	GList* bit_button_list;
	GtkCssProvider* css_provider;
	gint bit_toggle_separator_width;
	AdwDialog* character_code_dialog;
	AdwEntryRow* character_entry;
	AdwComboRow* convert_to_combo;
	GSimpleActionGroup* action_group;
};

struct _Block4Data {
	int _ref_count_;
	ProgrammingButtonPanel* self;
	gulong carousel_mapped;
};

static gint ProgrammingButtonPanel_private_offset;
static gpointer programming_button_panel_parent_class = NULL;

VALA_EXTERN GType programming_button_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ProgrammingButtonPanel, g_object_unref)
VALA_EXTERN GType math_buttons_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathButtons, g_object_unref)
static void programming_button_panel_on_set_base (ProgrammingButtonPanel* self,
                                           GSimpleAction* action,
                                           GVariant* param);
static void _programming_button_panel_on_set_base_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void programming_button_panel_on_set_word_size (ProgrammingButtonPanel* self,
                                                GSimpleAction* action,
                                                GVariant* param);
static void _programming_button_panel_on_set_word_size_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void programming_button_panel_on_toggle_bit (ProgrammingButtonPanel* self,
                                             GSimpleAction* action,
                                             GVariant* param);
static void _programming_button_panel_on_toggle_bit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void programming_button_panel_on_insert_character (ProgrammingButtonPanel* self);
static void _programming_button_panel_on_insert_character_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN ProgrammingButtonPanel* programming_button_panel_new (MathButtons* buttons);
VALA_EXTERN ProgrammingButtonPanel* programming_button_panel_construct (GType object_type,
                                                            MathButtons* buttons);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN MathEquation* math_buttons_get_equation (MathButtons* self);
static void programming_button_panel_correct_text_direction (ProgrammingButtonPanel* self);
VALA_EXTERN MathVariablePopover* math_variable_popover_new (MathEquation* equation);
VALA_EXTERN MathVariablePopover* math_variable_popover_construct (GType object_type,
                                                      MathEquation* equation);
VALA_EXTERN GType math_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathPopover, g_object_unref)
VALA_EXTERN GType math_variable_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathVariablePopover, g_object_unref)
VALA_EXTERN MathFunctionPopover* math_function_popover_new (MathEquation* equation);
VALA_EXTERN MathFunctionPopover* math_function_popover_construct (GType object_type,
                                                      MathEquation* equation);
VALA_EXTERN GType math_function_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathFunctionPopover, g_object_unref)
static void programming_button_panel_set_bit_panel_wide (ProgrammingButtonPanel* self);
static void __lambda35_ (ProgrammingButtonPanel* self);
static void ___lambda35__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda36_ (Block4Data* _data4_);
static void ___lambda36__gtk_widget_map (GtkWidget* _sender,
                                  gpointer self);
static void programming_button_panel_base_changed_cb (ProgrammingButtonPanel* self);
static void _programming_button_panel_base_changed_cb_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void programming_button_panel_word_size_changed_cb (ProgrammingButtonPanel* self);
static void _programming_button_panel_word_size_changed_cb_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void programming_button_panel_update_bit_panel (ProgrammingButtonPanel* self);
static void _programming_button_panel_update_bit_panel_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void programming_button_panel_real_size_allocate (GtkWidget* base,
                                                  gint width,
                                                  gint height,
                                                  gint baseline);
VALA_EXTERN void math_buttons_set_programming_base (MathButtons* self,
                                        gint value);
static void programming_button_panel_character_entry_changed_cb (ProgrammingButtonPanel* self);
VALA_EXTERN GType button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ButtonMode math_buttons_get_mode (MathButtons* self);
VALA_EXTERN gint math_buttons_get_programming_base (MathButtons* self);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static GVariant* _variant_new4 (const gchar* value);
static GVariant* _variant_new5 (const gchar* value);
static GVariant* _variant_new6 (const gchar* value);
static GVariant* _variant_new7 (const gchar* value);
static GVariant* _variant_new8 (const gchar* value);
static void programming_button_panel_update_hex_button_sensitivities (ProgrammingButtonPanel* self);
static void programming_button_panel_update_bit_button_sensitivities (ProgrammingButtonPanel* self);
static void programming_button_panel_set_bit_panel_narrow (ProgrammingButtonPanel* self);
static void programming_button_panel_move_bit_panel_child (ProgrammingButtonPanel* self,
                                                    gint column,
                                                    gint row,
                                                    gint new_column,
                                                    gint new_row);
static void _programming_button_panel_set_bit_panel_narrow_adw_breakpoint_apply (AdwBreakpoint* _sender,
                                                                          gpointer self);
static void _programming_button_panel_set_bit_panel_wide_adw_breakpoint_unapply (AdwBreakpoint* _sender,
                                                                          gpointer self);
static void _programming_button_panel_character_entry_changed_cb_gtk_editable_changed (GtkEditable* _sender,
                                                                                gpointer self);
static void programming_button_panel_insert_char_code (ProgrammingButtonPanel* self);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
static void _programming_button_panel_insert_char_code_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void programming_button_panel_finalize (GObject * obj);
static GType programming_button_panel_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry PROGRAMMING_BUTTON_PANEL_action_entries[4] = {{"set-base", _programming_button_panel_on_set_base_gsimple_action_activate_callback, "s"}, {"set-word-size", _programming_button_panel_on_set_word_size_gsimple_action_activate_callback, "s"}, {"toggle-bit", _programming_button_panel_on_toggle_bit_gsimple_action_activate_callback, "i"}, {"insert-character", _programming_button_panel_on_insert_character_gsimple_action_activate_callback}};

static inline gpointer
programming_button_panel_get_instance_private (ProgrammingButtonPanel* self)
{
	return G_STRUCT_MEMBER_P (self, ProgrammingButtonPanel_private_offset);
}

static void
_programming_button_panel_on_set_base_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	programming_button_panel_on_set_base ((ProgrammingButtonPanel*) self, action, parameter);
}

static void
_programming_button_panel_on_set_word_size_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	programming_button_panel_on_set_word_size ((ProgrammingButtonPanel*) self, action, parameter);
}

static void
_programming_button_panel_on_toggle_bit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	programming_button_panel_on_toggle_bit ((ProgrammingButtonPanel*) self, action, parameter);
}

static void
_programming_button_panel_on_insert_character_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	programming_button_panel_on_insert_character ((ProgrammingButtonPanel*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ProgrammingButtonPanel* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
__lambda35_ (ProgrammingButtonPanel* self)
{
	AdwCarousel* _tmp0_;
	AdwCarousel* _tmp1_;
	GtkWidget* _tmp2_;
	_tmp0_ = self->priv->carousel;
	_tmp1_ = self->priv->carousel;
	_tmp2_ = adw_carousel_get_nth_page (_tmp1_, (guint) 1);
	adw_carousel_scroll_to (_tmp0_, _tmp2_, FALSE);
}

static void
___lambda35__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda35_ ((ProgrammingButtonPanel*) self);
}

static void
__lambda36_ (Block4Data* _data4_)
{
	ProgrammingButtonPanel* self;
	AdwCarousel* _tmp0_;
	AdwCarousel* _tmp1_;
	GtkWidget* _tmp2_;
	AdwCarousel* _tmp3_;
	self = _data4_->self;
	_tmp0_ = self->priv->carousel;
	_tmp1_ = self->priv->carousel;
	_tmp2_ = adw_carousel_get_nth_page (_tmp1_, (guint) 1);
	adw_carousel_scroll_to (_tmp0_, _tmp2_, FALSE);
	_tmp3_ = self->priv->carousel;
	g_signal_handler_disconnect ((GObject*) _tmp3_, _data4_->carousel_mapped);
}

static void
___lambda36__gtk_widget_map (GtkWidget* _sender,
                             gpointer self)
{
	__lambda36_ (self);
}

static void
_programming_button_panel_base_changed_cb_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	programming_button_panel_base_changed_cb ((ProgrammingButtonPanel*) self);
}

static void
_programming_button_panel_word_size_changed_cb_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	programming_button_panel_word_size_changed_cb ((ProgrammingButtonPanel*) self);
}

static void
_programming_button_panel_update_bit_panel_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	programming_button_panel_update_bit_panel ((ProgrammingButtonPanel*) self);
}

ProgrammingButtonPanel*
programming_button_panel_construct (GType object_type,
                                    MathButtons* buttons)
{
	ProgrammingButtonPanel * self = NULL;
	Block4Data* _data4_;
	MathButtons* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	MathEquation* _tmp3_;
	GSimpleActionGroup* _tmp4_;
	GSimpleActionGroup* _tmp5_;
	GtkButton* _tmp6_;
	MathEquation* _tmp7_;
	Serializer* _tmp8_;
	Serializer* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkMenuButton* _tmp12_;
	MathEquation* _tmp13_;
	MathVariablePopover* _tmp14_;
	MathVariablePopover* _tmp15_;
	GtkMenuButton* _tmp16_;
	MathEquation* _tmp17_;
	MathFunctionPopover* _tmp18_;
	MathFunctionPopover* _tmp19_;
	AdwBreakpoint* _tmp33_;
	AdwBreakpoint* _tmp34_;
	AdwCarousel* _tmp35_;
	gulong _tmp36_;
	GtkButton* _tmp37_;
	GdkDisplay* _tmp38_;
	GtkCssProvider* _tmp39_;
	MathEquation* _tmp40_;
	MathEquation* _tmp41_;
	MathEquation* _tmp42_;
	MathEquation* _tmp43_;
	MathEquation* _tmp44_;
	g_return_val_if_fail (buttons != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	self = (ProgrammingButtonPanel*) g_object_new (object_type, NULL);
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (buttons);
	_g_object_unref0 (self->priv->buttons);
	self->priv->buttons = _tmp0_;
	_tmp1_ = math_buttons_get_equation (buttons);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp3_;
	_tmp4_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp4_, PROGRAMMING_BUTTON_PANEL_action_entries, (gint) G_N_ELEMENTS (PROGRAMMING_BUTTON_PANEL_action_entries), self);
	_tmp5_ = self->priv->action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "cal", (GActionGroup*) _tmp5_);
	programming_button_panel_correct_text_direction (self);
	_tmp6_ = self->priv->calc_numeric_point_button;
	_tmp7_ = self->priv->equation;
	_tmp8_ = math_equation_get_serializer (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_unichar_to_string (serializer_get_radix (_tmp9_));
	_tmp11_ = _tmp10_;
	gtk_button_set_label (_tmp6_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->calc_memory_button;
	_tmp13_ = self->priv->equation;
	_tmp14_ = math_variable_popover_new (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	gtk_menu_button_set_popover (_tmp12_, (GtkPopover*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->calc_function_button;
	_tmp17_ = self->priv->equation;
	_tmp18_ = math_function_popover_new (_tmp17_);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gtk_menu_button_set_popover (_tmp16_, (GtkPopover*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	{
		gint row = 0;
		row = 2;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = row;
					row = _tmp21_ - 1;
				}
				_tmp20_ = FALSE;
				if (!(row >= 0)) {
					break;
				}
				{
					gint column = 0;
					column = 0;
					{
						gboolean _tmp22_ = FALSE;
						_tmp22_ = TRUE;
						while (TRUE) {
							GtkGrid* _tmp24_;
							GtkWidget* _tmp25_;
							GtkButton* _tmp26_;
							if (!_tmp22_) {
								gint _tmp23_;
								_tmp23_ = column;
								column = _tmp23_ + 1;
							}
							_tmp22_ = FALSE;
							if (!(column <= 4)) {
								break;
							}
							_tmp24_ = self->priv->hex_buttons;
							_tmp25_ = gtk_grid_get_child_at (_tmp24_, column, row);
							_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, gtk_button_get_type ()) ? ((GtkButton*) _tmp25_) : NULL);
							self->priv->hex_button_list = g_list_append (self->priv->hex_button_list, _tmp26_);
						}
					}
				}
			}
		}
	}
	{
		gint row = 0;
		row = 6;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				if (!_tmp27_) {
					row -= 2;
				}
				_tmp27_ = FALSE;
				if (!(row >= 0)) {
					break;
				}
				{
					gint column = 0;
					column = 17;
					{
						gboolean _tmp28_ = FALSE;
						_tmp28_ = TRUE;
						while (TRUE) {
							GtkGrid* _tmp30_;
							GtkWidget* _tmp31_;
							GtkButton* _tmp32_;
							if (!_tmp28_) {
								gint _tmp29_;
								_tmp29_ = column;
								column = _tmp29_ - 1;
							}
							_tmp28_ = FALSE;
							if (!(column >= 2)) {
								break;
							}
							_tmp30_ = self->priv->bit_panel;
							_tmp31_ = gtk_grid_get_child_at (_tmp30_, column, row);
							_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_button_get_type ()) ? ((GtkButton*) _tmp31_) : NULL);
							self->priv->bit_button_list = g_list_append (self->priv->bit_button_list, _tmp32_);
						}
					}
				}
			}
		}
	}
	_tmp33_ = adw_breakpoint_bin_get_current_breakpoint ((AdwBreakpointBin*) self);
	_tmp34_ = _tmp33_;
	if (_tmp34_ == NULL) {
		programming_button_panel_set_bit_panel_wide (self);
	}
	g_signal_connect_object ((GObject*) buttons, "notify::mode", (GCallback) ___lambda35__g_object_notify, self, 0);
	_data4_->carousel_mapped = (gulong) 0;
	_tmp35_ = self->priv->carousel;
	_tmp36_ = g_signal_connect_data ((GtkWidget*) _tmp35_, "map", (GCallback) ___lambda36__gtk_widget_map, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_data4_->carousel_mapped = _tmp36_;
	_tmp37_ = self->priv->calc_inverse_modifier_button;
	g_object_bind_property_with_closures ((GObject*) buttons, "inverse", (GObject*) _tmp37_, "active", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp38_ = gdk_display_get_default ();
	_tmp39_ = self->priv->css_provider;
	gtk_style_context_add_provider_for_display (_tmp38_, (GtkStyleProvider*) _tmp39_, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_tmp40_ = self->priv->equation;
	g_signal_connect_object ((GObject*) _tmp40_, "notify::number-base", (GCallback) _programming_button_panel_base_changed_cb_g_object_notify, self, 0);
	_tmp41_ = self->priv->equation;
	g_signal_connect_object ((GObject*) _tmp41_, "notify::word-size", (GCallback) _programming_button_panel_word_size_changed_cb_g_object_notify, self, 0);
	_tmp42_ = self->priv->equation;
	g_signal_connect_object ((GObject*) _tmp42_, "notify::display", (GCallback) _programming_button_panel_update_bit_panel_g_object_notify, self, 0);
	_tmp43_ = self->priv->equation;
	g_signal_connect_object ((GObject*) _tmp43_, "notify::angle-units", (GCallback) _programming_button_panel_update_bit_panel_g_object_notify, self, 0);
	_tmp44_ = self->priv->equation;
	g_signal_connect_object ((GObject*) _tmp44_, "notify::number-format", (GCallback) _programming_button_panel_update_bit_panel_g_object_notify, self, 0);
	programming_button_panel_base_changed_cb (self);
	programming_button_panel_word_size_changed_cb (self);
	programming_button_panel_update_bit_panel (self);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}

ProgrammingButtonPanel*
programming_button_panel_new (MathButtons* buttons)
{
	return programming_button_panel_construct (TYPE_PROGRAMMING_BUTTON_PANEL, buttons);
}

static void
programming_button_panel_correct_text_direction (ProgrammingButtonPanel* self)
{
	AdwCarousel* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	gtk_widget_set_direction ((GtkWidget*) _tmp0_, GTK_TEXT_DIR_LTR);
	_tmp1_ = self->priv->carousel_dots;
	gtk_widget_set_direction (_tmp1_, GTK_TEXT_DIR_LTR);
	_tmp2_ = self->priv->math_box;
	gtk_widget_set_direction (_tmp2_, GTK_TEXT_DIR_LTR);
	_tmp3_ = self->priv->basic;
	gtk_widget_set_direction (_tmp3_, GTK_TEXT_DIR_LTR);
	_tmp4_ = self->priv->advanced;
	gtk_widget_set_direction (_tmp4_, GTK_TEXT_DIR_LTR);
	_tmp5_ = self->priv->hex_buttons;
	gtk_widget_set_direction ((GtkWidget*) _tmp5_, GTK_TEXT_DIR_LTR);
	_tmp6_ = self->priv->bit_panel;
	gtk_widget_set_direction ((GtkWidget*) _tmp6_, GTK_TEXT_DIR_LTR);
	{
		gint row = 0;
		row = 1;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GtkGrid* _tmp8_;
				GtkWidget* _tmp9_;
				GtkGrid* _tmp10_;
				GtkWidget* _tmp11_;
				if (!_tmp7_) {
					row += 2;
				}
				_tmp7_ = FALSE;
				if (!(row <= 7)) {
					break;
				}
				_tmp8_ = self->priv->bit_panel;
				_tmp9_ = gtk_grid_get_child_at (_tmp8_, 2, row);
				gtk_widget_set_direction (_tmp9_, GTK_TEXT_DIR_LTR);
				_tmp10_ = self->priv->bit_panel;
				_tmp11_ = gtk_grid_get_child_at (_tmp10_, 16, row);
				gtk_widget_set_direction (_tmp11_, GTK_TEXT_DIR_LTR);
			}
		}
	}
}

static void
programming_button_panel_real_size_allocate (GtkWidget* base,
                                             gint width,
                                             gint height,
                                             gint baseline)
{
	ProgrammingButtonPanel * self;
	self = (ProgrammingButtonPanel*) base;
	GTK_WIDGET_CLASS (programming_button_panel_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_breakpoint_bin_get_type (), AdwBreakpointBin), width, height, baseline);
	if (self->priv->bit_toggle_separator_width != (width / 40)) {
		GtkCssProvider* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		self->priv->bit_toggle_separator_width = width / 40;
		_tmp0_ = self->priv->css_provider;
		_tmp1_ = g_strdup_printf ("\n" \
"            .math-buttons .bit-toggle-separator {\n" \
"                margin-right: %dpx;\n" \
"            }\n" \
"            ", self->priv->bit_toggle_separator_width);
		_tmp2_ = _tmp1_;
		gtk_css_provider_load_from_string (_tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
	}
}

static void
programming_button_panel_on_set_base (ProgrammingButtonPanel* self,
                                      GSimpleAction* action,
                                      GVariant* param)
{
	MathButtons* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->buttons;
	_tmp1_ = g_variant_get_string (param, NULL);
	math_buttons_set_programming_base (_tmp0_, atoi (_tmp1_));
}

static void
programming_button_panel_on_set_word_size (ProgrammingButtonPanel* self,
                                           GSimpleAction* action,
                                           GVariant* param)
{
	MathEquation* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = g_variant_get_string (param, NULL);
	math_equation_set_word_size (_tmp0_, atoi (_tmp1_));
}

static void
programming_button_panel_on_toggle_bit (ProgrammingButtonPanel* self,
                                        GSimpleAction* action,
                                        GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_toggle_bit (_tmp0_, (guint) g_variant_get_int32 (param));
}

static void
programming_button_panel_on_insert_character (ProgrammingButtonPanel* self)
{
	AdwDialog* _tmp0_;
	AdwEntryRow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	adw_dialog_present (_tmp0_, (GtkWidget*) self);
	_tmp1_ = self->priv->character_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	programming_button_panel_character_entry_changed_cb (self);
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new3 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new4 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new5 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new6 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new7 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new8 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
programming_button_panel_base_changed_cb (ProgrammingButtonPanel* self)
{
	MathButtons* _tmp0_;
	ButtonMode _tmp1_;
	ButtonMode _tmp2_;
	MathButtons* _tmp3_;
	MathEquation* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	MathButtons* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->buttons;
	_tmp1_ = math_buttons_get_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != BUTTON_MODE_PROGRAMMING) {
		return;
	}
	_tmp3_ = self->priv->buttons;
	_tmp4_ = self->priv->equation;
	_tmp5_ = math_equation_get_number_base (_tmp4_);
	_tmp6_ = _tmp5_;
	math_buttons_set_programming_base (_tmp3_, _tmp6_);
	_tmp7_ = self->priv->buttons;
	_tmp8_ = math_buttons_get_programming_base (_tmp7_);
	_tmp9_ = _tmp8_;
	switch (_tmp9_) {
		case 2:
		{
			GtkMenuButton* _tmp10_;
			GtkButton* _tmp11_;
			GVariant* _tmp12_;
			GtkButton* _tmp13_;
			GVariant* _tmp14_;
			_tmp10_ = self->priv->calc_base_button;
			gtk_menu_button_set_label (_tmp10_, _ ("Binary"));
			_tmp11_ = self->priv->calc_base_10_exponential_button;
			_tmp12_ = _variant_new1 ("1010");
			g_object_set ((GtkActionable*) _tmp11_, "action-target", _tmp12_, NULL);
			_g_variant_unref0 (_tmp12_);
			_tmp13_ = self->priv->calc_base_2_exponential_button;
			_tmp14_ = _variant_new2 ("10");
			g_object_set ((GtkActionable*) _tmp13_, "action-target", _tmp14_, NULL);
			_g_variant_unref0 (_tmp14_);
			break;
		}
		case 8:
		{
			GtkMenuButton* _tmp15_;
			GtkButton* _tmp16_;
			GVariant* _tmp17_;
			GtkButton* _tmp18_;
			GVariant* _tmp19_;
			_tmp15_ = self->priv->calc_base_button;
			gtk_menu_button_set_label (_tmp15_, _ ("Octal"));
			_tmp16_ = self->priv->calc_base_10_exponential_button;
			_tmp17_ = _variant_new3 ("12");
			g_object_set ((GtkActionable*) _tmp16_, "action-target", _tmp17_, NULL);
			_g_variant_unref0 (_tmp17_);
			_tmp18_ = self->priv->calc_base_2_exponential_button;
			_tmp19_ = _variant_new4 ("2");
			g_object_set ((GtkActionable*) _tmp18_, "action-target", _tmp19_, NULL);
			_g_variant_unref0 (_tmp19_);
			break;
		}
		case 10:
		{
			GtkMenuButton* _tmp20_;
			GtkButton* _tmp21_;
			GVariant* _tmp22_;
			GtkButton* _tmp23_;
			GVariant* _tmp24_;
			_tmp20_ = self->priv->calc_base_button;
			gtk_menu_button_set_label (_tmp20_, _ ("Decimal"));
			_tmp21_ = self->priv->calc_base_10_exponential_button;
			_tmp22_ = _variant_new5 ("10");
			g_object_set ((GtkActionable*) _tmp21_, "action-target", _tmp22_, NULL);
			_g_variant_unref0 (_tmp22_);
			_tmp23_ = self->priv->calc_base_2_exponential_button;
			_tmp24_ = _variant_new6 ("2");
			g_object_set ((GtkActionable*) _tmp23_, "action-target", _tmp24_, NULL);
			_g_variant_unref0 (_tmp24_);
			break;
		}
		case 16:
		{
			GtkMenuButton* _tmp25_;
			GtkButton* _tmp26_;
			GVariant* _tmp27_;
			GtkButton* _tmp28_;
			GVariant* _tmp29_;
			_tmp25_ = self->priv->calc_base_button;
			gtk_menu_button_set_label (_tmp25_, _ ("Hexadecimal"));
			_tmp26_ = self->priv->calc_base_10_exponential_button;
			_tmp27_ = _variant_new7 ("A");
			g_object_set ((GtkActionable*) _tmp26_, "action-target", _tmp27_, NULL);
			_g_variant_unref0 (_tmp27_);
			_tmp28_ = self->priv->calc_base_2_exponential_button;
			_tmp29_ = _variant_new8 ("2");
			g_object_set ((GtkActionable*) _tmp28_, "action-target", _tmp29_, NULL);
			_g_variant_unref0 (_tmp29_);
			break;
		}
		default:
		break;
	}
	programming_button_panel_update_bit_panel (self);
	programming_button_panel_update_hex_button_sensitivities (self);
}

static void
programming_button_panel_update_hex_button_sensitivities (ProgrammingButtonPanel* self)
{
	gint i = 0;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	i = 1;
	_tmp0_ = self->priv->hex_button_list;
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp0_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			GtkButton* _tmp1_;
			GtkButton* button = NULL;
			_tmp1_ = _g_object_ref0 ((GtkButton*) button_it->data);
			button = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				MathButtons* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GtkButton* _tmp6_;
				gint _tmp7_;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = math_buttons_get_programming_base (_tmp3_);
				_tmp5_ = _tmp4_;
				if (i < _tmp5_) {
					_tmp2_ = "cal.insert-digit";
				} else {
					_tmp2_ = NULL;
				}
				_tmp6_ = button;
				gtk_actionable_set_action_name ((GtkActionable*) _tmp6_, _tmp2_);
				_tmp7_ = i;
				i = _tmp7_ + 1;
				_g_object_unref0 (button);
			}
		}
	}
}

static void
programming_button_panel_word_size_changed_cb (ProgrammingButtonPanel* self)
{
	gint size = 0;
	MathEquation* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* format = NULL;
	gchar* _tmp3_;
	GtkMenuButton* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_word_size (_tmp0_);
	_tmp2_ = _tmp1_;
	size = _tmp2_;
	_tmp3_ = g_strdup (ngettext ("%d-bit", "%d-bit", (gulong) size));
	format = _tmp3_;
	_tmp4_ = self->priv->calc_word_size_button;
	_tmp5_ = g_strdup_printf (format, size);
	_tmp6_ = _tmp5_;
	gtk_menu_button_set_label (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	programming_button_panel_update_bit_panel (self);
	programming_button_panel_update_bit_button_sensitivities (self);
	_g_free0 (format);
}

static void
programming_button_panel_update_bit_button_sensitivities (ProgrammingButtonPanel* self)
{
	gint i = 0;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	i = 0;
	_tmp0_ = self->priv->bit_button_list;
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp0_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			GtkButton* _tmp1_;
			GtkButton* button = NULL;
			_tmp1_ = _g_object_ref0 ((GtkButton*) button_it->data);
			button = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				MathEquation* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GtkButton* _tmp6_;
				gint _tmp7_;
				_tmp3_ = self->priv->equation;
				_tmp4_ = math_equation_get_word_size (_tmp3_);
				_tmp5_ = _tmp4_;
				if (i < _tmp5_) {
					_tmp2_ = "cal.toggle-bit";
				} else {
					_tmp2_ = NULL;
				}
				_tmp6_ = button;
				gtk_actionable_set_action_name ((GtkActionable*) _tmp6_, _tmp2_);
				_tmp7_ = i;
				i = _tmp7_ + 1;
				_g_object_unref0 (button);
			}
		}
	}
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static void
programming_button_panel_update_bit_panel (ProgrammingButtonPanel* self)
{
	Number* x = NULL;
	MathEquation* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	guint64 bits = 0ULL;
	gboolean _tmp3_ = FALSE;
	Number* _tmp4_;
	gboolean enabled = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean is_float = FALSE;
	GtkGrid* _tmp19_;
	gint i = 0;
	GList* _tmp21_;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	gchar* sign = NULL;
	gchar* _tmp54_;
	Number* _tmp55_;
	gchar* base_label = NULL;
	gchar* _tmp57_;
	MathEquation* _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	MathEquation* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	MathEquation* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	MathEquation* _tmp82_;
	const gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number (_tmp0_);
	_tmp2_ = _tmp1_;
	x = _tmp2_;
	bits = (guint64) 0;
	_tmp4_ = x;
	if (_tmp4_ != NULL) {
		Number* _tmp5_;
		_tmp5_ = x;
		_tmp3_ = !number_is_complex (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	enabled = _tmp3_;
	if (enabled) {
		Number* _tmp7_;
		_tmp7_ = x;
		_tmp6_ = number_is_float (_tmp7_);
	} else {
		_tmp6_ = FALSE;
	}
	is_float = _tmp6_;
	if (enabled) {
		if (is_float) {
			MathEquation* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			_tmp8_ = self->priv->equation;
			_tmp9_ = math_equation_get_word_size (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == 64) {
				gdouble d = 0.0;
				Number* _tmp11_;
				_tmp11_ = x;
				d = number_to_double (_tmp11_);
				bits = *((guint64*) (&d));
			} else {
				MathEquation* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp12_ = self->priv->equation;
				_tmp13_ = math_equation_get_word_size (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == 32) {
					gfloat f = 0.0F;
					Number* _tmp15_;
					_tmp15_ = x;
					f = number_to_float (_tmp15_);
					bits = (guint64) (*((guint32*) (&f)));
				} else {
					enabled = FALSE;
				}
			}
		} else {
			Number* _tmp16_;
			_tmp16_ = x;
			if (number_is_negative (_tmp16_)) {
				Number* _tmp17_;
				_tmp17_ = x;
				bits = (guint64) number_to_integer (_tmp17_);
			} else {
				Number* _tmp18_;
				_tmp18_ = x;
				bits = number_to_unsigned_integer (_tmp18_);
			}
		}
	}
	_tmp19_ = self->priv->bit_panel;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, enabled);
	if (!enabled) {
		MathEquation* _tmp20_;
		_tmp20_ = self->priv->equation;
		math_equation_set_base_label (_tmp20_, "");
		_g_object_unref0 (x);
		return;
	}
	i = 0;
	_tmp21_ = self->priv->bit_button_list;
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp21_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			GtkButton* _tmp22_;
			GtkButton* button = NULL;
			_tmp22_ = _g_object_ref0 ((GtkButton*) button_it->data);
			button = _tmp22_;
			{
				gchar* text = NULL;
				gchar* _tmp23_;
				GtkButton* _tmp25_;
				const gchar* _tmp26_;
				gint _tmp44_;
				_tmp23_ = g_strdup ("0");
				text = _tmp23_;
				if ((bits & (1ULL << i)) != ((guint64) 0)) {
					gchar* _tmp24_;
					_tmp24_ = g_strdup ("1");
					_g_free0 (text);
					text = _tmp24_;
				}
				_tmp25_ = button;
				_tmp26_ = text;
				gtk_button_set_label (_tmp25_, _tmp26_);
				if (i >= 52) {
					gboolean _tmp27_ = FALSE;
					if (is_float) {
						MathEquation* _tmp28_;
						gint _tmp29_;
						gint _tmp30_;
						_tmp28_ = self->priv->equation;
						_tmp29_ = math_equation_get_word_size (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp27_ = _tmp30_ == 64;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						const gchar* _tmp31_ = NULL;
						GtkButton* _tmp32_;
						if (i < 63) {
							_tmp31_ = "accent";
						} else {
							_tmp31_ = "dimmed";
						}
						_tmp32_ = button;
						gtk_widget_add_css_class ((GtkWidget*) _tmp32_, _tmp31_);
					} else {
						const gchar* _tmp33_ = NULL;
						GtkButton* _tmp34_;
						if (i < 63) {
							_tmp33_ = "accent";
						} else {
							_tmp33_ = "dimmed";
						}
						_tmp34_ = button;
						gtk_widget_remove_css_class ((GtkWidget*) _tmp34_, _tmp33_);
					}
				} else {
					gboolean _tmp35_ = FALSE;
					if (i >= 23) {
						_tmp35_ = i <= 31;
					} else {
						_tmp35_ = FALSE;
					}
					if (_tmp35_) {
						gboolean _tmp36_ = FALSE;
						if (is_float) {
							MathEquation* _tmp37_;
							gint _tmp38_;
							gint _tmp39_;
							_tmp37_ = self->priv->equation;
							_tmp38_ = math_equation_get_word_size (_tmp37_);
							_tmp39_ = _tmp38_;
							_tmp36_ = _tmp39_ == 32;
						} else {
							_tmp36_ = FALSE;
						}
						if (_tmp36_) {
							const gchar* _tmp40_ = NULL;
							GtkButton* _tmp41_;
							if (i < 31) {
								_tmp40_ = "accent";
							} else {
								_tmp40_ = "dimmed";
							}
							_tmp41_ = button;
							gtk_widget_add_css_class ((GtkWidget*) _tmp41_, _tmp40_);
						} else {
							const gchar* _tmp42_ = NULL;
							GtkButton* _tmp43_;
							if (i < 31) {
								_tmp42_ = "accent";
							} else {
								_tmp42_ = "dimmed";
							}
							_tmp43_ = button;
							gtk_widget_remove_css_class ((GtkWidget*) _tmp43_, _tmp42_);
						}
					}
				}
				_tmp44_ = i;
				i = _tmp44_ + 1;
				_g_free0 (text);
				_g_object_unref0 (button);
			}
		}
	}
	if (is_float) {
		_tmp46_ = TRUE;
	} else {
		MathEquation* _tmp47_;
		gboolean _tmp48_;
		gboolean _tmp49_;
		_tmp47_ = self->priv->equation;
		_tmp48_ = math_equation_get_is_empty (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp46_ = _tmp49_;
	}
	if (_tmp46_) {
		_tmp45_ = TRUE;
	} else {
		MathEquation* _tmp50_;
		gboolean _tmp51_;
		gboolean _tmp52_;
		_tmp50_ = self->priv->equation;
		_tmp51_ = math_equation_get_is_sign_radix (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp45_ = _tmp52_;
	}
	if (_tmp45_) {
		MathEquation* _tmp53_;
		_tmp53_ = self->priv->equation;
		math_equation_set_base_label (_tmp53_, "");
		_g_object_unref0 (x);
		return;
	}
	_tmp54_ = g_strdup ("");
	sign = _tmp54_;
	_tmp55_ = x;
	if (number_is_negative (_tmp55_)) {
		gchar* _tmp56_;
		_tmp56_ = g_strdup ("−");
		_g_free0 (sign);
		sign = _tmp56_;
		bits = (~bits) + 1;
	}
	_tmp57_ = g_strdup ("\u200E");
	base_label = _tmp57_;
	_tmp58_ = self->priv->equation;
	_tmp59_ = math_equation_get_number_base (_tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_ != 8) {
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		_tmp61_ = base_label;
		_tmp62_ = sign;
		_tmp63_ = g_strdup_printf ("%s%llo₈ ", _tmp62_, bits);
		_tmp64_ = _tmp63_;
		_tmp65_ = g_strconcat (_tmp61_, _tmp64_, NULL);
		_g_free0 (base_label);
		base_label = _tmp65_;
		_g_free0 (_tmp64_);
	}
	_tmp66_ = self->priv->equation;
	_tmp67_ = math_equation_get_number_base (_tmp66_);
	_tmp68_ = _tmp67_;
	if (_tmp68_ != 10) {
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		_tmp69_ = base_label;
		_tmp70_ = sign;
		_tmp71_ = g_strdup_printf ("%s%llu₁₀ ", _tmp70_, bits);
		_tmp72_ = _tmp71_;
		_tmp73_ = g_strconcat (_tmp69_, _tmp72_, NULL);
		_g_free0 (base_label);
		base_label = _tmp73_;
		_g_free0 (_tmp72_);
	}
	_tmp74_ = self->priv->equation;
	_tmp75_ = math_equation_get_number_base (_tmp74_);
	_tmp76_ = _tmp75_;
	if (_tmp76_ != 16) {
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		_tmp77_ = base_label;
		_tmp78_ = sign;
		_tmp79_ = g_strdup_printf ("%s%llX₁₆", _tmp78_, bits);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strconcat (_tmp77_, _tmp80_, NULL);
		_g_free0 (base_label);
		base_label = _tmp81_;
		_g_free0 (_tmp80_);
	}
	_tmp82_ = self->priv->equation;
	_tmp83_ = base_label;
	_tmp84_ = string_chomp (_tmp83_);
	_tmp85_ = _tmp84_;
	math_equation_set_base_label (_tmp82_, _tmp85_);
	_g_free0 (_tmp85_);
	_g_free0 (base_label);
	_g_free0 (sign);
	_g_object_unref0 (x);
}

static void
programming_button_panel_set_bit_panel_narrow (ProgrammingButtonPanel* self)
{
	GtkGrid* _tmp0_;
	GtkWidget* _tmp1_;
	GtkGrid* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	programming_button_panel_move_bit_panel_child (self, 0, 0, 2, 1);
	programming_button_panel_move_bit_panel_child (self, 18, 0, 2, 3);
	programming_button_panel_move_bit_panel_child (self, 0, 4, 2, 5);
	programming_button_panel_move_bit_panel_child (self, 18, 4, 2, 7);
	_tmp0_ = self->priv->bit_panel;
	_tmp1_ = gtk_grid_get_child_at (_tmp0_, 16, 1);
	gtk_widget_set_visible (_tmp1_, TRUE);
	programming_button_panel_move_bit_panel_child (self, 36, 0, 16, 3);
	_tmp2_ = self->priv->bit_panel;
	_tmp3_ = gtk_grid_get_child_at (_tmp2_, 16, 5);
	gtk_widget_set_visible (_tmp3_, TRUE);
	programming_button_panel_move_bit_panel_child (self, 36, 4, 16, 7);
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i <= 17)) {
					break;
				}
				programming_button_panel_move_bit_panel_child (self, i + 18, 0, i, 2);
				programming_button_panel_move_bit_panel_child (self, i + 18, 4, i, 6);
			}
		}
	}
}

static void
_programming_button_panel_set_bit_panel_narrow_adw_breakpoint_apply (AdwBreakpoint* _sender,
                                                                     gpointer self)
{
	programming_button_panel_set_bit_panel_narrow ((ProgrammingButtonPanel*) self);
}

static void
programming_button_panel_set_bit_panel_wide (ProgrammingButtonPanel* self)
{
	GtkGrid* _tmp0_;
	GtkWidget* _tmp1_;
	GtkGrid* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	programming_button_panel_move_bit_panel_child (self, 2, 1, 0, 0);
	programming_button_panel_move_bit_panel_child (self, 2, 3, 18, 0);
	programming_button_panel_move_bit_panel_child (self, 2, 5, 0, 4);
	programming_button_panel_move_bit_panel_child (self, 2, 7, 18, 4);
	_tmp0_ = self->priv->bit_panel;
	_tmp1_ = gtk_grid_get_child_at (_tmp0_, 16, 1);
	gtk_widget_set_visible (_tmp1_, FALSE);
	programming_button_panel_move_bit_panel_child (self, 16, 3, 36, 0);
	_tmp2_ = self->priv->bit_panel;
	_tmp3_ = gtk_grid_get_child_at (_tmp2_, 16, 5);
	gtk_widget_set_visible (_tmp3_, FALSE);
	programming_button_panel_move_bit_panel_child (self, 16, 7, 36, 4);
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i <= 17)) {
					break;
				}
				programming_button_panel_move_bit_panel_child (self, i, 2, i + 18, 0);
				programming_button_panel_move_bit_panel_child (self, i, 6, i + 18, 4);
			}
		}
	}
}

static void
_programming_button_panel_set_bit_panel_wide_adw_breakpoint_unapply (AdwBreakpoint* _sender,
                                                                     gpointer self)
{
	programming_button_panel_set_bit_panel_wide ((ProgrammingButtonPanel*) self);
}

static void
programming_button_panel_move_bit_panel_child (ProgrammingButtonPanel* self,
                                               gint column,
                                               gint row,
                                               gint new_column,
                                               gint new_row)
{
	GtkWidget* child = NULL;
	GtkGrid* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkGridLayoutChild* layout = NULL;
	GtkGrid* _tmp3_;
	GtkLayoutManager* _tmp4_;
	GtkLayoutManager* _tmp5_;
	GtkLayoutChild* _tmp6_;
	GtkGridLayoutChild* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bit_panel;
	_tmp1_ = gtk_grid_get_child_at (_tmp0_, column, row);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	child = _tmp2_;
	_tmp3_ = self->priv->bit_panel;
	_tmp4_ = gtk_widget_get_layout_manager ((GtkWidget*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_layout_manager_get_layout_child (_tmp5_, child);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_grid_layout_child_get_type ()) ? ((GtkGridLayoutChild*) _tmp6_) : NULL);
	layout = _tmp7_;
	gtk_grid_layout_child_set_column (layout, new_column);
	gtk_grid_layout_child_set_row (layout, new_row);
	_g_object_unref0 (layout);
	_g_object_unref0 (child);
}

static void
programming_button_panel_character_entry_changed_cb (ProgrammingButtonPanel* self)
{
	AdwDialog* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	AdwEntryRow* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	_tmp1_ = adw_dialog_get_default_widget (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->character_entry;
	_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive (_tmp2_, g_strcmp0 (_tmp5_, "") != 0);
}

static void
_programming_button_panel_character_entry_changed_cb_gtk_editable_changed (GtkEditable* _sender,
                                                                           gpointer self)
{
	programming_button_panel_character_entry_changed_cb ((ProgrammingButtonPanel*) self);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
programming_button_panel_insert_char_code (ProgrammingButtonPanel* self)
{
	gchar* text = NULL;
	AdwEntryRow* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	AdwComboRow* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	AdwDialog* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->character_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	text = _tmp3_;
	_tmp4_ = self->priv->convert_to_combo;
	_tmp5_ = adw_combo_row_get_selected (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == ((guint) 0)) {
		MathEquation* _tmp7_;
		const gchar* _tmp8_;
		Number* _tmp9_;
		Number* _tmp10_;
		_tmp7_ = self->priv->equation;
		_tmp8_ = text;
		_tmp9_ = number_new_integer ((gint64) string_get_char (_tmp8_, (glong) 0), (gint64) 0);
		_tmp10_ = _tmp9_;
		math_equation_insert_number (_tmp7_, _tmp10_);
		_g_object_unref0 (_tmp10_);
	} else {
		AdwComboRow* _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
		_tmp11_ = self->priv->convert_to_combo;
		_tmp12_ = adw_combo_row_get_selected (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == ((guint) 1)) {
			Number* x = NULL;
			Number* _tmp14_;
			guint8* decoded = NULL;
			const gchar* _tmp15_;
			guint8* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_ = 0;
			guint8* _tmp18_;
			gint _tmp18__length1;
			guint8* _tmp19_;
			gint _tmp19__length1;
			gint decoded_length1;
			gint _decoded_size_;
			gint len = 0;
			guint8* _tmp20_;
			gint _tmp20__length1;
			MathEquation* _tmp33_;
			Number* _tmp34_;
			_tmp14_ = number_new_integer ((gint64) 0, (gint64) 0);
			x = _tmp14_;
			_tmp15_ = text;
			_tmp16_ = string_get_data (_tmp15_, &_tmp17_);
			_tmp16__length1 = _tmp17_;
			_tmp18_ = _tmp16_;
			_tmp18__length1 = _tmp16__length1;
			_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup3 (_tmp18_, _tmp18__length1) : _tmp18_;
			_tmp19__length1 = _tmp18__length1;
			decoded = _tmp19_;
			decoded_length1 = _tmp19__length1;
			_decoded_size_ = decoded_length1;
			_tmp20_ = decoded;
			_tmp20__length1 = decoded_length1;
			len = _tmp20__length1;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp21_ = FALSE;
					_tmp21_ = TRUE;
					while (TRUE) {
						Number* _tmp23_;
						guint8* _tmp24_;
						gint _tmp24__length1;
						guint8 _tmp25_;
						Number* _tmp26_;
						Number* _tmp27_;
						Number* _tmp28_;
						if (!_tmp21_) {
							gint _tmp22_;
							_tmp22_ = i;
							i = _tmp22_ + 1;
						}
						_tmp21_ = FALSE;
						if (!(i < len)) {
							break;
						}
						_tmp23_ = x;
						_tmp24_ = decoded;
						_tmp24__length1 = decoded_length1;
						_tmp25_ = _tmp24_[i];
						_tmp26_ = number_new_integer ((gint64) _tmp25_, (gint64) 0);
						_tmp27_ = _tmp26_;
						_tmp28_ = number_add (_tmp23_, _tmp27_);
						_g_object_unref0 (x);
						x = _tmp28_;
						_g_object_unref0 (_tmp27_);
						if (i != (len - 1)) {
							Number* _tmp29_;
							Number* _tmp30_;
							Number* _tmp31_;
							Number* _tmp32_;
							_tmp29_ = x;
							_tmp30_ = number_new_integer ((gint64) 8, (gint64) 0);
							_tmp31_ = _tmp30_;
							_tmp32_ = number_left_shift (_tmp29_, _tmp31_, 64);
							_g_object_unref0 (x);
							x = _tmp32_;
							_g_object_unref0 (_tmp31_);
						}
					}
				}
			}
			_tmp33_ = self->priv->equation;
			_tmp34_ = x;
			math_equation_insert_number (_tmp33_, _tmp34_);
			decoded = (g_free (decoded), NULL);
			_g_object_unref0 (x);
		} else {
			guint c = 0U;
			const gchar* _tmp35_;
			MathEquation* _tmp36_;
			Number* _tmp37_;
			Number* _tmp38_;
			_tmp35_ = text;
			c = (guint) string_get_char (_tmp35_, (glong) 0);
			if (c >= ((guint) 0x10000)) {
				c -= (guint) 0x10000;
				c = (((c >> 10) + 0xD800) << 16) + ((c & 0x03FF) + 0xDC00);
			}
			_tmp36_ = self->priv->equation;
			_tmp37_ = number_new_integer ((gint64) c, (gint64) 0);
			_tmp38_ = _tmp37_;
			math_equation_insert_number (_tmp36_, _tmp38_);
			_g_object_unref0 (_tmp38_);
		}
	}
	_tmp39_ = self->priv->character_code_dialog;
	adw_dialog_close (_tmp39_);
	_g_free0 (text);
}

static void
_programming_button_panel_insert_char_code_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	programming_button_panel_insert_char_code ((ProgrammingButtonPanel*) self);
}

static void
programming_button_panel_class_init (ProgrammingButtonPanelClass * klass,
                                     gpointer klass_data)
{
	programming_button_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ProgrammingButtonPanel_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) programming_button_panel_real_size_allocate;
	G_OBJECT_CLASS (klass)->finalize = programming_button_panel_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/buttons-programming.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "carousel", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, carousel));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "carousel_dots", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, carousel_dots));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "math_box", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, math_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "basic", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, basic));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "advanced", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, advanced));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hex_buttons", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, hex_buttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "calc_numeric_point_button", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, calc_numeric_point_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "calc_memory_button", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, calc_memory_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "calc_function_button", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, calc_function_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "calc_inverse_modifier_button", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, calc_inverse_modifier_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "calc_base_10_exponential_button", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, calc_base_10_exponential_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "calc_base_2_exponential_button", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, calc_base_2_exponential_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "calc_base_button", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, calc_base_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "calc_word_size_button", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, calc_word_size_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bit_panel", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, bit_panel));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "character_code_dialog", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, character_code_dialog));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "character_entry", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, character_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "convert_to_combo", FALSE, ProgrammingButtonPanel_private_offset + G_STRUCT_OFFSET (ProgrammingButtonPanelPrivate, convert_to_combo));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "set_bit_panel_narrow", G_CALLBACK(_programming_button_panel_set_bit_panel_narrow_adw_breakpoint_apply));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "set_bit_panel_wide", G_CALLBACK(_programming_button_panel_set_bit_panel_wide_adw_breakpoint_unapply));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "character_entry_changed_cb", G_CALLBACK(_programming_button_panel_character_entry_changed_cb_gtk_editable_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "insert_char_code", G_CALLBACK(_programming_button_panel_insert_char_code_gtk_button_clicked));
}

static void
programming_button_panel_instance_init (ProgrammingButtonPanel * self,
                                        gpointer klass)
{
	GtkCssProvider* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	self->priv = programming_button_panel_get_instance_private (self);
	self->priv->hex_button_list = NULL;
	self->priv->bit_button_list = NULL;
	_tmp0_ = gtk_css_provider_new ();
	self->priv->css_provider = _tmp0_;
	self->priv->bit_toggle_separator_width = 9;
	_tmp1_ = g_simple_action_group_new ();
	self->priv->action_group = _tmp1_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
programming_button_panel_finalize (GObject * obj)
{
	ProgrammingButtonPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROGRAMMING_BUTTON_PANEL, ProgrammingButtonPanel);
	_g_object_unref0 (self->priv->buttons);
	_g_object_unref0 (self->priv->equation);
	(self->priv->hex_button_list == NULL) ? NULL : (self->priv->hex_button_list = (_g_list_free__g_object_unref0_ (self->priv->hex_button_list), NULL));
	(self->priv->bit_button_list == NULL) ? NULL : (self->priv->bit_button_list = (_g_list_free__g_object_unref0_ (self->priv->bit_button_list), NULL));
	_g_object_unref0 (self->priv->css_provider);
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (programming_button_panel_parent_class)->finalize (obj);
}

static GType
programming_button_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ProgrammingButtonPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) programming_button_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProgrammingButtonPanel), 0, (GInstanceInitFunc) programming_button_panel_instance_init, NULL };
	GType programming_button_panel_type_id;
	programming_button_panel_type_id = g_type_register_static (adw_breakpoint_bin_get_type (), "ProgrammingButtonPanel", &g_define_type_info, 0);
	ProgrammingButtonPanel_private_offset = g_type_add_instance_private (programming_button_panel_type_id, sizeof (ProgrammingButtonPanelPrivate));
	return programming_button_panel_type_id;
}

GType
programming_button_panel_get_type (void)
{
	static volatile gsize programming_button_panel_type_id__once = 0;
	if (g_once_init_enter (&programming_button_panel_type_id__once)) {
		GType programming_button_panel_type_id;
		programming_button_panel_type_id = programming_button_panel_get_type_once ();
		g_once_init_leave (&programming_button_panel_type_id__once, programming_button_panel_type_id);
	}
	return programming_button_panel_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

