/* BackgroundManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackgroundManager.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
 *                         2014 Tom Beckmann
 */

#include <meta/meta-background-group.h>
#include "gala.h"
#include <glib-object.h>
#include <meta/display.h>
#include <glib.h>
#include <meta/meta-background-actor.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <meta/prefs.h>
#include <meta/meta-background-content.h>
#include <meta/meta-background.h>
#include <mtk/mtk.h>
#include <graphene-gobject.h>
#include <string.h>

#define GALA_BACKGROUND_MANAGER_DIM_OPACITY 0.55
#define GALA_BACKGROUND_MANAGER_FADE_ANIMATION_TIME 1000
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
typedef struct _GalaBackgroundManagerPrivate GalaBackgroundManagerPrivate;

#define GALA_TYPE_BACKGROUND_SOURCE (gala_background_source_get_type ())
#define GALA_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource))
#define GALA_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))
#define GALA_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))

typedef struct _GalaBackgroundSource GalaBackgroundSource;
typedef struct _GalaBackgroundSourceClass GalaBackgroundSourceClass;
enum  {
	GALA_BACKGROUND_MANAGER_0_PROPERTY,
	GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY,
	GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY,
	GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY,
	GALA_BACKGROUND_MANAGER_ROUNDED_CORNERS_PROPERTY,
	GALA_BACKGROUND_MANAGER_NEWEST_BACKGROUND_ACTOR_PROPERTY,
	GALA_BACKGROUND_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_background_manager_properties[GALA_BACKGROUND_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_BACKGROUND_CACHE (gala_background_cache_get_type ())
#define GALA_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCache))
#define GALA_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))
#define GALA_IS_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_IS_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_BACKGROUND_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))

typedef struct _GalaBackgroundCache GalaBackgroundCache;
typedef struct _GalaBackgroundCacheClass GalaBackgroundCacheClass;

#define GALA_TYPE_BACKGROUND (gala_background_get_type ())
#define GALA_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND, GalaBackground))
#define GALA_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND, GalaBackgroundClass))
#define GALA_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND))
#define GALA_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND))
#define GALA_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND, GalaBackgroundClass))

typedef struct _GalaBackground GalaBackground;
typedef struct _GalaBackgroundClass GalaBackgroundClass;
typedef struct _Block41Data Block41Data;
typedef struct _Block42Data Block42Data;
enum  {
	GALA_BACKGROUND_MANAGER_CHANGED_SIGNAL,
	GALA_BACKGROUND_MANAGER_NUM_SIGNALS
};
static guint gala_background_manager_signals[GALA_BACKGROUND_MANAGER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaBackgroundManager {
	MetaBackgroundGroup parent_instance;
	GalaBackgroundManagerPrivate * priv;
};

struct _GalaBackgroundManagerClass {
	MetaBackgroundGroupClass parent_class;
};

struct _GalaBackgroundManagerPrivate {
	MetaDisplay* _display;
	gint _monitor_index;
	gboolean _control_position;
	gboolean _rounded_corners;
	GalaBackgroundSource* background_source;
	MetaBackgroundActor* background_actor;
	MetaBackgroundActor* new_background_actor;
};

struct _Block41Data {
	int _ref_count_;
	GalaBackgroundManager* self;
	MetaBackgroundContent* new_content;
	GalaBackground* background;
	gulong handler;
	gboolean animate;
};

struct _Block42Data {
	int _ref_count_;
	GalaBackgroundManager* self;
	GalaBackground* background;
	gulong changed_handler;
};

static gint GalaBackgroundManager_private_offset;
static gpointer gala_background_manager_parent_class = NULL;
static GalaBackgroundManagerInterfaceIface * gala_background_manager_gala_background_manager_interface_parent_iface = NULL;

VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
VALA_EXTERN GType gala_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundSource, g_object_unref)
VALA_EXTERN GalaBackgroundManager* gala_background_manager_new (MetaDisplay* display,
                                                    gint monitor_index,
                                                    gboolean control_position,
                                                    gboolean rounded_corners);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_construct (GType object_type,
                                                          MetaDisplay* display,
                                                          gint monitor_index,
                                                          gboolean control_position,
                                                          gboolean rounded_corners);
static void gala_background_manager_on_destroy (GalaBackgroundManager* self);
VALA_EXTERN GType gala_background_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundCache, g_object_unref)
VALA_EXTERN GalaBackgroundCache* gala_background_cache_get_default (void);
VALA_EXTERN void gala_background_cache_release_background_source (GalaBackgroundCache* self);
static void gala_background_manager_swap_background_actor (GalaBackgroundManager* self,
                                                    gboolean animate);
static void ___lambda56_ (GalaBackgroundManager* self,
                   ClutterTimeline* _transition);
static void ____lambda56__clutter_timeline_completed (ClutterTimeline* _sender,
                                               gpointer self);
static void gala_background_manager_update_background_actor (GalaBackgroundManager* self,
                                                      gboolean animate);
VALA_EXTERN GType gala_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackground, g_object_unref)
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static MetaBackgroundActor* gala_background_manager_create_background_actor (GalaBackgroundManager* self);
VALA_EXTERN gboolean gala_background_get_is_loaded (GalaBackground* self);
VALA_EXTERN gboolean gala_background_manager_get_rounded_corners (GalaBackgroundManager* self);
VALA_EXTERN MetaDisplay* gala_background_manager_get_display (GalaBackgroundManager* self);
VALA_EXTERN gint gala_background_manager_get_monitor_index (GalaBackgroundManager* self);
static void __lambda59_ (Block41Data* _data41_);
static void ___lambda59__gala_background_loaded (GalaBackground* _sender,
                                          gpointer self);
VALA_EXTERN void gala_background_manager_set_size (GalaBackgroundManager* self,
                                       gfloat width,
                                       gfloat height);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
VALA_EXTERN GalaBackground* gala_background_source_get_background (GalaBackgroundSource* self,
                                                       gint monitor_index);
VALA_EXTERN MetaBackground* gala_background_get_background (GalaBackground* self);
VALA_EXTERN gboolean gala_background_source_get_should_dim (GalaBackgroundSource* self);
VALA_EXTERN gboolean gala_background_manager_get_control_position (GalaBackgroundManager* self);
static void __lambda57_ (Block42Data* _data42_);
static void ___lambda57__gala_background_changed (GalaBackground* _sender,
                                           gpointer self);
static void __lambda58_ (Block42Data* _data42_);
static void ___lambda58__clutter_actor_destroy (ClutterActor* _sender,
                                         gpointer self);
static void gala_background_manager_set_display (GalaBackgroundManager* self,
                                          MetaDisplay* value);
static void gala_background_manager_set_monitor_index (GalaBackgroundManager* self,
                                                gint value);
static void gala_background_manager_set_control_position (GalaBackgroundManager* self,
                                                   gboolean value);
static void gala_background_manager_set_rounded_corners (GalaBackgroundManager* self,
                                                  gboolean value);
static GObject * gala_background_manager_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
VALA_EXTERN GalaBackgroundSource* gala_background_cache_get_background_source (GalaBackgroundCache* self,
                                                                   MetaDisplay* display);
static void _gala_background_manager_on_destroy_clutter_actor_destroy (ClutterActor* _sender,
                                                                gpointer self);
static void gala_background_manager_finalize (GObject * obj);
static GType gala_background_manager_get_type_once (void);
static void _vala_gala_background_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gala_background_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
gala_background_manager_get_instance_private (GalaBackgroundManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBackgroundManager_private_offset);
}

GalaBackgroundManager*
gala_background_manager_construct (GType object_type,
                                   MetaDisplay* display,
                                   gint monitor_index,
                                   gboolean control_position,
                                   gboolean rounded_corners)
{
	GalaBackgroundManager * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaBackgroundManager*) g_object_new (object_type, "display", display, "monitor-index", monitor_index, "control-position", control_position, "rounded-corners", rounded_corners, NULL);
	return self;
}

GalaBackgroundManager*
gala_background_manager_new (MetaDisplay* display,
                             gint monitor_index,
                             gboolean control_position,
                             gboolean rounded_corners)
{
	return gala_background_manager_construct (GALA_TYPE_BACKGROUND_MANAGER, display, monitor_index, control_position, rounded_corners);
}

static void
gala_background_manager_on_destroy (GalaBackgroundManager* self)
{
	GalaBackgroundCache* _tmp0_;
	MetaBackgroundActor* _tmp1_;
	MetaBackgroundActor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_background_cache_get_default ();
	gala_background_cache_release_background_source (_tmp0_);
	_g_object_unref0 (self->priv->background_source);
	self->priv->background_source = NULL;
	_tmp1_ = self->priv->new_background_actor;
	if (_tmp1_ != NULL) {
		MetaBackgroundActor* _tmp2_;
		_tmp2_ = self->priv->new_background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp2_);
		_g_object_unref0 (self->priv->new_background_actor);
		self->priv->new_background_actor = NULL;
	}
	_tmp3_ = self->priv->background_actor;
	if (_tmp3_ != NULL) {
		MetaBackgroundActor* _tmp4_;
		_tmp4_ = self->priv->background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp4_);
		_g_object_unref0 (self->priv->background_actor);
		self->priv->background_actor = NULL;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda56_ (GalaBackgroundManager* self,
              ClutterTimeline* _transition)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	g_return_if_fail (_transition != NULL);
	_tmp0_ = clutter_timeline_get_actor (_transition);
	_tmp1_ = _tmp0_;
	clutter_actor_destroy (_tmp1_);
}

static void
____lambda56__clutter_timeline_completed (ClutterTimeline* _sender,
                                          gpointer self)
{
	___lambda56_ ((GalaBackgroundManager*) self, _sender);
}

static void
gala_background_manager_swap_background_actor (GalaBackgroundManager* self,
                                               gboolean animate)
{
	MetaBackgroundActor* _tmp0_;
	MetaBackgroundActor* _tmp1_;
	gboolean _tmp4_ = FALSE;
	MetaBackgroundActor* _tmp16_;
	MetaBackgroundActor* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_background_actor;
	_vala_return_if_fail (_tmp0_ != NULL, "new_background_actor != null");
	g_signal_emit (self, gala_background_manager_signals[GALA_BACKGROUND_MANAGER_CHANGED_SIGNAL], 0);
	_tmp1_ = self->priv->background_actor;
	if (_tmp1_ == NULL) {
		MetaBackgroundActor* _tmp2_;
		MetaBackgroundActor* _tmp3_;
		_tmp2_ = self->priv->new_background_actor;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->priv->background_actor);
		self->priv->background_actor = _tmp3_;
		_g_object_unref0 (self->priv->new_background_actor);
		self->priv->new_background_actor = NULL;
		return;
	}
	if (animate) {
		_tmp4_ = meta_prefs_get_gnome_animations ();
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ClutterPropertyTransition* transition = NULL;
		ClutterPropertyTransition* _tmp5_;
		ClutterPropertyTransition* _tmp6_;
		GValue _tmp7_ = {0};
		ClutterPropertyTransition* _tmp8_;
		GValue _tmp9_ = {0};
		ClutterPropertyTransition* _tmp10_;
		ClutterPropertyTransition* _tmp11_;
		ClutterPropertyTransition* _tmp12_;
		MetaBackgroundActor* _tmp13_;
		ClutterPropertyTransition* _tmp14_;
		_tmp5_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
		transition = _tmp5_;
		_tmp6_ = transition;
		g_value_init (&_tmp7_, G_TYPE_INT);
		g_value_set_int (&_tmp7_, 255);
		clutter_transition_set_from_value ((ClutterTransition*) _tmp6_, &_tmp7_);
		G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
		_tmp8_ = transition;
		g_value_init (&_tmp9_, G_TYPE_INT);
		g_value_set_int (&_tmp9_, 0);
		clutter_transition_set_to_value ((ClutterTransition*) _tmp8_, &_tmp9_);
		G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
		_tmp10_ = transition;
		clutter_timeline_set_duration ((ClutterTimeline*) _tmp10_, (guint) GALA_BACKGROUND_MANAGER_FADE_ANIMATION_TIME);
		_tmp11_ = transition;
		clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp11_, CLUTTER_EASE_OUT_QUAD);
		_tmp12_ = transition;
		g_signal_connect_object ((ClutterTimeline*) _tmp12_, "completed", (GCallback) ____lambda56__clutter_timeline_completed, self, 0);
		_tmp13_ = self->priv->background_actor;
		_tmp14_ = transition;
		clutter_actor_add_transition ((ClutterActor*) _tmp13_, "fade-out", (ClutterTransition*) _tmp14_);
		_g_object_unref0 (transition);
	} else {
		MetaBackgroundActor* _tmp15_;
		_tmp15_ = self->priv->background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp15_);
	}
	_tmp16_ = self->priv->new_background_actor;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (self->priv->background_actor);
	self->priv->background_actor = _tmp17_;
	_g_object_unref0 (self->priv->new_background_actor);
	self->priv->new_background_actor = NULL;
}

static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		GalaBackgroundManager* self;
		self = _data41_->self;
		_g_object_unref0 (_data41_->background);
		_g_object_unref0 (_data41_->new_content);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}

static void
__lambda59_ (Block41Data* _data41_)
{
	GalaBackgroundManager* self;
	GalaBackground* _tmp0_;
	GalaBackground* _tmp1_;
	gboolean _tmp2_;
	self = _data41_->self;
	_tmp0_ = _data41_->background;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data41_->handler);
	_tmp1_ = _data41_->background;
	g_object_set_data_full ((GObject*) _tmp1_, "background-loaded-handler", (gpointer) ((guintptr) 0), NULL);
	_tmp2_ = self->priv->_rounded_corners;
	if (_tmp2_) {
		MtkRectangle monitor_geometry = {0};
		MetaDisplay* _tmp3_;
		gint _tmp4_;
		MtkRectangle _tmp5_ = {0};
		graphene_rect_t clip_bounds = {0};
		graphene_point_t _tmp6_ = {0};
		MtkRectangle _tmp7_;
		MtkRectangle _tmp8_;
		graphene_size_t _tmp9_ = {0};
		graphene_rect_t _tmp10_ = {0};
		MetaBackgroundContent* _tmp11_;
		graphene_rect_t _tmp12_;
		MetaBackgroundContent* _tmp13_;
		MetaDisplay* _tmp14_;
		gint _tmp15_;
		_tmp3_ = self->priv->_display;
		_tmp4_ = self->priv->_monitor_index;
		meta_display_get_monitor_geometry (_tmp3_, _tmp4_, &_tmp5_);
		monitor_geometry = _tmp5_;
		_tmp6_.x = (gfloat) 0;
		_tmp6_.y = (gfloat) 0;
		_tmp7_ = monitor_geometry;
		_tmp8_ = monitor_geometry;
		_tmp9_.width = (gfloat) _tmp7_.width;
		_tmp9_.height = (gfloat) _tmp8_.height;
		memset (&_tmp10_, 0, sizeof (graphene_rect_t));
		_tmp10_.origin = _tmp6_;
		_tmp10_.size = _tmp9_;
		clip_bounds = _tmp10_;
		_tmp11_ = _data41_->new_content;
		_tmp12_ = clip_bounds;
		meta_background_content_set_rounded_clip_bounds (_tmp11_, &_tmp12_);
		_tmp13_ = _data41_->new_content;
		_tmp14_ = self->priv->_display;
		_tmp15_ = self->priv->_monitor_index;
		g_object_set (_tmp13_, "rounded-clip-radius", (gfloat) gala_utils_scale_to_int (6, meta_display_get_monitor_scale (_tmp14_, _tmp15_)), NULL);
	}
	gala_background_manager_swap_background_actor (self, _data41_->animate);
}

static void
___lambda59__gala_background_loaded (GalaBackground* _sender,
                                     gpointer self)
{
	__lambda59_ (self);
}

static void
gala_background_manager_update_background_actor (GalaBackgroundManager* self,
                                                 gboolean animate)
{
	Block41Data* _data41_;
	MetaBackgroundActor* _tmp0_;
	MetaBackgroundActor* _tmp2_;
	MetaBackgroundActor* _tmp3_;
	ClutterContent* _tmp4_;
	ClutterContent* _tmp5_;
	MetaBackgroundContent* _tmp6_;
	MetaBackgroundContent* _tmp7_;
	MetaBackground* _tmp8_;
	MetaBackground* _tmp9_;
	MetaBackground* _tmp10_;
	gconstpointer _tmp11_;
	GalaBackground* _tmp12_;
	GalaBackground* _tmp13_;
	GalaBackground* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	GalaBackground* _tmp31_;
	gulong _tmp32_;
	GalaBackground* _tmp33_;
	g_return_if_fail (self != NULL);
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_data41_->animate = animate;
	_tmp0_ = self->priv->new_background_actor;
	if (_tmp0_ != NULL) {
		MetaBackgroundActor* _tmp1_;
		_tmp1_ = self->priv->new_background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp1_);
		_g_object_unref0 (self->priv->new_background_actor);
		self->priv->new_background_actor = NULL;
	}
	_tmp2_ = gala_background_manager_create_background_actor (self);
	_g_object_unref0 (self->priv->new_background_actor);
	self->priv->new_background_actor = _tmp2_;
	_tmp3_ = self->priv->new_background_actor;
	_tmp4_ = clutter_actor_get_content ((ClutterActor*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, meta_background_content_get_type (), MetaBackgroundContent));
	_data41_->new_content = _tmp6_;
	_tmp7_ = _data41_->new_content;
	g_object_get (_tmp7_, "background", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = g_object_get_data ((GObject*) _tmp10_, "delegate");
	_tmp12_ = _g_object_ref0 ((GalaBackground*) _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp10_);
	_data41_->background = _tmp13_;
	_tmp14_ = _data41_->background;
	_tmp15_ = gala_background_get_is_loaded (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		gboolean _tmp17_;
		_tmp17_ = self->priv->_rounded_corners;
		if (_tmp17_) {
			MtkRectangle monitor_geometry = {0};
			MetaDisplay* _tmp18_;
			gint _tmp19_;
			MtkRectangle _tmp20_ = {0};
			graphene_rect_t clip_bounds = {0};
			graphene_point_t _tmp21_ = {0};
			MtkRectangle _tmp22_;
			MtkRectangle _tmp23_;
			graphene_size_t _tmp24_ = {0};
			graphene_rect_t _tmp25_ = {0};
			MetaBackgroundContent* _tmp26_;
			graphene_rect_t _tmp27_;
			MetaBackgroundContent* _tmp28_;
			MetaDisplay* _tmp29_;
			gint _tmp30_;
			_tmp18_ = self->priv->_display;
			_tmp19_ = self->priv->_monitor_index;
			meta_display_get_monitor_geometry (_tmp18_, _tmp19_, &_tmp20_);
			monitor_geometry = _tmp20_;
			_tmp21_.x = (gfloat) 0;
			_tmp21_.y = (gfloat) 0;
			_tmp22_ = monitor_geometry;
			_tmp23_ = monitor_geometry;
			_tmp24_.width = (gfloat) _tmp22_.width;
			_tmp24_.height = (gfloat) _tmp23_.height;
			memset (&_tmp25_, 0, sizeof (graphene_rect_t));
			_tmp25_.origin = _tmp21_;
			_tmp25_.size = _tmp24_;
			clip_bounds = _tmp25_;
			_tmp26_ = _data41_->new_content;
			_tmp27_ = clip_bounds;
			meta_background_content_set_rounded_clip_bounds (_tmp26_, &_tmp27_);
			_tmp28_ = _data41_->new_content;
			_tmp29_ = self->priv->_display;
			_tmp30_ = self->priv->_monitor_index;
			g_object_set (_tmp28_, "rounded-clip-radius", (gfloat) gala_utils_scale_to_int (6, meta_display_get_monitor_scale (_tmp29_, _tmp30_)), NULL);
		}
		gala_background_manager_swap_background_actor (self, _data41_->animate);
		block41_data_unref (_data41_);
		_data41_ = NULL;
		return;
	}
	_data41_->handler = (gulong) 0;
	_tmp31_ = _data41_->background;
	_tmp32_ = g_signal_connect_data (_tmp31_, "loaded", (GCallback) ___lambda59__gala_background_loaded, block41_data_ref (_data41_), (GClosureNotify) block41_data_unref, 0);
	_data41_->handler = _tmp32_;
	_tmp33_ = _data41_->background;
	g_object_set_data_full ((GObject*) _tmp33_, "background-loaded-handler", (gpointer) ((guintptr) _data41_->handler), NULL);
	block41_data_unref (_data41_);
	_data41_ = NULL;
}

void
gala_background_manager_set_size (GalaBackgroundManager* self,
                                  gfloat width,
                                  gfloat height)
{
	gboolean _tmp0_ = FALSE;
	MetaBackgroundActor* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->background_actor;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (width != _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		MetaBackgroundActor* _tmp4_;
		gfloat _tmp5_;
		gfloat _tmp6_;
		_tmp4_ = self->priv->background_actor;
		_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = height != _tmp6_;
	}
	if (_tmp0_) {
		gala_background_manager_update_background_actor (self, FALSE);
	}
}

static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		GalaBackgroundManager* self;
		self = _data42_->self;
		_g_object_unref0 (_data42_->background);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}

static void
__lambda57_ (Block42Data* _data42_)
{
	GalaBackgroundManager* self;
	GalaBackground* _tmp0_;
	self = _data42_->self;
	_tmp0_ = _data42_->background;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data42_->changed_handler);
	_data42_->changed_handler = (gulong) 0;
	gala_background_manager_update_background_actor (self, TRUE);
}

static void
___lambda57__gala_background_changed (GalaBackground* _sender,
                                      gpointer self)
{
	__lambda57_ (self);
}

static void
__lambda58_ (Block42Data* _data42_)
{
	GalaBackgroundManager* self;
	gulong loaded_handler = 0UL;
	GalaBackground* _tmp1_;
	gconstpointer _tmp2_;
	self = _data42_->self;
	if (_data42_->changed_handler != ((gulong) 0)) {
		GalaBackground* _tmp0_;
		_tmp0_ = _data42_->background;
		g_signal_handler_disconnect ((GObject*) _tmp0_, _data42_->changed_handler);
		_data42_->changed_handler = (gulong) 0;
	}
	_tmp1_ = _data42_->background;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "background-loaded-handler");
	loaded_handler = (gulong) ((guintptr) _tmp2_);
	if (loaded_handler != ((gulong) 0)) {
		GalaBackground* _tmp3_;
		GalaBackground* _tmp4_;
		_tmp3_ = _data42_->background;
		g_signal_handler_disconnect ((GObject*) _tmp3_, loaded_handler);
		_tmp4_ = _data42_->background;
		g_object_set_data_full ((GObject*) _tmp4_, "background-loaded-handler", (gpointer) ((guintptr) 0), NULL);
	}
}

static void
___lambda58__clutter_actor_destroy (ClutterActor* _sender,
                                    gpointer self)
{
	__lambda58_ (self);
}

static MetaBackgroundActor*
gala_background_manager_create_background_actor (GalaBackgroundManager* self)
{
	Block42Data* _data42_;
	GalaBackgroundSource* _tmp0_;
	gint _tmp1_;
	GalaBackground* _tmp2_;
	MetaBackgroundActor* background_actor = NULL;
	MetaDisplay* _tmp3_;
	gint _tmp4_;
	MetaBackgroundActor* _tmp5_;
	MetaBackgroundContent* content = NULL;
	MetaBackgroundActor* _tmp6_;
	ClutterContent* _tmp7_;
	ClutterContent* _tmp8_;
	MetaBackgroundContent* _tmp9_;
	GalaBackground* _tmp10_;
	MetaBackground* _tmp11_;
	MetaBackground* _tmp12_;
	MtkRectangle monitor = {0};
	MetaDisplay* _tmp13_;
	gint _tmp14_;
	MtkRectangle _tmp15_ = {0};
	GalaBackgroundSource* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	MetaBackgroundActor* _tmp21_;
	MetaBackgroundActor* _tmp22_;
	MtkRectangle _tmp23_;
	MtkRectangle _tmp24_;
	gboolean _tmp25_;
	GalaBackground* _tmp29_;
	gulong _tmp30_;
	MetaBackgroundActor* _tmp31_;
	MetaBackgroundActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data42_ = g_slice_new0 (Block42Data);
	_data42_->_ref_count_ = 1;
	_data42_->self = g_object_ref (self);
	_tmp0_ = self->priv->background_source;
	_tmp1_ = self->priv->_monitor_index;
	_tmp2_ = gala_background_source_get_background (_tmp0_, _tmp1_);
	_data42_->background = _tmp2_;
	_tmp3_ = self->priv->_display;
	_tmp4_ = self->priv->_monitor_index;
	_tmp5_ = (MetaBackgroundActor*) meta_background_actor_new (_tmp3_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	background_actor = _tmp5_;
	_tmp6_ = background_actor;
	_tmp7_ = clutter_actor_get_content ((ClutterActor*) _tmp6_);
	_tmp8_ = _tmp7_;
	content = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, meta_background_content_get_type (), MetaBackgroundContent);
	_tmp9_ = content;
	_tmp10_ = _data42_->background;
	_tmp11_ = gala_background_get_background (_tmp10_);
	_tmp12_ = _tmp11_;
	g_object_set (_tmp9_, "background", _tmp12_, NULL);
	_tmp13_ = self->priv->_display;
	_tmp14_ = self->priv->_monitor_index;
	meta_display_get_monitor_geometry (_tmp13_, _tmp14_, &_tmp15_);
	monitor = _tmp15_;
	_tmp16_ = self->priv->background_source;
	_tmp17_ = gala_background_source_get_should_dim (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		MetaBackgroundContent* _tmp19_;
		MetaBackgroundContent* _tmp20_;
		_tmp19_ = content;
		g_object_set (_tmp19_, "vignette", TRUE, NULL);
		_tmp20_ = content;
		g_object_set (_tmp20_, "brightness", GALA_BACKGROUND_MANAGER_DIM_OPACITY, NULL);
	}
	_tmp21_ = background_actor;
	clutter_actor_insert_child_below ((ClutterActor*) self, (ClutterActor*) _tmp21_, NULL);
	_tmp22_ = background_actor;
	_tmp23_ = monitor;
	_tmp24_ = monitor;
	clutter_actor_set_size ((ClutterActor*) _tmp22_, (gfloat) _tmp23_.width, (gfloat) _tmp24_.height);
	_tmp25_ = self->priv->_control_position;
	if (_tmp25_) {
		MetaBackgroundActor* _tmp26_;
		MtkRectangle _tmp27_;
		MtkRectangle _tmp28_;
		_tmp26_ = background_actor;
		_tmp27_ = monitor;
		_tmp28_ = monitor;
		clutter_actor_set_position ((ClutterActor*) _tmp26_, (gfloat) _tmp27_.x, (gfloat) _tmp28_.y);
	}
	_data42_->changed_handler = (gulong) 0;
	_tmp29_ = _data42_->background;
	_tmp30_ = g_signal_connect_data (_tmp29_, "changed", (GCallback) ___lambda57__gala_background_changed, block42_data_ref (_data42_), (GClosureNotify) block42_data_unref, 0);
	_data42_->changed_handler = _tmp30_;
	_tmp31_ = background_actor;
	g_signal_connect_data ((ClutterActor*) _tmp31_, "destroy", (GCallback) ___lambda58__clutter_actor_destroy, block42_data_ref (_data42_), (GClosureNotify) block42_data_unref, 0);
	result = background_actor;
	block42_data_unref (_data42_);
	_data42_ = NULL;
	return result;
}

MetaDisplay*
gala_background_manager_get_display (GalaBackgroundManager* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_background_manager_set_display (GalaBackgroundManager* self,
                                     MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY]);
	}
}

gint
gala_background_manager_get_monitor_index (GalaBackgroundManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor_index;
	return result;
}

static void
gala_background_manager_set_monitor_index (GalaBackgroundManager* self,
                                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_get_monitor_index (self);
	if (old_value != value) {
		self->priv->_monitor_index = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY]);
	}
}

gboolean
gala_background_manager_get_control_position (GalaBackgroundManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_control_position;
	return result;
}

static void
gala_background_manager_set_control_position (GalaBackgroundManager* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_get_control_position (self);
	if (old_value != value) {
		self->priv->_control_position = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY]);
	}
}

gboolean
gala_background_manager_get_rounded_corners (GalaBackgroundManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_rounded_corners;
	return result;
}

static void
gala_background_manager_set_rounded_corners (GalaBackgroundManager* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_get_rounded_corners (self);
	if (old_value != value) {
		self->priv->_rounded_corners = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_ROUNDED_CORNERS_PROPERTY]);
	}
}

static MetaBackgroundActor*
gala_background_manager_real_get_newest_background_actor (GalaBackgroundManagerInterface* base)
{
	MetaBackgroundActor* result;
	GalaBackgroundManager* self;
	MetaBackgroundActor* _tmp0_ = NULL;
	MetaBackgroundActor* _tmp1_;
	self = (GalaBackgroundManager*) base;
	_tmp1_ = self->priv->new_background_actor;
	if (_tmp1_ != NULL) {
		MetaBackgroundActor* _tmp2_;
		_tmp2_ = self->priv->new_background_actor;
		_tmp0_ = _tmp2_;
	} else {
		MetaBackgroundActor* _tmp3_;
		_tmp3_ = self->priv->background_actor;
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

static void
_gala_background_manager_on_destroy_clutter_actor_destroy (ClutterActor* _sender,
                                                           gpointer self)
{
	gala_background_manager_on_destroy ((GalaBackgroundManager*) self);
}

static GObject *
gala_background_manager_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaBackgroundManager * self;
	GalaBackgroundCache* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaBackgroundSource* _tmp2_;
	parent_class = G_OBJECT_CLASS (gala_background_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	_tmp0_ = gala_background_cache_get_default ();
	_tmp1_ = self->priv->_display;
	_tmp2_ = gala_background_cache_get_background_source (_tmp0_, _tmp1_);
	_g_object_unref0 (self->priv->background_source);
	self->priv->background_source = _tmp2_;
	gala_background_manager_update_background_actor (self, FALSE);
	g_signal_connect_object ((ClutterActor*) self, "destroy", (GCallback) _gala_background_manager_on_destroy_clutter_actor_destroy, self, 0);
	return obj;
}

static void
gala_background_manager_class_init (GalaBackgroundManagerClass * klass,
                                    gpointer klass_data)
{
	gala_background_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBackgroundManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_background_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_background_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_background_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_background_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY] = g_param_spec_int ("monitor-index", "monitor-index", "monitor-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY] = g_param_spec_boolean ("control-position", "control-position", "control-position", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_ROUNDED_CORNERS_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_ROUNDED_CORNERS_PROPERTY] = g_param_spec_boolean ("rounded-corners", "rounded-corners", "rounded-corners", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_NEWEST_BACKGROUND_ACTOR_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_NEWEST_BACKGROUND_ACTOR_PROPERTY] = g_param_spec_object ("newest-background-actor", "newest-background-actor", "newest-background-actor", meta_background_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_background_manager_signals[GALA_BACKGROUND_MANAGER_CHANGED_SIGNAL] = g_signal_new ("changed", GALA_TYPE_BACKGROUND_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_background_manager_gala_background_manager_interface_interface_init (GalaBackgroundManagerInterfaceIface * iface,
                                                                          gpointer iface_data)
{
	gala_background_manager_gala_background_manager_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_newest_background_actor = gala_background_manager_real_get_newest_background_actor;
}

static void
gala_background_manager_instance_init (GalaBackgroundManager * self,
                                       gpointer klass)
{
	self->priv = gala_background_manager_get_instance_private (self);
	self->priv->new_background_actor = NULL;
}

static void
gala_background_manager_finalize (GObject * obj)
{
	GalaBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->background_source);
	_g_object_unref0 (self->priv->background_actor);
	_g_object_unref0 (self->priv->new_background_actor);
	G_OBJECT_CLASS (gala_background_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_background_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBackgroundManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_background_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBackgroundManager), 0, (GInstanceInitFunc) gala_background_manager_instance_init, NULL };
	static const GInterfaceInfo gala_background_manager_interface_info = { (GInterfaceInitFunc) gala_background_manager_gala_background_manager_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_background_manager_type_id;
	gala_background_manager_type_id = g_type_register_static (meta_background_group_get_type (), "GalaBackgroundManager", &g_define_type_info, 0);
	g_type_add_interface_static (gala_background_manager_type_id, GALA_TYPE_BACKGROUND_MANAGER_INTERFACE, &gala_background_manager_interface_info);
	GalaBackgroundManager_private_offset = g_type_add_instance_private (gala_background_manager_type_id, sizeof (GalaBackgroundManagerPrivate));
	return gala_background_manager_type_id;
}

GType
gala_background_manager_get_type (void)
{
	static gsize gala_background_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_background_manager_type_id__once)) {
		GType gala_background_manager_type_id;
		gala_background_manager_type_id = gala_background_manager_get_type_once ();
		g_once_init_leave (&gala_background_manager_type_id__once, gala_background_manager_type_id);
	}
	return gala_background_manager_type_id__once;
}

static void
_vala_gala_background_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GalaBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	switch (property_id) {
		case GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_background_manager_get_display (self));
		break;
		case GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY:
		g_value_set_int (value, gala_background_manager_get_monitor_index (self));
		break;
		case GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY:
		g_value_set_boolean (value, gala_background_manager_get_control_position (self));
		break;
		case GALA_BACKGROUND_MANAGER_ROUNDED_CORNERS_PROPERTY:
		g_value_set_boolean (value, gala_background_manager_get_rounded_corners (self));
		break;
		case GALA_BACKGROUND_MANAGER_NEWEST_BACKGROUND_ACTOR_PROPERTY:
		g_value_set_object (value, gala_background_manager_interface_get_newest_background_actor ((GalaBackgroundManagerInterface*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_background_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GalaBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	switch (property_id) {
		case GALA_BACKGROUND_MANAGER_DISPLAY_PROPERTY:
		gala_background_manager_set_display (self, g_value_get_object (value));
		break;
		case GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY:
		gala_background_manager_set_monitor_index (self, g_value_get_int (value));
		break;
		case GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY:
		gala_background_manager_set_control_position (self, g_value_get_boolean (value));
		break;
		case GALA_BACKGROUND_MANAGER_ROUNDED_CORNERS_PROPERTY:
		gala_background_manager_set_rounded_corners (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

