/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-wac-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_wac_report_id_to_string:
 * @val: value, e.g. %FU_WAC_REPORT_ID_SWITCH_TO_FLASH_LOADER
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_wac_report_id_to_string(FuWacReportId val)
{
    if (val == FU_WAC_REPORT_ID_FW_DESCRIPTOR)
        return "fw-descriptor";
    if (val == FU_WAC_REPORT_ID_SWITCH_TO_FLASH_LOADER)
        return "switch-to-flash-loader";
    if (val == FU_WAC_REPORT_ID_QUIT_AND_RESET)
        return "quit-and-reset";
    if (val == FU_WAC_REPORT_ID_READ_BLOCK_DATA)
        return "read-block-data";
    if (val == FU_WAC_REPORT_ID_WRITE_BLOCK)
        return "write-block";
    if (val == FU_WAC_REPORT_ID_ERASE_BLOCK)
        return "erase-block";
    if (val == FU_WAC_REPORT_ID_SET_READ_ADDRESS)
        return "set-read-address";
    if (val == FU_WAC_REPORT_ID_GET_STATUS)
        return "get-status";
    if (val == FU_WAC_REPORT_ID_UPDATE_RESET)
        return "update-reset";
    if (val == FU_WAC_REPORT_ID_WRITE_WORD)
        return "write-word";
    if (val == FU_WAC_REPORT_ID_GET_PARAMETERS)
        return "get-parameters";
    if (val == FU_WAC_REPORT_ID_GET_FLASH_DESCRIPTOR)
        return "get-flash-descriptor";
    if (val == FU_WAC_REPORT_ID_GET_CHECKSUMS)
        return "get-checksums";
    if (val == FU_WAC_REPORT_ID_SET_CHECKSUM_FOR_BLOCK)
        return "set-checksum-for-block";
    if (val == FU_WAC_REPORT_ID_CALCULATE_CHECKSUM_FOR_BLOCK)
        return "calculate-checksum-for-block";
    if (val == FU_WAC_REPORT_ID_WRITE_CHECKSUM_TABLE)
        return "write-checksum-table";
    if (val == FU_WAC_REPORT_ID_GET_CURRENT_FIRMWARE_IDX)
        return "get-current-firmware-idx";
    if (val == FU_WAC_REPORT_ID_MODULE)
        return "module";
    return NULL;
}

/**
 * fu_wac_module_fw_type_to_string:
 * @val: value, e.g. %FU_WAC_MODULE_FW_TYPE_BLUETOOTH
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_wac_module_fw_type_to_string(FuWacModuleFwType val)
{
    if (val == FU_WAC_MODULE_FW_TYPE_TOUCH)
        return "touch";
    if (val == FU_WAC_MODULE_FW_TYPE_BLUETOOTH)
        return "bluetooth";
    if (val == FU_WAC_MODULE_FW_TYPE_EMR_CORRECTION)
        return "emr-correction";
    if (val == FU_WAC_MODULE_FW_TYPE_BLUETOOTH_HID)
        return "bluetooth-hid";
    if (val == FU_WAC_MODULE_FW_TYPE_SCALER)
        return "scaler";
    if (val == FU_WAC_MODULE_FW_TYPE_BLUETOOTH_ID6)
        return "bluetooth-id6";
    if (val == FU_WAC_MODULE_FW_TYPE_TOUCH_ID7)
        return "touch-id7";
    if (val == FU_WAC_MODULE_FW_TYPE_BLUETOOTH_ID9)
        return "bluetooth-id9";
    if (val == FU_WAC_MODULE_FW_TYPE_SUB_CPU)
        return "sub-cpu";
    if (val == FU_WAC_MODULE_FW_TYPE_MAIN)
        return "main";
    return NULL;
}

/**
 * fu_wac_module_command_to_string:
 * @val: value, e.g. %FU_WAC_MODULE_COMMAND_DATA
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_wac_module_command_to_string(FuWacModuleCommand val)
{
    if (val == FU_WAC_MODULE_COMMAND_START)
        return "start";
    if (val == FU_WAC_MODULE_COMMAND_DATA)
        return "data";
    if (val == FU_WAC_MODULE_COMMAND_END)
        return "end";
    return NULL;
}

/**
 * fu_wac_module_status_to_string:
 * @val: value, e.g. %FU_WAC_MODULE_STATUS_BUSY
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_wac_module_status_to_string(FuWacModuleStatus val)
{
    if (val == FU_WAC_MODULE_STATUS_OK)
        return "ok";
    if (val == FU_WAC_MODULE_STATUS_BUSY)
        return "busy";
    if (val == FU_WAC_MODULE_STATUS_ERR_CRC)
        return "err-crc";
    if (val == FU_WAC_MODULE_STATUS_ERR_CMD)
        return "err-cmd";
    if (val == FU_WAC_MODULE_STATUS_ERR_HW_ACCESS_FAIL)
        return "err-hw-access-fail";
    if (val == FU_WAC_MODULE_STATUS_ERR_FLASH_NO_SUPPORT)
        return "err-flash-no-support";
    if (val == FU_WAC_MODULE_STATUS_ERR_MODE_WRONG)
        return "err-mode-wrong";
    if (val == FU_WAC_MODULE_STATUS_ERR_MPU_NO_SUPPORT)
        return "err-mpu-no-support";
    if (val == FU_WAC_MODULE_STATUS_ERR_VERSION_NO_SUPPORT)
        return "err-version-no-support";
    if (val == FU_WAC_MODULE_STATUS_ERR_ERASE)
        return "err-erase";
    if (val == FU_WAC_MODULE_STATUS_ERR_WRITE)
        return "err-write";
    if (val == FU_WAC_MODULE_STATUS_ERR_EXIT)
        return "err-exit";
    if (val == FU_WAC_MODULE_STATUS_ERR)
        return "err";
    if (val == FU_WAC_MODULE_STATUS_ERR_INVALID_OP)
        return "err-invalid-op";
    if (val == FU_WAC_MODULE_STATUS_ERR_WRONG_IMAGE)
        return "err-wrong-image";
    return NULL;
}

/**
 * fu_wac_device_status_to_string:
 * @val: value, e.g. %FU_WAC_DEVICE_STATUS_WRITING
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 *
 **/
gchar *
fu_wac_device_status_to_string(FuWacDeviceStatus val)
{
    const gchar *data[6] = {0};
    guint idx = 0;
    if (val == FU_WAC_DEVICE_STATUS_UNKNOWN)
        return g_strdup("unknown");
    if (val & FU_WAC_DEVICE_STATUS_WRITING)
        data[idx++] = "writing";
    if (val & FU_WAC_DEVICE_STATUS_ERASING)
        data[idx++] = "erasing";
    if (val & FU_WAC_DEVICE_STATUS_ERROR_WRITE)
        data[idx++] = "error-write";
    if (val & FU_WAC_DEVICE_STATUS_ERROR_ERASE)
        data[idx++] = "error-erase";
    if (val & FU_WAC_DEVICE_STATUS_WRITE_PROTECTED)
        data[idx++] = "write-protected";
    return g_strjoinv(",", (gchar **)data);
}
/**
 * fu_struct_wac_firmware_hdr_ref: (skip):
 **/
FuStructWacFirmwareHdr *
fu_struct_wac_firmware_hdr_ref(FuStructWacFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wac_firmware_hdr_unref: (skip):
 **/
void
fu_struct_wac_firmware_hdr_unref(FuStructWacFirmwareHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWacFirmwareHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wac_firmware_hdr_new_internal: (skip):
 **/
static FuStructWacFirmwareHdr *
fu_struct_wac_firmware_hdr_new_internal(void)
{
    FuStructWacFirmwareHdr *st = g_new0(FuStructWacFirmwareHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_wac_firmware_hdr_get_magic: (skip):
 **/
static gchar *
fu_struct_wac_firmware_hdr_get_magic(const FuStructWacFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 5, NULL);
}

/* setters */
static gboolean
fu_struct_wac_firmware_hdr_validate_internal(FuStructWacFirmwareHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "WACOM", 5) != 0) {
        g_autofree gchar *str = fu_struct_wac_firmware_hdr_get_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructWacFirmwareHdr.magic was not valid, "
                    "expected 'WACOM' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_wac_firmware_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_wac_firmware_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructWacFirmwareHdr) st = fu_struct_wac_firmware_hdr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 5, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructWacFirmwareHdr failed read of 0x%x: ", (guint) 5);
        return FALSE;
    }
    if (st->buf->len != 5) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructWacFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 5,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_wac_firmware_hdr_validate_internal(st, error);
}
/**
 * fu_struct_wta_block_header_ref: (skip):
 **/
FuStructWtaBlockHeader *
fu_struct_wta_block_header_ref(FuStructWtaBlockHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_wta_block_header_unref: (skip):
 **/
void
fu_struct_wta_block_header_unref(FuStructWtaBlockHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructWtaBlockHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_wta_block_header_new_internal: (skip):
 **/
static FuStructWtaBlockHeader *
fu_struct_wta_block_header_new_internal(void)
{
    FuStructWtaBlockHeader *st = g_new0(FuStructWtaBlockHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_wta_block_header_get_block_start: (skip):
 **/
guint32
fu_struct_wta_block_header_get_block_start(const FuStructWtaBlockHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wta_block_header_get_block_size: (skip):
 **/
guint32
fu_struct_wta_block_header_get_block_size(const FuStructWtaBlockHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_wta_block_header_to_string: (skip):
 **/
static gchar *
fu_struct_wta_block_header_to_string(const FuStructWtaBlockHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWtaBlockHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  block_start: 0x%x\n",
                           (guint) fu_struct_wta_block_header_get_block_start(st));
    g_string_append_printf(str, "  block_size: 0x%x\n",
                           (guint) fu_struct_wta_block_header_get_block_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wta_block_header_validate_internal(FuStructWtaBlockHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_wta_block_header_parse_internal(FuStructWtaBlockHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wta_block_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wta_block_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wta_block_header_parse: (skip):
 **/
FuStructWtaBlockHeader *
fu_struct_wta_block_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructWtaBlockHeader) st = fu_struct_wta_block_header_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWtaBlockHeader: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_struct_wta_block_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_id9_unknown_cmd_ref: (skip):
 **/
FuStructId9UnknownCmd *
fu_struct_id9_unknown_cmd_ref(FuStructId9UnknownCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_id9_unknown_cmd_unref: (skip):
 **/
void
fu_struct_id9_unknown_cmd_unref(FuStructId9UnknownCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructId9UnknownCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_id9_unknown_cmd_new_internal: (skip):
 **/
static FuStructId9UnknownCmd *
fu_struct_id9_unknown_cmd_new_internal(void)
{
    FuStructId9UnknownCmd *st = g_new0(FuStructId9UnknownCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_id9_unknown_cmd_get_unknown1: (skip):
 **/
static guint16
fu_struct_id9_unknown_cmd_get_unknown1(const FuStructId9UnknownCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_unknown_cmd_get_unknown2: (skip):
 **/
static guint32
fu_struct_id9_unknown_cmd_get_unknown2(const FuStructId9UnknownCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 2, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_id9_unknown_cmd_set_unknown1: (skip):
 **/
static void
fu_struct_id9_unknown_cmd_set_unknown1(FuStructId9UnknownCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_unknown_cmd_set_unknown2: (skip):
 **/
static void
fu_struct_id9_unknown_cmd_set_unknown2(FuStructId9UnknownCmd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 2, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_unknown_cmd_set_size: (skip):
 **/
void
fu_struct_id9_unknown_cmd_set_size(FuStructId9UnknownCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_unknown_cmd_new: (skip):
 **/
FuStructId9UnknownCmd *
fu_struct_id9_unknown_cmd_new(void)
{
    FuStructId9UnknownCmd *st = fu_struct_id9_unknown_cmd_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_id9_unknown_cmd_set_unknown1(st, 0x7050);
    fu_struct_id9_unknown_cmd_set_unknown2(st, 0);
    return st;
}
static gboolean
fu_struct_id9_unknown_cmd_validate_internal(FuStructId9UnknownCmd *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_id9_unknown_cmd_get_unknown1(st) != 0x7050) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructId9UnknownCmd.unknown1 was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x7050,
                    (guint) fu_struct_id9_unknown_cmd_get_unknown1(st));
        return FALSE;
    }
    if (fu_struct_id9_unknown_cmd_get_unknown2(st) != 0) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructId9UnknownCmd.unknown2 was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0,
                    (guint) fu_struct_id9_unknown_cmd_get_unknown2(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_id9_spi_cmd_ref: (skip):
 **/
FuStructId9SpiCmd *
fu_struct_id9_spi_cmd_ref(FuStructId9SpiCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_id9_spi_cmd_unref: (skip):
 **/
void
fu_struct_id9_spi_cmd_unref(FuStructId9SpiCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructId9SpiCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_id9_spi_cmd_new_internal: (skip):
 **/
static FuStructId9SpiCmd *
fu_struct_id9_spi_cmd_new_internal(void)
{
    FuStructId9SpiCmd *st = g_new0(FuStructId9SpiCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_id9_spi_cmd_get_command: (skip):
 **/
static guint8
fu_struct_id9_spi_cmd_get_command(const FuStructId9SpiCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_id9_spi_cmd_get_start_addr: (skip):
 **/
static guint32
fu_struct_id9_spi_cmd_get_start_addr(const FuStructId9SpiCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_id9_spi_cmd_set_command: (skip):
 **/
static void
fu_struct_id9_spi_cmd_set_command(FuStructId9SpiCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_id9_spi_cmd_set_start_addr: (skip):
 **/
static void
fu_struct_id9_spi_cmd_set_start_addr(FuStructId9SpiCmd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_spi_cmd_set_size: (skip):
 **/
void
fu_struct_id9_spi_cmd_set_size(FuStructId9SpiCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 5, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_spi_cmd_set_data: (skip):
 **/
gboolean
fu_struct_id9_spi_cmd_set_data(FuStructId9SpiCmd *st, const FuStructId9UnknownCmd *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_ID9_UNKNOWN_CMD_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructId9UnknownCmd' (0x%x bytes) does not fit in "
                    "FuStructId9SpiCmd.data (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_ID9_UNKNOWN_CMD_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_ID9_SPI_CMD_OFFSET_DATA, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_id9_spi_cmd_new: (skip):
 **/
FuStructId9SpiCmd *
fu_struct_id9_spi_cmd_new(void)
{
    FuStructId9SpiCmd *st = fu_struct_id9_spi_cmd_new_internal();
    st->buf = g_byte_array_sized_new(15);
    fu_byte_array_set_size(st->buf, 15, 0x0);
    {
        g_autoptr(FuStructId9UnknownCmd) st_donor = fu_struct_id9_unknown_cmd_new();
        memcpy(st->buf->data + 0x7, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    fu_struct_id9_spi_cmd_set_command(st, 0x91);
    fu_struct_id9_spi_cmd_set_start_addr(st, 0);
    return st;
}
static gboolean
fu_struct_id9_spi_cmd_validate_internal(FuStructId9SpiCmd *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_id9_spi_cmd_get_command(st) != 0x91) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructId9SpiCmd.command was not valid");
        return FALSE;
    }
    if (fu_struct_id9_spi_cmd_get_start_addr(st) != 0) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructId9SpiCmd.start_addr was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0,
                    (guint) fu_struct_id9_spi_cmd_get_start_addr(st));
        return FALSE;
    }
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x7,
            .len = 8,
        };
        FuStructId9UnknownCmd st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_id9_unknown_cmd_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_id9_loader_cmd_ref: (skip):
 **/
FuStructId9LoaderCmd *
fu_struct_id9_loader_cmd_ref(FuStructId9LoaderCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_id9_loader_cmd_unref: (skip):
 **/
void
fu_struct_id9_loader_cmd_unref(FuStructId9LoaderCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructId9LoaderCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_id9_loader_cmd_new_internal: (skip):
 **/
static FuStructId9LoaderCmd *
fu_struct_id9_loader_cmd_new_internal(void)
{
    FuStructId9LoaderCmd *st = g_new0(FuStructId9LoaderCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_id9_loader_cmd_set_command: (skip):
 **/
void
fu_struct_id9_loader_cmd_set_command(FuStructId9LoaderCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_id9_loader_cmd_set_size: (skip):
 **/
void
fu_struct_id9_loader_cmd_set_size(FuStructId9LoaderCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_loader_cmd_set_crc: (skip):
 **/
void
fu_struct_id9_loader_cmd_set_crc(FuStructId9LoaderCmd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 3, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_loader_cmd_set_data: (skip):
 **/
gboolean
fu_struct_id9_loader_cmd_set_data(FuStructId9LoaderCmd *st, const FuStructId9SpiCmd *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_ID9_SPI_CMD_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructId9SpiCmd' (0x%x bytes) does not fit in "
                    "FuStructId9LoaderCmd.data (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_ID9_SPI_CMD_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_ID9_LOADER_CMD_OFFSET_DATA, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_id9_loader_cmd_new: (skip):
 **/
FuStructId9LoaderCmd *
fu_struct_id9_loader_cmd_new(void)
{
    FuStructId9LoaderCmd *st = fu_struct_id9_loader_cmd_new_internal();
    st->buf = g_byte_array_sized_new(22);
    fu_byte_array_set_size(st->buf, 22, 0x0);
    {
        g_autoptr(FuStructId9SpiCmd) st_donor = fu_struct_id9_spi_cmd_new();
        memcpy(st->buf->data + 0x7, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    return st;
}
/**
 * fu_struct_id9_loader_cmd_to_bytes: (skip):
 **/
GBytes *
fu_struct_id9_loader_cmd_to_bytes(const FuStructId9LoaderCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return g_bytes_new(st->buf->data, st->buf->len);
}
static gboolean
fu_struct_id9_loader_cmd_validate_internal(FuStructId9LoaderCmd *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x7,
            .len = 15,
        };
        FuStructId9SpiCmd st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_id9_spi_cmd_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_id9_loader_cmd_validate: (skip):
 **/
gboolean
fu_struct_id9_loader_cmd_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st_buf = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    FuStructId9LoaderCmd st_tmp = {.buf = &st_buf };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 22, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructId9LoaderCmd: ");
        return FALSE;
    }
    if (!fu_struct_id9_loader_cmd_validate_internal(&st_tmp, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_module_desc_ref: (skip):
 **/
FuStructModuleDesc *
fu_struct_module_desc_ref(FuStructModuleDesc *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_module_desc_unref: (skip):
 **/
void
fu_struct_module_desc_unref(FuStructModuleDesc *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructModuleDesc refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_module_desc_new_internal: (skip):
 **/
static FuStructModuleDesc *
fu_struct_module_desc_new_internal(void)
{
    FuStructModuleDesc *st = g_new0(FuStructModuleDesc, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_module_desc_get_bootloader_version: (skip):
 **/
guint16
fu_struct_module_desc_get_bootloader_version(const FuStructModuleDesc *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_module_desc_get_number_modules: (skip):
 **/
guint8
fu_struct_module_desc_get_number_modules(const FuStructModuleDesc *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}

/* setters */
/**
 * fu_struct_module_desc_to_string: (skip):
 **/
static gchar *
fu_struct_module_desc_to_string(const FuStructModuleDesc *st)
{
    g_autoptr(GString) str = g_string_new("FuStructModuleDesc:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  bootloader_version: 0x%x\n",
                           (guint) fu_struct_module_desc_get_bootloader_version(st));
    g_string_append_printf(str, "  number_modules: 0x%x\n",
                           (guint) fu_struct_module_desc_get_number_modules(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_module_desc_validate_internal(FuStructModuleDesc *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_module_desc_parse_internal(FuStructModuleDesc *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_module_desc_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_module_desc_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_module_desc_parse: (skip):
 **/
FuStructModuleDesc *
fu_struct_module_desc_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructModuleDesc) st = fu_struct_module_desc_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructModuleDesc: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_struct_module_desc_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_module_item_ref: (skip):
 **/
FuStructModuleItem *
fu_struct_module_item_ref(FuStructModuleItem *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_module_item_unref: (skip):
 **/
void
fu_struct_module_item_unref(FuStructModuleItem *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructModuleItem refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_module_item_new_internal: (skip):
 **/
static FuStructModuleItem *
fu_struct_module_item_new_internal(void)
{
    FuStructModuleItem *st = g_new0(FuStructModuleItem, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_module_item_get_kind: (skip):
 **/
FuWacModuleFwType
fu_struct_module_item_get_kind(const FuStructModuleItem *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_module_item_get_version: (skip):
 **/
guint16
fu_struct_module_item_get_version(const FuStructModuleItem *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_module_item_get_version2: (skip):
 **/
guint8
fu_struct_module_item_get_version2(const FuStructModuleItem *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}

/* setters */
/**
 * fu_struct_module_item_to_string: (skip):
 **/
static gchar *
fu_struct_module_item_to_string(const FuStructModuleItem *st)
{
    g_autoptr(GString) str = g_string_new("FuStructModuleItem:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_wac_module_fw_type_to_string(fu_struct_module_item_get_kind(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  kind: 0x%x [%s]\n", (guint) fu_struct_module_item_get_kind(st), tmp);
        } else {
            g_string_append_printf(str, "  kind: 0x%x\n", (guint) fu_struct_module_item_get_kind(st));
        }
    }
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_module_item_get_version(st));
    g_string_append_printf(str, "  version2: 0x%x\n",
                           (guint) fu_struct_module_item_get_version2(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_module_item_validate_internal(FuStructModuleItem *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_module_item_parse_internal(FuStructModuleItem *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_module_item_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_module_item_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_module_item_parse: (skip):
 **/
FuStructModuleItem *
fu_struct_module_item_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructModuleItem) st = fu_struct_module_item_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructModuleItem: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_struct_module_item_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
