/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-usb-device-ds20-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_usb_device_ms_ds20_desc_to_string(FuUsbDeviceMsDs20Desc val)
{
    if (val == FU_USB_DEVICE_MS_DS20_DESC_SET_HEADER_DESCRIPTOR)
        return "set-header-descriptor";
    if (val == FU_USB_DEVICE_MS_DS20_DESC_SUBSET_HEADER_CONFIGURATION)
        return "subset-header-configuration";
    if (val == FU_USB_DEVICE_MS_DS20_DESC_SUBSET_HEADER_FUNCTION)
        return "subset-header-function";
    if (val == FU_USB_DEVICE_MS_DS20_DESC_FEATURE_COMPATIBLE_ID)
        return "feature-compatible-id";
    if (val == FU_USB_DEVICE_MS_DS20_DESC_FEATURE_REG_PROPERTY)
        return "feature-reg-property";
    if (val == FU_USB_DEVICE_MS_DS20_DESC_FEATURE_MIN_RESUME_TIME)
        return "feature-min-resume-time";
    if (val == FU_USB_DEVICE_MS_DS20_DESC_FEATURE_MODEL_ID)
        return "feature-model-id";
    if (val == FU_USB_DEVICE_MS_DS20_DESC_FEATURE_CCGP_DEVICE)
        return "feature-ccgp-device";
    if (val == FU_USB_DEVICE_MS_DS20_DESC_FEATURE_VENDOR_REVISION)
        return "feature-vendor-revision";
    return NULL;
}
/**
 * fu_struct_ds20_ref: (skip):
 **/
FuStructDs20 *
fu_struct_ds20_ref(FuStructDs20 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ds20_unref: (skip):
 **/
void
fu_struct_ds20_unref(FuStructDs20 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDs20 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ds20_new_internal: (skip):
 **/
static FuStructDs20 *
fu_struct_ds20_new_internal(void)
{
    FuStructDs20 *st = g_new0(FuStructDs20, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ds20_get_guid: (skip):
 **/
const fwupd_guid_t *
fu_struct_ds20_get_guid(const FuStructDs20 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 1);
}
/**
 * fu_struct_ds20_get_platform_ver: (skip):
 **/
guint32
fu_struct_ds20_get_platform_ver(const FuStructDs20 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 17, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ds20_get_total_length: (skip):
 **/
guint16
fu_struct_ds20_get_total_length(const FuStructDs20 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 21, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ds20_get_vendor_code: (skip):
 **/
guint8
fu_struct_ds20_get_vendor_code(const FuStructDs20 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[23];
}
/**
 * fu_struct_ds20_get_alt_code: (skip):
 **/
guint8
fu_struct_ds20_get_alt_code(const FuStructDs20 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[24];
}

/* setters */
/**
 * fu_struct_ds20_set_guid: (skip):
 **/
void
fu_struct_ds20_set_guid(FuStructDs20 *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 1, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_ds20_set_platform_ver: (skip):
 **/
void
fu_struct_ds20_set_platform_ver(FuStructDs20 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 17, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ds20_set_total_length: (skip):
 **/
void
fu_struct_ds20_set_total_length(FuStructDs20 *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 21, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ds20_set_vendor_code: (skip):
 **/
void
fu_struct_ds20_set_vendor_code(FuStructDs20 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[23] = value;
}
/**
 * fu_struct_ds20_set_alt_code: (skip):
 **/
void
fu_struct_ds20_set_alt_code(FuStructDs20 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[24] = value;
}
/**
 * fu_struct_ds20_new: (skip):
 **/
FuStructDs20 *
fu_struct_ds20_new(void)
{
    FuStructDs20 *st = fu_struct_ds20_new_internal();
    st->buf = g_byte_array_sized_new(25);
    fu_byte_array_set_size(st->buf, 25, 0x0);
    return st;
}
/**
 * fu_struct_ds20_to_string: (skip):
 **/
static gchar *
fu_struct_ds20_to_string(const FuStructDs20 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDs20:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_ds20_get_guid(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  guid: %s\n", tmp);
    }
    g_string_append_printf(str, "  platform_ver: 0x%x\n",
                           (guint) fu_struct_ds20_get_platform_ver(st));
    g_string_append_printf(str, "  total_length: 0x%x\n",
                           (guint) fu_struct_ds20_get_total_length(st));
    g_string_append_printf(str, "  vendor_code: 0x%x\n",
                           (guint) fu_struct_ds20_get_vendor_code(st));
    g_string_append_printf(str, "  alt_code: 0x%x\n",
                           (guint) fu_struct_ds20_get_alt_code(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ds20_validate_internal(FuStructDs20 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ds20_parse_internal(FuStructDs20 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ds20_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ds20_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ds20_parse_stream: (skip):
 **/
FuStructDs20 *
fu_struct_ds20_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructDs20) st = fu_struct_ds20_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 25, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructDs20 failed read of 0x%x: ", (guint) 25);
        return NULL;
    }
    if (st->buf->len != 25) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructDs20 requested 0x%x and got 0x%x",
                    (guint) 25,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ds20_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ms_ds20_ref: (skip):
 **/
FuStructMsDs20 *
fu_struct_ms_ds20_ref(FuStructMsDs20 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ms_ds20_unref: (skip):
 **/
void
fu_struct_ms_ds20_unref(FuStructMsDs20 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructMsDs20 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ms_ds20_new_internal: (skip):
 **/
static FuStructMsDs20 *
fu_struct_ms_ds20_new_internal(void)
{
    FuStructMsDs20 *st = g_new0(FuStructMsDs20, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ms_ds20_get_size: (skip):
 **/
guint16
fu_struct_ms_ds20_get_size(const FuStructMsDs20 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ms_ds20_get_type: (skip):
 **/
guint16
fu_struct_ms_ds20_get_type(const FuStructMsDs20 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ms_ds20_set_size: (skip):
 **/
void
fu_struct_ms_ds20_set_size(FuStructMsDs20 *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ms_ds20_set_type: (skip):
 **/
void
fu_struct_ms_ds20_set_type(FuStructMsDs20 *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ms_ds20_new: (skip):
 **/
FuStructMsDs20 *
fu_struct_ms_ds20_new(void)
{
    FuStructMsDs20 *st = fu_struct_ms_ds20_new_internal();
    st->buf = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st->buf, 4, 0x0);
    return st;
}
/**
 * fu_struct_ms_ds20_to_string: (skip):
 **/
static gchar *
fu_struct_ms_ds20_to_string(const FuStructMsDs20 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructMsDs20:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_ms_ds20_get_size(st));
    g_string_append_printf(str, "  type: 0x%x\n",
                           (guint) fu_struct_ms_ds20_get_type(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ms_ds20_validate_internal(FuStructMsDs20 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ms_ds20_parse_internal(FuStructMsDs20 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ms_ds20_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ms_ds20_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ms_ds20_parse_stream: (skip):
 **/
FuStructMsDs20 *
fu_struct_ms_ds20_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructMsDs20) st = fu_struct_ms_ds20_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 4, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructMsDs20 failed read of 0x%x: ", (guint) 4);
        return NULL;
    }
    if (st->buf->len != 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructMsDs20 requested 0x%x and got 0x%x",
                    (guint) 4,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ms_ds20_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
