// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomUseCounterMetrics_h
#define mozilla_GleanDomUseCounterMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace use_counter {
  /**
   * generated from use.counter.content_documents_destroyed
   * A count of how many content documents were destroyed. Used to turn document use counters' counts into rates. Excludes documents for which we do not count use counters (See `Document::ShouldIncludeInTelemetry`).
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> content_documents_destroyed(1270);

  /**
   * generated from use.counter.dedicated_workers_destroyed
   * A count of how many `Dedicated`-kind workers were destroyed. Used to turn dedicated worker use counters' counts into rates. Excludes chrome workers.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> dedicated_workers_destroyed(1271);

  /**
   * generated from use.counter.service_workers_destroyed
   * A count of how many `Service`-kind workers were destroyed. Used to turn service worker use counters' counts into rates. Excludes chrome workers.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> service_workers_destroyed(1272);

  /**
   * generated from use.counter.shared_workers_destroyed
   * A count of how many `Shared`-kind workers were destroyed. Used to turn shared worker use counters' counts into rates. Excludes chrome workers.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> shared_workers_destroyed(1273);

  /**
   * generated from use.counter.top_level_content_documents_destroyed
   * A count of how many "pages" were destroyed. Used to turn page use counters' counts into rates. Excludes pages that contain only documents for which we do not count use counters (See `Document::ShouldIncludeInTelemetry`).
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> top_level_content_documents_destroyed(1274);
}

namespace use_counter_css_doc {
  /**
   * generated from use.counter.css.doc.alignment_baseline
   * Whether a document used the (unknown, counted) CSS property alignment-baseline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> alignment_baseline(1275);

  /**
   * generated from use.counter.css.doc.background_repeat_x
   * Whether a document used the (unknown, counted) CSS property background-repeat-x. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> background_repeat_x(1276);

  /**
   * generated from use.counter.css.doc.background_repeat_y
   * Whether a document used the (unknown, counted) CSS property background-repeat-y. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> background_repeat_y(1277);

  /**
   * generated from use.counter.css.doc.baseline_shift
   * Whether a document used the (unknown, counted) CSS property baseline-shift. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> baseline_shift(1278);

  /**
   * generated from use.counter.css.doc.buffered_rendering
   * Whether a document used the (unknown, counted) CSS property buffered-rendering. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> buffered_rendering(1279);

  /**
   * generated from use.counter.css.doc.color_rendering
   * Whether a document used the (unknown, counted) CSS property color-rendering. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> color_rendering(1280);

  /**
   * generated from use.counter.css.doc.css_accent_color
   * Whether a document used the CSS property accent-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_accent_color(1281);

  /**
   * generated from use.counter.css.doc.css_align_content
   * Whether a document used the CSS property align-content. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_align_content(1282);

  /**
   * generated from use.counter.css.doc.css_align_items
   * Whether a document used the CSS property align-items. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_align_items(1283);

  /**
   * generated from use.counter.css.doc.css_align_self
   * Whether a document used the CSS property align-self. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_align_self(1284);

  /**
   * generated from use.counter.css.doc.css_all
   * Whether a document used the CSS property all. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_all(1285);

  /**
   * generated from use.counter.css.doc.css_anchor_name
   * Whether a document used the CSS property anchor-name. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_anchor_name(1286);

  /**
   * generated from use.counter.css.doc.css_anchor_scope
   * Whether a document used the CSS property anchor-scope. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_anchor_scope(1287);

  /**
   * generated from use.counter.css.doc.css_animation
   * Whether a document used the CSS property animation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation(1288);

  /**
   * generated from use.counter.css.doc.css_animation_composition
   * Whether a document used the CSS property animation-composition. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_composition(1289);

  /**
   * generated from use.counter.css.doc.css_animation_delay
   * Whether a document used the CSS property animation-delay. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_delay(1290);

  /**
   * generated from use.counter.css.doc.css_animation_direction
   * Whether a document used the CSS property animation-direction. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_direction(1291);

  /**
   * generated from use.counter.css.doc.css_animation_duration
   * Whether a document used the CSS property animation-duration. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_duration(1292);

  /**
   * generated from use.counter.css.doc.css_animation_fill_mode
   * Whether a document used the CSS property animation-fill-mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_fill_mode(1293);

  /**
   * generated from use.counter.css.doc.css_animation_iteration_count
   * Whether a document used the CSS property animation-iteration-count. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_iteration_count(1294);

  /**
   * generated from use.counter.css.doc.css_animation_name
   * Whether a document used the CSS property animation-name. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_name(1295);

  /**
   * generated from use.counter.css.doc.css_animation_play_state
   * Whether a document used the CSS property animation-play-state. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_play_state(1296);

  /**
   * generated from use.counter.css.doc.css_animation_timeline
   * Whether a document used the CSS property animation-timeline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_timeline(1297);

  /**
   * generated from use.counter.css.doc.css_animation_timing_function
   * Whether a document used the CSS property animation-timing-function. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_timing_function(1298);

  /**
   * generated from use.counter.css.doc.css_appearance
   * Whether a document used the CSS property appearance. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_appearance(1299);

  /**
   * generated from use.counter.css.doc.css_aspect_ratio
   * Whether a document used the CSS property aspect-ratio. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_aspect_ratio(1300);

  /**
   * generated from use.counter.css.doc.css_backdrop_filter
   * Whether a document used the CSS property backdrop-filter. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_backdrop_filter(1301);

  /**
   * generated from use.counter.css.doc.css_backface_visibility
   * Whether a document used the CSS property backface-visibility. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_backface_visibility(1302);

  /**
   * generated from use.counter.css.doc.css_background
   * Whether a document used the CSS property background. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background(1303);

  /**
   * generated from use.counter.css.doc.css_background_attachment
   * Whether a document used the CSS property background-attachment. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_attachment(1304);

  /**
   * generated from use.counter.css.doc.css_background_blend_mode
   * Whether a document used the CSS property background-blend-mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_blend_mode(1305);

  /**
   * generated from use.counter.css.doc.css_background_clip
   * Whether a document used the CSS property background-clip. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_clip(1306);

  /**
   * generated from use.counter.css.doc.css_background_color
   * Whether a document used the CSS property background-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_color(1307);

  /**
   * generated from use.counter.css.doc.css_background_image
   * Whether a document used the CSS property background-image. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_image(1308);

  /**
   * generated from use.counter.css.doc.css_background_origin
   * Whether a document used the CSS property background-origin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_origin(1309);

  /**
   * generated from use.counter.css.doc.css_background_position
   * Whether a document used the CSS property background-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_position(1310);

  /**
   * generated from use.counter.css.doc.css_background_position_x
   * Whether a document used the CSS property background-position-x. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_position_x(1311);

  /**
   * generated from use.counter.css.doc.css_background_position_y
   * Whether a document used the CSS property background-position-y. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_position_y(1312);

  /**
   * generated from use.counter.css.doc.css_background_repeat
   * Whether a document used the CSS property background-repeat. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_repeat(1313);

  /**
   * generated from use.counter.css.doc.css_background_size
   * Whether a document used the CSS property background-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_size(1314);

  /**
   * generated from use.counter.css.doc.css_baseline_source
   * Whether a document used the CSS property baseline-source. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_baseline_source(1315);

  /**
   * generated from use.counter.css.doc.css_block_size
   * Whether a document used the CSS property block-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_block_size(1316);

  /**
   * generated from use.counter.css.doc.css_border
   * Whether a document used the CSS property border. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border(1317);

  /**
   * generated from use.counter.css.doc.css_border_block
   * Whether a document used the CSS property border-block. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block(1318);

  /**
   * generated from use.counter.css.doc.css_border_block_color
   * Whether a document used the CSS property border-block-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_color(1319);

  /**
   * generated from use.counter.css.doc.css_border_block_end
   * Whether a document used the CSS property border-block-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_end(1320);

  /**
   * generated from use.counter.css.doc.css_border_block_end_color
   * Whether a document used the CSS property border-block-end-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_end_color(1321);

  /**
   * generated from use.counter.css.doc.css_border_block_end_style
   * Whether a document used the CSS property border-block-end-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_end_style(1322);

  /**
   * generated from use.counter.css.doc.css_border_block_end_width
   * Whether a document used the CSS property border-block-end-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_end_width(1323);

  /**
   * generated from use.counter.css.doc.css_border_block_start
   * Whether a document used the CSS property border-block-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_start(1324);

  /**
   * generated from use.counter.css.doc.css_border_block_start_color
   * Whether a document used the CSS property border-block-start-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_start_color(1325);

  /**
   * generated from use.counter.css.doc.css_border_block_start_style
   * Whether a document used the CSS property border-block-start-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_start_style(1326);

  /**
   * generated from use.counter.css.doc.css_border_block_start_width
   * Whether a document used the CSS property border-block-start-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_start_width(1327);

  /**
   * generated from use.counter.css.doc.css_border_block_style
   * Whether a document used the CSS property border-block-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_style(1328);

  /**
   * generated from use.counter.css.doc.css_border_block_width
   * Whether a document used the CSS property border-block-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_width(1329);

  /**
   * generated from use.counter.css.doc.css_border_bottom
   * Whether a document used the CSS property border-bottom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom(1330);

  /**
   * generated from use.counter.css.doc.css_border_bottom_color
   * Whether a document used the CSS property border-bottom-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom_color(1331);

  /**
   * generated from use.counter.css.doc.css_border_bottom_left_radius
   * Whether a document used the CSS property border-bottom-left-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom_left_radius(1332);

  /**
   * generated from use.counter.css.doc.css_border_bottom_right_radius
   * Whether a document used the CSS property border-bottom-right-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom_right_radius(1333);

  /**
   * generated from use.counter.css.doc.css_border_bottom_style
   * Whether a document used the CSS property border-bottom-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom_style(1334);

  /**
   * generated from use.counter.css.doc.css_border_bottom_width
   * Whether a document used the CSS property border-bottom-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom_width(1335);

  /**
   * generated from use.counter.css.doc.css_border_collapse
   * Whether a document used the CSS property border-collapse. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_collapse(1336);

  /**
   * generated from use.counter.css.doc.css_border_color
   * Whether a document used the CSS property border-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_color(1337);

  /**
   * generated from use.counter.css.doc.css_border_end_end_radius
   * Whether a document used the CSS property border-end-end-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_end_end_radius(1338);

  /**
   * generated from use.counter.css.doc.css_border_end_start_radius
   * Whether a document used the CSS property border-end-start-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_end_start_radius(1339);

  /**
   * generated from use.counter.css.doc.css_border_image
   * Whether a document used the CSS property border-image. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image(1340);

  /**
   * generated from use.counter.css.doc.css_border_image_outset
   * Whether a document used the CSS property border-image-outset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image_outset(1341);

  /**
   * generated from use.counter.css.doc.css_border_image_repeat
   * Whether a document used the CSS property border-image-repeat. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image_repeat(1342);

  /**
   * generated from use.counter.css.doc.css_border_image_slice
   * Whether a document used the CSS property border-image-slice. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image_slice(1343);

  /**
   * generated from use.counter.css.doc.css_border_image_source
   * Whether a document used the CSS property border-image-source. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image_source(1344);

  /**
   * generated from use.counter.css.doc.css_border_image_width
   * Whether a document used the CSS property border-image-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image_width(1345);

  /**
   * generated from use.counter.css.doc.css_border_inline
   * Whether a document used the CSS property border-inline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline(1346);

  /**
   * generated from use.counter.css.doc.css_border_inline_color
   * Whether a document used the CSS property border-inline-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_color(1347);

  /**
   * generated from use.counter.css.doc.css_border_inline_end
   * Whether a document used the CSS property border-inline-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_end(1348);

  /**
   * generated from use.counter.css.doc.css_border_inline_end_color
   * Whether a document used the CSS property border-inline-end-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_end_color(1349);

  /**
   * generated from use.counter.css.doc.css_border_inline_end_style
   * Whether a document used the CSS property border-inline-end-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_end_style(1350);

  /**
   * generated from use.counter.css.doc.css_border_inline_end_width
   * Whether a document used the CSS property border-inline-end-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_end_width(1351);

  /**
   * generated from use.counter.css.doc.css_border_inline_start
   * Whether a document used the CSS property border-inline-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_start(1352);

  /**
   * generated from use.counter.css.doc.css_border_inline_start_color
   * Whether a document used the CSS property border-inline-start-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_start_color(1353);

  /**
   * generated from use.counter.css.doc.css_border_inline_start_style
   * Whether a document used the CSS property border-inline-start-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_start_style(1354);

  /**
   * generated from use.counter.css.doc.css_border_inline_start_width
   * Whether a document used the CSS property border-inline-start-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_start_width(1355);

  /**
   * generated from use.counter.css.doc.css_border_inline_style
   * Whether a document used the CSS property border-inline-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_style(1356);

  /**
   * generated from use.counter.css.doc.css_border_inline_width
   * Whether a document used the CSS property border-inline-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_width(1357);

  /**
   * generated from use.counter.css.doc.css_border_left
   * Whether a document used the CSS property border-left. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_left(1358);

  /**
   * generated from use.counter.css.doc.css_border_left_color
   * Whether a document used the CSS property border-left-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_left_color(1359);

  /**
   * generated from use.counter.css.doc.css_border_left_style
   * Whether a document used the CSS property border-left-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_left_style(1360);

  /**
   * generated from use.counter.css.doc.css_border_left_width
   * Whether a document used the CSS property border-left-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_left_width(1361);

  /**
   * generated from use.counter.css.doc.css_border_radius
   * Whether a document used the CSS property border-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_radius(1362);

  /**
   * generated from use.counter.css.doc.css_border_right
   * Whether a document used the CSS property border-right. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_right(1363);

  /**
   * generated from use.counter.css.doc.css_border_right_color
   * Whether a document used the CSS property border-right-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_right_color(1364);

  /**
   * generated from use.counter.css.doc.css_border_right_style
   * Whether a document used the CSS property border-right-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_right_style(1365);

  /**
   * generated from use.counter.css.doc.css_border_right_width
   * Whether a document used the CSS property border-right-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_right_width(1366);

  /**
   * generated from use.counter.css.doc.css_border_spacing
   * Whether a document used the CSS property border-spacing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_spacing(1367);

  /**
   * generated from use.counter.css.doc.css_border_start_end_radius
   * Whether a document used the CSS property border-start-end-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_start_end_radius(1368);

  /**
   * generated from use.counter.css.doc.css_border_start_start_radius
   * Whether a document used the CSS property border-start-start-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_start_start_radius(1369);

  /**
   * generated from use.counter.css.doc.css_border_style
   * Whether a document used the CSS property border-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_style(1370);

  /**
   * generated from use.counter.css.doc.css_border_top
   * Whether a document used the CSS property border-top. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top(1371);

  /**
   * generated from use.counter.css.doc.css_border_top_color
   * Whether a document used the CSS property border-top-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top_color(1372);

  /**
   * generated from use.counter.css.doc.css_border_top_left_radius
   * Whether a document used the CSS property border-top-left-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top_left_radius(1373);

  /**
   * generated from use.counter.css.doc.css_border_top_right_radius
   * Whether a document used the CSS property border-top-right-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top_right_radius(1374);

  /**
   * generated from use.counter.css.doc.css_border_top_style
   * Whether a document used the CSS property border-top-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top_style(1375);

  /**
   * generated from use.counter.css.doc.css_border_top_width
   * Whether a document used the CSS property border-top-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top_width(1376);

  /**
   * generated from use.counter.css.doc.css_border_width
   * Whether a document used the CSS property border-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_width(1377);

  /**
   * generated from use.counter.css.doc.css_bottom
   * Whether a document used the CSS property bottom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_bottom(1378);

  /**
   * generated from use.counter.css.doc.css_box_decoration_break
   * Whether a document used the CSS property box-decoration-break. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_box_decoration_break(1379);

  /**
   * generated from use.counter.css.doc.css_box_shadow
   * Whether a document used the CSS property box-shadow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_box_shadow(1380);

  /**
   * generated from use.counter.css.doc.css_box_sizing
   * Whether a document used the CSS property box-sizing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_box_sizing(1381);

  /**
   * generated from use.counter.css.doc.css_break_after
   * Whether a document used the CSS property break-after. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_break_after(1382);

  /**
   * generated from use.counter.css.doc.css_break_before
   * Whether a document used the CSS property break-before. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_break_before(1383);

  /**
   * generated from use.counter.css.doc.css_break_inside
   * Whether a document used the CSS property break-inside. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_break_inside(1384);

  /**
   * generated from use.counter.css.doc.css_caption_side
   * Whether a document used the CSS property caption-side. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_caption_side(1385);

  /**
   * generated from use.counter.css.doc.css_caret_color
   * Whether a document used the CSS property caret-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_caret_color(1386);

  /**
   * generated from use.counter.css.doc.css_clear
   * Whether a document used the CSS property clear. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_clear(1387);

  /**
   * generated from use.counter.css.doc.css_clip
   * Whether a document used the CSS property clip. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_clip(1388);

  /**
   * generated from use.counter.css.doc.css_clip_path
   * Whether a document used the CSS property clip-path. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_clip_path(1389);

  /**
   * generated from use.counter.css.doc.css_clip_rule
   * Whether a document used the CSS property clip-rule. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_clip_rule(1390);

  /**
   * generated from use.counter.css.doc.css_color
   * Whether a document used the CSS property color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_color(1391);

  /**
   * generated from use.counter.css.doc.css_color_adjust
   * Whether a document used the CSS property color-adjust. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_color_adjust(1392);

  /**
   * generated from use.counter.css.doc.css_color_interpolation
   * Whether a document used the CSS property color-interpolation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_color_interpolation(1393);

  /**
   * generated from use.counter.css.doc.css_color_interpolation_filters
   * Whether a document used the CSS property color-interpolation-filters. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_color_interpolation_filters(1394);

  /**
   * generated from use.counter.css.doc.css_color_scheme
   * Whether a document used the CSS property color-scheme. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_color_scheme(1395);

  /**
   * generated from use.counter.css.doc.css_column_count
   * Whether a document used the CSS property column-count. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_count(1396);

  /**
   * generated from use.counter.css.doc.css_column_fill
   * Whether a document used the CSS property column-fill. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_fill(1397);

  /**
   * generated from use.counter.css.doc.css_column_gap
   * Whether a document used the CSS property column-gap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_gap(1398);

  /**
   * generated from use.counter.css.doc.css_column_rule
   * Whether a document used the CSS property column-rule. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_rule(1399);

  /**
   * generated from use.counter.css.doc.css_column_rule_color
   * Whether a document used the CSS property column-rule-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_rule_color(1400);

  /**
   * generated from use.counter.css.doc.css_column_rule_style
   * Whether a document used the CSS property column-rule-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_rule_style(1401);

  /**
   * generated from use.counter.css.doc.css_column_rule_width
   * Whether a document used the CSS property column-rule-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_rule_width(1402);

  /**
   * generated from use.counter.css.doc.css_column_span
   * Whether a document used the CSS property column-span. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_span(1403);

  /**
   * generated from use.counter.css.doc.css_column_width
   * Whether a document used the CSS property column-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_width(1404);

  /**
   * generated from use.counter.css.doc.css_columns
   * Whether a document used the CSS property columns. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_columns(1405);

  /**
   * generated from use.counter.css.doc.css_contain
   * Whether a document used the CSS property contain. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain(1406);

  /**
   * generated from use.counter.css.doc.css_contain_intrinsic_block_size
   * Whether a document used the CSS property contain-intrinsic-block-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain_intrinsic_block_size(1407);

  /**
   * generated from use.counter.css.doc.css_contain_intrinsic_height
   * Whether a document used the CSS property contain-intrinsic-height. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain_intrinsic_height(1408);

  /**
   * generated from use.counter.css.doc.css_contain_intrinsic_inline_size
   * Whether a document used the CSS property contain-intrinsic-inline-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain_intrinsic_inline_size(1409);

  /**
   * generated from use.counter.css.doc.css_contain_intrinsic_size
   * Whether a document used the CSS property contain-intrinsic-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain_intrinsic_size(1410);

  /**
   * generated from use.counter.css.doc.css_contain_intrinsic_width
   * Whether a document used the CSS property contain-intrinsic-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain_intrinsic_width(1411);

  /**
   * generated from use.counter.css.doc.css_container
   * Whether a document used the CSS property container. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_container(1412);

  /**
   * generated from use.counter.css.doc.css_container_name
   * Whether a document used the CSS property container-name. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_container_name(1413);

  /**
   * generated from use.counter.css.doc.css_container_type
   * Whether a document used the CSS property container-type. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_container_type(1414);

  /**
   * generated from use.counter.css.doc.css_content
   * Whether a document used the CSS property content. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_content(1415);

  /**
   * generated from use.counter.css.doc.css_content_visibility
   * Whether a document used the CSS property content-visibility. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_content_visibility(1416);

  /**
   * generated from use.counter.css.doc.css_counter_increment
   * Whether a document used the CSS property counter-increment. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_counter_increment(1417);

  /**
   * generated from use.counter.css.doc.css_counter_reset
   * Whether a document used the CSS property counter-reset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_counter_reset(1418);

  /**
   * generated from use.counter.css.doc.css_counter_set
   * Whether a document used the CSS property counter-set. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_counter_set(1419);

  /**
   * generated from use.counter.css.doc.css_cursor
   * Whether a document used the CSS property cursor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_cursor(1420);

  /**
   * generated from use.counter.css.doc.css_cx
   * Whether a document used the CSS property cx. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_cx(1421);

  /**
   * generated from use.counter.css.doc.css_cy
   * Whether a document used the CSS property cy. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_cy(1422);

  /**
   * generated from use.counter.css.doc.css_d
   * Whether a document used the CSS property d. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_d(1423);

  /**
   * generated from use.counter.css.doc.css_direction
   * Whether a document used the CSS property direction. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_direction(1424);

  /**
   * generated from use.counter.css.doc.css_display
   * Whether a document used the CSS property display. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_display(1425);

  /**
   * generated from use.counter.css.doc.css_dominant_baseline
   * Whether a document used the CSS property dominant-baseline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_dominant_baseline(1426);

  /**
   * generated from use.counter.css.doc.css_empty_cells
   * Whether a document used the CSS property empty-cells. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_empty_cells(1427);

  /**
   * generated from use.counter.css.doc.css_field_sizing
   * Whether a document used the CSS property field-sizing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_field_sizing(1428);

  /**
   * generated from use.counter.css.doc.css_fill
   * Whether a document used the CSS property fill. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_fill(1429);

  /**
   * generated from use.counter.css.doc.css_fill_opacity
   * Whether a document used the CSS property fill-opacity. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_fill_opacity(1430);

  /**
   * generated from use.counter.css.doc.css_fill_rule
   * Whether a document used the CSS property fill-rule. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_fill_rule(1431);

  /**
   * generated from use.counter.css.doc.css_filter
   * Whether a document used the CSS property filter. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_filter(1432);

  /**
   * generated from use.counter.css.doc.css_flex
   * Whether a document used the CSS property flex. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex(1433);

  /**
   * generated from use.counter.css.doc.css_flex_basis
   * Whether a document used the CSS property flex-basis. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_basis(1434);

  /**
   * generated from use.counter.css.doc.css_flex_direction
   * Whether a document used the CSS property flex-direction. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_direction(1435);

  /**
   * generated from use.counter.css.doc.css_flex_flow
   * Whether a document used the CSS property flex-flow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_flow(1436);

  /**
   * generated from use.counter.css.doc.css_flex_grow
   * Whether a document used the CSS property flex-grow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_grow(1437);

  /**
   * generated from use.counter.css.doc.css_flex_shrink
   * Whether a document used the CSS property flex-shrink. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_shrink(1438);

  /**
   * generated from use.counter.css.doc.css_flex_wrap
   * Whether a document used the CSS property flex-wrap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_wrap(1439);

  /**
   * generated from use.counter.css.doc.css_float
   * Whether a document used the CSS property float. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_float(1440);

  /**
   * generated from use.counter.css.doc.css_flood_color
   * Whether a document used the CSS property flood-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flood_color(1441);

  /**
   * generated from use.counter.css.doc.css_flood_opacity
   * Whether a document used the CSS property flood-opacity. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flood_opacity(1442);

  /**
   * generated from use.counter.css.doc.css_font
   * Whether a document used the CSS property font. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font(1443);

  /**
   * generated from use.counter.css.doc.css_font_family
   * Whether a document used the CSS property font-family. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_family(1444);

  /**
   * generated from use.counter.css.doc.css_font_feature_settings
   * Whether a document used the CSS property font-feature-settings. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_feature_settings(1445);

  /**
   * generated from use.counter.css.doc.css_font_kerning
   * Whether a document used the CSS property font-kerning. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_kerning(1446);

  /**
   * generated from use.counter.css.doc.css_font_language_override
   * Whether a document used the CSS property font-language-override. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_language_override(1447);

  /**
   * generated from use.counter.css.doc.css_font_optical_sizing
   * Whether a document used the CSS property font-optical-sizing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_optical_sizing(1448);

  /**
   * generated from use.counter.css.doc.css_font_palette
   * Whether a document used the CSS property font-palette. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_palette(1449);

  /**
   * generated from use.counter.css.doc.css_font_size
   * Whether a document used the CSS property font-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_size(1450);

  /**
   * generated from use.counter.css.doc.css_font_size_adjust
   * Whether a document used the CSS property font-size-adjust. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_size_adjust(1451);

  /**
   * generated from use.counter.css.doc.css_font_stretch
   * Whether a document used the CSS property font-stretch. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_stretch(1452);

  /**
   * generated from use.counter.css.doc.css_font_style
   * Whether a document used the CSS property font-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_style(1453);

  /**
   * generated from use.counter.css.doc.css_font_synthesis
   * Whether a document used the CSS property font-synthesis. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_synthesis(1454);

  /**
   * generated from use.counter.css.doc.css_font_synthesis_position
   * Whether a document used the CSS property font-synthesis-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_synthesis_position(1455);

  /**
   * generated from use.counter.css.doc.css_font_synthesis_small_caps
   * Whether a document used the CSS property font-synthesis-small-caps. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_synthesis_small_caps(1456);

  /**
   * generated from use.counter.css.doc.css_font_synthesis_style
   * Whether a document used the CSS property font-synthesis-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_synthesis_style(1457);

  /**
   * generated from use.counter.css.doc.css_font_synthesis_weight
   * Whether a document used the CSS property font-synthesis-weight. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_synthesis_weight(1458);

  /**
   * generated from use.counter.css.doc.css_font_variant
   * Whether a document used the CSS property font-variant. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant(1459);

  /**
   * generated from use.counter.css.doc.css_font_variant_alternates
   * Whether a document used the CSS property font-variant-alternates. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_alternates(1460);

  /**
   * generated from use.counter.css.doc.css_font_variant_caps
   * Whether a document used the CSS property font-variant-caps. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_caps(1461);

  /**
   * generated from use.counter.css.doc.css_font_variant_east_asian
   * Whether a document used the CSS property font-variant-east-asian. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_east_asian(1462);

  /**
   * generated from use.counter.css.doc.css_font_variant_emoji
   * Whether a document used the CSS property font-variant-emoji. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_emoji(1463);

  /**
   * generated from use.counter.css.doc.css_font_variant_ligatures
   * Whether a document used the CSS property font-variant-ligatures. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_ligatures(1464);

  /**
   * generated from use.counter.css.doc.css_font_variant_numeric
   * Whether a document used the CSS property font-variant-numeric. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_numeric(1465);

  /**
   * generated from use.counter.css.doc.css_font_variant_position
   * Whether a document used the CSS property font-variant-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_position(1466);

  /**
   * generated from use.counter.css.doc.css_font_variation_settings
   * Whether a document used the CSS property font-variation-settings. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variation_settings(1467);

  /**
   * generated from use.counter.css.doc.css_font_weight
   * Whether a document used the CSS property font-weight. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_weight(1468);

  /**
   * generated from use.counter.css.doc.css_forced_color_adjust
   * Whether a document used the CSS property forced-color-adjust. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_forced_color_adjust(1469);

  /**
   * generated from use.counter.css.doc.css_gap
   * Whether a document used the CSS property gap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_gap(1470);

  /**
   * generated from use.counter.css.doc.css_grid
   * Whether a document used the CSS property grid. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid(1471);

  /**
   * generated from use.counter.css.doc.css_grid_area
   * Whether a document used the CSS property grid-area. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_area(1472);

  /**
   * generated from use.counter.css.doc.css_grid_auto_columns
   * Whether a document used the CSS property grid-auto-columns. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_auto_columns(1473);

  /**
   * generated from use.counter.css.doc.css_grid_auto_flow
   * Whether a document used the CSS property grid-auto-flow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_auto_flow(1474);

  /**
   * generated from use.counter.css.doc.css_grid_auto_rows
   * Whether a document used the CSS property grid-auto-rows. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_auto_rows(1475);

  /**
   * generated from use.counter.css.doc.css_grid_column
   * Whether a document used the CSS property grid-column. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_column(1476);

  /**
   * generated from use.counter.css.doc.css_grid_column_end
   * Whether a document used the CSS property grid-column-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_column_end(1477);

  /**
   * generated from use.counter.css.doc.css_grid_column_gap
   * Whether a document used the CSS property grid-column-gap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_column_gap(1478);

  /**
   * generated from use.counter.css.doc.css_grid_column_start
   * Whether a document used the CSS property grid-column-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_column_start(1479);

  /**
   * generated from use.counter.css.doc.css_grid_gap
   * Whether a document used the CSS property grid-gap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_gap(1480);

  /**
   * generated from use.counter.css.doc.css_grid_row
   * Whether a document used the CSS property grid-row. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_row(1481);

  /**
   * generated from use.counter.css.doc.css_grid_row_end
   * Whether a document used the CSS property grid-row-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_row_end(1482);

  /**
   * generated from use.counter.css.doc.css_grid_row_gap
   * Whether a document used the CSS property grid-row-gap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_row_gap(1483);

  /**
   * generated from use.counter.css.doc.css_grid_row_start
   * Whether a document used the CSS property grid-row-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_row_start(1484);

  /**
   * generated from use.counter.css.doc.css_grid_template
   * Whether a document used the CSS property grid-template. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_template(1485);

  /**
   * generated from use.counter.css.doc.css_grid_template_areas
   * Whether a document used the CSS property grid-template-areas. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_template_areas(1486);

  /**
   * generated from use.counter.css.doc.css_grid_template_columns
   * Whether a document used the CSS property grid-template-columns. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_template_columns(1487);

  /**
   * generated from use.counter.css.doc.css_grid_template_rows
   * Whether a document used the CSS property grid-template-rows. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_template_rows(1488);

  /**
   * generated from use.counter.css.doc.css_height
   * Whether a document used the CSS property height. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_height(1489);

  /**
   * generated from use.counter.css.doc.css_hyphenate_character
   * Whether a document used the CSS property hyphenate-character. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_hyphenate_character(1490);

  /**
   * generated from use.counter.css.doc.css_hyphenate_limit_chars
   * Whether a document used the CSS property hyphenate-limit-chars. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_hyphenate_limit_chars(1491);

  /**
   * generated from use.counter.css.doc.css_hyphens
   * Whether a document used the CSS property hyphens. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_hyphens(1492);

  /**
   * generated from use.counter.css.doc.css_image_orientation
   * Whether a document used the CSS property image-orientation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_image_orientation(1493);

  /**
   * generated from use.counter.css.doc.css_image_rendering
   * Whether a document used the CSS property image-rendering. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_image_rendering(1494);

  /**
   * generated from use.counter.css.doc.css_ime_mode
   * Whether a document used the CSS property ime-mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_ime_mode(1495);

  /**
   * generated from use.counter.css.doc.css_initial_letter
   * Whether a document used the CSS property initial-letter. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_initial_letter(1496);

  /**
   * generated from use.counter.css.doc.css_inline_size
   * Whether a document used the CSS property inline-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inline_size(1497);

  /**
   * generated from use.counter.css.doc.css_inset
   * Whether a document used the CSS property inset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset(1498);

  /**
   * generated from use.counter.css.doc.css_inset_block
   * Whether a document used the CSS property inset-block. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_block(1499);

  /**
   * generated from use.counter.css.doc.css_inset_block_end
   * Whether a document used the CSS property inset-block-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_block_end(1500);

  /**
   * generated from use.counter.css.doc.css_inset_block_start
   * Whether a document used the CSS property inset-block-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_block_start(1501);

  /**
   * generated from use.counter.css.doc.css_inset_inline
   * Whether a document used the CSS property inset-inline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_inline(1502);

  /**
   * generated from use.counter.css.doc.css_inset_inline_end
   * Whether a document used the CSS property inset-inline-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_inline_end(1503);

  /**
   * generated from use.counter.css.doc.css_inset_inline_start
   * Whether a document used the CSS property inset-inline-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_inline_start(1504);

  /**
   * generated from use.counter.css.doc.css_isolation
   * Whether a document used the CSS property isolation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_isolation(1505);

  /**
   * generated from use.counter.css.doc.css_justify_content
   * Whether a document used the CSS property justify-content. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_justify_content(1506);

  /**
   * generated from use.counter.css.doc.css_justify_items
   * Whether a document used the CSS property justify-items. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_justify_items(1507);

  /**
   * generated from use.counter.css.doc.css_justify_self
   * Whether a document used the CSS property justify-self. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_justify_self(1508);

  /**
   * generated from use.counter.css.doc.css_left
   * Whether a document used the CSS property left. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_left(1509);

  /**
   * generated from use.counter.css.doc.css_letter_spacing
   * Whether a document used the CSS property letter-spacing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_letter_spacing(1510);

  /**
   * generated from use.counter.css.doc.css_lighting_color
   * Whether a document used the CSS property lighting-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_lighting_color(1511);

  /**
   * generated from use.counter.css.doc.css_line_break
   * Whether a document used the CSS property line-break. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_line_break(1512);

  /**
   * generated from use.counter.css.doc.css_line_height
   * Whether a document used the CSS property line-height. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_line_height(1513);

  /**
   * generated from use.counter.css.doc.css_list_style
   * Whether a document used the CSS property list-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_list_style(1514);

  /**
   * generated from use.counter.css.doc.css_list_style_image
   * Whether a document used the CSS property list-style-image. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_list_style_image(1515);

  /**
   * generated from use.counter.css.doc.css_list_style_position
   * Whether a document used the CSS property list-style-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_list_style_position(1516);

  /**
   * generated from use.counter.css.doc.css_list_style_type
   * Whether a document used the CSS property list-style-type. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_list_style_type(1517);

  /**
   * generated from use.counter.css.doc.css_margin
   * Whether a document used the CSS property margin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin(1518);

  /**
   * generated from use.counter.css.doc.css_margin_block
   * Whether a document used the CSS property margin-block. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_block(1519);

  /**
   * generated from use.counter.css.doc.css_margin_block_end
   * Whether a document used the CSS property margin-block-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_block_end(1520);

  /**
   * generated from use.counter.css.doc.css_margin_block_start
   * Whether a document used the CSS property margin-block-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_block_start(1521);

  /**
   * generated from use.counter.css.doc.css_margin_bottom
   * Whether a document used the CSS property margin-bottom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_bottom(1522);

  /**
   * generated from use.counter.css.doc.css_margin_inline
   * Whether a document used the CSS property margin-inline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_inline(1523);

  /**
   * generated from use.counter.css.doc.css_margin_inline_end
   * Whether a document used the CSS property margin-inline-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_inline_end(1524);

  /**
   * generated from use.counter.css.doc.css_margin_inline_start
   * Whether a document used the CSS property margin-inline-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_inline_start(1525);

  /**
   * generated from use.counter.css.doc.css_margin_left
   * Whether a document used the CSS property margin-left. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_left(1526);

  /**
   * generated from use.counter.css.doc.css_margin_right
   * Whether a document used the CSS property margin-right. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_right(1527);

  /**
   * generated from use.counter.css.doc.css_margin_top
   * Whether a document used the CSS property margin-top. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_top(1528);

  /**
   * generated from use.counter.css.doc.css_marker
   * Whether a document used the CSS property marker. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_marker(1529);

  /**
   * generated from use.counter.css.doc.css_marker_end
   * Whether a document used the CSS property marker-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_marker_end(1530);

  /**
   * generated from use.counter.css.doc.css_marker_mid
   * Whether a document used the CSS property marker-mid. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_marker_mid(1531);

  /**
   * generated from use.counter.css.doc.css_marker_start
   * Whether a document used the CSS property marker-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_marker_start(1532);

  /**
   * generated from use.counter.css.doc.css_mask
   * Whether a document used the CSS property mask. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask(1533);

  /**
   * generated from use.counter.css.doc.css_mask_clip
   * Whether a document used the CSS property mask-clip. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_clip(1534);

  /**
   * generated from use.counter.css.doc.css_mask_composite
   * Whether a document used the CSS property mask-composite. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_composite(1535);

  /**
   * generated from use.counter.css.doc.css_mask_image
   * Whether a document used the CSS property mask-image. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_image(1536);

  /**
   * generated from use.counter.css.doc.css_mask_mode
   * Whether a document used the CSS property mask-mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_mode(1537);

  /**
   * generated from use.counter.css.doc.css_mask_origin
   * Whether a document used the CSS property mask-origin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_origin(1538);

  /**
   * generated from use.counter.css.doc.css_mask_position
   * Whether a document used the CSS property mask-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_position(1539);

  /**
   * generated from use.counter.css.doc.css_mask_position_x
   * Whether a document used the CSS property mask-position-x. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_position_x(1540);

  /**
   * generated from use.counter.css.doc.css_mask_position_y
   * Whether a document used the CSS property mask-position-y. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_position_y(1541);

  /**
   * generated from use.counter.css.doc.css_mask_repeat
   * Whether a document used the CSS property mask-repeat. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_repeat(1542);

  /**
   * generated from use.counter.css.doc.css_mask_size
   * Whether a document used the CSS property mask-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_size(1543);

  /**
   * generated from use.counter.css.doc.css_mask_type
   * Whether a document used the CSS property mask-type. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_type(1544);

  /**
   * generated from use.counter.css.doc.css_masonry_auto_flow
   * Whether a document used the CSS property masonry-auto-flow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_masonry_auto_flow(1545);

  /**
   * generated from use.counter.css.doc.css_math_depth
   * Whether a document used the CSS property math-depth. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_math_depth(1546);

  /**
   * generated from use.counter.css.doc.css_math_shift
   * Whether a document used the CSS property math-shift. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_math_shift(1547);

  /**
   * generated from use.counter.css.doc.css_math_style
   * Whether a document used the CSS property math-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_math_style(1548);

  /**
   * generated from use.counter.css.doc.css_max_block_size
   * Whether a document used the CSS property max-block-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_max_block_size(1549);

  /**
   * generated from use.counter.css.doc.css_max_height
   * Whether a document used the CSS property max-height. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_max_height(1550);

  /**
   * generated from use.counter.css.doc.css_max_inline_size
   * Whether a document used the CSS property max-inline-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_max_inline_size(1551);

  /**
   * generated from use.counter.css.doc.css_max_width
   * Whether a document used the CSS property max-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_max_width(1552);

  /**
   * generated from use.counter.css.doc.css_min_block_size
   * Whether a document used the CSS property min-block-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_min_block_size(1553);

  /**
   * generated from use.counter.css.doc.css_min_height
   * Whether a document used the CSS property min-height. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_min_height(1554);

  /**
   * generated from use.counter.css.doc.css_min_inline_size
   * Whether a document used the CSS property min-inline-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_min_inline_size(1555);

  /**
   * generated from use.counter.css.doc.css_min_width
   * Whether a document used the CSS property min-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_min_width(1556);

  /**
   * generated from use.counter.css.doc.css_mix_blend_mode
   * Whether a document used the CSS property mix-blend-mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mix_blend_mode(1557);

  /**
   * generated from use.counter.css.doc.css_moz_animation
   * Whether a document used the CSS property -moz-animation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation(1558);

  /**
   * generated from use.counter.css.doc.css_moz_animation_delay
   * Whether a document used the CSS property -moz-animation-delay. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_delay(1559);

  /**
   * generated from use.counter.css.doc.css_moz_animation_direction
   * Whether a document used the CSS property -moz-animation-direction. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_direction(1560);

  /**
   * generated from use.counter.css.doc.css_moz_animation_duration
   * Whether a document used the CSS property -moz-animation-duration. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_duration(1561);

  /**
   * generated from use.counter.css.doc.css_moz_animation_fill_mode
   * Whether a document used the CSS property -moz-animation-fill-mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_fill_mode(1562);

  /**
   * generated from use.counter.css.doc.css_moz_animation_iteration_count
   * Whether a document used the CSS property -moz-animation-iteration-count. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_iteration_count(1563);

  /**
   * generated from use.counter.css.doc.css_moz_animation_name
   * Whether a document used the CSS property -moz-animation-name. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_name(1564);

  /**
   * generated from use.counter.css.doc.css_moz_animation_play_state
   * Whether a document used the CSS property -moz-animation-play-state. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_play_state(1565);

  /**
   * generated from use.counter.css.doc.css_moz_animation_timing_function
   * Whether a document used the CSS property -moz-animation-timing-function. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_timing_function(1566);

  /**
   * generated from use.counter.css.doc.css_moz_appearance
   * Whether a document used the CSS property -moz-appearance. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_appearance(1567);

  /**
   * generated from use.counter.css.doc.css_moz_backface_visibility
   * Whether a document used the CSS property -moz-backface-visibility. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_backface_visibility(1568);

  /**
   * generated from use.counter.css.doc.css_moz_border_end
   * Whether a document used the CSS property -moz-border-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_end(1569);

  /**
   * generated from use.counter.css.doc.css_moz_border_end_color
   * Whether a document used the CSS property -moz-border-end-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_end_color(1570);

  /**
   * generated from use.counter.css.doc.css_moz_border_end_style
   * Whether a document used the CSS property -moz-border-end-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_end_style(1571);

  /**
   * generated from use.counter.css.doc.css_moz_border_end_width
   * Whether a document used the CSS property -moz-border-end-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_end_width(1572);

  /**
   * generated from use.counter.css.doc.css_moz_border_image
   * Whether a document used the CSS property -moz-border-image. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_image(1573);

  /**
   * generated from use.counter.css.doc.css_moz_border_start
   * Whether a document used the CSS property -moz-border-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_start(1574);

  /**
   * generated from use.counter.css.doc.css_moz_border_start_color
   * Whether a document used the CSS property -moz-border-start-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_start_color(1575);

  /**
   * generated from use.counter.css.doc.css_moz_border_start_style
   * Whether a document used the CSS property -moz-border-start-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_start_style(1576);

  /**
   * generated from use.counter.css.doc.css_moz_border_start_width
   * Whether a document used the CSS property -moz-border-start-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_start_width(1577);

  /**
   * generated from use.counter.css.doc.css_moz_box_align
   * Whether a document used the CSS property -moz-box-align. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_align(1578);

  /**
   * generated from use.counter.css.doc.css_moz_box_collapse
   * Whether a document used the CSS property -moz-box-collapse. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_collapse(1579);

  /**
   * generated from use.counter.css.doc.css_moz_box_direction
   * Whether a document used the CSS property -moz-box-direction. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_direction(1580);

  /**
   * generated from use.counter.css.doc.css_moz_box_flex
   * Whether a document used the CSS property -moz-box-flex. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_flex(1581);

  /**
   * generated from use.counter.css.doc.css_moz_box_ordinal_group
   * Whether a document used the CSS property -moz-box-ordinal-group. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_ordinal_group(1582);

  /**
   * generated from use.counter.css.doc.css_moz_box_orient
   * Whether a document used the CSS property -moz-box-orient. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_orient(1583);

  /**
   * generated from use.counter.css.doc.css_moz_box_pack
   * Whether a document used the CSS property -moz-box-pack. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_pack(1584);

  /**
   * generated from use.counter.css.doc.css_moz_box_sizing
   * Whether a document used the CSS property -moz-box-sizing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_sizing(1585);

  /**
   * generated from use.counter.css.doc.css_moz_context_properties
   * Whether a document used the CSS property -moz-context-properties. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_context_properties(1586);

  /**
   * generated from use.counter.css.doc.css_moz_control_character_visibility
   * Whether a document used the CSS property -moz-control-character-visibility. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_control_character_visibility(1587);

  /**
   * generated from use.counter.css.doc.css_moz_default_appearance
   * Whether a document used the CSS property -moz-default-appearance. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_default_appearance(1588);

  /**
   * generated from use.counter.css.doc.css_moz_float_edge
   * Whether a document used the CSS property -moz-float-edge. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_float_edge(1589);

  /**
   * generated from use.counter.css.doc.css_moz_font_feature_settings
   * Whether a document used the CSS property -moz-font-feature-settings. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_font_feature_settings(1590);

  /**
   * generated from use.counter.css.doc.css_moz_font_language_override
   * Whether a document used the CSS property -moz-font-language-override. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_font_language_override(1591);

  /**
   * generated from use.counter.css.doc.css_moz_force_broken_image_icon
   * Whether a document used the CSS property -moz-force-broken-image-icon. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_force_broken_image_icon(1592);

  /**
   * generated from use.counter.css.doc.css_moz_hyphens
   * Whether a document used the CSS property -moz-hyphens. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_hyphens(1593);

  /**
   * generated from use.counter.css.doc.css_moz_inert
   * Whether a document used the CSS property -moz-inert. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_inert(1594);

  /**
   * generated from use.counter.css.doc.css_moz_margin_end
   * Whether a document used the CSS property -moz-margin-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_margin_end(1595);

  /**
   * generated from use.counter.css.doc.css_moz_margin_start
   * Whether a document used the CSS property -moz-margin-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_margin_start(1596);

  /**
   * generated from use.counter.css.doc.css_moz_math_variant
   * Whether a document used the CSS property -moz-math-variant. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_math_variant(1597);

  /**
   * generated from use.counter.css.doc.css_moz_min_font_size_ratio
   * Whether a document used the CSS property -moz-min-font-size-ratio. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_min_font_size_ratio(1598);

  /**
   * generated from use.counter.css.doc.css_moz_orient
   * Whether a document used the CSS property -moz-orient. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_orient(1599);

  /**
   * generated from use.counter.css.doc.css_moz_osx_font_smoothing
   * Whether a document used the CSS property -moz-osx-font-smoothing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_osx_font_smoothing(1600);

  /**
   * generated from use.counter.css.doc.css_moz_padding_end
   * Whether a document used the CSS property -moz-padding-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_padding_end(1601);

  /**
   * generated from use.counter.css.doc.css_moz_padding_start
   * Whether a document used the CSS property -moz-padding-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_padding_start(1602);

  /**
   * generated from use.counter.css.doc.css_moz_perspective
   * Whether a document used the CSS property -moz-perspective. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_perspective(1603);

  /**
   * generated from use.counter.css.doc.css_moz_perspective_origin
   * Whether a document used the CSS property -moz-perspective-origin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_perspective_origin(1604);

  /**
   * generated from use.counter.css.doc.css_moz_subtree_hidden_only_visually
   * Whether a document used the CSS property -moz-subtree-hidden-only-visually. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_subtree_hidden_only_visually(1605);

  /**
   * generated from use.counter.css.doc.css_moz_tab_size
   * Whether a document used the CSS property -moz-tab-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_tab_size(1606);

  /**
   * generated from use.counter.css.doc.css_moz_text_size_adjust
   * Whether a document used the CSS property -moz-text-size-adjust. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_text_size_adjust(1607);

  /**
   * generated from use.counter.css.doc.css_moz_theme
   * Whether a document used the CSS property -moz-theme. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_theme(1608);

  /**
   * generated from use.counter.css.doc.css_moz_top_layer
   * Whether a document used the CSS property -moz-top-layer. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_top_layer(1609);

  /**
   * generated from use.counter.css.doc.css_moz_transform
   * Whether a document used the CSS property -moz-transform. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transform(1610);

  /**
   * generated from use.counter.css.doc.css_moz_transform_origin
   * Whether a document used the CSS property -moz-transform-origin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transform_origin(1611);

  /**
   * generated from use.counter.css.doc.css_moz_transform_style
   * Whether a document used the CSS property -moz-transform-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transform_style(1612);

  /**
   * generated from use.counter.css.doc.css_moz_transition
   * Whether a document used the CSS property -moz-transition. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transition(1613);

  /**
   * generated from use.counter.css.doc.css_moz_transition_delay
   * Whether a document used the CSS property -moz-transition-delay. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transition_delay(1614);

  /**
   * generated from use.counter.css.doc.css_moz_transition_duration
   * Whether a document used the CSS property -moz-transition-duration. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transition_duration(1615);

  /**
   * generated from use.counter.css.doc.css_moz_transition_property
   * Whether a document used the CSS property -moz-transition-property. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transition_property(1616);

  /**
   * generated from use.counter.css.doc.css_moz_transition_timing_function
   * Whether a document used the CSS property -moz-transition-timing-function. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transition_timing_function(1617);

  /**
   * generated from use.counter.css.doc.css_moz_user_focus
   * Whether a document used the CSS property -moz-user-focus. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_user_focus(1618);

  /**
   * generated from use.counter.css.doc.css_moz_user_select
   * Whether a document used the CSS property -moz-user-select. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_user_select(1619);

  /**
   * generated from use.counter.css.doc.css_moz_window_dragging
   * Whether a document used the CSS property -moz-window-dragging. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_window_dragging(1620);

  /**
   * generated from use.counter.css.doc.css_moz_window_input_region_margin
   * Whether a document used the CSS property -moz-window-input-region-margin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_window_input_region_margin(1621);

  /**
   * generated from use.counter.css.doc.css_moz_window_opacity
   * Whether a document used the CSS property -moz-window-opacity. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_window_opacity(1622);

  /**
   * generated from use.counter.css.doc.css_moz_window_shadow
   * Whether a document used the CSS property -moz-window-shadow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_window_shadow(1623);

  /**
   * generated from use.counter.css.doc.css_moz_window_transform
   * Whether a document used the CSS property -moz-window-transform. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_window_transform(1624);

  /**
   * generated from use.counter.css.doc.css_object_fit
   * Whether a document used the CSS property object-fit. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_object_fit(1625);

  /**
   * generated from use.counter.css.doc.css_object_position
   * Whether a document used the CSS property object-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_object_position(1626);

  /**
   * generated from use.counter.css.doc.css_offset
   * Whether a document used the CSS property offset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset(1627);

  /**
   * generated from use.counter.css.doc.css_offset_anchor
   * Whether a document used the CSS property offset-anchor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset_anchor(1628);

  /**
   * generated from use.counter.css.doc.css_offset_distance
   * Whether a document used the CSS property offset-distance. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset_distance(1629);

  /**
   * generated from use.counter.css.doc.css_offset_path
   * Whether a document used the CSS property offset-path. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset_path(1630);

  /**
   * generated from use.counter.css.doc.css_offset_position
   * Whether a document used the CSS property offset-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset_position(1631);

  /**
   * generated from use.counter.css.doc.css_offset_rotate
   * Whether a document used the CSS property offset-rotate. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset_rotate(1632);

  /**
   * generated from use.counter.css.doc.css_opacity
   * Whether a document used the CSS property opacity. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_opacity(1633);

  /**
   * generated from use.counter.css.doc.css_order
   * Whether a document used the CSS property order. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_order(1634);

  /**
   * generated from use.counter.css.doc.css_outline
   * Whether a document used the CSS property outline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_outline(1635);

  /**
   * generated from use.counter.css.doc.css_outline_color
   * Whether a document used the CSS property outline-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_outline_color(1636);

  /**
   * generated from use.counter.css.doc.css_outline_offset
   * Whether a document used the CSS property outline-offset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_outline_offset(1637);

  /**
   * generated from use.counter.css.doc.css_outline_style
   * Whether a document used the CSS property outline-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_outline_style(1638);

  /**
   * generated from use.counter.css.doc.css_outline_width
   * Whether a document used the CSS property outline-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_outline_width(1639);

  /**
   * generated from use.counter.css.doc.css_overflow
   * Whether a document used the CSS property overflow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow(1640);

  /**
   * generated from use.counter.css.doc.css_overflow_anchor
   * Whether a document used the CSS property overflow-anchor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_anchor(1641);

  /**
   * generated from use.counter.css.doc.css_overflow_block
   * Whether a document used the CSS property overflow-block. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_block(1642);

  /**
   * generated from use.counter.css.doc.css_overflow_clip_margin
   * Whether a document used the CSS property overflow-clip-margin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_clip_margin(1643);

  /**
   * generated from use.counter.css.doc.css_overflow_inline
   * Whether a document used the CSS property overflow-inline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_inline(1644);

  /**
   * generated from use.counter.css.doc.css_overflow_wrap
   * Whether a document used the CSS property overflow-wrap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_wrap(1645);

  /**
   * generated from use.counter.css.doc.css_overflow_x
   * Whether a document used the CSS property overflow-x. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_x(1646);

  /**
   * generated from use.counter.css.doc.css_overflow_y
   * Whether a document used the CSS property overflow-y. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_y(1647);

  /**
   * generated from use.counter.css.doc.css_overscroll_behavior
   * Whether a document used the CSS property overscroll-behavior. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overscroll_behavior(1648);

  /**
   * generated from use.counter.css.doc.css_overscroll_behavior_block
   * Whether a document used the CSS property overscroll-behavior-block. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overscroll_behavior_block(1649);

  /**
   * generated from use.counter.css.doc.css_overscroll_behavior_inline
   * Whether a document used the CSS property overscroll-behavior-inline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overscroll_behavior_inline(1650);

  /**
   * generated from use.counter.css.doc.css_overscroll_behavior_x
   * Whether a document used the CSS property overscroll-behavior-x. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overscroll_behavior_x(1651);

  /**
   * generated from use.counter.css.doc.css_overscroll_behavior_y
   * Whether a document used the CSS property overscroll-behavior-y. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overscroll_behavior_y(1652);

  /**
   * generated from use.counter.css.doc.css_padding
   * Whether a document used the CSS property padding. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding(1653);

  /**
   * generated from use.counter.css.doc.css_padding_block
   * Whether a document used the CSS property padding-block. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_block(1654);

  /**
   * generated from use.counter.css.doc.css_padding_block_end
   * Whether a document used the CSS property padding-block-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_block_end(1655);

  /**
   * generated from use.counter.css.doc.css_padding_block_start
   * Whether a document used the CSS property padding-block-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_block_start(1656);

  /**
   * generated from use.counter.css.doc.css_padding_bottom
   * Whether a document used the CSS property padding-bottom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_bottom(1657);

  /**
   * generated from use.counter.css.doc.css_padding_inline
   * Whether a document used the CSS property padding-inline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_inline(1658);

  /**
   * generated from use.counter.css.doc.css_padding_inline_end
   * Whether a document used the CSS property padding-inline-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_inline_end(1659);

  /**
   * generated from use.counter.css.doc.css_padding_inline_start
   * Whether a document used the CSS property padding-inline-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_inline_start(1660);

  /**
   * generated from use.counter.css.doc.css_padding_left
   * Whether a document used the CSS property padding-left. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_left(1661);

  /**
   * generated from use.counter.css.doc.css_padding_right
   * Whether a document used the CSS property padding-right. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_right(1662);

  /**
   * generated from use.counter.css.doc.css_padding_top
   * Whether a document used the CSS property padding-top. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_top(1663);

  /**
   * generated from use.counter.css.doc.css_page
   * Whether a document used the CSS property page. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_page(1664);

  /**
   * generated from use.counter.css.doc.css_page_break_after
   * Whether a document used the CSS property page-break-after. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_page_break_after(1665);

  /**
   * generated from use.counter.css.doc.css_page_break_before
   * Whether a document used the CSS property page-break-before. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_page_break_before(1666);

  /**
   * generated from use.counter.css.doc.css_page_break_inside
   * Whether a document used the CSS property page-break-inside. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_page_break_inside(1667);

  /**
   * generated from use.counter.css.doc.css_page_orientation
   * Whether a document used the CSS property page-orientation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_page_orientation(1668);

  /**
   * generated from use.counter.css.doc.css_paint_order
   * Whether a document used the CSS property paint-order. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_paint_order(1669);

  /**
   * generated from use.counter.css.doc.css_perspective
   * Whether a document used the CSS property perspective. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_perspective(1670);

  /**
   * generated from use.counter.css.doc.css_perspective_origin
   * Whether a document used the CSS property perspective-origin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_perspective_origin(1671);

  /**
   * generated from use.counter.css.doc.css_place_content
   * Whether a document used the CSS property place-content. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_place_content(1672);

  /**
   * generated from use.counter.css.doc.css_place_items
   * Whether a document used the CSS property place-items. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_place_items(1673);

  /**
   * generated from use.counter.css.doc.css_place_self
   * Whether a document used the CSS property place-self. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_place_self(1674);

  /**
   * generated from use.counter.css.doc.css_pointer_events
   * Whether a document used the CSS property pointer-events. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_pointer_events(1675);

  /**
   * generated from use.counter.css.doc.css_position
   * Whether a document used the CSS property position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position(1676);

  /**
   * generated from use.counter.css.doc.css_position_anchor
   * Whether a document used the CSS property position-anchor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_anchor(1677);

  /**
   * generated from use.counter.css.doc.css_position_area
   * Whether a document used the CSS property position-area. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_area(1678);

  /**
   * generated from use.counter.css.doc.css_position_try
   * Whether a document used the CSS property position-try. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_try(1679);

  /**
   * generated from use.counter.css.doc.css_position_try_fallbacks
   * Whether a document used the CSS property position-try-fallbacks. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_try_fallbacks(1680);

  /**
   * generated from use.counter.css.doc.css_position_try_order
   * Whether a document used the CSS property position-try-order. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_try_order(1681);

  /**
   * generated from use.counter.css.doc.css_position_visibility
   * Whether a document used the CSS property position-visibility. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_visibility(1682);

  /**
   * generated from use.counter.css.doc.css_print_color_adjust
   * Whether a document used the CSS property print-color-adjust. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_print_color_adjust(1683);

  /**
   * generated from use.counter.css.doc.css_quotes
   * Whether a document used the CSS property quotes. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_quotes(1684);

  /**
   * generated from use.counter.css.doc.css_r
   * Whether a document used the CSS property r. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_r(1685);

  /**
   * generated from use.counter.css.doc.css_resize
   * Whether a document used the CSS property resize. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_resize(1686);

  /**
   * generated from use.counter.css.doc.css_right
   * Whether a document used the CSS property right. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_right(1687);

  /**
   * generated from use.counter.css.doc.css_rotate
   * Whether a document used the CSS property rotate. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_rotate(1688);

  /**
   * generated from use.counter.css.doc.css_row_gap
   * Whether a document used the CSS property row-gap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_row_gap(1689);

  /**
   * generated from use.counter.css.doc.css_ruby_align
   * Whether a document used the CSS property ruby-align. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_ruby_align(1690);

  /**
   * generated from use.counter.css.doc.css_ruby_position
   * Whether a document used the CSS property ruby-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_ruby_position(1691);

  /**
   * generated from use.counter.css.doc.css_rx
   * Whether a document used the CSS property rx. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_rx(1692);

  /**
   * generated from use.counter.css.doc.css_ry
   * Whether a document used the CSS property ry. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_ry(1693);

  /**
   * generated from use.counter.css.doc.css_scale
   * Whether a document used the CSS property scale. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scale(1694);

  /**
   * generated from use.counter.css.doc.css_scroll_behavior
   * Whether a document used the CSS property scroll-behavior. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_behavior(1695);

  /**
   * generated from use.counter.css.doc.css_scroll_margin
   * Whether a document used the CSS property scroll-margin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin(1696);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_block
   * Whether a document used the CSS property scroll-margin-block. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_block(1697);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_block_end
   * Whether a document used the CSS property scroll-margin-block-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_block_end(1698);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_block_start
   * Whether a document used the CSS property scroll-margin-block-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_block_start(1699);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_bottom
   * Whether a document used the CSS property scroll-margin-bottom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_bottom(1700);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_inline
   * Whether a document used the CSS property scroll-margin-inline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_inline(1701);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_inline_end
   * Whether a document used the CSS property scroll-margin-inline-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_inline_end(1702);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_inline_start
   * Whether a document used the CSS property scroll-margin-inline-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_inline_start(1703);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_left
   * Whether a document used the CSS property scroll-margin-left. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_left(1704);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_right
   * Whether a document used the CSS property scroll-margin-right. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_right(1705);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_top
   * Whether a document used the CSS property scroll-margin-top. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_top(1706);

  /**
   * generated from use.counter.css.doc.css_scroll_padding
   * Whether a document used the CSS property scroll-padding. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding(1707);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_block
   * Whether a document used the CSS property scroll-padding-block. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_block(1708);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_block_end
   * Whether a document used the CSS property scroll-padding-block-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_block_end(1709);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_block_start
   * Whether a document used the CSS property scroll-padding-block-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_block_start(1710);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_bottom
   * Whether a document used the CSS property scroll-padding-bottom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_bottom(1711);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_inline
   * Whether a document used the CSS property scroll-padding-inline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_inline(1712);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_inline_end
   * Whether a document used the CSS property scroll-padding-inline-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_inline_end(1713);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_inline_start
   * Whether a document used the CSS property scroll-padding-inline-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_inline_start(1714);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_left
   * Whether a document used the CSS property scroll-padding-left. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_left(1715);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_right
   * Whether a document used the CSS property scroll-padding-right. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_right(1716);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_top
   * Whether a document used the CSS property scroll-padding-top. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_top(1717);

  /**
   * generated from use.counter.css.doc.css_scroll_snap_align
   * Whether a document used the CSS property scroll-snap-align. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_snap_align(1718);

  /**
   * generated from use.counter.css.doc.css_scroll_snap_stop
   * Whether a document used the CSS property scroll-snap-stop. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_snap_stop(1719);

  /**
   * generated from use.counter.css.doc.css_scroll_snap_type
   * Whether a document used the CSS property scroll-snap-type. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_snap_type(1720);

  /**
   * generated from use.counter.css.doc.css_scroll_timeline
   * Whether a document used the CSS property scroll-timeline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_timeline(1721);

  /**
   * generated from use.counter.css.doc.css_scroll_timeline_axis
   * Whether a document used the CSS property scroll-timeline-axis. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_timeline_axis(1722);

  /**
   * generated from use.counter.css.doc.css_scroll_timeline_name
   * Whether a document used the CSS property scroll-timeline-name. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_timeline_name(1723);

  /**
   * generated from use.counter.css.doc.css_scrollbar_color
   * Whether a document used the CSS property scrollbar-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scrollbar_color(1724);

  /**
   * generated from use.counter.css.doc.css_scrollbar_gutter
   * Whether a document used the CSS property scrollbar-gutter. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scrollbar_gutter(1725);

  /**
   * generated from use.counter.css.doc.css_scrollbar_width
   * Whether a document used the CSS property scrollbar-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scrollbar_width(1726);

  /**
   * generated from use.counter.css.doc.css_shape_image_threshold
   * Whether a document used the CSS property shape-image-threshold. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_shape_image_threshold(1727);

  /**
   * generated from use.counter.css.doc.css_shape_margin
   * Whether a document used the CSS property shape-margin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_shape_margin(1728);

  /**
   * generated from use.counter.css.doc.css_shape_outside
   * Whether a document used the CSS property shape-outside. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_shape_outside(1729);

  /**
   * generated from use.counter.css.doc.css_shape_rendering
   * Whether a document used the CSS property shape-rendering. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_shape_rendering(1730);

  /**
   * generated from use.counter.css.doc.css_size
   * Whether a document used the CSS property size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_size(1731);

  /**
   * generated from use.counter.css.doc.css_stop_color
   * Whether a document used the CSS property stop-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stop_color(1732);

  /**
   * generated from use.counter.css.doc.css_stop_opacity
   * Whether a document used the CSS property stop-opacity. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stop_opacity(1733);

  /**
   * generated from use.counter.css.doc.css_stroke
   * Whether a document used the CSS property stroke. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke(1734);

  /**
   * generated from use.counter.css.doc.css_stroke_dasharray
   * Whether a document used the CSS property stroke-dasharray. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_dasharray(1735);

  /**
   * generated from use.counter.css.doc.css_stroke_dashoffset
   * Whether a document used the CSS property stroke-dashoffset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_dashoffset(1736);

  /**
   * generated from use.counter.css.doc.css_stroke_linecap
   * Whether a document used the CSS property stroke-linecap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_linecap(1737);

  /**
   * generated from use.counter.css.doc.css_stroke_linejoin
   * Whether a document used the CSS property stroke-linejoin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_linejoin(1738);

  /**
   * generated from use.counter.css.doc.css_stroke_miterlimit
   * Whether a document used the CSS property stroke-miterlimit. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_miterlimit(1739);

  /**
   * generated from use.counter.css.doc.css_stroke_opacity
   * Whether a document used the CSS property stroke-opacity. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_opacity(1740);

  /**
   * generated from use.counter.css.doc.css_stroke_width
   * Whether a document used the CSS property stroke-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_width(1741);

  /**
   * generated from use.counter.css.doc.css_tab_size
   * Whether a document used the CSS property tab-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_tab_size(1742);

  /**
   * generated from use.counter.css.doc.css_table_layout
   * Whether a document used the CSS property table-layout. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_table_layout(1743);

  /**
   * generated from use.counter.css.doc.css_text_align
   * Whether a document used the CSS property text-align. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_align(1744);

  /**
   * generated from use.counter.css.doc.css_text_align_last
   * Whether a document used the CSS property text-align-last. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_align_last(1745);

  /**
   * generated from use.counter.css.doc.css_text_anchor
   * Whether a document used the CSS property text-anchor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_anchor(1746);

  /**
   * generated from use.counter.css.doc.css_text_autospace
   * Whether a document used the CSS property text-autospace. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_autospace(1747);

  /**
   * generated from use.counter.css.doc.css_text_combine_upright
   * Whether a document used the CSS property text-combine-upright. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_combine_upright(1748);

  /**
   * generated from use.counter.css.doc.css_text_decoration
   * Whether a document used the CSS property text-decoration. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration(1749);

  /**
   * generated from use.counter.css.doc.css_text_decoration_color
   * Whether a document used the CSS property text-decoration-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_color(1750);

  /**
   * generated from use.counter.css.doc.css_text_decoration_inset
   * Whether a document used the CSS property text-decoration-inset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_inset(1751);

  /**
   * generated from use.counter.css.doc.css_text_decoration_line
   * Whether a document used the CSS property text-decoration-line. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_line(1752);

  /**
   * generated from use.counter.css.doc.css_text_decoration_skip_ink
   * Whether a document used the CSS property text-decoration-skip-ink. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_skip_ink(1753);

  /**
   * generated from use.counter.css.doc.css_text_decoration_style
   * Whether a document used the CSS property text-decoration-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_style(1754);

  /**
   * generated from use.counter.css.doc.css_text_decoration_thickness
   * Whether a document used the CSS property text-decoration-thickness. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_thickness(1755);

  /**
   * generated from use.counter.css.doc.css_text_emphasis
   * Whether a document used the CSS property text-emphasis. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_emphasis(1756);

  /**
   * generated from use.counter.css.doc.css_text_emphasis_color
   * Whether a document used the CSS property text-emphasis-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_emphasis_color(1757);

  /**
   * generated from use.counter.css.doc.css_text_emphasis_position
   * Whether a document used the CSS property text-emphasis-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_emphasis_position(1758);

  /**
   * generated from use.counter.css.doc.css_text_emphasis_style
   * Whether a document used the CSS property text-emphasis-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_emphasis_style(1759);

  /**
   * generated from use.counter.css.doc.css_text_indent
   * Whether a document used the CSS property text-indent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_indent(1760);

  /**
   * generated from use.counter.css.doc.css_text_justify
   * Whether a document used the CSS property text-justify. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_justify(1761);

  /**
   * generated from use.counter.css.doc.css_text_orientation
   * Whether a document used the CSS property text-orientation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_orientation(1762);

  /**
   * generated from use.counter.css.doc.css_text_overflow
   * Whether a document used the CSS property text-overflow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_overflow(1763);

  /**
   * generated from use.counter.css.doc.css_text_rendering
   * Whether a document used the CSS property text-rendering. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_rendering(1764);

  /**
   * generated from use.counter.css.doc.css_text_shadow
   * Whether a document used the CSS property text-shadow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_shadow(1765);

  /**
   * generated from use.counter.css.doc.css_text_transform
   * Whether a document used the CSS property text-transform. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_transform(1766);

  /**
   * generated from use.counter.css.doc.css_text_underline_offset
   * Whether a document used the CSS property text-underline-offset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_underline_offset(1767);

  /**
   * generated from use.counter.css.doc.css_text_underline_position
   * Whether a document used the CSS property text-underline-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_underline_position(1768);

  /**
   * generated from use.counter.css.doc.css_text_wrap
   * Whether a document used the CSS property text-wrap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_wrap(1769);

  /**
   * generated from use.counter.css.doc.css_text_wrap_mode
   * Whether a document used the CSS property text-wrap-mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_wrap_mode(1770);

  /**
   * generated from use.counter.css.doc.css_text_wrap_style
   * Whether a document used the CSS property text-wrap-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_wrap_style(1771);

  /**
   * generated from use.counter.css.doc.css_top
   * Whether a document used the CSS property top. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_top(1772);

  /**
   * generated from use.counter.css.doc.css_touch_action
   * Whether a document used the CSS property touch-action. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_touch_action(1773);

  /**
   * generated from use.counter.css.doc.css_transform
   * Whether a document used the CSS property transform. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transform(1774);

  /**
   * generated from use.counter.css.doc.css_transform_box
   * Whether a document used the CSS property transform-box. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transform_box(1775);

  /**
   * generated from use.counter.css.doc.css_transform_origin
   * Whether a document used the CSS property transform-origin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transform_origin(1776);

  /**
   * generated from use.counter.css.doc.css_transform_style
   * Whether a document used the CSS property transform-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transform_style(1777);

  /**
   * generated from use.counter.css.doc.css_transition
   * Whether a document used the CSS property transition. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition(1778);

  /**
   * generated from use.counter.css.doc.css_transition_behavior
   * Whether a document used the CSS property transition-behavior. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition_behavior(1779);

  /**
   * generated from use.counter.css.doc.css_transition_delay
   * Whether a document used the CSS property transition-delay. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition_delay(1780);

  /**
   * generated from use.counter.css.doc.css_transition_duration
   * Whether a document used the CSS property transition-duration. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition_duration(1781);

  /**
   * generated from use.counter.css.doc.css_transition_property
   * Whether a document used the CSS property transition-property. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition_property(1782);

  /**
   * generated from use.counter.css.doc.css_transition_timing_function
   * Whether a document used the CSS property transition-timing-function. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition_timing_function(1783);

  /**
   * generated from use.counter.css.doc.css_translate
   * Whether a document used the CSS property translate. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_translate(1784);

  /**
   * generated from use.counter.css.doc.css_unicode_bidi
   * Whether a document used the CSS property unicode-bidi. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_unicode_bidi(1785);

  /**
   * generated from use.counter.css.doc.css_user_select
   * Whether a document used the CSS property user-select. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_user_select(1786);

  /**
   * generated from use.counter.css.doc.css_vector_effect
   * Whether a document used the CSS property vector-effect. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_vector_effect(1787);

  /**
   * generated from use.counter.css.doc.css_vertical_align
   * Whether a document used the CSS property vertical-align. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_vertical_align(1788);

  /**
   * generated from use.counter.css.doc.css_view_timeline
   * Whether a document used the CSS property view-timeline. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_timeline(1789);

  /**
   * generated from use.counter.css.doc.css_view_timeline_axis
   * Whether a document used the CSS property view-timeline-axis. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_timeline_axis(1790);

  /**
   * generated from use.counter.css.doc.css_view_timeline_inset
   * Whether a document used the CSS property view-timeline-inset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_timeline_inset(1791);

  /**
   * generated from use.counter.css.doc.css_view_timeline_name
   * Whether a document used the CSS property view-timeline-name. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_timeline_name(1792);

  /**
   * generated from use.counter.css.doc.css_view_transition_class
   * Whether a document used the CSS property view-transition-class. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_transition_class(1793);

  /**
   * generated from use.counter.css.doc.css_view_transition_name
   * Whether a document used the CSS property view-transition-name. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_transition_name(1794);

  /**
   * generated from use.counter.css.doc.css_visibility
   * Whether a document used the CSS property visibility. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_visibility(1795);

  /**
   * generated from use.counter.css.doc.css_webkit_align_content
   * Whether a document used the CSS property -webkit-align-content. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_align_content(1796);

  /**
   * generated from use.counter.css.doc.css_webkit_align_items
   * Whether a document used the CSS property -webkit-align-items. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_align_items(1797);

  /**
   * generated from use.counter.css.doc.css_webkit_align_self
   * Whether a document used the CSS property -webkit-align-self. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_align_self(1798);

  /**
   * generated from use.counter.css.doc.css_webkit_animation
   * Whether a document used the CSS property -webkit-animation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation(1799);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_delay
   * Whether a document used the CSS property -webkit-animation-delay. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_delay(1800);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_direction
   * Whether a document used the CSS property -webkit-animation-direction. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_direction(1801);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_duration
   * Whether a document used the CSS property -webkit-animation-duration. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_duration(1802);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_fill_mode
   * Whether a document used the CSS property -webkit-animation-fill-mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_fill_mode(1803);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_iteration_count
   * Whether a document used the CSS property -webkit-animation-iteration-count. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_iteration_count(1804);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_name
   * Whether a document used the CSS property -webkit-animation-name. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_name(1805);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_play_state
   * Whether a document used the CSS property -webkit-animation-play-state. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_play_state(1806);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_timing_function
   * Whether a document used the CSS property -webkit-animation-timing-function. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_timing_function(1807);

  /**
   * generated from use.counter.css.doc.css_webkit_appearance
   * Whether a document used the CSS property -webkit-appearance. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_appearance(1808);

  /**
   * generated from use.counter.css.doc.css_webkit_backface_visibility
   * Whether a document used the CSS property -webkit-backface-visibility. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_backface_visibility(1809);

  /**
   * generated from use.counter.css.doc.css_webkit_background_clip
   * Whether a document used the CSS property -webkit-background-clip. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_background_clip(1810);

  /**
   * generated from use.counter.css.doc.css_webkit_background_origin
   * Whether a document used the CSS property -webkit-background-origin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_background_origin(1811);

  /**
   * generated from use.counter.css.doc.css_webkit_background_size
   * Whether a document used the CSS property -webkit-background-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_background_size(1812);

  /**
   * generated from use.counter.css.doc.css_webkit_border_bottom_left_radius
   * Whether a document used the CSS property -webkit-border-bottom-left-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_bottom_left_radius(1813);

  /**
   * generated from use.counter.css.doc.css_webkit_border_bottom_right_radius
   * Whether a document used the CSS property -webkit-border-bottom-right-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_bottom_right_radius(1814);

  /**
   * generated from use.counter.css.doc.css_webkit_border_image
   * Whether a document used the CSS property -webkit-border-image. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_image(1815);

  /**
   * generated from use.counter.css.doc.css_webkit_border_radius
   * Whether a document used the CSS property -webkit-border-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_radius(1816);

  /**
   * generated from use.counter.css.doc.css_webkit_border_top_left_radius
   * Whether a document used the CSS property -webkit-border-top-left-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_top_left_radius(1817);

  /**
   * generated from use.counter.css.doc.css_webkit_border_top_right_radius
   * Whether a document used the CSS property -webkit-border-top-right-radius. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_top_right_radius(1818);

  /**
   * generated from use.counter.css.doc.css_webkit_box_align
   * Whether a document used the CSS property -webkit-box-align. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_align(1819);

  /**
   * generated from use.counter.css.doc.css_webkit_box_direction
   * Whether a document used the CSS property -webkit-box-direction. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_direction(1820);

  /**
   * generated from use.counter.css.doc.css_webkit_box_flex
   * Whether a document used the CSS property -webkit-box-flex. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_flex(1821);

  /**
   * generated from use.counter.css.doc.css_webkit_box_ordinal_group
   * Whether a document used the CSS property -webkit-box-ordinal-group. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_ordinal_group(1822);

  /**
   * generated from use.counter.css.doc.css_webkit_box_orient
   * Whether a document used the CSS property -webkit-box-orient. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_orient(1823);

  /**
   * generated from use.counter.css.doc.css_webkit_box_pack
   * Whether a document used the CSS property -webkit-box-pack. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_pack(1824);

  /**
   * generated from use.counter.css.doc.css_webkit_box_shadow
   * Whether a document used the CSS property -webkit-box-shadow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_shadow(1825);

  /**
   * generated from use.counter.css.doc.css_webkit_box_sizing
   * Whether a document used the CSS property -webkit-box-sizing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_sizing(1826);

  /**
   * generated from use.counter.css.doc.css_webkit_clip_path
   * Whether a document used the CSS property -webkit-clip-path. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_clip_path(1827);

  /**
   * generated from use.counter.css.doc.css_webkit_filter
   * Whether a document used the CSS property -webkit-filter. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_filter(1828);

  /**
   * generated from use.counter.css.doc.css_webkit_flex
   * Whether a document used the CSS property -webkit-flex. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex(1829);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_basis
   * Whether a document used the CSS property -webkit-flex-basis. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_basis(1830);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_direction
   * Whether a document used the CSS property -webkit-flex-direction. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_direction(1831);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_flow
   * Whether a document used the CSS property -webkit-flex-flow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_flow(1832);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_grow
   * Whether a document used the CSS property -webkit-flex-grow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_grow(1833);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_shrink
   * Whether a document used the CSS property -webkit-flex-shrink. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_shrink(1834);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_wrap
   * Whether a document used the CSS property -webkit-flex-wrap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_wrap(1835);

  /**
   * generated from use.counter.css.doc.css_webkit_font_feature_settings
   * Whether a document used the CSS property -webkit-font-feature-settings. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_font_feature_settings(1836);

  /**
   * generated from use.counter.css.doc.css_webkit_font_smoothing
   * Whether a document used the CSS property -webkit-font-smoothing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_font_smoothing(1837);

  /**
   * generated from use.counter.css.doc.css_webkit_justify_content
   * Whether a document used the CSS property -webkit-justify-content. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_justify_content(1838);

  /**
   * generated from use.counter.css.doc.css_webkit_line_clamp
   * Whether a document used the CSS property -webkit-line-clamp. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_line_clamp(1839);

  /**
   * generated from use.counter.css.doc.css_webkit_mask
   * Whether a document used the CSS property -webkit-mask. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask(1840);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_clip
   * Whether a document used the CSS property -webkit-mask-clip. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_clip(1841);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_composite
   * Whether a document used the CSS property -webkit-mask-composite. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_composite(1842);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_image
   * Whether a document used the CSS property -webkit-mask-image. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_image(1843);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_origin
   * Whether a document used the CSS property -webkit-mask-origin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_origin(1844);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_position
   * Whether a document used the CSS property -webkit-mask-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_position(1845);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_position_x
   * Whether a document used the CSS property -webkit-mask-position-x. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_position_x(1846);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_position_y
   * Whether a document used the CSS property -webkit-mask-position-y. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_position_y(1847);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_repeat
   * Whether a document used the CSS property -webkit-mask-repeat. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_repeat(1848);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_size
   * Whether a document used the CSS property -webkit-mask-size. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_size(1849);

  /**
   * generated from use.counter.css.doc.css_webkit_order
   * Whether a document used the CSS property -webkit-order. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_order(1850);

  /**
   * generated from use.counter.css.doc.css_webkit_perspective
   * Whether a document used the CSS property -webkit-perspective. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_perspective(1851);

  /**
   * generated from use.counter.css.doc.css_webkit_perspective_origin
   * Whether a document used the CSS property -webkit-perspective-origin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_perspective_origin(1852);

  /**
   * generated from use.counter.css.doc.css_webkit_text_fill_color
   * Whether a document used the CSS property -webkit-text-fill-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_fill_color(1853);

  /**
   * generated from use.counter.css.doc.css_webkit_text_security
   * Whether a document used the CSS property -webkit-text-security. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_security(1854);

  /**
   * generated from use.counter.css.doc.css_webkit_text_size_adjust
   * Whether a document used the CSS property -webkit-text-size-adjust. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_size_adjust(1855);

  /**
   * generated from use.counter.css.doc.css_webkit_text_stroke
   * Whether a document used the CSS property -webkit-text-stroke. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_stroke(1856);

  /**
   * generated from use.counter.css.doc.css_webkit_text_stroke_color
   * Whether a document used the CSS property -webkit-text-stroke-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_stroke_color(1857);

  /**
   * generated from use.counter.css.doc.css_webkit_text_stroke_width
   * Whether a document used the CSS property -webkit-text-stroke-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_stroke_width(1858);

  /**
   * generated from use.counter.css.doc.css_webkit_transform
   * Whether a document used the CSS property -webkit-transform. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transform(1859);

  /**
   * generated from use.counter.css.doc.css_webkit_transform_origin
   * Whether a document used the CSS property -webkit-transform-origin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transform_origin(1860);

  /**
   * generated from use.counter.css.doc.css_webkit_transform_style
   * Whether a document used the CSS property -webkit-transform-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transform_style(1861);

  /**
   * generated from use.counter.css.doc.css_webkit_transition
   * Whether a document used the CSS property -webkit-transition. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transition(1862);

  /**
   * generated from use.counter.css.doc.css_webkit_transition_delay
   * Whether a document used the CSS property -webkit-transition-delay. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transition_delay(1863);

  /**
   * generated from use.counter.css.doc.css_webkit_transition_duration
   * Whether a document used the CSS property -webkit-transition-duration. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transition_duration(1864);

  /**
   * generated from use.counter.css.doc.css_webkit_transition_property
   * Whether a document used the CSS property -webkit-transition-property. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transition_property(1865);

  /**
   * generated from use.counter.css.doc.css_webkit_transition_timing_function
   * Whether a document used the CSS property -webkit-transition-timing-function. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transition_timing_function(1866);

  /**
   * generated from use.counter.css.doc.css_webkit_user_select
   * Whether a document used the CSS property -webkit-user-select. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_user_select(1867);

  /**
   * generated from use.counter.css.doc.css_white_space
   * Whether a document used the CSS property white-space. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_white_space(1868);

  /**
   * generated from use.counter.css.doc.css_white_space_collapse
   * Whether a document used the CSS property white-space-collapse. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_white_space_collapse(1869);

  /**
   * generated from use.counter.css.doc.css_width
   * Whether a document used the CSS property width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_width(1870);

  /**
   * generated from use.counter.css.doc.css_will_change
   * Whether a document used the CSS property will-change. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_will_change(1871);

  /**
   * generated from use.counter.css.doc.css_word_break
   * Whether a document used the CSS property word-break. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_word_break(1872);

  /**
   * generated from use.counter.css.doc.css_word_spacing
   * Whether a document used the CSS property word-spacing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_word_spacing(1873);

  /**
   * generated from use.counter.css.doc.css_word_wrap
   * Whether a document used the CSS property word-wrap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_word_wrap(1874);

  /**
   * generated from use.counter.css.doc.css_writing_mode
   * Whether a document used the CSS property writing-mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_writing_mode(1875);

  /**
   * generated from use.counter.css.doc.css_x
   * Whether a document used the CSS property x. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_x(1876);

  /**
   * generated from use.counter.css.doc.css_x_lang
   * Whether a document used the CSS property -x-lang. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_x_lang(1877);

  /**
   * generated from use.counter.css.doc.css_x_span
   * Whether a document used the CSS property -x-span. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_x_span(1878);

  /**
   * generated from use.counter.css.doc.css_x_text_scale
   * Whether a document used the CSS property -x-text-scale. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_x_text_scale(1879);

  /**
   * generated from use.counter.css.doc.css_y
   * Whether a document used the CSS property y. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_y(1880);

  /**
   * generated from use.counter.css.doc.css_z_index
   * Whether a document used the CSS property z-index. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_z_index(1881);

  /**
   * generated from use.counter.css.doc.css_zoom
   * Whether a document used the CSS property zoom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_zoom(1882);

  /**
   * generated from use.counter.css.doc.max_zoom
   * Whether a document used the (unknown, counted) CSS property max-zoom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> max_zoom(1883);

  /**
   * generated from use.counter.css.doc.min_zoom
   * Whether a document used the (unknown, counted) CSS property min-zoom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> min_zoom(1884);

  /**
   * generated from use.counter.css.doc.orientation
   * Whether a document used the (unknown, counted) CSS property orientation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> orientation(1885);

  /**
   * generated from use.counter.css.doc.orphans
   * Whether a document used the (unknown, counted) CSS property orphans. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> orphans(1886);

  /**
   * generated from use.counter.css.doc.speak
   * Whether a document used the (unknown, counted) CSS property speak. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> speak(1887);

  /**
   * generated from use.counter.css.doc.text_size_adjust
   * Whether a document used the (unknown, counted) CSS property text-size-adjust. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> text_size_adjust(1888);

  /**
   * generated from use.counter.css.doc.user_zoom
   * Whether a document used the (unknown, counted) CSS property user-zoom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> user_zoom(1889);

  /**
   * generated from use.counter.css.doc.webkit_app_region
   * Whether a document used the (unknown, counted) CSS property -webkit-app-region. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_app_region(1890);

  /**
   * generated from use.counter.css.doc.webkit_border_after
   * Whether a document used the (unknown, counted) CSS property -webkit-border-after. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_after(1891);

  /**
   * generated from use.counter.css.doc.webkit_border_after_color
   * Whether a document used the (unknown, counted) CSS property -webkit-border-after-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_after_color(1892);

  /**
   * generated from use.counter.css.doc.webkit_border_after_style
   * Whether a document used the (unknown, counted) CSS property -webkit-border-after-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_after_style(1893);

  /**
   * generated from use.counter.css.doc.webkit_border_after_width
   * Whether a document used the (unknown, counted) CSS property -webkit-border-after-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_after_width(1894);

  /**
   * generated from use.counter.css.doc.webkit_border_before
   * Whether a document used the (unknown, counted) CSS property -webkit-border-before. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_before(1895);

  /**
   * generated from use.counter.css.doc.webkit_border_before_color
   * Whether a document used the (unknown, counted) CSS property -webkit-border-before-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_before_color(1896);

  /**
   * generated from use.counter.css.doc.webkit_border_before_style
   * Whether a document used the (unknown, counted) CSS property -webkit-border-before-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_before_style(1897);

  /**
   * generated from use.counter.css.doc.webkit_border_before_width
   * Whether a document used the (unknown, counted) CSS property -webkit-border-before-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_before_width(1898);

  /**
   * generated from use.counter.css.doc.webkit_border_end
   * Whether a document used the (unknown, counted) CSS property -webkit-border-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_end(1899);

  /**
   * generated from use.counter.css.doc.webkit_border_end_color
   * Whether a document used the (unknown, counted) CSS property -webkit-border-end-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_end_color(1900);

  /**
   * generated from use.counter.css.doc.webkit_border_end_style
   * Whether a document used the (unknown, counted) CSS property -webkit-border-end-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_end_style(1901);

  /**
   * generated from use.counter.css.doc.webkit_border_end_width
   * Whether a document used the (unknown, counted) CSS property -webkit-border-end-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_end_width(1902);

  /**
   * generated from use.counter.css.doc.webkit_border_horizontal_spacing
   * Whether a document used the (unknown, counted) CSS property -webkit-border-horizontal-spacing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_horizontal_spacing(1903);

  /**
   * generated from use.counter.css.doc.webkit_border_start
   * Whether a document used the (unknown, counted) CSS property -webkit-border-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_start(1904);

  /**
   * generated from use.counter.css.doc.webkit_border_start_color
   * Whether a document used the (unknown, counted) CSS property -webkit-border-start-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_start_color(1905);

  /**
   * generated from use.counter.css.doc.webkit_border_start_style
   * Whether a document used the (unknown, counted) CSS property -webkit-border-start-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_start_style(1906);

  /**
   * generated from use.counter.css.doc.webkit_border_start_width
   * Whether a document used the (unknown, counted) CSS property -webkit-border-start-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_start_width(1907);

  /**
   * generated from use.counter.css.doc.webkit_border_vertical_spacing
   * Whether a document used the (unknown, counted) CSS property -webkit-border-vertical-spacing. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_vertical_spacing(1908);

  /**
   * generated from use.counter.css.doc.webkit_box_decoration_break
   * Whether a document used the (unknown, counted) CSS property -webkit-box-decoration-break. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_box_decoration_break(1909);

  /**
   * generated from use.counter.css.doc.webkit_box_reflect
   * Whether a document used the (unknown, counted) CSS property -webkit-box-reflect. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_box_reflect(1910);

  /**
   * generated from use.counter.css.doc.webkit_column_break_after
   * Whether a document used the (unknown, counted) CSS property -webkit-column-break-after. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_break_after(1911);

  /**
   * generated from use.counter.css.doc.webkit_column_break_before
   * Whether a document used the (unknown, counted) CSS property -webkit-column-break-before. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_break_before(1912);

  /**
   * generated from use.counter.css.doc.webkit_column_break_inside
   * Whether a document used the (unknown, counted) CSS property -webkit-column-break-inside. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_break_inside(1913);

  /**
   * generated from use.counter.css.doc.webkit_column_count
   * Whether a document used the (unknown, counted) CSS property -webkit-column-count. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_count(1914);

  /**
   * generated from use.counter.css.doc.webkit_column_gap
   * Whether a document used the (unknown, counted) CSS property -webkit-column-gap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_gap(1915);

  /**
   * generated from use.counter.css.doc.webkit_column_rule
   * Whether a document used the (unknown, counted) CSS property -webkit-column-rule. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_rule(1916);

  /**
   * generated from use.counter.css.doc.webkit_column_rule_color
   * Whether a document used the (unknown, counted) CSS property -webkit-column-rule-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_rule_color(1917);

  /**
   * generated from use.counter.css.doc.webkit_column_rule_style
   * Whether a document used the (unknown, counted) CSS property -webkit-column-rule-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_rule_style(1918);

  /**
   * generated from use.counter.css.doc.webkit_column_rule_width
   * Whether a document used the (unknown, counted) CSS property -webkit-column-rule-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_rule_width(1919);

  /**
   * generated from use.counter.css.doc.webkit_column_span
   * Whether a document used the (unknown, counted) CSS property -webkit-column-span. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_span(1920);

  /**
   * generated from use.counter.css.doc.webkit_column_width
   * Whether a document used the (unknown, counted) CSS property -webkit-column-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_width(1921);

  /**
   * generated from use.counter.css.doc.webkit_columns
   * Whether a document used the (unknown, counted) CSS property -webkit-columns. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_columns(1922);

  /**
   * generated from use.counter.css.doc.webkit_font_size_delta
   * Whether a document used the (unknown, counted) CSS property -webkit-font-size-delta. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_font_size_delta(1923);

  /**
   * generated from use.counter.css.doc.webkit_highlight
   * Whether a document used the (unknown, counted) CSS property -webkit-highlight. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_highlight(1924);

  /**
   * generated from use.counter.css.doc.webkit_hyphenate_character
   * Whether a document used the (unknown, counted) CSS property -webkit-hyphenate-character. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_hyphenate_character(1925);

  /**
   * generated from use.counter.css.doc.webkit_line_break
   * Whether a document used the (unknown, counted) CSS property -webkit-line-break. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_line_break(1926);

  /**
   * generated from use.counter.css.doc.webkit_locale
   * Whether a document used the (unknown, counted) CSS property -webkit-locale. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_locale(1927);

  /**
   * generated from use.counter.css.doc.webkit_logical_height
   * Whether a document used the (unknown, counted) CSS property -webkit-logical-height. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_logical_height(1928);

  /**
   * generated from use.counter.css.doc.webkit_logical_width
   * Whether a document used the (unknown, counted) CSS property -webkit-logical-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_logical_width(1929);

  /**
   * generated from use.counter.css.doc.webkit_margin_after
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-after. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_after(1930);

  /**
   * generated from use.counter.css.doc.webkit_margin_after_collapse
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-after-collapse. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_after_collapse(1931);

  /**
   * generated from use.counter.css.doc.webkit_margin_before
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-before. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_before(1932);

  /**
   * generated from use.counter.css.doc.webkit_margin_before_collapse
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-before-collapse. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_before_collapse(1933);

  /**
   * generated from use.counter.css.doc.webkit_margin_bottom_collapse
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-bottom-collapse. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_bottom_collapse(1934);

  /**
   * generated from use.counter.css.doc.webkit_margin_collapse
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-collapse. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_collapse(1935);

  /**
   * generated from use.counter.css.doc.webkit_margin_end
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_end(1936);

  /**
   * generated from use.counter.css.doc.webkit_margin_start
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_start(1937);

  /**
   * generated from use.counter.css.doc.webkit_margin_top_collapse
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-top-collapse. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_top_collapse(1938);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-image. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image(1939);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image_outset
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-image-outset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image_outset(1940);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image_repeat
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-image-repeat. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image_repeat(1941);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image_slice
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-image-slice. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image_slice(1942);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image_source
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-image-source. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image_source(1943);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image_width
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-image-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image_width(1944);

  /**
   * generated from use.counter.css.doc.webkit_mask_repeat_x
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-repeat-x. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_repeat_x(1945);

  /**
   * generated from use.counter.css.doc.webkit_mask_repeat_y
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-repeat-y. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_repeat_y(1946);

  /**
   * generated from use.counter.css.doc.webkit_max_logical_height
   * Whether a document used the (unknown, counted) CSS property -webkit-max-logical-height. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_max_logical_height(1947);

  /**
   * generated from use.counter.css.doc.webkit_max_logical_width
   * Whether a document used the (unknown, counted) CSS property -webkit-max-logical-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_max_logical_width(1948);

  /**
   * generated from use.counter.css.doc.webkit_min_logical_height
   * Whether a document used the (unknown, counted) CSS property -webkit-min-logical-height. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_min_logical_height(1949);

  /**
   * generated from use.counter.css.doc.webkit_min_logical_width
   * Whether a document used the (unknown, counted) CSS property -webkit-min-logical-width. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_min_logical_width(1950);

  /**
   * generated from use.counter.css.doc.webkit_opacity
   * Whether a document used the (unknown, counted) CSS property -webkit-opacity. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_opacity(1951);

  /**
   * generated from use.counter.css.doc.webkit_padding_after
   * Whether a document used the (unknown, counted) CSS property -webkit-padding-after. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_padding_after(1952);

  /**
   * generated from use.counter.css.doc.webkit_padding_before
   * Whether a document used the (unknown, counted) CSS property -webkit-padding-before. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_padding_before(1953);

  /**
   * generated from use.counter.css.doc.webkit_padding_end
   * Whether a document used the (unknown, counted) CSS property -webkit-padding-end. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_padding_end(1954);

  /**
   * generated from use.counter.css.doc.webkit_padding_start
   * Whether a document used the (unknown, counted) CSS property -webkit-padding-start. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_padding_start(1955);

  /**
   * generated from use.counter.css.doc.webkit_perspective_origin_x
   * Whether a document used the (unknown, counted) CSS property -webkit-perspective-origin-x. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_perspective_origin_x(1956);

  /**
   * generated from use.counter.css.doc.webkit_perspective_origin_y
   * Whether a document used the (unknown, counted) CSS property -webkit-perspective-origin-y. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_perspective_origin_y(1957);

  /**
   * generated from use.counter.css.doc.webkit_print_color_adjust
   * Whether a document used the (unknown, counted) CSS property -webkit-print-color-adjust. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_print_color_adjust(1958);

  /**
   * generated from use.counter.css.doc.webkit_rtl_ordering
   * Whether a document used the (unknown, counted) CSS property -webkit-rtl-ordering. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_rtl_ordering(1959);

  /**
   * generated from use.counter.css.doc.webkit_ruby_position
   * Whether a document used the (unknown, counted) CSS property -webkit-ruby-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_ruby_position(1960);

  /**
   * generated from use.counter.css.doc.webkit_shape_image_threshold
   * Whether a document used the (unknown, counted) CSS property -webkit-shape-image-threshold. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_shape_image_threshold(1961);

  /**
   * generated from use.counter.css.doc.webkit_shape_margin
   * Whether a document used the (unknown, counted) CSS property -webkit-shape-margin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_shape_margin(1962);

  /**
   * generated from use.counter.css.doc.webkit_shape_outside
   * Whether a document used the (unknown, counted) CSS property -webkit-shape-outside. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_shape_outside(1963);

  /**
   * generated from use.counter.css.doc.webkit_tap_highlight_color
   * Whether a document used the (unknown, counted) CSS property -webkit-tap-highlight-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_tap_highlight_color(1964);

  /**
   * generated from use.counter.css.doc.webkit_text_combine
   * Whether a document used the (unknown, counted) CSS property -webkit-text-combine. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_combine(1965);

  /**
   * generated from use.counter.css.doc.webkit_text_decorations_in_effect
   * Whether a document used the (unknown, counted) CSS property -webkit-text-decorations-in-effect. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_decorations_in_effect(1966);

  /**
   * generated from use.counter.css.doc.webkit_text_emphasis
   * Whether a document used the (unknown, counted) CSS property -webkit-text-emphasis. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_emphasis(1967);

  /**
   * generated from use.counter.css.doc.webkit_text_emphasis_color
   * Whether a document used the (unknown, counted) CSS property -webkit-text-emphasis-color. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_emphasis_color(1968);

  /**
   * generated from use.counter.css.doc.webkit_text_emphasis_position
   * Whether a document used the (unknown, counted) CSS property -webkit-text-emphasis-position. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_emphasis_position(1969);

  /**
   * generated from use.counter.css.doc.webkit_text_emphasis_style
   * Whether a document used the (unknown, counted) CSS property -webkit-text-emphasis-style. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_emphasis_style(1970);

  /**
   * generated from use.counter.css.doc.webkit_text_orientation
   * Whether a document used the (unknown, counted) CSS property -webkit-text-orientation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_orientation(1971);

  /**
   * generated from use.counter.css.doc.webkit_transform_origin_x
   * Whether a document used the (unknown, counted) CSS property -webkit-transform-origin-x. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_transform_origin_x(1972);

  /**
   * generated from use.counter.css.doc.webkit_transform_origin_y
   * Whether a document used the (unknown, counted) CSS property -webkit-transform-origin-y. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_transform_origin_y(1973);

  /**
   * generated from use.counter.css.doc.webkit_transform_origin_z
   * Whether a document used the (unknown, counted) CSS property -webkit-transform-origin-z. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_transform_origin_z(1974);

  /**
   * generated from use.counter.css.doc.webkit_user_drag
   * Whether a document used the (unknown, counted) CSS property -webkit-user-drag. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_user_drag(1975);

  /**
   * generated from use.counter.css.doc.webkit_user_modify
   * Whether a document used the (unknown, counted) CSS property -webkit-user-modify. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_user_modify(1976);

  /**
   * generated from use.counter.css.doc.webkit_writing_mode
   * Whether a document used the (unknown, counted) CSS property -webkit-writing-mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_writing_mode(1977);

  /**
   * generated from use.counter.css.doc.widows
   * Whether a document used the (unknown, counted) CSS property widows. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> widows(1978);
}

namespace use_counter_css_page {
  /**
   * generated from use.counter.css.page.alignment_baseline
   * Whether a page used the (unknown, counted) CSS property alignment-baseline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> alignment_baseline(1979);

  /**
   * generated from use.counter.css.page.background_repeat_x
   * Whether a page used the (unknown, counted) CSS property background-repeat-x. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> background_repeat_x(1980);

  /**
   * generated from use.counter.css.page.background_repeat_y
   * Whether a page used the (unknown, counted) CSS property background-repeat-y. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> background_repeat_y(1981);

  /**
   * generated from use.counter.css.page.baseline_shift
   * Whether a page used the (unknown, counted) CSS property baseline-shift. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> baseline_shift(1982);

  /**
   * generated from use.counter.css.page.buffered_rendering
   * Whether a page used the (unknown, counted) CSS property buffered-rendering. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> buffered_rendering(1983);

  /**
   * generated from use.counter.css.page.color_rendering
   * Whether a page used the (unknown, counted) CSS property color-rendering. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> color_rendering(1984);

  /**
   * generated from use.counter.css.page.css_accent_color
   * Whether a page used the CSS property accent-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_accent_color(1985);

  /**
   * generated from use.counter.css.page.css_align_content
   * Whether a page used the CSS property align-content. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_align_content(1986);

  /**
   * generated from use.counter.css.page.css_align_items
   * Whether a page used the CSS property align-items. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_align_items(1987);

  /**
   * generated from use.counter.css.page.css_align_self
   * Whether a page used the CSS property align-self. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_align_self(1988);

  /**
   * generated from use.counter.css.page.css_all
   * Whether a page used the CSS property all. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_all(1989);

  /**
   * generated from use.counter.css.page.css_anchor_name
   * Whether a page used the CSS property anchor-name. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_anchor_name(1990);

  /**
   * generated from use.counter.css.page.css_anchor_scope
   * Whether a page used the CSS property anchor-scope. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_anchor_scope(1991);

  /**
   * generated from use.counter.css.page.css_animation
   * Whether a page used the CSS property animation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation(1992);

  /**
   * generated from use.counter.css.page.css_animation_composition
   * Whether a page used the CSS property animation-composition. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_composition(1993);

  /**
   * generated from use.counter.css.page.css_animation_delay
   * Whether a page used the CSS property animation-delay. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_delay(1994);

  /**
   * generated from use.counter.css.page.css_animation_direction
   * Whether a page used the CSS property animation-direction. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_direction(1995);

  /**
   * generated from use.counter.css.page.css_animation_duration
   * Whether a page used the CSS property animation-duration. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_duration(1996);

  /**
   * generated from use.counter.css.page.css_animation_fill_mode
   * Whether a page used the CSS property animation-fill-mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_fill_mode(1997);

  /**
   * generated from use.counter.css.page.css_animation_iteration_count
   * Whether a page used the CSS property animation-iteration-count. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_iteration_count(1998);

  /**
   * generated from use.counter.css.page.css_animation_name
   * Whether a page used the CSS property animation-name. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_name(1999);

  /**
   * generated from use.counter.css.page.css_animation_play_state
   * Whether a page used the CSS property animation-play-state. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_play_state(2000);

  /**
   * generated from use.counter.css.page.css_animation_timeline
   * Whether a page used the CSS property animation-timeline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_timeline(2001);

  /**
   * generated from use.counter.css.page.css_animation_timing_function
   * Whether a page used the CSS property animation-timing-function. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_animation_timing_function(2002);

  /**
   * generated from use.counter.css.page.css_appearance
   * Whether a page used the CSS property appearance. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_appearance(2003);

  /**
   * generated from use.counter.css.page.css_aspect_ratio
   * Whether a page used the CSS property aspect-ratio. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_aspect_ratio(2004);

  /**
   * generated from use.counter.css.page.css_backdrop_filter
   * Whether a page used the CSS property backdrop-filter. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_backdrop_filter(2005);

  /**
   * generated from use.counter.css.page.css_backface_visibility
   * Whether a page used the CSS property backface-visibility. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_backface_visibility(2006);

  /**
   * generated from use.counter.css.page.css_background
   * Whether a page used the CSS property background. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background(2007);

  /**
   * generated from use.counter.css.page.css_background_attachment
   * Whether a page used the CSS property background-attachment. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_attachment(2008);

  /**
   * generated from use.counter.css.page.css_background_blend_mode
   * Whether a page used the CSS property background-blend-mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_blend_mode(2009);

  /**
   * generated from use.counter.css.page.css_background_clip
   * Whether a page used the CSS property background-clip. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_clip(2010);

  /**
   * generated from use.counter.css.page.css_background_color
   * Whether a page used the CSS property background-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_color(2011);

  /**
   * generated from use.counter.css.page.css_background_image
   * Whether a page used the CSS property background-image. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_image(2012);

  /**
   * generated from use.counter.css.page.css_background_origin
   * Whether a page used the CSS property background-origin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_origin(2013);

  /**
   * generated from use.counter.css.page.css_background_position
   * Whether a page used the CSS property background-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_position(2014);

  /**
   * generated from use.counter.css.page.css_background_position_x
   * Whether a page used the CSS property background-position-x. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_position_x(2015);

  /**
   * generated from use.counter.css.page.css_background_position_y
   * Whether a page used the CSS property background-position-y. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_position_y(2016);

  /**
   * generated from use.counter.css.page.css_background_repeat
   * Whether a page used the CSS property background-repeat. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_repeat(2017);

  /**
   * generated from use.counter.css.page.css_background_size
   * Whether a page used the CSS property background-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_background_size(2018);

  /**
   * generated from use.counter.css.page.css_baseline_source
   * Whether a page used the CSS property baseline-source. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_baseline_source(2019);

  /**
   * generated from use.counter.css.page.css_block_size
   * Whether a page used the CSS property block-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_block_size(2020);

  /**
   * generated from use.counter.css.page.css_border
   * Whether a page used the CSS property border. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border(2021);

  /**
   * generated from use.counter.css.page.css_border_block
   * Whether a page used the CSS property border-block. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block(2022);

  /**
   * generated from use.counter.css.page.css_border_block_color
   * Whether a page used the CSS property border-block-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_color(2023);

  /**
   * generated from use.counter.css.page.css_border_block_end
   * Whether a page used the CSS property border-block-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_end(2024);

  /**
   * generated from use.counter.css.page.css_border_block_end_color
   * Whether a page used the CSS property border-block-end-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_end_color(2025);

  /**
   * generated from use.counter.css.page.css_border_block_end_style
   * Whether a page used the CSS property border-block-end-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_end_style(2026);

  /**
   * generated from use.counter.css.page.css_border_block_end_width
   * Whether a page used the CSS property border-block-end-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_end_width(2027);

  /**
   * generated from use.counter.css.page.css_border_block_start
   * Whether a page used the CSS property border-block-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_start(2028);

  /**
   * generated from use.counter.css.page.css_border_block_start_color
   * Whether a page used the CSS property border-block-start-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_start_color(2029);

  /**
   * generated from use.counter.css.page.css_border_block_start_style
   * Whether a page used the CSS property border-block-start-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_start_style(2030);

  /**
   * generated from use.counter.css.page.css_border_block_start_width
   * Whether a page used the CSS property border-block-start-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_start_width(2031);

  /**
   * generated from use.counter.css.page.css_border_block_style
   * Whether a page used the CSS property border-block-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_style(2032);

  /**
   * generated from use.counter.css.page.css_border_block_width
   * Whether a page used the CSS property border-block-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_block_width(2033);

  /**
   * generated from use.counter.css.page.css_border_bottom
   * Whether a page used the CSS property border-bottom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom(2034);

  /**
   * generated from use.counter.css.page.css_border_bottom_color
   * Whether a page used the CSS property border-bottom-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom_color(2035);

  /**
   * generated from use.counter.css.page.css_border_bottom_left_radius
   * Whether a page used the CSS property border-bottom-left-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom_left_radius(2036);

  /**
   * generated from use.counter.css.page.css_border_bottom_right_radius
   * Whether a page used the CSS property border-bottom-right-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom_right_radius(2037);

  /**
   * generated from use.counter.css.page.css_border_bottom_style
   * Whether a page used the CSS property border-bottom-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom_style(2038);

  /**
   * generated from use.counter.css.page.css_border_bottom_width
   * Whether a page used the CSS property border-bottom-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_bottom_width(2039);

  /**
   * generated from use.counter.css.page.css_border_collapse
   * Whether a page used the CSS property border-collapse. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_collapse(2040);

  /**
   * generated from use.counter.css.page.css_border_color
   * Whether a page used the CSS property border-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_color(2041);

  /**
   * generated from use.counter.css.page.css_border_end_end_radius
   * Whether a page used the CSS property border-end-end-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_end_end_radius(2042);

  /**
   * generated from use.counter.css.page.css_border_end_start_radius
   * Whether a page used the CSS property border-end-start-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_end_start_radius(2043);

  /**
   * generated from use.counter.css.page.css_border_image
   * Whether a page used the CSS property border-image. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image(2044);

  /**
   * generated from use.counter.css.page.css_border_image_outset
   * Whether a page used the CSS property border-image-outset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image_outset(2045);

  /**
   * generated from use.counter.css.page.css_border_image_repeat
   * Whether a page used the CSS property border-image-repeat. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image_repeat(2046);

  /**
   * generated from use.counter.css.page.css_border_image_slice
   * Whether a page used the CSS property border-image-slice. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image_slice(2047);

  /**
   * generated from use.counter.css.page.css_border_image_source
   * Whether a page used the CSS property border-image-source. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image_source(2048);

  /**
   * generated from use.counter.css.page.css_border_image_width
   * Whether a page used the CSS property border-image-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_image_width(2049);

  /**
   * generated from use.counter.css.page.css_border_inline
   * Whether a page used the CSS property border-inline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline(2050);

  /**
   * generated from use.counter.css.page.css_border_inline_color
   * Whether a page used the CSS property border-inline-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_color(2051);

  /**
   * generated from use.counter.css.page.css_border_inline_end
   * Whether a page used the CSS property border-inline-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_end(2052);

  /**
   * generated from use.counter.css.page.css_border_inline_end_color
   * Whether a page used the CSS property border-inline-end-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_end_color(2053);

  /**
   * generated from use.counter.css.page.css_border_inline_end_style
   * Whether a page used the CSS property border-inline-end-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_end_style(2054);

  /**
   * generated from use.counter.css.page.css_border_inline_end_width
   * Whether a page used the CSS property border-inline-end-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_end_width(2055);

  /**
   * generated from use.counter.css.page.css_border_inline_start
   * Whether a page used the CSS property border-inline-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_start(2056);

  /**
   * generated from use.counter.css.page.css_border_inline_start_color
   * Whether a page used the CSS property border-inline-start-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_start_color(2057);

  /**
   * generated from use.counter.css.page.css_border_inline_start_style
   * Whether a page used the CSS property border-inline-start-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_start_style(2058);

  /**
   * generated from use.counter.css.page.css_border_inline_start_width
   * Whether a page used the CSS property border-inline-start-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_start_width(2059);

  /**
   * generated from use.counter.css.page.css_border_inline_style
   * Whether a page used the CSS property border-inline-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_style(2060);

  /**
   * generated from use.counter.css.page.css_border_inline_width
   * Whether a page used the CSS property border-inline-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_inline_width(2061);

  /**
   * generated from use.counter.css.page.css_border_left
   * Whether a page used the CSS property border-left. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_left(2062);

  /**
   * generated from use.counter.css.page.css_border_left_color
   * Whether a page used the CSS property border-left-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_left_color(2063);

  /**
   * generated from use.counter.css.page.css_border_left_style
   * Whether a page used the CSS property border-left-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_left_style(2064);

  /**
   * generated from use.counter.css.page.css_border_left_width
   * Whether a page used the CSS property border-left-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_left_width(2065);

  /**
   * generated from use.counter.css.page.css_border_radius
   * Whether a page used the CSS property border-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_radius(2066);

  /**
   * generated from use.counter.css.page.css_border_right
   * Whether a page used the CSS property border-right. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_right(2067);

  /**
   * generated from use.counter.css.page.css_border_right_color
   * Whether a page used the CSS property border-right-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_right_color(2068);

  /**
   * generated from use.counter.css.page.css_border_right_style
   * Whether a page used the CSS property border-right-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_right_style(2069);

  /**
   * generated from use.counter.css.page.css_border_right_width
   * Whether a page used the CSS property border-right-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_right_width(2070);

  /**
   * generated from use.counter.css.page.css_border_spacing
   * Whether a page used the CSS property border-spacing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_spacing(2071);

  /**
   * generated from use.counter.css.page.css_border_start_end_radius
   * Whether a page used the CSS property border-start-end-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_start_end_radius(2072);

  /**
   * generated from use.counter.css.page.css_border_start_start_radius
   * Whether a page used the CSS property border-start-start-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_start_start_radius(2073);

  /**
   * generated from use.counter.css.page.css_border_style
   * Whether a page used the CSS property border-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_style(2074);

  /**
   * generated from use.counter.css.page.css_border_top
   * Whether a page used the CSS property border-top. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top(2075);

  /**
   * generated from use.counter.css.page.css_border_top_color
   * Whether a page used the CSS property border-top-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top_color(2076);

  /**
   * generated from use.counter.css.page.css_border_top_left_radius
   * Whether a page used the CSS property border-top-left-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top_left_radius(2077);

  /**
   * generated from use.counter.css.page.css_border_top_right_radius
   * Whether a page used the CSS property border-top-right-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top_right_radius(2078);

  /**
   * generated from use.counter.css.page.css_border_top_style
   * Whether a page used the CSS property border-top-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top_style(2079);

  /**
   * generated from use.counter.css.page.css_border_top_width
   * Whether a page used the CSS property border-top-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_top_width(2080);

  /**
   * generated from use.counter.css.page.css_border_width
   * Whether a page used the CSS property border-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_border_width(2081);

  /**
   * generated from use.counter.css.page.css_bottom
   * Whether a page used the CSS property bottom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_bottom(2082);

  /**
   * generated from use.counter.css.page.css_box_decoration_break
   * Whether a page used the CSS property box-decoration-break. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_box_decoration_break(2083);

  /**
   * generated from use.counter.css.page.css_box_shadow
   * Whether a page used the CSS property box-shadow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_box_shadow(2084);

  /**
   * generated from use.counter.css.page.css_box_sizing
   * Whether a page used the CSS property box-sizing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_box_sizing(2085);

  /**
   * generated from use.counter.css.page.css_break_after
   * Whether a page used the CSS property break-after. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_break_after(2086);

  /**
   * generated from use.counter.css.page.css_break_before
   * Whether a page used the CSS property break-before. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_break_before(2087);

  /**
   * generated from use.counter.css.page.css_break_inside
   * Whether a page used the CSS property break-inside. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_break_inside(2088);

  /**
   * generated from use.counter.css.page.css_caption_side
   * Whether a page used the CSS property caption-side. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_caption_side(2089);

  /**
   * generated from use.counter.css.page.css_caret_color
   * Whether a page used the CSS property caret-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_caret_color(2090);

  /**
   * generated from use.counter.css.page.css_clear
   * Whether a page used the CSS property clear. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_clear(2091);

  /**
   * generated from use.counter.css.page.css_clip
   * Whether a page used the CSS property clip. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_clip(2092);

  /**
   * generated from use.counter.css.page.css_clip_path
   * Whether a page used the CSS property clip-path. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_clip_path(2093);

  /**
   * generated from use.counter.css.page.css_clip_rule
   * Whether a page used the CSS property clip-rule. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_clip_rule(2094);

  /**
   * generated from use.counter.css.page.css_color
   * Whether a page used the CSS property color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_color(2095);

  /**
   * generated from use.counter.css.page.css_color_adjust
   * Whether a page used the CSS property color-adjust. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_color_adjust(2096);

  /**
   * generated from use.counter.css.page.css_color_interpolation
   * Whether a page used the CSS property color-interpolation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_color_interpolation(2097);

  /**
   * generated from use.counter.css.page.css_color_interpolation_filters
   * Whether a page used the CSS property color-interpolation-filters. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_color_interpolation_filters(2098);

  /**
   * generated from use.counter.css.page.css_color_scheme
   * Whether a page used the CSS property color-scheme. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_color_scheme(2099);

  /**
   * generated from use.counter.css.page.css_column_count
   * Whether a page used the CSS property column-count. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_count(2100);

  /**
   * generated from use.counter.css.page.css_column_fill
   * Whether a page used the CSS property column-fill. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_fill(2101);

  /**
   * generated from use.counter.css.page.css_column_gap
   * Whether a page used the CSS property column-gap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_gap(2102);

  /**
   * generated from use.counter.css.page.css_column_rule
   * Whether a page used the CSS property column-rule. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_rule(2103);

  /**
   * generated from use.counter.css.page.css_column_rule_color
   * Whether a page used the CSS property column-rule-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_rule_color(2104);

  /**
   * generated from use.counter.css.page.css_column_rule_style
   * Whether a page used the CSS property column-rule-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_rule_style(2105);

  /**
   * generated from use.counter.css.page.css_column_rule_width
   * Whether a page used the CSS property column-rule-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_rule_width(2106);

  /**
   * generated from use.counter.css.page.css_column_span
   * Whether a page used the CSS property column-span. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_span(2107);

  /**
   * generated from use.counter.css.page.css_column_width
   * Whether a page used the CSS property column-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_column_width(2108);

  /**
   * generated from use.counter.css.page.css_columns
   * Whether a page used the CSS property columns. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_columns(2109);

  /**
   * generated from use.counter.css.page.css_contain
   * Whether a page used the CSS property contain. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain(2110);

  /**
   * generated from use.counter.css.page.css_contain_intrinsic_block_size
   * Whether a page used the CSS property contain-intrinsic-block-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain_intrinsic_block_size(2111);

  /**
   * generated from use.counter.css.page.css_contain_intrinsic_height
   * Whether a page used the CSS property contain-intrinsic-height. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain_intrinsic_height(2112);

  /**
   * generated from use.counter.css.page.css_contain_intrinsic_inline_size
   * Whether a page used the CSS property contain-intrinsic-inline-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain_intrinsic_inline_size(2113);

  /**
   * generated from use.counter.css.page.css_contain_intrinsic_size
   * Whether a page used the CSS property contain-intrinsic-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain_intrinsic_size(2114);

  /**
   * generated from use.counter.css.page.css_contain_intrinsic_width
   * Whether a page used the CSS property contain-intrinsic-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_contain_intrinsic_width(2115);

  /**
   * generated from use.counter.css.page.css_container
   * Whether a page used the CSS property container. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_container(2116);

  /**
   * generated from use.counter.css.page.css_container_name
   * Whether a page used the CSS property container-name. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_container_name(2117);

  /**
   * generated from use.counter.css.page.css_container_type
   * Whether a page used the CSS property container-type. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_container_type(2118);

  /**
   * generated from use.counter.css.page.css_content
   * Whether a page used the CSS property content. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_content(2119);

  /**
   * generated from use.counter.css.page.css_content_visibility
   * Whether a page used the CSS property content-visibility. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_content_visibility(2120);

  /**
   * generated from use.counter.css.page.css_counter_increment
   * Whether a page used the CSS property counter-increment. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_counter_increment(2121);

  /**
   * generated from use.counter.css.page.css_counter_reset
   * Whether a page used the CSS property counter-reset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_counter_reset(2122);

  /**
   * generated from use.counter.css.page.css_counter_set
   * Whether a page used the CSS property counter-set. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_counter_set(2123);

  /**
   * generated from use.counter.css.page.css_cursor
   * Whether a page used the CSS property cursor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_cursor(2124);

  /**
   * generated from use.counter.css.page.css_cx
   * Whether a page used the CSS property cx. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_cx(2125);

  /**
   * generated from use.counter.css.page.css_cy
   * Whether a page used the CSS property cy. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_cy(2126);

  /**
   * generated from use.counter.css.page.css_d
   * Whether a page used the CSS property d. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_d(2127);

  /**
   * generated from use.counter.css.page.css_direction
   * Whether a page used the CSS property direction. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_direction(2128);

  /**
   * generated from use.counter.css.page.css_display
   * Whether a page used the CSS property display. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_display(2129);

  /**
   * generated from use.counter.css.page.css_dominant_baseline
   * Whether a page used the CSS property dominant-baseline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_dominant_baseline(2130);

  /**
   * generated from use.counter.css.page.css_empty_cells
   * Whether a page used the CSS property empty-cells. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_empty_cells(2131);

  /**
   * generated from use.counter.css.page.css_field_sizing
   * Whether a page used the CSS property field-sizing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_field_sizing(2132);

  /**
   * generated from use.counter.css.page.css_fill
   * Whether a page used the CSS property fill. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_fill(2133);

  /**
   * generated from use.counter.css.page.css_fill_opacity
   * Whether a page used the CSS property fill-opacity. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_fill_opacity(2134);

  /**
   * generated from use.counter.css.page.css_fill_rule
   * Whether a page used the CSS property fill-rule. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_fill_rule(2135);

  /**
   * generated from use.counter.css.page.css_filter
   * Whether a page used the CSS property filter. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_filter(2136);

  /**
   * generated from use.counter.css.page.css_flex
   * Whether a page used the CSS property flex. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex(2137);

  /**
   * generated from use.counter.css.page.css_flex_basis
   * Whether a page used the CSS property flex-basis. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_basis(2138);

  /**
   * generated from use.counter.css.page.css_flex_direction
   * Whether a page used the CSS property flex-direction. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_direction(2139);

  /**
   * generated from use.counter.css.page.css_flex_flow
   * Whether a page used the CSS property flex-flow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_flow(2140);

  /**
   * generated from use.counter.css.page.css_flex_grow
   * Whether a page used the CSS property flex-grow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_grow(2141);

  /**
   * generated from use.counter.css.page.css_flex_shrink
   * Whether a page used the CSS property flex-shrink. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_shrink(2142);

  /**
   * generated from use.counter.css.page.css_flex_wrap
   * Whether a page used the CSS property flex-wrap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flex_wrap(2143);

  /**
   * generated from use.counter.css.page.css_float
   * Whether a page used the CSS property float. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_float(2144);

  /**
   * generated from use.counter.css.page.css_flood_color
   * Whether a page used the CSS property flood-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flood_color(2145);

  /**
   * generated from use.counter.css.page.css_flood_opacity
   * Whether a page used the CSS property flood-opacity. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_flood_opacity(2146);

  /**
   * generated from use.counter.css.page.css_font
   * Whether a page used the CSS property font. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font(2147);

  /**
   * generated from use.counter.css.page.css_font_family
   * Whether a page used the CSS property font-family. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_family(2148);

  /**
   * generated from use.counter.css.page.css_font_feature_settings
   * Whether a page used the CSS property font-feature-settings. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_feature_settings(2149);

  /**
   * generated from use.counter.css.page.css_font_kerning
   * Whether a page used the CSS property font-kerning. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_kerning(2150);

  /**
   * generated from use.counter.css.page.css_font_language_override
   * Whether a page used the CSS property font-language-override. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_language_override(2151);

  /**
   * generated from use.counter.css.page.css_font_optical_sizing
   * Whether a page used the CSS property font-optical-sizing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_optical_sizing(2152);

  /**
   * generated from use.counter.css.page.css_font_palette
   * Whether a page used the CSS property font-palette. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_palette(2153);

  /**
   * generated from use.counter.css.page.css_font_size
   * Whether a page used the CSS property font-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_size(2154);

  /**
   * generated from use.counter.css.page.css_font_size_adjust
   * Whether a page used the CSS property font-size-adjust. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_size_adjust(2155);

  /**
   * generated from use.counter.css.page.css_font_stretch
   * Whether a page used the CSS property font-stretch. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_stretch(2156);

  /**
   * generated from use.counter.css.page.css_font_style
   * Whether a page used the CSS property font-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_style(2157);

  /**
   * generated from use.counter.css.page.css_font_synthesis
   * Whether a page used the CSS property font-synthesis. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_synthesis(2158);

  /**
   * generated from use.counter.css.page.css_font_synthesis_position
   * Whether a page used the CSS property font-synthesis-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_synthesis_position(2159);

  /**
   * generated from use.counter.css.page.css_font_synthesis_small_caps
   * Whether a page used the CSS property font-synthesis-small-caps. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_synthesis_small_caps(2160);

  /**
   * generated from use.counter.css.page.css_font_synthesis_style
   * Whether a page used the CSS property font-synthesis-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_synthesis_style(2161);

  /**
   * generated from use.counter.css.page.css_font_synthesis_weight
   * Whether a page used the CSS property font-synthesis-weight. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_synthesis_weight(2162);

  /**
   * generated from use.counter.css.page.css_font_variant
   * Whether a page used the CSS property font-variant. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant(2163);

  /**
   * generated from use.counter.css.page.css_font_variant_alternates
   * Whether a page used the CSS property font-variant-alternates. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_alternates(2164);

  /**
   * generated from use.counter.css.page.css_font_variant_caps
   * Whether a page used the CSS property font-variant-caps. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_caps(2165);

  /**
   * generated from use.counter.css.page.css_font_variant_east_asian
   * Whether a page used the CSS property font-variant-east-asian. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_east_asian(2166);

  /**
   * generated from use.counter.css.page.css_font_variant_emoji
   * Whether a page used the CSS property font-variant-emoji. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_emoji(2167);

  /**
   * generated from use.counter.css.page.css_font_variant_ligatures
   * Whether a page used the CSS property font-variant-ligatures. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_ligatures(2168);

  /**
   * generated from use.counter.css.page.css_font_variant_numeric
   * Whether a page used the CSS property font-variant-numeric. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_numeric(2169);

  /**
   * generated from use.counter.css.page.css_font_variant_position
   * Whether a page used the CSS property font-variant-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variant_position(2170);

  /**
   * generated from use.counter.css.page.css_font_variation_settings
   * Whether a page used the CSS property font-variation-settings. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_variation_settings(2171);

  /**
   * generated from use.counter.css.page.css_font_weight
   * Whether a page used the CSS property font-weight. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_font_weight(2172);

  /**
   * generated from use.counter.css.page.css_forced_color_adjust
   * Whether a page used the CSS property forced-color-adjust. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_forced_color_adjust(2173);

  /**
   * generated from use.counter.css.page.css_gap
   * Whether a page used the CSS property gap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_gap(2174);

  /**
   * generated from use.counter.css.page.css_grid
   * Whether a page used the CSS property grid. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid(2175);

  /**
   * generated from use.counter.css.page.css_grid_area
   * Whether a page used the CSS property grid-area. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_area(2176);

  /**
   * generated from use.counter.css.page.css_grid_auto_columns
   * Whether a page used the CSS property grid-auto-columns. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_auto_columns(2177);

  /**
   * generated from use.counter.css.page.css_grid_auto_flow
   * Whether a page used the CSS property grid-auto-flow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_auto_flow(2178);

  /**
   * generated from use.counter.css.page.css_grid_auto_rows
   * Whether a page used the CSS property grid-auto-rows. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_auto_rows(2179);

  /**
   * generated from use.counter.css.page.css_grid_column
   * Whether a page used the CSS property grid-column. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_column(2180);

  /**
   * generated from use.counter.css.page.css_grid_column_end
   * Whether a page used the CSS property grid-column-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_column_end(2181);

  /**
   * generated from use.counter.css.page.css_grid_column_gap
   * Whether a page used the CSS property grid-column-gap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_column_gap(2182);

  /**
   * generated from use.counter.css.page.css_grid_column_start
   * Whether a page used the CSS property grid-column-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_column_start(2183);

  /**
   * generated from use.counter.css.page.css_grid_gap
   * Whether a page used the CSS property grid-gap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_gap(2184);

  /**
   * generated from use.counter.css.page.css_grid_row
   * Whether a page used the CSS property grid-row. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_row(2185);

  /**
   * generated from use.counter.css.page.css_grid_row_end
   * Whether a page used the CSS property grid-row-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_row_end(2186);

  /**
   * generated from use.counter.css.page.css_grid_row_gap
   * Whether a page used the CSS property grid-row-gap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_row_gap(2187);

  /**
   * generated from use.counter.css.page.css_grid_row_start
   * Whether a page used the CSS property grid-row-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_row_start(2188);

  /**
   * generated from use.counter.css.page.css_grid_template
   * Whether a page used the CSS property grid-template. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_template(2189);

  /**
   * generated from use.counter.css.page.css_grid_template_areas
   * Whether a page used the CSS property grid-template-areas. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_template_areas(2190);

  /**
   * generated from use.counter.css.page.css_grid_template_columns
   * Whether a page used the CSS property grid-template-columns. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_template_columns(2191);

  /**
   * generated from use.counter.css.page.css_grid_template_rows
   * Whether a page used the CSS property grid-template-rows. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_grid_template_rows(2192);

  /**
   * generated from use.counter.css.page.css_height
   * Whether a page used the CSS property height. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_height(2193);

  /**
   * generated from use.counter.css.page.css_hyphenate_character
   * Whether a page used the CSS property hyphenate-character. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_hyphenate_character(2194);

  /**
   * generated from use.counter.css.page.css_hyphenate_limit_chars
   * Whether a page used the CSS property hyphenate-limit-chars. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_hyphenate_limit_chars(2195);

  /**
   * generated from use.counter.css.page.css_hyphens
   * Whether a page used the CSS property hyphens. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_hyphens(2196);

  /**
   * generated from use.counter.css.page.css_image_orientation
   * Whether a page used the CSS property image-orientation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_image_orientation(2197);

  /**
   * generated from use.counter.css.page.css_image_rendering
   * Whether a page used the CSS property image-rendering. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_image_rendering(2198);

  /**
   * generated from use.counter.css.page.css_ime_mode
   * Whether a page used the CSS property ime-mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_ime_mode(2199);

  /**
   * generated from use.counter.css.page.css_initial_letter
   * Whether a page used the CSS property initial-letter. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_initial_letter(2200);

  /**
   * generated from use.counter.css.page.css_inline_size
   * Whether a page used the CSS property inline-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inline_size(2201);

  /**
   * generated from use.counter.css.page.css_inset
   * Whether a page used the CSS property inset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset(2202);

  /**
   * generated from use.counter.css.page.css_inset_block
   * Whether a page used the CSS property inset-block. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_block(2203);

  /**
   * generated from use.counter.css.page.css_inset_block_end
   * Whether a page used the CSS property inset-block-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_block_end(2204);

  /**
   * generated from use.counter.css.page.css_inset_block_start
   * Whether a page used the CSS property inset-block-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_block_start(2205);

  /**
   * generated from use.counter.css.page.css_inset_inline
   * Whether a page used the CSS property inset-inline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_inline(2206);

  /**
   * generated from use.counter.css.page.css_inset_inline_end
   * Whether a page used the CSS property inset-inline-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_inline_end(2207);

  /**
   * generated from use.counter.css.page.css_inset_inline_start
   * Whether a page used the CSS property inset-inline-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_inset_inline_start(2208);

  /**
   * generated from use.counter.css.page.css_isolation
   * Whether a page used the CSS property isolation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_isolation(2209);

  /**
   * generated from use.counter.css.page.css_justify_content
   * Whether a page used the CSS property justify-content. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_justify_content(2210);

  /**
   * generated from use.counter.css.page.css_justify_items
   * Whether a page used the CSS property justify-items. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_justify_items(2211);

  /**
   * generated from use.counter.css.page.css_justify_self
   * Whether a page used the CSS property justify-self. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_justify_self(2212);

  /**
   * generated from use.counter.css.page.css_left
   * Whether a page used the CSS property left. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_left(2213);

  /**
   * generated from use.counter.css.page.css_letter_spacing
   * Whether a page used the CSS property letter-spacing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_letter_spacing(2214);

  /**
   * generated from use.counter.css.page.css_lighting_color
   * Whether a page used the CSS property lighting-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_lighting_color(2215);

  /**
   * generated from use.counter.css.page.css_line_break
   * Whether a page used the CSS property line-break. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_line_break(2216);

  /**
   * generated from use.counter.css.page.css_line_height
   * Whether a page used the CSS property line-height. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_line_height(2217);

  /**
   * generated from use.counter.css.page.css_list_style
   * Whether a page used the CSS property list-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_list_style(2218);

  /**
   * generated from use.counter.css.page.css_list_style_image
   * Whether a page used the CSS property list-style-image. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_list_style_image(2219);

  /**
   * generated from use.counter.css.page.css_list_style_position
   * Whether a page used the CSS property list-style-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_list_style_position(2220);

  /**
   * generated from use.counter.css.page.css_list_style_type
   * Whether a page used the CSS property list-style-type. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_list_style_type(2221);

  /**
   * generated from use.counter.css.page.css_margin
   * Whether a page used the CSS property margin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin(2222);

  /**
   * generated from use.counter.css.page.css_margin_block
   * Whether a page used the CSS property margin-block. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_block(2223);

  /**
   * generated from use.counter.css.page.css_margin_block_end
   * Whether a page used the CSS property margin-block-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_block_end(2224);

  /**
   * generated from use.counter.css.page.css_margin_block_start
   * Whether a page used the CSS property margin-block-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_block_start(2225);

  /**
   * generated from use.counter.css.page.css_margin_bottom
   * Whether a page used the CSS property margin-bottom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_bottom(2226);

  /**
   * generated from use.counter.css.page.css_margin_inline
   * Whether a page used the CSS property margin-inline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_inline(2227);

  /**
   * generated from use.counter.css.page.css_margin_inline_end
   * Whether a page used the CSS property margin-inline-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_inline_end(2228);

  /**
   * generated from use.counter.css.page.css_margin_inline_start
   * Whether a page used the CSS property margin-inline-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_inline_start(2229);

  /**
   * generated from use.counter.css.page.css_margin_left
   * Whether a page used the CSS property margin-left. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_left(2230);

  /**
   * generated from use.counter.css.page.css_margin_right
   * Whether a page used the CSS property margin-right. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_right(2231);

  /**
   * generated from use.counter.css.page.css_margin_top
   * Whether a page used the CSS property margin-top. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_margin_top(2232);

  /**
   * generated from use.counter.css.page.css_marker
   * Whether a page used the CSS property marker. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_marker(2233);

  /**
   * generated from use.counter.css.page.css_marker_end
   * Whether a page used the CSS property marker-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_marker_end(2234);

  /**
   * generated from use.counter.css.page.css_marker_mid
   * Whether a page used the CSS property marker-mid. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_marker_mid(2235);

  /**
   * generated from use.counter.css.page.css_marker_start
   * Whether a page used the CSS property marker-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_marker_start(2236);

  /**
   * generated from use.counter.css.page.css_mask
   * Whether a page used the CSS property mask. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask(2237);

  /**
   * generated from use.counter.css.page.css_mask_clip
   * Whether a page used the CSS property mask-clip. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_clip(2238);

  /**
   * generated from use.counter.css.page.css_mask_composite
   * Whether a page used the CSS property mask-composite. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_composite(2239);

  /**
   * generated from use.counter.css.page.css_mask_image
   * Whether a page used the CSS property mask-image. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_image(2240);

  /**
   * generated from use.counter.css.page.css_mask_mode
   * Whether a page used the CSS property mask-mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_mode(2241);

  /**
   * generated from use.counter.css.page.css_mask_origin
   * Whether a page used the CSS property mask-origin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_origin(2242);

  /**
   * generated from use.counter.css.page.css_mask_position
   * Whether a page used the CSS property mask-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_position(2243);

  /**
   * generated from use.counter.css.page.css_mask_position_x
   * Whether a page used the CSS property mask-position-x. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_position_x(2244);

  /**
   * generated from use.counter.css.page.css_mask_position_y
   * Whether a page used the CSS property mask-position-y. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_position_y(2245);

  /**
   * generated from use.counter.css.page.css_mask_repeat
   * Whether a page used the CSS property mask-repeat. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_repeat(2246);

  /**
   * generated from use.counter.css.page.css_mask_size
   * Whether a page used the CSS property mask-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_size(2247);

  /**
   * generated from use.counter.css.page.css_mask_type
   * Whether a page used the CSS property mask-type. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mask_type(2248);

  /**
   * generated from use.counter.css.page.css_masonry_auto_flow
   * Whether a page used the CSS property masonry-auto-flow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_masonry_auto_flow(2249);

  /**
   * generated from use.counter.css.page.css_math_depth
   * Whether a page used the CSS property math-depth. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_math_depth(2250);

  /**
   * generated from use.counter.css.page.css_math_shift
   * Whether a page used the CSS property math-shift. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_math_shift(2251);

  /**
   * generated from use.counter.css.page.css_math_style
   * Whether a page used the CSS property math-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_math_style(2252);

  /**
   * generated from use.counter.css.page.css_max_block_size
   * Whether a page used the CSS property max-block-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_max_block_size(2253);

  /**
   * generated from use.counter.css.page.css_max_height
   * Whether a page used the CSS property max-height. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_max_height(2254);

  /**
   * generated from use.counter.css.page.css_max_inline_size
   * Whether a page used the CSS property max-inline-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_max_inline_size(2255);

  /**
   * generated from use.counter.css.page.css_max_width
   * Whether a page used the CSS property max-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_max_width(2256);

  /**
   * generated from use.counter.css.page.css_min_block_size
   * Whether a page used the CSS property min-block-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_min_block_size(2257);

  /**
   * generated from use.counter.css.page.css_min_height
   * Whether a page used the CSS property min-height. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_min_height(2258);

  /**
   * generated from use.counter.css.page.css_min_inline_size
   * Whether a page used the CSS property min-inline-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_min_inline_size(2259);

  /**
   * generated from use.counter.css.page.css_min_width
   * Whether a page used the CSS property min-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_min_width(2260);

  /**
   * generated from use.counter.css.page.css_mix_blend_mode
   * Whether a page used the CSS property mix-blend-mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_mix_blend_mode(2261);

  /**
   * generated from use.counter.css.page.css_moz_animation
   * Whether a page used the CSS property -moz-animation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation(2262);

  /**
   * generated from use.counter.css.page.css_moz_animation_delay
   * Whether a page used the CSS property -moz-animation-delay. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_delay(2263);

  /**
   * generated from use.counter.css.page.css_moz_animation_direction
   * Whether a page used the CSS property -moz-animation-direction. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_direction(2264);

  /**
   * generated from use.counter.css.page.css_moz_animation_duration
   * Whether a page used the CSS property -moz-animation-duration. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_duration(2265);

  /**
   * generated from use.counter.css.page.css_moz_animation_fill_mode
   * Whether a page used the CSS property -moz-animation-fill-mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_fill_mode(2266);

  /**
   * generated from use.counter.css.page.css_moz_animation_iteration_count
   * Whether a page used the CSS property -moz-animation-iteration-count. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_iteration_count(2267);

  /**
   * generated from use.counter.css.page.css_moz_animation_name
   * Whether a page used the CSS property -moz-animation-name. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_name(2268);

  /**
   * generated from use.counter.css.page.css_moz_animation_play_state
   * Whether a page used the CSS property -moz-animation-play-state. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_play_state(2269);

  /**
   * generated from use.counter.css.page.css_moz_animation_timing_function
   * Whether a page used the CSS property -moz-animation-timing-function. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_animation_timing_function(2270);

  /**
   * generated from use.counter.css.page.css_moz_appearance
   * Whether a page used the CSS property -moz-appearance. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_appearance(2271);

  /**
   * generated from use.counter.css.page.css_moz_backface_visibility
   * Whether a page used the CSS property -moz-backface-visibility. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_backface_visibility(2272);

  /**
   * generated from use.counter.css.page.css_moz_border_end
   * Whether a page used the CSS property -moz-border-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_end(2273);

  /**
   * generated from use.counter.css.page.css_moz_border_end_color
   * Whether a page used the CSS property -moz-border-end-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_end_color(2274);

  /**
   * generated from use.counter.css.page.css_moz_border_end_style
   * Whether a page used the CSS property -moz-border-end-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_end_style(2275);

  /**
   * generated from use.counter.css.page.css_moz_border_end_width
   * Whether a page used the CSS property -moz-border-end-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_end_width(2276);

  /**
   * generated from use.counter.css.page.css_moz_border_image
   * Whether a page used the CSS property -moz-border-image. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_image(2277);

  /**
   * generated from use.counter.css.page.css_moz_border_start
   * Whether a page used the CSS property -moz-border-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_start(2278);

  /**
   * generated from use.counter.css.page.css_moz_border_start_color
   * Whether a page used the CSS property -moz-border-start-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_start_color(2279);

  /**
   * generated from use.counter.css.page.css_moz_border_start_style
   * Whether a page used the CSS property -moz-border-start-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_start_style(2280);

  /**
   * generated from use.counter.css.page.css_moz_border_start_width
   * Whether a page used the CSS property -moz-border-start-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_border_start_width(2281);

  /**
   * generated from use.counter.css.page.css_moz_box_align
   * Whether a page used the CSS property -moz-box-align. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_align(2282);

  /**
   * generated from use.counter.css.page.css_moz_box_collapse
   * Whether a page used the CSS property -moz-box-collapse. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_collapse(2283);

  /**
   * generated from use.counter.css.page.css_moz_box_direction
   * Whether a page used the CSS property -moz-box-direction. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_direction(2284);

  /**
   * generated from use.counter.css.page.css_moz_box_flex
   * Whether a page used the CSS property -moz-box-flex. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_flex(2285);

  /**
   * generated from use.counter.css.page.css_moz_box_ordinal_group
   * Whether a page used the CSS property -moz-box-ordinal-group. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_ordinal_group(2286);

  /**
   * generated from use.counter.css.page.css_moz_box_orient
   * Whether a page used the CSS property -moz-box-orient. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_orient(2287);

  /**
   * generated from use.counter.css.page.css_moz_box_pack
   * Whether a page used the CSS property -moz-box-pack. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_pack(2288);

  /**
   * generated from use.counter.css.page.css_moz_box_sizing
   * Whether a page used the CSS property -moz-box-sizing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_box_sizing(2289);

  /**
   * generated from use.counter.css.page.css_moz_context_properties
   * Whether a page used the CSS property -moz-context-properties. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_context_properties(2290);

  /**
   * generated from use.counter.css.page.css_moz_control_character_visibility
   * Whether a page used the CSS property -moz-control-character-visibility. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_control_character_visibility(2291);

  /**
   * generated from use.counter.css.page.css_moz_default_appearance
   * Whether a page used the CSS property -moz-default-appearance. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_default_appearance(2292);

  /**
   * generated from use.counter.css.page.css_moz_float_edge
   * Whether a page used the CSS property -moz-float-edge. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_float_edge(2293);

  /**
   * generated from use.counter.css.page.css_moz_font_feature_settings
   * Whether a page used the CSS property -moz-font-feature-settings. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_font_feature_settings(2294);

  /**
   * generated from use.counter.css.page.css_moz_font_language_override
   * Whether a page used the CSS property -moz-font-language-override. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_font_language_override(2295);

  /**
   * generated from use.counter.css.page.css_moz_force_broken_image_icon
   * Whether a page used the CSS property -moz-force-broken-image-icon. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_force_broken_image_icon(2296);

  /**
   * generated from use.counter.css.page.css_moz_hyphens
   * Whether a page used the CSS property -moz-hyphens. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_hyphens(2297);

  /**
   * generated from use.counter.css.page.css_moz_inert
   * Whether a page used the CSS property -moz-inert. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_inert(2298);

  /**
   * generated from use.counter.css.page.css_moz_margin_end
   * Whether a page used the CSS property -moz-margin-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_margin_end(2299);

  /**
   * generated from use.counter.css.page.css_moz_margin_start
   * Whether a page used the CSS property -moz-margin-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_margin_start(2300);

  /**
   * generated from use.counter.css.page.css_moz_math_variant
   * Whether a page used the CSS property -moz-math-variant. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_math_variant(2301);

  /**
   * generated from use.counter.css.page.css_moz_min_font_size_ratio
   * Whether a page used the CSS property -moz-min-font-size-ratio. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_min_font_size_ratio(2302);

  /**
   * generated from use.counter.css.page.css_moz_orient
   * Whether a page used the CSS property -moz-orient. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_orient(2303);

  /**
   * generated from use.counter.css.page.css_moz_osx_font_smoothing
   * Whether a page used the CSS property -moz-osx-font-smoothing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_osx_font_smoothing(2304);

  /**
   * generated from use.counter.css.page.css_moz_padding_end
   * Whether a page used the CSS property -moz-padding-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_padding_end(2305);

  /**
   * generated from use.counter.css.page.css_moz_padding_start
   * Whether a page used the CSS property -moz-padding-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_padding_start(2306);

  /**
   * generated from use.counter.css.page.css_moz_perspective
   * Whether a page used the CSS property -moz-perspective. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_perspective(2307);

  /**
   * generated from use.counter.css.page.css_moz_perspective_origin
   * Whether a page used the CSS property -moz-perspective-origin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_perspective_origin(2308);

  /**
   * generated from use.counter.css.page.css_moz_subtree_hidden_only_visually
   * Whether a page used the CSS property -moz-subtree-hidden-only-visually. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_subtree_hidden_only_visually(2309);

  /**
   * generated from use.counter.css.page.css_moz_tab_size
   * Whether a page used the CSS property -moz-tab-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_tab_size(2310);

  /**
   * generated from use.counter.css.page.css_moz_text_size_adjust
   * Whether a page used the CSS property -moz-text-size-adjust. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_text_size_adjust(2311);

  /**
   * generated from use.counter.css.page.css_moz_theme
   * Whether a page used the CSS property -moz-theme. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_theme(2312);

  /**
   * generated from use.counter.css.page.css_moz_top_layer
   * Whether a page used the CSS property -moz-top-layer. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_top_layer(2313);

  /**
   * generated from use.counter.css.page.css_moz_transform
   * Whether a page used the CSS property -moz-transform. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transform(2314);

  /**
   * generated from use.counter.css.page.css_moz_transform_origin
   * Whether a page used the CSS property -moz-transform-origin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transform_origin(2315);

  /**
   * generated from use.counter.css.page.css_moz_transform_style
   * Whether a page used the CSS property -moz-transform-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transform_style(2316);

  /**
   * generated from use.counter.css.page.css_moz_transition
   * Whether a page used the CSS property -moz-transition. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transition(2317);

  /**
   * generated from use.counter.css.page.css_moz_transition_delay
   * Whether a page used the CSS property -moz-transition-delay. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transition_delay(2318);

  /**
   * generated from use.counter.css.page.css_moz_transition_duration
   * Whether a page used the CSS property -moz-transition-duration. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transition_duration(2319);

  /**
   * generated from use.counter.css.page.css_moz_transition_property
   * Whether a page used the CSS property -moz-transition-property. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transition_property(2320);

  /**
   * generated from use.counter.css.page.css_moz_transition_timing_function
   * Whether a page used the CSS property -moz-transition-timing-function. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_transition_timing_function(2321);

  /**
   * generated from use.counter.css.page.css_moz_user_focus
   * Whether a page used the CSS property -moz-user-focus. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_user_focus(2322);

  /**
   * generated from use.counter.css.page.css_moz_user_select
   * Whether a page used the CSS property -moz-user-select. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_user_select(2323);

  /**
   * generated from use.counter.css.page.css_moz_window_dragging
   * Whether a page used the CSS property -moz-window-dragging. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_window_dragging(2324);

  /**
   * generated from use.counter.css.page.css_moz_window_input_region_margin
   * Whether a page used the CSS property -moz-window-input-region-margin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_window_input_region_margin(2325);

  /**
   * generated from use.counter.css.page.css_moz_window_opacity
   * Whether a page used the CSS property -moz-window-opacity. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_window_opacity(2326);

  /**
   * generated from use.counter.css.page.css_moz_window_shadow
   * Whether a page used the CSS property -moz-window-shadow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_window_shadow(2327);

  /**
   * generated from use.counter.css.page.css_moz_window_transform
   * Whether a page used the CSS property -moz-window-transform. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_moz_window_transform(2328);

  /**
   * generated from use.counter.css.page.css_object_fit
   * Whether a page used the CSS property object-fit. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_object_fit(2329);

  /**
   * generated from use.counter.css.page.css_object_position
   * Whether a page used the CSS property object-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_object_position(2330);

  /**
   * generated from use.counter.css.page.css_offset
   * Whether a page used the CSS property offset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset(2331);

  /**
   * generated from use.counter.css.page.css_offset_anchor
   * Whether a page used the CSS property offset-anchor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset_anchor(2332);

  /**
   * generated from use.counter.css.page.css_offset_distance
   * Whether a page used the CSS property offset-distance. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset_distance(2333);

  /**
   * generated from use.counter.css.page.css_offset_path
   * Whether a page used the CSS property offset-path. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset_path(2334);

  /**
   * generated from use.counter.css.page.css_offset_position
   * Whether a page used the CSS property offset-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset_position(2335);

  /**
   * generated from use.counter.css.page.css_offset_rotate
   * Whether a page used the CSS property offset-rotate. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_offset_rotate(2336);

  /**
   * generated from use.counter.css.page.css_opacity
   * Whether a page used the CSS property opacity. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_opacity(2337);

  /**
   * generated from use.counter.css.page.css_order
   * Whether a page used the CSS property order. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_order(2338);

  /**
   * generated from use.counter.css.page.css_outline
   * Whether a page used the CSS property outline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_outline(2339);

  /**
   * generated from use.counter.css.page.css_outline_color
   * Whether a page used the CSS property outline-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_outline_color(2340);

  /**
   * generated from use.counter.css.page.css_outline_offset
   * Whether a page used the CSS property outline-offset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_outline_offset(2341);

  /**
   * generated from use.counter.css.page.css_outline_style
   * Whether a page used the CSS property outline-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_outline_style(2342);

  /**
   * generated from use.counter.css.page.css_outline_width
   * Whether a page used the CSS property outline-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_outline_width(2343);

  /**
   * generated from use.counter.css.page.css_overflow
   * Whether a page used the CSS property overflow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow(2344);

  /**
   * generated from use.counter.css.page.css_overflow_anchor
   * Whether a page used the CSS property overflow-anchor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_anchor(2345);

  /**
   * generated from use.counter.css.page.css_overflow_block
   * Whether a page used the CSS property overflow-block. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_block(2346);

  /**
   * generated from use.counter.css.page.css_overflow_clip_margin
   * Whether a page used the CSS property overflow-clip-margin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_clip_margin(2347);

  /**
   * generated from use.counter.css.page.css_overflow_inline
   * Whether a page used the CSS property overflow-inline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_inline(2348);

  /**
   * generated from use.counter.css.page.css_overflow_wrap
   * Whether a page used the CSS property overflow-wrap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_wrap(2349);

  /**
   * generated from use.counter.css.page.css_overflow_x
   * Whether a page used the CSS property overflow-x. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_x(2350);

  /**
   * generated from use.counter.css.page.css_overflow_y
   * Whether a page used the CSS property overflow-y. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overflow_y(2351);

  /**
   * generated from use.counter.css.page.css_overscroll_behavior
   * Whether a page used the CSS property overscroll-behavior. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overscroll_behavior(2352);

  /**
   * generated from use.counter.css.page.css_overscroll_behavior_block
   * Whether a page used the CSS property overscroll-behavior-block. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overscroll_behavior_block(2353);

  /**
   * generated from use.counter.css.page.css_overscroll_behavior_inline
   * Whether a page used the CSS property overscroll-behavior-inline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overscroll_behavior_inline(2354);

  /**
   * generated from use.counter.css.page.css_overscroll_behavior_x
   * Whether a page used the CSS property overscroll-behavior-x. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overscroll_behavior_x(2355);

  /**
   * generated from use.counter.css.page.css_overscroll_behavior_y
   * Whether a page used the CSS property overscroll-behavior-y. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_overscroll_behavior_y(2356);

  /**
   * generated from use.counter.css.page.css_padding
   * Whether a page used the CSS property padding. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding(2357);

  /**
   * generated from use.counter.css.page.css_padding_block
   * Whether a page used the CSS property padding-block. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_block(2358);

  /**
   * generated from use.counter.css.page.css_padding_block_end
   * Whether a page used the CSS property padding-block-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_block_end(2359);

  /**
   * generated from use.counter.css.page.css_padding_block_start
   * Whether a page used the CSS property padding-block-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_block_start(2360);

  /**
   * generated from use.counter.css.page.css_padding_bottom
   * Whether a page used the CSS property padding-bottom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_bottom(2361);

  /**
   * generated from use.counter.css.page.css_padding_inline
   * Whether a page used the CSS property padding-inline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_inline(2362);

  /**
   * generated from use.counter.css.page.css_padding_inline_end
   * Whether a page used the CSS property padding-inline-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_inline_end(2363);

  /**
   * generated from use.counter.css.page.css_padding_inline_start
   * Whether a page used the CSS property padding-inline-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_inline_start(2364);

  /**
   * generated from use.counter.css.page.css_padding_left
   * Whether a page used the CSS property padding-left. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_left(2365);

  /**
   * generated from use.counter.css.page.css_padding_right
   * Whether a page used the CSS property padding-right. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_right(2366);

  /**
   * generated from use.counter.css.page.css_padding_top
   * Whether a page used the CSS property padding-top. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_padding_top(2367);

  /**
   * generated from use.counter.css.page.css_page
   * Whether a page used the CSS property page. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_page(2368);

  /**
   * generated from use.counter.css.page.css_page_break_after
   * Whether a page used the CSS property page-break-after. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_page_break_after(2369);

  /**
   * generated from use.counter.css.page.css_page_break_before
   * Whether a page used the CSS property page-break-before. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_page_break_before(2370);

  /**
   * generated from use.counter.css.page.css_page_break_inside
   * Whether a page used the CSS property page-break-inside. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_page_break_inside(2371);

  /**
   * generated from use.counter.css.page.css_page_orientation
   * Whether a page used the CSS property page-orientation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_page_orientation(2372);

  /**
   * generated from use.counter.css.page.css_paint_order
   * Whether a page used the CSS property paint-order. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_paint_order(2373);

  /**
   * generated from use.counter.css.page.css_perspective
   * Whether a page used the CSS property perspective. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_perspective(2374);

  /**
   * generated from use.counter.css.page.css_perspective_origin
   * Whether a page used the CSS property perspective-origin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_perspective_origin(2375);

  /**
   * generated from use.counter.css.page.css_place_content
   * Whether a page used the CSS property place-content. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_place_content(2376);

  /**
   * generated from use.counter.css.page.css_place_items
   * Whether a page used the CSS property place-items. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_place_items(2377);

  /**
   * generated from use.counter.css.page.css_place_self
   * Whether a page used the CSS property place-self. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_place_self(2378);

  /**
   * generated from use.counter.css.page.css_pointer_events
   * Whether a page used the CSS property pointer-events. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_pointer_events(2379);

  /**
   * generated from use.counter.css.page.css_position
   * Whether a page used the CSS property position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position(2380);

  /**
   * generated from use.counter.css.page.css_position_anchor
   * Whether a page used the CSS property position-anchor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_anchor(2381);

  /**
   * generated from use.counter.css.page.css_position_area
   * Whether a page used the CSS property position-area. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_area(2382);

  /**
   * generated from use.counter.css.page.css_position_try
   * Whether a page used the CSS property position-try. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_try(2383);

  /**
   * generated from use.counter.css.page.css_position_try_fallbacks
   * Whether a page used the CSS property position-try-fallbacks. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_try_fallbacks(2384);

  /**
   * generated from use.counter.css.page.css_position_try_order
   * Whether a page used the CSS property position-try-order. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_try_order(2385);

  /**
   * generated from use.counter.css.page.css_position_visibility
   * Whether a page used the CSS property position-visibility. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_position_visibility(2386);

  /**
   * generated from use.counter.css.page.css_print_color_adjust
   * Whether a page used the CSS property print-color-adjust. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_print_color_adjust(2387);

  /**
   * generated from use.counter.css.page.css_quotes
   * Whether a page used the CSS property quotes. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_quotes(2388);

  /**
   * generated from use.counter.css.page.css_r
   * Whether a page used the CSS property r. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_r(2389);

  /**
   * generated from use.counter.css.page.css_resize
   * Whether a page used the CSS property resize. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_resize(2390);

  /**
   * generated from use.counter.css.page.css_right
   * Whether a page used the CSS property right. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_right(2391);

  /**
   * generated from use.counter.css.page.css_rotate
   * Whether a page used the CSS property rotate. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_rotate(2392);

  /**
   * generated from use.counter.css.page.css_row_gap
   * Whether a page used the CSS property row-gap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_row_gap(2393);

  /**
   * generated from use.counter.css.page.css_ruby_align
   * Whether a page used the CSS property ruby-align. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_ruby_align(2394);

  /**
   * generated from use.counter.css.page.css_ruby_position
   * Whether a page used the CSS property ruby-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_ruby_position(2395);

  /**
   * generated from use.counter.css.page.css_rx
   * Whether a page used the CSS property rx. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_rx(2396);

  /**
   * generated from use.counter.css.page.css_ry
   * Whether a page used the CSS property ry. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_ry(2397);

  /**
   * generated from use.counter.css.page.css_scale
   * Whether a page used the CSS property scale. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scale(2398);

  /**
   * generated from use.counter.css.page.css_scroll_behavior
   * Whether a page used the CSS property scroll-behavior. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_behavior(2399);

  /**
   * generated from use.counter.css.page.css_scroll_margin
   * Whether a page used the CSS property scroll-margin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin(2400);

  /**
   * generated from use.counter.css.page.css_scroll_margin_block
   * Whether a page used the CSS property scroll-margin-block. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_block(2401);

  /**
   * generated from use.counter.css.page.css_scroll_margin_block_end
   * Whether a page used the CSS property scroll-margin-block-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_block_end(2402);

  /**
   * generated from use.counter.css.page.css_scroll_margin_block_start
   * Whether a page used the CSS property scroll-margin-block-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_block_start(2403);

  /**
   * generated from use.counter.css.page.css_scroll_margin_bottom
   * Whether a page used the CSS property scroll-margin-bottom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_bottom(2404);

  /**
   * generated from use.counter.css.page.css_scroll_margin_inline
   * Whether a page used the CSS property scroll-margin-inline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_inline(2405);

  /**
   * generated from use.counter.css.page.css_scroll_margin_inline_end
   * Whether a page used the CSS property scroll-margin-inline-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_inline_end(2406);

  /**
   * generated from use.counter.css.page.css_scroll_margin_inline_start
   * Whether a page used the CSS property scroll-margin-inline-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_inline_start(2407);

  /**
   * generated from use.counter.css.page.css_scroll_margin_left
   * Whether a page used the CSS property scroll-margin-left. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_left(2408);

  /**
   * generated from use.counter.css.page.css_scroll_margin_right
   * Whether a page used the CSS property scroll-margin-right. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_right(2409);

  /**
   * generated from use.counter.css.page.css_scroll_margin_top
   * Whether a page used the CSS property scroll-margin-top. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_margin_top(2410);

  /**
   * generated from use.counter.css.page.css_scroll_padding
   * Whether a page used the CSS property scroll-padding. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding(2411);

  /**
   * generated from use.counter.css.page.css_scroll_padding_block
   * Whether a page used the CSS property scroll-padding-block. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_block(2412);

  /**
   * generated from use.counter.css.page.css_scroll_padding_block_end
   * Whether a page used the CSS property scroll-padding-block-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_block_end(2413);

  /**
   * generated from use.counter.css.page.css_scroll_padding_block_start
   * Whether a page used the CSS property scroll-padding-block-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_block_start(2414);

  /**
   * generated from use.counter.css.page.css_scroll_padding_bottom
   * Whether a page used the CSS property scroll-padding-bottom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_bottom(2415);

  /**
   * generated from use.counter.css.page.css_scroll_padding_inline
   * Whether a page used the CSS property scroll-padding-inline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_inline(2416);

  /**
   * generated from use.counter.css.page.css_scroll_padding_inline_end
   * Whether a page used the CSS property scroll-padding-inline-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_inline_end(2417);

  /**
   * generated from use.counter.css.page.css_scroll_padding_inline_start
   * Whether a page used the CSS property scroll-padding-inline-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_inline_start(2418);

  /**
   * generated from use.counter.css.page.css_scroll_padding_left
   * Whether a page used the CSS property scroll-padding-left. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_left(2419);

  /**
   * generated from use.counter.css.page.css_scroll_padding_right
   * Whether a page used the CSS property scroll-padding-right. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_right(2420);

  /**
   * generated from use.counter.css.page.css_scroll_padding_top
   * Whether a page used the CSS property scroll-padding-top. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_padding_top(2421);

  /**
   * generated from use.counter.css.page.css_scroll_snap_align
   * Whether a page used the CSS property scroll-snap-align. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_snap_align(2422);

  /**
   * generated from use.counter.css.page.css_scroll_snap_stop
   * Whether a page used the CSS property scroll-snap-stop. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_snap_stop(2423);

  /**
   * generated from use.counter.css.page.css_scroll_snap_type
   * Whether a page used the CSS property scroll-snap-type. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_snap_type(2424);

  /**
   * generated from use.counter.css.page.css_scroll_timeline
   * Whether a page used the CSS property scroll-timeline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_timeline(2425);

  /**
   * generated from use.counter.css.page.css_scroll_timeline_axis
   * Whether a page used the CSS property scroll-timeline-axis. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_timeline_axis(2426);

  /**
   * generated from use.counter.css.page.css_scroll_timeline_name
   * Whether a page used the CSS property scroll-timeline-name. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scroll_timeline_name(2427);

  /**
   * generated from use.counter.css.page.css_scrollbar_color
   * Whether a page used the CSS property scrollbar-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scrollbar_color(2428);

  /**
   * generated from use.counter.css.page.css_scrollbar_gutter
   * Whether a page used the CSS property scrollbar-gutter. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scrollbar_gutter(2429);

  /**
   * generated from use.counter.css.page.css_scrollbar_width
   * Whether a page used the CSS property scrollbar-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_scrollbar_width(2430);

  /**
   * generated from use.counter.css.page.css_shape_image_threshold
   * Whether a page used the CSS property shape-image-threshold. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_shape_image_threshold(2431);

  /**
   * generated from use.counter.css.page.css_shape_margin
   * Whether a page used the CSS property shape-margin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_shape_margin(2432);

  /**
   * generated from use.counter.css.page.css_shape_outside
   * Whether a page used the CSS property shape-outside. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_shape_outside(2433);

  /**
   * generated from use.counter.css.page.css_shape_rendering
   * Whether a page used the CSS property shape-rendering. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_shape_rendering(2434);

  /**
   * generated from use.counter.css.page.css_size
   * Whether a page used the CSS property size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_size(2435);

  /**
   * generated from use.counter.css.page.css_stop_color
   * Whether a page used the CSS property stop-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stop_color(2436);

  /**
   * generated from use.counter.css.page.css_stop_opacity
   * Whether a page used the CSS property stop-opacity. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stop_opacity(2437);

  /**
   * generated from use.counter.css.page.css_stroke
   * Whether a page used the CSS property stroke. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke(2438);

  /**
   * generated from use.counter.css.page.css_stroke_dasharray
   * Whether a page used the CSS property stroke-dasharray. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_dasharray(2439);

  /**
   * generated from use.counter.css.page.css_stroke_dashoffset
   * Whether a page used the CSS property stroke-dashoffset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_dashoffset(2440);

  /**
   * generated from use.counter.css.page.css_stroke_linecap
   * Whether a page used the CSS property stroke-linecap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_linecap(2441);

  /**
   * generated from use.counter.css.page.css_stroke_linejoin
   * Whether a page used the CSS property stroke-linejoin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_linejoin(2442);

  /**
   * generated from use.counter.css.page.css_stroke_miterlimit
   * Whether a page used the CSS property stroke-miterlimit. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_miterlimit(2443);

  /**
   * generated from use.counter.css.page.css_stroke_opacity
   * Whether a page used the CSS property stroke-opacity. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_opacity(2444);

  /**
   * generated from use.counter.css.page.css_stroke_width
   * Whether a page used the CSS property stroke-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_stroke_width(2445);

  /**
   * generated from use.counter.css.page.css_tab_size
   * Whether a page used the CSS property tab-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_tab_size(2446);

  /**
   * generated from use.counter.css.page.css_table_layout
   * Whether a page used the CSS property table-layout. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_table_layout(2447);

  /**
   * generated from use.counter.css.page.css_text_align
   * Whether a page used the CSS property text-align. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_align(2448);

  /**
   * generated from use.counter.css.page.css_text_align_last
   * Whether a page used the CSS property text-align-last. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_align_last(2449);

  /**
   * generated from use.counter.css.page.css_text_anchor
   * Whether a page used the CSS property text-anchor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_anchor(2450);

  /**
   * generated from use.counter.css.page.css_text_autospace
   * Whether a page used the CSS property text-autospace. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_autospace(2451);

  /**
   * generated from use.counter.css.page.css_text_combine_upright
   * Whether a page used the CSS property text-combine-upright. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_combine_upright(2452);

  /**
   * generated from use.counter.css.page.css_text_decoration
   * Whether a page used the CSS property text-decoration. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration(2453);

  /**
   * generated from use.counter.css.page.css_text_decoration_color
   * Whether a page used the CSS property text-decoration-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_color(2454);

  /**
   * generated from use.counter.css.page.css_text_decoration_inset
   * Whether a page used the CSS property text-decoration-inset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_inset(2455);

  /**
   * generated from use.counter.css.page.css_text_decoration_line
   * Whether a page used the CSS property text-decoration-line. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_line(2456);

  /**
   * generated from use.counter.css.page.css_text_decoration_skip_ink
   * Whether a page used the CSS property text-decoration-skip-ink. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_skip_ink(2457);

  /**
   * generated from use.counter.css.page.css_text_decoration_style
   * Whether a page used the CSS property text-decoration-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_style(2458);

  /**
   * generated from use.counter.css.page.css_text_decoration_thickness
   * Whether a page used the CSS property text-decoration-thickness. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_decoration_thickness(2459);

  /**
   * generated from use.counter.css.page.css_text_emphasis
   * Whether a page used the CSS property text-emphasis. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_emphasis(2460);

  /**
   * generated from use.counter.css.page.css_text_emphasis_color
   * Whether a page used the CSS property text-emphasis-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_emphasis_color(2461);

  /**
   * generated from use.counter.css.page.css_text_emphasis_position
   * Whether a page used the CSS property text-emphasis-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_emphasis_position(2462);

  /**
   * generated from use.counter.css.page.css_text_emphasis_style
   * Whether a page used the CSS property text-emphasis-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_emphasis_style(2463);

  /**
   * generated from use.counter.css.page.css_text_indent
   * Whether a page used the CSS property text-indent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_indent(2464);

  /**
   * generated from use.counter.css.page.css_text_justify
   * Whether a page used the CSS property text-justify. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_justify(2465);

  /**
   * generated from use.counter.css.page.css_text_orientation
   * Whether a page used the CSS property text-orientation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_orientation(2466);

  /**
   * generated from use.counter.css.page.css_text_overflow
   * Whether a page used the CSS property text-overflow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_overflow(2467);

  /**
   * generated from use.counter.css.page.css_text_rendering
   * Whether a page used the CSS property text-rendering. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_rendering(2468);

  /**
   * generated from use.counter.css.page.css_text_shadow
   * Whether a page used the CSS property text-shadow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_shadow(2469);

  /**
   * generated from use.counter.css.page.css_text_transform
   * Whether a page used the CSS property text-transform. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_transform(2470);

  /**
   * generated from use.counter.css.page.css_text_underline_offset
   * Whether a page used the CSS property text-underline-offset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_underline_offset(2471);

  /**
   * generated from use.counter.css.page.css_text_underline_position
   * Whether a page used the CSS property text-underline-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_underline_position(2472);

  /**
   * generated from use.counter.css.page.css_text_wrap
   * Whether a page used the CSS property text-wrap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_wrap(2473);

  /**
   * generated from use.counter.css.page.css_text_wrap_mode
   * Whether a page used the CSS property text-wrap-mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_wrap_mode(2474);

  /**
   * generated from use.counter.css.page.css_text_wrap_style
   * Whether a page used the CSS property text-wrap-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_text_wrap_style(2475);

  /**
   * generated from use.counter.css.page.css_top
   * Whether a page used the CSS property top. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_top(2476);

  /**
   * generated from use.counter.css.page.css_touch_action
   * Whether a page used the CSS property touch-action. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_touch_action(2477);

  /**
   * generated from use.counter.css.page.css_transform
   * Whether a page used the CSS property transform. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transform(2478);

  /**
   * generated from use.counter.css.page.css_transform_box
   * Whether a page used the CSS property transform-box. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transform_box(2479);

  /**
   * generated from use.counter.css.page.css_transform_origin
   * Whether a page used the CSS property transform-origin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transform_origin(2480);

  /**
   * generated from use.counter.css.page.css_transform_style
   * Whether a page used the CSS property transform-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transform_style(2481);

  /**
   * generated from use.counter.css.page.css_transition
   * Whether a page used the CSS property transition. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition(2482);

  /**
   * generated from use.counter.css.page.css_transition_behavior
   * Whether a page used the CSS property transition-behavior. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition_behavior(2483);

  /**
   * generated from use.counter.css.page.css_transition_delay
   * Whether a page used the CSS property transition-delay. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition_delay(2484);

  /**
   * generated from use.counter.css.page.css_transition_duration
   * Whether a page used the CSS property transition-duration. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition_duration(2485);

  /**
   * generated from use.counter.css.page.css_transition_property
   * Whether a page used the CSS property transition-property. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition_property(2486);

  /**
   * generated from use.counter.css.page.css_transition_timing_function
   * Whether a page used the CSS property transition-timing-function. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_transition_timing_function(2487);

  /**
   * generated from use.counter.css.page.css_translate
   * Whether a page used the CSS property translate. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_translate(2488);

  /**
   * generated from use.counter.css.page.css_unicode_bidi
   * Whether a page used the CSS property unicode-bidi. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_unicode_bidi(2489);

  /**
   * generated from use.counter.css.page.css_user_select
   * Whether a page used the CSS property user-select. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_user_select(2490);

  /**
   * generated from use.counter.css.page.css_vector_effect
   * Whether a page used the CSS property vector-effect. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_vector_effect(2491);

  /**
   * generated from use.counter.css.page.css_vertical_align
   * Whether a page used the CSS property vertical-align. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_vertical_align(2492);

  /**
   * generated from use.counter.css.page.css_view_timeline
   * Whether a page used the CSS property view-timeline. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_timeline(2493);

  /**
   * generated from use.counter.css.page.css_view_timeline_axis
   * Whether a page used the CSS property view-timeline-axis. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_timeline_axis(2494);

  /**
   * generated from use.counter.css.page.css_view_timeline_inset
   * Whether a page used the CSS property view-timeline-inset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_timeline_inset(2495);

  /**
   * generated from use.counter.css.page.css_view_timeline_name
   * Whether a page used the CSS property view-timeline-name. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_timeline_name(2496);

  /**
   * generated from use.counter.css.page.css_view_transition_class
   * Whether a page used the CSS property view-transition-class. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_transition_class(2497);

  /**
   * generated from use.counter.css.page.css_view_transition_name
   * Whether a page used the CSS property view-transition-name. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_view_transition_name(2498);

  /**
   * generated from use.counter.css.page.css_visibility
   * Whether a page used the CSS property visibility. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_visibility(2499);

  /**
   * generated from use.counter.css.page.css_webkit_align_content
   * Whether a page used the CSS property -webkit-align-content. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_align_content(2500);

  /**
   * generated from use.counter.css.page.css_webkit_align_items
   * Whether a page used the CSS property -webkit-align-items. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_align_items(2501);

  /**
   * generated from use.counter.css.page.css_webkit_align_self
   * Whether a page used the CSS property -webkit-align-self. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_align_self(2502);

  /**
   * generated from use.counter.css.page.css_webkit_animation
   * Whether a page used the CSS property -webkit-animation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation(2503);

  /**
   * generated from use.counter.css.page.css_webkit_animation_delay
   * Whether a page used the CSS property -webkit-animation-delay. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_delay(2504);

  /**
   * generated from use.counter.css.page.css_webkit_animation_direction
   * Whether a page used the CSS property -webkit-animation-direction. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_direction(2505);

  /**
   * generated from use.counter.css.page.css_webkit_animation_duration
   * Whether a page used the CSS property -webkit-animation-duration. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_duration(2506);

  /**
   * generated from use.counter.css.page.css_webkit_animation_fill_mode
   * Whether a page used the CSS property -webkit-animation-fill-mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_fill_mode(2507);

  /**
   * generated from use.counter.css.page.css_webkit_animation_iteration_count
   * Whether a page used the CSS property -webkit-animation-iteration-count. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_iteration_count(2508);

  /**
   * generated from use.counter.css.page.css_webkit_animation_name
   * Whether a page used the CSS property -webkit-animation-name. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_name(2509);

  /**
   * generated from use.counter.css.page.css_webkit_animation_play_state
   * Whether a page used the CSS property -webkit-animation-play-state. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_play_state(2510);

  /**
   * generated from use.counter.css.page.css_webkit_animation_timing_function
   * Whether a page used the CSS property -webkit-animation-timing-function. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_animation_timing_function(2511);

  /**
   * generated from use.counter.css.page.css_webkit_appearance
   * Whether a page used the CSS property -webkit-appearance. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_appearance(2512);

  /**
   * generated from use.counter.css.page.css_webkit_backface_visibility
   * Whether a page used the CSS property -webkit-backface-visibility. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_backface_visibility(2513);

  /**
   * generated from use.counter.css.page.css_webkit_background_clip
   * Whether a page used the CSS property -webkit-background-clip. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_background_clip(2514);

  /**
   * generated from use.counter.css.page.css_webkit_background_origin
   * Whether a page used the CSS property -webkit-background-origin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_background_origin(2515);

  /**
   * generated from use.counter.css.page.css_webkit_background_size
   * Whether a page used the CSS property -webkit-background-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_background_size(2516);

  /**
   * generated from use.counter.css.page.css_webkit_border_bottom_left_radius
   * Whether a page used the CSS property -webkit-border-bottom-left-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_bottom_left_radius(2517);

  /**
   * generated from use.counter.css.page.css_webkit_border_bottom_right_radius
   * Whether a page used the CSS property -webkit-border-bottom-right-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_bottom_right_radius(2518);

  /**
   * generated from use.counter.css.page.css_webkit_border_image
   * Whether a page used the CSS property -webkit-border-image. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_image(2519);

  /**
   * generated from use.counter.css.page.css_webkit_border_radius
   * Whether a page used the CSS property -webkit-border-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_radius(2520);

  /**
   * generated from use.counter.css.page.css_webkit_border_top_left_radius
   * Whether a page used the CSS property -webkit-border-top-left-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_top_left_radius(2521);

  /**
   * generated from use.counter.css.page.css_webkit_border_top_right_radius
   * Whether a page used the CSS property -webkit-border-top-right-radius. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_border_top_right_radius(2522);

  /**
   * generated from use.counter.css.page.css_webkit_box_align
   * Whether a page used the CSS property -webkit-box-align. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_align(2523);

  /**
   * generated from use.counter.css.page.css_webkit_box_direction
   * Whether a page used the CSS property -webkit-box-direction. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_direction(2524);

  /**
   * generated from use.counter.css.page.css_webkit_box_flex
   * Whether a page used the CSS property -webkit-box-flex. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_flex(2525);

  /**
   * generated from use.counter.css.page.css_webkit_box_ordinal_group
   * Whether a page used the CSS property -webkit-box-ordinal-group. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_ordinal_group(2526);

  /**
   * generated from use.counter.css.page.css_webkit_box_orient
   * Whether a page used the CSS property -webkit-box-orient. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_orient(2527);

  /**
   * generated from use.counter.css.page.css_webkit_box_pack
   * Whether a page used the CSS property -webkit-box-pack. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_pack(2528);

  /**
   * generated from use.counter.css.page.css_webkit_box_shadow
   * Whether a page used the CSS property -webkit-box-shadow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_shadow(2529);

  /**
   * generated from use.counter.css.page.css_webkit_box_sizing
   * Whether a page used the CSS property -webkit-box-sizing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_box_sizing(2530);

  /**
   * generated from use.counter.css.page.css_webkit_clip_path
   * Whether a page used the CSS property -webkit-clip-path. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_clip_path(2531);

  /**
   * generated from use.counter.css.page.css_webkit_filter
   * Whether a page used the CSS property -webkit-filter. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_filter(2532);

  /**
   * generated from use.counter.css.page.css_webkit_flex
   * Whether a page used the CSS property -webkit-flex. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex(2533);

  /**
   * generated from use.counter.css.page.css_webkit_flex_basis
   * Whether a page used the CSS property -webkit-flex-basis. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_basis(2534);

  /**
   * generated from use.counter.css.page.css_webkit_flex_direction
   * Whether a page used the CSS property -webkit-flex-direction. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_direction(2535);

  /**
   * generated from use.counter.css.page.css_webkit_flex_flow
   * Whether a page used the CSS property -webkit-flex-flow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_flow(2536);

  /**
   * generated from use.counter.css.page.css_webkit_flex_grow
   * Whether a page used the CSS property -webkit-flex-grow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_grow(2537);

  /**
   * generated from use.counter.css.page.css_webkit_flex_shrink
   * Whether a page used the CSS property -webkit-flex-shrink. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_shrink(2538);

  /**
   * generated from use.counter.css.page.css_webkit_flex_wrap
   * Whether a page used the CSS property -webkit-flex-wrap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_flex_wrap(2539);

  /**
   * generated from use.counter.css.page.css_webkit_font_feature_settings
   * Whether a page used the CSS property -webkit-font-feature-settings. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_font_feature_settings(2540);

  /**
   * generated from use.counter.css.page.css_webkit_font_smoothing
   * Whether a page used the CSS property -webkit-font-smoothing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_font_smoothing(2541);

  /**
   * generated from use.counter.css.page.css_webkit_justify_content
   * Whether a page used the CSS property -webkit-justify-content. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_justify_content(2542);

  /**
   * generated from use.counter.css.page.css_webkit_line_clamp
   * Whether a page used the CSS property -webkit-line-clamp. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_line_clamp(2543);

  /**
   * generated from use.counter.css.page.css_webkit_mask
   * Whether a page used the CSS property -webkit-mask. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask(2544);

  /**
   * generated from use.counter.css.page.css_webkit_mask_clip
   * Whether a page used the CSS property -webkit-mask-clip. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_clip(2545);

  /**
   * generated from use.counter.css.page.css_webkit_mask_composite
   * Whether a page used the CSS property -webkit-mask-composite. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_composite(2546);

  /**
   * generated from use.counter.css.page.css_webkit_mask_image
   * Whether a page used the CSS property -webkit-mask-image. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_image(2547);

  /**
   * generated from use.counter.css.page.css_webkit_mask_origin
   * Whether a page used the CSS property -webkit-mask-origin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_origin(2548);

  /**
   * generated from use.counter.css.page.css_webkit_mask_position
   * Whether a page used the CSS property -webkit-mask-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_position(2549);

  /**
   * generated from use.counter.css.page.css_webkit_mask_position_x
   * Whether a page used the CSS property -webkit-mask-position-x. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_position_x(2550);

  /**
   * generated from use.counter.css.page.css_webkit_mask_position_y
   * Whether a page used the CSS property -webkit-mask-position-y. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_position_y(2551);

  /**
   * generated from use.counter.css.page.css_webkit_mask_repeat
   * Whether a page used the CSS property -webkit-mask-repeat. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_repeat(2552);

  /**
   * generated from use.counter.css.page.css_webkit_mask_size
   * Whether a page used the CSS property -webkit-mask-size. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_mask_size(2553);

  /**
   * generated from use.counter.css.page.css_webkit_order
   * Whether a page used the CSS property -webkit-order. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_order(2554);

  /**
   * generated from use.counter.css.page.css_webkit_perspective
   * Whether a page used the CSS property -webkit-perspective. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_perspective(2555);

  /**
   * generated from use.counter.css.page.css_webkit_perspective_origin
   * Whether a page used the CSS property -webkit-perspective-origin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_perspective_origin(2556);

  /**
   * generated from use.counter.css.page.css_webkit_text_fill_color
   * Whether a page used the CSS property -webkit-text-fill-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_fill_color(2557);

  /**
   * generated from use.counter.css.page.css_webkit_text_security
   * Whether a page used the CSS property -webkit-text-security. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_security(2558);

  /**
   * generated from use.counter.css.page.css_webkit_text_size_adjust
   * Whether a page used the CSS property -webkit-text-size-adjust. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_size_adjust(2559);

  /**
   * generated from use.counter.css.page.css_webkit_text_stroke
   * Whether a page used the CSS property -webkit-text-stroke. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_stroke(2560);

  /**
   * generated from use.counter.css.page.css_webkit_text_stroke_color
   * Whether a page used the CSS property -webkit-text-stroke-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_stroke_color(2561);

  /**
   * generated from use.counter.css.page.css_webkit_text_stroke_width
   * Whether a page used the CSS property -webkit-text-stroke-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_text_stroke_width(2562);

  /**
   * generated from use.counter.css.page.css_webkit_transform
   * Whether a page used the CSS property -webkit-transform. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transform(2563);

  /**
   * generated from use.counter.css.page.css_webkit_transform_origin
   * Whether a page used the CSS property -webkit-transform-origin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transform_origin(2564);

  /**
   * generated from use.counter.css.page.css_webkit_transform_style
   * Whether a page used the CSS property -webkit-transform-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transform_style(2565);

  /**
   * generated from use.counter.css.page.css_webkit_transition
   * Whether a page used the CSS property -webkit-transition. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transition(2566);

  /**
   * generated from use.counter.css.page.css_webkit_transition_delay
   * Whether a page used the CSS property -webkit-transition-delay. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transition_delay(2567);

  /**
   * generated from use.counter.css.page.css_webkit_transition_duration
   * Whether a page used the CSS property -webkit-transition-duration. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transition_duration(2568);

  /**
   * generated from use.counter.css.page.css_webkit_transition_property
   * Whether a page used the CSS property -webkit-transition-property. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transition_property(2569);

  /**
   * generated from use.counter.css.page.css_webkit_transition_timing_function
   * Whether a page used the CSS property -webkit-transition-timing-function. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_transition_timing_function(2570);

  /**
   * generated from use.counter.css.page.css_webkit_user_select
   * Whether a page used the CSS property -webkit-user-select. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_webkit_user_select(2571);

  /**
   * generated from use.counter.css.page.css_white_space
   * Whether a page used the CSS property white-space. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_white_space(2572);

  /**
   * generated from use.counter.css.page.css_white_space_collapse
   * Whether a page used the CSS property white-space-collapse. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_white_space_collapse(2573);

  /**
   * generated from use.counter.css.page.css_width
   * Whether a page used the CSS property width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_width(2574);

  /**
   * generated from use.counter.css.page.css_will_change
   * Whether a page used the CSS property will-change. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_will_change(2575);

  /**
   * generated from use.counter.css.page.css_word_break
   * Whether a page used the CSS property word-break. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_word_break(2576);

  /**
   * generated from use.counter.css.page.css_word_spacing
   * Whether a page used the CSS property word-spacing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_word_spacing(2577);

  /**
   * generated from use.counter.css.page.css_word_wrap
   * Whether a page used the CSS property word-wrap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_word_wrap(2578);

  /**
   * generated from use.counter.css.page.css_writing_mode
   * Whether a page used the CSS property writing-mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_writing_mode(2579);

  /**
   * generated from use.counter.css.page.css_x
   * Whether a page used the CSS property x. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_x(2580);

  /**
   * generated from use.counter.css.page.css_x_lang
   * Whether a page used the CSS property -x-lang. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_x_lang(2581);

  /**
   * generated from use.counter.css.page.css_x_span
   * Whether a page used the CSS property -x-span. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_x_span(2582);

  /**
   * generated from use.counter.css.page.css_x_text_scale
   * Whether a page used the CSS property -x-text-scale. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_x_text_scale(2583);

  /**
   * generated from use.counter.css.page.css_y
   * Whether a page used the CSS property y. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_y(2584);

  /**
   * generated from use.counter.css.page.css_z_index
   * Whether a page used the CSS property z-index. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_z_index(2585);

  /**
   * generated from use.counter.css.page.css_zoom
   * Whether a page used the CSS property zoom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> css_zoom(2586);

  /**
   * generated from use.counter.css.page.max_zoom
   * Whether a page used the (unknown, counted) CSS property max-zoom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> max_zoom(2587);

  /**
   * generated from use.counter.css.page.min_zoom
   * Whether a page used the (unknown, counted) CSS property min-zoom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> min_zoom(2588);

  /**
   * generated from use.counter.css.page.orientation
   * Whether a page used the (unknown, counted) CSS property orientation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> orientation(2589);

  /**
   * generated from use.counter.css.page.orphans
   * Whether a page used the (unknown, counted) CSS property orphans. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> orphans(2590);

  /**
   * generated from use.counter.css.page.speak
   * Whether a page used the (unknown, counted) CSS property speak. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> speak(2591);

  /**
   * generated from use.counter.css.page.text_size_adjust
   * Whether a page used the (unknown, counted) CSS property text-size-adjust. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> text_size_adjust(2592);

  /**
   * generated from use.counter.css.page.user_zoom
   * Whether a page used the (unknown, counted) CSS property user-zoom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> user_zoom(2593);

  /**
   * generated from use.counter.css.page.webkit_app_region
   * Whether a page used the (unknown, counted) CSS property -webkit-app-region. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_app_region(2594);

  /**
   * generated from use.counter.css.page.webkit_border_after
   * Whether a page used the (unknown, counted) CSS property -webkit-border-after. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_after(2595);

  /**
   * generated from use.counter.css.page.webkit_border_after_color
   * Whether a page used the (unknown, counted) CSS property -webkit-border-after-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_after_color(2596);

  /**
   * generated from use.counter.css.page.webkit_border_after_style
   * Whether a page used the (unknown, counted) CSS property -webkit-border-after-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_after_style(2597);

  /**
   * generated from use.counter.css.page.webkit_border_after_width
   * Whether a page used the (unknown, counted) CSS property -webkit-border-after-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_after_width(2598);

  /**
   * generated from use.counter.css.page.webkit_border_before
   * Whether a page used the (unknown, counted) CSS property -webkit-border-before. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_before(2599);

  /**
   * generated from use.counter.css.page.webkit_border_before_color
   * Whether a page used the (unknown, counted) CSS property -webkit-border-before-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_before_color(2600);

  /**
   * generated from use.counter.css.page.webkit_border_before_style
   * Whether a page used the (unknown, counted) CSS property -webkit-border-before-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_before_style(2601);

  /**
   * generated from use.counter.css.page.webkit_border_before_width
   * Whether a page used the (unknown, counted) CSS property -webkit-border-before-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_before_width(2602);

  /**
   * generated from use.counter.css.page.webkit_border_end
   * Whether a page used the (unknown, counted) CSS property -webkit-border-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_end(2603);

  /**
   * generated from use.counter.css.page.webkit_border_end_color
   * Whether a page used the (unknown, counted) CSS property -webkit-border-end-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_end_color(2604);

  /**
   * generated from use.counter.css.page.webkit_border_end_style
   * Whether a page used the (unknown, counted) CSS property -webkit-border-end-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_end_style(2605);

  /**
   * generated from use.counter.css.page.webkit_border_end_width
   * Whether a page used the (unknown, counted) CSS property -webkit-border-end-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_end_width(2606);

  /**
   * generated from use.counter.css.page.webkit_border_horizontal_spacing
   * Whether a page used the (unknown, counted) CSS property -webkit-border-horizontal-spacing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_horizontal_spacing(2607);

  /**
   * generated from use.counter.css.page.webkit_border_start
   * Whether a page used the (unknown, counted) CSS property -webkit-border-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_start(2608);

  /**
   * generated from use.counter.css.page.webkit_border_start_color
   * Whether a page used the (unknown, counted) CSS property -webkit-border-start-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_start_color(2609);

  /**
   * generated from use.counter.css.page.webkit_border_start_style
   * Whether a page used the (unknown, counted) CSS property -webkit-border-start-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_start_style(2610);

  /**
   * generated from use.counter.css.page.webkit_border_start_width
   * Whether a page used the (unknown, counted) CSS property -webkit-border-start-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_start_width(2611);

  /**
   * generated from use.counter.css.page.webkit_border_vertical_spacing
   * Whether a page used the (unknown, counted) CSS property -webkit-border-vertical-spacing. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_border_vertical_spacing(2612);

  /**
   * generated from use.counter.css.page.webkit_box_decoration_break
   * Whether a page used the (unknown, counted) CSS property -webkit-box-decoration-break. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_box_decoration_break(2613);

  /**
   * generated from use.counter.css.page.webkit_box_reflect
   * Whether a page used the (unknown, counted) CSS property -webkit-box-reflect. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_box_reflect(2614);

  /**
   * generated from use.counter.css.page.webkit_column_break_after
   * Whether a page used the (unknown, counted) CSS property -webkit-column-break-after. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_break_after(2615);

  /**
   * generated from use.counter.css.page.webkit_column_break_before
   * Whether a page used the (unknown, counted) CSS property -webkit-column-break-before. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_break_before(2616);

  /**
   * generated from use.counter.css.page.webkit_column_break_inside
   * Whether a page used the (unknown, counted) CSS property -webkit-column-break-inside. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_break_inside(2617);

  /**
   * generated from use.counter.css.page.webkit_column_count
   * Whether a page used the (unknown, counted) CSS property -webkit-column-count. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_count(2618);

  /**
   * generated from use.counter.css.page.webkit_column_gap
   * Whether a page used the (unknown, counted) CSS property -webkit-column-gap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_gap(2619);

  /**
   * generated from use.counter.css.page.webkit_column_rule
   * Whether a page used the (unknown, counted) CSS property -webkit-column-rule. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_rule(2620);

  /**
   * generated from use.counter.css.page.webkit_column_rule_color
   * Whether a page used the (unknown, counted) CSS property -webkit-column-rule-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_rule_color(2621);

  /**
   * generated from use.counter.css.page.webkit_column_rule_style
   * Whether a page used the (unknown, counted) CSS property -webkit-column-rule-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_rule_style(2622);

  /**
   * generated from use.counter.css.page.webkit_column_rule_width
   * Whether a page used the (unknown, counted) CSS property -webkit-column-rule-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_rule_width(2623);

  /**
   * generated from use.counter.css.page.webkit_column_span
   * Whether a page used the (unknown, counted) CSS property -webkit-column-span. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_span(2624);

  /**
   * generated from use.counter.css.page.webkit_column_width
   * Whether a page used the (unknown, counted) CSS property -webkit-column-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_column_width(2625);

  /**
   * generated from use.counter.css.page.webkit_columns
   * Whether a page used the (unknown, counted) CSS property -webkit-columns. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_columns(2626);

  /**
   * generated from use.counter.css.page.webkit_font_size_delta
   * Whether a page used the (unknown, counted) CSS property -webkit-font-size-delta. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_font_size_delta(2627);

  /**
   * generated from use.counter.css.page.webkit_highlight
   * Whether a page used the (unknown, counted) CSS property -webkit-highlight. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_highlight(2628);

  /**
   * generated from use.counter.css.page.webkit_hyphenate_character
   * Whether a page used the (unknown, counted) CSS property -webkit-hyphenate-character. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_hyphenate_character(2629);

  /**
   * generated from use.counter.css.page.webkit_line_break
   * Whether a page used the (unknown, counted) CSS property -webkit-line-break. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_line_break(2630);

  /**
   * generated from use.counter.css.page.webkit_locale
   * Whether a page used the (unknown, counted) CSS property -webkit-locale. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_locale(2631);

  /**
   * generated from use.counter.css.page.webkit_logical_height
   * Whether a page used the (unknown, counted) CSS property -webkit-logical-height. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_logical_height(2632);

  /**
   * generated from use.counter.css.page.webkit_logical_width
   * Whether a page used the (unknown, counted) CSS property -webkit-logical-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_logical_width(2633);

  /**
   * generated from use.counter.css.page.webkit_margin_after
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-after. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_after(2634);

  /**
   * generated from use.counter.css.page.webkit_margin_after_collapse
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-after-collapse. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_after_collapse(2635);

  /**
   * generated from use.counter.css.page.webkit_margin_before
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-before. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_before(2636);

  /**
   * generated from use.counter.css.page.webkit_margin_before_collapse
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-before-collapse. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_before_collapse(2637);

  /**
   * generated from use.counter.css.page.webkit_margin_bottom_collapse
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-bottom-collapse. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_bottom_collapse(2638);

  /**
   * generated from use.counter.css.page.webkit_margin_collapse
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-collapse. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_collapse(2639);

  /**
   * generated from use.counter.css.page.webkit_margin_end
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_end(2640);

  /**
   * generated from use.counter.css.page.webkit_margin_start
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_start(2641);

  /**
   * generated from use.counter.css.page.webkit_margin_top_collapse
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-top-collapse. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_margin_top_collapse(2642);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image(2643);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image_outset
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image-outset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image_outset(2644);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image_repeat
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image-repeat. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image_repeat(2645);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image_slice
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image-slice. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image_slice(2646);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image_source
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image-source. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image_source(2647);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image_width
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_box_image_width(2648);

  /**
   * generated from use.counter.css.page.webkit_mask_repeat_x
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-repeat-x. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_repeat_x(2649);

  /**
   * generated from use.counter.css.page.webkit_mask_repeat_y
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-repeat-y. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_mask_repeat_y(2650);

  /**
   * generated from use.counter.css.page.webkit_max_logical_height
   * Whether a page used the (unknown, counted) CSS property -webkit-max-logical-height. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_max_logical_height(2651);

  /**
   * generated from use.counter.css.page.webkit_max_logical_width
   * Whether a page used the (unknown, counted) CSS property -webkit-max-logical-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_max_logical_width(2652);

  /**
   * generated from use.counter.css.page.webkit_min_logical_height
   * Whether a page used the (unknown, counted) CSS property -webkit-min-logical-height. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_min_logical_height(2653);

  /**
   * generated from use.counter.css.page.webkit_min_logical_width
   * Whether a page used the (unknown, counted) CSS property -webkit-min-logical-width. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_min_logical_width(2654);

  /**
   * generated from use.counter.css.page.webkit_opacity
   * Whether a page used the (unknown, counted) CSS property -webkit-opacity. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_opacity(2655);

  /**
   * generated from use.counter.css.page.webkit_padding_after
   * Whether a page used the (unknown, counted) CSS property -webkit-padding-after. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_padding_after(2656);

  /**
   * generated from use.counter.css.page.webkit_padding_before
   * Whether a page used the (unknown, counted) CSS property -webkit-padding-before. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_padding_before(2657);

  /**
   * generated from use.counter.css.page.webkit_padding_end
   * Whether a page used the (unknown, counted) CSS property -webkit-padding-end. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_padding_end(2658);

  /**
   * generated from use.counter.css.page.webkit_padding_start
   * Whether a page used the (unknown, counted) CSS property -webkit-padding-start. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_padding_start(2659);

  /**
   * generated from use.counter.css.page.webkit_perspective_origin_x
   * Whether a page used the (unknown, counted) CSS property -webkit-perspective-origin-x. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_perspective_origin_x(2660);

  /**
   * generated from use.counter.css.page.webkit_perspective_origin_y
   * Whether a page used the (unknown, counted) CSS property -webkit-perspective-origin-y. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_perspective_origin_y(2661);

  /**
   * generated from use.counter.css.page.webkit_print_color_adjust
   * Whether a page used the (unknown, counted) CSS property -webkit-print-color-adjust. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_print_color_adjust(2662);

  /**
   * generated from use.counter.css.page.webkit_rtl_ordering
   * Whether a page used the (unknown, counted) CSS property -webkit-rtl-ordering. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_rtl_ordering(2663);

  /**
   * generated from use.counter.css.page.webkit_ruby_position
   * Whether a page used the (unknown, counted) CSS property -webkit-ruby-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_ruby_position(2664);

  /**
   * generated from use.counter.css.page.webkit_shape_image_threshold
   * Whether a page used the (unknown, counted) CSS property -webkit-shape-image-threshold. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_shape_image_threshold(2665);

  /**
   * generated from use.counter.css.page.webkit_shape_margin
   * Whether a page used the (unknown, counted) CSS property -webkit-shape-margin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_shape_margin(2666);

  /**
   * generated from use.counter.css.page.webkit_shape_outside
   * Whether a page used the (unknown, counted) CSS property -webkit-shape-outside. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_shape_outside(2667);

  /**
   * generated from use.counter.css.page.webkit_tap_highlight_color
   * Whether a page used the (unknown, counted) CSS property -webkit-tap-highlight-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_tap_highlight_color(2668);

  /**
   * generated from use.counter.css.page.webkit_text_combine
   * Whether a page used the (unknown, counted) CSS property -webkit-text-combine. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_combine(2669);

  /**
   * generated from use.counter.css.page.webkit_text_decorations_in_effect
   * Whether a page used the (unknown, counted) CSS property -webkit-text-decorations-in-effect. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_decorations_in_effect(2670);

  /**
   * generated from use.counter.css.page.webkit_text_emphasis
   * Whether a page used the (unknown, counted) CSS property -webkit-text-emphasis. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_emphasis(2671);

  /**
   * generated from use.counter.css.page.webkit_text_emphasis_color
   * Whether a page used the (unknown, counted) CSS property -webkit-text-emphasis-color. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_emphasis_color(2672);

  /**
   * generated from use.counter.css.page.webkit_text_emphasis_position
   * Whether a page used the (unknown, counted) CSS property -webkit-text-emphasis-position. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_emphasis_position(2673);

  /**
   * generated from use.counter.css.page.webkit_text_emphasis_style
   * Whether a page used the (unknown, counted) CSS property -webkit-text-emphasis-style. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_emphasis_style(2674);

  /**
   * generated from use.counter.css.page.webkit_text_orientation
   * Whether a page used the (unknown, counted) CSS property -webkit-text-orientation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_text_orientation(2675);

  /**
   * generated from use.counter.css.page.webkit_transform_origin_x
   * Whether a page used the (unknown, counted) CSS property -webkit-transform-origin-x. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_transform_origin_x(2676);

  /**
   * generated from use.counter.css.page.webkit_transform_origin_y
   * Whether a page used the (unknown, counted) CSS property -webkit-transform-origin-y. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_transform_origin_y(2677);

  /**
   * generated from use.counter.css.page.webkit_transform_origin_z
   * Whether a page used the (unknown, counted) CSS property -webkit-transform-origin-z. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_transform_origin_z(2678);

  /**
   * generated from use.counter.css.page.webkit_user_drag
   * Whether a page used the (unknown, counted) CSS property -webkit-user-drag. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_user_drag(2679);

  /**
   * generated from use.counter.css.page.webkit_user_modify
   * Whether a page used the (unknown, counted) CSS property -webkit-user-modify. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_user_modify(2680);

  /**
   * generated from use.counter.css.page.webkit_writing_mode
   * Whether a page used the (unknown, counted) CSS property -webkit-writing-mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webkit_writing_mode(2681);

  /**
   * generated from use.counter.css.page.widows
   * Whether a page used the (unknown, counted) CSS property widows. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> widows(2682);
}

namespace use_counter_deprecated_ops_doc {
  /**
   * generated from use.counter.deprecated_ops.doc.ambient_light_event
   * Whether a document used AmbientLightEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ambient_light_event(2683);

  /**
   * generated from use.counter.deprecated_ops.doc.app_cache
   * Whether a document used AppCache. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> app_cache(2684);

  /**
   * generated from use.counter.deprecated_ops.doc.ckeditor4_compat_hack
   * Whether a document used CKEditor4CompatHack. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ckeditor4_compat_hack(2685);

  /**
   * generated from use.counter.deprecated_ops.doc.components
   * Whether a document used Components. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> components(2686);

  /**
   * generated from use.counter.deprecated_ops.doc.create_image_bitmap_canvas_rendering_context2_d
   * Whether a document used CreateImageBitmapCanvasRenderingContext2D. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> create_image_bitmap_canvas_rendering_context2_d(2687);

  /**
   * generated from use.counter.deprecated_ops.doc.deprecated_testing_attribute
   * Whether a document used DeprecatedTestingAttribute. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> deprecated_testing_attribute(2688);

  /**
   * generated from use.counter.deprecated_ops.doc.deprecated_testing_interface
   * Whether a document used DeprecatedTestingInterface. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> deprecated_testing_interface(2689);

  /**
   * generated from use.counter.deprecated_ops.doc.deprecated_testing_method
   * Whether a document used DeprecatedTestingMethod. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> deprecated_testing_method(2690);

  /**
   * generated from use.counter.deprecated_ops.doc.document_release_capture
   * Whether a document used DocumentReleaseCapture. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_release_capture(2691);

  /**
   * generated from use.counter.deprecated_ops.doc.domquad_bounds_attr
   * Whether a document used DOMQuadBoundsAttr. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> domquad_bounds_attr(2692);

  /**
   * generated from use.counter.deprecated_ops.doc.draw_window_canvas_rendering_context2_d
   * Whether a document used DrawWindowCanvasRenderingContext2D. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> draw_window_canvas_rendering_context2_d(2693);

  /**
   * generated from use.counter.deprecated_ops.doc.element_release_capture
   * Whether a document used ElementReleaseCapture. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_release_capture(2694);

  /**
   * generated from use.counter.deprecated_ops.doc.element_set_capture
   * Whether a document used ElementSetCapture. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_set_capture(2695);

  /**
   * generated from use.counter.deprecated_ops.doc.external__add_search_provider
   * Whether a document used External_AddSearchProvider. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> external__add_search_provider(2696);

  /**
   * generated from use.counter.deprecated_ops.doc.form_submission_untrusted_event
   * Whether a document used FormSubmissionUntrustedEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> form_submission_untrusted_event(2697);

  /**
   * generated from use.counter.deprecated_ops.doc.fullscreen_attribute
   * Whether a document used FullscreenAttribute. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fullscreen_attribute(2698);

  /**
   * generated from use.counter.deprecated_ops.doc.idbobject_store_create_index_locale
   * Whether a document used IDBObjectStoreCreateIndexLocale. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> idbobject_store_create_index_locale(2699);

  /**
   * generated from use.counter.deprecated_ops.doc.idbopen_dboptions__storage_type
   * Whether a document used IDBOpenDBOptions_StorageType. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> idbopen_dboptions__storage_type(2700);

  /**
   * generated from use.counter.deprecated_ops.doc.image_bitmap_rendering_context__transfer_image_bitmap
   * Whether a document used ImageBitmapRenderingContext_TransferImageBitmap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> image_bitmap_rendering_context__transfer_image_bitmap(2701);

  /**
   * generated from use.counter.deprecated_ops.doc.import_xulinto_content
   * Whether a document used ImportXULIntoContent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> import_xulinto_content(2702);

  /**
   * generated from use.counter.deprecated_ops.doc.init_mouse_event
   * Whether a document used InitMouseEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> init_mouse_event(2703);

  /**
   * generated from use.counter.deprecated_ops.doc.init_nsmouse_event
   * Whether a document used InitNSMouseEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> init_nsmouse_event(2704);

  /**
   * generated from use.counter.deprecated_ops.doc.install_trigger_deprecated
   * Whether a document used InstallTriggerDeprecated. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> install_trigger_deprecated(2705);

  /**
   * generated from use.counter.deprecated_ops.doc.lenient_setter
   * Whether a document used LenientSetter. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> lenient_setter(2706);

  /**
   * generated from use.counter.deprecated_ops.doc.lenient_this
   * Whether a document used LenientThis. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> lenient_this(2707);

  /**
   * generated from use.counter.deprecated_ops.doc.math_ml__deprecated_math_space_value2
   * Whether a document used MathML_DeprecatedMathSpaceValue2. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_ml__deprecated_math_space_value2(2708);

  /**
   * generated from use.counter.deprecated_ops.doc.math_ml__deprecated_math_variant
   * Whether a document used MathML_DeprecatedMathVariant. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_ml__deprecated_math_variant(2709);

  /**
   * generated from use.counter.deprecated_ops.doc.math_ml__deprecated_mo_explicit_accent
   * Whether a document used MathML_DeprecatedMoExplicitAccent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_ml__deprecated_mo_explicit_accent(2710);

  /**
   * generated from use.counter.deprecated_ops.doc.math_ml__deprecated_mover_non_explicit_accent
   * Whether a document used MathML_DeprecatedMoverNonExplicitAccent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_ml__deprecated_mover_non_explicit_accent(2711);

  /**
   * generated from use.counter.deprecated_ops.doc.math_ml__deprecated_munder_non_explicit_accentunder
   * Whether a document used MathML_DeprecatedMunderNonExplicitAccentunder. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_ml__deprecated_munder_non_explicit_accentunder(2712);

  /**
   * generated from use.counter.deprecated_ops.doc.motion_event
   * Whether a document used MotionEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> motion_event(2713);

  /**
   * generated from use.counter.deprecated_ops.doc.mouse_event__moz_pressure
   * Whether a document used MouseEvent_MozPressure. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mouse_event__moz_pressure(2714);

  /**
   * generated from use.counter.deprecated_ops.doc.moz_input_source
   * Whether a document used MozInputSource. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> moz_input_source(2715);

  /**
   * generated from use.counter.deprecated_ops.doc.moz_request_full_screen_deprecated_prefix
   * Whether a document used MozRequestFullScreenDeprecatedPrefix. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> moz_request_full_screen_deprecated_prefix(2716);

  /**
   * generated from use.counter.deprecated_ops.doc.mozfullscreenchange_deprecated_prefix
   * Whether a document used MozfullscreenchangeDeprecatedPrefix. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozfullscreenchange_deprecated_prefix(2717);

  /**
   * generated from use.counter.deprecated_ops.doc.mozfullscreenerror_deprecated_prefix
   * Whether a document used MozfullscreenerrorDeprecatedPrefix. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozfullscreenerror_deprecated_prefix(2718);

  /**
   * generated from use.counter.deprecated_ops.doc.mozlockorientation_deprecated
   * Whether a document used MozlockorientationDeprecated. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozlockorientation_deprecated(2719);

  /**
   * generated from use.counter.deprecated_ops.doc.mozorientation_deprecated
   * Whether a document used MozorientationDeprecated. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozorientation_deprecated(2720);

  /**
   * generated from use.counter.deprecated_ops.doc.mozorientationchange_deprecated
   * Whether a document used MozorientationchangeDeprecated. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozorientationchange_deprecated(2721);

  /**
   * generated from use.counter.deprecated_ops.doc.mozunlockorientation_deprecated
   * Whether a document used MozunlockorientationDeprecated. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozunlockorientation_deprecated(2722);

  /**
   * generated from use.counter.deprecated_ops.doc.navigator_get_user_media
   * Whether a document used NavigatorGetUserMedia. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> navigator_get_user_media(2723);

  /**
   * generated from use.counter.deprecated_ops.doc.node_iterator_detach
   * Whether a document used NodeIteratorDetach. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> node_iterator_detach(2724);

  /**
   * generated from use.counter.deprecated_ops.doc.offscreen_canvas_to_blob
   * Whether a document used OffscreenCanvasToBlob. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> offscreen_canvas_to_blob(2725);

  /**
   * generated from use.counter.deprecated_ops.doc.orientation_event
   * Whether a document used OrientationEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> orientation_event(2726);

  /**
   * generated from use.counter.deprecated_ops.doc.proximity_event
   * Whether a document used ProximityEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> proximity_event(2727);

  /**
   * generated from use.counter.deprecated_ops.doc.rtcpeer_connection_get_streams
   * Whether a document used RTCPeerConnectionGetStreams. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> rtcpeer_connection_get_streams(2728);

  /**
   * generated from use.counter.deprecated_ops.doc.svgdeselect_all
   * Whether a document used SVGDeselectAll. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> svgdeselect_all(2729);

  /**
   * generated from use.counter.deprecated_ops.doc.sync_xmlhttp_request_deprecated
   * Whether a document used SyncXMLHttpRequestDeprecated. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> sync_xmlhttp_request_deprecated(2730);

  /**
   * generated from use.counter.deprecated_ops.doc.use_of_capture_events
   * Whether a document used UseOfCaptureEvents. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> use_of_capture_events(2731);

  /**
   * generated from use.counter.deprecated_ops.doc.use_of_release_events
   * Whether a document used UseOfReleaseEvents. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> use_of_release_events(2732);

  /**
   * generated from use.counter.deprecated_ops.doc.webrtc_deprecated_prefix
   * Whether a document used WebrtcDeprecatedPrefix. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webrtc_deprecated_prefix(2733);

  /**
   * generated from use.counter.deprecated_ops.doc.window__cc_ontrollers
   * Whether a document used Window_Cc_ontrollers. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window__cc_ontrollers(2734);

  /**
   * generated from use.counter.deprecated_ops.doc.window_content_untrusted
   * Whether a document used WindowContentUntrusted. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_content_untrusted(2735);

  /**
   * generated from use.counter.deprecated_ops.doc.xsltdeprecated
   * Whether a document used XSLTDeprecated. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> xsltdeprecated(2736);
}

namespace use_counter_deprecated_ops_page {
  /**
   * generated from use.counter.deprecated_ops.page.ambient_light_event
   * Whether a page used AmbientLightEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ambient_light_event(2737);

  /**
   * generated from use.counter.deprecated_ops.page.app_cache
   * Whether a page used AppCache. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> app_cache(2738);

  /**
   * generated from use.counter.deprecated_ops.page.ckeditor4_compat_hack
   * Whether a page used CKEditor4CompatHack. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ckeditor4_compat_hack(2739);

  /**
   * generated from use.counter.deprecated_ops.page.components
   * Whether a page used Components. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> components(2740);

  /**
   * generated from use.counter.deprecated_ops.page.create_image_bitmap_canvas_rendering_context2_d
   * Whether a page used CreateImageBitmapCanvasRenderingContext2D. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> create_image_bitmap_canvas_rendering_context2_d(2741);

  /**
   * generated from use.counter.deprecated_ops.page.deprecated_testing_attribute
   * Whether a page used DeprecatedTestingAttribute. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> deprecated_testing_attribute(2742);

  /**
   * generated from use.counter.deprecated_ops.page.deprecated_testing_interface
   * Whether a page used DeprecatedTestingInterface. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> deprecated_testing_interface(2743);

  /**
   * generated from use.counter.deprecated_ops.page.deprecated_testing_method
   * Whether a page used DeprecatedTestingMethod. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> deprecated_testing_method(2744);

  /**
   * generated from use.counter.deprecated_ops.page.document_release_capture
   * Whether a page used DocumentReleaseCapture. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_release_capture(2745);

  /**
   * generated from use.counter.deprecated_ops.page.domquad_bounds_attr
   * Whether a page used DOMQuadBoundsAttr. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> domquad_bounds_attr(2746);

  /**
   * generated from use.counter.deprecated_ops.page.draw_window_canvas_rendering_context2_d
   * Whether a page used DrawWindowCanvasRenderingContext2D. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> draw_window_canvas_rendering_context2_d(2747);

  /**
   * generated from use.counter.deprecated_ops.page.element_release_capture
   * Whether a page used ElementReleaseCapture. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_release_capture(2748);

  /**
   * generated from use.counter.deprecated_ops.page.element_set_capture
   * Whether a page used ElementSetCapture. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_set_capture(2749);

  /**
   * generated from use.counter.deprecated_ops.page.external__add_search_provider
   * Whether a page used External_AddSearchProvider. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> external__add_search_provider(2750);

  /**
   * generated from use.counter.deprecated_ops.page.form_submission_untrusted_event
   * Whether a page used FormSubmissionUntrustedEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> form_submission_untrusted_event(2751);

  /**
   * generated from use.counter.deprecated_ops.page.fullscreen_attribute
   * Whether a page used FullscreenAttribute. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fullscreen_attribute(2752);

  /**
   * generated from use.counter.deprecated_ops.page.idbobject_store_create_index_locale
   * Whether a page used IDBObjectStoreCreateIndexLocale. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> idbobject_store_create_index_locale(2753);

  /**
   * generated from use.counter.deprecated_ops.page.idbopen_dboptions__storage_type
   * Whether a page used IDBOpenDBOptions_StorageType. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> idbopen_dboptions__storage_type(2754);

  /**
   * generated from use.counter.deprecated_ops.page.image_bitmap_rendering_context__transfer_image_bitmap
   * Whether a page used ImageBitmapRenderingContext_TransferImageBitmap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> image_bitmap_rendering_context__transfer_image_bitmap(2755);

  /**
   * generated from use.counter.deprecated_ops.page.import_xulinto_content
   * Whether a page used ImportXULIntoContent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> import_xulinto_content(2756);

  /**
   * generated from use.counter.deprecated_ops.page.init_mouse_event
   * Whether a page used InitMouseEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> init_mouse_event(2757);

  /**
   * generated from use.counter.deprecated_ops.page.init_nsmouse_event
   * Whether a page used InitNSMouseEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> init_nsmouse_event(2758);

  /**
   * generated from use.counter.deprecated_ops.page.install_trigger_deprecated
   * Whether a page used InstallTriggerDeprecated. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> install_trigger_deprecated(2759);

  /**
   * generated from use.counter.deprecated_ops.page.lenient_setter
   * Whether a page used LenientSetter. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> lenient_setter(2760);

  /**
   * generated from use.counter.deprecated_ops.page.lenient_this
   * Whether a page used LenientThis. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> lenient_this(2761);

  /**
   * generated from use.counter.deprecated_ops.page.math_ml__deprecated_math_space_value2
   * Whether a page used MathML_DeprecatedMathSpaceValue2. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_ml__deprecated_math_space_value2(2762);

  /**
   * generated from use.counter.deprecated_ops.page.math_ml__deprecated_math_variant
   * Whether a page used MathML_DeprecatedMathVariant. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_ml__deprecated_math_variant(2763);

  /**
   * generated from use.counter.deprecated_ops.page.math_ml__deprecated_mo_explicit_accent
   * Whether a page used MathML_DeprecatedMoExplicitAccent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_ml__deprecated_mo_explicit_accent(2764);

  /**
   * generated from use.counter.deprecated_ops.page.math_ml__deprecated_mover_non_explicit_accent
   * Whether a page used MathML_DeprecatedMoverNonExplicitAccent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_ml__deprecated_mover_non_explicit_accent(2765);

  /**
   * generated from use.counter.deprecated_ops.page.math_ml__deprecated_munder_non_explicit_accentunder
   * Whether a page used MathML_DeprecatedMunderNonExplicitAccentunder. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_ml__deprecated_munder_non_explicit_accentunder(2766);

  /**
   * generated from use.counter.deprecated_ops.page.motion_event
   * Whether a page used MotionEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> motion_event(2767);

  /**
   * generated from use.counter.deprecated_ops.page.mouse_event__moz_pressure
   * Whether a page used MouseEvent_MozPressure. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mouse_event__moz_pressure(2768);

  /**
   * generated from use.counter.deprecated_ops.page.moz_input_source
   * Whether a page used MozInputSource. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> moz_input_source(2769);

  /**
   * generated from use.counter.deprecated_ops.page.moz_request_full_screen_deprecated_prefix
   * Whether a page used MozRequestFullScreenDeprecatedPrefix. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> moz_request_full_screen_deprecated_prefix(2770);

  /**
   * generated from use.counter.deprecated_ops.page.mozfullscreenchange_deprecated_prefix
   * Whether a page used MozfullscreenchangeDeprecatedPrefix. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozfullscreenchange_deprecated_prefix(2771);

  /**
   * generated from use.counter.deprecated_ops.page.mozfullscreenerror_deprecated_prefix
   * Whether a page used MozfullscreenerrorDeprecatedPrefix. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozfullscreenerror_deprecated_prefix(2772);

  /**
   * generated from use.counter.deprecated_ops.page.mozlockorientation_deprecated
   * Whether a page used MozlockorientationDeprecated. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozlockorientation_deprecated(2773);

  /**
   * generated from use.counter.deprecated_ops.page.mozorientation_deprecated
   * Whether a page used Mozorientationdeprecated. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozorientation_deprecated(2774);

  /**
   * generated from use.counter.deprecated_ops.page.mozorientationchange_deprecated
   * Whether a page used MozorientationchangeDeprecated. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozorientationchange_deprecated(2775);

  /**
   * generated from use.counter.deprecated_ops.page.mozunlockorientation_deprecated
   * Whether a page used MozunlockorientationDeprecated. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mozunlockorientation_deprecated(2776);

  /**
   * generated from use.counter.deprecated_ops.page.navigator_get_user_media
   * Whether a page used NavigatorGetUserMedia. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> navigator_get_user_media(2777);

  /**
   * generated from use.counter.deprecated_ops.page.node_iterator_detach
   * Whether a page used NodeIteratorDetach. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> node_iterator_detach(2778);

  /**
   * generated from use.counter.deprecated_ops.page.offscreen_canvas_to_blob
   * Whether a page used OffscreenCanvasToBlob. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> offscreen_canvas_to_blob(2779);

  /**
   * generated from use.counter.deprecated_ops.page.orientation_event
   * Whether a page used OrientationEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> orientation_event(2780);

  /**
   * generated from use.counter.deprecated_ops.page.proximity_event
   * Whether a page used ProximityEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> proximity_event(2781);

  /**
   * generated from use.counter.deprecated_ops.page.rtcpeer_connection_get_streams
   * Whether a page used RTCPeerConnectionGetStreams. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> rtcpeer_connection_get_streams(2782);

  /**
   * generated from use.counter.deprecated_ops.page.svgdeselect_all
   * Whether a page used SVGDeselectAll. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> svgdeselect_all(2783);

  /**
   * generated from use.counter.deprecated_ops.page.sync_xmlhttp_request_deprecated
   * Whether a page used SyncXMLHttpRequestDeprecated. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> sync_xmlhttp_request_deprecated(2784);

  /**
   * generated from use.counter.deprecated_ops.page.use_of_capture_events
   * Whether a page used UseOfCaptureEvents. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> use_of_capture_events(2785);

  /**
   * generated from use.counter.deprecated_ops.page.use_of_release_events
   * Whether a page used UseOfReleaseEvents. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> use_of_release_events(2786);

  /**
   * generated from use.counter.deprecated_ops.page.webrtc_deprecated_prefix
   * Whether a page used WebrtcDeprecatedPrefix. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webrtc_deprecated_prefix(2787);

  /**
   * generated from use.counter.deprecated_ops.page.window__cc_ontrollers
   * Whether a page used Window_Cc_ontrollers. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window__cc_ontrollers(2788);

  /**
   * generated from use.counter.deprecated_ops.page.window_content_untrusted
   * Whether a page used WindowContentUntrusted. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_content_untrusted(2789);

  /**
   * generated from use.counter.deprecated_ops.page.xsltdeprecated
   * Whether a page used XSLTDeprecated. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> xsltdeprecated(2790);
}

namespace use_counter_doc {
  /**
   * generated from use.counter.doc.components_shim_resolved
   * Whether a document resolves the components shim.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> components_shim_resolved(2791);

  /**
   * generated from use.counter.doc.console_assert
   * Whether a document called called console.assert. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_assert(2792);

  /**
   * generated from use.counter.doc.console_clear
   * Whether a document called called console.clear. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_clear(2793);

  /**
   * generated from use.counter.doc.console_count
   * Whether a document called called console.count. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_count(2794);

  /**
   * generated from use.counter.doc.console_countreset
   * Whether a document called called console.countReset. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_countreset(2795);

  /**
   * generated from use.counter.doc.console_debug
   * Whether a document called called console.debug. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_debug(2796);

  /**
   * generated from use.counter.doc.console_dir
   * Whether a document called called console.dir. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_dir(2797);

  /**
   * generated from use.counter.doc.console_dirxml
   * Whether a document called called console.dirxml. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_dirxml(2798);

  /**
   * generated from use.counter.doc.console_error
   * Whether a document called called console.error. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_error(2799);

  /**
   * generated from use.counter.doc.console_exception
   * Whether a document called called console.exception. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_exception(2800);

  /**
   * generated from use.counter.doc.console_group
   * Whether a document called called console.group. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_group(2801);

  /**
   * generated from use.counter.doc.console_groupcollapsed
   * Whether a document called called console.groupCollapsed. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_groupcollapsed(2802);

  /**
   * generated from use.counter.doc.console_groupend
   * Whether a document called called console.groupEnd. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_groupend(2803);

  /**
   * generated from use.counter.doc.console_info
   * Whether a document called called console.info. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_info(2804);

  /**
   * generated from use.counter.doc.console_log
   * Whether a document called called console.log. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_log(2805);

  /**
   * generated from use.counter.doc.console_profile
   * Whether a document called called console.profile. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_profile(2806);

  /**
   * generated from use.counter.doc.console_profileend
   * Whether a document called called console.profileEnd. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_profileend(2807);

  /**
   * generated from use.counter.doc.console_table
   * Whether a document called called console.table. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_table(2808);

  /**
   * generated from use.counter.doc.console_time
   * Whether a document called called console.time. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_time(2809);

  /**
   * generated from use.counter.doc.console_timeend
   * Whether a document called called console.timeEnd. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timeend(2810);

  /**
   * generated from use.counter.doc.console_timelog
   * Whether a document called called console.timeLog. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timelog(2811);

  /**
   * generated from use.counter.doc.console_timestamp
   * Whether a document called called console.timeStamp. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timestamp(2812);

  /**
   * generated from use.counter.doc.console_trace
   * Whether a document called called console.trace. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_trace(2813);

  /**
   * generated from use.counter.doc.console_warn
   * Whether a document called called console.warn. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_warn(2814);

  /**
   * generated from use.counter.doc.cookiestore_delete
   * Whether a document called called CookieStore.delete. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_delete(2815);

  /**
   * generated from use.counter.doc.cookiestore_get
   * Whether a document called called CookieStore.get. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_get(2816);

  /**
   * generated from use.counter.doc.cookiestore_getall
   * Whether a document called called CookieStore.getAll. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_getall(2817);

  /**
   * generated from use.counter.doc.cookiestore_set
   * Whether a document called called CookieStore.set. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_set(2818);

  /**
   * generated from use.counter.doc.customelementregistry_define
   * Whether a document called called CustomElementRegistry.define. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> customelementregistry_define(2819);

  /**
   * generated from use.counter.doc.customized_builtin
   * Whether a document registers a customized built-in element. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> customized_builtin(2820);

  /**
   * generated from use.counter.doc.datatransfer_addelement
   * Whether a document called called DataTransfer.addElement. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_addelement(2821);

  /**
   * generated from use.counter.doc.datatransfer_mozcleardataat
   * Whether a document called called DataTransfer.mozClearDataAt. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozcleardataat(2822);

  /**
   * generated from use.counter.doc.datatransfer_mozcursor_getter
   * Whether a document got DataTransfer.mozCursor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozcursor_getter(2823);

  /**
   * generated from use.counter.doc.datatransfer_mozcursor_setter
   * Whether a document set DataTransfer.mozCursor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozcursor_setter(2824);

  /**
   * generated from use.counter.doc.datatransfer_mozgetdataat
   * Whether a document called called DataTransfer.mozGetDataAt. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozgetdataat(2825);

  /**
   * generated from use.counter.doc.datatransfer_mozitemcount_getter
   * Whether a document got DataTransfer.mozItemCount. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozitemcount_getter(2826);

  /**
   * generated from use.counter.doc.datatransfer_mozitemcount_setter
   * Whether a document set DataTransfer.mozItemCount. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozitemcount_setter(2827);

  /**
   * generated from use.counter.doc.datatransfer_mozsetdataat
   * Whether a document called called DataTransfer.mozSetDataAt. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozsetdataat(2828);

  /**
   * generated from use.counter.doc.datatransfer_mozsourcenode_getter
   * Whether a document got DataTransfer.mozSourceNode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozsourcenode_getter(2829);

  /**
   * generated from use.counter.doc.datatransfer_mozsourcenode_setter
   * Whether a document set DataTransfer.mozSourceNode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozsourcenode_setter(2830);

  /**
   * generated from use.counter.doc.datatransfer_moztypesat
   * Whether a document called called DataTransfer.mozTypesAt. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_moztypesat(2831);

  /**
   * generated from use.counter.doc.datatransfer_mozusercancelled_getter
   * Whether a document got DataTransfer.mozUserCancelled. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozusercancelled_getter(2832);

  /**
   * generated from use.counter.doc.datatransfer_mozusercancelled_setter
   * Whether a document set DataTransfer.mozUserCancelled. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozusercancelled_setter(2833);

  /**
   * generated from use.counter.doc.document_exec_command_content_read_only
   * Whether a document calls execCommand with contentReadOnly. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_exec_command_content_read_only(2834);

  /**
   * generated from use.counter.doc.document_mozsetimageelement
   * Whether a document called called Document.mozSetImageElement. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_mozsetimageelement(2835);

  /**
   * generated from use.counter.doc.document_open
   * Whether a document calls document.open in a way that creates a new Window object. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_open(2836);

  /**
   * generated from use.counter.doc.document_query_command_state_or_value_content_read_only
   * Whether a document calls queryCommandState or queryCommandValue with contentReadOnly. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_query_command_state_or_value_content_read_only(2837);

  /**
   * generated from use.counter.doc.document_query_command_state_or_value_insert_br_on_return
   * Whether a document calls queryCommandState or queryCommandValue with insertBrOnReturn. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_query_command_state_or_value_insert_br_on_return(2838);

  /**
   * generated from use.counter.doc.document_query_command_supported_or_enabled_content_read_only
   * Whether a document calls queryCommandSupported or queryCommandEnabled with contentReadOnly. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_query_command_supported_or_enabled_content_read_only(2839);

  /**
   * generated from use.counter.doc.document_query_command_supported_or_enabled_insert_br_on_return
   * Whether a document calls queryCommandSupported or queryCommandEnabled with insertBrOnReturn. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_query_command_supported_or_enabled_insert_br_on_return(2840);

  /**
   * generated from use.counter.doc.domparser_parsefromstring
   * Whether a document called called DOMParser.parseFromString. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> domparser_parsefromstring(2841);

  /**
   * generated from use.counter.doc.element_attachshadow
   * Whether a document called called Element.attachShadow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_attachshadow(2842);

  /**
   * generated from use.counter.doc.element_releasecapture
   * Whether a document called called Element.releaseCapture. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_releasecapture(2843);

  /**
   * generated from use.counter.doc.element_releasepointercapture
   * Whether a document called called Element.releasePointerCapture. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_releasepointercapture(2844);

  /**
   * generated from use.counter.doc.element_setcapture
   * Whether a document called called Element.setCapture. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_setcapture(2845);

  /**
   * generated from use.counter.doc.element_sethtml
   * Whether a document called called Element.setHTML. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_sethtml(2846);

  /**
   * generated from use.counter.doc.element_setpointercapture
   * Whether a document called called Element.setPointerCapture. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_setpointercapture(2847);

  /**
   * generated from use.counter.doc.enumerate_devices_insec
   * Whether a document calls MediaDevices.enumerateDevices from an insecure context. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> enumerate_devices_insec(2848);

  /**
   * generated from use.counter.doc.enumerate_devices_unfocused
   * Whether a document calls MediaDevices.enumerateDevices from a unfocused document. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> enumerate_devices_unfocused(2849);

  /**
   * generated from use.counter.doc.fe_blend
   * Whether a document uses the feBlend SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_blend(2850);

  /**
   * generated from use.counter.doc.fe_color_matrix
   * Whether a document uses the feColorMatrix SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_color_matrix(2851);

  /**
   * generated from use.counter.doc.fe_component_transfer
   * Whether a document uses the feComponentTransfer SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_component_transfer(2852);

  /**
   * generated from use.counter.doc.fe_composite
   * Whether a document uses the feComposite SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_composite(2853);

  /**
   * generated from use.counter.doc.fe_convolve_matrix
   * Whether a document uses the feConvolveMatrix SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_convolve_matrix(2854);

  /**
   * generated from use.counter.doc.fe_diffuse_lighting
   * Whether a document uses the feDiffuseLighting SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_diffuse_lighting(2855);

  /**
   * generated from use.counter.doc.fe_displacement_map
   * Whether a document uses the feDisplacementMap SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_displacement_map(2856);

  /**
   * generated from use.counter.doc.fe_flood
   * Whether a document uses the feFlood SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_flood(2857);

  /**
   * generated from use.counter.doc.fe_gaussian_blur
   * Whether a document uses the feGaussianBlur SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_gaussian_blur(2858);

  /**
   * generated from use.counter.doc.fe_image
   * Whether a document uses the feImage SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_image(2859);

  /**
   * generated from use.counter.doc.fe_merge
   * Whether a document uses the feMerge SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_merge(2860);

  /**
   * generated from use.counter.doc.fe_morphology
   * Whether a document uses the feMorphology SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_morphology(2861);

  /**
   * generated from use.counter.doc.fe_offset
   * Whether a document uses the feOffset SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_offset(2862);

  /**
   * generated from use.counter.doc.fe_specular_lighting
   * Whether a document uses the feSpecularLighting SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_specular_lighting(2863);

  /**
   * generated from use.counter.doc.fe_tile
   * Whether a document uses the feTile SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_tile(2864);

  /**
   * generated from use.counter.doc.fe_turbulence
   * Whether a document uses the feTurbulence SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_turbulence(2865);

  /**
   * generated from use.counter.doc.filtered_cross_origin_iframe
   * Whether a document cross-origin <iframe> within a CSS/SVG filter. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> filtered_cross_origin_iframe(2866);

  /**
   * generated from use.counter.doc.get_user_media_insec
   * Whether a document calls MediaDevices.getUserMedia from an insecure context. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> get_user_media_insec(2867);

  /**
   * generated from use.counter.doc.get_user_media_unfocused
   * Whether a document calls MediaDevices.getUserMedia from an unfocused document. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> get_user_media_unfocused(2868);

  /**
   * generated from use.counter.doc.htmldialogelement_show
   * Whether a document called called HTMLDialogElement.show. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldialogelement_show(2869);

  /**
   * generated from use.counter.doc.htmldocument_caretrangefrompoint
   * Whether a document called called HTMLDocument.caretRangeFromPoint. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_caretrangefrompoint(2870);

  /**
   * generated from use.counter.doc.htmldocument_exitpictureinpicture
   * Whether a document called called HTMLDocument.exitPictureInPicture. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_exitpictureinpicture(2871);

  /**
   * generated from use.counter.doc.htmldocument_featurepolicy
   * Whether a document called called HTMLDocument.featurePolicy. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_featurepolicy(2872);

  /**
   * generated from use.counter.doc.htmldocument_named_getter_hit
   * Whether a document calls to the named getter on HTMLDocument that find something via the name lookup. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_named_getter_hit(2873);

  /**
   * generated from use.counter.doc.htmldocument_onbeforecopy
   * Whether a document called called HTMLDocument.onbeforecopy. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onbeforecopy(2874);

  /**
   * generated from use.counter.doc.htmldocument_onbeforecut
   * Whether a document called called HTMLDocument.onbeforecut. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onbeforecut(2875);

  /**
   * generated from use.counter.doc.htmldocument_onbeforepaste
   * Whether a document called called HTMLDocument.onbeforepaste. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onbeforepaste(2876);

  /**
   * generated from use.counter.doc.htmldocument_oncancel
   * Whether a document called called HTMLDocument.oncancel. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_oncancel(2877);

  /**
   * generated from use.counter.doc.htmldocument_onfreeze
   * Whether a document called called HTMLDocument.onfreeze. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onfreeze(2878);

  /**
   * generated from use.counter.doc.htmldocument_onmousewheel
   * Whether a document called called HTMLDocument.onmousewheel. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onmousewheel(2879);

  /**
   * generated from use.counter.doc.htmldocument_onresume
   * Whether a document called called HTMLDocument.onresume. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onresume(2880);

  /**
   * generated from use.counter.doc.htmldocument_onsearch
   * Whether a document called called HTMLDocument.onsearch. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onsearch(2881);

  /**
   * generated from use.counter.doc.htmldocument_onwebkitfullscreenchange
   * Whether a document called called HTMLDocument.onwebkitfullscreenchange. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onwebkitfullscreenchange(2882);

  /**
   * generated from use.counter.doc.htmldocument_onwebkitfullscreenerror
   * Whether a document called called HTMLDocument.onwebkitfullscreenerror. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onwebkitfullscreenerror(2883);

  /**
   * generated from use.counter.doc.htmldocument_pictureinpictureelement
   * Whether a document called called HTMLDocument.pictureInPictureElement. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_pictureinpictureelement(2884);

  /**
   * generated from use.counter.doc.htmldocument_pictureinpictureenabled
   * Whether a document called called HTMLDocument.pictureInPictureEnabled. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_pictureinpictureenabled(2885);

  /**
   * generated from use.counter.doc.htmldocument_registerelement
   * Whether a document called called HTMLDocument.registerElement. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_registerelement(2886);

  /**
   * generated from use.counter.doc.htmldocument_wasdiscarded
   * Whether a document called called HTMLDocument.wasDiscarded. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_wasdiscarded(2887);

  /**
   * generated from use.counter.doc.htmldocument_webkitcancelfullscreen
   * Whether a document called called HTMLDocument.webkitCancelFullScreen. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitcancelfullscreen(2888);

  /**
   * generated from use.counter.doc.htmldocument_webkitcurrentfullscreenelement
   * Whether a document called called HTMLDocument.webkitCurrentFullScreenElement. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitcurrentfullscreenelement(2889);

  /**
   * generated from use.counter.doc.htmldocument_webkitexitfullscreen
   * Whether a document called called HTMLDocument.webkitExitFullscreen. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitexitfullscreen(2890);

  /**
   * generated from use.counter.doc.htmldocument_webkitfullscreenelement
   * Whether a document called called HTMLDocument.webkitFullscreenElement. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitfullscreenelement(2891);

  /**
   * generated from use.counter.doc.htmldocument_webkitfullscreenenabled
   * Whether a document called called HTMLDocument.webkitFullscreenEnabled. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitfullscreenenabled(2892);

  /**
   * generated from use.counter.doc.htmldocument_webkithidden
   * Whether a document called called HTMLDocument.webkitHidden. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkithidden(2893);

  /**
   * generated from use.counter.doc.htmldocument_webkitisfullscreen
   * Whether a document called called HTMLDocument.webkitIsFullScreen. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitisfullscreen(2894);

  /**
   * generated from use.counter.doc.htmldocument_webkitvisibilitystate
   * Whether a document called called HTMLDocument.webkitVisibilityState. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitvisibilitystate(2895);

  /**
   * generated from use.counter.doc.htmldocument_xmlencoding
   * Whether a document called called HTMLDocument.xmlEncoding. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_xmlencoding(2896);

  /**
   * generated from use.counter.doc.htmldocument_xmlstandalone
   * Whether a document called called HTMLDocument.xmlStandalone. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_xmlstandalone(2897);

  /**
   * generated from use.counter.doc.htmldocument_xmlversion
   * Whether a document called called HTMLDocument.xmlVersion. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_xmlversion(2898);

  /**
   * generated from use.counter.doc.invalid_text_directives
   * Whether a document had a text fragment that could not be found after loading has finished. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> invalid_text_directives(2899);

  /**
   * generated from use.counter.doc.js_asmjs
   * Whether a document uses asm.js. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_asmjs(2900);

  /**
   * generated from use.counter.doc.js_dateparse
   * Whether a document called Date.parse. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_dateparse(2901);

  /**
   * generated from use.counter.doc.js_dateparse_impl_def
   * Whether a document call to Date.parse used implementation defined behaviour. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_dateparse_impl_def(2902);

  /**
   * generated from use.counter.doc.js_ic_stub_oom
   * Whether a document OOMed while creating IC stub. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_ic_stub_oom(2903);

  /**
   * generated from use.counter.doc.js_ic_stub_too_large
   * Whether a document tried to create an IC stub that was too large. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_ic_stub_too_large(2904);

  /**
   * generated from use.counter.doc.js_is_htmldda_fuse
   * Whether a document has used the document.all getter (popping the EmulatesUndefined Fuse). Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_is_htmldda_fuse(2905);

  /**
   * generated from use.counter.doc.js_large_oom_recovered
   * Whether a document recovered a large oom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_large_oom_recovered(2906);

  /**
   * generated from use.counter.doc.js_large_oom_reported
   * Whether a document reported a large oom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_large_oom_reported(2907);

  /**
   * generated from use.counter.doc.js_legacy_lang_subtag
   * Whether a document uses a 5-to-8-character language subtag in Intl.Locale constructor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_legacy_lang_subtag(2908);

  /**
   * generated from use.counter.doc.js_optimize_array_species_fuse
   * Whether a document has modified builtin Array objects such that the ArraySpecies fuse is popped. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_optimize_array_species_fuse(2909);

  /**
   * generated from use.counter.doc.js_optimize_get_iterator_fuse
   * Whether a document has modified any builtins such that the GetIterator fuse is popped. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_optimize_get_iterator_fuse(2910);

  /**
   * generated from use.counter.doc.js_optimize_promise_lookup_fuse
   * Whether a document has modified builtin Promise objects such that the PromiseLookup fuse is popped. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_optimize_promise_lookup_fuse(2911);

  /**
   * generated from use.counter.doc.js_small_oom_recovered
   * Whether a document recovered a small oom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_small_oom_recovered(2912);

  /**
   * generated from use.counter.doc.js_small_oom_reported
   * Whether a document reported a small oom. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_small_oom_reported(2913);

  /**
   * generated from use.counter.doc.js_thenable
   * Whether a document resolved a promise using thenable support rather than builtin methods. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_thenable(2914);

  /**
   * generated from use.counter.doc.js_thenable_object_proto
   * Whether a document resolved a promise using thenable on a realms Object.prototype. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_thenable_object_proto(2915);

  /**
   * generated from use.counter.doc.js_thenable_proto
   * Whether a document resolved a promise using thenable on prototype. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_thenable_proto(2916);

  /**
   * generated from use.counter.doc.js_thenable_standard_proto
   * Whether a document resolved a promise using thenable on a standard prototype. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_thenable_standard_proto(2917);

  /**
   * generated from use.counter.doc.js_use_asm
   * Whether a document has instantiated a script containing "use asm" either in the top level or a nested function. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_use_asm(2918);

  /**
   * generated from use.counter.doc.js_wasm
   * Whether a document uses WebAssembly. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_wasm(2919);

  /**
   * generated from use.counter.doc.js_wasm_legacy_exceptions
   * Whether a document uses WebAssembly legacy exception-handling. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_wasm_legacy_exceptions(2920);

  /**
   * generated from use.counter.doc.location_ancestororigins
   * Whether a document called called Location.ancestorOrigins. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> location_ancestororigins(2921);

  /**
   * generated from use.counter.doc.math_mlused
   * Whether a document has used MathML. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_mlused(2922);

  /**
   * generated from use.counter.doc.mediadevices_enumeratedevices
   * Whether a document called called MediaDevices.enumerateDevices. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mediadevices_enumeratedevices(2923);

  /**
   * generated from use.counter.doc.mediadevices_getdisplaymedia
   * Whether a document called called MediaDevices.getDisplayMedia. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mediadevices_getdisplaymedia(2924);

  /**
   * generated from use.counter.doc.mediadevices_getusermedia
   * Whether a document called called MediaDevices.getUserMedia. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mediadevices_getusermedia(2925);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_audio_failure
   * Whether a document includes a mixed content audio element that does not load.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_audio_failure(2926);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_audio_success
   * Whether a document includes a mixed content audio element that loads.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_audio_success(2927);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_image_failure
   * Whether a document includes a mixed content img element that does not load.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_image_failure(2928);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_image_success
   * Whether a document includes a mixed content img element that loads.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_image_success(2929);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_video_failure
   * Whether a document includes a mixed content video element that does not laod.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_video_failure(2930);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_video_success
   * Whether a document includes a mixed content video element that loads.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_video_success(2931);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_audio_failure
   * Whether a document includes a mixed content audio element that does not load.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_audio_failure(2932);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_audio_success
   * Whether a document includes a mixed content audio element that loads.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_audio_success(2933);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_image_failure
   * Whether a document includes a mixed content img element that does not load.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_image_failure(2934);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_image_success
   * Whether a document includes a mixed content img element that loads.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_image_success(2935);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_video_failure
   * Whether a document includes a mixed content video element that does not laod.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_video_failure(2936);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_video_success
   * Whether a document includes a mixed content video element that loads.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_video_success(2937);

  /**
   * generated from use.counter.doc.mls_deriveexporter
   * Whether a document called called MLS.deriveExporter. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_deriveexporter(2938);

  /**
   * generated from use.counter.doc.mls_generatecredentialbasic
   * Whether a document called called MLS.generateCredentialBasic. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatecredentialbasic(2939);

  /**
   * generated from use.counter.doc.mls_generatekeypackage
   * Whether a document called called MLS.generateKeyPackage. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatekeypackage(2940);

  /**
   * generated from use.counter.doc.mls_generatesignaturekeypair
   * Whether a document called called MLS.generateSignatureKeypair. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatesignaturekeypair(2941);

  /**
   * generated from use.counter.doc.mls_groupadd
   * Whether a document called called MLS.groupAdd. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupadd(2942);

  /**
   * generated from use.counter.doc.mls_groupclose
   * Whether a document called called MLS.groupClose. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupclose(2943);

  /**
   * generated from use.counter.doc.mls_groupcreate
   * Whether a document called called MLS.groupCreate. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupcreate(2944);

  /**
   * generated from use.counter.doc.mls_groupjoin
   * Whether a document called called MLS.groupJoin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupjoin(2945);

  /**
   * generated from use.counter.doc.mls_groupmembers
   * Whether a document called called MLS.groupMembers. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupmembers(2946);

  /**
   * generated from use.counter.doc.mls_groupproposeadd
   * Whether a document called called MLS.groupProposeAdd. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupproposeadd(2947);

  /**
   * generated from use.counter.doc.mls_groupproposeremove
   * Whether a document called called MLS.groupProposeRemove. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupproposeremove(2948);

  /**
   * generated from use.counter.doc.mls_groupremove
   * Whether a document called called MLS.groupRemove. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupremove(2949);

  /**
   * generated from use.counter.doc.mls_receive
   * Whether a document called called MLS.receive. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_receive(2950);

  /**
   * generated from use.counter.doc.mls_send
   * Whether a document called called MLS.send. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_send(2951);

  /**
   * generated from use.counter.doc.mls_statedelete
   * Whether a document called called MLS.stateDelete. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_statedelete(2952);

  /**
   * generated from use.counter.doc.mls_statedeletegroup
   * Whether a document called called MLS.stateDeleteGroup. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_statedeletegroup(2953);

  /**
   * generated from use.counter.doc.navigator_mozgetusermedia
   * Whether a document called called Navigator.mozGetUserMedia. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> navigator_mozgetusermedia(2954);

  /**
   * generated from use.counter.doc.notificationoptions_actions
   * Whether a document called called NotificationOptions.actions. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_actions(2955);

  /**
   * generated from use.counter.doc.notificationoptions_badge
   * Whether a document called called NotificationOptions.badge. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_badge(2956);

  /**
   * generated from use.counter.doc.notificationoptions_image
   * Whether a document called called NotificationOptions.image. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_image(2957);

  /**
   * generated from use.counter.doc.notificationoptions_navigate
   * Whether a document called called NotificationOptions.navigate. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_navigate(2958);

  /**
   * generated from use.counter.doc.notificationoptions_renotify
   * Whether a document called called NotificationOptions.renotify. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_renotify(2959);

  /**
   * generated from use.counter.doc.notificationoptions_requireinteraction
   * Whether a document called called NotificationOptions.requireInteraction. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_requireinteraction(2960);

  /**
   * generated from use.counter.doc.notificationoptions_timestamp
   * Whether a document called called NotificationOptions.timestamp. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_timestamp(2961);

  /**
   * generated from use.counter.doc.notificationoptions_vibrate
   * Whether a document called called NotificationOptions.vibrate. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_vibrate(2962);

  /**
   * generated from use.counter.doc.ondommousescroll
   * Whether a document sets DOMMouseScroll event listener. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ondommousescroll(2963);

  /**
   * generated from use.counter.doc.onmozmousepixelscroll
   * Whether a document sets MozMousePixelScroll event listener. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> onmozmousepixelscroll(2964);

  /**
   * generated from use.counter.doc.percentage_stroke_width_in_svg
   * Whether a document whether percentage stroke-width is used in SVG elements (excluding <text>). Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> percentage_stroke_width_in_svg(2965);

  /**
   * generated from use.counter.doc.percentage_stroke_width_in_svgtext
   * Whether a document whether percentage stroke-width is used in SVG <text>. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> percentage_stroke_width_in_svgtext(2966);

  /**
   * generated from use.counter.doc.private_browsing_caches_delete
   * Whether a document calls caches.delete in Private Browsing Mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_delete(2967);

  /**
   * generated from use.counter.doc.private_browsing_caches_has
   * Whether a document calls caches.has in Private Browsing Mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_has(2968);

  /**
   * generated from use.counter.doc.private_browsing_caches_keys
   * Whether a document calls caches.keys in Private Browsing Mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_keys(2969);

  /**
   * generated from use.counter.doc.private_browsing_caches_match
   * Whether a document calls caches.match in Private Browsing Mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_match(2970);

  /**
   * generated from use.counter.doc.private_browsing_caches_open
   * Whether a document calls caches.open in Private Browsing Mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_open(2971);

  /**
   * generated from use.counter.doc.private_browsing_idbfactory_delete_database
   * Whether a document calls indexedDB.deleteDatabase in Private Browsing Mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_idbfactory_delete_database(2972);

  /**
   * generated from use.counter.doc.private_browsing_idbfactory_open
   * Whether a document calls indexedDB.open in Private Browsing Mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_idbfactory_open(2973);

  /**
   * generated from use.counter.doc.private_browsing_navigator_service_worker
   * Whether a document accesses navigator.serviceWorker in Private Browsing Mode. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_navigator_service_worker(2974);

  /**
   * generated from use.counter.doc.pushmanager_subscribe
   * Whether a document called called PushManager.subscribe. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pushmanager_subscribe(2975);

  /**
   * generated from use.counter.doc.pushsubscription_unsubscribe
   * Whether a document called called PushSubscription.unsubscribe. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pushsubscription_unsubscribe(2976);

  /**
   * generated from use.counter.doc.range_createcontextualfragment
   * Whether a document called called Range.createContextualFragment. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> range_createcontextualfragment(2977);

  /**
   * generated from use.counter.doc.sanitizer_constructor
   * Whether a document called called Sanitizer.constructor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> sanitizer_constructor(2978);

  /**
   * generated from use.counter.doc.sanitizer_sanitize
   * Whether a document called called Sanitizer.sanitize. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> sanitizer_sanitize(2979);

  /**
   * generated from use.counter.doc.scheduler_posttask
   * Whether a document called called Scheduler.postTask. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> scheduler_posttask(2980);

  /**
   * generated from use.counter.doc.svgsvgelement_currentscale_getter
   * Whether a document got SVGSVGElement.currentScale. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> svgsvgelement_currentscale_getter(2981);

  /**
   * generated from use.counter.doc.svgsvgelement_currentscale_setter
   * Whether a document set SVGSVGElement.currentScale. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> svgsvgelement_currentscale_setter(2982);

  /**
   * generated from use.counter.doc.svgsvgelement_getelementbyid
   * Whether a document called called SVGSVGElement.getElementById. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> svgsvgelement_getelementbyid(2983);

  /**
   * generated from use.counter.doc.text_directive_not_created
   * Whether a document has not succeeded in creating a text fragment. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> text_directive_not_created(2984);

  /**
   * generated from use.counter.doc.text_directive_pages
   * Whether a document used text fragments. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> text_directive_pages(2985);

  /**
   * generated from use.counter.doc.webgpu_render_output
   * Whether a document displays WebGPU rendering output. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webgpu_render_output(2986);

  /**
   * generated from use.counter.doc.webgpu_request_adapter
   * Whether a document requests a WebGPU adapter. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webgpu_request_adapter(2987);

  /**
   * generated from use.counter.doc.window_absoluteorientationsensor
   * Whether a document called called Window.AbsoluteOrientationSensor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_absoluteorientationsensor(2988);

  /**
   * generated from use.counter.doc.window_accelerometer
   * Whether a document called called Window.Accelerometer. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_accelerometer(2989);

  /**
   * generated from use.counter.doc.window_backgroundfetchmanager
   * Whether a document called called Window.BackgroundFetchManager. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_backgroundfetchmanager(2990);

  /**
   * generated from use.counter.doc.window_backgroundfetchrecord
   * Whether a document called called Window.BackgroundFetchRecord. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_backgroundfetchrecord(2991);

  /**
   * generated from use.counter.doc.window_backgroundfetchregistration
   * Whether a document called called Window.BackgroundFetchRegistration. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_backgroundfetchregistration(2992);

  /**
   * generated from use.counter.doc.window_beforeinstallpromptevent
   * Whether a document called called Window.BeforeInstallPromptEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_beforeinstallpromptevent(2993);

  /**
   * generated from use.counter.doc.window_bluetooth
   * Whether a document called called Window.Bluetooth. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetooth(2994);

  /**
   * generated from use.counter.doc.window_bluetoothcharacteristicproperties
   * Whether a document called called Window.BluetoothCharacteristicProperties. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothcharacteristicproperties(2995);

  /**
   * generated from use.counter.doc.window_bluetoothdevice
   * Whether a document called called Window.BluetoothDevice. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothdevice(2996);

  /**
   * generated from use.counter.doc.window_bluetoothremotegattcharacteristic
   * Whether a document called called Window.BluetoothRemoteGATTCharacteristic. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothremotegattcharacteristic(2997);

  /**
   * generated from use.counter.doc.window_bluetoothremotegattdescriptor
   * Whether a document called called Window.BluetoothRemoteGATTDescriptor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothremotegattdescriptor(2998);

  /**
   * generated from use.counter.doc.window_bluetoothremotegattserver
   * Whether a document called called Window.BluetoothRemoteGATTServer. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothremotegattserver(2999);

  /**
   * generated from use.counter.doc.window_bluetoothremotegattservice
   * Whether a document called called Window.BluetoothRemoteGATTService. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothremotegattservice(3000);

  /**
   * generated from use.counter.doc.window_bluetoothuuid
   * Whether a document called called Window.BluetoothUUID. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothuuid(3001);

  /**
   * generated from use.counter.doc.window_canvascapturemediastreamtrack
   * Whether a document called called Window.CanvasCaptureMediaStreamTrack. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_canvascapturemediastreamtrack(3002);

  /**
   * generated from use.counter.doc.window_chrome
   * Whether a document called called Window.chrome. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_chrome(3003);

  /**
   * generated from use.counter.doc.window_clipboarditem
   * Whether a document called called Window.ClipboardItem. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_clipboarditem(3004);

  /**
   * generated from use.counter.doc.window_cssimagevalue
   * Whether a document called called Window.CSSImageValue. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssimagevalue(3005);

  /**
   * generated from use.counter.doc.window_csskeywordvalue
   * Whether a document called called Window.CSSKeywordValue. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csskeywordvalue(3006);

  /**
   * generated from use.counter.doc.window_cssmathclamp
   * Whether a document called called Window.CSSMathClamp. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathclamp(3007);

  /**
   * generated from use.counter.doc.window_cssmathinvert
   * Whether a document called called Window.CSSMathInvert. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathinvert(3008);

  /**
   * generated from use.counter.doc.window_cssmathmax
   * Whether a document called called Window.CSSMathMax. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathmax(3009);

  /**
   * generated from use.counter.doc.window_cssmathmin
   * Whether a document called called Window.CSSMathMin. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathmin(3010);

  /**
   * generated from use.counter.doc.window_cssmathnegate
   * Whether a document called called Window.CSSMathNegate. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathnegate(3011);

  /**
   * generated from use.counter.doc.window_cssmathproduct
   * Whether a document called called Window.CSSMathProduct. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathproduct(3012);

  /**
   * generated from use.counter.doc.window_cssmathsum
   * Whether a document called called Window.CSSMathSum. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathsum(3013);

  /**
   * generated from use.counter.doc.window_cssmathvalue
   * Whether a document called called Window.CSSMathValue. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathvalue(3014);

  /**
   * generated from use.counter.doc.window_cssmatrixcomponent
   * Whether a document called called Window.CSSMatrixComponent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmatrixcomponent(3015);

  /**
   * generated from use.counter.doc.window_cssnumericarray
   * Whether a document called called Window.CSSNumericArray. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssnumericarray(3016);

  /**
   * generated from use.counter.doc.window_cssnumericvalue
   * Whether a document called called Window.CSSNumericValue. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssnumericvalue(3017);

  /**
   * generated from use.counter.doc.window_cssperspective
   * Whether a document called called Window.CSSPerspective. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssperspective(3018);

  /**
   * generated from use.counter.doc.window_csspositionvalue
   * Whether a document called called Window.CSSPositionValue. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csspositionvalue(3019);

  /**
   * generated from use.counter.doc.window_csspropertyrule
   * Whether a document called called Window.CSSPropertyRule. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csspropertyrule(3020);

  /**
   * generated from use.counter.doc.window_cssrotate
   * Whether a document called called Window.CSSRotate. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssrotate(3021);

  /**
   * generated from use.counter.doc.window_cssscale
   * Whether a document called called Window.CSSScale. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssscale(3022);

  /**
   * generated from use.counter.doc.window_cssskew
   * Whether a document called called Window.CSSSkew. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssskew(3023);

  /**
   * generated from use.counter.doc.window_cssskewx
   * Whether a document called called Window.CSSSkewX. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssskewx(3024);

  /**
   * generated from use.counter.doc.window_cssskewy
   * Whether a document called called Window.CSSSkewY. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssskewy(3025);

  /**
   * generated from use.counter.doc.window_cssstylevalue
   * Whether a document called called Window.CSSStyleValue. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssstylevalue(3026);

  /**
   * generated from use.counter.doc.window_csstransformcomponent
   * Whether a document called called Window.CSSTransformComponent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csstransformcomponent(3027);

  /**
   * generated from use.counter.doc.window_csstransformvalue
   * Whether a document called called Window.CSSTransformValue. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csstransformvalue(3028);

  /**
   * generated from use.counter.doc.window_csstranslate
   * Whether a document called called Window.CSSTranslate. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csstranslate(3029);

  /**
   * generated from use.counter.doc.window_cssunitvalue
   * Whether a document called called Window.CSSUnitValue. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssunitvalue(3030);

  /**
   * generated from use.counter.doc.window_cssunparsedvalue
   * Whether a document called called Window.CSSUnparsedValue. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssunparsedvalue(3031);

  /**
   * generated from use.counter.doc.window_cssvariablereferencevalue
   * Whether a document called called Window.CSSVariableReferenceValue. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssvariablereferencevalue(3032);

  /**
   * generated from use.counter.doc.window_defaultstatus
   * Whether a document called called Window.defaultStatus. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_defaultstatus(3033);

  /**
   * generated from use.counter.doc.window_devicemotioneventacceleration
   * Whether a document called called Window.DeviceMotionEventAcceleration. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_devicemotioneventacceleration(3034);

  /**
   * generated from use.counter.doc.window_devicemotioneventrotationrate
   * Whether a document called called Window.DeviceMotionEventRotationRate. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_devicemotioneventrotationrate(3035);

  /**
   * generated from use.counter.doc.window_domerror
   * Whether a document called called Window.DOMError. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_domerror(3036);

  /**
   * generated from use.counter.doc.window_encodedvideochunk
   * Whether a document called called Window.EncodedVideoChunk. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_encodedvideochunk(3037);

  /**
   * generated from use.counter.doc.window_enterpictureinpictureevent
   * Whether a document called called Window.EnterPictureInPictureEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_enterpictureinpictureevent(3038);

  /**
   * generated from use.counter.doc.window_external
   * Whether a document called called Window.External. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_external(3039);

  /**
   * generated from use.counter.doc.window_federatedcredential
   * Whether a document called called Window.FederatedCredential. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_federatedcredential(3040);

  /**
   * generated from use.counter.doc.window_gyroscope
   * Whether a document called called Window.Gyroscope. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_gyroscope(3041);

  /**
   * generated from use.counter.doc.window_htmlcontentelement
   * Whether a document called called Window.HTMLContentElement. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_htmlcontentelement(3042);

  /**
   * generated from use.counter.doc.window_htmlshadowelement
   * Whether a document called called Window.HTMLShadowElement. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_htmlshadowelement(3043);

  /**
   * generated from use.counter.doc.window_imagecapture
   * Whether a document called called Window.ImageCapture. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_imagecapture(3044);

  /**
   * generated from use.counter.doc.window_inputdevicecapabilities
   * Whether a document called called Window.InputDeviceCapabilities. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_inputdevicecapabilities(3045);

  /**
   * generated from use.counter.doc.window_inputdeviceinfo
   * Whether a document called called Window.InputDeviceInfo. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_inputdeviceinfo(3046);

  /**
   * generated from use.counter.doc.window_keyboard
   * Whether a document called called Window.Keyboard. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_keyboard(3047);

  /**
   * generated from use.counter.doc.window_keyboardlayoutmap
   * Whether a document called called Window.KeyboardLayoutMap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_keyboardlayoutmap(3048);

  /**
   * generated from use.counter.doc.window_linearaccelerationsensor
   * Whether a document called called Window.LinearAccelerationSensor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_linearaccelerationsensor(3049);

  /**
   * generated from use.counter.doc.window_mediasettingsrange
   * Whether a document called called Window.MediaSettingsRange. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_mediasettingsrange(3050);

  /**
   * generated from use.counter.doc.window_midiaccess
   * Whether a document called called Window.MIDIAccess. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midiaccess(3051);

  /**
   * generated from use.counter.doc.window_midiconnectionevent
   * Whether a document called called Window.MIDIConnectionEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midiconnectionevent(3052);

  /**
   * generated from use.counter.doc.window_midiinput
   * Whether a document called called Window.MIDIInput. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midiinput(3053);

  /**
   * generated from use.counter.doc.window_midiinputmap
   * Whether a document called called Window.MIDIInputMap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midiinputmap(3054);

  /**
   * generated from use.counter.doc.window_midimessageevent
   * Whether a document called called Window.MIDIMessageEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midimessageevent(3055);

  /**
   * generated from use.counter.doc.window_midioutput
   * Whether a document called called Window.MIDIOutput. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midioutput(3056);

  /**
   * generated from use.counter.doc.window_midioutputmap
   * Whether a document called called Window.MIDIOutputMap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midioutputmap(3057);

  /**
   * generated from use.counter.doc.window_midiport
   * Whether a document called called Window.MIDIPort. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midiport(3058);

  /**
   * generated from use.counter.doc.window_networkinformation
   * Whether a document called called Window.NetworkInformation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_networkinformation(3059);

  /**
   * generated from use.counter.doc.window_offscreenbuffering
   * Whether a document called called Window.offscreenBuffering. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_offscreenbuffering(3060);

  /**
   * generated from use.counter.doc.window_onbeforeinstallprompt
   * Whether a document called called Window.onbeforeinstallprompt. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_onbeforeinstallprompt(3061);

  /**
   * generated from use.counter.doc.window_oncancel
   * Whether a document called called Window.oncancel. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_oncancel(3062);

  /**
   * generated from use.counter.doc.window_onmousewheel
   * Whether a document called called Window.onmousewheel. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_onmousewheel(3063);

  /**
   * generated from use.counter.doc.window_onorientationchange
   * Whether a document called called Window.onorientationchange. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_onorientationchange(3064);

  /**
   * generated from use.counter.doc.window_onsearch
   * Whether a document called called Window.onsearch. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_onsearch(3065);

  /**
   * generated from use.counter.doc.window_onselectionchange
   * Whether a document called called Window.onselectionchange. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_onselectionchange(3066);

  /**
   * generated from use.counter.doc.window_open_empty_url
   * Whether a document calls window.open with an empty url argument. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_open_empty_url(3067);

  /**
   * generated from use.counter.doc.window_opendatabase
   * Whether a document called called Window.openDatabase. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_opendatabase(3068);

  /**
   * generated from use.counter.doc.window_orientation
   * Whether a document called called Window.orientation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_orientation(3069);

  /**
   * generated from use.counter.doc.window_orientationsensor
   * Whether a document called called Window.OrientationSensor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_orientationsensor(3070);

  /**
   * generated from use.counter.doc.window_overconstrainederror
   * Whether a document called called Window.OverconstrainedError. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_overconstrainederror(3071);

  /**
   * generated from use.counter.doc.window_passwordcredential
   * Whether a document called called Window.PasswordCredential. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_passwordcredential(3072);

  /**
   * generated from use.counter.doc.window_paymentaddress
   * Whether a document called called Window.PaymentAddress. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentaddress(3073);

  /**
   * generated from use.counter.doc.window_paymentinstruments
   * Whether a document called called Window.PaymentInstruments. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentinstruments(3074);

  /**
   * generated from use.counter.doc.window_paymentmanager
   * Whether a document called called Window.PaymentManager. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentmanager(3075);

  /**
   * generated from use.counter.doc.window_paymentmethodchangeevent
   * Whether a document called called Window.PaymentMethodChangeEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentmethodchangeevent(3076);

  /**
   * generated from use.counter.doc.window_paymentrequest
   * Whether a document called called Window.PaymentRequest. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentrequest(3077);

  /**
   * generated from use.counter.doc.window_paymentrequestupdateevent
   * Whether a document called called Window.PaymentRequestUpdateEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentrequestupdateevent(3078);

  /**
   * generated from use.counter.doc.window_paymentresponse
   * Whether a document called called Window.PaymentResponse. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentresponse(3079);

  /**
   * generated from use.counter.doc.window_performancelongtasktiming
   * Whether a document called called Window.PerformanceLongTaskTiming. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_performancelongtasktiming(3080);

  /**
   * generated from use.counter.doc.window_photocapabilities
   * Whether a document called called Window.PhotoCapabilities. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_photocapabilities(3081);

  /**
   * generated from use.counter.doc.window_pictureinpictureevent
   * Whether a document called called Window.PictureInPictureEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_pictureinpictureevent(3082);

  /**
   * generated from use.counter.doc.window_pictureinpicturewindow
   * Whether a document called called Window.PictureInPictureWindow. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_pictureinpicturewindow(3083);

  /**
   * generated from use.counter.doc.window_presentation
   * Whether a document called called Window.Presentation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentation(3084);

  /**
   * generated from use.counter.doc.window_presentationavailability
   * Whether a document called called Window.PresentationAvailability. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationavailability(3085);

  /**
   * generated from use.counter.doc.window_presentationconnection
   * Whether a document called called Window.PresentationConnection. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationconnection(3086);

  /**
   * generated from use.counter.doc.window_presentationconnectionavailableevent
   * Whether a document called called Window.PresentationConnectionAvailableEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationconnectionavailableevent(3087);

  /**
   * generated from use.counter.doc.window_presentationconnectioncloseevent
   * Whether a document called called Window.PresentationConnectionCloseEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationconnectioncloseevent(3088);

  /**
   * generated from use.counter.doc.window_presentationconnectionlist
   * Whether a document called called Window.PresentationConnectionList. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationconnectionlist(3089);

  /**
   * generated from use.counter.doc.window_presentationreceiver
   * Whether a document called called Window.PresentationReceiver. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationreceiver(3090);

  /**
   * generated from use.counter.doc.window_presentationrequest
   * Whether a document called called Window.PresentationRequest. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationrequest(3091);

  /**
   * generated from use.counter.doc.window_relativeorientationsensor
   * Whether a document called called Window.RelativeOrientationSensor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_relativeorientationsensor(3092);

  /**
   * generated from use.counter.doc.window_remoteplayback
   * Whether a document called called Window.RemotePlayback. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_remoteplayback(3093);

  /**
   * generated from use.counter.doc.window_report
   * Whether a document called called Window.Report. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_report(3094);

  /**
   * generated from use.counter.doc.window_reportbody
   * Whether a document called called Window.ReportBody. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_reportbody(3095);

  /**
   * generated from use.counter.doc.window_reportingobserver
   * Whether a document called called Window.ReportingObserver. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_reportingobserver(3096);

  /**
   * generated from use.counter.doc.window_rtcerror
   * Whether a document called called Window.RTCError. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_rtcerror(3097);

  /**
   * generated from use.counter.doc.window_rtcerrorevent
   * Whether a document called called Window.RTCErrorEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_rtcerrorevent(3098);

  /**
   * generated from use.counter.doc.window_rtcicetransport
   * Whether a document called called Window.RTCIceTransport. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_rtcicetransport(3099);

  /**
   * generated from use.counter.doc.window_rtcpeerconnectioniceerrorevent
   * Whether a document called called Window.RTCPeerConnectionIceErrorEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_rtcpeerconnectioniceerrorevent(3100);

  /**
   * generated from use.counter.doc.window_sensor
   * Whether a document called called Window.Sensor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_sensor(3101);

  /**
   * generated from use.counter.doc.window_sensorerrorevent
   * Whether a document called called Window.SensorErrorEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_sensorerrorevent(3102);

  /**
   * generated from use.counter.doc.window_sidebar_getter
   * Whether a document got Window.sidebar. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_sidebar_getter(3103);

  /**
   * generated from use.counter.doc.window_sidebar_setter
   * Whether a document set Window.sidebar. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_sidebar_setter(3104);

  /**
   * generated from use.counter.doc.window_speechrecognitionalternative
   * Whether a document called called Window.SpeechRecognitionAlternative. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_speechrecognitionalternative(3105);

  /**
   * generated from use.counter.doc.window_speechrecognitionresult
   * Whether a document called called Window.SpeechRecognitionResult. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_speechrecognitionresult(3106);

  /**
   * generated from use.counter.doc.window_speechrecognitionresultlist
   * Whether a document called called Window.SpeechRecognitionResultList. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_speechrecognitionresultlist(3107);

  /**
   * generated from use.counter.doc.window_stylemedia
   * Whether a document called called Window.styleMedia. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_stylemedia(3108);

  /**
   * generated from use.counter.doc.window_stylepropertymap
   * Whether a document called called Window.StylePropertyMap. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_stylepropertymap(3109);

  /**
   * generated from use.counter.doc.window_stylepropertymapreadonly
   * Whether a document called called Window.StylePropertyMapReadOnly. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_stylepropertymapreadonly(3110);

  /**
   * generated from use.counter.doc.window_svgdiscardelement
   * Whether a document called called Window.SVGDiscardElement. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_svgdiscardelement(3111);

  /**
   * generated from use.counter.doc.window_syncmanager
   * Whether a document called called Window.SyncManager. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_syncmanager(3112);

  /**
   * generated from use.counter.doc.window_taskattributiontiming
   * Whether a document called called Window.TaskAttributionTiming. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_taskattributiontiming(3113);

  /**
   * generated from use.counter.doc.window_textevent
   * Whether a document called called Window.TextEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_textevent(3114);

  /**
   * generated from use.counter.doc.window_touch
   * Whether a document called called Window.Touch. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_touch(3115);

  /**
   * generated from use.counter.doc.window_touchevent
   * Whether a document called called Window.TouchEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_touchevent(3116);

  /**
   * generated from use.counter.doc.window_touchlist
   * Whether a document called called Window.TouchList. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_touchlist(3117);

  /**
   * generated from use.counter.doc.window_usb
   * Whether a document called called Window.USB. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usb(3118);

  /**
   * generated from use.counter.doc.window_usbalternateinterface
   * Whether a document called called Window.USBAlternateInterface. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbalternateinterface(3119);

  /**
   * generated from use.counter.doc.window_usbconfiguration
   * Whether a document called called Window.USBConfiguration. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbconfiguration(3120);

  /**
   * generated from use.counter.doc.window_usbconnectionevent
   * Whether a document called called Window.USBConnectionEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbconnectionevent(3121);

  /**
   * generated from use.counter.doc.window_usbdevice
   * Whether a document called called Window.USBDevice. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbdevice(3122);

  /**
   * generated from use.counter.doc.window_usbendpoint
   * Whether a document called called Window.USBEndpoint. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbendpoint(3123);

  /**
   * generated from use.counter.doc.window_usbinterface
   * Whether a document called called Window.USBInterface. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbinterface(3124);

  /**
   * generated from use.counter.doc.window_usbintransferresult
   * Whether a document called called Window.USBInTransferResult. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbintransferresult(3125);

  /**
   * generated from use.counter.doc.window_usbisochronousintransferpacket
   * Whether a document called called Window.USBIsochronousInTransferPacket. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbisochronousintransferpacket(3126);

  /**
   * generated from use.counter.doc.window_usbisochronousintransferresult
   * Whether a document called called Window.USBIsochronousInTransferResult. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbisochronousintransferresult(3127);

  /**
   * generated from use.counter.doc.window_usbisochronousouttransferpacket
   * Whether a document called called Window.USBIsochronousOutTransferPacket. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbisochronousouttransferpacket(3128);

  /**
   * generated from use.counter.doc.window_usbisochronousouttransferresult
   * Whether a document called called Window.USBIsochronousOutTransferResult. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbisochronousouttransferresult(3129);

  /**
   * generated from use.counter.doc.window_usbouttransferresult
   * Whether a document called called Window.USBOutTransferResult. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbouttransferresult(3130);

  /**
   * generated from use.counter.doc.window_useractivation
   * Whether a document called called Window.UserActivation. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_useractivation(3131);

  /**
   * generated from use.counter.doc.window_videocolorspace
   * Whether a document called called Window.VideoColorSpace. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_videocolorspace(3132);

  /**
   * generated from use.counter.doc.window_videodecoder
   * Whether a document called called Window.VideoDecoder. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_videodecoder(3133);

  /**
   * generated from use.counter.doc.window_videoencoder
   * Whether a document called called Window.VideoEncoder. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_videoencoder(3134);

  /**
   * generated from use.counter.doc.window_videoframe
   * Whether a document called called Window.VideoFrame. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_videoframe(3135);

  /**
   * generated from use.counter.doc.window_wakelock
   * Whether a document called called Window.WakeLock. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_wakelock(3136);

  /**
   * generated from use.counter.doc.window_wakelocksentinel
   * Whether a document called called Window.WakeLockSentinel. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_wakelocksentinel(3137);

  /**
   * generated from use.counter.doc.window_webkitcancelanimationframe
   * Whether a document called called Window.webkitCancelAnimationFrame. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitcancelanimationframe(3138);

  /**
   * generated from use.counter.doc.window_webkitmediastream
   * Whether a document called called Window.webkitMediaStream. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitmediastream(3139);

  /**
   * generated from use.counter.doc.window_webkitmutationobserver
   * Whether a document called called Window.WebKitMutationObserver. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitmutationobserver(3140);

  /**
   * generated from use.counter.doc.window_webkitrequestanimationframe
   * Whether a document called called Window.webkitRequestAnimationFrame. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitrequestanimationframe(3141);

  /**
   * generated from use.counter.doc.window_webkitrequestfilesystem
   * Whether a document called called Window.webkitRequestFileSystem. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitrequestfilesystem(3142);

  /**
   * generated from use.counter.doc.window_webkitresolvelocalfilesystemurl
   * Whether a document called called Window.webkitResolveLocalFileSystemURL. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitresolvelocalfilesystemurl(3143);

  /**
   * generated from use.counter.doc.window_webkitrtcpeerconnection
   * Whether a document called called Window.webkitRTCPeerConnection. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitrtcpeerconnection(3144);

  /**
   * generated from use.counter.doc.window_webkitspeechgrammar
   * Whether a document called called Window.webkitSpeechGrammar. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitspeechgrammar(3145);

  /**
   * generated from use.counter.doc.window_webkitspeechgrammarlist
   * Whether a document called called Window.webkitSpeechGrammarList. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitspeechgrammarlist(3146);

  /**
   * generated from use.counter.doc.window_webkitspeechrecognition
   * Whether a document called called Window.webkitSpeechRecognition. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitspeechrecognition(3147);

  /**
   * generated from use.counter.doc.window_webkitspeechrecognitionerror
   * Whether a document called called Window.webkitSpeechRecognitionError. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitspeechrecognitionerror(3148);

  /**
   * generated from use.counter.doc.window_webkitspeechrecognitionevent
   * Whether a document called called Window.webkitSpeechRecognitionEvent. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitspeechrecognitionevent(3149);

  /**
   * generated from use.counter.doc.window_webkitstorageinfo
   * Whether a document called called Window.webkitStorageInfo. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitstorageinfo(3150);

  /**
   * generated from use.counter.doc.wr_filter_fallback
   * Whether a document triggers the blob fallback for an SVG filter.. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> wr_filter_fallback(3151);

  /**
   * generated from use.counter.doc.xslstylesheet
   * Whether a document uses an XSL Stylesheet. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> xslstylesheet(3152);

  /**
   * generated from use.counter.doc.xsltprocessor_constructor
   * Whether a document called called XSLTProcessor.constructor. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> xsltprocessor_constructor(3153);

  /**
   * generated from use.counter.doc.you_tube_flash_embed
   * Whether a document in <object> or <embed>. Compare against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> you_tube_flash_embed(3154);
}

namespace use_counter_page {
  /**
   * generated from use.counter.page.components_shim_resolved
   * Whether a page resolves the components shim.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> components_shim_resolved(3155);

  /**
   * generated from use.counter.page.console_assert
   * Whether a page called called console.assert. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_assert(3156);

  /**
   * generated from use.counter.page.console_clear
   * Whether a page called called console.clear. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_clear(3157);

  /**
   * generated from use.counter.page.console_count
   * Whether a page called called console.count. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_count(3158);

  /**
   * generated from use.counter.page.console_countreset
   * Whether a page called called console.countReset. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_countreset(3159);

  /**
   * generated from use.counter.page.console_debug
   * Whether a page called called console.debug. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_debug(3160);

  /**
   * generated from use.counter.page.console_dir
   * Whether a page called called console.dir. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_dir(3161);

  /**
   * generated from use.counter.page.console_dirxml
   * Whether a page called called console.dirxml. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_dirxml(3162);

  /**
   * generated from use.counter.page.console_error
   * Whether a page called called console.error. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_error(3163);

  /**
   * generated from use.counter.page.console_exception
   * Whether a page called called console.exception. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_exception(3164);

  /**
   * generated from use.counter.page.console_group
   * Whether a page called called console.group. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_group(3165);

  /**
   * generated from use.counter.page.console_groupcollapsed
   * Whether a page called called console.groupCollapsed. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_groupcollapsed(3166);

  /**
   * generated from use.counter.page.console_groupend
   * Whether a page called called console.groupEnd. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_groupend(3167);

  /**
   * generated from use.counter.page.console_info
   * Whether a page called called console.info. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_info(3168);

  /**
   * generated from use.counter.page.console_log
   * Whether a page called called console.log. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_log(3169);

  /**
   * generated from use.counter.page.console_profile
   * Whether a page called called console.profile. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_profile(3170);

  /**
   * generated from use.counter.page.console_profileend
   * Whether a page called called console.profileEnd. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_profileend(3171);

  /**
   * generated from use.counter.page.console_table
   * Whether a page called called console.table. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_table(3172);

  /**
   * generated from use.counter.page.console_time
   * Whether a page called called console.time. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_time(3173);

  /**
   * generated from use.counter.page.console_timeend
   * Whether a page called called console.timeEnd. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timeend(3174);

  /**
   * generated from use.counter.page.console_timelog
   * Whether a page called called console.timeLog. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timelog(3175);

  /**
   * generated from use.counter.page.console_timestamp
   * Whether a page called called console.timeStamp. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timestamp(3176);

  /**
   * generated from use.counter.page.console_trace
   * Whether a page called called console.trace. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_trace(3177);

  /**
   * generated from use.counter.page.console_warn
   * Whether a page called called console.warn. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_warn(3178);

  /**
   * generated from use.counter.page.cookiestore_delete
   * Whether a page called called CookieStore.delete. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_delete(3179);

  /**
   * generated from use.counter.page.cookiestore_get
   * Whether a page called called CookieStore.get. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_get(3180);

  /**
   * generated from use.counter.page.cookiestore_getall
   * Whether a page called called CookieStore.getAll. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_getall(3181);

  /**
   * generated from use.counter.page.cookiestore_set
   * Whether a page called called CookieStore.set. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_set(3182);

  /**
   * generated from use.counter.page.customelementregistry_define
   * Whether a page called called CustomElementRegistry.define. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> customelementregistry_define(3183);

  /**
   * generated from use.counter.page.customized_builtin
   * Whether a page registers a customized built-in element. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> customized_builtin(3184);

  /**
   * generated from use.counter.page.datatransfer_addelement
   * Whether a page called called DataTransfer.addElement. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_addelement(3185);

  /**
   * generated from use.counter.page.datatransfer_mozcleardataat
   * Whether a page called called DataTransfer.mozClearDataAt. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozcleardataat(3186);

  /**
   * generated from use.counter.page.datatransfer_mozcursor_getter
   * Whether a page got DataTransfer.mozCursor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozcursor_getter(3187);

  /**
   * generated from use.counter.page.datatransfer_mozcursor_setter
   * Whether a page set DataTransfer.mozCursor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozcursor_setter(3188);

  /**
   * generated from use.counter.page.datatransfer_mozgetdataat
   * Whether a page called called DataTransfer.mozGetDataAt. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozgetdataat(3189);

  /**
   * generated from use.counter.page.datatransfer_mozitemcount_getter
   * Whether a page got DataTransfer.mozItemCount. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozitemcount_getter(3190);

  /**
   * generated from use.counter.page.datatransfer_mozitemcount_setter
   * Whether a page set DataTransfer.mozItemCount. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozitemcount_setter(3191);

  /**
   * generated from use.counter.page.datatransfer_mozsetdataat
   * Whether a page called called DataTransfer.mozSetDataAt. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozsetdataat(3192);

  /**
   * generated from use.counter.page.datatransfer_mozsourcenode_getter
   * Whether a page got DataTransfer.mozSourceNode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozsourcenode_getter(3193);

  /**
   * generated from use.counter.page.datatransfer_mozsourcenode_setter
   * Whether a page set DataTransfer.mozSourceNode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozsourcenode_setter(3194);

  /**
   * generated from use.counter.page.datatransfer_moztypesat
   * Whether a page called called DataTransfer.mozTypesAt. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_moztypesat(3195);

  /**
   * generated from use.counter.page.datatransfer_mozusercancelled_getter
   * Whether a page got DataTransfer.mozUserCancelled. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozusercancelled_getter(3196);

  /**
   * generated from use.counter.page.datatransfer_mozusercancelled_setter
   * Whether a page set DataTransfer.mozUserCancelled. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> datatransfer_mozusercancelled_setter(3197);

  /**
   * generated from use.counter.page.document_exec_command_content_read_only
   * Whether a page calls execCommand with contentReadOnly. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_exec_command_content_read_only(3198);

  /**
   * generated from use.counter.page.document_mozsetimageelement
   * Whether a page called called Document.mozSetImageElement. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_mozsetimageelement(3199);

  /**
   * generated from use.counter.page.document_open
   * Whether a page calls document.open in a way that creates a new Window object. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_open(3200);

  /**
   * generated from use.counter.page.document_query_command_state_or_value_content_read_only
   * Whether a page calls queryCommandState or queryCommandValue with contentReadOnly. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_query_command_state_or_value_content_read_only(3201);

  /**
   * generated from use.counter.page.document_query_command_state_or_value_insert_br_on_return
   * Whether a page calls queryCommandState or queryCommandValue with insertBrOnReturn. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_query_command_state_or_value_insert_br_on_return(3202);

  /**
   * generated from use.counter.page.document_query_command_supported_or_enabled_content_read_only
   * Whether a page calls queryCommandSupported or queryCommandEnabled with contentReadOnly. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_query_command_supported_or_enabled_content_read_only(3203);

  /**
   * generated from use.counter.page.document_query_command_supported_or_enabled_insert_br_on_return
   * Whether a page calls queryCommandSupported or queryCommandEnabled with insertBrOnReturn. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> document_query_command_supported_or_enabled_insert_br_on_return(3204);

  /**
   * generated from use.counter.page.domparser_parsefromstring
   * Whether a page called called DOMParser.parseFromString. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> domparser_parsefromstring(3205);

  /**
   * generated from use.counter.page.element_attachshadow
   * Whether a page called called Element.attachShadow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_attachshadow(3206);

  /**
   * generated from use.counter.page.element_releasecapture
   * Whether a page called called Element.releaseCapture. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_releasecapture(3207);

  /**
   * generated from use.counter.page.element_releasepointercapture
   * Whether a page called called Element.releasePointerCapture. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_releasepointercapture(3208);

  /**
   * generated from use.counter.page.element_setcapture
   * Whether a page called called Element.setCapture. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_setcapture(3209);

  /**
   * generated from use.counter.page.element_sethtml
   * Whether a page called called Element.setHTML. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_sethtml(3210);

  /**
   * generated from use.counter.page.element_setpointercapture
   * Whether a page called called Element.setPointerCapture. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_setpointercapture(3211);

  /**
   * generated from use.counter.page.enumerate_devices_insec
   * Whether a page calls MediaDevices.enumerateDevices from an insecure context. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> enumerate_devices_insec(3212);

  /**
   * generated from use.counter.page.enumerate_devices_unfocused
   * Whether a page calls MediaDevices.enumerateDevices from a unfocused document. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> enumerate_devices_unfocused(3213);

  /**
   * generated from use.counter.page.fe_blend
   * Whether a page uses the feBlend SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_blend(3214);

  /**
   * generated from use.counter.page.fe_color_matrix
   * Whether a page uses the feColorMatrix SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_color_matrix(3215);

  /**
   * generated from use.counter.page.fe_component_transfer
   * Whether a page uses the feComponentTransfer SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_component_transfer(3216);

  /**
   * generated from use.counter.page.fe_composite
   * Whether a page uses the feComposite SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_composite(3217);

  /**
   * generated from use.counter.page.fe_convolve_matrix
   * Whether a page uses the feConvolveMatrix SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_convolve_matrix(3218);

  /**
   * generated from use.counter.page.fe_diffuse_lighting
   * Whether a page uses the feDiffuseLighting SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_diffuse_lighting(3219);

  /**
   * generated from use.counter.page.fe_displacement_map
   * Whether a page uses the feDisplacementMap SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_displacement_map(3220);

  /**
   * generated from use.counter.page.fe_flood
   * Whether a page uses the feFlood SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_flood(3221);

  /**
   * generated from use.counter.page.fe_gaussian_blur
   * Whether a page uses the feGaussianBlur SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_gaussian_blur(3222);

  /**
   * generated from use.counter.page.fe_image
   * Whether a page uses the feImage SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_image(3223);

  /**
   * generated from use.counter.page.fe_merge
   * Whether a page uses the feMerge SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_merge(3224);

  /**
   * generated from use.counter.page.fe_morphology
   * Whether a page uses the feMorphology SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_morphology(3225);

  /**
   * generated from use.counter.page.fe_offset
   * Whether a page uses the feOffset SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_offset(3226);

  /**
   * generated from use.counter.page.fe_specular_lighting
   * Whether a page uses the feSpecularLighting SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_specular_lighting(3227);

  /**
   * generated from use.counter.page.fe_tile
   * Whether a page uses the feTile SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_tile(3228);

  /**
   * generated from use.counter.page.fe_turbulence
   * Whether a page uses the feTurbulence SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> fe_turbulence(3229);

  /**
   * generated from use.counter.page.filtered_cross_origin_iframe
   * Whether a page cross-origin <iframe> within a CSS/SVG filter. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> filtered_cross_origin_iframe(3230);

  /**
   * generated from use.counter.page.get_user_media_insec
   * Whether a page calls MediaDevices.getUserMedia from an insecure context. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> get_user_media_insec(3231);

  /**
   * generated from use.counter.page.get_user_media_unfocused
   * Whether a page calls MediaDevices.getUserMedia from an unfocused document. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> get_user_media_unfocused(3232);

  /**
   * generated from use.counter.page.htmldialogelement_show
   * Whether a page called called HTMLDialogElement.show. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldialogelement_show(3233);

  /**
   * generated from use.counter.page.htmldocument_caretrangefrompoint
   * Whether a page called called HTMLDocument.caretRangeFromPoint. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_caretrangefrompoint(3234);

  /**
   * generated from use.counter.page.htmldocument_exitpictureinpicture
   * Whether a page called called HTMLDocument.exitPictureInPicture. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_exitpictureinpicture(3235);

  /**
   * generated from use.counter.page.htmldocument_featurepolicy
   * Whether a page called called HTMLDocument.featurePolicy. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_featurepolicy(3236);

  /**
   * generated from use.counter.page.htmldocument_named_getter_hit
   * Whether a page calls to the named getter on HTMLDocument that find something via the name lookup. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_named_getter_hit(3237);

  /**
   * generated from use.counter.page.htmldocument_onbeforecopy
   * Whether a page called called HTMLDocument.onbeforecopy. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onbeforecopy(3238);

  /**
   * generated from use.counter.page.htmldocument_onbeforecut
   * Whether a page called called HTMLDocument.onbeforecut. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onbeforecut(3239);

  /**
   * generated from use.counter.page.htmldocument_onbeforepaste
   * Whether a page called called HTMLDocument.onbeforepaste. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onbeforepaste(3240);

  /**
   * generated from use.counter.page.htmldocument_oncancel
   * Whether a page called called HTMLDocument.oncancel. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_oncancel(3241);

  /**
   * generated from use.counter.page.htmldocument_onfreeze
   * Whether a page called called HTMLDocument.onfreeze. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onfreeze(3242);

  /**
   * generated from use.counter.page.htmldocument_onmousewheel
   * Whether a page called called HTMLDocument.onmousewheel. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onmousewheel(3243);

  /**
   * generated from use.counter.page.htmldocument_onresume
   * Whether a page called called HTMLDocument.onresume. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onresume(3244);

  /**
   * generated from use.counter.page.htmldocument_onsearch
   * Whether a page called called HTMLDocument.onsearch. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onsearch(3245);

  /**
   * generated from use.counter.page.htmldocument_onwebkitfullscreenchange
   * Whether a page called called HTMLDocument.onwebkitfullscreenchange. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onwebkitfullscreenchange(3246);

  /**
   * generated from use.counter.page.htmldocument_onwebkitfullscreenerror
   * Whether a page called called HTMLDocument.onwebkitfullscreenerror. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_onwebkitfullscreenerror(3247);

  /**
   * generated from use.counter.page.htmldocument_pictureinpictureelement
   * Whether a page called called HTMLDocument.pictureInPictureElement. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_pictureinpictureelement(3248);

  /**
   * generated from use.counter.page.htmldocument_pictureinpictureenabled
   * Whether a page called called HTMLDocument.pictureInPictureEnabled. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_pictureinpictureenabled(3249);

  /**
   * generated from use.counter.page.htmldocument_registerelement
   * Whether a page called called HTMLDocument.registerElement. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_registerelement(3250);

  /**
   * generated from use.counter.page.htmldocument_wasdiscarded
   * Whether a page called called HTMLDocument.wasDiscarded. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_wasdiscarded(3251);

  /**
   * generated from use.counter.page.htmldocument_webkitcancelfullscreen
   * Whether a page called called HTMLDocument.webkitCancelFullScreen. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitcancelfullscreen(3252);

  /**
   * generated from use.counter.page.htmldocument_webkitcurrentfullscreenelement
   * Whether a page called called HTMLDocument.webkitCurrentFullScreenElement. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitcurrentfullscreenelement(3253);

  /**
   * generated from use.counter.page.htmldocument_webkitexitfullscreen
   * Whether a page called called HTMLDocument.webkitExitFullscreen. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitexitfullscreen(3254);

  /**
   * generated from use.counter.page.htmldocument_webkitfullscreenelement
   * Whether a page called called HTMLDocument.webkitFullscreenElement. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitfullscreenelement(3255);

  /**
   * generated from use.counter.page.htmldocument_webkitfullscreenenabled
   * Whether a page called called HTMLDocument.webkitFullscreenEnabled. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitfullscreenenabled(3256);

  /**
   * generated from use.counter.page.htmldocument_webkithidden
   * Whether a page called called HTMLDocument.webkitHidden. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkithidden(3257);

  /**
   * generated from use.counter.page.htmldocument_webkitisfullscreen
   * Whether a page called called HTMLDocument.webkitIsFullScreen. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitisfullscreen(3258);

  /**
   * generated from use.counter.page.htmldocument_webkitvisibilitystate
   * Whether a page called called HTMLDocument.webkitVisibilityState. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_webkitvisibilitystate(3259);

  /**
   * generated from use.counter.page.htmldocument_xmlencoding
   * Whether a page called called HTMLDocument.xmlEncoding. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_xmlencoding(3260);

  /**
   * generated from use.counter.page.htmldocument_xmlstandalone
   * Whether a page called called HTMLDocument.xmlStandalone. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_xmlstandalone(3261);

  /**
   * generated from use.counter.page.htmldocument_xmlversion
   * Whether a page called called HTMLDocument.xmlVersion. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> htmldocument_xmlversion(3262);

  /**
   * generated from use.counter.page.invalid_text_directives
   * Whether a page had a text fragment that could not be found after loading has finished. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> invalid_text_directives(3263);

  /**
   * generated from use.counter.page.js_asmjs
   * Whether a page uses asm.js. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_asmjs(3264);

  /**
   * generated from use.counter.page.js_dateparse
   * Whether a page called Date.parse. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_dateparse(3265);

  /**
   * generated from use.counter.page.js_dateparse_impl_def
   * Whether a page call to Date.parse used implementation defined behaviour. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_dateparse_impl_def(3266);

  /**
   * generated from use.counter.page.js_ic_stub_oom
   * Whether a page OOMed while creating IC stub. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_ic_stub_oom(3267);

  /**
   * generated from use.counter.page.js_ic_stub_too_large
   * Whether a page tried to create an IC stub that was too large. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_ic_stub_too_large(3268);

  /**
   * generated from use.counter.page.js_is_htmldda_fuse
   * Whether a page has used the document.all getter (popping the EmulatesUndefined Fuse). Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_is_htmldda_fuse(3269);

  /**
   * generated from use.counter.page.js_large_oom_recovered
   * Whether a page recovered a large oom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_large_oom_recovered(3270);

  /**
   * generated from use.counter.page.js_large_oom_reported
   * Whether a page reported a large oom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_large_oom_reported(3271);

  /**
   * generated from use.counter.page.js_legacy_lang_subtag
   * Whether a page uses a 5-to-8-character language subtag in Intl.Locale constructor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_legacy_lang_subtag(3272);

  /**
   * generated from use.counter.page.js_optimize_array_species_fuse
   * Whether a page has modified builtin Array objects such that the ArraySpecies fuse is popped. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_optimize_array_species_fuse(3273);

  /**
   * generated from use.counter.page.js_optimize_get_iterator_fuse
   * Whether a page has modified any builtins such that the GetIterator fuse is popped. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_optimize_get_iterator_fuse(3274);

  /**
   * generated from use.counter.page.js_optimize_promise_lookup_fuse
   * Whether a page has modified builtin Promise objects such that the PromiseLookup fuse is popped. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_optimize_promise_lookup_fuse(3275);

  /**
   * generated from use.counter.page.js_small_oom_recovered
   * Whether a page recovered a small oom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_small_oom_recovered(3276);

  /**
   * generated from use.counter.page.js_small_oom_reported
   * Whether a page reported a small oom. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_small_oom_reported(3277);

  /**
   * generated from use.counter.page.js_thenable
   * Whether a page resolved a promise using thenable support rather than builtin methods. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_thenable(3278);

  /**
   * generated from use.counter.page.js_thenable_object_proto
   * Whether a page resolved a promise using thenable on a realms Object.prototype. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_thenable_object_proto(3279);

  /**
   * generated from use.counter.page.js_thenable_proto
   * Whether a page resolved a promise using thenable on prototype. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_thenable_proto(3280);

  /**
   * generated from use.counter.page.js_thenable_standard_proto
   * Whether a page resolved a promise using thenable on a standard prototype. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_thenable_standard_proto(3281);

  /**
   * generated from use.counter.page.js_use_asm
   * Whether a page has instantiated a script containing "use asm" either in the top level or a nested function. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_use_asm(3282);

  /**
   * generated from use.counter.page.js_wasm
   * Whether a page uses WebAssembly. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_wasm(3283);

  /**
   * generated from use.counter.page.js_wasm_legacy_exceptions
   * Whether a page uses WebAssembly legacy exception-handling. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> js_wasm_legacy_exceptions(3284);

  /**
   * generated from use.counter.page.location_ancestororigins
   * Whether a page called called Location.ancestorOrigins. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> location_ancestororigins(3285);

  /**
   * generated from use.counter.page.math_mlused
   * Whether a page has used MathML. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> math_mlused(3286);

  /**
   * generated from use.counter.page.mediadevices_enumeratedevices
   * Whether a page called called MediaDevices.enumerateDevices. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mediadevices_enumeratedevices(3287);

  /**
   * generated from use.counter.page.mediadevices_getdisplaymedia
   * Whether a page called called MediaDevices.getDisplayMedia. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mediadevices_getdisplaymedia(3288);

  /**
   * generated from use.counter.page.mediadevices_getusermedia
   * Whether a page called called MediaDevices.getUserMedia. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mediadevices_getusermedia(3289);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_audio_failure
   * Whether a page includes a mixed content audio element that does not load.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_audio_failure(3290);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_audio_success
   * Whether a page includes a mixed content audio element that loads.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_audio_success(3291);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_image_failure
   * Whether a page includes a mixed content img element that does not load.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_image_failure(3292);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_image_success
   * Whether a page includes a mixed content img element that loads.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_image_success(3293);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_video_failure
   * Whether a page includes a mixed content video element that does not laod.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_video_failure(3294);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_video_success
   * Whether a page includes a mixed content video element that loads.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_not_upgraded_video_success(3295);

  /**
   * generated from use.counter.page.mixed_content_upgraded_audio_failure
   * Whether a page includes a mixed content audio element that does not load.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_audio_failure(3296);

  /**
   * generated from use.counter.page.mixed_content_upgraded_audio_success
   * Whether a page includes a mixed content audio element that loads.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_audio_success(3297);

  /**
   * generated from use.counter.page.mixed_content_upgraded_image_failure
   * Whether a page includes a mixed content img element that does not load.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_image_failure(3298);

  /**
   * generated from use.counter.page.mixed_content_upgraded_image_success
   * Whether a page includes a mixed content img element that loads.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_image_success(3299);

  /**
   * generated from use.counter.page.mixed_content_upgraded_video_failure
   * Whether a page includes a mixed content video element that does not laod.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_video_failure(3300);

  /**
   * generated from use.counter.page.mixed_content_upgraded_video_success
   * Whether a page includes a mixed content video element that loads.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mixed_content_upgraded_video_success(3301);

  /**
   * generated from use.counter.page.mls_deriveexporter
   * Whether a page called called MLS.deriveExporter. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_deriveexporter(3302);

  /**
   * generated from use.counter.page.mls_generatecredentialbasic
   * Whether a page called called MLS.generateCredentialBasic. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatecredentialbasic(3303);

  /**
   * generated from use.counter.page.mls_generatekeypackage
   * Whether a page called called MLS.generateKeyPackage. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatekeypackage(3304);

  /**
   * generated from use.counter.page.mls_generatesignaturekeypair
   * Whether a page called called MLS.generateSignatureKeypair. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatesignaturekeypair(3305);

  /**
   * generated from use.counter.page.mls_groupadd
   * Whether a page called called MLS.groupAdd. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupadd(3306);

  /**
   * generated from use.counter.page.mls_groupclose
   * Whether a page called called MLS.groupClose. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupclose(3307);

  /**
   * generated from use.counter.page.mls_groupcreate
   * Whether a page called called MLS.groupCreate. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupcreate(3308);

  /**
   * generated from use.counter.page.mls_groupjoin
   * Whether a page called called MLS.groupJoin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupjoin(3309);

  /**
   * generated from use.counter.page.mls_groupmembers
   * Whether a page called called MLS.groupMembers. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupmembers(3310);

  /**
   * generated from use.counter.page.mls_groupproposeadd
   * Whether a page called called MLS.groupProposeAdd. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupproposeadd(3311);

  /**
   * generated from use.counter.page.mls_groupproposeremove
   * Whether a page called called MLS.groupProposeRemove. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupproposeremove(3312);

  /**
   * generated from use.counter.page.mls_groupremove
   * Whether a page called called MLS.groupRemove. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupremove(3313);

  /**
   * generated from use.counter.page.mls_receive
   * Whether a page called called MLS.receive. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_receive(3314);

  /**
   * generated from use.counter.page.mls_send
   * Whether a page called called MLS.send. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_send(3315);

  /**
   * generated from use.counter.page.mls_statedelete
   * Whether a page called called MLS.stateDelete. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_statedelete(3316);

  /**
   * generated from use.counter.page.mls_statedeletegroup
   * Whether a page called called MLS.stateDeleteGroup. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_statedeletegroup(3317);

  /**
   * generated from use.counter.page.navigator_mozgetusermedia
   * Whether a page called called Navigator.mozGetUserMedia. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> navigator_mozgetusermedia(3318);

  /**
   * generated from use.counter.page.notificationoptions_actions
   * Whether a page called called NotificationOptions.actions. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_actions(3319);

  /**
   * generated from use.counter.page.notificationoptions_badge
   * Whether a page called called NotificationOptions.badge. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_badge(3320);

  /**
   * generated from use.counter.page.notificationoptions_image
   * Whether a page called called NotificationOptions.image. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_image(3321);

  /**
   * generated from use.counter.page.notificationoptions_navigate
   * Whether a page called called NotificationOptions.navigate. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_navigate(3322);

  /**
   * generated from use.counter.page.notificationoptions_renotify
   * Whether a page called called NotificationOptions.renotify. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_renotify(3323);

  /**
   * generated from use.counter.page.notificationoptions_requireinteraction
   * Whether a page called called NotificationOptions.requireInteraction. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_requireinteraction(3324);

  /**
   * generated from use.counter.page.notificationoptions_timestamp
   * Whether a page called called NotificationOptions.timestamp. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_timestamp(3325);

  /**
   * generated from use.counter.page.notificationoptions_vibrate
   * Whether a page called called NotificationOptions.vibrate. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_vibrate(3326);

  /**
   * generated from use.counter.page.ondommousescroll
   * Whether a page sets DOMMouseScroll event listener. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ondommousescroll(3327);

  /**
   * generated from use.counter.page.onmozmousepixelscroll
   * Whether a page sets MozMousePixelScroll event listener. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> onmozmousepixelscroll(3328);

  /**
   * generated from use.counter.page.percentage_stroke_width_in_svg
   * Whether a page whether percentage stroke-width is used in SVG elements (excluding <text>). Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> percentage_stroke_width_in_svg(3329);

  /**
   * generated from use.counter.page.percentage_stroke_width_in_svgtext
   * Whether a page whether percentage stroke-width is used in SVG <text>. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> percentage_stroke_width_in_svgtext(3330);

  /**
   * generated from use.counter.page.private_browsing_caches_delete
   * Whether a page calls caches.delete in Private Browsing Mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_delete(3331);

  /**
   * generated from use.counter.page.private_browsing_caches_has
   * Whether a page calls caches.has in Private Browsing Mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_has(3332);

  /**
   * generated from use.counter.page.private_browsing_caches_keys
   * Whether a page calls caches.keys in Private Browsing Mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_keys(3333);

  /**
   * generated from use.counter.page.private_browsing_caches_match
   * Whether a page calls caches.match in Private Browsing Mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_match(3334);

  /**
   * generated from use.counter.page.private_browsing_caches_open
   * Whether a page calls caches.open in Private Browsing Mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_open(3335);

  /**
   * generated from use.counter.page.private_browsing_idbfactory_delete_database
   * Whether a page calls indexedDB.deleteDatabase in Private Browsing Mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_idbfactory_delete_database(3336);

  /**
   * generated from use.counter.page.private_browsing_idbfactory_open
   * Whether a page calls indexedDB.open in Private Browsing Mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_idbfactory_open(3337);

  /**
   * generated from use.counter.page.private_browsing_navigator_service_worker
   * Whether a page accesses navigator.serviceWorker in Private Browsing Mode. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_navigator_service_worker(3338);

  /**
   * generated from use.counter.page.pushmanager_subscribe
   * Whether a page called called PushManager.subscribe. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pushmanager_subscribe(3339);

  /**
   * generated from use.counter.page.pushsubscription_unsubscribe
   * Whether a page called called PushSubscription.unsubscribe. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pushsubscription_unsubscribe(3340);

  /**
   * generated from use.counter.page.range_createcontextualfragment
   * Whether a page called called Range.createContextualFragment. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> range_createcontextualfragment(3341);

  /**
   * generated from use.counter.page.sanitizer_constructor
   * Whether a page called called Sanitizer.constructor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> sanitizer_constructor(3342);

  /**
   * generated from use.counter.page.sanitizer_sanitize
   * Whether a page called called Sanitizer.sanitize. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> sanitizer_sanitize(3343);

  /**
   * generated from use.counter.page.scheduler_posttask
   * Whether a page called called Scheduler.postTask. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> scheduler_posttask(3344);

  /**
   * generated from use.counter.page.svgsvgelement_currentscale_getter
   * Whether a page got SVGSVGElement.currentScale. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> svgsvgelement_currentscale_getter(3345);

  /**
   * generated from use.counter.page.svgsvgelement_currentscale_setter
   * Whether a page set SVGSVGElement.currentScale. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> svgsvgelement_currentscale_setter(3346);

  /**
   * generated from use.counter.page.svgsvgelement_getelementbyid
   * Whether a page called called SVGSVGElement.getElementById. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> svgsvgelement_getelementbyid(3347);

  /**
   * generated from use.counter.page.text_directive_not_created
   * Whether a page has not succeeded in creating a text fragment. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> text_directive_not_created(3348);

  /**
   * generated from use.counter.page.text_directive_pages
   * Whether a page used text fragments. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> text_directive_pages(3349);

  /**
   * generated from use.counter.page.webgpu_render_output
   * Whether a page displays WebGPU rendering output. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webgpu_render_output(3350);

  /**
   * generated from use.counter.page.webgpu_request_adapter
   * Whether a page requests a WebGPU adapter. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webgpu_request_adapter(3351);

  /**
   * generated from use.counter.page.window_absoluteorientationsensor
   * Whether a page called called Window.AbsoluteOrientationSensor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_absoluteorientationsensor(3352);

  /**
   * generated from use.counter.page.window_accelerometer
   * Whether a page called called Window.Accelerometer. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_accelerometer(3353);

  /**
   * generated from use.counter.page.window_backgroundfetchmanager
   * Whether a page called called Window.BackgroundFetchManager. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_backgroundfetchmanager(3354);

  /**
   * generated from use.counter.page.window_backgroundfetchrecord
   * Whether a page called called Window.BackgroundFetchRecord. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_backgroundfetchrecord(3355);

  /**
   * generated from use.counter.page.window_backgroundfetchregistration
   * Whether a page called called Window.BackgroundFetchRegistration. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_backgroundfetchregistration(3356);

  /**
   * generated from use.counter.page.window_beforeinstallpromptevent
   * Whether a page called called Window.BeforeInstallPromptEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_beforeinstallpromptevent(3357);

  /**
   * generated from use.counter.page.window_bluetooth
   * Whether a page called called Window.Bluetooth. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetooth(3358);

  /**
   * generated from use.counter.page.window_bluetoothcharacteristicproperties
   * Whether a page called called Window.BluetoothCharacteristicProperties. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothcharacteristicproperties(3359);

  /**
   * generated from use.counter.page.window_bluetoothdevice
   * Whether a page called called Window.BluetoothDevice. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothdevice(3360);

  /**
   * generated from use.counter.page.window_bluetoothremotegattcharacteristic
   * Whether a page called called Window.BluetoothRemoteGATTCharacteristic. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothremotegattcharacteristic(3361);

  /**
   * generated from use.counter.page.window_bluetoothremotegattdescriptor
   * Whether a page called called Window.BluetoothRemoteGATTDescriptor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothremotegattdescriptor(3362);

  /**
   * generated from use.counter.page.window_bluetoothremotegattserver
   * Whether a page called called Window.BluetoothRemoteGATTServer. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothremotegattserver(3363);

  /**
   * generated from use.counter.page.window_bluetoothremotegattservice
   * Whether a page called called Window.BluetoothRemoteGATTService. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothremotegattservice(3364);

  /**
   * generated from use.counter.page.window_bluetoothuuid
   * Whether a page called called Window.BluetoothUUID. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_bluetoothuuid(3365);

  /**
   * generated from use.counter.page.window_canvascapturemediastreamtrack
   * Whether a page called called Window.CanvasCaptureMediaStreamTrack. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_canvascapturemediastreamtrack(3366);

  /**
   * generated from use.counter.page.window_chrome
   * Whether a page called called Window.chrome. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_chrome(3367);

  /**
   * generated from use.counter.page.window_clipboarditem
   * Whether a page called called Window.ClipboardItem. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_clipboarditem(3368);

  /**
   * generated from use.counter.page.window_cssimagevalue
   * Whether a page called called Window.CSSImageValue. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssimagevalue(3369);

  /**
   * generated from use.counter.page.window_csskeywordvalue
   * Whether a page called called Window.CSSKeywordValue. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csskeywordvalue(3370);

  /**
   * generated from use.counter.page.window_cssmathclamp
   * Whether a page called called Window.CSSMathClamp. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathclamp(3371);

  /**
   * generated from use.counter.page.window_cssmathinvert
   * Whether a page called called Window.CSSMathInvert. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathinvert(3372);

  /**
   * generated from use.counter.page.window_cssmathmax
   * Whether a page called called Window.CSSMathMax. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathmax(3373);

  /**
   * generated from use.counter.page.window_cssmathmin
   * Whether a page called called Window.CSSMathMin. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathmin(3374);

  /**
   * generated from use.counter.page.window_cssmathnegate
   * Whether a page called called Window.CSSMathNegate. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathnegate(3375);

  /**
   * generated from use.counter.page.window_cssmathproduct
   * Whether a page called called Window.CSSMathProduct. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathproduct(3376);

  /**
   * generated from use.counter.page.window_cssmathsum
   * Whether a page called called Window.CSSMathSum. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathsum(3377);

  /**
   * generated from use.counter.page.window_cssmathvalue
   * Whether a page called called Window.CSSMathValue. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmathvalue(3378);

  /**
   * generated from use.counter.page.window_cssmatrixcomponent
   * Whether a page called called Window.CSSMatrixComponent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssmatrixcomponent(3379);

  /**
   * generated from use.counter.page.window_cssnumericarray
   * Whether a page called called Window.CSSNumericArray. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssnumericarray(3380);

  /**
   * generated from use.counter.page.window_cssnumericvalue
   * Whether a page called called Window.CSSNumericValue. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssnumericvalue(3381);

  /**
   * generated from use.counter.page.window_cssperspective
   * Whether a page called called Window.CSSPerspective. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssperspective(3382);

  /**
   * generated from use.counter.page.window_csspositionvalue
   * Whether a page called called Window.CSSPositionValue. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csspositionvalue(3383);

  /**
   * generated from use.counter.page.window_csspropertyrule
   * Whether a page called called Window.CSSPropertyRule. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csspropertyrule(3384);

  /**
   * generated from use.counter.page.window_cssrotate
   * Whether a page called called Window.CSSRotate. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssrotate(3385);

  /**
   * generated from use.counter.page.window_cssscale
   * Whether a page called called Window.CSSScale. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssscale(3386);

  /**
   * generated from use.counter.page.window_cssskew
   * Whether a page called called Window.CSSSkew. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssskew(3387);

  /**
   * generated from use.counter.page.window_cssskewx
   * Whether a page called called Window.CSSSkewX. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssskewx(3388);

  /**
   * generated from use.counter.page.window_cssskewy
   * Whether a page called called Window.CSSSkewY. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssskewy(3389);

  /**
   * generated from use.counter.page.window_cssstylevalue
   * Whether a page called called Window.CSSStyleValue. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssstylevalue(3390);

  /**
   * generated from use.counter.page.window_csstransformcomponent
   * Whether a page called called Window.CSSTransformComponent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csstransformcomponent(3391);

  /**
   * generated from use.counter.page.window_csstransformvalue
   * Whether a page called called Window.CSSTransformValue. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csstransformvalue(3392);

  /**
   * generated from use.counter.page.window_csstranslate
   * Whether a page called called Window.CSSTranslate. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_csstranslate(3393);

  /**
   * generated from use.counter.page.window_cssunitvalue
   * Whether a page called called Window.CSSUnitValue. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssunitvalue(3394);

  /**
   * generated from use.counter.page.window_cssunparsedvalue
   * Whether a page called called Window.CSSUnparsedValue. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssunparsedvalue(3395);

  /**
   * generated from use.counter.page.window_cssvariablereferencevalue
   * Whether a page called called Window.CSSVariableReferenceValue. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_cssvariablereferencevalue(3396);

  /**
   * generated from use.counter.page.window_defaultstatus
   * Whether a page called called Window.defaultStatus. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_defaultstatus(3397);

  /**
   * generated from use.counter.page.window_devicemotioneventacceleration
   * Whether a page called called Window.DeviceMotionEventAcceleration. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_devicemotioneventacceleration(3398);

  /**
   * generated from use.counter.page.window_devicemotioneventrotationrate
   * Whether a page called called Window.DeviceMotionEventRotationRate. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_devicemotioneventrotationrate(3399);

  /**
   * generated from use.counter.page.window_domerror
   * Whether a page called called Window.DOMError. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_domerror(3400);

  /**
   * generated from use.counter.page.window_encodedvideochunk
   * Whether a page called called Window.EncodedVideoChunk. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_encodedvideochunk(3401);

  /**
   * generated from use.counter.page.window_enterpictureinpictureevent
   * Whether a page called called Window.EnterPictureInPictureEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_enterpictureinpictureevent(3402);

  /**
   * generated from use.counter.page.window_external
   * Whether a page called called Window.External. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_external(3403);

  /**
   * generated from use.counter.page.window_federatedcredential
   * Whether a page called called Window.FederatedCredential. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_federatedcredential(3404);

  /**
   * generated from use.counter.page.window_gyroscope
   * Whether a page called called Window.Gyroscope. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_gyroscope(3405);

  /**
   * generated from use.counter.page.window_htmlcontentelement
   * Whether a page called called Window.HTMLContentElement. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_htmlcontentelement(3406);

  /**
   * generated from use.counter.page.window_htmlshadowelement
   * Whether a page called called Window.HTMLShadowElement. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_htmlshadowelement(3407);

  /**
   * generated from use.counter.page.window_imagecapture
   * Whether a page called called Window.ImageCapture. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_imagecapture(3408);

  /**
   * generated from use.counter.page.window_inputdevicecapabilities
   * Whether a page called called Window.InputDeviceCapabilities. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_inputdevicecapabilities(3409);

  /**
   * generated from use.counter.page.window_inputdeviceinfo
   * Whether a page called called Window.InputDeviceInfo. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_inputdeviceinfo(3410);

  /**
   * generated from use.counter.page.window_keyboard
   * Whether a page called called Window.Keyboard. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_keyboard(3411);

  /**
   * generated from use.counter.page.window_keyboardlayoutmap
   * Whether a page called called Window.KeyboardLayoutMap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_keyboardlayoutmap(3412);

  /**
   * generated from use.counter.page.window_linearaccelerationsensor
   * Whether a page called called Window.LinearAccelerationSensor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_linearaccelerationsensor(3413);

  /**
   * generated from use.counter.page.window_mediasettingsrange
   * Whether a page called called Window.MediaSettingsRange. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_mediasettingsrange(3414);

  /**
   * generated from use.counter.page.window_midiaccess
   * Whether a page called called Window.MIDIAccess. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midiaccess(3415);

  /**
   * generated from use.counter.page.window_midiconnectionevent
   * Whether a page called called Window.MIDIConnectionEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midiconnectionevent(3416);

  /**
   * generated from use.counter.page.window_midiinput
   * Whether a page called called Window.MIDIInput. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midiinput(3417);

  /**
   * generated from use.counter.page.window_midiinputmap
   * Whether a page called called Window.MIDIInputMap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midiinputmap(3418);

  /**
   * generated from use.counter.page.window_midimessageevent
   * Whether a page called called Window.MIDIMessageEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midimessageevent(3419);

  /**
   * generated from use.counter.page.window_midioutput
   * Whether a page called called Window.MIDIOutput. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midioutput(3420);

  /**
   * generated from use.counter.page.window_midioutputmap
   * Whether a page called called Window.MIDIOutputMap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midioutputmap(3421);

  /**
   * generated from use.counter.page.window_midiport
   * Whether a page called called Window.MIDIPort. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_midiport(3422);

  /**
   * generated from use.counter.page.window_networkinformation
   * Whether a page called called Window.NetworkInformation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_networkinformation(3423);

  /**
   * generated from use.counter.page.window_offscreenbuffering
   * Whether a page called called Window.offscreenBuffering. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_offscreenbuffering(3424);

  /**
   * generated from use.counter.page.window_onbeforeinstallprompt
   * Whether a page called called Window.onbeforeinstallprompt. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_onbeforeinstallprompt(3425);

  /**
   * generated from use.counter.page.window_oncancel
   * Whether a page called called Window.oncancel. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_oncancel(3426);

  /**
   * generated from use.counter.page.window_onmousewheel
   * Whether a page called called Window.onmousewheel. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_onmousewheel(3427);

  /**
   * generated from use.counter.page.window_onorientationchange
   * Whether a page called called Window.onorientationchange. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_onorientationchange(3428);

  /**
   * generated from use.counter.page.window_onsearch
   * Whether a page called called Window.onsearch. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_onsearch(3429);

  /**
   * generated from use.counter.page.window_onselectionchange
   * Whether a page called called Window.onselectionchange. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_onselectionchange(3430);

  /**
   * generated from use.counter.page.window_open_empty_url
   * Whether a page calls window.open with an empty url argument. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_open_empty_url(3431);

  /**
   * generated from use.counter.page.window_opendatabase
   * Whether a page called called Window.openDatabase. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_opendatabase(3432);

  /**
   * generated from use.counter.page.window_orientation
   * Whether a page called called Window.orientation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_orientation(3433);

  /**
   * generated from use.counter.page.window_orientationsensor
   * Whether a page called called Window.OrientationSensor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_orientationsensor(3434);

  /**
   * generated from use.counter.page.window_overconstrainederror
   * Whether a page called called Window.OverconstrainedError. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_overconstrainederror(3435);

  /**
   * generated from use.counter.page.window_passwordcredential
   * Whether a page called called Window.PasswordCredential. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_passwordcredential(3436);

  /**
   * generated from use.counter.page.window_paymentaddress
   * Whether a page called called Window.PaymentAddress. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentaddress(3437);

  /**
   * generated from use.counter.page.window_paymentinstruments
   * Whether a page called called Window.PaymentInstruments. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentinstruments(3438);

  /**
   * generated from use.counter.page.window_paymentmanager
   * Whether a page called called Window.PaymentManager. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentmanager(3439);

  /**
   * generated from use.counter.page.window_paymentmethodchangeevent
   * Whether a page called called Window.PaymentMethodChangeEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentmethodchangeevent(3440);

  /**
   * generated from use.counter.page.window_paymentrequest
   * Whether a page called called Window.PaymentRequest. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentrequest(3441);

  /**
   * generated from use.counter.page.window_paymentrequestupdateevent
   * Whether a page called called Window.PaymentRequestUpdateEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentrequestupdateevent(3442);

  /**
   * generated from use.counter.page.window_paymentresponse
   * Whether a page called called Window.PaymentResponse. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_paymentresponse(3443);

  /**
   * generated from use.counter.page.window_performancelongtasktiming
   * Whether a page called called Window.PerformanceLongTaskTiming. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_performancelongtasktiming(3444);

  /**
   * generated from use.counter.page.window_photocapabilities
   * Whether a page called called Window.PhotoCapabilities. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_photocapabilities(3445);

  /**
   * generated from use.counter.page.window_pictureinpictureevent
   * Whether a page called called Window.PictureInPictureEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_pictureinpictureevent(3446);

  /**
   * generated from use.counter.page.window_pictureinpicturewindow
   * Whether a page called called Window.PictureInPictureWindow. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_pictureinpicturewindow(3447);

  /**
   * generated from use.counter.page.window_presentation
   * Whether a page called called Window.Presentation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentation(3448);

  /**
   * generated from use.counter.page.window_presentationavailability
   * Whether a page called called Window.PresentationAvailability. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationavailability(3449);

  /**
   * generated from use.counter.page.window_presentationconnection
   * Whether a page called called Window.PresentationConnection. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationconnection(3450);

  /**
   * generated from use.counter.page.window_presentationconnectionavailableevent
   * Whether a page called called Window.PresentationConnectionAvailableEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationconnectionavailableevent(3451);

  /**
   * generated from use.counter.page.window_presentationconnectioncloseevent
   * Whether a page called called Window.PresentationConnectionCloseEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationconnectioncloseevent(3452);

  /**
   * generated from use.counter.page.window_presentationconnectionlist
   * Whether a page called called Window.PresentationConnectionList. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationconnectionlist(3453);

  /**
   * generated from use.counter.page.window_presentationreceiver
   * Whether a page called called Window.PresentationReceiver. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationreceiver(3454);

  /**
   * generated from use.counter.page.window_presentationrequest
   * Whether a page called called Window.PresentationRequest. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_presentationrequest(3455);

  /**
   * generated from use.counter.page.window_relativeorientationsensor
   * Whether a page called called Window.RelativeOrientationSensor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_relativeorientationsensor(3456);

  /**
   * generated from use.counter.page.window_remoteplayback
   * Whether a page called called Window.RemotePlayback. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_remoteplayback(3457);

  /**
   * generated from use.counter.page.window_report
   * Whether a page called called Window.Report. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_report(3458);

  /**
   * generated from use.counter.page.window_reportbody
   * Whether a page called called Window.ReportBody. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_reportbody(3459);

  /**
   * generated from use.counter.page.window_reportingobserver
   * Whether a page called called Window.ReportingObserver. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_reportingobserver(3460);

  /**
   * generated from use.counter.page.window_rtcerror
   * Whether a page called called Window.RTCError. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_rtcerror(3461);

  /**
   * generated from use.counter.page.window_rtcerrorevent
   * Whether a page called called Window.RTCErrorEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_rtcerrorevent(3462);

  /**
   * generated from use.counter.page.window_rtcicetransport
   * Whether a page called called Window.RTCIceTransport. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_rtcicetransport(3463);

  /**
   * generated from use.counter.page.window_rtcpeerconnectioniceerrorevent
   * Whether a page called called Window.RTCPeerConnectionIceErrorEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_rtcpeerconnectioniceerrorevent(3464);

  /**
   * generated from use.counter.page.window_sensor
   * Whether a page called called Window.Sensor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_sensor(3465);

  /**
   * generated from use.counter.page.window_sensorerrorevent
   * Whether a page called called Window.SensorErrorEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_sensorerrorevent(3466);

  /**
   * generated from use.counter.page.window_sidebar_getter
   * Whether a page got Window.sidebar. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_sidebar_getter(3467);

  /**
   * generated from use.counter.page.window_sidebar_setter
   * Whether a page set Window.sidebar. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_sidebar_setter(3468);

  /**
   * generated from use.counter.page.window_speechrecognitionalternative
   * Whether a page called called Window.SpeechRecognitionAlternative. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_speechrecognitionalternative(3469);

  /**
   * generated from use.counter.page.window_speechrecognitionresult
   * Whether a page called called Window.SpeechRecognitionResult. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_speechrecognitionresult(3470);

  /**
   * generated from use.counter.page.window_speechrecognitionresultlist
   * Whether a page called called Window.SpeechRecognitionResultList. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_speechrecognitionresultlist(3471);

  /**
   * generated from use.counter.page.window_stylemedia
   * Whether a page called called Window.styleMedia. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_stylemedia(3472);

  /**
   * generated from use.counter.page.window_stylepropertymap
   * Whether a page called called Window.StylePropertyMap. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_stylepropertymap(3473);

  /**
   * generated from use.counter.page.window_stylepropertymapreadonly
   * Whether a page called called Window.StylePropertyMapReadOnly. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_stylepropertymapreadonly(3474);

  /**
   * generated from use.counter.page.window_svgdiscardelement
   * Whether a page called called Window.SVGDiscardElement. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_svgdiscardelement(3475);

  /**
   * generated from use.counter.page.window_syncmanager
   * Whether a page called called Window.SyncManager. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_syncmanager(3476);

  /**
   * generated from use.counter.page.window_taskattributiontiming
   * Whether a page called called Window.TaskAttributionTiming. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_taskattributiontiming(3477);

  /**
   * generated from use.counter.page.window_textevent
   * Whether a page called called Window.TextEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_textevent(3478);

  /**
   * generated from use.counter.page.window_touch
   * Whether a page called called Window.Touch. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_touch(3479);

  /**
   * generated from use.counter.page.window_touchevent
   * Whether a page called called Window.TouchEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_touchevent(3480);

  /**
   * generated from use.counter.page.window_touchlist
   * Whether a page called called Window.TouchList. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_touchlist(3481);

  /**
   * generated from use.counter.page.window_usb
   * Whether a page called called Window.USB. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usb(3482);

  /**
   * generated from use.counter.page.window_usbalternateinterface
   * Whether a page called called Window.USBAlternateInterface. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbalternateinterface(3483);

  /**
   * generated from use.counter.page.window_usbconfiguration
   * Whether a page called called Window.USBConfiguration. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbconfiguration(3484);

  /**
   * generated from use.counter.page.window_usbconnectionevent
   * Whether a page called called Window.USBConnectionEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbconnectionevent(3485);

  /**
   * generated from use.counter.page.window_usbdevice
   * Whether a page called called Window.USBDevice. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbdevice(3486);

  /**
   * generated from use.counter.page.window_usbendpoint
   * Whether a page called called Window.USBEndpoint. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbendpoint(3487);

  /**
   * generated from use.counter.page.window_usbinterface
   * Whether a page called called Window.USBInterface. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbinterface(3488);

  /**
   * generated from use.counter.page.window_usbintransferresult
   * Whether a page called called Window.USBInTransferResult. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbintransferresult(3489);

  /**
   * generated from use.counter.page.window_usbisochronousintransferpacket
   * Whether a page called called Window.USBIsochronousInTransferPacket. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbisochronousintransferpacket(3490);

  /**
   * generated from use.counter.page.window_usbisochronousintransferresult
   * Whether a page called called Window.USBIsochronousInTransferResult. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbisochronousintransferresult(3491);

  /**
   * generated from use.counter.page.window_usbisochronousouttransferpacket
   * Whether a page called called Window.USBIsochronousOutTransferPacket. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbisochronousouttransferpacket(3492);

  /**
   * generated from use.counter.page.window_usbisochronousouttransferresult
   * Whether a page called called Window.USBIsochronousOutTransferResult. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbisochronousouttransferresult(3493);

  /**
   * generated from use.counter.page.window_usbouttransferresult
   * Whether a page called called Window.USBOutTransferResult. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_usbouttransferresult(3494);

  /**
   * generated from use.counter.page.window_useractivation
   * Whether a page called called Window.UserActivation. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_useractivation(3495);

  /**
   * generated from use.counter.page.window_videocolorspace
   * Whether a page called called Window.VideoColorSpace. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_videocolorspace(3496);

  /**
   * generated from use.counter.page.window_videodecoder
   * Whether a page called called Window.VideoDecoder. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_videodecoder(3497);

  /**
   * generated from use.counter.page.window_videoencoder
   * Whether a page called called Window.VideoEncoder. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_videoencoder(3498);

  /**
   * generated from use.counter.page.window_videoframe
   * Whether a page called called Window.VideoFrame. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_videoframe(3499);

  /**
   * generated from use.counter.page.window_wakelock
   * Whether a page called called Window.WakeLock. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_wakelock(3500);

  /**
   * generated from use.counter.page.window_wakelocksentinel
   * Whether a page called called Window.WakeLockSentinel. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_wakelocksentinel(3501);

  /**
   * generated from use.counter.page.window_webkitcancelanimationframe
   * Whether a page called called Window.webkitCancelAnimationFrame. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitcancelanimationframe(3502);

  /**
   * generated from use.counter.page.window_webkitmediastream
   * Whether a page called called Window.webkitMediaStream. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitmediastream(3503);

  /**
   * generated from use.counter.page.window_webkitmutationobserver
   * Whether a page called called Window.WebKitMutationObserver. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitmutationobserver(3504);

  /**
   * generated from use.counter.page.window_webkitrequestanimationframe
   * Whether a page called called Window.webkitRequestAnimationFrame. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitrequestanimationframe(3505);

  /**
   * generated from use.counter.page.window_webkitrequestfilesystem
   * Whether a page called called Window.webkitRequestFileSystem. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitrequestfilesystem(3506);

  /**
   * generated from use.counter.page.window_webkitresolvelocalfilesystemurl
   * Whether a page called called Window.webkitResolveLocalFileSystemURL. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitresolvelocalfilesystemurl(3507);

  /**
   * generated from use.counter.page.window_webkitrtcpeerconnection
   * Whether a page called called Window.webkitRTCPeerConnection. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitrtcpeerconnection(3508);

  /**
   * generated from use.counter.page.window_webkitspeechgrammar
   * Whether a page called called Window.webkitSpeechGrammar. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitspeechgrammar(3509);

  /**
   * generated from use.counter.page.window_webkitspeechgrammarlist
   * Whether a page called called Window.webkitSpeechGrammarList. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitspeechgrammarlist(3510);

  /**
   * generated from use.counter.page.window_webkitspeechrecognition
   * Whether a page called called Window.webkitSpeechRecognition. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitspeechrecognition(3511);

  /**
   * generated from use.counter.page.window_webkitspeechrecognitionerror
   * Whether a page called called Window.webkitSpeechRecognitionError. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitspeechrecognitionerror(3512);

  /**
   * generated from use.counter.page.window_webkitspeechrecognitionevent
   * Whether a page called called Window.webkitSpeechRecognitionEvent. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitspeechrecognitionevent(3513);

  /**
   * generated from use.counter.page.window_webkitstorageinfo
   * Whether a page called called Window.webkitStorageInfo. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> window_webkitstorageinfo(3514);

  /**
   * generated from use.counter.page.wr_filter_fallback
   * Whether a page triggers the blob fallback for an SVG filter.. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> wr_filter_fallback(3515);

  /**
   * generated from use.counter.page.xslstylesheet
   * Whether a page uses an XSL Stylesheet. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> xslstylesheet(3516);

  /**
   * generated from use.counter.page.xsltprocessor_constructor
   * Whether a page called called XSLTProcessor.constructor. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> xsltprocessor_constructor(3517);

  /**
   * generated from use.counter.page.you_tube_flash_embed
   * Whether a page in <object> or <embed>. Compare against `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> you_tube_flash_embed(3518);
}

namespace use_counter_worker_dedicated {
  /**
   * generated from use.counter.worker.dedicated.console_assert
   * Whether a dedicated worker called called console.assert. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_assert(3519);

  /**
   * generated from use.counter.worker.dedicated.console_clear
   * Whether a dedicated worker called called console.clear. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_clear(3520);

  /**
   * generated from use.counter.worker.dedicated.console_count
   * Whether a dedicated worker called called console.count. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_count(3521);

  /**
   * generated from use.counter.worker.dedicated.console_countreset
   * Whether a dedicated worker called called console.countReset. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_countreset(3522);

  /**
   * generated from use.counter.worker.dedicated.console_debug
   * Whether a dedicated worker called called console.debug. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_debug(3523);

  /**
   * generated from use.counter.worker.dedicated.console_dir
   * Whether a dedicated worker called called console.dir. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_dir(3524);

  /**
   * generated from use.counter.worker.dedicated.console_dirxml
   * Whether a dedicated worker called called console.dirxml. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_dirxml(3525);

  /**
   * generated from use.counter.worker.dedicated.console_error
   * Whether a dedicated worker called called console.error. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_error(3526);

  /**
   * generated from use.counter.worker.dedicated.console_exception
   * Whether a dedicated worker called called console.exception. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_exception(3527);

  /**
   * generated from use.counter.worker.dedicated.console_group
   * Whether a dedicated worker called called console.group. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_group(3528);

  /**
   * generated from use.counter.worker.dedicated.console_groupcollapsed
   * Whether a dedicated worker called called console.groupCollapsed. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_groupcollapsed(3529);

  /**
   * generated from use.counter.worker.dedicated.console_groupend
   * Whether a dedicated worker called called console.groupEnd. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_groupend(3530);

  /**
   * generated from use.counter.worker.dedicated.console_info
   * Whether a dedicated worker called called console.info. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_info(3531);

  /**
   * generated from use.counter.worker.dedicated.console_log
   * Whether a dedicated worker called called console.log. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_log(3532);

  /**
   * generated from use.counter.worker.dedicated.console_profile
   * Whether a dedicated worker called called console.profile. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_profile(3533);

  /**
   * generated from use.counter.worker.dedicated.console_profileend
   * Whether a dedicated worker called called console.profileEnd. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_profileend(3534);

  /**
   * generated from use.counter.worker.dedicated.console_table
   * Whether a dedicated worker called called console.table. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_table(3535);

  /**
   * generated from use.counter.worker.dedicated.console_time
   * Whether a dedicated worker called called console.time. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_time(3536);

  /**
   * generated from use.counter.worker.dedicated.console_timeend
   * Whether a dedicated worker called called console.timeEnd. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timeend(3537);

  /**
   * generated from use.counter.worker.dedicated.console_timelog
   * Whether a dedicated worker called called console.timeLog. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timelog(3538);

  /**
   * generated from use.counter.worker.dedicated.console_timestamp
   * Whether a dedicated worker called called console.timeStamp. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timestamp(3539);

  /**
   * generated from use.counter.worker.dedicated.console_trace
   * Whether a dedicated worker called called console.trace. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_trace(3540);

  /**
   * generated from use.counter.worker.dedicated.console_warn
   * Whether a dedicated worker called called console.warn. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_warn(3541);

  /**
   * generated from use.counter.worker.dedicated.cookiestore_delete
   * Whether a dedicated worker called called CookieStore.delete. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_delete(3542);

  /**
   * generated from use.counter.worker.dedicated.cookiestore_get
   * Whether a dedicated worker called called CookieStore.get. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_get(3543);

  /**
   * generated from use.counter.worker.dedicated.cookiestore_getall
   * Whether a dedicated worker called called CookieStore.getAll. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_getall(3544);

  /**
   * generated from use.counter.worker.dedicated.cookiestore_set
   * Whether a dedicated worker called called CookieStore.set. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_set(3545);

  /**
   * generated from use.counter.worker.dedicated.mls_deriveexporter
   * Whether a dedicated worker called called MLS.deriveExporter. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_deriveexporter(3546);

  /**
   * generated from use.counter.worker.dedicated.mls_generatecredentialbasic
   * Whether a dedicated worker called called MLS.generateCredentialBasic. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatecredentialbasic(3547);

  /**
   * generated from use.counter.worker.dedicated.mls_generatekeypackage
   * Whether a dedicated worker called called MLS.generateKeyPackage. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatekeypackage(3548);

  /**
   * generated from use.counter.worker.dedicated.mls_generatesignaturekeypair
   * Whether a dedicated worker called called MLS.generateSignatureKeypair. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatesignaturekeypair(3549);

  /**
   * generated from use.counter.worker.dedicated.mls_groupadd
   * Whether a dedicated worker called called MLS.groupAdd. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupadd(3550);

  /**
   * generated from use.counter.worker.dedicated.mls_groupclose
   * Whether a dedicated worker called called MLS.groupClose. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupclose(3551);

  /**
   * generated from use.counter.worker.dedicated.mls_groupcreate
   * Whether a dedicated worker called called MLS.groupCreate. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupcreate(3552);

  /**
   * generated from use.counter.worker.dedicated.mls_groupjoin
   * Whether a dedicated worker called called MLS.groupJoin. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupjoin(3553);

  /**
   * generated from use.counter.worker.dedicated.mls_groupmembers
   * Whether a dedicated worker called called MLS.groupMembers. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupmembers(3554);

  /**
   * generated from use.counter.worker.dedicated.mls_groupproposeadd
   * Whether a dedicated worker called called MLS.groupProposeAdd. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupproposeadd(3555);

  /**
   * generated from use.counter.worker.dedicated.mls_groupproposeremove
   * Whether a dedicated worker called called MLS.groupProposeRemove. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupproposeremove(3556);

  /**
   * generated from use.counter.worker.dedicated.mls_groupremove
   * Whether a dedicated worker called called MLS.groupRemove. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupremove(3557);

  /**
   * generated from use.counter.worker.dedicated.mls_receive
   * Whether a dedicated worker called called MLS.receive. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_receive(3558);

  /**
   * generated from use.counter.worker.dedicated.mls_send
   * Whether a dedicated worker called called MLS.send. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_send(3559);

  /**
   * generated from use.counter.worker.dedicated.mls_statedelete
   * Whether a dedicated worker called called MLS.stateDelete. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_statedelete(3560);

  /**
   * generated from use.counter.worker.dedicated.mls_statedeletegroup
   * Whether a dedicated worker called called MLS.stateDeleteGroup. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_statedeletegroup(3561);

  /**
   * generated from use.counter.worker.dedicated.notificationoptions_actions
   * Whether a dedicated worker called called NotificationOptions.actions. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_actions(3562);

  /**
   * generated from use.counter.worker.dedicated.notificationoptions_badge
   * Whether a dedicated worker called called NotificationOptions.badge. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_badge(3563);

  /**
   * generated from use.counter.worker.dedicated.notificationoptions_image
   * Whether a dedicated worker called called NotificationOptions.image. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_image(3564);

  /**
   * generated from use.counter.worker.dedicated.notificationoptions_navigate
   * Whether a dedicated worker called called NotificationOptions.navigate. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_navigate(3565);

  /**
   * generated from use.counter.worker.dedicated.notificationoptions_renotify
   * Whether a dedicated worker called called NotificationOptions.renotify. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_renotify(3566);

  /**
   * generated from use.counter.worker.dedicated.notificationoptions_requireinteraction
   * Whether a dedicated worker called called NotificationOptions.requireInteraction. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_requireinteraction(3567);

  /**
   * generated from use.counter.worker.dedicated.notificationoptions_timestamp
   * Whether a dedicated worker called called NotificationOptions.timestamp. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_timestamp(3568);

  /**
   * generated from use.counter.worker.dedicated.notificationoptions_vibrate
   * Whether a dedicated worker called called NotificationOptions.vibrate. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_vibrate(3569);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_caches_delete
   * Whether a dedicated worker calls caches.delete in Private Browsing Mode. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_delete(3570);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_caches_has
   * Whether a dedicated worker calls caches.has in Private Browsing Mode. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_has(3571);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_caches_keys
   * Whether a dedicated worker calls caches.keys in Private Browsing Mode. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_keys(3572);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_caches_match
   * Whether a dedicated worker calls caches.match in Private Browsing Mode. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_match(3573);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_caches_open
   * Whether a dedicated worker calls caches.open in Private Browsing Mode. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_open(3574);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_idbfactory_delete_database
   * Whether a dedicated worker calls indexedDB.deleteDatabase in Private Browsing Mode. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_idbfactory_delete_database(3575);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_idbfactory_open
   * Whether a dedicated worker calls indexedDB.open in Private Browsing Mode. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_idbfactory_open(3576);

  /**
   * generated from use.counter.worker.dedicated.pushmanager_subscribe
   * Whether a dedicated worker called called PushManager.subscribe. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pushmanager_subscribe(3577);

  /**
   * generated from use.counter.worker.dedicated.pushsubscription_unsubscribe
   * Whether a dedicated worker called called PushSubscription.unsubscribe. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pushsubscription_unsubscribe(3578);

  /**
   * generated from use.counter.worker.dedicated.scheduler_posttask
   * Whether a dedicated worker called called Scheduler.postTask. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> scheduler_posttask(3579);

  /**
   * generated from use.counter.worker.dedicated.webgpu_request_adapter
   * Whether a dedicated worker requests a WebGPU adapter. Compare against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webgpu_request_adapter(3580);
}

namespace use_counter_worker_service {
  /**
   * generated from use.counter.worker.service.console_assert
   * Whether a service worker called called console.assert. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_assert(3581);

  /**
   * generated from use.counter.worker.service.console_clear
   * Whether a service worker called called console.clear. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_clear(3582);

  /**
   * generated from use.counter.worker.service.console_count
   * Whether a service worker called called console.count. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_count(3583);

  /**
   * generated from use.counter.worker.service.console_countreset
   * Whether a service worker called called console.countReset. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_countreset(3584);

  /**
   * generated from use.counter.worker.service.console_debug
   * Whether a service worker called called console.debug. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_debug(3585);

  /**
   * generated from use.counter.worker.service.console_dir
   * Whether a service worker called called console.dir. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_dir(3586);

  /**
   * generated from use.counter.worker.service.console_dirxml
   * Whether a service worker called called console.dirxml. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_dirxml(3587);

  /**
   * generated from use.counter.worker.service.console_error
   * Whether a service worker called called console.error. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_error(3588);

  /**
   * generated from use.counter.worker.service.console_exception
   * Whether a service worker called called console.exception. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_exception(3589);

  /**
   * generated from use.counter.worker.service.console_group
   * Whether a service worker called called console.group. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_group(3590);

  /**
   * generated from use.counter.worker.service.console_groupcollapsed
   * Whether a service worker called called console.groupCollapsed. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_groupcollapsed(3591);

  /**
   * generated from use.counter.worker.service.console_groupend
   * Whether a service worker called called console.groupEnd. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_groupend(3592);

  /**
   * generated from use.counter.worker.service.console_info
   * Whether a service worker called called console.info. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_info(3593);

  /**
   * generated from use.counter.worker.service.console_log
   * Whether a service worker called called console.log. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_log(3594);

  /**
   * generated from use.counter.worker.service.console_profile
   * Whether a service worker called called console.profile. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_profile(3595);

  /**
   * generated from use.counter.worker.service.console_profileend
   * Whether a service worker called called console.profileEnd. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_profileend(3596);

  /**
   * generated from use.counter.worker.service.console_table
   * Whether a service worker called called console.table. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_table(3597);

  /**
   * generated from use.counter.worker.service.console_time
   * Whether a service worker called called console.time. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_time(3598);

  /**
   * generated from use.counter.worker.service.console_timeend
   * Whether a service worker called called console.timeEnd. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timeend(3599);

  /**
   * generated from use.counter.worker.service.console_timelog
   * Whether a service worker called called console.timeLog. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timelog(3600);

  /**
   * generated from use.counter.worker.service.console_timestamp
   * Whether a service worker called called console.timeStamp. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timestamp(3601);

  /**
   * generated from use.counter.worker.service.console_trace
   * Whether a service worker called called console.trace. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_trace(3602);

  /**
   * generated from use.counter.worker.service.console_warn
   * Whether a service worker called called console.warn. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_warn(3603);

  /**
   * generated from use.counter.worker.service.cookiestore_delete
   * Whether a service worker called called CookieStore.delete. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_delete(3604);

  /**
   * generated from use.counter.worker.service.cookiestore_get
   * Whether a service worker called called CookieStore.get. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_get(3605);

  /**
   * generated from use.counter.worker.service.cookiestore_getall
   * Whether a service worker called called CookieStore.getAll. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_getall(3606);

  /**
   * generated from use.counter.worker.service.cookiestore_set
   * Whether a service worker called called CookieStore.set. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_set(3607);

  /**
   * generated from use.counter.worker.service.mls_deriveexporter
   * Whether a service worker called called MLS.deriveExporter. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_deriveexporter(3608);

  /**
   * generated from use.counter.worker.service.mls_generatecredentialbasic
   * Whether a service worker called called MLS.generateCredentialBasic. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatecredentialbasic(3609);

  /**
   * generated from use.counter.worker.service.mls_generatekeypackage
   * Whether a service worker called called MLS.generateKeyPackage. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatekeypackage(3610);

  /**
   * generated from use.counter.worker.service.mls_generatesignaturekeypair
   * Whether a service worker called called MLS.generateSignatureKeypair. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatesignaturekeypair(3611);

  /**
   * generated from use.counter.worker.service.mls_groupadd
   * Whether a service worker called called MLS.groupAdd. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupadd(3612);

  /**
   * generated from use.counter.worker.service.mls_groupclose
   * Whether a service worker called called MLS.groupClose. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupclose(3613);

  /**
   * generated from use.counter.worker.service.mls_groupcreate
   * Whether a service worker called called MLS.groupCreate. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupcreate(3614);

  /**
   * generated from use.counter.worker.service.mls_groupjoin
   * Whether a service worker called called MLS.groupJoin. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupjoin(3615);

  /**
   * generated from use.counter.worker.service.mls_groupmembers
   * Whether a service worker called called MLS.groupMembers. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupmembers(3616);

  /**
   * generated from use.counter.worker.service.mls_groupproposeadd
   * Whether a service worker called called MLS.groupProposeAdd. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupproposeadd(3617);

  /**
   * generated from use.counter.worker.service.mls_groupproposeremove
   * Whether a service worker called called MLS.groupProposeRemove. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupproposeremove(3618);

  /**
   * generated from use.counter.worker.service.mls_groupremove
   * Whether a service worker called called MLS.groupRemove. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupremove(3619);

  /**
   * generated from use.counter.worker.service.mls_receive
   * Whether a service worker called called MLS.receive. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_receive(3620);

  /**
   * generated from use.counter.worker.service.mls_send
   * Whether a service worker called called MLS.send. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_send(3621);

  /**
   * generated from use.counter.worker.service.mls_statedelete
   * Whether a service worker called called MLS.stateDelete. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_statedelete(3622);

  /**
   * generated from use.counter.worker.service.mls_statedeletegroup
   * Whether a service worker called called MLS.stateDeleteGroup. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_statedeletegroup(3623);

  /**
   * generated from use.counter.worker.service.notificationoptions_actions
   * Whether a service worker called called NotificationOptions.actions. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_actions(3624);

  /**
   * generated from use.counter.worker.service.notificationoptions_badge
   * Whether a service worker called called NotificationOptions.badge. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_badge(3625);

  /**
   * generated from use.counter.worker.service.notificationoptions_image
   * Whether a service worker called called NotificationOptions.image. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_image(3626);

  /**
   * generated from use.counter.worker.service.notificationoptions_navigate
   * Whether a service worker called called NotificationOptions.navigate. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_navigate(3627);

  /**
   * generated from use.counter.worker.service.notificationoptions_renotify
   * Whether a service worker called called NotificationOptions.renotify. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_renotify(3628);

  /**
   * generated from use.counter.worker.service.notificationoptions_requireinteraction
   * Whether a service worker called called NotificationOptions.requireInteraction. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_requireinteraction(3629);

  /**
   * generated from use.counter.worker.service.notificationoptions_timestamp
   * Whether a service worker called called NotificationOptions.timestamp. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_timestamp(3630);

  /**
   * generated from use.counter.worker.service.notificationoptions_vibrate
   * Whether a service worker called called NotificationOptions.vibrate. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_vibrate(3631);

  /**
   * generated from use.counter.worker.service.private_browsing_caches_delete
   * Whether a service worker calls caches.delete in Private Browsing Mode. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_delete(3632);

  /**
   * generated from use.counter.worker.service.private_browsing_caches_has
   * Whether a service worker calls caches.has in Private Browsing Mode. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_has(3633);

  /**
   * generated from use.counter.worker.service.private_browsing_caches_keys
   * Whether a service worker calls caches.keys in Private Browsing Mode. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_keys(3634);

  /**
   * generated from use.counter.worker.service.private_browsing_caches_match
   * Whether a service worker calls caches.match in Private Browsing Mode. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_match(3635);

  /**
   * generated from use.counter.worker.service.private_browsing_caches_open
   * Whether a service worker calls caches.open in Private Browsing Mode. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_open(3636);

  /**
   * generated from use.counter.worker.service.private_browsing_idbfactory_delete_database
   * Whether a service worker calls indexedDB.deleteDatabase in Private Browsing Mode. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_idbfactory_delete_database(3637);

  /**
   * generated from use.counter.worker.service.private_browsing_idbfactory_open
   * Whether a service worker calls indexedDB.open in Private Browsing Mode. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_idbfactory_open(3638);

  /**
   * generated from use.counter.worker.service.pushmanager_subscribe
   * Whether a service worker called called PushManager.subscribe. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pushmanager_subscribe(3639);

  /**
   * generated from use.counter.worker.service.pushsubscription_unsubscribe
   * Whether a service worker called called PushSubscription.unsubscribe. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pushsubscription_unsubscribe(3640);

  /**
   * generated from use.counter.worker.service.scheduler_posttask
   * Whether a service worker called called Scheduler.postTask. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> scheduler_posttask(3641);

  /**
   * generated from use.counter.worker.service.webgpu_request_adapter
   * Whether a service worker requests a WebGPU adapter. Compare against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webgpu_request_adapter(3642);
}

namespace use_counter_worker_shared {
  /**
   * generated from use.counter.worker.shared.console_assert
   * Whether a shared worker called called console.assert. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_assert(3643);

  /**
   * generated from use.counter.worker.shared.console_clear
   * Whether a shared worker called called console.clear. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_clear(3644);

  /**
   * generated from use.counter.worker.shared.console_count
   * Whether a shared worker called called console.count. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_count(3645);

  /**
   * generated from use.counter.worker.shared.console_countreset
   * Whether a shared worker called called console.countReset. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_countreset(3646);

  /**
   * generated from use.counter.worker.shared.console_debug
   * Whether a shared worker called called console.debug. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_debug(3647);

  /**
   * generated from use.counter.worker.shared.console_dir
   * Whether a shared worker called called console.dir. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_dir(3648);

  /**
   * generated from use.counter.worker.shared.console_dirxml
   * Whether a shared worker called called console.dirxml. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_dirxml(3649);

  /**
   * generated from use.counter.worker.shared.console_error
   * Whether a shared worker called called console.error. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_error(3650);

  /**
   * generated from use.counter.worker.shared.console_exception
   * Whether a shared worker called called console.exception. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_exception(3651);

  /**
   * generated from use.counter.worker.shared.console_group
   * Whether a shared worker called called console.group. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_group(3652);

  /**
   * generated from use.counter.worker.shared.console_groupcollapsed
   * Whether a shared worker called called console.groupCollapsed. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_groupcollapsed(3653);

  /**
   * generated from use.counter.worker.shared.console_groupend
   * Whether a shared worker called called console.groupEnd. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_groupend(3654);

  /**
   * generated from use.counter.worker.shared.console_info
   * Whether a shared worker called called console.info. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_info(3655);

  /**
   * generated from use.counter.worker.shared.console_log
   * Whether a shared worker called called console.log. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_log(3656);

  /**
   * generated from use.counter.worker.shared.console_profile
   * Whether a shared worker called called console.profile. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_profile(3657);

  /**
   * generated from use.counter.worker.shared.console_profileend
   * Whether a shared worker called called console.profileEnd. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_profileend(3658);

  /**
   * generated from use.counter.worker.shared.console_table
   * Whether a shared worker called called console.table. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_table(3659);

  /**
   * generated from use.counter.worker.shared.console_time
   * Whether a shared worker called called console.time. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_time(3660);

  /**
   * generated from use.counter.worker.shared.console_timeend
   * Whether a shared worker called called console.timeEnd. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timeend(3661);

  /**
   * generated from use.counter.worker.shared.console_timelog
   * Whether a shared worker called called console.timeLog. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timelog(3662);

  /**
   * generated from use.counter.worker.shared.console_timestamp
   * Whether a shared worker called called console.timeStamp. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_timestamp(3663);

  /**
   * generated from use.counter.worker.shared.console_trace
   * Whether a shared worker called called console.trace. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_trace(3664);

  /**
   * generated from use.counter.worker.shared.console_warn
   * Whether a shared worker called called console.warn. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> console_warn(3665);

  /**
   * generated from use.counter.worker.shared.cookiestore_delete
   * Whether a shared worker called called CookieStore.delete. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_delete(3666);

  /**
   * generated from use.counter.worker.shared.cookiestore_get
   * Whether a shared worker called called CookieStore.get. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_get(3667);

  /**
   * generated from use.counter.worker.shared.cookiestore_getall
   * Whether a shared worker called called CookieStore.getAll. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_getall(3668);

  /**
   * generated from use.counter.worker.shared.cookiestore_set
   * Whether a shared worker called called CookieStore.set. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cookiestore_set(3669);

  /**
   * generated from use.counter.worker.shared.mls_deriveexporter
   * Whether a shared worker called called MLS.deriveExporter. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_deriveexporter(3670);

  /**
   * generated from use.counter.worker.shared.mls_generatecredentialbasic
   * Whether a shared worker called called MLS.generateCredentialBasic. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatecredentialbasic(3671);

  /**
   * generated from use.counter.worker.shared.mls_generatekeypackage
   * Whether a shared worker called called MLS.generateKeyPackage. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatekeypackage(3672);

  /**
   * generated from use.counter.worker.shared.mls_generatesignaturekeypair
   * Whether a shared worker called called MLS.generateSignatureKeypair. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_generatesignaturekeypair(3673);

  /**
   * generated from use.counter.worker.shared.mls_groupadd
   * Whether a shared worker called called MLS.groupAdd. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupadd(3674);

  /**
   * generated from use.counter.worker.shared.mls_groupclose
   * Whether a shared worker called called MLS.groupClose. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupclose(3675);

  /**
   * generated from use.counter.worker.shared.mls_groupcreate
   * Whether a shared worker called called MLS.groupCreate. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupcreate(3676);

  /**
   * generated from use.counter.worker.shared.mls_groupjoin
   * Whether a shared worker called called MLS.groupJoin. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupjoin(3677);

  /**
   * generated from use.counter.worker.shared.mls_groupmembers
   * Whether a shared worker called called MLS.groupMembers. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupmembers(3678);

  /**
   * generated from use.counter.worker.shared.mls_groupproposeadd
   * Whether a shared worker called called MLS.groupProposeAdd. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupproposeadd(3679);

  /**
   * generated from use.counter.worker.shared.mls_groupproposeremove
   * Whether a shared worker called called MLS.groupProposeRemove. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupproposeremove(3680);

  /**
   * generated from use.counter.worker.shared.mls_groupremove
   * Whether a shared worker called called MLS.groupRemove. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_groupremove(3681);

  /**
   * generated from use.counter.worker.shared.mls_receive
   * Whether a shared worker called called MLS.receive. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_receive(3682);

  /**
   * generated from use.counter.worker.shared.mls_send
   * Whether a shared worker called called MLS.send. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_send(3683);

  /**
   * generated from use.counter.worker.shared.mls_statedelete
   * Whether a shared worker called called MLS.stateDelete. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_statedelete(3684);

  /**
   * generated from use.counter.worker.shared.mls_statedeletegroup
   * Whether a shared worker called called MLS.stateDeleteGroup. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mls_statedeletegroup(3685);

  /**
   * generated from use.counter.worker.shared.notificationoptions_actions
   * Whether a shared worker called called NotificationOptions.actions. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_actions(3686);

  /**
   * generated from use.counter.worker.shared.notificationoptions_badge
   * Whether a shared worker called called NotificationOptions.badge. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_badge(3687);

  /**
   * generated from use.counter.worker.shared.notificationoptions_image
   * Whether a shared worker called called NotificationOptions.image. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_image(3688);

  /**
   * generated from use.counter.worker.shared.notificationoptions_navigate
   * Whether a shared worker called called NotificationOptions.navigate. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_navigate(3689);

  /**
   * generated from use.counter.worker.shared.notificationoptions_renotify
   * Whether a shared worker called called NotificationOptions.renotify. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_renotify(3690);

  /**
   * generated from use.counter.worker.shared.notificationoptions_requireinteraction
   * Whether a shared worker called called NotificationOptions.requireInteraction. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_requireinteraction(3691);

  /**
   * generated from use.counter.worker.shared.notificationoptions_timestamp
   * Whether a shared worker called called NotificationOptions.timestamp. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_timestamp(3692);

  /**
   * generated from use.counter.worker.shared.notificationoptions_vibrate
   * Whether a shared worker called called NotificationOptions.vibrate. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> notificationoptions_vibrate(3693);

  /**
   * generated from use.counter.worker.shared.private_browsing_caches_delete
   * Whether a shared worker calls caches.delete in Private Browsing Mode. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_delete(3694);

  /**
   * generated from use.counter.worker.shared.private_browsing_caches_has
   * Whether a shared worker calls caches.has in Private Browsing Mode. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_has(3695);

  /**
   * generated from use.counter.worker.shared.private_browsing_caches_keys
   * Whether a shared worker calls caches.keys in Private Browsing Mode. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_keys(3696);

  /**
   * generated from use.counter.worker.shared.private_browsing_caches_match
   * Whether a shared worker calls caches.match in Private Browsing Mode. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_match(3697);

  /**
   * generated from use.counter.worker.shared.private_browsing_caches_open
   * Whether a shared worker calls caches.open in Private Browsing Mode. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_caches_open(3698);

  /**
   * generated from use.counter.worker.shared.private_browsing_idbfactory_delete_database
   * Whether a shared worker calls indexedDB.deleteDatabase in Private Browsing Mode. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_idbfactory_delete_database(3699);

  /**
   * generated from use.counter.worker.shared.private_browsing_idbfactory_open
   * Whether a shared worker calls indexedDB.open in Private Browsing Mode. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> private_browsing_idbfactory_open(3700);

  /**
   * generated from use.counter.worker.shared.pushmanager_subscribe
   * Whether a shared worker called called PushManager.subscribe. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pushmanager_subscribe(3701);

  /**
   * generated from use.counter.worker.shared.pushsubscription_unsubscribe
   * Whether a shared worker called called PushSubscription.unsubscribe. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pushsubscription_unsubscribe(3702);

  /**
   * generated from use.counter.worker.shared.scheduler_posttask
   * Whether a shared worker called called Scheduler.postTask. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> scheduler_posttask(3703);

  /**
   * generated from use.counter.worker.shared.webgpu_request_adapter
   * Whether a shared worker requests a WebGPU adapter. Compare against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> webgpu_request_adapter(3704);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomUseCounterMetrics_h
